/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Utils;

public final class ApiKeyProvider {
    private static final Map<String, String> CACHE = new HashMap<String, String>();

    private ApiKeyProvider() {
    }

    private static List<String> getApiKeySites() {
        return Preferences.main().getList("apikey.sites", Collections.singletonList(Config.getUrls().getJOSMWebsite() + "/mapkey/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String retrieveApiKey(String imageryId) throws IOException {
        if (CACHE.containsKey(imageryId)) {
            return CACHE.get(imageryId);
        }
        for (String siteUrl : ApiKeyProvider.getApiKeySites()) {
            HttpClient.Response response = HttpClient.create(new URL(siteUrl + imageryId)).connect();
            try {
                if (response.getResponseCode() != 200) continue;
                String key = Utils.strip(response.fetchContent());
                CACHE.put(imageryId, key);
                String string = key;
                return string;
            }
            finally {
                response.disconnect();
            }
        }
        return null;
    }
}

