/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class RenderingHelper {
    private final DataSet ds;
    private final Bounds bounds;
    private final ProjectionBounds projBounds;
    private final double scale;
    private final Collection<StyleData> styles;
    private Color backgroundColor;
    private boolean fillBackground = true;
    private PrintStream debugStream;

    public RenderingHelper(DataSet ds, Bounds bounds, double scale, Collection<StyleData> styles) {
        CheckParameterUtil.ensureParameterNotNull(ds, "ds");
        CheckParameterUtil.ensureParameterNotNull(bounds, "bounds");
        CheckParameterUtil.ensureParameterNotNull(styles, "styles");
        this.ds = ds;
        this.bounds = bounds;
        this.scale = scale;
        this.styles = styles;
        Projection proj = ProjectionRegistry.getProjection();
        this.projBounds = new ProjectionBounds();
        this.projBounds.extend(proj.latlon2eastNorth(bounds.getMin()));
        this.projBounds.extend(proj.latlon2eastNorth(bounds.getMax()));
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setFillBackground(boolean fillBackground) {
        this.fillBackground = fillBackground;
    }

    Dimension getImageSize() {
        double widthEn = this.projBounds.maxEast - this.projBounds.minEast;
        double heightEn = this.projBounds.maxNorth - this.projBounds.minNorth;
        int widthPx = (int)Math.round(widthEn / this.scale);
        int heightPx = (int)Math.round(heightEn / this.scale);
        return new Dimension(widthPx, heightPx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage render() throws IOException, IllegalDataException {
        ElemStyles elemStyles = new ElemStyles();
        MapCSSStyleSource.STYLE_SOURCE_LOCK.writeLock().lock();
        try {
            for (StyleData sd : this.styles) {
                MapCSSStyleSource source = new MapCSSStyleSource(sd.styleUrl, "cliRenderingStyle", "cli rendering style '" + sd.styleUrl + "'");
                source.loadStyleSource();
                elemStyles.add(source);
                if (!source.getErrors().isEmpty()) {
                    throw new IllegalDataException("Failed to load style file. Errors: " + String.valueOf(source.getErrors()));
                }
                for (String key : sd.settings.keySet()) {
                    StyleSetting.PropertyStyleSetting match = source.settings.stream().filter(s -> s instanceof StyleSetting.PropertyStyleSetting).map(s -> (StyleSetting.PropertyStyleSetting)s).filter(bs -> bs.getKey().endsWith(":" + key)).findFirst().orElse(null);
                    if (match == null) {
                        Logging.warn(I18n.tr("Style setting not found: ''{0}''", key));
                        continue;
                    }
                    String value = sd.settings.get(key);
                    Logging.trace("setting applied: ''{0}:{1}''", key, value);
                    match.setStringValue(value);
                }
                if (sd.settings.isEmpty()) continue;
                source.loadStyleSource();
            }
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.writeLock().unlock();
        }
        final Dimension imgDimPx = this.getImageSize();
        NavigatableComponent nc = new NavigatableComponent(this){
            final /* synthetic */ RenderingHelper this$0;
            {
                this.this$0 = this$0;
                this.setBounds(0, 0, imgDimPx.width, imgDimPx.height);
                this.updateLocationState();
            }

            @Override
            protected boolean isVisibleOnScreen() {
                return true;
            }

            @Override
            public Point getLocationOnScreen() {
                return new Point(0, 0);
            }
        };
        nc.zoomTo(this.projBounds.getCenter(), this.scale);
        BufferedImage image = new BufferedImage(imgDimPx.width, imgDimPx.height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.fillBackground) {
            g.setColor(Optional.ofNullable(this.backgroundColor).orElse(elemStyles.getBackgroundColor()));
            g.fillRect(0, 0, imgDimPx.width, imgDimPx.height);
        }
        StyledMapRenderer smr = new StyledMapRenderer(g, nc, false);
        smr.setStyles(elemStyles);
        smr.render(this.ds, false, this.bounds);
        if (this.debugStream != null) {
            for (OsmPrimitive primitive : this.ds.allPrimitives()) {
                if (!primitive.isKeyTrue("debug")) continue;
                this.debugStream.println(primitive);
                for (StyleElement styleElement : elemStyles.get(primitive, this.scale, nc)) {
                    this.debugStream.append(" * ").println(styleElement);
                }
            }
        }
        return image;
    }

    void setDebugStream(PrintStream debugStream) {
        this.debugStream = debugStream;
    }

    public static class StyleData {
        public String styleUrl;
        public Map<String, String> settings = new HashMap<String, String>();
    }
}

