/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @file  ap_config_layout.h
 * @brief Apache Config Layout
 */

#ifndef AP_CONFIG_LAYOUT_H
#define AP_CONFIG_LAYOUT_H

/* Configured Apache directory layout */
#define DEFAULT_PREFIX "/opt/local"
#define DEFAULT_EXP_EXEC_PREFIX "/opt/local"
#define DEFAULT_REL_EXEC_PREFIX ""
#define DEFAULT_EXP_BINDIR "/opt/local/bin"
#define DEFAULT_REL_BINDIR "bin"
#define DEFAULT_EXP_SBINDIR "/opt/local/sbin"
#define DEFAULT_REL_SBINDIR "sbin"
#define DEFAULT_EXP_LIBEXECDIR "/opt/local/lib/apache2/modules"
#define DEFAULT_REL_LIBEXECDIR "lib/apache2/modules"
#define DEFAULT_EXP_MANDIR "/opt/local/share/apache2"
#define DEFAULT_REL_MANDIR "share/apache2"
#define DEFAULT_EXP_SYSCONFDIR "/opt/local/etc/apache2"
#define DEFAULT_REL_SYSCONFDIR "etc/apache2"
#define DEFAULT_EXP_DATADIR "/opt/local/www/apache2"
#define DEFAULT_REL_DATADIR "www/apache2"
#define DEFAULT_EXP_INSTALLBUILDDIR "/opt/local/www/apache2/build"
#define DEFAULT_REL_INSTALLBUILDDIR "www/apache2/build"
#define DEFAULT_EXP_ERRORDIR "/opt/local/www/apache2/error"
#define DEFAULT_REL_ERRORDIR "www/apache2/error"
#define DEFAULT_EXP_ICONSDIR "/opt/local/www/apache2/icons"
#define DEFAULT_REL_ICONSDIR "www/apache2/icons"
#define DEFAULT_EXP_HTDOCSDIR "/opt/local/www/apache2/html"
#define DEFAULT_REL_HTDOCSDIR "www/apache2/html"
#define DEFAULT_EXP_MANUALDIR "/opt/local/www/apache2/manual"
#define DEFAULT_REL_MANUALDIR "www/apache2/manual"
#define DEFAULT_EXP_CGIDIR "/opt/local/www/apache2/cgi-bin"
#define DEFAULT_REL_CGIDIR "www/apache2/cgi-bin"
#define DEFAULT_EXP_INCLUDEDIR "/opt/local/include/apache2"
#define DEFAULT_REL_INCLUDEDIR "include/apache2"
#define DEFAULT_EXP_LOCALSTATEDIR "/opt/local/var"
#define DEFAULT_REL_LOCALSTATEDIR "var"
#define DEFAULT_EXP_RUNTIMEDIR "/opt/local/var/run/apache2"
#define DEFAULT_REL_RUNTIMEDIR "var/run/apache2"
#define DEFAULT_EXP_LOGFILEDIR "/opt/local/var/log/apache2"
#define DEFAULT_REL_LOGFILEDIR "var/log/apache2"
#define DEFAULT_EXP_PROXYCACHEDIR "/opt/local/var/tmp/apache2"
#define DEFAULT_REL_PROXYCACHEDIR "var/tmp/apache2"

#endif /* AP_CONFIG_LAYOUT_H */
