/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedOdexFile;
import com.android.tools.smali.dexlib2.dexbacked.OatFile;
import com.android.tools.smali.util.jcommander.Command;
import com.android.tools.smali.util.jcommander.ExtendedParameter;
import com.android.tools.smali.util.jcommander.ExtendedParameters;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

@Parameters(commandDescription="Lists the stored dependencies in an odex/oat file.")
@ExtendedParameters(commandName="dependencies", commandAliases={"deps", "dep"})
public class ListDependenciesCommand
extends Command {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information")
    private boolean help;
    @Parameter(description="An oat/odex file")
    @ExtendedParameter(argumentNames={"file"})
    private List<String> inputList = Lists.newArrayList();

    public ListDependenciesCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    @Override
    public void run() {
        if (this.help || this.inputList == null || this.inputList.isEmpty()) {
            this.usage();
            return;
        }
        if (this.inputList.size() > 1) {
            System.err.println("Too many files specified");
            this.usage();
            return;
        }
        String input = this.inputList.get(0);
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(input));
        }
        catch (FileNotFoundException ex) {
            System.err.println("Could not find file: " + input);
            System.exit(-1);
        }
        try {
            OatFile oatFile = OatFile.fromInputStream(inputStream);
            for (String entry : oatFile.getBootClassPath()) {
                System.out.println(entry);
            }
            return;
        }
        catch (OatFile.NotAnOatFileException oatFile) {
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            DexBackedOdexFile odexFile = DexBackedOdexFile.fromInputStream(Opcodes.getDefault(), inputStream);
            for (String entry : odexFile.getDependencies()) {
                System.out.println(entry);
            }
            return;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (DexBackedOdexFile.NotAnOdexFile notAnOdexFile) {
        }
        catch (DexBackedDexFile.NotADexFile notADexFile) {
            // empty catch block
        }
        System.err.println(input + " is not an odex or oat file.");
        System.exit(-1);
    }
}

