/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.meta.ApkInfo;
import brut.androlib.meta.PackageInfo;
import brut.androlib.meta.SdkInfo;
import brut.androlib.meta.VersionInfo;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.AndroidManifestPullStreamDecoder;
import brut.androlib.res.decoder.AndroidManifestResourceParser;
import brut.androlib.res.decoder.Res9patchStreamDecoder;
import brut.androlib.res.decoder.ResFileDecoder;
import brut.androlib.res.decoder.ResRawStreamDecoder;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.androlib.res.decoder.ResXmlPullStreamDecoder;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.androlib.res.xml.ResXmlUtils;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.xmlpull.MXSerializer;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlSerializer;

public class ResourcesDecoder {
    private static final Logger LOGGER = Logger.getLogger(ResourcesDecoder.class.getName());
    private static final Set<String> IGNORED_PACKAGES = Sets.newHashSet("android", "com.htc", "com.lge", "com.lge.internal", "yi", "flyme", "air.com.adobe.appentry", "FFFFFFFFFFFFFFFFFFFFFF");
    private final ApkInfo mApkInfo;
    private final Config mConfig;
    private final ResTable mResTable;
    private final Map<String, String> mResFileMapping;

    public ResourcesDecoder(ApkInfo apkInfo, Config config) {
        this.mApkInfo = apkInfo;
        this.mConfig = config;
        this.mResTable = new ResTable(apkInfo, config);
        this.mResFileMapping = new HashMap<String, String>();
    }

    public ResTable getResTable() throws AndrolibException {
        if (!this.mApkInfo.hasManifest() && !this.mApkInfo.hasResources()) {
            throw new AndrolibException("Apk doesn't contain either AndroidManifest.xml file or resources.arsc file");
        }
        return this.mResTable;
    }

    public Map<String, String> getResFileMapping() {
        return this.mResFileMapping;
    }

    public void decodeResources(File apkDir) throws AndrolibException {
        Directory outDir;
        Directory inDir;
        if (!this.mApkInfo.hasResources()) {
            return;
        }
        this.mResTable.loadMainPackage();
        ResStreamDecoderContainer decoders = new ResStreamDecoderContainer();
        decoders.setDecoder("raw", new ResRawStreamDecoder());
        decoders.setDecoder("9patch", new Res9patchStreamDecoder());
        AXmlResourceParser axmlParser = new AXmlResourceParser(this.mResTable);
        XmlSerializer xmlSerializer = this.newXmlSerializer();
        decoders.setDecoder("xml", new ResXmlPullStreamDecoder(axmlParser, xmlSerializer));
        ResFileDecoder fileDecoder = new ResFileDecoder(decoders);
        try {
            inDir = this.mApkInfo.getApkFile().getDirectory();
            outDir = new ExtFile(apkDir).getDirectory().createDir("res");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        ResPackage pkg = this.mResTable.getMainPackage();
        LOGGER.info("Decoding file-resources...");
        for (ResResource res : pkg.listFiles()) {
            fileDecoder.decode(res, inDir, outDir, this.mResFileMapping);
        }
        LOGGER.info("Decoding values */* XMLs...");
        for (ResValuesFile valuesFile : pkg.listValuesFiles()) {
            this.generateValuesFile(valuesFile, outDir, xmlSerializer);
        }
        this.generatePublicXml(pkg, outDir, xmlSerializer);
        AndrolibException decodeError = axmlParser.getFirstError();
        if (decodeError != null) {
            throw decodeError;
        }
    }

    private XmlSerializer newXmlSerializer() throws AndrolibException {
        try {
            MXSerializer serial = new MXSerializer();
            serial.setFeature("http://xmlpull.org/v1/doc/features.html#attr-value-no-escape", true);
            serial.setProperty("http://xmlpull.org/v1/doc/properties.html#default-encoding", "utf-8");
            serial.setProperty("http://xmlpull.org/v1/doc/properties.html#indentation", "    ");
            serial.setProperty("http://xmlpull.org/v1/doc/properties.html#line-separator", System.getProperty("line.separator"));
            return serial;
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void generateValuesFile(ResValuesFile valuesFile, Directory resDir, XmlSerializer serial) throws AndrolibException {
        try (OutputStream out = resDir.getFileOutput(valuesFile.getPath());){
            serial.setOutput(out, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResResource res : valuesFile.listResources()) {
                if (valuesFile.isSynthesized(res)) continue;
                ((ResValuesXmlSerializable)((Object)res.getValue())).serializeToResValuesXml(serial, res);
            }
            serial.endTag(null, "resources");
            serial.endDocument();
            serial.flush();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate: " + valuesFile.getPath(), ex);
        }
    }

    private void generatePublicXml(ResPackage pkg, Directory resDir, XmlSerializer serial) throws AndrolibException {
        try (OutputStream out = resDir.getFileOutput("values/public.xml");){
            serial.setOutput(out, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            List<ResResSpec> specs = pkg.listResSpecs();
            specs.sort(Comparator.comparing(ResResSpec::getId));
            for (ResResSpec spec : specs) {
                serial.startTag(null, "public");
                serial.attribute(null, "type", spec.getType().getName());
                serial.attribute(null, "name", spec.getName());
                serial.attribute(null, "id", spec.getId().toString());
                serial.endTag(null, "public");
            }
            serial.endTag(null, "resources");
            serial.endDocument();
            serial.flush();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate public.xml file", ex);
        }
    }

    public void decodeManifest(File apkDir) throws AndrolibException {
        String[] flags;
        if (!this.mApkInfo.hasManifest()) {
            return;
        }
        AndroidManifestResourceParser axmlParser = new AndroidManifestResourceParser(this.mResTable);
        XmlSerializer xmlSerializer = this.newXmlSerializer();
        AndroidManifestPullStreamDecoder fileDecoder = new AndroidManifestPullStreamDecoder(axmlParser, xmlSerializer);
        try {
            Directory inDir = this.mApkInfo.getApkFile().getDirectory();
            Directory outDir = new ExtFile(apkDir).getDirectory();
            if (this.mResTable.isMainPackageLoaded()) {
                LOGGER.info("Decoding AndroidManifest.xml with resources...");
            } else {
                LOGGER.info("Decoding AndroidManifest.xml with only framework resources...");
            }
            try (InputStream in = inDir.getFileInput("AndroidManifest.xml");
                 OutputStream out = outDir.getFileOutput("AndroidManifest.xml");){
                fileDecoder.decode(in, out);
            }
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
        File manifest = new File(apkDir, "AndroidManifest.xml");
        if (this.mResTable.isMainPackageLoaded()) {
            String versionName;
            VersionInfo versionInfo;
            String refValue;
            this.mResTable.updateApkInfo();
            SdkInfo sdkInfo = this.mApkInfo.getSdkInfo();
            if (!sdkInfo.isEmpty()) {
                String refValue2;
                String maxSdkVersion;
                String targetSdkVersion;
                String refValue3;
                String minSdkVersion = sdkInfo.getMinSdkVersion();
                if (minSdkVersion != null && (refValue3 = ResXmlUtils.pullValueFromIntegers(apkDir, minSdkVersion)) != null) {
                    sdkInfo.setMinSdkVersion(refValue3);
                }
                if ((targetSdkVersion = sdkInfo.getTargetSdkVersion()) != null && (refValue = ResXmlUtils.pullValueFromIntegers(apkDir, targetSdkVersion)) != null) {
                    sdkInfo.setTargetSdkVersion(refValue);
                }
                if ((maxSdkVersion = sdkInfo.getMaxSdkVersion()) != null && (refValue2 = ResXmlUtils.pullValueFromIntegers(apkDir, maxSdkVersion)) != null) {
                    sdkInfo.setMaxSdkVersion(refValue2);
                }
            }
            if (!(versionInfo = this.mApkInfo.getVersionInfo()).isEmpty() && (versionName = versionInfo.getVersionName()) != null && (refValue = ResXmlUtils.pullValueFromStrings(apkDir, versionName)) != null) {
                versionInfo.setVersionName(refValue);
            }
            if (!this.mConfig.isAnalysisMode()) {
                PackageInfo packageInfo = this.mApkInfo.getPackageInfo();
                String manifestPackage = packageInfo.getRenameManifestPackage();
                String mainResPackage = this.mResTable.getMainPackage().getName();
                if (mainResPackage != null && !mainResPackage.equals(manifestPackage) && !IGNORED_PACKAGES.contains(mainResPackage)) {
                    LOGGER.info("Renaming manifest package from " + manifestPackage + " to " + mainResPackage + "...");
                    ResXmlUtils.renameManifestPackage(manifest, mainResPackage);
                } else {
                    packageInfo.setRenameManifestPackage(null);
                }
            }
        } else {
            this.mApkInfo.getPackageInfo().setRenameManifestPackage(null);
        }
        if (!this.mConfig.isAnalysisMode()) {
            ResXmlUtils.removeManifestVersions(manifest);
        }
        if ((flags = ResXmlUtils.pullManifestFeatureFlags(manifest)) != null) {
            Map<String, Boolean> featureFlags = this.mApkInfo.getFeatureFlags();
            for (String flag : flags) {
                featureFlags.put(flag, true);
            }
        }
    }
}

