/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;

public final class Extensions {
    private Extensions() {
    }

    public static <T> Constructor<T> findConstructorWithMostMatchingArguments(Class<T> clazz, Object ... args) {
        int numberOfMatchingArguments = -1;
        Constructor<?> bestConstructor = null;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            int currentNumberOfArguments = constructor.getParameterTypes().length;
            if (currentNumberOfArguments <= numberOfMatchingArguments || !Extensions.isConstructorCandidate(constructor, args)) continue;
            numberOfMatchingArguments = currentNumberOfArguments;
            bestConstructor = constructor;
        }
        if (bestConstructor != null) {
            return bestConstructor;
        }
        ArrayList expectedTypes = new ArrayList(args.length);
        for (Object arg : args) {
            if (arg == null) {
                expectedTypes.add(Void.class);
                continue;
            }
            expectedTypes.add(arg.getClass());
        }
        throw new IllegalArgumentException("Extension class " + clazz.getName() + " does not provide a constructor accepting " + String.valueOf(expectedTypes));
    }

    private static boolean isConstructorCandidate(Constructor<?> constructor, Object ... args) {
        if (constructor.getParameterTypes().length > args.length) {
            return false;
        }
        Class<?>[] constructorParameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < constructorParameterTypes.length; ++i) {
            if (args[i] == null || constructorParameterTypes[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }
}

