/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.prof;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.item.XQStruct;
import org.basex.util.Util;

public final class ProfType
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Expr expr = this.arg(0);
        String label = this.toStringOrNull(this.arg(1), qc);
        Value value = expr.value(qc);
        qc.trace(label, () -> {
            StringBuilder sb = new StringBuilder().append(ProfType.info(expr));
            if (expr != value) {
                sb.append(" -> ").append(ProfType.info(value));
            }
            return sb.toString();
        });
        return value;
    }

    private static String info(Expr expr) {
        long l;
        Class<?> clazz = expr.getClass();
        String string = expr.seqType().toString();
        if (expr instanceof XQStruct) {
            XQStruct struct = (XQStruct)expr;
            l = struct.structSize();
        } else {
            l = expr.size();
        }
        return new TypeInfo(clazz, string, l).toString();
    }

    public record TypeInfo(Class<?> clazz, String type, long size) {
        @Override
        public String toString() {
            String info = Util.className(this.clazz) + " (" + this.type;
            if (XQStruct.class.isAssignableFrom(this.clazz)) {
                info = info + ", " + this.size + " " + (this.size == 1L ? "entry" : "entries");
            } else if (this.size > 1L) {
                info = info + ", " + this.size + " items";
            }
            return info + ")";
        }
    }
}

