/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import org.basex.io.in.DataInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.path.Test;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class ChoiceItemType
implements Type {
    public final List<SeqType> types;
    private final Type union;
    private EnumMap<Occ, SeqType> seqTypes;

    public ChoiceItemType(List<SeqType> types) {
        if (types.contains(Types.ERROR_O)) {
            ArrayList<SeqType> list = new ArrayList<SeqType>(types);
            while (list.remove(Types.ERROR_O)) {
            }
            this.types = list.isEmpty() ? types : list;
        } else {
            this.types = types;
        }
        Type tp = null;
        for (SeqType st : this.types) {
            tp = tp == null ? st.type : tp.union(st.type);
        }
        this.union = tp;
    }

    public static ChoiceItemType get(SeqType ... types) {
        return new ChoiceItemType(Arrays.asList(types));
    }

    @Override
    public Value cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
        for (SeqType st : this.types) {
            Value val = st.cast((Value)item, false, qc, info);
            if (val == null) continue;
            return val;
        }
        throw QueryError.FUNCCAST_X_X_X.get(info, item.type, this, item);
    }

    @Override
    public Value cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
        for (SeqType st : this.types) {
            try {
                return st.type.cast(value, qc, info);
            }
            catch (QueryException ex) {
                Util.debug(ex);
            }
        }
        throw QueryError.FUNCCAST_X_X.get(info, this, value);
    }

    @Override
    public Item read(DataInput in, QueryContext qc) {
        throw Util.notExpected();
    }

    @Override
    public SeqType seqType(Occ occ) {
        if (this.seqTypes == null) {
            this.seqTypes = new EnumMap(Occ.class);
        }
        return this.seqTypes.computeIfAbsent(occ, o -> new SeqType(this, (Occ)((Object)o)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean eq(Type type) {
        if (this == type) return true;
        if (!(type instanceof ChoiceItemType)) return false;
        ChoiceItemType cit = (ChoiceItemType)type;
        if (!this.types.equals(cit.types)) return false;
        return true;
    }

    public boolean instanceOf(SeqType seqType) {
        if (!seqType.one()) {
            throw Util.notExpected();
        }
        for (SeqType st : this.types) {
            if (st.instanceOf(seqType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean instanceOf(Type type) {
        for (SeqType st : this.types) {
            if (st.type.instanceOf(type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type union(Type type) {
        return this.union.union(type);
    }

    @Override
    public Type intersect(Type type) {
        ArrayList<SeqType> list = new ArrayList<SeqType>();
        for (SeqType st : this.types) {
            Type tp = type.intersect(st.type);
            if (tp == null) continue;
            list.add(tp.seqType());
        }
        return switch (list.size()) {
            case 0 -> null;
            case 1 -> ((SeqType)list.get((int)0)).type;
            default -> new ChoiceItemType(list);
        };
    }

    @Override
    public boolean isNumber() {
        return this.union.isNumber();
    }

    @Override
    public boolean isUntyped() {
        return this.union.isNumberOrUntyped();
    }

    @Override
    public boolean isNumberOrUntyped() {
        return this.union.isNumberOrUntyped();
    }

    @Override
    public boolean isStringOrUntyped() {
        return this.union.isStringOrUntyped();
    }

    @Override
    public boolean isSortable() {
        return this.union.isSortable();
    }

    @Override
    public AtomType atomic() {
        return this.union.atomic();
    }

    @Override
    public Type.ID id() {
        return Type.ID.CIT;
    }

    @Override
    public boolean nsSensitive() {
        for (SeqType st : this.types) {
            if (!st.type.nsSensitive()) continue;
            return true;
        }
        return false;
    }

    boolean hasInstance(Type type) {
        for (SeqType st : this.types) {
            if (!type.instanceOf(st.type)) continue;
            return true;
        }
        return false;
    }

    boolean hasInstance(SeqType seqType) {
        if (!seqType.one()) {
            throw Util.notExpected();
        }
        Test test = seqType.test();
        if (test instanceof UnionTest) {
            UnionTest ut = (UnionTest)test;
            for (Test t : ut.tests) {
                if (this.hasInstance(SeqType.get(t))) continue;
                return false;
            }
            return true;
        }
        for (SeqType st : this.types) {
            if (!seqType.instanceOf(st)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.types.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ChoiceItemType)) return false;
        ChoiceItemType cit = (ChoiceItemType)obj;
        if (!this.types.equals(cit.types)) return false;
        return true;
    }

    @Override
    public String toString() {
        QueryString qs = new QueryString().token('(');
        int n = this.types.size();
        for (SeqType st : this.types) {
            qs.token(st.toString());
            if (--n == 0) continue;
            qs.token('|');
        }
        return qs.token(')').toString();
    }
}

