/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Token;

public final class Inline {
    private static final long INLINE = 0x8000000000L;
    private static final long STRING = 0x2000000000L;
    private static final byte[] WS = new byte[]{10, 9, 32, 13};

    private Inline() {
    }

    public static long pack(byte[] token) {
        long value = Inline.packInt(token);
        if (value != -1L) {
            return value;
        }
        long tl = token.length;
        if (tl <= 4L) {
            value = 0xA000000000L | tl << 32;
            int c = 32;
            for (byte b : token) {
                value |= ((long)b & 0xFFL) << (c -= 8);
            }
            return value;
        }
        if (tl < 16L && Token.ws(token)) {
            value = 0xE000000000L | tl << 32;
            int c = 32;
            for (byte b : token) {
                value |= (b < 11 ? 0L : 1L) << --c | (long)(b & 1) << --c;
            }
            return value;
        }
        return 0L;
    }

    public static long packInt(byte[] token) {
        byte b;
        int tl = token.length;
        if (tl == 0) {
            return -1L;
        }
        if (tl > 1 && ((b = token[0]) < 49 || b > 57)) {
            return -1L;
        }
        long value = 0L;
        for (byte b2 : token) {
            value = (value << 3) + (value << 1) + (long)b2 - 48L;
            if (b2 >= 48 && b2 <= 57 && value <= Integer.MAX_VALUE) continue;
            return -1L;
        }
        return 0x8000000000L | value;
    }

    public static byte[] unpack(long value) {
        return (value & 0x2000000000L) == 0L ? Token.token((int)value) : Inline.unpackString(value);
    }

    public static long unpackLong(long value) {
        return (value & 0x2000000000L) == 0L ? value & 0x7FFFFFFFFFL : Token.toLong(Inline.unpackString(value));
    }

    public static double unpackDouble(long value) {
        return (value & 0x2000000000L) == 0L ? (double)(value & 0x7FFFFFFFFFL) : Token.toDouble(Inline.unpackString(value));
    }

    public static int unpackLength(long value) {
        return (value & 0x2000000000L) == 0L ? Token.numDigits((int)value) : (int)(value >> 32) & 0xF;
    }

    public static boolean inlined(long value) {
        return (value & 0x8000000000L) != 0L;
    }

    private static byte[] unpackString(long value) {
        int tl = (int)(value >> 32) & 0xF;
        int v = (int)value;
        byte[] token = new byte[tl];
        if (tl <= 4) {
            int t = 0;
            int c = 24;
            while (t < tl) {
                token[t] = (byte)(v >> c);
                ++t;
                c -= 8;
            }
        } else {
            int t = 0;
            int c = 30;
            while (t < tl) {
                token[t] = WS[v >> c & 3];
                ++t;
                c -= 2;
            }
        }
        return token;
    }
}

