/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.QueryResource;
import org.basex.query.func.java.JavaCall;
import org.basex.query.util.pkg.ClassLoaderCache;
import org.basex.query.util.pkg.JarDesc;
import org.basex.query.util.pkg.JarParser;
import org.basex.query.util.pkg.Pkg;
import org.basex.query.util.pkg.PkgComponent;
import org.basex.query.util.pkg.PkgDep;
import org.basex.query.util.pkg.PkgParser;
import org.basex.query.util.pkg.PkgText;
import org.basex.query.util.pkg.PkgValidator;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.Version;

public final class ModuleLoader {
    private static final Method CLOSE = Reflect.method(QueryResource.class, "close", new Class[0]);
    private final Context context;
    private final HashSet<Object> javaModules = new HashSet();
    private ArrayList<ClassLoaderCache.Loader> loaders = new ArrayList();
    private final HashMap<String, Class<?>> resolved = new HashMap();

    public ModuleLoader(Context context) {
        this.context = context;
    }

    public void close() {
        for (Object jm : this.javaModules) {
            for (Class<?> c : jm.getClass().getInterfaces()) {
                if (c != QueryResource.class) continue;
                Reflect.invoke(CLOSE, jm, new Object[0]);
            }
        }
        this.javaModules.clear();
        for (ClassLoaderCache.Loader l : this.loaders) {
            l.release();
        }
        this.loaders.clear();
        this.resolved.clear();
    }

    public boolean addImport(String uri, QueryParser qp, InputInfo info) throws QueryException {
        Class<?> clz;
        String className;
        boolean java = uri.startsWith("java:");
        if (java) {
            className = uri.substring("java:".length());
        } else {
            HashSet<String> pkgs = this.context.repo.nsDict().get(uri);
            if (pkgs != null) {
                Version ver = null;
                String id = null;
                for (String pkg : pkgs) {
                    Version v = new Version(Pkg.version(pkg));
                    if (ver != null && v.compareTo(ver) <= 0) continue;
                    ver = v;
                    id = pkg;
                }
                if (id != null) {
                    this.addRepo(id, new HashSet<String>(), new HashSet<String>(), qp, info);
                    return true;
                }
            }
            String repoPath = this.context.soptions.get(StaticOptions.REPOPATH);
            String path = Strings.uri2path(uri);
            for (String suffix : IO.XQSUFFIXES) {
                IOFile file = new IOFile(repoPath, path + suffix);
                if (!file.exists()) continue;
                qp.module(file.path(), uri, info);
                return true;
            }
            className = Strings.uriToClasspath(path);
        }
        className = JavaCall.classPath(className);
        try {
            this.addLoader(ModuleLoader.jarUrls(this.context, className));
            clz = this.findClass(className);
        }
        catch (ClassNotFoundException ex) {
            Util.debug(ex);
            if (java) {
                throw QueryError.WHICHMODCLASS_X.get(info, className);
            }
            return false;
        }
        catch (Throwable th) {
            Throwable t = Util.rootException(th);
            throw QueryError.MODINIT_X_X_X.get(info, className, t.getMessage(), Util.className(t));
        }
        try {
            this.javaModules.add(clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            return true;
        }
        catch (Throwable ex) {
            throw QueryError.MODINST_X_X.get(info, className, ex);
        }
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c = this.resolved.get(name);
        if (c != null) {
            return c;
        }
        c = Reflect.find(name);
        if (c != null) {
            return c;
        }
        for (int i = this.loaders.size() - 1; i >= 0; --i) {
            c = this.loaders.get(i).find(name);
            if (c == null) continue;
            this.resolved.put(name, c);
            return c;
        }
        throw new ClassNotFoundException(name);
    }

    public Object findModule(String clz) {
        for (Object mod : this.javaModules) {
            if (!mod.getClass().getName().equals(clz)) continue;
            return mod;
        }
        return null;
    }

    static List<String> pkgUrls(IOFile pkgPath, IOFile modDir, InputInfo info) throws QueryException {
        ArrayList<String> urls = new ArrayList<String>();
        IOFile jarDesc = new IOFile(pkgPath, PkgText.JARDESC);
        if (jarDesc.exists()) {
            JarDesc desc = new JarParser(info).parse(jarDesc);
            for (byte[] u : desc.jars) {
                ModuleLoader.addURL(urls, new IOFile(modDir, Token.string(u)));
            }
        }
        return urls;
    }

    static List<String> jarUrls(Context context, String className) {
        ArrayList<String> urls = new ArrayList<String>();
        String repoPath = context.soptions.get(StaticOptions.REPOPATH);
        IOFile jar = new IOFile(repoPath, Strings.uri2path(className) + ".jar");
        if (jar.exists()) {
            ModuleLoader.addURL(urls, jar);
        }
        return urls;
    }

    private void addLoader(List<String> urls) throws IOException {
        if (!urls.isEmpty()) {
            this.loaders.add(ClassLoaderCache.acquire(urls));
        }
    }

    private void addRepo(String id, HashSet<String> toLoad, HashSet<String> loaded, QueryParser qp, InputInfo info) throws QueryException {
        if (loaded.contains(id)) {
            return;
        }
        Pkg pkg = this.context.repo.pkgDict().get(id);
        if (pkg == null) {
            throw QueryError.REPO_NOTFOUND_X.get(info, id);
        }
        IOFile pkgPath = this.context.repo.path(pkg.path());
        IOFile pkgDesc = new IOFile(pkgPath, "expath-pkg.xml");
        if (!((IO)pkgDesc).exists()) {
            Util.debugln("Missing package descriptor for package '%'", id);
        }
        pkg = new PkgParser(info).parse(pkgDesc);
        IOFile modDir = pkg.modDir(pkgPath);
        try {
            this.addLoader(ModuleLoader.pkgUrls(pkgPath, modDir, info));
        }
        catch (Throwable th) {
            Throwable t = Util.rootException(th);
            throw QueryError.MODINIT_X_X_X.get(info, pkg.name, t.getMessage(), Util.className(t));
        }
        if (!pkg.dep.isEmpty()) {
            toLoad.add(id);
        }
        for (PkgDep dep : pkg.dep) {
            if (dep.name == null) continue;
            String depId = new PkgValidator(this.context.repo, info).depPkg(dep);
            if (depId == null) {
                throw QueryError.REPO_NOTFOUND_X.get(info, dep.name);
            }
            if (toLoad.contains(depId)) {
                throw QueryError.CIRCMODULE.get(info, new Object[0]);
            }
            this.addRepo(depId, toLoad, loaded, qp, info);
        }
        for (PkgComponent comp : pkg.comps) {
            qp.module(new IOFile(modDir, comp.file).path(), comp.uri, info);
        }
        toLoad.remove(id);
        loaded.add(id);
    }

    private static void addURL(List<String> urls, IOFile jar) {
        urls.add(jar.url());
        IOFile extDir = new IOFile(jar.parent(), "." + jar.dbName());
        if (extDir.exists()) {
            for (IOFile file : extDir.children()) {
                urls.add(file.url());
            }
        }
    }
}

