/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public abstract class OracleObject<PARENT extends DBSObject>
implements DBSObject,
DBPSaveableObject {
    private static final Log log = Log.getLog(OracleObject.class);
    protected final PARENT parent;
    protected String name;
    private boolean persisted;
    private long objectId;

    protected OracleObject(PARENT parent, String name, long objectId, boolean persisted) {
        this.parent = parent;
        this.name = CommonUtils.notEmpty((String)name);
        this.objectId = objectId;
        this.persisted = persisted;
    }

    protected OracleObject(PARENT parent, String name, boolean persisted) {
        this.parent = parent;
        this.name = name;
        this.persisted = persisted;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public PARENT getParentObject() {
        return this.parent;
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return (OracleDataSource)this.parent.getDataSource();
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }
}

