/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerFigure;

public class PaletteToolbarLayout
extends ToolbarLayout {
    protected boolean isChildGrowing(IFigure child) {
        DrawerFigure drawerFigure;
        return child instanceof DrawerFigure && (drawerFigure = (DrawerFigure)child).isExpanded();
    }

    public void layout(IFigure parent) {
        boolean stretching;
        IFigure child;
        List children = parent.getChildren();
        ArrayList<IFigure> childrenGrabbingVertical = new ArrayList<IFigure>();
        int numChildren = children.size();
        Rectangle clientArea = parent.getClientArea();
        int x = clientArea.x;
        int y = clientArea.y;
        int availableHeight = clientArea.height;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        int totalHeight = 0;
        int totalMinHeight = 0;
        int heightOfNonGrowingChildren = 0;
        int heightPerChild = 0;
        int excessHeight = 0;
        int wHint = clientArea.width;
        int hHint = -1;
        int i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            prefSizes[i] = child.getPreferredSize(wHint, hHint);
            minSizes[i] = child.getMinimumSize(wHint, hHint);
            totalHeight += prefSizes[i].height;
            totalMinHeight += minSizes[i].height;
            if (this.isChildGrowing(child)) {
                childrenGrabbingVertical.add(child);
            } else {
                heightOfNonGrowingChildren += prefSizes[i].height;
            }
            ++i;
        }
        boolean bl = stretching = (totalHeight += (numChildren - 1) * this.getSpacing()) - Math.max(availableHeight, totalMinHeight += (numChildren - 1) * this.getSpacing()) < 0;
        if (stretching) {
            i = 0;
            while (i < childrenGrabbingVertical.size() - 1) {
                int index = children.indexOf(childrenGrabbingVertical.get(i));
                heightOfNonGrowingChildren += prefSizes[index].height;
                ++i;
            }
            if (!childrenGrabbingVertical.isEmpty()) {
                IFigure last = (IFigure)childrenGrabbingVertical.get(childrenGrabbingVertical.size() - 1);
                childrenGrabbingVertical.clear();
                childrenGrabbingVertical.add(last);
                heightPerChild = availableHeight - heightOfNonGrowingChildren;
            }
        } else if (!childrenGrabbingVertical.isEmpty()) {
            boolean childrenDiscarded;
            int spaceToConsume = availableHeight - heightOfNonGrowingChildren;
            heightPerChild = spaceToConsume / childrenGrabbingVertical.size();
            excessHeight = spaceToConsume - heightPerChild * childrenGrabbingVertical.size();
            block7: do {
                childrenDiscarded = false;
                Iterator iter = childrenGrabbingVertical.iterator();
                while (iter.hasNext()) {
                    IFigure childFig = (IFigure)iter.next();
                    int i2 = childFig.getParent().getChildren().indexOf(childFig);
                    if (prefSizes[i2].height >= heightPerChild) continue;
                    spaceToConsume -= prefSizes[i2].height;
                    heightOfNonGrowingChildren += prefSizes[i2].height;
                    iter.remove();
                    if (childrenGrabbingVertical.isEmpty()) continue block7;
                    childrenDiscarded = true;
                    heightPerChild = spaceToConsume / childrenGrabbingVertical.size();
                    excessHeight = spaceToConsume - heightPerChild * childrenGrabbingVertical.size();
                    continue block7;
                }
            } while (childrenDiscarded);
        }
        i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            Rectangle newBounds = new Rectangle(x, y, prefSizes[i].width, prefSizes[i].height);
            if (childrenGrabbingVertical.contains(child)) {
                childrenGrabbingVertical.remove(child);
                newBounds.height = childrenGrabbingVertical.isEmpty() ? heightPerChild + excessHeight : heightPerChild;
            }
            newBounds.width = this.isStretchMinorAxis() ? clientArea.width : Math.min(prefSizes[i].width, clientArea.width);
            int adjust = clientArea.width - newBounds.width;
            switch (this.getMinorAlignment()) {
                case 1: {
                    adjust = 0;
                    break;
                }
                case 0: {
                    adjust /= 2;
                    break;
                }
                case 2: {
                    break;
                }
            }
            newBounds.x += adjust;
            child.setBounds(newBounds);
            y += newBounds.height + this.getSpacing();
            ++i;
        }
    }
}

