/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExtendedProperty;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableType;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandWithOptions;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBEStructEditor;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class SQLServerTableColumnManager
extends SQLTableColumnManager<SQLServerTableColumn, SQLServerTableBase>
implements DBEStructEditor<SQLServerTableColumn>,
DBEObjectRenamer<SQLServerTableColumn> {
    protected final SQLTableColumnManager.ColumnModifier<SQLServerTableColumn> IdentityModifier = (monitor, column, sql, command) -> {
        if (column.isIdentity() && !column.isTimestamp()) {
            try {
                long seedValue;
                SQLServerTableColumn.IdentityInfo identityInfo = column.getIdentityInfo(monitor);
                long incrementValue = identityInfo.getIncrementValue();
                if (incrementValue <= 0L) {
                    incrementValue = 1L;
                }
                if ((seedValue = identityInfo.getSeedValue()) <= 0L) {
                    seedValue = 1L;
                }
                sql.append(" IDENTITY(").append(seedValue).append(",").append(incrementValue).append(")");
            }
            catch (DBCException e) {
                log.error((Object)"Error reading identity information", (Throwable)e);
            }
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<SQLServerTableColumn> CollateModifier = (monitor, column, sql, command) -> {
        String collationName = column.getCollationName();
        if (!CommonUtils.isEmpty((String)collationName)) {
            sql.append(" COLLATE ").append(collationName);
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<SQLServerTableColumn> SQLServerDefaultModifier = (monitor, column, sql, command) -> {
        DBECommandWithOptions commandWithOptions;
        boolean ddlSource = false;
        if (command instanceof DBECommandWithOptions && (commandWithOptions = (DBECommandWithOptions)command).getOptions().containsKey("ddl.source")) {
            ddlSource = true;
        }
        if (!column.isPersisted() || ddlSource) {
            this.DefaultModifier.appendModifier(monitor, column, sql, command);
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<SQLServerTableColumn> ComputedModifier = (monitor, column, sql, command) -> {
        String definition = column.getComputedDefinition();
        if (CommonUtils.isNotEmpty((String)definition)) {
            sql.append(" AS ").append(definition);
        }
        if (column.isComputedPersisted()) {
            sql.append(" PERSISTED");
        }
    };
    private static final Class<? extends DBSObject>[] CHILD_TYPES = (Class[])CommonUtils.array((Object[])new Class[]{SQLServerExtendedProperty.class});

    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES;
    }

    @Nullable
    public Collection<? extends DBSObject> getChildObjects(DBRProgressMonitor monitor, SQLServerTableColumn object, Class<? extends DBSObject> childType) throws DBException {
        return null;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, SQLServerTableColumn> getObjectsCache(SQLServerTableColumn object) {
        return ((SQLServerSchema)((SQLServerTableBase)object.getParentObject()).getContainer()).getTableCache().getChildrenCache((SQLServerTableBase)object.getParentObject());
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(SQLServerTableColumn column, Map<String, Object> options) {
        if (CommonUtils.isNotEmpty((String)column.getComputedDefinition())) {
            return new SQLTableColumnManager.ColumnModifier[]{this.ComputedModifier, this.NotNullModifier};
        }
        return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.IdentityModifier, this.CollateModifier, this.SQLServerDefaultModifier, this.NullNotNullModifier};
    }

    public boolean canEditObject(@NotNull SQLServerTableColumn object) {
        return !this.isTableType(object) && super.canEditObject((DBSEntityAttribute)object);
    }

    public boolean canDeleteObject(@NotNull SQLServerTableColumn object) {
        return !this.isTableType(object) && super.canDeleteObject((DBSEntityAttribute)object);
    }

    private boolean isTableType(SQLServerTableColumn column) {
        return column.getTable() instanceof SQLServerTableType;
    }

    protected SQLServerTableColumn createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        SQLServerTableBase table = (SQLServerTableBase)container;
        DBSDataType columnType = SQLServerTableColumnManager.findBestDataType((DBSObject)table, (String[])new String[]{"varchar"});
        SQLServerTableColumn column = new SQLServerTableColumn(table);
        column.setName(this.getNewColumnName(monitor, context, (DBSEntity)table));
        if (columnType instanceof SQLServerDataType) {
            SQLServerDataType dt = (SQLServerDataType)columnType;
            column.setDataType(dt);
        }
        column.setTypeName(columnType == null ? "varchar" : columnType.getName());
        column.setMaxLength(columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0);
        column.setValueType(columnType == null ? 12 : columnType.getTypeID());
        column.setOrdinalPosition(-1);
        return column;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        super.addObjectCreateActions(monitor, executionContext, actions, command, options);
        if (CommonUtils.isNotEmpty((String)((SQLServerTableColumn)command.getObject()).getDescription())) {
            SQLServerTableColumnManager.addColumnCommentAction(actions, (SQLServerTableColumn)command.getObject(), false);
        }
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        boolean hasComment;
        SQLServerTableColumn column = (SQLServerTableColumn)command.getObject();
        int totalProps = command.getProperties().size();
        boolean bl = hasComment = command.getProperty((Object)"description") != null;
        if (hasComment) {
            --totalProps;
        }
        if (column.isPersisted() && command.hasProperty((Object)"defaultValue")) {
            --totalProps;
            SQLServerTableColumnManager.addDropConstraintAction(actionList, column);
            String defaultValue = column.getDefaultValue();
            if (!CommonUtils.isEmpty((String)defaultValue)) {
                StringBuilder sql = new StringBuilder();
                sql.append("ALTER TABLE ").append(((SQLServerTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ADD ");
                this.DefaultModifier.appendModifier(monitor, (DBPObject)column, sql, (DBECommandAbstract)command);
                sql.append(" FOR ").append(DBUtils.getQuotedIdentifier((DBSObject)column));
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter default value", sql.toString()));
            }
        }
        if (hasComment) {
            boolean isUpdate = SQLServerUtils.isCommentSet(monitor, ((SQLServerTableBase)column.getTable()).getDatabase(), SQLServerObjectClass.OBJECT_OR_COLUMN, ((SQLServerTableBase)column.getTable()).getObjectId(), column.getObjectId());
            SQLServerTableColumnManager.addColumnCommentAction(actionList, column, isUpdate);
        }
        if (totalProps > 0) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify column", "ALTER TABLE " + ((SQLServerTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ALTER COLUMN " + String.valueOf(this.getNestedDeclaration(monitor, (DBSEntity)((SQLServerTableBase)column.getTable()), (DBECommandAbstract)command, options))));
        }
    }

    static void addColumnCommentAction(List<DBEPersistAction> actionList, SQLServerTableColumn column, boolean isUpdate) {
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Add column comment", "EXEC " + SQLServerUtils.getSystemTableName(((SQLServerTableBase)column.getTable()).getDatabase(), isUpdate ? "sp_updateextendedproperty" : "sp_addextendedproperty") + " 'MS_Description', " + SQLUtils.quoteString((DBSObject)column, (String)column.getDescription()) + ", 'schema', " + SQLUtils.quoteString((DBSObject)column, (String)((SQLServerTableBase)column.getTable()).getSchema().getName()) + ", 'table', " + SQLUtils.quoteString((DBSObject)column, (String)((SQLServerTableBase)column.getTable()).getName()) + ", 'column', " + SQLUtils.quoteString((DBSObject)column, (String)column.getName())));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) throws DBException {
        SQLServerTableColumnManager.addDropConstraintAction(actions, (SQLServerTableColumn)command.getObject());
        super.addObjectDeleteActions(monitor, executionContext, actions, command, options);
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull SQLServerTableColumn object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        SQLServerTableColumn column = (SQLServerTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "EXEC " + SQLServerUtils.getSystemTableName(((SQLServerTableBase)column.getTable()).getDatabase(), "sp_rename") + " N'" + ((SQLServerTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DML) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + "' , N'" + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName()) + "', 'COLUMN'"));
    }

    private static void addDropConstraintAction(@NotNull List<DBEPersistAction> actions, @NotNull SQLServerTableColumn column) {
        if (column.getDefaultConstraintName() != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop default constraint", "ALTER TABLE " + ((SQLServerTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " DROP CONSTRAINT " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)column.getDefaultConstraintName())));
        }
    }
}

