/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPExclusiveResource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;

public class InvalidateJob
extends DataSourceJob {
    private static final Log log = Log.getLog(InvalidateJob.class);
    private static final String TASK_INVALIDATE = "dsInvalidate";
    private List<ContextInvalidateResult> invalidateResults = new ArrayList<ContextInvalidateResult>();
    private InvalidationFeedbackHandler feedbackHandler;

    public InvalidateJob(DBPDataSource dataSource) {
        super("Invalidate " + dataSource.getContainer().getName(), DBUtils.getDefaultContext(dataSource.getDefaultInstance(), false));
    }

    public List<ContextInvalidateResult> getInvalidateResults() {
        return this.invalidateResults;
    }

    public void setFeedbackHandler(@Nullable InvalidationFeedbackHandler feedbackHandler) {
        this.feedbackHandler = feedbackHandler;
    }

    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        DBPDataSource dataSource = this.getExecutionContext().getDataSource();
        this.invalidateResults = InvalidateJob.invalidateDataSource(monitor, dataSource, false, true, this.feedbackHandler);
        return Status.OK_STATUS;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<ContextInvalidateResult> invalidateDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, boolean disconnectOnFailure, boolean showErrors, @Nullable InvalidationFeedbackHandler feedbackHandler) {
        containers = new LinkedHashSet<DBPDataSourceContainer>();
        InvalidateJob.collectDependentDataSources(dataSource, containers);
        locks = new HashMap<DBPDataSourceContainer, Object>();
        it = containers.iterator();
        while (it.hasNext()) {
            container = (DBPDataSourceContainer)it.next();
            monitor.subTask("Obtain exclusive datasource lock for '" + container.getName() + "'");
            lock = container.getExclusiveLock().acquireTaskLock("dsInvalidate", true);
            if (lock == DBPExclusiveResource.TASK_PROCESED) {
                InvalidateJob.log.debug("Datasource '" + container.getName() + "' was already invalidated");
                it.remove();
                continue;
            }
            locks.put(container, lock);
        }
        if (locks.isEmpty()) {
            InvalidateJob.log.debug("Nothing to invalidate");
            monitor.done();
            return List.of();
        }
        try {
            if (feedbackHandler == null || feedbackHandler.confirmInvalidate(containers)) {
                var8_9 /* !! */  = InvalidateJob.invalidateDataSources0(monitor, containers, disconnectOnFailure, showErrors, feedbackHandler);
                return var8_9 /* !! */ ;
            }
            InvalidateJob.log.debug("Invalidate cancelled by user");
            var8_9 /* !! */  = List.of();
            return var8_9 /* !! */ ;
        }
        finally {
            monitor.subTask("Release exclusive datasource locks");
            ** for (entry : locks.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            ((DBPDataSourceContainer)entry.getKey()).getExclusiveLock().releaseTaskLock("dsInvalidate", entry.getValue());
            continue;
        }
lbl32:
        // 1 sources

        monitor.done();
        return var8_9 /* !! */ ;
    }

    @NotNull
    private static List<ContextInvalidateResult> invalidateDataSources0(@NotNull DBRProgressMonitor monitor, @NotNull Set<DBPDataSourceContainer> containers, boolean disconnectOnFailure, boolean showErrors, @Nullable InvalidationFeedbackHandler feedbackHandler) {
        monitor.beginTask("Invalidate data sources", containers.size());
        ArrayList<ContextInvalidateResult> finalResults = new ArrayList<ContextInvalidateResult>();
        DBCInvalidatePhase[] dBCInvalidatePhaseArray = DBCInvalidatePhase.values();
        int n = dBCInvalidatePhaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<ContextInvalidateResult> results;
            DBPDataSource dataSource;
            DBCInvalidatePhase phase = dBCInvalidatePhaseArray[n2];
            finalResults.clear();
            static enum Severity {
                FINE,
                SEVERE;

            }
            HashMap<DBPDataSourceContainer, Severity> failed = new HashMap<DBPDataSourceContainer, Severity>();
            for (DBPDataSourceContainer container : containers) {
                if (failed.get(container) == Severity.SEVERE || (dataSource = container.getDataSource()) == null) continue;
                results = InvalidateJob.invalidateNetworkHandlers(monitor, dataSource, phase);
                if (InvalidateJob.anyFailed(results)) {
                    failed.put(container, Severity.SEVERE);
                }
                finalResults.addAll(results);
            }
            for (DBPDataSourceContainer container : containers) {
                if (failed.containsKey(container) || (dataSource = container.getDataSource()) == null) continue;
                results = InvalidateJob.invalidateInstances(monitor, dataSource, phase);
                if (InvalidateJob.anyFailed(results)) {
                    failed.put(container, Severity.FINE);
                }
                if (disconnectOnFailure && InvalidateJob.allFailed(results)) {
                    try {
                        container.disconnect(monitor);
                    }
                    catch (Exception e) {
                        log.error("Error closing inaccessible datasource", e);
                    }
                    String errors = results.stream().filter(ContextInvalidateResult::isError).map(result -> result.getException().getMessage()).collect(Collectors.joining("\n"));
                    DBWorkbench.getPlatformUI().showError("Forced disconnect", "Datasource '" + container.getName() + "' was disconnected: destination database unreachable.\n" + errors);
                }
                if (phase == DBCInvalidatePhase.AFTER_INVALIDATE) {
                    if (feedbackHandler != null) {
                        if (InvalidateJob.anySucceeded(results)) {
                            feedbackHandler.onInvalidateSuccess(container, results);
                        } else if (showErrors) {
                            feedbackHandler.onInvalidateFailure(container, results);
                        }
                    }
                    monitor.worked(1);
                }
                finalResults.addAll(results);
            }
            ++n2;
        }
        monitor.done();
        return finalResults;
    }

    private static void collectDependentDataSources(@NotNull DBPDataSource dataSource, @NotNull Set<DBPDataSourceContainer> result) {
        ArrayDeque<DBPDataSourceContainer> pending = new ArrayDeque<DBPDataSourceContainer>();
        pending.add(dataSource.getContainer());
        while (!pending.isEmpty()) {
            DBPDataSourceContainer container = (DBPDataSourceContainer)pending.remove();
            if (!result.add(container)) continue;
            DBWNetworkHandler[] dBWNetworkHandlerArray = container.getActiveNetworkHandlers();
            int n = dBWNetworkHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBPDataSourceContainer[] dataSources;
                DBWNetworkHandler handler = dBWNetworkHandlerArray[n2];
                DBPDataSourceContainer[] dBPDataSourceContainerArray = dataSources = handler.getDependentDataSources();
                int n3 = dataSources.length;
                int n4 = 0;
                while (n4 < n3) {
                    DBPDataSourceContainer other = dBPDataSourceContainerArray[n4];
                    pending.offer(other);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    @NotNull
    private static Collection<ContextInvalidateResult> invalidateNetworkHandlers(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DBCInvalidatePhase phase) {
        ArrayList<ContextInvalidateResult> results = new ArrayList<ContextInvalidateResult>();
        monitor.subTask("Invalidate network connection");
        DBWNetworkHandler[] dBWNetworkHandlerArray = dataSource.getContainer().getActiveNetworkHandlers();
        int n = dBWNetworkHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBWNetworkHandler nh = dBWNetworkHandlerArray[n2];
            log.debug("\tInvalidate network handler '" + nh.getClass().getSimpleName() + "' for " + dataSource.getContainer().getId());
            monitor.subTask("Invalidate handler [" + nh.getClass().getSimpleName() + "]");
            try {
                nh.invalidateHandler(monitor, dataSource, phase);
                results.add(ContextInvalidateResult.newSuccess(dataSource));
            }
            catch (Exception e) {
                results.add(ContextInvalidateResult.newError(dataSource, e));
            }
            ++n2;
        }
        return results;
    }

    @NotNull
    private static Collection<ContextInvalidateResult> invalidateInstances(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DBCInvalidatePhase phase) {
        ArrayList<ContextInvalidateResult> results = new ArrayList<ContextInvalidateResult>();
        monitor.subTask("Invalidate connections of " + dataSource.getContainer().getName());
        for (DBSInstance dBSInstance : dataSource.getAvailableInstances()) {
            DBCExecutionContext[] dBCExecutionContextArray = dBSInstance.getAllContexts();
            int n = dBCExecutionContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    DBCExecutionContext context = dBCExecutionContextArray[n2];
                    log.debug("\tInvalidate context '" + context.getContextName() + "' for " + dataSource.getContainer().getId() + " (" + String.valueOf((Object)phase) + ")");
                    Object exclusiveLock = dBSInstance.getExclusiveLock().acquireExclusiveLock();
                    try {
                        try {
                            context.invalidateContext(monitor, phase);
                            results.add(ContextInvalidateResult.newSuccess(dataSource));
                        }
                        catch (Exception e) {
                            log.debug("\tFailed: " + e.getMessage());
                            results.add(ContextInvalidateResult.newError(dataSource, e));
                            dBSInstance.getExclusiveLock().releaseExclusiveLock(exclusiveLock);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        dBSInstance.getExclusiveLock().releaseExclusiveLock(exclusiveLock);
                        throw throwable;
                    }
                    dBSInstance.getExclusiveLock().releaseExclusiveLock(exclusiveLock);
                }
                ++n2;
            }
        }
        return results;
    }

    public static void invalidateTransaction(DBRProgressMonitor monitor, DBPDataSource dataSource, DBCExecutionContext executionContext) {
        if (executionContext != null) {
            monitor.subTask("Invalidate context [" + executionContext.getDataSource().getContainer().getName() + "/" + executionContext.getContextName() + "] transactions");
            InvalidateJob.invalidateTransaction(monitor, executionContext);
        } else {
            monitor.subTask("Invalidate datasource [" + dataSource.getContainer().getName() + "] transactions");
            for (DBSInstance dBSInstance : dataSource.getAvailableInstances()) {
                DBCExecutionContext[] dBCExecutionContextArray = dBSInstance.getAllContexts();
                int n = dBCExecutionContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBCExecutionContext context = dBCExecutionContextArray[n2];
                    InvalidateJob.invalidateTransaction(monitor, context);
                    ++n2;
                }
            }
        }
    }

    public static void invalidateTransaction(DBRProgressMonitor monitor, DBCExecutionContext context) {
        block12: {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager(context);
            if (txnManager != null) {
                try {
                    if (txnManager.isAutoCommit()) break block12;
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Rollback failed transaction");){
                        session.enableLogging(false);
                        txnManager.rollback(session, null);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DBException e) {
                    log.error("Error invalidating aborted transaction", e);
                }
            }
        }
    }

    public static boolean allSucceeded(@NotNull Collection<ContextInvalidateResult> results) {
        return results.stream().allMatch(ContextInvalidateResult::isSuccess);
    }

    public static boolean anySucceeded(@NotNull Collection<ContextInvalidateResult> results) {
        return results.stream().anyMatch(ContextInvalidateResult::isSuccess);
    }

    public static boolean allFailed(@NotNull Collection<ContextInvalidateResult> results) {
        return results.stream().allMatch(ContextInvalidateResult::isError);
    }

    public static boolean anyFailed(@NotNull Collection<ContextInvalidateResult> results) {
        return results.stream().anyMatch(ContextInvalidateResult::isError);
    }

    public static int getSucceededCount(@NotNull Collection<ContextInvalidateResult> results) {
        return (int)results.stream().filter(ContextInvalidateResult::isSuccess).count();
    }

    @Override
    protected void canceling() {
        this.getThread().interrupt();
    }

    public static class ContextInvalidateResult {
        private final DBPDataSource dataSource;
        private final Exception exception;

        public ContextInvalidateResult(DBPDataSource dataSource) {
            this.dataSource = dataSource;
            this.exception = null;
        }

        public ContextInvalidateResult(DBPDataSource dataSource, Exception exception) {
            this.dataSource = dataSource;
            this.exception = exception;
        }

        public static ContextInvalidateResult newSuccess(@NotNull DBPDataSource dataSource) {
            return new ContextInvalidateResult(dataSource);
        }

        public static ContextInvalidateResult newError(@NotNull DBPDataSource dataSource, @NotNull Exception exception) {
            return new ContextInvalidateResult(dataSource, exception);
        }

        public DBPDataSource getDataSource() {
            return this.dataSource;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean isSuccess() {
            return this.exception == null;
        }

        public boolean isError() {
            return this.exception != null;
        }
    }

    public static interface InvalidationFeedbackHandler {
        public boolean confirmInvalidate(@NotNull Set<DBPDataSourceContainer> var1);

        public void onInvalidateSuccess(@NotNull DBPDataSourceContainer var1, @NotNull Collection<ContextInvalidateResult> var2);

        public void onInvalidateFailure(@NotNull DBPDataSourceContainer var1, @NotNull Collection<ContextInvalidateResult> var2);
    }
}

