/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.utils.DurationFormat;

public final class DurationFormatter {
    private static final Format LONG_HOURS_FORMAT = new MessageFormat(ModelMessages.duration_formatter_hours);
    private static final Format LONG_MINUTES_FORMAT = new MessageFormat(ModelMessages.duration_formatter_minutes);
    private static final Format LONG_SECONDS_FORMAT = new MessageFormat(ModelMessages.duration_formatter_seconds);
    private static final Format LONG_MILLISECONDS_FORMAT = new MessageFormat(ModelMessages.duration_formatter_milliseconds);
    private static final Format SHORT_SECONDS_FORMAT = new DecimalFormat("#.#s");
    private static final Format MEDIUM_SECONDS_FORMAT = new DecimalFormat("#.###s");

    private DurationFormatter() {
    }

    @NotNull
    public static String format(@NotNull Duration duration, @NotNull DurationFormat format) {
        return switch (format) {
            case DurationFormat.LONG -> DurationFormatter.formatLong(duration);
            case DurationFormat.MEDIUM -> DurationFormatter.formatShortOrMedium(duration, true);
            case DurationFormat.SHORT -> DurationFormatter.formatShortOrMedium(duration, false);
            default -> throw new MatchException(null, null);
        };
    }

    @NotNull
    private static String formatShortOrMedium(@NotNull Duration duration, boolean medium) {
        long hours = duration.toHours();
        int minutes = duration.toMinutesPart();
        int seconds = duration.toSecondsPart();
        int millis = duration.toMillisPart();
        if (hours > 0L) {
            return String.format("%dh %dm %ds", hours, minutes, seconds);
        }
        if (minutes > 0) {
            return String.format("%dm %ds", minutes, seconds);
        }
        if (seconds >= 10) {
            return String.format("%ds", seconds);
        }
        Format format = medium ? MEDIUM_SECONDS_FORMAT : SHORT_SECONDS_FORMAT;
        return format.format((double)seconds + (double)millis * 0.001);
    }

    @NotNull
    private static String formatLong(@NotNull Duration duration) {
        int seconds;
        int minutes;
        StringJoiner joiner = new StringJoiner(", ");
        long hours = duration.toHours();
        if (hours > 0L) {
            joiner.add(LONG_HOURS_FORMAT.format(new Object[]{hours}));
        }
        if ((minutes = duration.toMinutesPart()) > 0) {
            joiner.add(LONG_MINUTES_FORMAT.format(new Object[]{minutes}));
        }
        if ((seconds = duration.toSecondsPart()) > 0) {
            joiner.add(LONG_SECONDS_FORMAT.format(new Object[]{seconds}));
        }
        if (joiner.length() == 0) {
            joiner.add(LONG_MILLISECONDS_FORMAT.format(new Object[]{duration.toMillis()}));
        }
        return joiner.toString();
    }
}

