/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCObjectSupplier;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCStatementImpl;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.sql.DBSQLException;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class JDBCPreparedStatementImpl<STATEMENT extends PreparedStatement>
extends JDBCStatementImpl<STATEMENT>
implements JDBCPreparedStatement {
    private static final Log log = Log.getLog(JDBCPreparedStatementImpl.class);
    private static final Object NULL_VALUE = new Object();
    private Map<Object, Object> paramMap;

    JDBCPreparedStatementImpl(@NotNull JDBCSession connection, @NotNull JDBCObjectSupplier<STATEMENT> stmtSupplier, @Nullable String query, boolean disableLogging) throws SQLException {
        super(connection, stmtSupplier, query, disableLogging);
    }

    @Override
    public void close() {
        if (this.paramMap != null) {
            this.paramMap.clear();
            this.paramMap = null;
        }
        super.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getFormattedQuery() {
        if (this.paramMap == null) {
            return this.getQueryString();
        }
        String q = this.getQueryString();
        if (q == null) {
            return "";
        }
        int length = q.length();
        StringBuilder formatted = new StringBuilder(length * 2);
        int paramIndex = 0;
        int i = 0;
        while (i < length) {
            block10: {
                char c = q.charAt(i);
                block0 : switch (c) {
                    case '?': {
                        Object paramValue = this.paramMap.get(++paramIndex);
                        if (paramValue == null) break;
                        formatted.append(this.formatParameterValue(paramValue));
                        break block10;
                    }
                    case ':': {
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        formatted.append(c);
                        int k = i + 1;
                        while (k < length) {
                            char c2 = q.charAt(k);
                            if (c2 == c && q.charAt(k - 1) != '\\') {
                                i = k;
                                c = c2;
                                break block0;
                            }
                            formatted.append(c2);
                            ++k;
                        }
                        break block0;
                    }
                }
                formatted.append(c);
            }
            ++i;
        }
        return formatted.toString();
    }

    @NotNull
    private String formatParameterValue(Object value) {
        if (value instanceof CharSequence) {
            return SQLUtils.quoteString((DBPDataSource)((JDBCSession)this.connection).getDataSource(), (String)value.toString());
        }
        if (value instanceof Number) {
            return DBValueFormatting.convertNumberToNativeString((Number)((Number)value), (boolean)false);
        }
        if (value instanceof java.util.Date) {
            try {
                DBDDataFormatterProfile formatterProfile = ((JDBCSession)this.getSession()).getDataFormatterProfile();
                if (value instanceof Date) {
                    return SQLUtils.quoteString((DBPDataSource)((JDBCSession)this.connection).getDataSource(), (String)formatterProfile.createFormatter("date", null).formatValue(value));
                }
                if (value instanceof Time) {
                    return SQLUtils.quoteString((DBPDataSource)((JDBCSession)this.connection).getDataSource(), (String)formatterProfile.createFormatter("time", null).formatValue(value));
                }
                return SQLUtils.quoteString((DBPDataSource)((JDBCSession)this.connection).getDataSource(), (String)formatterProfile.createFormatter("timestamptz", null).formatValue(value));
            }
            catch (Exception e) {
                log.debug((Object)("Error formatting date [" + String.valueOf(value) + "]"), (Throwable)e);
            }
        } else if (value == NULL_VALUE) {
            return "NULL";
        }
        return value.toString();
    }

    protected void handleStatementBind(Object parameter, @Nullable Object o) {
        if (this.isQMLoggingEnabled()) {
            if (o == null) {
                o = NULL_VALUE;
            } else if (!DBUtils.isAtomicParameter((Object)o)) {
                o = new ContentParameter((JDBCSession)this.connection, o);
            }
            if (this.paramMap == null) {
                this.paramMap = new LinkedHashMap<Object, Object>();
            }
            this.paramMap.put(parameter, o);
            if (((JDBCSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementBind((DBCStatement)this, parameter, o);
            }
        }
    }

    @Override
    public boolean executeStatement() throws DBCException {
        try {
            return this.execute();
        }
        catch (SQLException e) {
            throw new DBSQLException(this.query, (Throwable)e, (DBCExecutionContext)((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public void addToBatch() throws DBCException {
        try {
            this.addBatch();
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public JDBCResultSet executeQuery() throws SQLException {
        this.beforeExecute();
        try {
            JDBCResultSet jDBCResultSet = this.createResultSetImpl(((PreparedStatement)this.getOriginal()).executeQuery());
            return jDBCResultSet;
        }
        catch (Throwable e) {
            throw super.handleExecuteError(e);
        }
        finally {
            super.afterExecute();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.beforeExecute();
        try {
            int n = ((PreparedStatement)this.getOriginal()).executeUpdate();
            return n;
        }
        catch (Throwable e) {
            throw super.handleExecuteError(e);
        }
        finally {
            super.afterExecute();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.beforeExecute();
        try {
            boolean bl = ((PreparedStatement)this.getOriginal()).execute();
            return bl;
        }
        catch (Throwable e) {
            throw super.handleExecuteError(e);
        }
        finally {
            super.afterExecute();
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setNull(parameterIndex, sqlType);
        this.handleStatementBind(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setBoolean(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setByte(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setShort(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setInt(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setLong(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setFloat(parameterIndex, x);
        this.handleStatementBind(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setDouble(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setBigDecimal(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setString(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setBytes(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setDate(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setTime(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setTimestamp(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setAsciiStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setUnicodeStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setBinaryStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void clearParameters() throws SQLException {
        ((PreparedStatement)this.getOriginal()).clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setObject(parameterIndex, x, targetSqlType);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setObject(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void addBatch() throws SQLException {
        ((PreparedStatement)this.getOriginal()).addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setCharacterStream(parameterIndex, reader, length);
        this.handleStatementBind(parameterIndex, reader);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setRef(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setBlob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setClob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setArray(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return ((PreparedStatement)this.getOriginal()).getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setDate(parameterIndex, x, cal);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setTime(parameterIndex, x, cal);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setTimestamp(parameterIndex, x, cal);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setNull(parameterIndex, sqlType, typeName);
        this.handleStatementBind(parameterIndex, null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setURL(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.getOriginal()).getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setRowId(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setNString(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setNCharacterStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setNClob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setClob(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setBlob(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setNClob(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setSQLXML(parameterIndex, xmlObject);
        this.handleStatementBind(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setAsciiStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setBinaryStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setCharacterStream(parameterIndex, x, length);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setAsciiStream(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setBinaryStream(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setCharacterStream(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setNCharacterStream(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setClob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setBlob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        ((PreparedStatement)this.getOriginal()).setNClob(parameterIndex, x);
        this.handleStatementBind(parameterIndex, x);
    }

    protected static class ContentParameter {
        String displayString;

        ContentParameter(@NotNull JDBCSession session, Object value) {
            if (value instanceof RowId) {
                RowId rowId = (RowId)value;
                this.displayString = SQLUtils.quoteString((DBPDataSource)session.getDataSource(), (String)new String(rowId.getBytes()));
            } else if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                this.displayString = DBValueFormatting.formatBinaryString((DBPDataSource)session.getDataSource(), (byte[])bytes, (DBDDisplayFormat)DBDDisplayFormat.NATIVE, (boolean)true);
            } else {
                this.displayString = "DATA(" + (value == null ? "[NULL]" : value.getClass().getSimpleName()) + ")";
            }
        }

        public String toString() {
            return this.displayString;
        }
    }
}

