/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hive.model;

import java.io.Closeable;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Properties;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.IOUtils;

class HiveDataSourceInfo
extends JDBCDataSourceInfo {
    private static final Log log = Log.getLog(HiveDataSourceInfo.class);
    private String serverVersion;
    private String clientVersion;

    HiveDataSourceInfo(DBRProgressMonitor monitor, DBPDataSource dataSource, JDBCDatabaseMetaData metaData) {
        block17: {
            super(metaData);
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Read Hive version");){
                    this.serverVersion = JDBCUtils.queryString((Connection)session, (String)"SELECT version()", (Object[])new Object[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.debug((Object)("Error reading Hive version: " + e.getMessage()));
            }
            try {
                InputStream propsStream;
                ClassLoader classLoader = dataSource.getContainer().getDriver().getDriverLoader(dataSource.getContainer()).getClassLoader();
                if (classLoader == null || (propsStream = classLoader.getResourceAsStream("common-version-info.properties")) == null) break block17;
                try {
                    Properties props = new Properties();
                    props.load(propsStream);
                    this.clientVersion = props.getProperty("version");
                }
                finally {
                    IOUtils.close((Closeable)propsStream);
                }
            }
            catch (Throwable throwable) {
                log.debug((Object)"Error getting Hive client version");
            }
        }
    }

    public String getDatabaseProductVersion() {
        return this.serverVersion == null ? super.getDatabaseProductVersion() : this.serverVersion;
    }

    public String getDriverVersion() {
        if (this.clientVersion != null) {
            return this.clientVersion;
        }
        return super.getDriverVersion();
    }

    public boolean supportsIndexes() {
        if (this.serverVersion != null) {
            return !this.serverVersion.startsWith("3");
        }
        return false;
    }
}

