/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.action;

import org.eclipse.gef.Disposable;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.action.Action;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.erd.ERDIcon;
import org.jkiss.dbeaver.ui.editors.erd.ERDUIUtils;
import org.jkiss.dbeaver.ui.editors.erd.internal.ERDUIMessages;

public class DiagramToggleHandAction
extends Action
implements PaletteListener,
Disposable {
    public static final String CMD_TOGGLE_HAND = "org.jkiss.dbeaver.erd.toggleHand";
    private final PaletteViewer viewer;
    private final ToolEntry handTool;
    private ToolEntry previousTool;

    public DiagramToggleHandAction(@NotNull PaletteViewer viewer) {
        super(ERDUIMessages.erd_action_diagram_toggle_hand_checkbox_text, 2);
        this.viewer = viewer;
        this.viewer.addPaletteListener((PaletteListener)this);
        this.handTool = (ToolEntry)ERDUIUtils.findPaletteEntry((PaletteContainer)viewer.getPaletteRoot(), "hand-tool");
        this.setId(CMD_TOGGLE_HAND);
        this.setActionDefinitionId(CMD_TOGGLE_HAND);
        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)ERDIcon.MOVE));
    }

    public void run() {
        if (this.viewer.getActiveTool() == this.handTool) {
            this.viewer.setActiveTool(this.previousTool);
        } else {
            this.viewer.setActiveTool(this.handTool);
        }
    }

    public void activeToolChanged(PaletteViewer viewer, ToolEntry toolEntry) {
        if (toolEntry != this.handTool) {
            this.previousTool = toolEntry;
        }
        this.setChecked(toolEntry == this.handTool);
    }

    public void dispose() {
        this.viewer.removePaletteListener((PaletteListener)this);
    }
}

