/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OracleQueue
extends OracleSchemaObject {
    private static final Log log = Log.getLog(OracleQueue.class);
    private String queueTable;
    private int qId;
    private QueueType queueType;
    private Integer maxRetries;
    private Integer retryDelay;
    private String enqueueEnabled;
    private String dequeueEnabled;
    private String retention;
    private String userComment;
    private String networkName;

    public OracleQueue(OracleSchema schema, String name) {
        super(schema, name, false);
    }

    public OracleQueue(OracleSchema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NAME"), true);
        this.queueTable = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"QUEUE_TABLE");
        try {
            this.queueType = QueueType.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"QUEUE_TYPE"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.queueType = null;
        }
        this.maxRetries = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"MAX_RETRIES");
        this.retryDelay = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"RETRY_DELAY");
        this.qId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"QID");
        this.enqueueEnabled = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ENQUEUE_ENABLED");
        this.dequeueEnabled = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEQUEUE_ENABLED");
        this.retention = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RETENTION");
        this.userComment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"USER_COMMENT");
        this.networkName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NETWORK_NAME");
    }

    @Property(viewable=true, order=2)
    @NotNull
    public OracleTableBase getQueueTable(DBRProgressMonitor monitor) throws DBException {
        return (OracleTableBase)((OracleSchema)this.parent).tableCache.getObject(monitor, (OracleSchema)this.parent, this.queueTable);
    }

    @Property(viewable=true, order=3)
    @NotNull
    public int getQId() {
        return this.qId;
    }

    @Property(viewable=true, order=4)
    public QueueType getQueueType() {
        return this.queueType;
    }

    @Property(viewable=true, order=5)
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Property(viewable=true, order=6)
    public Integer getRetryDelay() {
        return this.retryDelay;
    }

    @Property(viewable=true, order=7)
    public String getEnqueueEnabled() {
        return this.enqueueEnabled;
    }

    @Property(viewable=true, order=8)
    public String getDequeueEnabled() {
        return this.dequeueEnabled;
    }

    @Property(viewable=true, order=9)
    public String getRetention() {
        return this.retention;
    }

    @Property(viewable=true, order=10)
    public String getUserComment() {
        return this.userComment;
    }

    @Property(viewable=true, order=11)
    public String getNetworkName() {
        return this.networkName;
    }

    public static enum QueueType {
        NORMAL_QUEUE,
        EXCEPTION_QUEUE,
        NON_PERSISTENT_QUEUE;

    }
}

