/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.driver.libsql;

import com.dbeaver.jdbc.driver.libsql.LibSqlResultSet;
import com.dbeaver.jdbc.driver.libsql.LibSqlStatement;
import com.dbeaver.jdbc.driver.libsql.client.LibSqlExecutionResult;
import com.dbeaver.jdbc.model.AbstractJdbcResultSetMetaData;
import com.dbeaver.jdbc.model.AbstractJdbcStatement;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;

public class LibSqlResultSetMetaData
extends AbstractJdbcResultSetMetaData<LibSqlStatement> {
    @NotNull
    private final LibSqlResultSet resultSet;

    public LibSqlResultSetMetaData(@NotNull LibSqlResultSet resultSet) throws SQLException {
        super((AbstractJdbcStatement)((LibSqlStatement)resultSet.getStatement()));
        this.resultSet = resultSet;
    }

    private ResultColumnDataType getDataTypeFromData(int column) {
        LibSqlExecutionResult result = this.resultSet.getResult();
        if (result != null && !CommonUtils.isEmpty(result.getRows())) {
            Object columnValue = result.getRows().get(0)[column - 1];
            if (columnValue instanceof Boolean) {
                return ResultColumnDataType.BOOLEAN;
            }
            if (columnValue instanceof Number) {
                return ResultColumnDataType.NUMBER;
            }
        }
        return ResultColumnDataType.STRING;
    }

    public int getColumnCount() throws SQLException {
        return this.resultSet.getResult() == null ? 0 : this.resultSet.getResult().getColumns().size();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    public int isNullable(int column) throws SQLException {
        return 1;
    }

    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return -1;
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.resultSet.getResult().getColumns().get(column - 1);
    }

    public String getColumnName(int column) throws SQLException {
        List<String> columns = this.resultSet.getResult().getColumns();
        if (column < 1 || column > columns.size()) {
            throw new SQLException("Column index out of bounds: " + column + "/" + columns.size());
        }
        return columns.get(column - 1);
    }

    public int getPrecision(int column) throws SQLException {
        return -1;
    }

    public int getScale(int column) throws SQLException {
        return -1;
    }

    public String getCatalogName(int column) throws SQLException {
        return null;
    }

    public String getSchemaName(int column) throws SQLException {
        return null;
    }

    public String getTableName(int column) throws SQLException {
        return null;
    }

    public int getColumnType(int column) throws SQLException {
        switch (this.getDataTypeFromData(column)) {
            case BOOLEAN: {
                return 16;
            }
            case NUMBER: {
                return 2;
            }
            case STRING: {
                return 12;
            }
        }
        return 1111;
    }

    public String getColumnTypeName(int column) throws SQLException {
        switch (this.getDataTypeFromData(column)) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case NUMBER: {
                return "NUMERIC";
            }
            case STRING: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN";
    }

    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return true;
    }

    private static enum ResultColumnDataType {
        BOOLEAN,
        NUMBER,
        STRING;

    }
}

