/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.diff.DiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;
import org.eclipse.team.internal.core.subscribers.AbstractContentComparator;
import org.eclipse.team.internal.ui.synchronize.RegexDiffComparator;

public class RegexDiffFilter
extends DiffFilter {
    AbstractContentComparator criteria;
    boolean ignoreWhiteSpace;

    public RegexDiffFilter(String pattern) {
        this(false, pattern);
    }

    public RegexDiffFilter(boolean ignoreWhitespace, String pattern) {
        this.criteria = new RegexDiffComparator(Pattern.compile(pattern, 32), ignoreWhitespace);
    }

    public boolean select(IDiff diff, IProgressMonitor monitor) {
        IFileRevision remote = SyncInfoToDiffConverter.getRemote((IDiff)diff);
        IResource local = ResourceDiffTree.getResourceFor((IDiff)diff);
        if (local == null || local.getType() != 1) {
            return true;
        }
        if (remote == null) {
            return !local.exists();
        }
        if (!local.exists()) {
            return false;
        }
        return this.criteria.compare(local, remote, monitor);
    }
}

