/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import net.schmizz.sshj.userauth.keyprovider.PEMKey;
import net.schmizz.sshj.userauth.keyprovider.PEMKeyReader;

class StandardPEMKeyReader
implements PEMKeyReader {
    private static final String HEADER_DELIMITER = "-----BEGIN";
    private static final String FOOTER_DELIMITER = "-----END";
    private static final char PEM_HEADER_DELIMITER = ':';
    private static final int CHARACTER_NOT_FOUND = -1;
    private static final String HEADER_NOT_FOUND = "header not found";
    private static final Base64.Decoder bodyDecoder = Base64.getDecoder();

    StandardPEMKeyReader() {
    }

    @Override
    public PEMKey readPemKey(BufferedReader bufferedReader) throws IOException {
        Objects.requireNonNull(bufferedReader, "Reader required");
        PEMKey.PEMKeyType pemKeyType = this.findPemKeyType(bufferedReader);
        return this.readPemKeyBody(pemKeyType, bufferedReader);
    }

    private PEMKey.PEMKeyType findPemKeyType(BufferedReader bufferedReader) throws IOException {
        PEMKey.PEMKeyType pemKeyTypeFound = null;
        String header = HEADER_NOT_FOUND;
        String line = bufferedReader.readLine();
        block0: while (line != null) {
            if (line.startsWith(HEADER_DELIMITER)) {
                header = line;
                for (PEMKey.PEMKeyType pemKeyType : PEMKey.PEMKeyType.values()) {
                    if (!pemKeyType.getHeader().equals(line)) continue;
                    pemKeyTypeFound = pemKeyType;
                    break block0;
                }
            }
            line = bufferedReader.readLine();
        }
        if (pemKeyTypeFound == null) {
            throw new IOException(String.format("Supported PEM Key Type not found for header [%s]", header));
        }
        return pemKeyTypeFound;
    }

    private PEMKey readPemKeyBody(PEMKey.PEMKeyType pemKeyType, BufferedReader bufferedReader) throws IOException {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> headers = new ArrayList<String>();
        String line = bufferedReader.readLine();
        while (line != null && !line.startsWith(FOOTER_DELIMITER)) {
            if (line.indexOf(58) > -1) {
                headers.add(line);
            } else if (!line.isEmpty()) {
                builder.append(line);
            }
            line = bufferedReader.readLine();
        }
        String pemKeyBody = builder.toString();
        byte[] pemKeyBodyDecoded = this.getPemKeyBodyDecoded(pemKeyBody);
        return new PEMKey(pemKeyType, headers, pemKeyBodyDecoded);
    }

    private byte[] getPemKeyBodyDecoded(String pemKeyBodyEncoded) throws IOException {
        try {
            return bodyDecoder.decode(pemKeyBodyEncoded);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Base64 decoding of PEM Key failed", e);
        }
    }
}

