/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator;

import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.CommonUtils;

public abstract class SQLGeneratorBase<OBJECT>
extends SQLGenerator<OBJECT> {
    protected abstract Collection<? extends DBSAttributeBase> getAllAttributes(DBRProgressMonitor var1, OBJECT var2) throws DBException;

    protected abstract Collection<? extends DBSAttributeBase> getKeyAttributes(DBRProgressMonitor var1, OBJECT var2) throws DBException;

    protected Collection<? extends DBSAttributeBase> getValueAttributes(DBRProgressMonitor monitor, OBJECT object, Collection<? extends DBSAttributeBase> keyAttributes) throws DBException {
        if (CommonUtils.isEmpty(keyAttributes)) {
            return this.getAllAttributes(monitor, object);
        }
        ArrayList<DBSAttributeBase> valueAttributes = new ArrayList<DBSAttributeBase>(this.getAllAttributes(monitor, object));
        valueAttributes.removeIf(keyAttributes::contains);
        return valueAttributes;
    }

    protected void appendDefaultValue(StringBuilder sql, DBSAttributeBase attr) {
        String defValue = null;
        if (attr instanceof DBSEntityAttribute) {
            defValue = ((DBSEntityAttribute)attr).getDefaultValue();
        }
        if (!CommonUtils.isEmpty(defValue)) {
            sql.append(defValue);
        } else {
            switch (attr.getDataKind()) {
                case BOOLEAN: {
                    sql.append("false");
                    break;
                }
                case NUMERIC: {
                    sql.append("0");
                    break;
                }
                case STRING: 
                case DATETIME: 
                case CONTENT: {
                    sql.append("''");
                    break;
                }
                default: {
                    sql.append("?");
                }
            }
        }
    }
}

