/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.semver4j.RangesExpression;
import org.semver4j.RangesList;
import org.semver4j.RangesListFactory;
import org.semver4j.internal.Coerce;
import org.semver4j.internal.Comparator;
import org.semver4j.internal.Differ;
import org.semver4j.internal.Modifier;
import org.semver4j.internal.StrictParser;

public class Semver
implements Comparable<Semver> {
    @NotNull
    public static final Semver ZERO = new Semver("0.0.0");
    @NotNull
    private final String originalVersion;
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final @NotNull List<@NotNull String> preRelease;
    @NotNull
    private final @NotNull List<@NotNull String> build;
    @NotNull
    private final String version;

    public Semver(@NotNull String version) {
        this.originalVersion = version.trim();
        StrictParser.Version parsedVersion = StrictParser.parse(this.originalVersion);
        this.major = parsedVersion.getMajor();
        this.minor = parsedVersion.getMinor();
        this.patch = parsedVersion.getPatch();
        this.preRelease = parsedVersion.getPreRelease();
        this.build = parsedVersion.getBuild();
        this.version = new Builder().withMajor(this.major).withMinor(this.minor).withPatch(this.patch).withPreReleases(this.preRelease).withBuilds(this.build).toVersion();
    }

    @Nullable
    public static Semver parse(@Nullable String version) {
        if (version == null) {
            return null;
        }
        try {
            return new Semver(version);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Semver coerce(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Semver semver = Semver.parse(version);
        if (semver != null) {
            return semver;
        }
        String coerce = Coerce.coerce(version);
        return Semver.parse(coerce);
    }

    public static boolean isValid(@Nullable String version) {
        return Semver.parse(version) != null;
    }

    public static Builder of() {
        return new Builder();
    }

    @NotNull
    public static Semver of(int major, int minor, int patch) {
        return new Builder().withMajor(major).withMinor(minor).withPatch(patch).toSemver();
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    @NotNull
    public @NotNull List<@NotNull String> getPreRelease() {
        return this.preRelease;
    }

    @NotNull
    public @NotNull List<@NotNull String> getBuild() {
        return this.build;
    }

    public boolean isStable() {
        return this.major > 0 && this.preRelease.isEmpty();
    }

    @NotNull
    public Semver nextMajor() {
        return Modifier.nextMajor(this);
    }

    @NotNull
    public Semver withIncMajor() {
        return this.withIncMajor(1);
    }

    @NotNull
    public Semver withIncMajor(int number) {
        return Modifier.withIncMajor(this, number);
    }

    @NotNull
    public Semver nextMinor() {
        return Modifier.nextMinor(this);
    }

    @NotNull
    public Semver withIncMinor() {
        return this.withIncMinor(1);
    }

    @NotNull
    public Semver withIncMinor(int number) {
        return Modifier.withIncMinor(this, number);
    }

    @NotNull
    public Semver nextPatch() {
        return Modifier.nextPatch(this);
    }

    @NotNull
    public Semver withIncPatch() {
        return this.withIncPatch(1);
    }

    @NotNull
    public Semver withIncPatch(int number) {
        return Modifier.withIncPatch(this, number);
    }

    @NotNull
    public Semver withPreRelease(@NotNull String preRelease) {
        return Modifier.withPreRelease(this, preRelease);
    }

    @NotNull
    public Semver withBuild(@NotNull String build) {
        return Modifier.withBuild(this, build);
    }

    @NotNull
    public Semver withClearedPreRelease() {
        return Modifier.withClearedPreRelease(this);
    }

    @NotNull
    public Semver withClearedBuild() {
        return Modifier.withClearedBuild(this);
    }

    @NotNull
    public Semver withClearedPreReleaseAndBuild() {
        return Modifier.withClearedPreReleaseAndBuild(this);
    }

    @Override
    public int compareTo(@NotNull Semver other) {
        return Comparator.compareTo(this, other);
    }

    public boolean isApiCompatible(@NotNull String version) {
        return this.diff(version).ordinal() < VersionDiff.MAJOR.ordinal();
    }

    public boolean isApiCompatible(@NotNull Semver version) {
        return this.diff(version).ordinal() < VersionDiff.MAJOR.ordinal();
    }

    public boolean isGreaterThan(@NotNull String version) {
        return this.isGreaterThan(new Semver(version));
    }

    public boolean isGreaterThan(@NotNull Semver version) {
        return this.compareTo(version) > 0;
    }

    public boolean isGreaterThanOrEqualTo(@NotNull String version) {
        return this.isGreaterThanOrEqualTo(new Semver(version));
    }

    public boolean isGreaterThanOrEqualTo(@NotNull Semver version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isLowerThan(@NotNull String version) {
        return this.isLowerThan(new Semver(version));
    }

    public boolean isLowerThan(@NotNull Semver version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLowerThanOrEqualTo(@NotNull String version) {
        return this.isLowerThanOrEqualTo(new Semver(version));
    }

    public boolean isLowerThanOrEqualTo(@NotNull Semver version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isEqualTo(@NotNull String version) {
        return this.isEqualTo(new Semver(version));
    }

    public boolean isEqualTo(@NotNull Semver version) {
        return this.equals(version);
    }

    public boolean isEquivalentTo(@NotNull String version) {
        return this.isEquivalentTo(new Semver(version));
    }

    public boolean isEquivalentTo(@NotNull Semver version) {
        return this.compareTo(version) == 0;
    }

    @NotNull
    public VersionDiff diff(@NotNull String version) {
        return this.diff(new Semver(version));
    }

    @NotNull
    public VersionDiff diff(@NotNull Semver version) {
        return Differ.diff(this, version);
    }

    public boolean satisfies(@NotNull String range) {
        RangesList rangesList = RangesListFactory.create(range);
        return this.satisfies(rangesList);
    }

    public boolean satisfies(@NotNull RangesExpression rangesExpression) {
        RangesList rangesList = RangesListFactory.create(rangesExpression);
        return this.satisfies(rangesList);
    }

    public boolean satisfies(@NotNull RangesList rangesList) {
        return rangesList.isSatisfiedBy(this);
    }

    public String format(Function<Semver, String> formatter) {
        return formatter.apply(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Semver semver = (Semver)o;
        return Objects.equals(this.originalVersion, semver.originalVersion);
    }

    public int hashCode() {
        return Objects.hash(this.originalVersion);
    }

    @NotNull
    public String toString() {
        return this.getVersion();
    }

    public static class Builder {
        private int major;
        private int minor;
        private int patch;
        private List<String> preRelease = Collections.emptyList();
        private List<String> build = Collections.emptyList();

        public Builder withMajor(int major) {
            this.major = major;
            return this;
        }

        public Builder withMinor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder withPatch(int patch) {
            this.patch = patch;
            return this;
        }

        public Builder withPreRelease(@NotNull String preRelease) {
            Objects.requireNonNull(preRelease, "preRelease cannot be null");
            return this.withPreReleases(new String[]{preRelease});
        }

        public Builder withPreReleases(@NotNull Collection<String> preReleases) {
            Objects.requireNonNull(preReleases, "preRelease cannot be null");
            this.preRelease = new ArrayList<String>(preReleases);
            return this;
        }

        public Builder withPreReleases(@NotNull String[] preReleases) {
            Objects.requireNonNull(preReleases, "preRelease cannot be null");
            this.preRelease = Arrays.asList(preReleases);
            return this;
        }

        public Builder withBuild(@NotNull String build) {
            Objects.requireNonNull(build, "build cannot be null");
            return this.withBuilds(new String[]{build});
        }

        public Builder withBuilds(@NotNull Collection<String> builds) {
            Objects.requireNonNull(builds, "builds cannot be null");
            this.build = new ArrayList<String>(builds);
            return this;
        }

        public Builder withBuilds(@NotNull String[] builds) {
            Objects.requireNonNull(builds, "builds cannot be null");
            this.build = Arrays.asList(builds);
            return this;
        }

        @NotNull
        public Semver toSemver() {
            String version = this.toVersion();
            return new Semver(version);
        }

        @NotNull
        public String toVersion() {
            String resultVersion = String.format(Locale.ROOT, "%d.%d.%d", this.major, this.minor, this.patch);
            if (!this.preRelease.isEmpty()) {
                resultVersion = resultVersion + "-" + String.join((CharSequence)".", this.preRelease);
            }
            if (!this.build.isEmpty()) {
                resultVersion = resultVersion + "+" + String.join((CharSequence)".", this.build);
            }
            return resultVersion;
        }

        public String toVersion(Function<Semver, String> formatter) {
            return formatter.apply(this.toSemver());
        }
    }

    public static enum VersionDiff {
        NONE,
        BUILD,
        PRE_RELEASE,
        PATCH,
        MINOR,
        MAJOR;

    }
}

