/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.Statement;
import com.singlestore.jdbc.client.ClientImpl;
import com.singlestore.jdbc.client.TransactionSaver;
import com.singlestore.jdbc.client.context.RedoContext;
import com.singlestore.jdbc.message.client.ClientMessage;
import com.singlestore.jdbc.message.client.PreparePacket;
import com.singlestore.jdbc.message.client.RedoableClientMessage;
import com.singlestore.jdbc.message.client.RedoableWithPrepareClientMessage;
import com.singlestore.jdbc.message.server.Completion;
import com.singlestore.jdbc.message.server.PrepareResultPacket;
import com.singlestore.jdbc.util.exceptions.MaxAllowedPacketException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class ClientReplayImpl
extends ClientImpl {
    public ClientReplayImpl(Configuration conf, HostAddress hostAddress, ReentrantLock lock, boolean skipPostCommands) throws SQLException {
        super(conf, hostAddress, lock, skipPostCommands);
    }

    @Override
    public int sendQuery(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        try {
            if (message instanceof RedoableClientMessage) {
                ((RedoableClientMessage)message).ensureReplayable(this.context);
            }
            return message.encode(this.writer, this.context);
        }
        catch (IOException ioException) {
            if (ioException instanceof MaxAllowedPacketException) {
                if (((MaxAllowedPacketException)ioException).isMustReconnect()) {
                    this.destroySocket();
                    throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "08000", ioException);
                }
                throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "HZ000", ioException);
            }
            this.destroySocket();
            throw this.exceptionFactory.withSql(message.description()).create("Socket error", "08000", ioException);
        }
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        List<Completion> res = super.executePipeline(messages, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        ((RedoContext)this.context).saveRedo(messages);
        return res;
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        List<Completion> completions = super.execute(message, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        ((RedoContext)this.context).saveRedo(message);
        return completions;
    }

    public void transactionReplay(TransactionSaver transactionSaver) throws SQLException {
        List<RedoableClientMessage> buffers = transactionSaver.getBuffers();
        try {
            for (RedoableClientMessage querySaver : buffers) {
                int responseNo;
                if (querySaver instanceof RedoableWithPrepareClientMessage) {
                    RedoableWithPrepareClientMessage redoable = (RedoableWithPrepareClientMessage)querySaver;
                    String cmd = redoable.getCommand();
                    PrepareResultPacket prepare = this.context.getPrepareCache().get(cmd, redoable.prep());
                    if (prepare == null) {
                        PreparePacket preparePacket = new PreparePacket(cmd);
                        this.sendQuery(preparePacket);
                        prepare = (PrepareResultPacket)this.readPacket(preparePacket);
                    }
                    responseNo = querySaver.reEncode(this.writer, this.context, prepare);
                } else {
                    responseNo = querySaver.reEncode(this.writer, this.context, null);
                }
                for (int j = 0; j < responseNo; ++j) {
                    this.readResponse(querySaver);
                }
            }
        }
        catch (IOException e) {
            throw this.context.getExceptionFactory().create("Socket error during transaction replay", "08000", e);
        }
    }
}

