/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.querytranslation.hql;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.ColumnMetadata;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.IServerVersion;
import com.databricks.client.hivecommon.IServerVersionUtils;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.hivecommon.querytranslation.hql.JoinColumnNode;
import com.databricks.client.hivecommon.querytranslation.hql.JoinNode;
import com.databricks.client.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESort;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETable;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AERename;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class ChildJoinPredicateAnalyzer
extends AEDefaultVisitor<String> {
    private JoinState m_innerJoinState = JoinState.NULL;
    private HashMap<AENamedRelationalExpr, String> m_generatedTableAlias;
    private List<JoinNode> m_syntheticJoinProjections;
    private HashMap<AEJoin, String> synthTable_JoinMap = new HashMap();
    private IServerVersionUtils m_serverVersionUtils;
    private IServerVersion m_serverVersion;
    private boolean m_getColumnRef;
    private List<AEColumnReference> m_columnReferences = new ArrayList<AEColumnReference>();
    private boolean m_processingOrderBy = false;
    private HiveJDBCSettings m_settings;

    public ChildJoinPredicateAnalyzer(IAENode iAENode, HashMap<AENamedRelationalExpr, String> hashMap, IServerVersionUtils iServerVersionUtils, IServerVersion iServerVersion, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        try {
            this.m_generatedTableAlias = hashMap;
            this.m_serverVersionUtils = iServerVersionUtils;
            this.m_serverVersion = iServerVersion;
            this.m_settings = hiveJDBCSettings;
            this.defaultVisit(iAENode);
        }
        catch (ErrorException errorException) {
            ErrorException errorException2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), "translation error");
            throw errorException2;
        }
    }

    public List<JoinNode> getSyntheticJoinProjections() {
        return this.m_syntheticJoinProjections;
    }

    private void analyzeParentJoinConditions(Iterator<AEValueExpr> iterator, AEJoin aEJoin, List<AEColumnReference> list) {
        while (iterator.hasNext()) {
            AEValueExpr aEValueExpr = iterator.next();
            if (!(aEValueExpr instanceof AEColumnReference)) continue;
            AEColumnReference aEColumnReference = (AEColumnReference)aEValueExpr;
            boolean bl = true;
            if (aEJoin.getLeftOperand() instanceof AETable && this.isTableMatch(aEColumnReference, (AETable)aEJoin.getLeftOperand())) {
                bl = false;
            }
            if (aEJoin.getRightOperand() instanceof AETable && this.isTableMatch(aEColumnReference, (AETable)aEJoin.getRightOperand())) {
                bl = false;
            }
            if (!bl || list.contains(aEColumnReference)) continue;
            list.add(aEColumnReference);
        }
    }

    private boolean isTableMatch(AEColumnReference aEColumnReference, AETable aETable) {
        return null != aEColumnReference && null != aETable && aETable.getCorrelationName().equals(aEColumnReference.getNamedRelationalExpr().getCorrelationName());
    }

    private String getTableNameForLaterSynthesis(AETable aETable) {
        if (this.m_generatedTableAlias.containsKey(aETable)) {
            return this.m_generatedTableAlias.get(aETable);
        }
        if (aETable.hasCorrelationName()) {
            return aETable.getCorrelationName();
        }
        return aETable.getTableName();
    }

    @Override
    public String visit(AEColumnReference aEColumnReference) throws ErrorException {
        if (this.m_getColumnRef) {
            this.m_columnReferences.add(aEColumnReference);
        }
        return this.defaultVisit(aEColumnReference);
    }

    @Override
    public String visit(AEJoin aEJoin) throws ErrorException {
        ArrayList<AEColumnReference> arrayList = null;
        String string = null;
        this.defaultVisit(aEJoin);
        if (aEJoin.getParent() instanceof AEJoin) {
            Iterator<IColumn> iterator;
            Object object;
            Object object2;
            arrayList = new ArrayList<AEColumnReference>();
            AEJoin aEJoin2 = (AEJoin)aEJoin.getParent();
            if (null != aEJoin2.getJoinCondition() && aEJoin2.getJoinCondition() instanceof AEComparison) {
                object2 = (AEComparison)aEJoin2.getJoinCondition();
                if (null != ((AEComparison)object2).getLeftOperand() && null != ((AEComparison)object2).getLeftOperand().getChildItr()) {
                    this.analyzeParentJoinConditions(((AEComparison)object2).getLeftOperand().getChildItr(), aEJoin2, arrayList);
                }
                if (null != ((AEComparison)object2).getRightOperand() && null != ((AEComparison)object2).getRightOperand().getChildItr()) {
                    this.analyzeParentJoinConditions(((AEComparison)object2).getRightOperand().getChildItr(), aEJoin2, arrayList);
                }
            }
            object2 = UUID.randomUUID().toString().substring(0, 8);
            string = "`SYNTHJOIN_" + (String)object2 + "`";
            this.synthTable_JoinMap.put(aEJoin, "SYNTHJOIN_" + (String)object2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" ( SELECT ");
            boolean bl = true;
            ArrayList<JoinColumnNode> arrayList2 = new ArrayList<JoinColumnNode>();
            if (aEJoin.getRightOperand() instanceof AETable) {
                object = (AETable)aEJoin.getRightOperand();
                for (IColumn object3 : aEJoin.getRightOperand().getResultSetColumns()) {
                    bl = this.buildPrefixString(object3, stringBuilder, arrayList2, this.getTableNameForLaterSynthesis((AETable)object), string, arrayList, aEJoin, bl, null);
                }
            }
            if (aEJoin.getLeftOperand() instanceof AETable) {
                object = (AETable)aEJoin.getLeftOperand();
                for (IColumn iColumn : aEJoin.getLeftOperand().getResultSetColumns()) {
                    bl = this.buildPrefixString(iColumn, stringBuilder, arrayList2, this.getTableNameForLaterSynthesis((AETable)object), string, arrayList, aEJoin, bl, null);
                }
            }
            if (aEJoin.getRightOperand() instanceof AESubQuery) {
                object = (AESubQuery)aEJoin.getRightOperand();
                iterator = null;
                if (this.m_processingOrderBy && ((AESubQuery)object).getOperand() instanceof AEProject) {
                    iterator = ((AEProject)((AESubQuery)object).getOperand()).getProjectionList();
                }
                for (IColumn iColumn : aEJoin.getRightOperand().getResultSetColumns()) {
                    bl = this.buildPrefixString(iColumn, stringBuilder, (List<JoinColumnNode>)arrayList2, ((AESubQuery)object).getTableName(), string, (List<AEColumnReference>)arrayList, aEJoin, bl, (AEValueExprList)((Object)iterator));
                }
            }
            if (aEJoin.getLeftOperand() instanceof AESubQuery) {
                object = (AESubQuery)aEJoin.getLeftOperand();
                iterator = null;
                if (this.m_processingOrderBy && ((AESubQuery)object).getOperand() instanceof AEProject) {
                    iterator = ((AEProject)((AESubQuery)object).getOperand()).getProjectionList();
                }
                for (IColumn iColumn : aEJoin.getLeftOperand().getResultSetColumns()) {
                    bl = this.buildPrefixString(iColumn, stringBuilder, (List<JoinColumnNode>)arrayList2, ((AESubQuery)object).getTableName(), string, (List<AEColumnReference>)arrayList, aEJoin, bl, (AEValueExprList)((Object)iterator));
                }
            } else if (aEJoin.getLeftOperand() instanceof AEJoin && null != (object = this.synthTable_JoinMap.get(aEJoin.getLeftOperand()))) {
                for (IColumn iColumn : aEJoin.getLeftOperand().createResultSetColumns()) {
                    bl = this.buildPrefixString(iColumn, stringBuilder, arrayList2, (String)object, string, arrayList, aEJoin, bl, null);
                }
            }
            stringBuilder.append(" FROM ");
            this.m_innerJoinState = JoinState.IGNORE;
            object = new StringBuilder();
            ((StringBuilder)object).append(") ").append(string).append(" ");
            if (this.m_settings.m_renameJoinColumn) {
                if (null == this.m_syntheticJoinProjections) {
                    this.m_syntheticJoinProjections = new ArrayList<JoinNode>();
                }
                this.m_syntheticJoinProjections.add(new JoinNode((AEJoin)aEJoin.getParent(), aEJoin, stringBuilder.toString(), ((StringBuilder)object).toString(), arrayList2));
            }
        }
        return null;
    }

    @Override
    public String visit(AESort aESort) throws ErrorException {
        this.m_processingOrderBy = true;
        this.defaultVisit(aESort);
        this.m_processingOrderBy = false;
        return null;
    }

    @Override
    public String visit(AESubQuery aESubQuery) throws ErrorException {
        Object object;
        this.defaultVisit(aESubQuery);
        ArrayList<IColumn> arrayList = aESubQuery.createResultSetColumns();
        for (int i = 0; i < aESubQuery.getColumnCount(); ++i) {
            object = aESubQuery.getColumn(i);
            arrayList.add((IColumn)object);
        }
        if (aESubQuery.getOperand() instanceof AEProject && ((AEProject)aESubQuery.getOperand()).getOperand() instanceof AEJoin) {
            AEJoin aEJoin = (AEJoin)((AEProject)aESubQuery.getOperand()).getOperand();
            object = aEJoin.getResultSetColumns();
            AEValueExprList aEValueExprList = ((AEProject)aESubQuery.getOperand()).getProjectionList();
            this.m_getColumnRef = true;
            this.defaultVisit(aEValueExprList);
            this.m_getColumnRef = false;
            if (null != this.m_syntheticJoinProjections) {
                block1: for (AEColumnReference aEColumnReference : this.m_columnReferences) {
                    if (!object.contains(aEColumnReference.getColumn()) || aEColumnReference.getParent() instanceof AERename) continue;
                    for (JoinNode joinNode : this.m_syntheticJoinProjections) {
                        if (joinNode.getParent() != aEJoin) continue;
                        for (JoinColumnNode joinColumnNode : joinNode.getPredicateColumns()) {
                            if (joinColumnNode.getColumn() != aEColumnReference.getColumn()) continue;
                            ColumnMetadata columnMetadata = (ColumnMetadata)arrayList.get(aEColumnReference.getColumnNum());
                            columnMetadata.setName(joinColumnNode.getColumnReferenceName().replace('`', '_').replace('.', '_'));
                            continue block1;
                        }
                        continue block1;
                    }
                }
            }
        }
        return null;
    }

    private boolean buildPrefixString(IColumn iColumn, StringBuilder stringBuilder, List<JoinColumnNode> list, String string, String string2, List<AEColumnReference> list2, AEJoin aEJoin, boolean bl, AEValueExprList aEValueExprList) {
        if (!bl) {
            stringBuilder.append(", ");
        }
        bl = false;
        String string3 = null;
        String string4 = iColumn.getName();
        if (null != this.m_syntheticJoinProjections) {
            block0: for (JoinNode object : this.m_syntheticJoinProjections) {
                if (object.getParent() != aEJoin) continue;
                for (JoinColumnNode joinColumnNode : object.getPredicateColumns()) {
                    if (joinColumnNode.getColumn() != iColumn) continue;
                    string4 = joinColumnNode.getStraightColumnName();
                    break block0;
                }
            }
        }
        if (this.m_processingOrderBy && null != aEValueExprList && string4 == iColumn.getName()) {
            for (AEValueExpr aEValueExpr : aEValueExprList) {
                if (!(aEValueExpr instanceof AEColumnReference) || ((AEColumnReference)aEValueExpr).getColumn() != iColumn) continue;
                String string5 = ((AEColumnReference)aEValueExpr).getNamedRelationalExpr().getCorrelationName();
                string4 = string5 + string4;
                break;
            }
        }
        if (null != string && string.length() > 0) {
            string3 = string + string4;
            stringBuilder.append("`").append(string).append("`.`").append(string4).append("`");
        } else {
            stringBuilder.append("`").append(string4).append("`");
        }
        stringBuilder.append(" AS ").append(this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, string3)).append(" ");
        boolean bl2 = false;
        for (AEColumnReference aEColumnReference : list2) {
            if (aEColumnReference.getColumn() != iColumn) continue;
            bl2 = true;
        }
        list.add(new JoinColumnNode(bl2, iColumn, string2 + ".`" + string3 + "`", string3));
        return bl;
    }

    @Override
    public String defaultVisit(IAENode iAENode) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<? extends IAENode> iterator = iAENode.getChildItr();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().acceptVisitor(this));
        }
        return stringBuilder.toString();
    }

    private static enum JoinState {
        NULL,
        TRIGGER,
        IGNORE;

    }
}

