/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.relation;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.CursorType;
import com.databricks.client.sqlengine.executor.etree.ETCacheInvalidationListener;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.ETDefaultVisitor;
import com.databricks.client.sqlengine.executor.etree.IETExpr;
import com.databricks.client.sqlengine.executor.etree.IETNode;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;

public abstract class ETRelationalExpr
implements IETExpr {
    private HashSet<ETCacheInvalidationListener> m_cacheValidationListeners = new HashSet();
    private boolean m_canReopenAfterClosed = false;
    protected boolean[] m_dataNeeded;

    public ETRelationalExpr(boolean[] blArray) {
        this.m_dataNeeded = (boolean[])blArray.clone();
    }

    public boolean canReopenAfterClosed() {
        return this.m_canReopenAfterClosed;
    }

    @Override
    public Iterator<? extends IETNode> getChildItr() {
        return new AbstractList<IETNode>(){

            @Override
            public IETNode get(int n) {
                return ETRelationalExpr.this.getChild(n);
            }

            @Override
            public int size() {
                return ETRelationalExpr.this.getNumChildren();
            }
        }.iterator();
    }

    public abstract IColumn getColumn(int var1);

    public abstract int getColumnCount();

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName();
    }

    public boolean getDataNeeded(int n) {
        return this.m_dataNeeded[n];
    }

    public abstract long getRowCount() throws ErrorException;

    public boolean move() throws ErrorException {
        if (this.doMove()) {
            for (ETCacheInvalidationListener eTCacheInvalidationListener : this.m_cacheValidationListeners) {
                eTCacheInvalidationListener.invalidateCache();
            }
            return true;
        }
        return false;
    }

    public abstract void open(CursorType var1) throws ErrorException;

    public void registerCacheValidationListener(ETCacheInvalidationListener eTCacheInvalidationListener) {
        this.m_cacheValidationListeners.add(eTCacheInvalidationListener);
    }

    public abstract boolean retrieveData(int var1, ETDataRequest var2) throws ErrorException;

    public void setCanReopenAfterClosed() {
        if (!this.m_canReopenAfterClosed) {
            try {
                ETDefaultVisitor<Void> eTDefaultVisitor = new ETDefaultVisitor<Void>(){

                    @Override
                    public Void defaultVisit(IETNode iETNode) throws ErrorException {
                        if (iETNode instanceof ETRelationalExpr) {
                            ((ETRelationalExpr)iETNode).m_canReopenAfterClosed = true;
                        }
                        Iterator<? extends IETNode> iterator = iETNode.getChildItr();
                        while (iterator.hasNext()) {
                            IETNode iETNode2 = iterator.next();
                            iETNode2.acceptVisitor(this);
                        }
                        return null;
                    }
                };
                this.acceptVisitor(eTDefaultVisitor);
            }
            catch (ErrorException errorException) {
                throw new AssertionError((Object)"Won't happen");
            }
        }
    }

    protected abstract IETNode getChild(int var1) throws IndexOutOfBoundsException;

    protected abstract boolean doMove() throws ErrorException;
}

