![nlesolver-fortran](media/logo.png)
============

Nonlinear Equation Solver with Modern Fortran.

A basic Newton-Raphson type nonlinear equation solver for dense systems with `m` functions of `n` input variables.

A work in progress.

### Status

[![Language](https://img.shields.io/badge/-Fortran-734f96?logo=fortran&logoColor=white)](https://github.com/topics/fortran)
[![CI Status](https://github.com/jacobwilliams/nlesolver-fortran/actions/workflows/CI.yml/badge.svg)](https://github.com/jacobwilliams/nlesolver-fortran/actions)
[![GitHub release](https://img.shields.io/github/release/jacobwilliams/nlesolver-fortran.svg)](https://github.com/jacobwilliams/nlesolver-fortran/releases/latest)
[![codecov](https://codecov.io/gh/jacobwilliams/nlesolver-fortran/branch/master/graph/badge.svg)](https://codecov.io/gh/jacobwilliams/nlesolver-fortran)
[![last-commit](https://img.shields.io/github/last-commit/jacobwilliams/nlesolver-fortran)](https://github.com/jacobwilliams/nlesolver-fortran/commits/master)

### Features

  * Is object-oriented.
  * Works with square, under-determined, or over-determined systems.
  * Can use different methods to solve the linear system:
    1. [LAPACK](https://www.netlib.org/lapack/) routines (`dgesv` or `dgels`) for dense systems: If `n=m`, uses `dgesv` (LU decomposition). If `n/=m`, uses `dgels` (if `m>n` uses QR factorization, if `m<n` uses LQ factorization).
    2. [lsqr](https://github.com/jacobwilliams/LSQR) -- a conjugate-gradient type method for solving sparse linear equations and sparse least-squares problems.
    3. [lusol](https://github.com/jacobwilliams/lusol) -- A sparse LU factorization for square and rectangular matrices, with Bartels-Golub-Reid updates for column replacement and other rank-1 modifications.
    4. [lsmr](https://github.com/jacobwilliams/LSMR) -- a conjugate-gradient type method for solving sparse linear equations and sparse least-squares problems
    5. The user can also provide a custom linear solver.
  * Has a Broyden update option (sparse and dense versions).
  * Has various line search options.
     * use a specified constant step size (0,1]
     * backtracking linesearch method
     * exact linesearch method using [fmin](https://github.com/jacobwilliams/fmin) minimizer
     * evaluate function at specified fixed points

### Compiling

* A [Fortran Package Manager](https://github.com/fortran-lang/fpm) file is also included, so that the library and tests cases can be compiled with FPM. For example:

```
fpm build --profile release
fpm test --profile release
```

By default, the library is built with double precision (`real64`) real values. Explicitly specifying the real kind can be done using the following preprocessor flags:

Preprocessor flag | Kind  | Number of bytes
----------------- | ----- | ---------------
`REAL32`  | `real(kind=real32)`  | 4
`REAL64`  | `real(kind=real64)`  | 8
`REAL128` | `real(kind=real128)` | 16

For example, to build a single precision version of the library, use:

```
fpm build --profile release --flag "-DREAL32"
```

To use `nlesolver` within your fpm project, add the following to your `fpm.toml` file:
```toml
[dependencies]
nlesolver-fortran = { git="https://github.com/jacobwilliams/nlesolver-fortran.git" }
```

Or to use a specific version:

```toml
[dependencies]
nlesolver-fortran = { git="https://github.com/jacobwilliams/nlesolver-fortran.git", tag="1.1.0" }
```

Note that LAPACK is required to build. The [fmin](https://github.com/jacobwilliams/fmin), [lsqr](https://github.com/jacobwilliams/LSQR), [lusol](https://github.com/jacobwilliams/lusol), and [lsmr](https://github.com/jacobwilliams/LSMR) libraries are also dependencies (which will be automatically downloaded by fpm).

### Documentation

 * The API documentation for the current ```master``` branch can be found [here](https://jacobwilliams.github.io/nlesolver-fortran/).  This is generated by processing the source files with [FORD](https://github.com/Fortran-FOSS-Programmers/ford).

### License

 * The NLESolver-Fortran source code and related files and documentation are distributed under a permissive free software [license](https://github.com/jacobwilliams/nlesolver-fortran/blob/master/LICENSE) (BSD-3).

### References

  * C. G. Broyden, "[A Class of Methods for Solving Nonlinear Simultaneous Equations](https://www.ams.org/journals/mcom/1965-19-092/S0025-5718-1965-0198670-6/S0025-5718-1965-0198670-6.pdf)", Math. Comp. 19 (1965), 577-593
  * L. K. Schubert, "[Modification of a Quasi-Newton Method for Nonlinear Equations with a Sparse Jacobian](https://www.ams.org/journals/mcom/1970-24-109/S0025-5718-1970-0258276-9/S0025-5718-1970-0258276-9.pdf)", Mathematics of Computation, Vol. 24, No. 109 (Jan., 1970), pp. 27-30.

### See also

  * [MINPACK](https://github.com/fortran-lang/minpack) -- Modernized Minpack: for solving nonlinear equations and nonlinear least squares problems
  * [LUSOL](https://web.stanford.edu/group/SOL/software/lusol/) Stanford University Systems Optimization Laboratory
  * [qr_mumps](https://gitlab.com/qr_mumps/qr_mumps) -- a software package for the solution of sparse, linear
  systems on multicore computers.

