/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import process from 'node:process';
/**
 * Detects if the CLI is running in a "headless" (non-interactive) mode.
 *
 * Headless mode is triggered by:
 * 1. process.env.CI being set to 'true'.
 * 2. process.stdout not being a TTY.
 * 3. Presence of an explicit prompt flag.
 *
 * @param options - Optional flags and arguments from the CLI.
 * @returns true if the environment is considered headless.
 */
export function isHeadlessMode(options) {
    if (process.env['GEMINI_CLI_INTEGRATION_TEST'] === 'true') {
        return (!!options?.prompt ||
            (!!process.stdin && !process.stdin.isTTY) ||
            (!!process.stdout && !process.stdout.isTTY));
    }
    return (process.env['CI'] === 'true' ||
        process.env['GITHUB_ACTIONS'] === 'true' ||
        !!options?.prompt ||
        (!!process.stdin && !process.stdin.isTTY) ||
        (!!process.stdout && !process.stdout.isTTY));
}
//# sourceMappingURL=headless.js.map