/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.GroupPath;

public class SubDataFieldLocation
extends CodeUnitLocation {
    private String rep;
    private String fieldName;

    public SubDataFieldLocation(Program program, Address addr, GroupPath path, int[] componentPath, Address refAddr, String rep, int charOffset, String fieldName) {
        super(program, addr, componentPath, refAddr, 0, 0, charOffset);
        this.rep = rep;
        this.fieldName = fieldName;
    }

    public SubDataFieldLocation() {
    }

    public String getDataRepresentation() {
        return this.rep;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String toString() {
        return super.toString() + ", OpRep = " + this.rep + ", Field Name = " + this.fieldName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubDataFieldLocation other = (SubDataFieldLocation)obj;
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        return !(this.rep == null ? other.rep != null : !this.rep.equals(other.rep));
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.rep = obj.getString("_REP", "");
        this.fieldName = obj.getString("_FIELDNAME", "");
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_REP", this.rep);
        obj.putString("_FIELDNAME", this.fieldName);
    }
}

