/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.program.model.lang.Language;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.Step;
import ghidra.trace.model.time.schedule.TraceSchedule;
import java.util.List;

public abstract class AbstractStep
implements Step {
    protected final long threadKey;
    protected long tickCount;

    protected AbstractStep(long threadKey, long tickCount) {
        if (tickCount < 0L) {
            throw new IllegalArgumentException("Cannot step a negative number");
        }
        this.threadKey = threadKey;
        this.tickCount = tickCount;
    }

    protected abstract String toStringStepPart(TraceSchedule.TimeRadix var1);

    public String toString() {
        return this.toString(TraceSchedule.TimeRadix.DEFAULT);
    }

    @Override
    public String toString(TraceSchedule.TimeRadix radix) {
        if (this.threadKey == -1L) {
            return this.toStringStepPart(radix);
        }
        return String.format("t%d-%s", this.threadKey, this.toStringStepPart(radix));
    }

    @Override
    public boolean isNop() {
        return this.tickCount == 0L;
    }

    @Override
    public long getThreadKey() {
        return this.threadKey;
    }

    @Override
    public long getTickCount() {
        return this.tickCount;
    }

    @Override
    public long getPatchCount() {
        return 0L;
    }

    @Override
    public abstract AbstractStep clone();

    public void advance(long steps) {
        if (steps < 0L) {
            throw new IllegalArgumentException("Cannot advance a negative number");
        }
        long newCount = this.tickCount + steps;
        if (newCount < 0L) {
            throw new IllegalArgumentException("Total step count exceeds LONG_MAX");
        }
        this.tickCount = newCount;
    }

    @Override
    public long rewind(long steps) {
        if (steps < 0L) {
            throw new IllegalArgumentException("Cannot rewind a negative number");
        }
        long diff = this.tickCount - steps;
        this.tickCount = Long.max(0L, diff);
        return -diff;
    }

    @Override
    public boolean isCompatible(Step step) {
        if (step.getClass() != this.getClass()) {
            return false;
        }
        AbstractStep as = (AbstractStep)step;
        return this.threadKey == as.threadKey || as.threadKey == -1L;
    }

    @Override
    public void addTo(Step step) {
        assert (this.isCompatible(step));
        AbstractStep as = (AbstractStep)step;
        this.advance(as.tickCount);
    }

    public int hashCode() {
        return Long.hashCode(this.threadKey) * 31 + Long.hashCode(this.tickCount);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractStep that = (AbstractStep)obj;
        if (this.threadKey != that.threadKey) {
            return false;
        }
        return this.tickCount == that.tickCount;
    }

    @Override
    public CompareResult compareStep(Step step) {
        CompareResult result = this.compareStepType(step);
        if (result != CompareResult.EQUALS) {
            return result;
        }
        AbstractStep that = (AbstractStep)step;
        result = CompareResult.unrelated(Long.compare(this.threadKey, that.threadKey));
        if (result != CompareResult.EQUALS) {
            return result;
        }
        result = CompareResult.related(Long.compare(this.tickCount, that.tickCount));
        if (result != CompareResult.EQUALS) {
            return result;
        }
        return CompareResult.EQUALS;
    }

    @Override
    public long coalescePatches(Language language, List<Step> steps) {
        return 0L;
    }
}

