/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class UuidCommand
extends LoadCommand {
    private byte[] uuid;

    UuidCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.uuid = reader.readNextByteArray(16);
    }

    public byte[] getUUID() {
        return this.uuid;
    }

    @Override
    public String getCommandName() {
        return "uuid_command";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add((DataType)new ArrayDataType(BYTE, 16, BYTE.getLength()), "uuid", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

