/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PascalString255DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class OmfString
implements StructConverter {
    private int length;
    private String str;

    public OmfString(int length, String str) {
        this.length = length;
        this.str = str;
    }

    public int length() {
        return this.length;
    }

    public String str() {
        return this.str;
    }

    public int getDataTypeSize() {
        return BYTE.getLength() + this.length;
    }

    public String toString() {
        return this.str;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        if (this.length == 0) {
            return BYTE;
        }
        return new PascalString255DataType();
    }
}

