/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.oatdexfile;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.bundle.OatBundle;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile_KitKat;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile_Lollipop;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile_Marshmallow;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile_Nougat;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile_Oreo;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile_OreoM2;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile_Pie;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile_Q;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile_R;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile_S_T;
import java.io.IOException;

public final class OatDexFileFactory {
    public static final OatDexFile getOatDexFile(BinaryReader reader, String oatVersion, OatBundle bundle) throws IOException {
        switch (oatVersion) {
            case "007": {
                return new OatDexFile_KitKat(reader);
            }
            case "039": 
            case "045": 
            case "051": {
                return new OatDexFile_Lollipop(reader);
            }
            case "064": {
                return new OatDexFile_Marshmallow(reader);
            }
            case "079": 
            case "088": {
                return new OatDexFile_Nougat(reader);
            }
            case "124": 
            case "126": {
                return new OatDexFile_Oreo(reader, bundle);
            }
            case "131": {
                return new OatDexFile_OreoM2(reader, bundle);
            }
            case "138": {
                return new OatDexFile_Pie(reader, bundle);
            }
            case "170": {
                return new OatDexFile_Q(reader, bundle);
            }
            case "183": {
                return new OatDexFile_R(reader, bundle);
            }
            case "195": 
            case "199": 
            case "220": 
            case "223": 
            case "225": {
                return new OatDexFile_S_T(reader, bundle);
            }
        }
        throw new IOException("Unsupported OAT version: " + oatVersion);
    }
}

