/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import generic.json.Json;
import ghidra.framework.options.SaveState;
import java.util.Objects;

public class DtTypeFilter {
    private static final String IS_TYPE_ACTIVE_KEY = "IS_TYPE_ACTIVE";
    private static final String IS_TYPE_DEF_ACTIVE_KEY = "IS_TYPE_DEF_ACTIVE";
    private String name;
    private boolean isTypeActive = true;
    private boolean isTypeDefActive = true;

    static DtTypeFilter restore(String typeName, SaveState ss) {
        if (ss == null) {
            return new DtTypeFilter(typeName);
        }
        return new DtTypeFilter(ss);
    }

    DtTypeFilter(String name) {
        this.name = name;
    }

    private DtTypeFilter(SaveState ss) {
        this.name = ss.getName();
        this.isTypeActive = ss.getBoolean(IS_TYPE_ACTIVE_KEY, true);
        this.isTypeDefActive = ss.getBoolean(IS_TYPE_DEF_ACTIVE_KEY, true);
    }

    SaveState save() {
        SaveState ss = new SaveState(this.name);
        ss.putBoolean(IS_TYPE_ACTIVE_KEY, this.isTypeActive);
        ss.putBoolean(IS_TYPE_DEF_ACTIVE_KEY, this.isTypeDefActive);
        return ss;
    }

    DtTypeFilter copy() {
        DtTypeFilter filter = new DtTypeFilter(this.name);
        filter.isTypeActive = this.isTypeActive;
        filter.isTypeDefActive = this.isTypeDefActive;
        return filter;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTypeActive() {
        return this.isTypeActive;
    }

    public boolean isTypeDefActive() {
        return this.isTypeDefActive;
    }

    public void setTypeActive(boolean b) {
        this.isTypeActive = b;
    }

    public void setTypeDefActive(boolean b) {
        this.isTypeDefActive = b;
    }

    public String toString() {
        return Json.toString((Object)this);
    }

    public int hashCode() {
        return Objects.hash(this.isTypeActive, this.isTypeDefActive, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DtTypeFilter other = (DtTypeFilter)obj;
        return this.isTypeActive == other.isTypeActive && this.isTypeDefActive == other.isTypeDefActive && Objects.equals(this.name, other.name);
    }
}

