/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.program.model.pcode.AttributeId;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlMessageLog;
import ghidra.xml.XmlPullParser;
import java.util.HexFormat;

public class DecompileDebugByteManager {
    TaskMonitor monitor;
    Program prog;
    String programName;

    public DecompileDebugByteManager(TaskMonitor monitor, Program prog, String programName) {
        this.monitor = monitor;
        this.prog = prog;
        this.programName = programName;
    }

    public void parse(XmlPullParser parser, XmlMessageLog log) {
        while (parser.peek().getName().equals("bytechunk") && !this.monitor.isCancelled()) {
            this.processByteChunk(parser, log);
        }
    }

    private void processByteChunk(XmlPullParser parser, XmlMessageLog log) {
        XmlElement byteChunkElement = parser.start(new String[]{"bytechunk"});
        Address address = this.prog.getAddressFactory().getAddress(byteChunkElement.getAttribute(AttributeId.ATTRIB_OFFSET.name()));
        byteChunkElement = parser.end(byteChunkElement);
        String hexString = byteChunkElement.getText().trim().replaceAll("\n", "");
        byte[] rawBytes = HexFormat.of().parseHex(hexString);
        if (!this.generateMemoryChunk(rawBytes, address, log)) {
            log.appendMsg("Error attempting to load memory chunk");
        }
    }

    private boolean generateMemoryChunk(byte[] rawBytes, Address address, XmlMessageLog log) {
        Memory memory = this.prog.getMemory();
        try {
            memory.createInitializedBlock(this.programName, address, (long)rawBytes.length, (byte)0, this.monitor, false);
            memory.setBytes(address, rawBytes);
        }
        catch (LockException | AddressOverflowException | MemoryAccessException | MemoryConflictException | CancelledException | IllegalArgumentException e) {
            log.appendException(e);
            return false;
        }
        return true;
    }
}

