/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BootImage
implements StructConverter {
    private String magic;
    private int kernelSize;
    private int kernelAddress;
    private int ramDiskSize;
    private int ramDiskAddress;
    private int secondStageSize;
    private int secondStageAddress;
    private int tagsAddress;
    private int pageSize;
    private int[] unused;
    private String name;
    private String commandLine;
    private int[] id;

    public BootImage(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public BootImage(BinaryReader reader) throws IOException {
        this.magic = reader.readNextAsciiString(8);
        this.kernelSize = reader.readNextInt();
        this.kernelAddress = reader.readNextInt();
        this.ramDiskSize = reader.readNextInt();
        this.ramDiskAddress = reader.readNextInt();
        this.secondStageSize = reader.readNextInt();
        this.secondStageAddress = reader.readNextInt();
        this.tagsAddress = reader.readNextInt();
        this.pageSize = reader.readNextInt();
        this.unused = reader.readNextIntArray(2);
        this.name = reader.readNextAsciiString(16);
        this.commandLine = reader.readNextAsciiString(512);
        this.id = reader.readNextIntArray(8);
    }

    public String getMagic() {
        return this.magic;
    }

    public int getKernelSize() {
        return this.kernelSize;
    }

    public int getKernelAddress() {
        return this.kernelAddress;
    }

    public int getKernelOffset() {
        return this.getPageSize();
    }

    public int getKernelSizePageAligned() {
        int remainder = this.getPageSize() - this.getKernelSize() % this.getPageSize();
        return this.getKernelSize() + remainder;
    }

    public int getRamDiskSize() {
        return this.ramDiskSize;
    }

    public int getRamDiskAddress() {
        return this.ramDiskAddress;
    }

    public int getRamDiskOffset() {
        return this.getKernelOffset() + this.getKernelSizePageAligned();
    }

    public int getRamDiskSizePageAligned() {
        int remainder = this.getPageSize() - this.getRamDiskSize() % this.getPageSize();
        return this.getRamDiskSize() + remainder;
    }

    public int getSecondStageSize() {
        return this.secondStageSize;
    }

    public int getSecondStageAddress() {
        return this.secondStageAddress;
    }

    public int getSecondStageOffset() {
        return this.getRamDiskOffset() + this.getRamDiskSizePageAligned() * this.getPageSize();
    }

    public int getSecondStageSizePageAligned() {
        int remainder = this.getPageSize() - this.getSecondStageSize() % this.getPageSize();
        return this.getSecondStageSize() + remainder;
    }

    public int getTagsAddress() {
        return this.tagsAddress;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int[] getUnused() {
        return this.unused;
    }

    public String getName() {
        return this.name;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public int[] getId() {
        return this.id;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("boot_img_hdr", 0);
        structure.add(UTF8, 8, "magic", null);
        structure.add(DWORD, "kernelSize", null);
        structure.add(DWORD, "kernelAddress", null);
        structure.add(DWORD, "ramDiskSize", null);
        structure.add(DWORD, "ramDiskAddress", null);
        structure.add(DWORD, "secondStageSize", null);
        structure.add(DWORD, "secondStageAddress", null);
        structure.add(DWORD, "tagsAddress", null);
        structure.add(DWORD, "pageSize", null);
        structure.add((DataType)new ArrayDataType(DWORD, 2, DWORD.getLength()), "unused", null);
        structure.add(UTF8, 16, "name", null);
        structure.add(UTF8, 512, "commandLine", null);
        structure.add((DataType)new ArrayDataType(DWORD, 8, DWORD.getLength()), "id", null);
        return structure;
    }
}

