/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import java.util.function.Supplier;
import org.jetbrains.kotlin.com.intellij.openapi.application.CachedSingletonsRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;

public final class StandardFileSystems {
    public static final String FILE_PROTOCOL = "file";
    public static final String FILE_PROTOCOL_PREFIX = "file://";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_PROTOCOL_PREFIX = "jar://";
    public static final String JRT_PROTOCOL = "jrt";
    public static final String JRT_PROTOCOL_PREFIX = "jrt://";
    private static final Supplier<VirtualFileSystem> ourLocal = CachedSingletonsRegistry.lazy(() -> VirtualFileManager.getInstance().getFileSystem(FILE_PROTOCOL));
    private static final Supplier<VirtualFileSystem> ourJar = CachedSingletonsRegistry.lazy(() -> VirtualFileManager.getInstance().getFileSystem(JAR_PROTOCOL));

    public static VirtualFileSystem local() {
        return ourLocal.get();
    }

    public static VirtualFileSystem jar() {
        return ourJar.get();
    }
}

