/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.twitter;

import java.util.List;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.sdk.twitter.TwitterException;
import org.jreleaser.util.StringUtils;
import twitter4j.Twitter;
import twitter4j.v1.Status;
import twitter4j.v1.StatusUpdate;
import twitter4j.v1.TwitterV1;

public class Twitter {
    private final JReleaserLogger logger;
    private final boolean dryrun;
    private final TwitterV1 twitter;

    public Twitter(JReleaserLogger logger, int connectTimeout, int readTimeout, String consumerKey, String consumerToken, String accessToken, String accessTokenSecret, boolean dryrun) {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)consumerKey, (String)"'consumerKey' must not be blank");
        StringUtils.requireNonBlank((String)consumerToken, (String)"'consumerToken' must not be blank");
        StringUtils.requireNonBlank((String)accessToken, (String)"'accessToken' must not be blank");
        StringUtils.requireNonBlank((String)accessTokenSecret, (String)"'accessTokenSecret' must not be blank");
        this.logger = logger;
        this.dryrun = dryrun;
        this.twitter = ((Twitter.TwitterBuilder)((Twitter.TwitterBuilder)((Twitter.TwitterBuilder)((Twitter.TwitterBuilder)twitter4j.Twitter.newBuilder().oAuthConsumer(consumerKey, consumerToken)).oAuthAccessToken(accessToken, accessTokenSecret)).httpConnectionTimeout(connectTimeout * 1000)).httpReadTimeout(readTimeout * 1000)).build().v1();
        this.logger.debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void updateStatus(List<String> statuses) throws TwitterException {
        this.wrap(() -> {
            Status status = this.twitter.tweets().updateStatus((String)statuses.get(0));
            for (int i = 1; i < statuses.size(); ++i) {
                status = this.twitter.tweets().updateStatus(StatusUpdate.of((String)((String)statuses.get(i))).inReplyToStatusId(status.getId()));
            }
        });
    }

    private void wrap(TwitterOperation op) throws TwitterException {
        try {
            if (!this.dryrun) {
                op.execute();
            }
        }
        catch (twitter4j.TwitterException e) {
            this.logger.trace((Throwable)e);
            throw new TwitterException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Twitter"}), e);
        }
    }

    private static interface TwitterOperation {
        public void execute() throws twitter4j.TwitterException;
    }
}

