/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.MetaClass;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.api.Access;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.runtime.ThreadContext;

public interface Compilable<T> {
    public void setCallCount(int var1);

    @Deprecated(since="10.0")
    default public void completeBuild(T buildResult) {
        this.completeBuild(this.getImplementationClass().getCurrentContext(), buildResult);
    }

    default public void completeBuild(ThreadContext context, T buildResult) {
        this.completeBuild(buildResult);
    }

    default public boolean forceBuild(ThreadContext context) {
        return false;
    }

    default public boolean isBuildComplete() {
        return true;
    }

    public IRScope getIRScope();

    public InterpreterContext ensureInstrsReady();

    @Deprecated(since="10.0")
    default public String getOwnerName() {
        return this.getOwnerName(this.getImplementationClass().getCurrentContext());
    }

    default public String getOwnerName(ThreadContext context) {
        RubyModule implClass = this.getImplementationClass();
        return implClass == null ? null : Compilable.resolveFullName(context, implClass);
    }

    public String getName();

    public String getFile();

    public int getLine();

    public RubyModule getImplementationClass();

    @Deprecated
    default public String getClassName(ThreadContext context) {
        return this.getOwnerName(context);
    }

    public static String resolveFullName(ThreadContext context, RubyModule implementationClass) {
        if (implementationClass.isSingleton()) {
            MetaClass metaClass = (MetaClass)implementationClass;
            RubyClass realClass = metaClass.getRealClass();
            return realClass == Access.classClass(context) ? ((RubyClass)metaClass.getAttached()).getName(context) : realClass.getName(context);
        }
        return implementationClass.getName(context);
    }
}

