# v6.0

Despite this being a new major version release, it is a vary minor update. Aside from a handful of bugfixes, the most significant change is notice of deprecation for `=`, `let`, and `?`.

## Breaking Changes

None

## Deprecation Warnings

Please read out [compatibility commitment](https://murex.rocks/compatibility.html) to understand how features are deprecated.

* the `?` pipe will be deprecated to make way for a the ternary operator. You can achieve the same result with `<err> <!out>`, eg `command <err> <!out> parameters... | next-command ...`
  
* the `=` and `let` builtins are now officially deprecated. They've been marked as deprecated in the documentation for a couple of years but you'll now receive a deprecation warning when using them. This warning will not impact any functions that call them (they bypass the stdout and stderr pipes and write directly to your TTY) but it is still recommended that you update any existing code not to use it. The change is very simple, Murex supported expressions as first class primitives, so you can simply drop the `=` and `let` command names from your expressions

## Features

Features marked as **EXPERIMENTAL** are provided without assurances of future breaking changes. All other features are considered stable as part of Murex's [compatibility commitment](https://murex.rocks/compatibility.html).

* new integrations for the experimental `mxtty` terminal emulator ([Github repo](https://github.com/lmorg/mxtty))

## Bug Fixes

* `which` and `whereis` autocompletions were Linux specific. Now they're enabled for all platforms

* `grep` and `egrep` aliases were Linux specific. Now they're enabled for all POSIX platforms

* zero length environment variables are no longer being reported as `null` by `is-null` ([issue #786](https://github.com/lmorg/murex/issues/786))

* fixed edge case where a zero length string could generate a panic when normalising paths ([issue #789](https://github.com/lmorg/murex/issues/789))

* suppress sqlite3 cache error message. The error doesn't impact the operation of Murex, it just spooks users ([issue #788](https://github.com/lmorg/murex/issues/788))
  
## Special Thanks

Special thank yous for this release goes to everyone in the discussions group for raising bug reports and their design discussions.

You rock!

<hr>

Published: 17.02.2024 at 20:47

## See Also

* [Define Environmental Variable: `export`](../commands/export.md):
  Define an environmental variable and set it's value
* [How To Contribute](../Murex/CONTRIBUTING.md):
  Murex is community project. We gratefully accept contributions
* [Is Value Null: `is-null`](../commands/is-null.md):
  Checks if a variable is null or undefined
* [Shell Configuration And Settings: `config`](../commands/config.md):
  Query or define Murex runtime settings
* [Shell Runtime: `runtime`](../commands/runtime.md):
  Returns runtime information on the internal state of Murex
* [Tab Autocompletion: `autocomplete`](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line

<hr/>

This document was generated from [gen/changelog/v6.0_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v6.0_doc.yaml).