" Vim syntax file

" #############################################################################
" #############################################################################
" Note: Be careful when merging the upstream version of this file.
"       Much of this is generated by scripts/genvimvim.lua
"       (installs to $VIMRUNTIME/syntax/vim/generated.vim)
" #############################################################################
" #############################################################################

" Quit when a syntax file was already loaded {{{1
if exists("b:current_syntax")
  finish
endif
let s:keepcpo = &cpo
set cpo&vim

" Feature testing {{{1

let s:vim9script = "\n" .. getline(1, 32)->join("\n") =~# '\n\s*vim9\%[script]\>'

function s:has(feature)
  return has(a:feature) || index(get(g:, "vimsyn_vim_features", []), a:feature) != -1
endfunction

" Automatically generated keyword lists: {{{1

" vimTodo: contains common special-notices for comments {{{2
" Use the vimCommentGroup cluster to add your own.
syn keyword vimTodo contained	COMBAK	FIXME	TODO	XXX
syn cluster vimCommentGroup	contains=vimTodo,@Spell

" Lower priority :syn-match to allow for :command/function() distinction
syn match vimCommand "\<chd\%[ir]\>"    nextgroup=vimBang
syn match vimCommand "\<co\%[py]\>"     nextgroup=vimBang
syn match vimCommand "\<d\%[elete]\>"   nextgroup=vimBang
syn match vimCommand "\<j\%[oin]\>"     nextgroup=vimBang
syn match vimCommand "\<sp\%[lit]\>"    nextgroup=vimBang
syn match vimCommand "\<sw\%[apname]\>" nextgroup=vimBang

" GEN_SYN_VIM: vimCommand modifier, START_STR='syn keyword vimCommandModifier', END_STR='skipwhite nextgroup=vimCommandModifierBang,@vimCmdList'
syn keyword vimCommandModifier abo[veleft] bel[owright] bo[tright] hid[e] hor[izontal] kee[pmarks] keepj[umps] keepp[atterns] keepa[lt] lefta[bove] leg[acy] loc[kmarks] noa[utocmd] nos[wapfile] rightb[elow] san[dbox] sil[ent] tab to[pleft] uns[ilent] verb[ose] vert[ical] vim9[cmd] skipwhite nextgroup=vimCommandModifierBang,@vimCmdList
" :filter is handled specially elsewhere
syn match	vimCommandModifierBang	contained	"\a\@1<=!"	skipwhite nextgroup=@vimCmdList

" Lower priority :syn-match to allow for :command/function() distinction
syn match vimCommand "\<bro\%[wse]\>"  skipwhite nextgroup=vimCommandModifierBang,@vimCmdList
syn match vimCommand "\<conf\%[irm]\>" skipwhite nextgroup=vimCommandModifierBang,@vimCmdList

" Special and plugin vim commands {{{2
syn match   vimCommand contained	"\<z[-+^.=]\=\>"
syn keyword vimOnlyCommand contained	fix[del] op[en] sh[ell] P[rint]
syn keyword vimStdPlugin contained	Arguments Asm Break Cfilter Clear Continue DiffOrig Evaluate Finish Gdb Lfilter Man Over Program Run S Source Step Stop Termdebug TermdebugCommand TOhtml Until Winbar XMLent XMLns

" Vim-specific options {{{2
syn keyword vimOnlyOption contained	biosk bioskey cp compatible consk conskey cm cryptmethod edcompatible guipty key macatsui mzq mzquantum osfiletype oft renderoptions rop st shelltype sn shortname tenc termencoding ta textauto tx textmode tf ttyfast ttym ttymouse tbi ttybuiltin wiv weirdinvert
" Turn-off setting variants
syn keyword vimOnlyOption contained	nobiosk nobioskey noconsk noconskey nocp nocompatible noguipty nomacatsui nosn noshortname nota notextauto notx notextmode notf nottyfast notbi nottybuiltin nowiv noweirdinvert
" Invertible setting variants
syn keyword vimOnlyOption contained	invbiosk invbioskey invconsk invconskey invcp invcompatible invguipty invmacatsui invsn invshortname invta invtextauto invtx invtextmode invtf invttyfast invtbi invttybuiltin invwiv invweirdinvert
" termcap codes (which can also be set) {{{2
" GEN_SYN_VIM: vimOption term output code, START_STR='syn keyword vimOption contained', END_STR='skipwhite nextgroup=vimSetEqual,vimSetMod'
syn keyword vimOption contained t_AB t_AF t_AU t_AL t_al t_bc t_BE t_BD t_cd t_ce t_Ce t_CF t_cl t_cm t_Co t_CS t_Cs t_cs t_CV t_da t_db t_DL t_dl t_ds t_Ds t_EC t_EI t_fs t_fd t_fe t_GP t_IE t_IS t_ke t_ks t_le t_mb t_md t_me t_mr t_ms t_nd t_op t_RF t_RB t_RC t_RI t_Ri t_RK t_RS t_RT t_RV t_Sb t_SC t_se t_Sf t_SH t_SI t_Si t_so t_SR t_sr t_ST t_Te t_te t_TE t_ti t_TI t_Ts t_ts t_u7 t_ue t_us t_Us t_ut t_vb t_ve t_vi t_VS t_vs t_WP t_WS t_XM t_xn t_xs t_ZH t_ZR t_8f t_8b t_8u t_xo skipwhite nextgroup=vimSetEqual,vimSetMod
" term key codes
syn keyword vimOption contained	t_F1 t_F2 t_F3 t_F4 t_F5 t_F6 t_F7 t_F8 t_F9 t_k1 t_K1 t_k2 t_k3 t_K3 t_k4 t_K4 t_k5 t_K5 t_k6 t_K6 t_k7 t_K7 t_k8 t_K8 t_k9 t_K9 t_KA t_kb t_kB t_KB t_KC t_kd t_kD t_KD t_KE t_KF t_KG t_kh t_KH t_kI t_KI t_KJ t_KK t_kl t_KL t_kN t_kP t_kr t_ku
syn match   vimTermOption contained	"t_%1"
syn match   vimTermOption contained	"t_#2"
syn match   vimTermOption contained	"t_#4"
syn match   vimTermOption contained	"t_@7"
syn match   vimTermOption contained	"t_*7"
syn match   vimTermOption contained	"t_&8"
syn match   vimTermOption contained	"t_%i"
syn match   vimTermOption contained	"t_k;"

" vimOptions: These are the variable names {{{2
" GEN_SYN_VIM: vimOption term output code variable, START_STR='syn keyword vimOptionVarName contained', END_STR=''
syn keyword vimOptionVarName contained t_AB t_AF t_AU t_AL t_al t_bc t_BE t_BD t_cd t_ce t_Ce t_CF t_cl t_cm t_Co t_CS t_Cs t_cs t_CV t_da t_db t_DL t_dl t_ds t_Ds t_EC t_EI t_fs t_fd t_fe t_GP t_IE t_IS t_ke t_ks t_le t_mb t_md t_me t_mr t_ms t_nd t_op t_RF t_RB t_RC t_RI t_Ri t_RK t_RS t_RT t_RV t_Sb t_SC t_se t_Sf t_SH t_SI t_Si t_so t_SR t_sr t_ST t_Te t_te t_TE t_ti t_TI t_Ts t_ts t_u7 t_ue t_us t_Us t_ut t_vb t_ve t_vi t_VS t_vs t_WP t_WS t_XM t_xn t_xs t_ZH t_ZR t_8f t_8b t_8u t_xo
syn keyword vimOptionVarName contained	t_F1 t_F2 t_F3 t_F4 t_F5 t_F6 t_F7 t_F8 t_F9 t_k1 t_K1 t_k2 t_k3 t_K3 t_k4 t_K4 t_k5 t_K5 t_k6 t_K6 t_k7 t_K7 t_k8 t_K8 t_k9 t_K9 t_KA t_kb t_kB t_KB t_KC t_kd t_kD t_KD t_KE t_KF t_KG t_kh t_KH t_kI t_KI t_KJ t_KK t_kl t_KL t_kN t_kP t_kr t_ku
syn match   vimOptionVarName contained	"t_%1"
syn match   vimOptionVarName contained	"t_#2"
syn match   vimOptionVarName contained	"t_#4"
syn match   vimOptionVarName contained	"t_@7"
syn match   vimOptionVarName contained	"t_*7"
syn match   vimOptionVarName contained	"t_&8"
syn match   vimOptionVarName contained	"t_%i"
syn match   vimOptionVarName contained	"t_k;"

" unsupported settings: these are supported by vi but don't do anything in vim {{{2
" GEN_SYN_VIM: Missing vimOption, START_STR='syn keyword vimErrSetting contained', END_STR=''
syn keyword vimErrSetting contained akm altkeymap anti antialias ap autoprint bf beautify biosk bioskey consk conskey fk fkmap fl flash gr graphic ht hardtabs macatsui mesg novice open opt optimize oft osfiletype redraw slow slowopen sourceany w1200 w300 w9600
syn keyword vimErrSetting contained noakm noaltkeymap noanti noantialias noap noautoprint nobf nobeautify nobiosk nobioskey noconsk noconskey nofk nofkmap nofl noflash nogr nographic nomacatsui nomesg nonovice noopen noopt nooptimize noredraw noslow noslowopen nosourceany
syn keyword vimErrSetting contained invakm invaltkeymap invanti invantialias invap invautoprint invbf invbeautify invbiosk invbioskey invconsk invconskey invfk invfkmap invfl invflash invgr invgraphic invmacatsui invmesg invnovice invopen invopt invoptimize invredraw invslow invslowopen invsourceany

 " AutoCmd Events {{{2
syn case ignore

syn keyword	vimAutoEvent	contained	User	skipwhite nextgroup=vimUserAutoEvent
syn match	vimUserAutoEvent	contained	"\<\h\w*\>"	skipwhite nextgroup=vimUserAutoEventSep,vimAutocmdMod,vimAutocmdBlock

" Highlight commonly used Groupnames {{{2
" GEN_SYN_VIM: vimGroup, START_STR='syn keyword vimGroup contained', END_STR=''
syn keyword vimGroup contained Added Bold BoldItalic Boolean Changed Character Comment Conditional Constant Debug Define Delimiter Error Exception Float Function Identifier Ignore Include Italic Keyword Label Macro Number Operator PreCondit PreProc Removed Repeat Special SpecialChar SpecialComment Statement StorageClass String Structure Tag Todo Type Typedef Underlined

" Default highlighting groups {{{2
" GEN_SYN_VIM: vimHLGroup, START_STR='syn keyword vimHLGroup contained', END_STR=''
syn keyword vimHLGroup contained ErrorMsg IncSearch ModeMsg NonText StatusLine StatusLineNC EndOfBuffer VertSplit DiffText DiffTextAdd PmenuSbar TabLineSel TabLineFill Cursor lCursor QuickFixLine CursorLineSign CursorLineFold CurSearch PmenuKind PmenuKindSel PmenuMatch PmenuMatchSel PmenuExtra PmenuExtraSel Normal Directory LineNr CursorLineNr MoreMsg Question Search SpellBad SpellCap SpellRare SpellLocal PmenuThumb Pmenu PmenuSel SpecialKey Title WarningMsg WildMenu Folded FoldColumn SignColumn Visual DiffAdd DiffChange DiffDelete TabLine CursorColumn CursorLine ColorColumn MatchParen StatusLineTerm StatusLineTermNC CursorIM
syn keyword vimHLGroup contained ComplMatchIns LineNrAbove LineNrBelow MsgArea User1 User2 User3 User4 User5 User6 User7 User8 User9
syn match vimHLGroup contained "\<Conceal\>"
syn keyword vimOnlyHLGroup contained	Menu PopupSelected MessageWindow PopupNotification Scrollbar Terminal ToolbarButton ToolbarLine Tooltip VisualNOS
syn keyword nvimHLGroup contained	FloatBorder FloatFooter FloatTitle MsgSeparator NormalFloat NormalNC Substitute TermCursor VisualNC Whitespace WinBar WinBarNC WinSeparator
"}}}2
syn case match

" Special Vim Highlighting (not automatic) {{{1

" Set up commands for this syntax highlighting file {{{2

com! -nargs=* Vim9 execute <q-args> s:vim9script ? "" : "contained"
com! -nargs=* VimL execute <q-args> s:vim9script ? "contained" : ""

if exists("g:vimsyn_folding") && g:vimsyn_folding =~# '[acefhiHlmpPrt]'
 if g:vimsyn_folding =~# 'a'
  com! -nargs=* VimFolda <args> fold
 else
  com! -nargs=* VimFolda <args>
 endif
 if g:vimsyn_folding =~# 'c'
  com! -nargs=* VimFoldc <args> fold
 else
  com! -nargs=* VimFoldc <args>
 endif
 if g:vimsyn_folding =~# 'e'
  com! -nargs=* VimFolde <args> fold
 else
  com! -nargs=* VimFolde <args>
 endif
 if g:vimsyn_folding =~# 'f'
  com! -nargs=* VimFoldf <args> fold
 else
  com! -nargs=* VimFoldf <args>
 endif
 if g:vimsyn_folding =~# 'h'
  com! -nargs=* VimFoldh <args> fold
 else
  com! -nargs=* VimFoldh <args>
 endif
 if g:vimsyn_folding =~# 'H'
  com! -nargs=* VimFoldH <args> fold
 else
  com! -nargs=* VimFoldH <args>
 endif
 if g:vimsyn_folding =~# 'i'
  com! -nargs=* VimFoldi <args> fold
 else
  com! -nargs=* VimFoldi <args>
 endif
 if g:vimsyn_folding =~# 'l'
  com! -nargs=* VimFoldl <args> fold
 else
  com! -nargs=* VimFoldl <args>
 endif
 if g:vimsyn_folding =~# 'm'
  com! -nargs=* VimFoldm <args> fold
 else
  com! -nargs=* VimFoldm <args>
 endif
 if g:vimsyn_folding =~# 'p'
  com! -nargs=* VimFoldp <args> fold
 else
  com! -nargs=* VimFoldp <args>
 endif
 if g:vimsyn_folding =~# 'P'
  com! -nargs=* VimFoldP <args> fold
 else
  com! -nargs=* VimFoldP <args>
 endif
 if g:vimsyn_folding =~# 'r'
  com! -nargs=* VimFoldr <args> fold
 else
  com! -nargs=* VimFoldr <args>
 endif
 if g:vimsyn_folding =~# 't'
  com! -nargs=* VimFoldt <args> fold
 else
  com! -nargs=* VimFoldt <args>
 endif
else
 com! -nargs=*	VimFolda	<args>
 com! -nargs=*	VimFoldc	<args>
 com! -nargs=*	VimFolde	<args>
 com! -nargs=*	VimFoldf	<args>
 com! -nargs=*	VimFoldi	<args>
 com! -nargs=*	VimFoldh	<args>
 com! -nargs=*	VimFoldH	<args>
 com! -nargs=*	VimFoldl	<args>
 com! -nargs=*	VimFoldm	<args>
 com! -nargs=*	VimFoldp	<args>
 com! -nargs=*	VimFoldP	<args>
 com! -nargs=*	VimFoldr	<args>
 com! -nargs=*	VimFoldt	<args>
endif

" Deprecated variable options {{{2
if exists("g:vim_minlines")
 let g:vimsyn_minlines= g:vim_minlines
endif
if exists("g:vim_maxlines")
 let g:vimsyn_maxlines= g:vim_maxlines
endif
if exists("g:vimsyntax_noerror")
 let g:vimsyn_noerror= g:vimsyntax_noerror
endif

" Nulls {{{2
" =====
Vim9 syn keyword  vim9Null	null null_blob null_channel null_class null_dict null_function null_job null_list null_object null_partial null_string

" Booleans {{{2
" ========
Vim9 syn keyword vim9Boolean	true false

" Numbers {{{2
" =======
syn case ignore
syn match	vimNumber	"\<\d\+\%('\d\+\)*"		skipwhite nextgroup=@vimComment,vimSubscript,vimGlobal,vimSubst1
syn match	vimNumber	"\<\d\+\%('\d\+\)*\.\d\+\%(e[+-]\=\d\+\)\="	skipwhite nextgroup=@vimComment
syn match	vimNumber	"\<0b[01]\+\%('[01]\+\)*"		skipwhite nextgroup=@vimComment,vimSubscript
syn match	vimNumber	"\<0o\=\o\+\%('\o\+\)*"		skipwhite nextgroup=@vimComment,vimSubscript
syn match	vimNumber	"\<0x\x\+\%('\x\+\)*"		skipwhite nextgroup=@vimComment,vimSubscript
syn match	vimNumber	'\<0z\>'			skipwhite nextgroup=@vimComment
syn match	vimNumber	'\<0z\%(\x\x\)\+\%(\.\%(\x\x\)\+\)*'	skipwhite nextgroup=@vimComment,vimSubscript
syn case match

" All vimCommands are contained by vimIsCommand. {{{2
syn cluster vimCmdList	contains=vimAbb,vimAddress,vimAutocmd,vimAugroup,vimBehave,vimCall,vimCatch,vimCommandModifier,vimConst,vimDoautocmd,vimDebuggreedy,vimDef,vimDefFold,vimDefer,vimDelcommand,vimDelFunction,@vimEcho,vimElse,vimEnddef,vimEndfunction,vimEndif,vimEval,vimExecute,vimIsCommand,vimExtCmd,vimExFilter,vimExMark,vimFiletype,vimFor,vimFunction,vimFunctionFold,vimGrep,vimGrepAdd,vimGlobal,vimHelpgrep,vimHighlight,vimImport,vimLet,vimLoadkeymap,vimLockvar,vimMake,vimMap,vimMark,vimMatch,vimNotFunc,vimNormal,vimProfdel,vimProfile,vimRedir,vimSet,vimSleep,vimSort,vimSyntax,vimSynColor,vimSynLink,vimThrow,vimUniq,vimUnlet,vimUnlockvar,vimUnmap,vimUserCmd,vimVimgrep,vimVimgrepadd,vimMenu,vimMenutranslate,@vim9CmdList,@vimExUserCmdList,vimLua,vimMzScheme,vimPerl,vimPython,vimPython3,vimPythonX,vimRuby,vimTcl
syn cluster vim9CmdList	contains=vim9Abstract,vim9Class,vim9Const,vim9Enum,vim9Export,vim9Final,vim9For,vim9Interface,vim9Type,vim9Var
syn match vimCmdSep	"\\\@1<!|"	skipwhite nextgroup=@vimCmdList,vimSubst1,@vimFunc
syn match vimCmdSep	":\+"	skipwhite nextgroup=@vimCmdList,vimSubst1
syn match vimCount	contained	"\d\+"
syn match vimIsCommand	"\<\h\w*\>"	nextgroup=vimBang contains=vimCommand
syn match vimBang	      contained	"!"
syn match vimWhitespace contained	"\s\+"

syn region vimSubscript contained	matchgroup=vimSubscriptBracket start="\[" end="]" nextgroup=vimSubscript contains=@vimExprList

syn match vimVar	      contained	"\<\h[a-zA-Z0-9#_]*\>"	nextgroup=vimSubscript contains=vim9Super,vim9This
syn match vimVar		"\<[bwglstav]:\h[a-zA-Z0-9#_]*\>"	nextgroup=vimSubscript contains=vimVarScope
syn match vimVar		"\<a:\%(000\|1\=[0-9]\|20\)\>"	nextgroup=vimSubscript contains=vimVarScope
syn match vimFBVar      contained	"\<[bwglsta]:\h[a-zA-Z0-9#_]*\>"	nextgroup=vimSubscript contains=vimVarScope

" match the scope prefix independently of the retrofitted scope dictionary
syn match vimVarScope   contained	"\<[bwglstav]:"
syn match vimVimVar     contained	"\<[bwglstav]:\%(\h\|\d\)\@!"	nextgroup=vimSubscript

syn match vimVarNameError contained "\<\h\w*\>"
syn match vimVimVar	"\<v:"		nextgroup=vimSubscript,vimVimVarName,vimVarNameError
syn match vimOptionVar	"&\%([lg]:\)\="		nextgroup=vimSubscript,vimOptionVarName,vimVarNameError
syn cluster vimSpecialVar	contains=vimEnvvar,vimLetRegister,vimOptionVar,vimVimVar

Vim9 syn match	vim9LhsVariable	"\s\=\h[a-zA-Z0-9#_]*\ze\s\+[-+/*%]\=="
Vim9 syn match	vim9LhsVariable	"\s\=\h[a-zA-Z0-9#_]*\ze\s\+\.\.="
Vim9 syn match	vim9LhsVariable	"\s\=\%([bwgt]:\)\=\h[a-zA-Z0-9#_]*\ze\s\+=<<"	skipwhite nextgroup=vimLetHeredoc	contains=vimVarScope
Vim9 syn match	vim9LhsVariable	"\s\=\h[a-zA-Z0-9#_]*\ze\["		          nextgroup=vimSubscript
Vim9 syn match	vim9LhsVariable	"\s\=\h[a-zA-Z0-9#_]*\ze\."		          nextgroup=vimOper	contains=vim9Super,vim9This
Vim9 syn match	vim9LhsVariable	"\s\=\h[a-zA-Z0-9#_]*\ze\s*->"				contains=vim9Super,vim9This

Vim9 syn match vim9LhsVariableList	"\[\_[^]]\+]\ze\s\+[-+/*%]\=="			contains=vimVar,@vimSpecialVar
Vim9 syn match vim9LhsVariableList	"\[\_[^]]\+]\ze\s\+=<<"	skipwhite nextgroup=vimLetHeredoc	contains=vimVar,@vimSpecialVar
Vim9 syn match vim9LhsVariableList	"\[\_[^]]\+]\ze\s\+\.\.="			contains=vimVar,@vimSpecialVar

Vim9 syn match vim9LhsRegister	"@["0-9\-a-zA-Z#=*+_/]\ze\s\+\%(\.\.\)\=="

syn cluster vimExprList	contains=@vimSpecialVar,@vimFunc,vimNumber,vimOper,vimOperParen,vimLambda,vimString,vimVar,@vim9ExprList
syn cluster vim9ExprList	contains=vim9Boolean,vim9LambdaParams,vim9Null

" Insertions And Appends: insert append {{{2
"   (buftype != nofile test avoids having append, change, insert show up in the command window)
" =======================
if &buftype != 'nofile'
 syn region vimInsert	matchgroup=vimCommand start="^[: \t]*\(\d\+\(,\d\+\)\=\)\=a\%[ppend]$"		matchgroup=vimCommand end="^\.$" extend
 syn region vimInsert	matchgroup=vimCommand start="^[: \t]*\(\d\+\(,\d\+\)\=\)\=c\%[hange]$"		matchgroup=vimCommand end="^\.$" extend
 syn region vimInsert	matchgroup=vimCommand start="^[: \t]*\(\d\+\(,\d\+\)\=\)\=i\%[nsert]$"		matchgroup=vimCommand end="^\.$" extend
endif

" Behave! {{{2
" =======
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_nobehaveerror")
 syn match   vimBehaveError contained	"[^ ]\+"
endif
syn match   vimBehave	"\<be\%[have]\>"	nextgroup=vimBehaveBang,vimBehaveModel,vimBehaveError skipwhite
syn match   vimBehaveBang	contained	"\a\@1<=!" nextgroup=vimBehaveModel skipwhite
syn keyword vimBehaveModel	contained	mswin	xterm

" Call {{{2
" ====
syn match vimCall	"\<call\=\>"	skipwhite nextgroup=vimVar,@vimFunc

" Debuggreedy {{{2
" ===========
" TODO: special-cased until generalised range/count support is implemented
syn match	vimDebuggreedy	"\<0\=debugg\%[reedy]\>" contains=vimCount

" Defer {{{2
" =====
syn match	vimDefer	"\<defer\=\>"	skipwhite nextgroup=@vimFunc

" Exception Handling {{{2
syn keyword	vimThrow	th[row]	skipwhite nextgroup=@vimExprList
syn keyword	vimCatch	cat[ch]	skipwhite nextgroup=vimCatchPattern
syn region	vimCatchPattern	contained	matchgroup=Delimiter start="\z([!#$%&'()*+,-./:;<=>?@[\]^_`{}~]\)" skip="\\\\\|\\\z1" end="\z1" contains=@vimSubstList oneline

" Export {{{2
" ======
if s:vim9script
  syn keyword	vim9Export	export	skipwhite nextgroup=vim9Abstract,vim9ClassBody,vim9Const,vim9Def,vim9EnumBody,vim9Final,vim9InterfaceBody,vim9Type,vim9Var
endif

" Filetypes {{{2
" =========
syn match   vimFiletype	"\<filet\%[ype]\(\s\+\I\i*\)*"	skipwhite contains=vimFTCmd,vimFTOption,vimFTError
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_vimFTError")
 syn match   vimFTError  contained	"\I\i*"
endif
syn keyword vimFTCmd    contained	filet[ype]
syn keyword vimFTOption contained	detect indent off on plugin

" Import {{{2
" ======
syn keyword	vimImportAutoload	contained	autoload	skipwhite nextgroup=vimImportFilename
if s:vim9script
  syn region	vimImportFilename contained
        \ start="\S"
        \ skip=+\%#=1
          "\ continuation operators at SOL
          \\n\%(\s*#.*\n\)*\s*\%([[:punct:]]\+\&[^#"'(]\)
            \\|
          "\ continuation operators at EOL
          \\%(\%([[:punct:]]\+\&[^#"')]\)\s*\%(#.*\)\=\)\@<=$
            \\|
          \\n\%(\s*#.*\n\)*\s*as\s
            \\|
          \\%(^\s*#.*\)\@<=$
            \\|
          \\n\s*\%(\\\|#\\ \)
        \+
        \ matchgroup=vimCommand
        \ end="\s\+\zsas\ze\s\+\h"
        \ matchgroup=NONE
        \ end="$"
        \ skipwhite nextgroup=vimImportName
        \ contains=@vim9Continue,@vimExprList,vim9Comment
        \ transparent
else
  syn region	vimImportFilename contained
        \ start="\S"
        \ skip=+\n\s*\%(\\\|"\\ \)+
        \ matchgroup=vimCommand
        \ end="\s\+\zsas\ze\s\+\h"
        \ matchgroup=NONE
        \ end="$"
        \ skipwhite nextgroup=vimImportName
        \ contains=@vimContinue,@vimExprList
        \ transparent
endif
syn match	vimImportName	contained	"\%(\<as\s\+\)\@<=\h\w*\>"	skipwhite nextgroup=@vimComment
syn match	vimImport		"\<imp\%[ort]\>"		skipwhite nextgroup=vimImportAutoload,vimImportFilename

" Augroup : vimAugroupError removed because long augroups caused sync'ing problems. {{{2
" ======= : Trade-off: Increasing synclines with slower editing vs augroup END error checking.
syn cluster vimAugroupList	contains=@vimCmdList,vimFilter,@vimFunc,vimLineComment,vimSpecFile,vimOper,vimNumber,vimOperParen,@vimComment,vimString,vimSubst,vimRegister,vimCmplxRepeat,vimNotation,vimCtrlChar,vimContinue

" define
VimFolda syn region vimAugroup
      \ start="\<aug\%[roup]\>\ze\s\+\%([eE][nN][dD]\)\@!\S\+"
      \ matchgroup=vimAugroupKey
      \ end="\<aug\%[roup]\>\ze\s\+[eE][nN][dD]\>"
      \ skipwhite nextgroup=vimAugroupEnd
      \ contains=vimAutocmd,@vimAugroupList,vimAugroupkey
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_noaugrouperror")
  syn match	vimAugroupError	"\<aug\%[roup]\>\s\+[eE][nN][dD]\>"
endif

" TODO: Vim9 comment
syn match	vimAugroupName	contained	"\%(\\["|[:space:]]\|[^"|[:space:]]\)\+"
      \                                                                 skipwhite nextgroup=vimCmdSep,vimComment
syn match	vimAugroupEnd	contained	"\c\<END\>"	skipwhite nextgroup=vimCmdSep,vimComment
syn match	vimAugroupBang	contained	"\a\@1<=!"	skipwhite nextgroup=vimAugroupName
syn keyword	vimAugroupKey	contained	aug[roup] 	skipwhite nextgroup=vimAugroupBang,vimAugroupName,vimAugroupEnd

" remove
syn match	vimAugroup	"\<aug\%[roup]!"		skipwhite nextgroup=vimAugroupName contains=vimAugroupKey,vimAugroupBang

" list
VimL syn match	vimAugroup	"\<aug\%[roup]\>\ze\s*\%(["|]\|$\)"	skipwhite nextgroup=vimCmdSep,vimComment  contains=vimAugroupKey
Vim9 syn match 	vimAugroup	"\<aug\%[roup]\>\ze\s*\%([#|]\|$\)"	skipwhite nextgroup=vimCmdSep,vim9Comment contains=vimAugroupKey

" Operators: {{{2
" =========
syn cluster	vimOperGroup	contains=@vimContinue,@vimExprList,vim9Comment,vim9LineComment,vimContinueString
syn match	vimOper	"\a\@<!!"			skipwhite skipnl nextgroup=@vimOperContinue,@vimExprList,vimSpecFile
syn match	vimOper	"||\|&&\|[-+*/%.]"		skipwhite skipnl nextgroup=@vimOperContinue,@vimExprList,vimSpecFile
syn match	vimOper	"?"			skipwhite skipnl nextgroup=@vimOperContinue,@vimExprList,vimContinueString
" distinguish ternary : from ex-colon
syn match	vimOper	"\s\@1<=:\ze\s\|\s\@1<=:$"		skipwhite skipnl nextgroup=@vimOperContinue,@vimExprList,vimContinueString
syn match	vimOper	"??"			skipwhite skipnl nextgroup=@vimOperContinue,@vimExprList,vimContinueString
syn match	vimOper	"="			skipwhite skipnl nextgroup=@vimOperContinue,@vimExprList,vimContinueString,vimSpecFile
syn match	vimOper	"\%#=1\%(==\|!=\|>=\|<=\|=\~\|!\~\|>\|<\)[?#]\="	skipwhite skipnl nextgroup=@vimOperContinue,@vimExprList,vimContinueString,vimSpecFile
syn match	vimOper	"\<is\%(not\)\=\>"		skipwhite skipnl nextgroup=@vimOperContinue,@vimExprList,vimContinueString,vimSpecFile
syn match	vimOper	"\<is\%(not\)\=[?#]"		skipwhite skipnl nextgroup=@vimOperContinue,@vimExprList,vimContinueString,vimSpecFile
syn region	vimOperParen 		matchgroup=vimParenSep start="("    end=")" contains=@vimOperGroup nextgroup=vimSubscript
syn region	vimOperParen		matchgroup=vimSep	     start="#\={" end="}" contains=@vimOperGroup nextgroup=vimSubscript,vimVar
syn region	vimOperParen	contained	matchgroup=vimSep	     start="\["	end="]" contains=@vimOperGroup nextgroup=vimSubscript,vimVar
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_noopererror")
 syn match	vimOperError	")"
endif

syn match	vimOperContinue		contained	"^\s*\\"        skipwhite skipnl nextgroup=@vimOperContinue,@vimExprList contains=vimWhitespace
syn match         vimOperContinueComment	contained	'^\s*["#]\\ .*' skipwhite skipnl nextgroup=@vimOperContinue,@vimExprList contains=vimWhitespace
syn cluster	vimOperContinue		contains=vimOperContinue,vimOperContinueComment

" Lambda Expressions: {{{2
" ==================
syn match	vimLambdaOperator	contained	"->" skipwhite nextgroup=@vimExprList
syn region	vimLambda	contained
      \ matchgroup=vimLambdaBrace
      \ start=+{\ze[[:space:][:alnum:]_.,]*\%(\n\s*\%(\\[[:space:][:alnum:]_.,]*\|"\\ .*\)\)*->+
      \ skip=+\n\s*\%(\\\|"\\ \)+
      \ end="}" end="$"
      \ contains=@vimContinue,@vimExprList,vimLambdaParams
syn match	vimLambdaParams	contained	"\%({\n\=\)\@1<=\_.\{-}\%(->\)\@=" nextgroup=vimLambdaOperator contains=@vimContinue,vimFunctionParam

syn match	vim9LambdaOperator   contained	"=>" skipwhite skipempty nextgroup=@vimExprList,vim9LambdaBlock,vim9LambdaOperatorComment
syn match	vim9LambdaParen      contained	"[()]"
syn match	vim9LambdaParams	   contained
      \ "(\%(\<func(\|[^(]\)*\%(\n\s*\\\%(\<func(\|[^(]\)*\|\n\s*#\\ .*\)*\ze\s\+=>"
      \ skipwhite nextgroup=vim9LambdaOperator
      \ contains=@vim9Continue,vimDefParam,vim9LambdaParen,vim9LambdaReturnType
syn region	vim9LambdaReturnType contained	start=")\@<=:\s" end="\ze\s*#" end="\ze\s*=>" contains=@vim9Continue,@vimType transparent
syn region	vim9LambdaBlock	   contained	matchgroup=vimSep start="{" end="^\s*\zs}" contains=@vimDefBodyList

syn match	vim9LambdaOperatorComment contained "#.*" skipwhite skipempty nextgroup=@vimExprList,vim9LambdaBlock,vim9LambdaOperatorComment

" Functions: Tag is provided for those who wish to highlight tagged functions {{{2
" =========
syn cluster	vimFunctionBodyCommon	contains=@vimCmdList,vimCmplxRepeat,vimContinue,vimCtrlChar,vimDef,vimFBVar,vimFunction,vimNotFunc,vimNumber,vimOper,vimOperParen,vimRegister,vimSpecFile,vimString,vimSubst,vimFunctionFold,vimDefFold,vimCmdSep
syn cluster	vimFunctionBodyList	contains=@vimFunctionBodyCommon,vimComment,vimLineComment,vimInsert,vimConst,vimLet,vimSearch
syn cluster	vimDefBodyList		contains=@vimFunctionBodyCommon,vim9Comment,vim9LineComment,vim9Block,vim9Const,vim9Final,vim9Var,vim9Null,vim9Boolean,vim9For,vim9LhsVariable,vim9LhsVariableList,vim9LhsRegister,vim9Search,@vimSpecialVar,@vim9Func

syn region	vimFunctionPattern	contained
      \ matchgroup=vimOper
      \ start="/"
      \ end="$"
      \ contains=@vimSubstList

syn match	vimFunctionBang	contained	"\a\@1<=!"	skipwhite nextgroup=vimFunctionName
syn match	vimDefBang	contained	"\a\@1<=!"	skipwhite nextgroup=vimDefName
syn match	vimFunctionSID	contained	"\c<sid>"
syn match	vimFunctionScope	contained	"\<[bwglstav]:"
syn match	vimFunctionName	contained
      \ "\%(<[sS][iI][dD]>\|[bwglstav]:\)\=\%([[:alnum:]_#.]\+\|{.\{-1,}}\)\+"
      \ skipwhite nextgroup=vimFunctionParams,vimCmdSep,vimComment,vim9Comment
      \ contains=vimFunctionError,vimFunctionScope,vimFunctionSID,Tag
syn match	vimDefName	contained
      \ "\%(<[sS][iI][dD]>\|[bwglstav]:\)\=\%([[:alnum:]_#.]\+\|{.\{-1,}}\)\+"
      \ nextgroup=vimDefParams,vimCmdSep,vimComment,vim9Comment
      \ contains=vimFunctionError,vimFunctionScope,vimFunctionSID,Tag

syn match	vimFunction	"\<fu\%[nction]\>"	skipwhite nextgroup=vimFunctionBang,vimFunctionName,vimFunctionPattern,vimCmdSep,vimComment
syn match	vimDef	"\<def\>"		skipwhite nextgroup=vimDefBang,vimDefName,vimFunctionPattern,vimCmdSep,vimComment

syn region	vimFunctionComment	contained
      \ start=+".*+
      \ skip=+\n\s*\%(\\\|"\\ \)+
      \ end="$"
      \ skipwhite skipempty nextgroup=vimFunctionBody,vimEndfunction
syn region	vimDefComment	contained
      \ start="#.*"
      \ skip=+\n\s*\%(\\\|#\\ \)+
      \ end="$"
      \ skipwhite skipempty nextgroup=vimDefBody,vimEnddef

syn region	vimFunctionParams	contained
      \ matchgroup=Delimiter
      \ start="("
      \ skip=+\n\s*\%(\\\|"\\ \)+
      \ end=")"
      \ skipwhite skipempty nextgroup=vimFunctionBody,vimFunctionComment,vimEndfunction,vimFunctionMod,vim9CommentError
      \ contains=vimFunctionParam,vimOperParen,@vimContinue
syn region	vimDefParams	contained
      \ matchgroup=Delimiter
      \ start="("
      \ end=")"
      \ skipwhite skipempty nextgroup=vimDefBody,vimDefComment,vimEnddef,vimReturnType,vimCommentError
      \ contains=vimDefParam,vim9Comment,vimFunctionParamEquals,vimOperParen
syn match	vimFunctionParam	contained	"\<\h\w*\>\|\.\.\."	skipwhite nextgroup=vimFunctionParamEquals
syn match	vimDefParam	contained	"\<\h\w*\>"		skipwhite nextgroup=vimParamType,vimFunctionParamEquals

syn match	vimFunctionParamEquals contained	"="			skipwhite	  nextgroup=@vimExprList
syn match	vimFunctionMod	     contained	"\<\%(abort\|closure\|dict\|range\)\>"	skipwhite skipempty nextgroup=vimFunctionBody,vimFunctionComment,vimEndfunction,vimFunctionMod,vim9CommentError

syn region	vimFunctionBody	contained
      \ start="^."
      \ matchgroup=vimCommand
      \ end="\<endfu\%[nction]\>"
      \ skipwhite nextgroup=vimCmdSep,vimComment,vim9CommentError
      \ contains=@vimFunctionBodyList
syn region	vimDefBody	contained
      \ start="^."
      \ matchgroup=vimCommand
      \ end="\<enddef\>"
      \ skipwhite nextgroup=vimCmdSep,vim9Comment,vimCommentError
      \ contains=@vimDefBodyList

syn match	vimEndfunction	"\<endf\%[unction]\>"	skipwhite nextgroup=vimCmdSep,vimComment,vim9CommentError
syn match	vimEnddef	"\<enddef\>"		skipwhite nextgroup=vimCmdSep,vim9Comment,vimCommentError

if exists("g:vimsyn_folding") && g:vimsyn_folding =~# 'f'
  syn region	vimFunctionFold
        \ start="\<fu\%[nction]!"
        "\ assume no dict literal in curly-brace name expressions
        \ start="\<fu\%[nction]\>\s*\%([[:alnum:]_:<>.#]\+\|{.\{-1,}}\)\+\s*("
        \ end="^\s*:\=\s*endf\%[unction]\>"
        \ contains=vimFunction
        \ extend fold keepend transparent
  syn region	vimDefFold
        \ start="\<def!"
        "\ assume no dict literal in curly-brace name expressions
        \ start="\<def\>\s*\%([[:alnum:]_:<>.#]\+\|{.\{-1,}}\)\+("
        \ end="^\s*:\=\s*enddef\>"
        \ contains=vimDef
        \ extend fold keepend transparent
endif

syn match	vimDelfunctionBang	contained	"\a\@1<=!"		skipwhite nextgroup=vimFunctionName
syn match	vimDelfunction			"\<delf\%[unction]\>"	skipwhite nextgroup=vimDelfunctionBang,vimFunctionName

" Types: {{{2
" =====

syn region	vimReturnType	contained
      \ start=":\%(\s\|\n\)\@="
      \ skip=+\n\s*\\\|\n\s*#\\ \|^\s*#\\ +
      \ end="$"
      \ matchgroup=vim9Comment
      "\ allow for legacy script tail comment error
      \ end="\ze[#"]"
      \ skipwhite skipempty nextgroup=vimDefBody,vimDefComment,vimEnddef,vimCommentError
      \ contains=@vim9Continue,@vimType
      \ transparent
syn match	vimParamType	contained	":\s"	skipwhite skipnl nextgroup=@vimType contains=vimTypeSep

syn match	vimTypeSep	contained	":\%(\s\|\n\)\@=" skipwhite nextgroup=@vimType
syn keyword	vimType	contained	blob bool channel float job number string void
syn keyword	vimTypeAny	contained	any
syn match	vimType	contained	"\<\%(func\)\>"
syn region	vimCompoundType	contained	matchgroup=vimType start="\<func("	          end=")" nextgroup=vimTypeSep contains=@vim9Continue,@vimType transparent
syn region	vimCompoundType	contained	matchgroup=vimType start="\<tuple<"           end=">"                      contains=@vim9Continue,@vimType transparent
syn region	vimCompoundType	contained	matchgroup=vimType start="\<\%(list\|dict\)<" end=">"		   contains=@vimType oneline       transparent
syn match	vimUserType	contained	"\<\%(\h\w*\.\)*\u\w*\>"

syn cluster vimType contains=vimType,vimTypeAny,vimCompoundType,vimUserType

" Classes, Enums And Interfaces: {{{2
" =============================

if s:vim9script

  " Methods {{{3
  syn match	vim9MethodDef		contained	"\<def\>"	skipwhite nextgroup=vim9MethodDefName,vim9ConstructorDefName
  syn match	vim9MethodDefName		contained	"\<\h\w*\>"	nextgroup=vim9MethodDefParams contains=@vim9MethodName
  syn region	vim9MethodDefParams	contained
        \ matchgroup=Delimiter start="(" end=")"
        \ skipwhite skipnl nextgroup=vim9MethodDefBody,vim9MethodDefComment,vimEnddef,vim9MethodDefReturnType,vimCommentError
        \ contains=vimDefParam,vim9Comment,vimFunctionParamEquals

  syn match	vim9ConstructorDefName	contained	"\<_\=new\w*\>"
        \ nextgroup=vim9ConstructorDefParams
        \ contains=@vim9MethodName
  syn match	vim9ConstructorDefParam	contained	"\<\%(this\.\)\=\h\w*\>"
        \ skipwhite nextgroup=vimParamType,vimFunctionParamEquals
        \ contains=vim9This,vimOper
  syn region	vim9ConstructorDefParams	contained
        \ matchgroup=Delimiter start="(" end=")"
        \ skipwhite skipnl nextgroup=vim9MethodDefBody,vim9MethodDefComment,vimEnddef,vimCommentError
        \ contains=vim9ConstructorDefParam,vim9Comment,vimFunctionParamEquals

  syn region	vim9MethodDefReturnType	contained
        \ start=":\%(\s\|\n\)\@="
        \ skip=+\n\s*\\\|\n\s*#\\ \|^\s*#\\ +
        \ end="$"
        \ matchgroup=vim9Comment
        \ end="\ze#"
        \ skipwhite skipnl nextgroup=vim9MethodDefBody,vim9MethodDefComment,vimEnddef,vimCommentError
        \ contains=@vim9Continue,vimType,vimTypeSep
        \ transparent

  syn region	vim9MethodDefComment	contained
        \ start="#.*"
        \ skip=+\n\s*\\\|\n\s*#\\ +
        \ end="$"
        \ skipwhite skipempty nextgroup=vim9MethodDefBody,vimEnddef

  syn region	vim9MethodDefBody		contained
        \ start="^.\=" matchgroup=vimCommand end="\<enddef\>"
        \ skipwhite nextgroup=vimCmdSep,vim9Comment,vimCommentError
        \ contains=@vim9MethodDefBodyList

  syn cluster	vim9MethodDefBodyList contains=@vimDefBodyList,vim9This,vim9Super

  if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_novimfunctionerror")
    syn match	vim9MethodNameError contained	"\<[a-z0-9]\i\>"
  endif
  syn match	vim9MethodName	contained	"\<_\=new\w*\>"
  syn keyword	vim9MethodName	contained	empty len string

  syn cluster	vim9MethodName	contains=vim9MethodName,vim9MethodNameError

  if exists("g:vimsyn_folding") && g:vimsyn_folding =~# 'f'
    syn region	vim9MethodDefFold	contained	start="\%(^\s*\%(:\=static\s\+\)\=\)\@16<=:\=def\s\+\h\i*(" end="^\s*:\=enddef\>" contains=vim9MethodDef fold keepend extend transparent
    syn region	vim9MethodDefFold	contained	start="^\s*:\=def\s\+_\=new\i*("		      end="^\s*:\=enddef\>" contains=vim9MethodDef fold keepend extend transparent
  endif

  syn cluster vim9MethodDef contains=vim9MethodDef,vim9MethodDefFold

  " Classes {{{3
  syn cluster	vim9ClassBodyList		contains=vim9Abstract,vim9Class,vim9Comment,vim9LineComment,@vim9Continue,@vimExprList,vim9Extends,vim9Implements,@vim9MethodDef,vim9Public,vim9Static,vim9Const,vim9Final,vim9This,vim9Super,vim9Var

  syn match	vim9Class		contained	"\<class\>"	skipwhite        nextgroup=vim9ClassName
  syn match	vim9ClassName		contained	"\<\u\w*\>"	skipwhite skipnl nextgroup=vim9Extends,vim9Implements
  syn match	vim9SuperClass		contained	"\<\u\w*\>"	skipwhite skipnl nextgroup=vim9Implements
  syn match	vim9ImplementedInterface	contained	"\<\u\w*\>"	skipwhite skipnl nextgroup=vim9InterfaceListComma,vim9Extends
  syn match	vim9InterfaceListComma	contained	","	skipwhite skipnl nextgroup=vim9ImplementedInterface
  syn keyword	vim9Abstract			abstract	skipwhite skipnl nextgroup=vim9ClassBody,vim9AbstractDef
  syn keyword	vim9Extends		contained	extends	skipwhite skipnl nextgroup=vim9SuperClass
  syn keyword	vim9Implements		contained	implements	skipwhite skipnl nextgroup=vim9ImplementedInterface
  syn keyword	vim9Public		contained	public
  syn keyword	vim9Static		contained	static
  " FIXME: don't match as dictionary keys, remove when operators are not
  "        shared between Vim9 and legacy script
  syn match	vim9This		contained	"\.\@1<!\<this\>:\@!"
  " super must be folowed by '.'
  syn match	vim9Super		contained	"\.\@1<!\<super\.\@="

  VimFoldc syn region	vim9ClassBody	start="\<class\>" matchgroup=vimCommand end="\<endclass\>" contains=@vim9ClassBodyList transparent

  " Enums {{{3
  syn cluster	vim9EnumBodyList		contains=vim9Comment,vim9LineComment,@vim9Continue,vim9Enum,@vimExprList,@vim9MethodDef,vim9Public,vim9Static,vim9Const,vim9Final,vim9This,vim9Var

  syn match	vim9Enum		contained	"\<enum\>"	skipwhite           nextgroup=vim9EnumName

  syn match	vim9EnumName		contained	"\<\u\w*\>"	skipwhite skipempty nextgroup=vim9EnumNameTrailing,vim9EnumNameEmpty,vim9EnumNameComment,@vim9EnumNameContinue,vim9EnumImplements
  syn match	vim9EnumNameTrailing	contained	"\S.*"
  syn region	vim9EnumNameComment	contained
        \ start="#" skip="\n\s*\%(\\\|#\\ \)" end="$"
        \ skipwhite skipempty nextgroup=vim9EnumNameComment,vim9EnumValue
        \ contains=@vimCommentGroup,vimCommentString
  " vim9EnumName's "skipempty" should only apply to comments and enum values and not implements clauses
  syn match	vim9EnumNameEmpty		contained	"^"	skipwhite skipempty nextgroup=vim9EnumNameComment,vim9EnumValue
  " allow line continuation between enum name and "implements"
  syn match	vim9EnumNameContinue	contained
        \ "^\s*\\"
        \ skipwhite skipnl nextgroup=vim9EnumNameTrailing,vim9EnumNameEmpty,vim9EnumNameComment,@vim9EnumNameContinue,vim9EnumImplements
        \ contains=vimWhitespace
  syn match	vim9EnumNameContinueComment	contained
        \ "^\s*#\\ .*"
        \ skipwhite skipnl nextgroup=vim9EnumNameEmpty,vim9EnumNameComment,@vim9EnumNameContinue
        \ contains=vimWhitespace
  syn cluster	vim9EnumNameContinue	contains=vim9EnumNameContinue,vim9EnumNameContinueComment

  " enforce enum value list location
  syn match	vim9EnumValue		contained	"\<\a\w*\>"		  nextgroup=vim9EnumValueArgList,vim9EnumValueListComma,vim9Comment
  syn match	vim9EnumValueListComma	contained	","	skipwhite skipempty nextgroup=vim9EnumValue,vim9EnumValueListCommaComment
  syn region	vim9EnumValueListCommaComment	contained
        \ start="#" skip="\n\s*\%(\\\|#\\ \)" end="$"
        \ skipwhite skipempty nextgroup=vim9EnumValueListCommaComment,vim9EnumValue
        \ contains=@vimCommentGroup,vimCommentString
  syn region	vim9EnumValueArgList	contained
        \ matchgroup=vimParenSep start="(" end=")"
        \ nextgroup=vim9EnumValueListComma
        \ contains=@vimExprList,vimContinueString,vim9Comment

  syn keyword	vim9EnumImplements	contained	implements	skipwhite        nextgroup=vim9EnumImplementedInterface
  syn match	vim9EnumImplementedInterface	contained	"\<\u\w*\>"	skipwhite skipnl nextgroup=vim9EnumInterfaceListComma,vim9EnumImplementedInterfaceComment,vim9EnumValue
  syn match	vim9EnumInterfaceListComma	contained	","	skipwhite        nextgroup=vim9EnumImplementedInterface
  syn region	vim9EnumImplementedInterfaceComment	contained
        \ start="#" skip="\n\s*\%(\\\|#\\ \)" end="$"
        \ skipwhite skipempty nextgroup=vim9EnumImplementedInterfaceComment,vim9EnumValue
        \ contains=@vimCommentGroup,vimCommentString

  VimFolde syn region	vim9EnumBody	start="\<enum\>" matchgroup=vimCommand end="\<endenum\>" contains=@vim9EnumBodyList transparent

  " Interfaces {{{3
  " TODO: limit to decl only - no init values
  syn cluster	vim9InterfaceBodyList	contains=vim9Comment,vim9LineComment,@vim9Continue,vim9Extends,vim9Interface,vim9AbstractDef,vim9Var

  syn match	vim9Interface		contained	"\<interface\>"	skipwhite nextgroup=vim9InterfaceName
  syn match	vim9InterfaceName		contained	"\<\u\w*\>"	skipwhite skipnl nextgroup=vim9Extends

  syn keyword	vim9AbstractDef		contained	def	skipwhite nextgroup=vim9AbstractDefName
  syn match	vim9AbstractDefName	contained	"\<\h\w*\>"	skipwhite nextgroup=vim9AbstractDefParams contains=@vim9MethodName
  syn region	vim9AbstractDefParams	contained
        \ matchgroup=Delimiter start="(" end=")"
        \ skipwhite skipnl nextgroup=vimDefComment,vim9AbstractDefReturnType,vimCommentError
        \ contains=vimDefParam,vim9Comment,vimFunctionParamEquals
  syn region	vim9AbstractDefReturnType	contained
        \ start=":\s" end="$" matchgroup=vim9Comment end="\ze[#"]"
        \ skipwhite skipnl nextgroup=vimDefComment,vimCommentError
        \ contains=vimTypeSep
        \ transparent

  VimFoldi syn region	vim9InterfaceBody	start="\<interface\>" matchgroup=vimCommand end="\<endinterface\>" contains=@vim9InterfaceBodyList transparent

  " Type Aliases {{{3
  syn match	vim9Type		"\<ty\%[pe]\>"	skipwhite nextgroup=vim9TypeAlias,vim9TypeAliasError
  syn match	vim9TypeAlias	 contained	"\<\u\w*\>"	skipwhite nextgroup=vim9TypeEquals
  syn match	vim9TypeEquals	 contained	"="	skipwhite nextgroup=@vimType
  if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_notypealiaserror")
    syn match	vim9TypeAliasError contained	"\<\l\w*\>"	skipwhite nextgroup=vim9TypeEquals
  endif
endif

" Blocks: {{{2
" ======
Vim9 syn region	vim9Block
      \ matchgroup=vimSep
      \ start="{\ze\s*\%($\|[#|]\)"
      \ end="^\s*\zs}"
      \ skipwhite nextgroup=vim9Comment,vimCmdSep
      \ contains=@vimDefBodyList

" Keymaps: {{{2
" =======

syn match  vimKeymapStart	"^"	contained skipwhite nextgroup=vimKeymapLhs,@vimKeymapLineComment
syn match  vimKeymapLhs	"\S\+"	contained skipwhite nextgroup=vimKeymapRhs contains=vimNotation
syn match  vimKeymapRhs	"\S\+"	contained skipwhite nextgroup=vimKeymapTailComment contains=vimNotation
syn match  vimKeymapTailComment	"\S.*"	contained

" TODO: remove when :" comment is matched in parts as "ex-colon comment" --djk
if s:vim9script
  syn match  vim9KeymapLineComment	"#.*"	contained contains=@vimCommentGroup,vimCommentString,vim9CommentTitle
else
  syn match  vimKeymapLineComment	+".*+	contained contains=@vimCommentGroup,vimCommentString,vimCommentTitle
endif
syn cluster vimKeymapLineComment contains=vim9\=KeymapLineComment

syn region vimLoadkeymap matchgroup=vimCommand start="\<loadk\%[eymap]\>" end="\%$" contains=vimKeymapStart

" Special Filenames, Modifiers, Extension Removal: {{{2
" ===============================================
syn match	vimSpecFile	"<c\(word\|WORD\)>"	nextgroup=vimSpecFileMod,vimSubst1
syn match	vimSpecFile	"<\([acs]file\|amatch\|abuf\)>"	nextgroup=vimSpecFileMod,vimSubst1
syn match	vimSpecFile	"\s%[ \t:]"ms=s+1,me=e-1	nextgroup=vimSpecFileMod,vimSubst1
syn match	vimSpecFile	"\s%$"ms=s+1		nextgroup=vimSpecFileMod,vimSubst1
syn match	vimSpecFile	"\s%<"ms=s+1,me=e-1	nextgroup=vimSpecFileMod,vimSubst1
syn match	vimSpecFile	"#\d\+\|[#%]<\>"		nextgroup=vimSpecFileMod,vimSubst1
syn match	vimSpecFileMod	"\(:[phtre]\)\+"	contained

" User-Specified Commands: {{{2
" =======================
syn cluster	vimUserCmdList	contains=@vimCmdList,vimCmplxRepeat,@vimComment,vimCtrlChar,vimEscapeBrace,@vimFunc,vimNotation,vimNumber,vimOper,vimRegister,vimSpecFile,vimString,vimSubst,vimSubstRep,vimSubstRange

syn match	vimUserCmd	"\<com\%[mand]\>!\="		skipwhite        nextgroup=vimUserCmdAttrs,vimUserCmdName contains=vimBang
syn match	vimUserCmd	+\<com\%[mand]\>!\=\ze\s*\n\s*\%(\\\|["#]\\ \)+	skipwhite skipnl nextgroup=vimUserCmdAttrs,vimUserCmdName contains=vimBang

syn region	vimUserCmdAttrs	    contained
      \ start="-\l"
      \ start=+^\s*\%(\\\|["#]\\ \)+
      \ end="\ze\s\u"
      \ skipwhite nextgroup=vimUserCmdName
      \ contains=@vimContinue,vimUserCmdAttr,vimUserCmdAttrError
      \ transparent
syn match	vimUserCmdAttrError contained	"-\a\+\ze\%(\s\|=\)"
syn match	vimUserCmdAttr	  contained	"-addr="		contains=vimUserCmdAttrKey nextgroup=vimUserCmdAttrAddr
syn match	vimUserCmdAttr	  contained	"-bang\>"		contains=vimUserCmdAttrKey
syn match	vimUserCmdAttr	  contained	"-bar\>"		contains=vimUserCmdAttrKey
syn match	vimUserCmdAttr	  contained	"-buffer\>"		contains=vimUserCmdAttrKey
syn match	vimUserCmdAttr	  contained	"-complete="		contains=vimUserCmdAttrKey nextgroup=vimUserCmdAttrComplete,vimUserCmdError
syn match	vimUserCmdAttr	  contained	"-count\>"		contains=vimUserCmdAttrKey
syn match	vimUserCmdAttr	  contained	"-count="		contains=vimUserCmdAttrKey nextgroup=vimNumber
syn match	vimUserCmdAttr	  contained	"-keepscript\>"		contains=vimUserCmdAttrKey
syn match	vimUserCmdAttr	  contained	"-nargs="		contains=vimUserCmdAttrKey nextgroup=vimUserCmdAttrNargs
syn match	vimUserCmdAttr	  contained	"-range\>"		contains=vimUserCmdAttrKey
syn match	vimUserCmdAttr	  contained	"-range="		contains=vimUserCmdAttrKey nextgroup=vimNumber,vimUserCmdAttrRange
syn match	vimUserCmdAttr	  contained	"-register\>"		contains=vimUserCmdAttrKey

syn match	vimUserCmdAttrNargs	contained	"[01*?+]"
syn match	vimUserCmdAttrRange	contained	"%"

if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_nousercmderror")
 syn match	vimUserCmdError	contained	"\S\+\>"
endif

syn case ignore
syn keyword	vimUserCmdAttrKey   contained	a[ddr] ban[g] bar bu[ffer] com[plete] cou[nt] k[eepscript] n[args] ra[nge] re[gister]

" GEN_SYN_VIM: vimUserCmdAttrComplete, START_STR='syn keyword vimUserCmdAttrComplete contained', END_STR=''
syn keyword vimUserCmdAttrComplete contained arglist augroup behave breakpoint buffer color command compiler cscope diff_buffer dir dir_in_path environment event expression file file_in_path filetype filetypecmd function help highlight history keymap locale mapclear mapping menu messages option packadd retab runtime scriptnames shellcmd shellcmdline sign syntax syntime tag tag_listfiles user var
syn keyword vimUserCmdAttrComplete contained arglist augroup behave breakpoint buffer color command compiler cscope diff_buffer dir dir_in_path environment event expression file file_in_path filetype function help highlight history keymap locale mapclear mapping menu messages option packadd runtime scriptnames shellcmd shellcmdline sign syntax syntime tag tag_listfiles user var
syn keyword	vimUserCmdAttrComplete	contained	custom customlist nextgroup=vimUserCmdAttrCompleteFunc,vimUserCmdError
syn match	vimUserCmdAttrCompleteFunc	contained	",\%([bwglstav]:\|<[sS][iI][dD]>\)\=\h\w*\%([.#]\h\w*\)*"hs=s+1 nextgroup=vimUserCmdError contains=vimVarScope,vimFunctionSID

" GEN_SYN_VIM: vimUserCmdAttrAddr, START_STR='syn keyword vimUserCmdAttrAddr contained', END_STR=''
syn keyword vimUserCmdAttrAddr contained arguments arg buffers buf lines line loaded_buffers load other quickfix qf tabs tab windows win
syn keyword vimUserCmdAttrAddr contained arguments arg buffers buf lines line loaded_buffers load other quickfix qf tabs tab windows win
syn match	vimUserCmdAttrAddr     contained	"?"
syn case match

syn match	vimUserCmdName	    contained	"\<\u[[:alnum:]]*\>"		skipwhite        nextgroup=vimUserCmdBlock,vimUserCmdReplacement
syn match	vimUserCmdName	    contained	+\<\u[[:alnum:]]*\>\ze\s*\n\s*\%(\\\|["#]\\ \)+	skipwhite skipnl nextgroup=vimUserCmdBlock,vimUserCmdReplacement
syn region	vimUserCmdReplacement contained
      \ start="\S"
      \ start=+^\s*\%(\\\|["#]\\ \)+
      \ skip=+\n\s*\%(\\\|["#]\\ \)+
      \ end="$"
      \ contains=@vimContinue,@vimUserCmdList,vimComFilter
syn region	vimUserCmdBlock	    contained
      \ matchgroup=vimSep
      \ start="{"
      \ end="^\s*\zs}"
      \ contains=@vimDefBodyList,@vimUserCmdList

syn match	vimDelcommand		"\<delc\%[ommand]\>"	skipwhite nextgroup=vimDelcommandAttr,vimDelcommandName
syn match	vimDelcommandAttr	contained	"-buffer\>"		skipwhite nextgroup=vimDelcommandName
syn match	vimDelcommandName	contained	"\<\u[[:alnum:]]*\>"

" Lower Priority Comments: after some vim commands... {{{2
" =======================
if get(g:, "vimsyn_comment_strings", 1)
  syn region	vimCommentString	contained oneline start='\S\s\+"'ms=e end='"' extend
endif

if s:vim9script
  syn cluster vimComment contains=vim9Comment
else
  syn cluster vimComment contains=vimComment
endif

VimL syn region	vimComment
      \ excludenl
      \ start=+"+
      \ skip=+\n\s*\%(\\\|"\\ \)+
      \ end="$"
      \ contains=@vimCommentGroup,vimCommentString
      \ extend
Vim9 syn region	vim9Comment
      \ excludenl
      \ start="\%#=1\s\@1<=#\%({\@!\|{{\)"
      \ skip="\n\s*\%(\\\|#\\ \)"
      \ end="$"
      \ contains=@vimCommentGroup,vimCommentString
      \ extend

syn match	vim9CommentError	contained	"#.*"
syn match	vimCommentError	contained	+".*+

" Environment Variables: {{{2
" =====================
syn match	vimEnvvar	"\$\I\i*"
syn match	vimEnvvar	"\${\I\i*}"

" Strings {{{2
" =======

" In-String Specials:
" Try to catch strings, if nothing else matches (therefore it must precede the others!)
"  vimEscapeBrace handles ["]  []"] (ie. "s don't terminate string inside [])
" syn region	vimEscapeBrace	oneline   contained transparent start="[^\\]\(\\\\\)*\[\zs\^\=\]\=" skip="\\\\\|\\\]" end="]"me=e-1
syn match	vimPatSepErr	contained	"\\)"
syn match	vimPatSep	contained	"\\|"
syn region	vimPatSepZone	oneline   contained   matchgroup=vimPatSepZ start="\\%\=\ze(" skip="\\\\" end="\\)\|[^\\]['"]"	contains=@vimStringGroup
syn region	vimPatRegion	contained transparent matchgroup=vimPatSepR start="\\[z%]\=(" end="\\)"	contains=@vimSubstList oneline
syn match	vimNotPatSep	contained	"\\\\"
syn cluster	vimStringGroup	contains=vimEscape,vimEscapeBrace,vimPatSep,vimNotPatSep,vimPatSepErr,vimPatSepZone,@Spell
syn region	vimString	oneline keepend	matchgroup=vimString start=+[^a-zA-Z\\@]"+lc=1 skip=+\\\\\|\\"+ matchgroup=vimStringEnd end=+"+ nextgroup=vimSubscript contains=@vimStringGroup extend
syn region	vimString	oneline	matchgroup=vimString start=+[^a-zA-Z\\@]'+lc=1 end=+'+		       nextgroup=vimSubscript contains=vimQuoteEscape  extend
"syn region	vimString	oneline	start="\s/\s*\A"lc=1 skip="\\\\\|\\+" end="/"	contains=@vimStringGroup  " see tst45.vim

syn match	vimEscape	contained	"\\."
" syn match	vimEscape	contained	+\\[befnrt\"]+
syn match	vimEscape	contained	"\\\o\{1,3}\|\\[xX]\x\{1,2}\|\\u\x\{1,4}\|\\U\x\{1,8}"
syn match	vimEscape	contained	"\\<" contains=vimNotation
syn match	vimEscape	contained	"\\<\*[^>]*>\=>"
syn match	vimQuoteEscape	contained	"''"

syn region	vimString	oneline matchgroup=vimString start=+$'+ end=+'+ nextgroup=vimSubscript contains=@vimStringInterpolation,vimQuoteEscape  extend
syn region	vimString	oneline matchgroup=vimString start=+$"+ end=+"+ nextgroup=vimSubscript contains=@vimStringInterpolation,@vimStringGroup extend
syn region	vimStringInterpolationExpr  oneline contained matchgroup=vimSep start=+{+ end=+}+ contains=@vimExprList
syn match	vimStringInterpolationBrace contained "{{"
syn match	vimStringInterpolationBrace contained "}}"
syn cluster	vimStringInterpolation contains=vimStringInterpolationExpr,vimStringInterpolationBrace

syn region	vimContinueString	contained	matchgroup=vimContinueString start=+"+  skip=+\n\s*\%(\\\|["#]\\ \)+ end=+"+ end="$" skipwhite nextgroup=vimSubscript,vimComment contains=@vimContinue,@vimStringGroup
syn region	vimContinueString	contained	matchgroup=vimContinueString start=+'+  skip=+\n\s*\%(\\\|["#]\\ \)+ end=+'+ end="$" skipwhite nextgroup=vimSubscript,vimComment contains=@vimContinue,vimQuoteEscape
syn region	vimContinueString	contained	matchgroup=vimContinueString start=+$"+ skip=+\n\s*\%(\\\|["#]\\ \)+ end=+"+ end="$" skipwhite nextgroup=vimSubscript,vimComment contains=@vimContinue,@vimStringInterpolation,@vimStringGroup
syn region	vimContinueString	contained	matchgroup=vimContinueString start=+$'+ skip=+\n\s*\%(\\\|["#]\\ \)+ end=+'+ end="$" skipwhite nextgroup=vimSubscript,vimComment contains=@vimContinue,@vimStringInterpolation,vimQuoteEscape

" Substitutions: {{{2
" =============
syn cluster	vimSubstList	contains=vimPatSep,vimPatRegion,vimPatSepErr,vimSubstTwoBS,vimSubstRange,vimNotation
syn cluster	vimSubstRepList	contains=vimSubstSubstr,vimSubstTwoBS,vimNotation
syn cluster	vimSubstList	add=vimCollection
syn match	vimSubst		"^\s*\%(s\%[ubstitute]\|sm\%[agic]\|sno\%[magic]\)\>"		skipwhite nextgroup=vimSubstPat,vimSubstFlags,vimSubstCount
syn match	vimSubst		"^\s*\%(s\%[ubstitute]\|sm\%[agic]\|sno\%[magic]\)[_#]\@="	skipwhite nextgroup=vimSubstPat
syn match	vimSubst		"^\s*\%(s\%[ubstitute]\|sm\%[agic]\|sno\%[magic]\)\%(\d\+\)\@="	skipwhite nextgroup=vimSubstCount
syn match	vimSubst1	contained	"\%(s\%[ubstitute]\|sm\%[agic]\>\|sno\%[magic]\)\>"		skipwhite nextgroup=vimSubstPat,vimSubstFlags,vimSubstCount
syn match	vimSubst1	contained	"\%(s\%[ubstitute]\|sm\%[agic]\>\|sno\%[magic]\)[_#]\@="	skipwhite nextgroup=vimSubstPat
syn match	vimSubst1	contained	"\%(s\%[ubstitute]\|sm\%[agic]\>\|sno\%[magic]\)\%(\d\+\)\@="	skipwhite nextgroup=vimSubstCount
syn match	vimSubstFlagErr	contained	"[^< \t\r|]\+" contains=vimSubstFlags
" & and # after :s are always pattern delimiters not flags
syn match	vimSubstFlags	contained	"[&cegiIlnpr#]\+"	skipwhite nextgroup=vimSubstCount
syn match	vimSubstCount	contained	"\d\+\>"
" TODO: Vim9 illegal separators for abbreviated :s form are [-.:], :su\%[...] required
"     : # is allowed but "not recommended" (see :h pattern-delimiter)
syn region	vimSubstPat	contained	matchgroup=vimSubstDelim start="\z([!#$%&'()*+,-./:;<=>?@[\]^_`{}~]\)"rs=s+1 skip="\\\\\|\\\z1" end="\z1"re=e-1,me=e-1	contains=@vimSubstList	nextgroup=vimSubstRep4	oneline
syn region	vimSubstRep4	contained	matchgroup=vimSubstDelim start="\z(.\)" skip="\\\\\|\\\z1" end="\z1" matchgroup=vimNotation end="<[cC][rR]>"	contains=@vimSubstRepList	nextgroup=vimSubstFlagErr	oneline
syn region	vimCollection	contained 	transparent	start="\\\@<!\[" skip="\\\[" end="\]"	contains=vimCollClass
syn match	vimCollClassErr	contained	"\[:.\{-\}:\]"
syn match	vimCollClass	contained 	transparent	"\%#=1\[:\(alnum\|alpha\|blank\|cntrl\|digit\|graph\|lower\|print\|punct\|space\|upper\|xdigit\|retu\%[rn]\|tab\|escape\|backspace\):\]"
syn match	vimSubstSubstr	contained	"\\z\=\d"
syn match	vimSubstTwoBS	contained	"\\\\"

" TODO: flags, unlike count, must follow immediately
"     : distinguish from with Vim9 &var
" syn match	vimSubst		"^\s*\zs&&\="	skipwhite nextgroup=vimSubstFlags,vimSubstCount
" syn match	vimSubst		"^\s*\zs\~&\="	skipwhite nextgroup=vimSubstFlags,vimSubstCount
" syn match	vimSubst1	contained	"&&\="	skipwhite nextgroup=vimSubstFlags,vimSubstCount
" syn match	vimSubst1	contained	"\~&\="	skipwhite nextgroup=vimSubstFlags,vimSubstCount

" two and three letter variants (matched as :s + flags, count may follow immediately)
syn match	vimSubst		"^\s*\zssc[egiIlnp]\=\a\@!"	skipwhite nextgroup=vimSubstCount	contains=vimSubstFlags
syn match	vimSubst		"^\s*\zssg[ceiIlnpr]\=\a\@!"	skipwhite nextgroup=vimSubstCount	contains=vimSubstFlags
syn match	vimSubst		"^\s*\zssi[ceInpr]\=\a\@!"	skipwhite nextgroup=vimSubstCount	contains=vimSubstFlags
syn match	vimSubst		"^\s*\zssI[ceginplr]\=\a\@!"	skipwhite nextgroup=vimSubstCount	contains=vimSubstFlags
syn match	vimSubst		"^\s*\zssr[cgiInplr]\=\a\@!"	skipwhite nextgroup=vimSubstCount	contains=vimSubstFlags

syn match	vimSubst1	contained	"\<sc[egiIlnp]\=\a\@!"	skipwhite nextgroup=vimSubstCount	contains=vimSubstFlags
syn match	vimSubst1	contained	"\<sg[ceiIlnpr]\=\a\@!"	skipwhite nextgroup=vimSubstCount	contains=vimSubstFlags
syn match	vimSubst1	contained	"\<si[ceInpr]\=\a\@!"	skipwhite nextgroup=vimSubstCount	contains=vimSubstFlags
syn match	vimSubst1	contained	"\<sI[ceginplr]\=\a\@!"	skipwhite nextgroup=vimSubstCount	contains=vimSubstFlags
syn match	vimSubst1	contained	"\<sr[cgiInplr]\=\a\@!"	skipwhite nextgroup=vimSubstCount	contains=vimSubstFlags

" Vi compatibility
syn match	vimSubstDelim	contained	"\\"
syn match	vimSubstPat	contained	"\\\ze[/?&]" contains=vimSubstDelim nextgroup=vimSubstRep4

" Mark: {{{2
" ====
VimL syn match	vimExMark	"\<k\%([a-zA-Z0-9]\>\|[[\]<>'`]\)\@="         nextgroup=@vimMarkArg
VimL syn match	vimExMark	"\<k\>"	      	skipwhite nextgroup=@vimMarkArg
syn match	vimExMark	"\<mark\>"	      	skipwhite nextgroup=@vimMarkArg

syn match	vimMarkArg	contained	"[a-zA-Z]\>\|[[\]<>'`]"	skipwhite nextgroup=vimCmdSep,vimComment
syn match	vimMarkArgError	contained	"["^.(){}0-9]"
syn cluster	vimMarkArg	contains=vimMarkArg,vimMarkArgError

" Marks, Registers, Addresses, Filters: {{{2
syn match	vimMark	"'[a-zA-Z0-9]\ze\s*$"
syn match	vimMark	"'[[\]{}()<>'`"^.]\ze\s*$"
syn match	vimMark	"'[a-zA-Z0-9]\ze[-+,!]"	nextgroup=vimFilter,vimMarkNumber,vimSubst1
syn match	vimMark	"'[[\]{}()<>'`"^.]\ze[-+,!]"	nextgroup=vimFilter,vimMarkNumber,vimSubst1
syn match	vimMark	",\zs'[[\]{}()<>'`"^.]"	nextgroup=vimFilter,vimMarkNumber,vimSubst1
syn match	vimMark	"[!,:]\zs'[a-zA-Z0-9]"	nextgroup=vimFilter,vimMarkNumber,vimSubst1
syn match	vimMarkNumber	"[-+]\d\+"		contained contains=vimOper nextgroup=vimSubst1
syn match	vimPlainMark contained	"'[a-zA-Z0-9]"
syn match	vimRange	"[`'][a-zA-Z0-9],[`'][a-zA-Z0-9]"	contains=vimMark	skipwhite nextgroup=vimFilter

syn match	vimRegister	'[^,;[{: \t]\zs"[a-zA-Z0-9.%#:_\-/]\ze[^a-zA-Z_":0-9]'
syn match	vimRegister	'@"'
syn match	vimLetRegister	contained	'@["@0-9\-a-zA-Z:.%#=*+~_/]'

syn match	vimAddress	",\zs[.$]"	skipwhite nextgroup=vimSubst1
syn match	vimAddress	"%\ze\a"	skipwhite nextgroup=vimString,vimSubst1

syn match	vimFilter 		"^!!\=[^"]\{-}\(|\|\ze\"\|$\)"	contains=vimOper,vimSpecFile
syn match	vimFilter    contained	"!!\=[^"]\{-}\(|\|\ze\"\|$\)"	contains=vimOper,vimSpecFile
syn match	vimComFilter contained	"|!!\=[^"]\{-}\(|\|\ze\"\|$\)"      contains=vimOper,vimSpecFile

" Complex Repeats: (:h complex-repeat) {{{2
" ===============
syn match	vimCmplxRepeat	'[^a-zA-Z_/\\()]q[0-9a-zA-Z"]\>'lc=1
syn match	vimCmplxRepeat	'@[0-9a-z".=@:]\ze\($\|[^a-zA-Z]\>\)'

" Set command and associated set-options (vimOptions) with comment {{{2
syn match	vimSet		"\<\%(setl\%[ocal]\|setg\%[lobal]\|se\%[t]\)\>" skipwhite nextgroup=vimSetBang,vimCmdSep,vimComment,vimSetArgs
syn region	vimSetComment	contained	start=+"+ skip=+\n\s*\%(\\\||"\\ \)+ end="$" contains=@vimCommentGroup,vimCommentString extend
syn match	vimSetCmdSep	contained	"|" skipwhite nextgroup=@vimCmdList,vimSubst1,@vimFunc
syn match	vimSetEscape	contained	"\\\%(\\[|"]\|.\)"
syn match	vimSetBarEscape	contained	"\\|"
syn match	vimSetQuoteEscape	contained	+\\"+
syn region	vimSetArgs	contained
      \ start="\l\|<"
      \ skip=+\n\s*\%(\\\|["#]\\ \)\|^\s*"\\ +
      \ end=+\ze\\\@1<![|"]+
      "\ assume this isn't an escaped char with backslash on the previous line
      \ end=+^\s*\\\ze[|"]+
      \ end="\ze\s#"
      \ end="$"
      \ nextgroup=vimSetCmdSep,vimSetComment,vim9Comment
      \ contains=@vimContinue,vimErrSetting,vimOption,vimSetAll,vimSetTermcap
      \ keepend
" TODO: restrict this to valid values?
syn match	vimOption	contained	"<[^>]\+>"	contains=vimOption
syn region	vimSetEqual	contained
      \ matchgroup=vimOper
      \ start="[=:]\|[-+^]="
      \ skip=+\\\s\|^\s*\%(\\\|["#]\\ \)+
      \ end="\ze\s"
      \ contains=@vimContinue,vimCtrlChar,vimEnvvar,vimNotation,vimSetSep,vimSetEscape,vimSetBarEscape,vimSetQuoteEscape
syn match	vimSetBang	contained	"\a\@1<=!" skipwhite nextgroup=vimSetAll,vimSetTermcap
syn keyword	vimSetAll	contained	all nextgroup=vimSetMod
syn keyword	vimSetTermcap	contained	termcap
syn match	vimSetSep	contained	"[,:]"
syn match	vimSetMod	contained	"\a\@1<=\%(&vim\=\|[!&?<]\)"

" Variable Declarations: {{{2
" =====================
VimL syn keyword	vimLet	let		skipwhite nextgroup=@vimSpecialVar,vimVar,vimVarList,vimLetVar
VimL syn keyword	vimConst	cons[t]		skipwhite nextgroup=@vimSpecialVar,vimVar,vimVarList,vimLetVar
syn region	vimVarList	contained
      \ start="\[" end="]"
      \ skipwhite nextgroup=vimLetHeredoc
      \ contains=@vimContinue,@vimSpecialVar,vimVar
syn match	vimLetVar	 contained	"\<\%([bwglstav]:\)\=\h[a-zA-Z0-9#_]*\>\ze\%(\[.*]\)\=\s*=<<"	skipwhite nextgroup=vimLetVarSubscript,vimLetHeredoc	contains=vimVarScope,vimSubscript
hi link vimLetVar vimVar
syn region	vimLetVarSubscript contained
      \ matchgroup=vimSubscriptBracket
      \ start="\S\@1<=\["
      \ end="]"
      \ skipwhite nextgroup=vimLetVarSubscript,vimLetHeredoc
      \ contains=@vimExprList

VimL syn keyword	vimUnlet		unl[et]	skipwhite nextgroup=vimUnletBang,vimUnletVars
syn match	vimUnletBang	contained	"\a\@1<=!"	skipwhite nextgroup=vimUnletVars
syn region	vimUnletVars	contained
      \ start="$\I\|\h" skip=+\n\s*\\\|\n\s*"\\ \|^\s*"\\ + end="$" end="\ze[|"]"
      \ nextgroup=vimCmdSep,vimComment
      \ contains=@vimContinue,vimEnvvar,vimVar,vimVimVar

" TODO: type error after register or environment variables (strings)
VimFoldh syn region vimLetHeredoc	contained
      \ matchgroup=vimLetHeredocStart
      \ start="\%(^\z(\s*\)\S.*\)\@<==<<\s*trim\%(\s\+\)\@>\z(\L\S*\)"
      \ matchgroup=vimLetHeredocStop
      \ end="^\z1\=\z2$"
      \ extend
VimFoldh syn region vimLetHeredoc	contained
      \ matchgroup=vimLetHeredocStart
      \ start="=<<\%(\s*\)\@>\z(\L\S*\)"
      \ matchgroup=vimLetHeredocStop end="^\z1$"
      \ extend
VimFoldh syn region vimLetHeredoc	contained
      \ matchgroup=vimLetHeredocStart
      \ start="\%(^\z(\s*\)\S.*\)\@<==<<\s*\%(trim\s\+eval\|eval\s\+trim\)\%(\s\+\)\@>\z(\L\S*\)"
      \ matchgroup=vimLetHeredocStop
      \ end="^\z1\=\z2$"
      \ contains=@vimStringInterpolation
      \ extend
VimFoldh syn region vimLetHeredoc	contained
      \ matchgroup=vimLetHeredocStart
      \ start="=<<\s*eval\%(\s\+\)\@>\z(\L\S*\)"
      \ matchgroup=vimLetHeredocStop
      \ end="^\z1$"
      \ contains=@vimStringInterpolation
      \ extend

Vim9 syn keyword	vim9Const	const	skipwhite nextgroup=vim9Variable,vim9VariableList
Vim9 syn keyword	vim9Final	final	skipwhite nextgroup=vim9Variable,vim9VariableList
Vim9 syn keyword	vim9Var	var	skipwhite nextgroup=vim9Variable,vim9VariableList

syn match	vim9Variable	contained	"\<\h\w*\>"	skipwhite nextgroup=vim9VariableTypeSep,vimLetHeredoc,vimOper
syn region	vim9VariableList	contained	start="\[" end="]" contains=@vimContinue,@vimSpecialVar,vim9Variable skipwhite nextgroup=vimLetHeredoc

syn match	vim9VariableTypeSep	contained	"\S\@1<=:\%(\s\|\n\)\@="		skipwhite nextgroup=@vim9VariableType
syn keyword	vim9VariableType		contained	blob bool channel float job number string void	skipwhite nextgroup=vimLetHeredoc
syn keyword	vim9VariableTypeAny	contained	any			skipwhite nextgroup=vimLetHeredoc
syn match	vim9VariableType		contained	"\<\%(func\)\>"			skipwhite nextgroup=vimLetHeredoc
syn region	vim9VariableCompoundType	contained
      \ matchgroup=vim9VariableType
      \ start="\<func("
      \ end=")"
      \ skipwhite nextgroup=vim9VariableTypeSep,vimLetHeredoc
      \ contains=@vim9Continue,@vim9VariableType
      \ transparent
syn region	vim9VariableCompoundType	contained
      \ matchgroup=vim9VariableType
      \ start="\<tuple<"
      \ end=">"
      \ skipwhite nextgroup=vimLetHeredoc
      \ contains=@vim9Continue,@vim9VariableType
      \ transparent
syn region	vim9VariableCompoundType	contained
      \ matchgroup=vim9VariableType
      \ start="\<\%(list\|dict\)<"
      \ end=">"
      \ skipwhite nextgroup=vimLetHeredoc
      \ contains=@vim9VariableType
      \ oneline
      \ transparent
syn match	vim9VariableUserType	contained	"\<\%(\h\w*\.\)*\u\w*\>"	skipwhite nextgroup=vimLetHeredoc

syn cluster vim9VariableType contains=vim9VariableType,vim9VariableTypeAny,vim9VariableCompoundType,vim9VariableUserType

" Lockvar and Unlockvar: {{{2
" =====================
syn keyword	vimLockvar	lockv[ar]	skipwhite nextgroup=vimLockvarBang,vimLockvarDepth,vimLockvarVars
syn keyword	vimUnlockvar	unlo[ckvar]	skipwhite nextgroup=vimLockvarBang,vimLockvarDepth,vimLockvarVars
syn match	vimLockvarBang	contained	"\a\@1<=!"	skipwhite nextgroup=vimLockvarVars
syn match	vimLockvarDepth	contained	"\<[0-3]\>"	skipwhite nextgroup=vimLockvarVars
syn region	vimLockvarVars	contained
      \ start="\h" skip=+\n\s*\\\|\n\s*"\\ \|^\s*"\\ + end="$" end="\ze[|"]"
      \ nextgroup=vimCmdSep,vimComment
      \ contains=@vimContinue,vimVar

hi def link vimLockvar vimCommand
hi def link vimUnlockvar vimCommand
hi def link vimLockvarBang vimBang
hi def link vimLockvarDepth vimNumber

" For: {{{2
" ===
" handles Vim9 and legacy for now
syn region	vimFor
      \ matchgroup=vimCommand
      \ start="\<for\>" end="\<in\>"
      \ skipwhite skipnl nextgroup=@vimForInContinue,vim9ForInComment,@vimExprList
      \ contains=@vimContinue,vimVar,vimVarList,vim9VariableList
      \ transparent

syn match	vim9ForInComment		contained	"#.*"	skipwhite skipempty nextgroup=vimForInComment,@vimExprList

syn match	vimForInContinue		contained	"^\s*\zs\\"	 skipwhite skipnl nextgroup=@vimForInContinue,@vimExprList
syn match         vimForInContinueComment	contained	'^\s*\zs["#]\\ .*' skipwhite skipnl nextgroup=@vimForInContinue,@vimExprList
syn cluster	vimForInContinue		contains=vimForInContinue,vimForInContinueComment

" Abbreviations: {{{2
" =============
" GEN_SYN_VIM: vimCommand abbrev, START_STR='syn keyword vimAbb', END_STR='skipwhite nextgroup=vimMapMod,vimMapLhs'
syn keyword vimAbb ab[breviate] ca[bbrev] cnorea[bbrev] cuna[bbrev] ia[bbrev] inorea[bbrev] iuna[bbrev] norea[bbrev] una[bbreviate] skipwhite nextgroup=vimMapMod,vimMapLhs
" GEN_SYN_VIM: vimCommand abclear, START_STR='syn keyword vimAbb', END_STR='skipwhite nextgroup=vimMapMod'
syn keyword vimAbb abc[lear] cabc[lear] iabc[lear] skipwhite nextgroup=vimMapMod

" Filename Patterns: {{{2
" =================

syn match	vimWildcardQuestion	contained	"?"
syn match	vimWildcardStar		contained	"*"

syn match	vimWildcardBraceComma	contained	","
syn region	vimWildcardBrace		contained
      \ matchgroup=vimWildcard
      \ start="{"
      \ end="}"
      \ contains=vimWildcardEscape,vimWildcardBrace,vimWildcardBraceComma,vimWildcardQuestion,vimWildcardStar,vimWildcardBracket
      \ oneline

syn match	vimWildcardIntervalNumber	contained	"\d\+"
syn match	vimWildcardInterval	contained	"\\\\\\{\d\+\%(,\d\+\)\=\\}" contains=vimWildcardIntervalNumber


syn match	vimWildcardBracket	contained	"\[\%(\^\=]\=\%(\\.\|\[\([:.=]\)[^:.=]\+\1]\|[^][:space:]]\)*\)\@>]"
      \ contains=vimWildcardBracketStart,vimWildcardEscape

syn match	vimWildcardBracketCharacter	contained	"."	nextgroup=@vimWildcardBracketCharacter,vimWildcardBracketHyphen,vimWildcardBracketEnd
syn match	vimWildcardBracketRightBracket	contained	"]"	nextgroup=@vimWildcardBracketCharacter,vimWildcardBracketEnd
syn match	vimWildcardBracketHyphen	contained	"-]\@!"	nextgroup=@vimWildcardBracketCharacter
syn match	vimWildcardBracketEscape	contained	"\\."	nextgroup=@vimWildcardBracketCharacter,vimWildcardBracketHyphen,vimWildcardBracketEnd
syn match	vimWildcardBracketCharacterClass	contained	"\[:[^:]\+:]"	nextgroup=@vimWildcardBracketCharacter,vimWildcardBracketEnd
syn match	vimWildcardBracketEquivalenceClass	contained	"\[=[^=]\+=]"	nextgroup=@vimWildcardBracketCharacter,vimWildcardBracketEnd
syn match	vimWildcardBracketCollatingSymbol	contained	"\[\.[^.]\+\.]"	nextgroup=@vimWildcardBracketCharacter,vimWildcardBracketEnd

syn match	vimWildcardBracketStart	contained	"\["	nextgroup=vimWildcardBracketCaret,vimWildcardBracketRightBracket,@vimWildcardBracketCharacter
syn match	vimWildcardBracketCaret	contained	"\^"	nextgroup=@vimWildcardBracketCharacter,vimWildcardBracketRightBracket
syn match	vimWildcardBracketEnd	contained	"]"

syn cluster	vimWildcardBracketCharacter	contains=vimWildcardBracketCharacter,vimWildcardBracketEscape,vimWildcardBracketCharacterClass,vimWildcardBracketEquivalenceClass,vimWildcardBracketCollatingSymbol

syn match	vimWildcardEscape	contained	"\\."

syn cluster	vimWildcard		contains=vimWildcardQuestion,vimWildcardStar,vimWildcardBrace,vimWildcardBracket,vimWildcardInterval

" Autocmd and Doauto{cmd,all}: {{{2
" ===========================

" TODO: explicitly match the {cmd} arg rather than bailing out to TOP
syn region	vimAutocmdBlock	contained	matchgroup=vimSep start="{" end="^\s*\zs}" contains=@vimDefBodyList

syn match	vimAutocmdGroup	contained	"\%(\\["|[:space:]]\|[^"|[:space:]]\)\+" skipwhite nextgroup=vimAutoEvent,nvimAutoEvent,vimAutoEventGlob
syn match	vimAutocmdBang	contained	"\a\@1<=!"		     skipwhite nextgroup=vimAutocmdGroup,vimAutoEvent,nvimAutoEvent,vimAutoEventGlob

" TODO: cleaner handling of | in pattern position
"     : match pattern items in addition to wildcards
syn region	vimAutocmdPattern	contained
      \ start="|\@!\S"
      \ skip="\\\\\|\\[,[:space:]]"
      \ end="\ze[,[:space:]]"
      \ end="$"
      \ skipwhite nextgroup=vimAutocmdPatternSep,vimAutocmdMod,vimAutocmdBlock,@vimFunc
      \ contains=vimEnvvar,@vimWildcard,vimAutocmdPatternEscape
syn match	vimAutocmdBufferPattern	contained	"<buffer\%(=\%(\d\+\|abuf\)\)\=>" skipwhite nextgroup=vimAutocmdPatternSep,vimAutocmdMod,vimAutocmdBlock,@vimFunc
" trailing pattern separator comma allowed
syn match	vimAutocmdPatternSep	contained	","	                skipwhite nextgroup=@vimAutocmdPattern,vimAutocmdMod,vimAutocmdBlock
syn match	vimAutocmdPatternEscape	contained	"\\."
syn cluster	vimAutocmdPattern		contains=vimAutocmdPattern,vimAutocmdBufferPattern

" TODO: Vim9 requires '++' prefix
syn match	vimAutocmdMod	contained	"\%(++\)\=\<nested\>" skipwhite nextgroup=vimAutocmdMod,vimAutocmdBlock
syn match	vimAutocmdMod	contained	"++once\>"	skipwhite nextgroup=vimAutocmdMod,vimAutocmdBlock

" higher priority than vimAutocmdGroup, assume no group is so named
syn match	vimAutoEventGlob	contained	"*"	skipwhite nextgroup=@vimAutocmdPattern
syn match	vimAutoEventSep	contained	"\a\@1<=,"	nextgroup=vimAutoEvent,nvimAutoEvent
syn match	vimUserAutoEventSep contained	"\a\@1<=,"	nextgroup=vimUserAutoEvent

syn match	vimAutocmd		"\<au\%[tocmd]\>"	skipwhite nextgroup=vimAutocmdBang,vimAutocmdGroup,vimAutoEvent,nvimAutoEvent,vimAutoEventGlob


syn match	vimDoautocmdMod	contained	"<nomodeline>"		skipwhite nextgroup=vimAutocmdGroup,vimAutoEvent,nvimAutoEvent
syn match	vimDoautocmd		"\<do\%[autocmd]\>"	skipwhite nextgroup=vimDoautocmdMod,vimAutocmdGroup,vimAutoEvent,nvimAutoEvent
syn match	vimDoautocmd		"\<doautoa\%[ll]\>"	skipwhite nextgroup=vimDoautocmdMod,vimAutocmdGroup,vimAutoEvent,nvimAutoEvent

" Echo And Execute: -- prefer strings! {{{2
" ================
" NOTE: No trailing comments

syn region	vimEcho
      \ matchgroup=vimCommand
      \ start="\<ec\%[ho]\>"
      \ start="\<echoe\%[rr]\>"
      \ start="\<echom\%[sg]\>"
      \ start="\<echoc\%[onsole]\>"
      \ start="\<echon\>"
      \ start="\<echow\%[indow]\>"
      \ skip=+\\|\|||\|\n\s*\%(\\\|["#]\\ \)+
      \ end="\ze|"
      \ excludenl end="$"
      \ nextgroup=vimCmdSep
      \ contains=@vimContinue,@vimExprList
      \ transparent

syn match	vimEchohl	"\<echohl\=\>"	skipwhite nextgroup=vimGroup,vimHLGroup,vimEchohlNone,vimOnlyHLGroup,nvimHLGroup
syn case ignore
syn keyword	vimEchohlNone	contained none
syn case match

syn cluster	vimEcho	contains=vimEcho,vimEchohl

syn region	vimExecute
      \ matchgroup=vimCommand
      \ start="\<exe\%[cute]\>"
      \ skip=+\\|\|||\|\n\s*\%(\\\|["#]\\ \)+
      \ end="\ze|"
      \ excludenl end="$"
      \ nextgroup=vimCmdSep
      \ contains=@vimContinue,@vimExprList
      \ transparent

syn region	vimEval
      \ matchgroup=vimCommand
      \ start="\<ev\%[al]\>"
      \ skip=+\\|\|||\|\n\s*\%(\\\|["#]\\ \)+
      \ end="\ze|"
      \ excludenl end="$"
      \ nextgroup=vimCmdSep
      \ contains=@vimContinue,@vimExprList
      \ transparent

" Filter: {{{2
" ======
syn match	vimExFilter		"\<filt\%[er]\>"	skipwhite nextgroup=vimExFilterBang,vimExFilterPattern
syn region	vimExFilterPattern contained
      \ start="[[:ident:]]"
      \ end="\ze[[:space:]\n]"
      \ skipwhite nextgroup=@vimCmdList
      \ contains=@vimSubstList
      \ oneline
syn region	vimExFilterPattern contained
      \ matchgroup=Delimiter
      \ start="\z([^[:space:][:ident:]|"]\)"
      \ skip="\\\\\|\\\z1"
      \ end="\z1"
      \ skipwhite nextgroup=@vimCmdList
      \ contains=@vimSubstList
      \ oneline
syn match	vimExFilterBang	 contained	"\a\@1<=!"	skipwhite nextgroup=vimExFilterPattern

" Grep and Make: {{{2
" =============
" | is the command separator, escaped with \| all other backslashes are passed through literally, no tail comments
syn match	vimGrep		"\<l\=gr\%[ep]\>"		skipwhite nextgroup=vimGrepBang,vimGrepArgs,vimCmdSep
syn match	vimGrepadd		"\<l\=grepa\%[dd]\>"	skipwhite nextgroup=vimGrepBang,vimGrepArgs,vimCmdSep
syn region	vimGrepArgs	contained
      \ start="|\@!\S"
      \ skip=+\n\s*\%(\\\|[#"]\\ \)+
      \ matchgroup=vimCmdSep
      \ end="|"
      \ end="$"
      "\ TODO: include vimSpecFile
      \ contains=vimGrepBarEscape
syn match	vimGrepBarEscape	contained	"\\|"
syn match	vimGrepBang	contained	"\a\@1<=!"		skipwhite nextgroup=vimGrepArgs,vimCmdSep

syn match	vimMake		"\<l\=make\=\>"		skipwhite nextgroup=vimMakeBang,vimMakeArgs,vimCmdSep
syn region	vimMakeArgs	contained
      \ start="|\@!\S"
      \ skip=+\n\s*\%(\\\|[#"]\\ \)+
      \ matchgroup=vimCmdSep
      \ end="|"
      \ end="$"
      "\ TODO: include vimSpecFile
      \ contains=vimMakeBarEscape
syn match	vimMakeBarEscape	contained	"\\|"
syn match	vimMakeBang	contained	"\a\@1<=!"		skipwhite nextgroup=vimMakeArgs,vimCmdSep

syn match	vimHelpgrep		"\<l\=helpg\%[rep]\>"	skipwhite nextgroup=vimHelpgrepBang,vimHelpgrepPattern
syn region	vimHelpgrepPattern	contained
      \ start="\S"
      \ matchgroup=Special
      \ end="@\w\w\>"
      \ end="$"
      \ contains=@vimSubstList
      \ oneline

" Vimgrep: {{{2
" =======
syn match	vimVimgrep		"\<l\=vim\%[grep]\>"	skipwhite nextgroup=vimVimgrepBang,vimVimgrepPattern
syn match	vimVimgrepadd		"\<l\=vimgrepa\%[dd]\>"	skipwhite nextgroup=vimVimgrepBang,vimVimgrepPattern
syn match	vimVimgrepBang	  contained	"\a\@1<=!"		skipwhite nextgroup=vimVimgrepPattern
syn region	vimVimgrepPattern   contained
      \ start="[[:ident:]]"
      \ end="\ze[[:space:]\n]"
      \ skipwhite nextgroup=vimVimgrepFile,vimCmdSep
      \ contains=@vimSubstList
      \ oneline
syn region	vimVimgrepPattern   contained
      \ matchgroup=Delimiter
      \ start="\z([^[:space:][:ident:]|"]\)"
      \ skip="\\\\\|\\\z1"
      \ end="\z1"
      \ skipwhite nextgroup=vimVimgrepFlags,vimVimgrepFile,vimCmdSep
      \ contains=@vimSubstList
      \ oneline
syn match	vimVimgrepEscape	  contained	"\\\%(\\|\|.\)"
syn match	vimVimgrepBarEscape contained	"\\|"
syn region	vimVimgrepFile	  contained
      \ start="|\@!\S"
      \ matchgroup=vimCmdSep
      \ end="|"
      \ end="\ze\s"
      \ end="$"
      \ skipwhite nextgroup=vimVimgrepFile
      \ contains=vimSpecFile,vimVimgrepEscape,vimVimgrepBarEscape
syn match	vimVimgrepFlags	  contained	"\<[gjf]\{,3\}\>" skipwhite nextgroup=vimVimgrepfile

" Maps: {{{2
" ====
" GEN_SYN_VIM: vimCommand map, START_STR='syn keyword vimMap', END_STR='skipwhite nextgroup=vimMapMod,vimMapLhs'
syn keyword vimMap cm[ap] cno[remap] im[ap] ino[remap] lm[ap] ln[oremap] nm[ap] nn[oremap] om[ap] ono[remap] smap snor[emap] tma[p] tno[remap] vm[ap] vn[oremap] xm[ap] xn[oremap] skipwhite nextgroup=vimMapMod,vimMapLhs
syn match	vimMap	"\<map\>"	skipwhite nextgroup=vimMapBang,vimMapMod,vimMapLhs
syn keyword	vimMap	no[remap]	skipwhite nextgroup=vimMapBang,vimMapMod,vimMapLhs
" GEN_SYN_VIM: vimCommand mapclear, START_STR='syn keyword vimMap', END_STR='skipwhite nextgroup=vimMapMod'
syn keyword vimMap cmapc[lear] imapc[lear] lmapc[lear] nmapc[lear] omapc[lear] smapc[lear] tmapc[lear] vmapc[lear] xmapc[lear] skipwhite nextgroup=vimMapMod
syn keyword	vimMap	mapc[lear]	skipwhite nextgroup=vimMapBang,vimMapMod
" GEN_SYN_VIM: vimCommand unmap, START_STR='syn keyword vimUnmap', END_STR='skipwhite nextgroup=vimMapMod,vimMapLhs'
syn keyword vimUnmap cu[nmap] iu[nmap] lu[nmap] nun[map] ou[nmap] sunm[ap] tunma[p] vu[nmap] xu[nmap] skipwhite nextgroup=vimMapMod,vimMapLhs
syn keyword	vimUnmap	unm[ap]	skipwhite nextgroup=vimMapBang,vimMapMod,vimMapLhs

syn match	vimMapLhs	contained	"\%(.\|\S\)\+"		contains=vimCtrlChar,vimNotation,vimMapLeader skipwhite        nextgroup=vimMapRhs
syn match	vimMapLhs	contained	"\%(.\|\S\)\+\ze\s*$"	contains=vimCtrlChar,vimNotation,vimMapLeader skipwhite skipnl nextgroup=vimMapRhsContinue
syn match	vimMapBang	contained	"\a\@1<=!"		skipwhite nextgroup=vimMapMod,vimMapLhs
syn match	vimMapMod	contained	"\%#=1<\%(buffer\|expr\|nowait\|script\|silent\|special\|unique\)\+>" contains=vimMapModKey,vimMapModErr skipwhite nextgroup=vimMapMod,vimMapLhs
syn region	vimMapRhs	contained
      \ start="\S"
      \ skip=+\\|\|\@1<=|\|\n\s*\%(\\\|["#]\\ \)+
      \ end="\ze|"
      \ end="$"
      \ nextgroup=vimCmdSep
      \ contains=@vimContinue,vimCtrlChar,vimNotation,vimMapLeader
syn region	vimMapRhsContinue	contained
      \ start=+^\s*\%(\\\|["#]\\ \)+
      \ skip=+\\|\|\@1<=|\|\n\s*\%(\\\|["#]\\ \)+
      \ end="\ze|"
      \ end="$"
      \ nextgroup=vimCmdSep
      \ contains=@vimContinue,vimCtrlChar,vimNotation,vimMapLeader
syn match	vimMapLeader	contained	"\%#=1\c<\%(local\)\=leader>"	contains=vimMapLeaderKey
syn keyword	vimMapModKey	contained	buffer expr nowait script silent special unique
syn case ignore
syn keyword	vimMapLeaderKey	contained	leader localleader
syn case match

" Menus: {{{2
" =====
" NOTE: tail comments disallowed
" GEN_SYN_VIM: vimCommand menu, START_STR='syn keyword vimMenu', END_STR='skipwhite nextgroup=vimMenuBang,vimMenuMod,vimMenuName,vimMenuPriority,vimMenuStatus'
syn keyword vimMenu am[enu] an[oremenu] aun[menu] cme[nu] cnoreme[nu] cunme[nu] ime[nu] inoreme[nu] iunme[nu] me[nu] nme[nu] nnoreme[nu] noreme[nu] nunme[nu] ome[nu] onoreme[nu] ounme[nu] sme[nu] snoreme[nu] sunme[nu] tlm[enu] tln[oremenu] tlu[nmenu] tm[enu] tu[nmenu] unme[nu] vme[nu] vnoreme[nu] vunme[nu] xme[nu] xnoreme[nu] xunme[nu] skipwhite nextgroup=vimMenuBang,vimMenuMod,vimMenuName,vimMenuPriority,vimMenuStatus
syn keyword vimMenu popu[p] skipwhite nextgroup=vimMenuBang,vimMenuName
syn region	vimMenuRhs	 contained contains=@vimContinue,vimNotation start="|\@!\S"            skip=+\\\\\|\\|\|\n\s*\\\|\n\s*"\\ + end="$" matchgroup=vimSep end="|"
syn region	vimMenuRhsContinue contained contains=@vimContinue,vimNotation start=+^\s*\%(\\\|"\\ \)+ skip=+\\\\\|\\|\|\n\s*\\\|\n\s*"\\ + end="$" matchgroup=vimSep end="|"
syn match	vimMenuName	"\.\@!\%(\\\s\|\S\)\+"        contained contains=vimMenuNotation,vimNotation skipwhite        nextgroup=vimCmdSep,vimMenuRhs
syn match	vimMenuName	"\.\@!\%(\\\s\|\S\)\+\ze\s*$" contained contains=vimMenuNotation,vimNotation skipwhite skipnl nextgroup=vimCmdSep,vimMenuRhsContinue
syn match	vimMenuNotation	"&\a\|&&\|\\\s\|\\\." contained
syn match	vimMenuPriority	"\<\d\+\%(\.\d\+\)*\>" contained skipwhite nextgroup=vimMenuName
syn match	vimMenuMod	"\c<\%(script\|silent\|special\)>" contained skipwhite nextgroup=vimMenuName,vimMenuPriority,vimMenuMod contains=vimMapModKey,vimMapModErr
syn keyword	vimMenuStatus	enable disable nextgroup=vimMenuName skipwhite
syn match	vimMenuBang	"\a\@1<=!" contained skipwhite nextgroup=vimMenuName,vimMenuMod

syn region	vimMenutranslate
      \ matchgroup=vimCommand start="\<menut\%[ranslate]\>"
      \ skip=+\\\\\|\\|\|\n\s*\\\|\n\s*"\\ +
      \ end="$" matchgroup=vimCmdSep end="|" matchgroup=vimMenuClear end="\<clear\ze\s*\%(["#|]\|$\)"
      \ contains=@vimContinue,vimMenutranslateName keepend transparent
" oneline is sufficient to match the current formatting in runtime/lang/*.vim
syn match	vimMenutranslateName "\%(\\\s\|\S\)\+" contained contains=vimMenuNotation,vimNotation
syn match	vimMenutranslateComment +".*+ contained containedin=vimMenutranslate

" If, While and Return: {{{2
" ====================
syn match	vimNotFunc	"\%#=1\<\%(if\|el\%[seif]\|retu\%[rn]\|while\)\>"	skipwhite nextgroup=@vimExprList,vimNotation
syn match	vimElse	"\<el\%[se]\>"			skipwhite nextgroup=vimComment,vim9Comment
syn match	vimEndif	"\<en\%[dif]\>"			skipwhite nextgroup=vimComment,vim9Comment

" Angle-Bracket Notation: (tnx to Michael Geddes) {{{2
" ======================
syn case ignore
syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%([scamd]-\)\{0,4}x\=\%(f\d\{1,2}\|[^ \t:]\|space\|bar\|bslash\|nl\|newline\|lf\|linefeed\|cr\|retu\%[rn]\|enter\|k\=del\%[ete]\|bs\|backspace\|tab\|esc\|csi\|right\|paste\%(start\|end\)\|left\|help\|undo\|k\=insert\|ins\|mouse\|[kz]\=home\|[kz]\=end\|kplus\|kminus\|kdivide\|kmultiply\|kenter\|kpoint\|space\|k\=\%(page\)\=\%(\|down\|up\|k\d\>\)\)>" contains=vimBracket

syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%([scamd2-4]-\)\{0,4}\%(net\|dec\|jsb\|pterm\|urxvt\|sgr\)mouse>"		contains=vimBracket
syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%([scamd2-4]-\)\{0,4}\%(left\|middle\|right\)\%(mouse\|drag\|release\)>"	contains=vimBracket
syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%([scamd2-4]-\)\{0,4}left\%(mouse\|release\)nm>"			contains=vimBracket
syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%([scamd2-4]-\)\{0,4}x[12]\%(mouse\|drag\|release\)>"		contains=vimBracket
syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%([scamd2-4]-\)\{0,4}sgrmouserelease>"			contains=vimBracket
syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%([scamd2-4]-\)\{0,4}mouse\%(up\|down\|move\)>"			contains=vimBracket
syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%([scamd2-4]-\)\{0,4}scrollwheel\%(up\|down\|right\|left\)>"		contains=vimBracket

syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%(sid\|nop\|nul\|lt\|drop\)>"				contains=vimBracket
syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%(snr\|plug\|cursorhold\|ignore\|cmd\|scriptcmd\|focus\%(gained\|lost\)\)>"	contains=vimBracket
" syn match	vimNotation	contained	'\%(\\\|<lt>\)\=<C-R>[0-9a-z"%#:.\-=]'he=e-1				contains=vimBracket
syn match	vimNotation	contained	'\%#=1\%(\\\|<lt>\)\=<\%([fq]-\)\=\%(line[12]\|count\|bang\|reg\|args\|mods\|lt\)>'		contains=vimBracket skipwhite nextgroup=vimSubst1
syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%([cas]file\|abuf\|amatch\|cexpr\|cword\|cWORD\|client\|stack\|script\|sf\=lnum\)>"	contains=vimBracket
syn match	vimNotation	contained	"\%#=1\%(\\\|<lt>\)\=<\%([scamd]-\)\{0,4}char-\%(\d\+\|0\o\+\|0x\x\+\)>"		contains=vimBracket

syn match	vimBracket contained	"[\\<>]"
syn case match

" User Command Highlighting: {{{2
syn match vimUsrCmd	'^\s*\zs\u\%(\w*\)\@>\%([.(#[]\|\s\+\%([-+*/%]\=\|\.\.\)=\)\@!'

" Vim user commands

" Compiler plugins
syn match	vimCompilerSet	"\<CompilerSet\>"	skipwhite nextgroup=vimSetArgs

" runtime/makemenu.vim
syn match	vimSynMenu		"\<SynMenu\>"	skipwhite nextgroup=vimSynMenuPath
syn match	vimSynMenuPath	contained	".*\ze:"	nextgroup=vimSynMenuColon contains=vimMenuNotation
syn match	vimSynMenuColon	contained	":"	nextgroup=vimSynMenuName
syn match	vimSynMenuName	contained	"\w\+"

" runtime/syntax/syncolor.vim
syn match	vimSynColor		"\<SynColor\>"	skipwhite nextgroup=vimSynColorGroup
syn match	vimSynColorGroup	contained	"\<\h\w*\>"	skipwhite nextgroup=vimHiKeyList	contains=vimGroup
syn match	vimSynLink		"\<SynLink\>"	skipwhite nextgroup=vimSynLinkGroup
syn match	vimSynLinkGroup	contained	"\<\h\w*\>"	skipwhite nextgroup=vimGroup	contains=vimGroup

syn cluster vimExUserCmdList contains=vimCompilerSet,vimSynColor,vimSynLink,vimSynMenu

" Errors And Warnings: {{{2
" ====================
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_novimfunctionerror")
 syn match	vimFunctionError	contained	"[[:space:]!]\@1<=\<[a-z0-9]\w\{-}\ze\s*("
 syn match	vimFunctionError	contained	"\%(<[sS][iI][dD]>\|[sg]:\)\d\w\{-}\ze\s*("
 syn match	vimElseIfErr	"\<else\s\+if\>"
 syn match	vimBufnrWarn	/\<bufnr\s*(\s*["']\.['"]\s*)/
endif

" Match: {{{2
" =====
syn match	vimMatch		"\<\%([1-3]\s*\)\=mat\%[ch]\>"	skipwhite nextgroup=vimMatchGroup,vimMatchNone contains=vimCount
syn match	vimMatchGroup	contained	"[[:alnum:]._-]\+"	skipwhite nextgroup=vimMatchPattern
syn case ignore
syn keyword	vimMatchNone	contained	none
syn case match
syn region	vimMatchPattern	contained
      \ matchgroup=Delimiter
      \ start="\z([!#$%&'()*+,-./:;<=>?@[\]^_`{}~]\)"
      \ skip="\\\\\|\\\z1"
      \ end="\z1"
      \ contains=@vimSubstList
      \ oneline

" Normal: {{{2
" ======
syn match	vimNormal		"\<norm\%[al]\>!\=" skipwhite nextgroup=vimNormalArg contains=vimBang
syn region	vimNormalArg	contained	start="\S" skip=+\n\s*\\\|\n\s*["#]\\ + end="$" contains=@vimContinue

" Profile: {{{2
" =======
syn match	vimProfileBang	 contained	"\a\@1<=!"	skipwhite nextgroup=vimProfileArg
syn keyword	vimProfileArg	 contained	start	skipwhite nextgroup=vimProfilePattern
syn keyword	vimProfileArg	 contained	func	skipwhite nextgroup=vimProfilePattern
syn keyword	vimProfileArg	 contained	file	skipwhite nextgroup=vimProfilePattern
syn keyword	vimProfileArg	 contained	stop pause	skipwhite nextgroup=vimCmdSep,@vimComment
syn keyword	vimProfileArg	 contained	continue dump	skipwhite nextgroup=vimCmdSep,@vimComment
" TODO: match file pattern
syn region	vimProfilePattern contained
      \ start="\S"
      \ skip=+\\[|"#]+
      \ end="$" end=+\ze\s*[|"#]+
      \ skipwhite nextgroup=vimCmdSep,vimComment,vim9Comment
syn match	vimProfile	"\<prof\%[ile]\>"	skipwhite nextgroup=vimProfileBang,vimProfileArg

syn keyword	vimProfdelArg	contained	func	skipwhite nextgroup=vimProfilePattern
syn keyword	vimProfdelArg	contained	file	skipwhite nextgroup=vimProfilePattern
syn keyword	vimProfdelArg	contained	here	skipwhite nextgroup=vimCmdSep,@vimComment
syn match	vimProfdel	"\<profd\%[el]\>" skipwhite nextgroup=vimProfdelArg

" Redir: {{{2
" =====
syn match	vimRedir		"\<redir\=\>"	skipwhite nextgroup=vimRedirBang,vimRedirFileOperator,vimRedirVariableOperator,vimRedirRegister,vimRedirEnd
syn match	vimRedirBang	       contained	"\a\@1<=!"	skipwhite nextgroup=vimRedirFileOperator

syn match	vimRedirFileOperator     contained	">>\="	skipwhite nextgroup=vimRedirFile
syn region	vimRedirFile	       contained
      \ start="\S"
      \ matchgroup=Normal
      \ end="\s*$"
      \ end="\s*\ze[|"]"
      \ nextgroup=vimCmdSep,vimComment
      \ contains=vimSpecFile
syn match	vimRedirRegisterOperator contained	">>\="
syn match	vimRedirRegister	       contained	"@[a-zA-Z*+"]"	nextgroup=vimRedirRegisterOperator
syn match	vimRedirVariableOperator contained	"=>>\="	skipwhite nextgroup=vimVar
syn keyword	vimRedirEnd	       contained	END

" Sleep: {{{2
" =====
syn keyword	vimSleep		sl[eep]		skipwhite nextgroup=vimSleepBang,vimSleepArg
syn match	vimSleepBang	contained	"\a\@1<=!"		skipwhite nextgroup=vimSleepArg
syn match	vimSleepArg	contained	"\<\%(\d\+\)\=m\=\>"

" Sort: {{{2
" ====
syn match	vimSort		"\<sort\=\>"			skipwhite nextgroup=vimSortBang,@vimSortOptions,vimSortPattern,vimCmdSep
syn match	vimSortBang	  contained	"\a\@1<=!"			skipwhite nextgroup=@vimSortOptions,vimSortPattern,vimCmdSep
syn match	vimSortOptionsError contained	"\a\+"
syn match	vimSortOptions	  contained	"\<[ilur]*[nfxob]\=[ilur]*\>"		skipwhite nextgroup=vimSortPattern,vimCmdSep
syn region	vimSortPattern	  contained
      \ matchgroup=Delimiter
      \ start="\z([^[:space:][:alpha:]|]\)"
      \ skip="\\\\\|\\\z1"
      \ end="\z1"
      \ skipwhite nextgroup=@vimSortOptions,vimCmdSep
      \ contains=@vimSubstList
      \ oneline

syn cluster vimSortOptions contains=vimSortOptions,vimSortOptionsError

" Uniq: {{{2
" ====
syn match	vimUniq		"\<uniq\=\>"	skipwhite nextgroup=vimUniqBang,@vimUniqOptions,vimUniqPattern,vimCmdSep
syn match	vimUniqBang	  contained	"\a\@1<=!"	skipwhite nextgroup=@vimUniqOptions,vimUniqPattern,vimCmdSep
syn match	vimUniqOptionsError contained	"\a\+"
syn match	vimUniqOptions	  contained	"\<[ilur]*\>"	skipwhite nextgroup=vimUniqPattern,vimCmdSep
syn region	vimUniqPattern	  contained
      \ matchgroup=Delimiter
      \ start="\z([^[:space:][:alpha:]|]\)"
      \ skip="\\\\\|\\\z1"
      \ end="\z1"
      \ skipwhite nextgroup=@vimUniqOptions,vimCmdSep
      \ contains=@vimSubstList
      \ oneline

syn cluster vimUniqOptions contains=vimUniqOptions,vimUniqOptionsError

" Syntax: {{{2
"=======
syn match	vimGroupList	contained	"[^[:space:],]\+\%(\s*,\s*[^[:space:],]\+\)*" contains=vimGroupSpecial
syn region	vimGroupList	contained	start=/^\s*["#]\\ \|^\s*\\\|[^[:space:],]\+\s*,/ skip=/\s*\n\s*\\\|\s*\n\s*["#]\\ \|^\s*\\\|^\s*["#]\\ / end=/[^[:space:],]\s*$\|[^[:space:],]\ze\s\+\w/ contains=@vimContinue,vimGroupSpecial
syn keyword	vimGroupSpecial	contained	ALL	ALLBUT	CONTAINED	TOP

if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_novimsynerror")
 syn match	vimSynError	contained	"\i\+"
 syn match	vimSynError	contained	"\i\+="	nextgroup=vimGroupList
endif
syn match	vimSynContains	contained	"\<contain\%(s\|edin\)="	skipwhite skipnl nextgroup=vimGroupList
syn match	vimSynKeyContainedin	contained	"\<containedin="	skipwhite skipnl nextgroup=vimGroupList
syn match	vimSynNextgroup	contained	"\<nextgroup="		skipwhite skipnl nextgroup=vimGroupList
if has("conceal")
 " no whitespace allowed after '='
 syn match	vimSynCchar	contained	"\<cchar="	nextgroup=vimSynCcharValue
 syn match	vimSynCcharValue	contained	"\S"
endif

syn match	vimSyntax	"\<sy\%[ntax]\>"	contains=vimCommand skipwhite nextgroup=vimSynType,@vimComment
syn cluster vimFunctionBodyList add=vimSyntax

" Syntax: case {{{2
syn keyword	vimSynType	contained	case	skipwhite nextgroup=vimSynCase,vimSynCaseError
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_novimsyncaseerror")
 syn match	vimSynCaseError	contained	"\i\+"
endif
syn keyword	vimSynCase	contained	ignore	match

" Syntax: clear {{{2
syn keyword	vimSynType	contained	clear	skipwhite nextgroup=vimGroupList

" Syntax: cluster {{{2
syn keyword	vimSynType	contained	cluster	skipwhite nextgroup=vimClusterName
syn region	vimClusterName	contained keepend	matchgroup=vimGroupName start="\h\w*\>" skip=+\\\\\|\\\|\n\s*\\\|\n\s*"\\ + matchgroup=vimCmdSep end="$\||" contains=@vimContinue,vimGroupAdd,vimGroupRem,vimSynContains,vimSynError
syn match	vimGroupAdd	contained keepend	"\<add="	skipwhite skipnl nextgroup=vimGroupList
syn match	vimGroupRem	contained keepend	"\<remove="	skipwhite skipnl nextgroup=vimGroupList

" Syntax: conceal {{{2
syn match	vimSynType	contained	"\<conceal\>"	skipwhite nextgroup=vimSynConceal,vimSynConcealError
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_novimsynconcealerror")
 syn match	vimSynConcealError contained	"\i\+"
endif
syn keyword	vimSynConceal	contained	on	off

" Syntax: foldlevel {{{2
syn keyword	vimSynType	contained	foldlevel	skipwhite nextgroup=vimSynFoldlevel,vimSynFoldlevelError
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_novimsynfoldlevelerror")
 syn match	vimSynFoldlevelError	contained	"\i\+"
endif
syn keyword	vimSynFoldlevel	contained	start	minimum

" Syntax: iskeyword {{{2
syn keyword	vimSynType		contained	iskeyword	skipwhite nextgroup=vimSynIskeyword
syn keyword	vimSynIskeyword		contained	clear
syn match	vimSynIskeyword		contained	"\S\+"	contains=vimSynIskeywordSep
syn match	vimSynIskeywordSep	contained	","

" Syntax: include {{{2
syn keyword	vimSynType	contained	include	skipwhite nextgroup=vimGroupList

" Syntax: keyword {{{2
syn cluster	vimSynKeyGroup	contains=@vimContinue,vimSynCchar,vimSynNextgroup,vimSynKeyOpt,vimSynKeyContainedin
syn keyword	vimSynType	contained	keyword	skipwhite nextgroup=vimSynKeyRegion
syn region	vimSynKeyRegion	contained         keepend	matchgroup=vimGroupName start="\h\w*\>" skip=+\\\\\|\\|\|\n\s*\\\|\n\s*"\\ + matchgroup=vimCmdSep end="|\|$" contains=@vimSynKeyGroup
syn match	vimSynKeyOpt	contained	"\%#=1\<\%(conceal\|contained\|transparent\|skipempty\|skipwhite\|skipnl\)\>"

" Syntax: match {{{2
syn cluster	vimSynMtchGroup	contains=@vimContinue,vimSynCchar,vimSynContains,vimSynError,vimSynMtchOpt,vimSynNextgroup,vimSynRegPat,vimNotation,vimMtchComment
syn keyword	vimSynType	contained	match	skipwhite nextgroup=vimSynMatchRegion
syn region	vimSynMatchRegion	contained keepend	matchgroup=vimGroupName start="\h\w*\>" skip=+\\\\\|\\|\|\n\s*\\\|\n\s*"\\ + matchgroup=vimCmdSep end="|\|$" contains=@vimSynMtchGroup
syn match	vimSynMtchOpt	contained	"\%#=1\<\%(conceal\|transparent\|contained\|excludenl\|keepend\|skipempty\|skipwhite\|display\|extend\|skipnl\|fold\)\>"

" Syntax: off and on {{{2
syn keyword	vimSynType	contained	enable	list	manual	off	on	reset

" Syntax: region {{{2
syn cluster	vimSynRegPatGroup	contains=@vimContinue,vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange,vimSubstSubstr,vimPatRegion,vimPatSepErr,vimNotation
syn cluster	vimSynRegGroup	contains=@vimContinue,vimSynCchar,vimSynContains,vimSynNextgroup,vimSynRegOpt,vimSynReg,vimSynMtchGrp
syn keyword	vimSynType	contained	region	skipwhite nextgroup=vimSynRegion
syn region	vimSynRegion	contained keepend	matchgroup=vimGroupName start="\h\w*" skip=+\\\\\|\\\|\n\s*\\\|\n\s*"\\ + matchgroup=vimCmdSep end="|\|$" contains=@vimSynRegGroup
syn match	vimSynRegOpt	contained	"\%#=1\<\%(conceal\%(ends\)\=\|transparent\|contained\|excludenl\|skipempty\|skipwhite\|display\|keepend\|oneline\|extend\|skipnl\|fold\)\>"
syn match	vimSynReg	contained	"\<\%(start\|skip\|end\)="	nextgroup=vimSynRegPat
syn match	vimSynMtchGrp	contained	"matchgroup="	nextgroup=vimGroup,vimHLGroup,vimOnlyHLGroup,nvimHLGroup
syn region	vimSynRegPat	contained extend	start="\z([-`~!@#$%^&*_=+;:'",./?]\)"  skip=/\\\\\|\\\z1\|\n\s*\\\|\n\s*"\\ /  end="\z1"  contains=@vimSynRegPatGroup skipwhite nextgroup=vimSynPatMod,vimSynReg
syn match	vimSynPatMod	contained	"\%#=1\%(hs\|ms\|me\|hs\|he\|rs\|re\)=[se]\%([-+]\d\+\)\="
syn match	vimSynPatMod	contained	"\%#=1\%(hs\|ms\|me\|hs\|he\|rs\|re\)=[se]\%([-+]\d\+\)\=," nextgroup=vimSynPatMod
syn match	vimSynPatMod	contained	"lc=\d\+"
syn match	vimSynPatMod	contained	"lc=\d\+," nextgroup=vimSynPatMod
syn region	vimSynPatRange	contained	start="\["	skip="\\\\\|\\]"   end="]"
syn match	vimSynNotPatRange	contained	"\\\\\|\\\["
syn match	vimMtchComment	contained	'"[^"]\+$'

" Syntax: spell {{{2
syn keyword	vimSynType	contained	spell	skipwhite nextgroup=vimSynSpell,vimSynSpellError
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_novimsynspellerror")
 syn match	vimSynSpellError contained	"\i\+"
endif
syn keyword	vimSynSpell	contained	default	notoplevel	toplevel

" Syntax: sync {{{2
" ============
syn keyword vimSynType	contained	sync	skipwhite	nextgroup=vimSyncClear,vimSyncMatch,vimSyncError,vimSyncRegion,vimSyncArgs
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_novimsyncerror")
 syn match	vimSyncError	contained	"\i\+"
endif

syn region	vimSyncArgs	contained	start="\S" skip=+\\\\\|\\|\|\n\s*\\\|\n\s*"\\ + matchgroup=vimCmdSep end="|\|$" contains=vimSyncLines,vimSyncLinebreak,vimSyncLinecont,vimSyncFromstart,vimSyncCcomment

syn keyword	vimSyncCcomment	contained	ccomment	skipwhite	nextgroup=vimGroupName
syn keyword	vimSyncClear	contained	clear	skipwhite	nextgroup=vimSyncGroupName
syn keyword	vimSyncFromstart	contained	fromstart
syn keyword	vimSyncMatch	contained	match	skipwhite	nextgroup=vimSyncGroupName
syn keyword	vimSyncRegion	contained	region	skipwhite	nextgroup=vimSynRegion
syn match	vimSyncLinebreak	contained	"\<linebreaks="		nextgroup=vimNumber
syn keyword	vimSyncLinecont	contained	linecont	skipwhite	nextgroup=vimSynRegPat
syn match	vimSyncLines	contained	"\<lines="		nextgroup=vimNumber
syn match	vimSyncLines	contained	"\<minlines="		nextgroup=vimNumber
syn match	vimSyncLines	contained	"\<maxlines="		nextgroup=vimNumber
syn match	vimSyncGroupName	contained	"\<\h\w*\>"	skipwhite	nextgroup=vimSyncKey
syn match	vimSyncKey	contained	"\<grouphere\>"	skipwhite	nextgroup=vimSyncGroup
syn match	vimSyncKey	contained	"\<groupthere\>"	skipwhite	nextgroup=vimSyncGroup
syn match	vimSyncGroup	contained	"\<\h\w*\>"	skipwhite	nextgroup=vimSynRegPat,vimSyncNone
syn keyword	vimSyncNone	contained	NONE

" Additional IsCommand: here by reasons of precedence {{{2
" ====================
syn match	vimIsCommand	"<Bar>\s*\a\+"	transparent contains=vimCommand,vimNotation

" Highlighting: {{{2
" ============
syn cluster	vimHighlightCluster		contains=vimHiLink,vimHiClear,vimHiKeyList,@vimComment
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_novimhictermerror")
 syn match	vimHiCtermError	contained	"\D\i*"
endif
syn match	vimHighlight	"\<hi\%[ghlight]\>"	skipwhite nextgroup=vimHiBang,@vimHighlightCluster
syn match	vimHiBang	contained	"\a\@1<=!"	skipwhite nextgroup=@vimHighlightCluster

syn case ignore
" Conceal is a generated low-priority match
syn match	vimHiGroup	contained	"\%(\<Conceal\>\)\@!\i\+"
syn keyword	vimHiNone	contained	NONE
syn keyword	vimHiAttrib	contained	none bold inverse italic nocombine reverse standout strikethrough underline undercurl underdashed underdotted underdouble
syn keyword	vimFgBgAttrib	contained	none bg background fg foreground
syn case match
syn match	vimHiAttribList	contained	"\i\+"	contains=vimHiAttrib
syn match	vimHiAttribList	contained	"\i\+,"he=e-1	contains=vimHiAttrib nextgroup=vimHiAttribList
syn case ignore
syn keyword	vimHiCtermColor	contained	black blue brown cyan darkblue darkcyan darkgray darkgreen darkgrey darkmagenta darkred darkyellow gray green grey grey40 grey50 grey90 lightblue lightcyan lightgray lightgreen lightgrey lightmagenta lightred lightyellow magenta red seagreen white yellow
syn match	vimHiCtermColor	contained	"\<color\d\{1,3}\>"
syn case match

syn match	vimHiFontname	contained	"[a-zA-Z\-*]\+"
syn match	vimHiGuiFontname	contained	"'[a-zA-Z\-* ]\+'"
syn match	vimHiGuiRgb	contained	"#\x\{6}"

" Highlighting: hi group key=arg ... {{{2
syn cluster	vimHiCluster contains=vimGroup,vimHLGroup,vimHiBlend,vimHiGroup,vimHiNone,vimHiTerm,vimHiCTerm,vimHiStartStop,vimHiCtermFgBg,vimHiCtermul,vimHiCtermfont,vimHiGui,vimHiGuiFont,vimHiGuiFgBg,vimHiKeyError,vimNotation,vimComment,vim9comment
syn region	vimHiKeyList	contained 	start="\i\+" skip=+\\\\\|\\|\|\n\s*\\\|\n\s*"\\ + matchgroup=vimCmdSep end="|" excludenl end="$" contains=@vimContinue,@vimHiCluster
if !exists("g:vimsyn_noerror") && !exists("g:vimsyn_vimhikeyerror")
 syn match	vimHiKeyError	contained	"\i\+="he=e-1
endif
syn match	vimHiTerm	contained	"\cterm="he=e-1		nextgroup=vimHiAttribList
syn match	vimHiStartStop	contained	"\c\%(start\|stop\)="he=e-1	nextgroup=vimHiTermcap,vimOption
syn match	vimHiCTerm	contained	"\ccterm="he=e-1		nextgroup=vimHiAttribList
syn match	vimHiCtermFgBg	contained	"\ccterm[fb]g="he=e-1	nextgroup=vimHiNmbr,vimHiCtermColor,vimFgBgAttrib,vimHiCtermError
syn match	vimHiCtermul	contained	"\cctermul="he=e-1	nextgroup=vimHiNmbr,vimHiCtermColor,vimFgBgAttrib,vimHiCtermError
syn match	vimHiCtermfont	contained	"\cctermfont="he=e-1	nextgroup=vimHiNmbr,vimHiCtermColor,vimFgBgAttrib,vimHiCtermError
syn match	vimHiGui	contained	"\cgui="he=e-1		nextgroup=vimHiAttribList
syn match	vimHiGuiFont	contained	"\cfont="he=e-1		nextgroup=vimHiFontname
syn match	vimHiGuiFgBg	contained	"\cgui\%([fb]g\|sp\)="he=e-1	nextgroup=vimHiGroup,vimHiGuiFontname,vimHiGuiRgb,vimFgBgAttrib
syn match	vimHiTermcap	contained	"\S\+"		contains=vimNotation
syn match	vimHiBlend	contained	"\cblend="he=e-1		nextgroup=vimHiNmbr
syn match	vimHiNmbr	contained	'\d\+'

" Highlight: clear {{{2
syn keyword	vimHiClear	contained	clear	skipwhite nextgroup=vimGroup,vimHLGroup,vimHiGroup

" Highlight: link {{{2
" see tst24 (hi def vs hi) (Jul 06, 2018)
"syn region	vimHiLink	contained oneline matchgroup=vimCommand start="\(\<hi\%[ghlight]\s\+\)\@<=\(\(def\%[ault]\s\+\)\=link\>\|\<def\>\)" end="$"	contains=vimHiGroup,vimGroup,vimHLGroup,vimNotation
" TODO: simplify and allow line continuations --djk
syn region	vimHiLink	contained matchgroup=Type start="\%(\<hi\%[ghlight]!\=\s\+\)\@<=\%(\%(def\%[ault]\s\+\)\=link\>\|\<def\%[ault]\>\)" skip=+\\\\\|\\|\|\n\s*\\\|\n\s*"\\ + matchgroup=vimCmdSep end="|" excludenl end="$" contains=@vimContinue,@vimHiCluster

" Control Characters: {{{2
" ==================
syn match	vimCtrlChar	"[--]"

" Embedded Scripts:  {{{2
" ================
"   perl,ruby	: Benoit Cerrina
"   python,tcl	: Johannes Zellner
"   mzscheme, lua : Charles Campbell

" Allows users to specify the type of embedded script highlighting
" they want:  (lua/mzscheme/perl/python/ruby/tcl support)
"   g:vimsyn_embed == 0   : don't embed any scripts
"   g:vimsyn_embed =~# 'l' : embed Lua
"   g:vimsyn_embed =~# 'm' : embed MzScheme
"   g:vimsyn_embed =~# 'p' : embed Perl
"   g:vimsyn_embed =~# 'P' : embed Python
"   g:vimsyn_embed =~# 'r' : embed Ruby
"   g:vimsyn_embed =~# 't' : embed Tcl

let s:interfaces = get(g:, "vimsyn_embed", "l")

" [-- lua --] {{{3
if s:interfaces =~# 'l'
  syn include @vimLuaScript syntax/lua.vim
  unlet b:current_syntax
endif

syn keyword	vimLua	lua	skipwhite nextgroup=vimLuaHeredoc,vimLuaStatement
syn keyword	vimLua	luado	skipwhite nextgroup=vimLuaStatement
syn keyword	vimLua	luafile

syn region	vimLuaStatement	contained
      \ start="\S"
      \ skip=+\n\s*\%(\\\|["#]\\ \)+
      \ end="$"
      \ contains=@vimLuaScript,@vimContinue
VimFoldl syn region vimLuaHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\s*\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1$+
      \ contains=@vimLuaScript
VimFoldl syn region vimLuaHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\.$+
      \ contains=@vimLuaScript
VimFoldl syn region vimLuaHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\s\+\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\z2$+
      \ contains=@vimLuaScript
VimFoldl syn region vimLuaHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\.$+
      \ contains=@vimLuaScript

" [-- mzscheme --] {{{3
if s:interfaces =~# 'm'
  let s:iskKeep = &isk
  syn include @vimMzSchemeScript syntax/scheme.vim
  unlet b:current_syntax
  let &isk = s:iskKeep
endif

syn keyword	vimMzScheme	mz[scheme]	skipwhite nextgroup=vimMzSchemeHeredoc,vimMzSchemeStatement
syn keyword	vimMzScheme	mzf[ile]

syn region	vimMzSchemeStatement	contained
      \ start="\S"
      \ skip=+\n\s*\%(\\\|["#]\\ \)+
      \ end="$"
      \ contains=@vimMzSchemeScript,@vimContinue
VimFoldm syn region vimMzSchemeHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\s*\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1$+
      \ contains=@vimMzSchemeScript
VimFoldm syn region vimMzSchemeHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\.$+
      \ contains=@vimMzSchemeScript
VimFoldm syn region vimMzSchemeHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\s\+\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\z2$+
      \ contains=@vimMzSchemeScript
VimFoldm syn region vimMzSchemeHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\.$+
      \ contains=@vimMzSchemeScript

" [-- perl --] {{{3
if s:interfaces =~# 'p'
  syn include @vimPerlScript syntax/perl.vim
  unlet b:current_syntax
endif

syn keyword	vimPerl	pe[rl]	skipwhite nextgroup=vimPerlHeredoc,vimPerlStatement
syn keyword	vimPerl	perld[o]	skipwhite nextgroup=vimPerlStatement

syn region	vimPerlStatement	contained
       \ start="\S"
       \ skip=+\n\s*\%(\\\|["#]\\ \)+
       \ end="$"
       \ contains=@vimPerlScript,@vimContinue
VimFoldp syn region vimPerlHeredoc	contained
       \ matchgroup=vimScriptHeredocStart
       \ start=+<<\s*\z(\S\+\)\ze\s*$+
       \ matchgroup=vimScriptHeredocStop
       \ end=+^\z1$+ contains=@vimPerlScript
VimFoldp syn region vimPerlHeredoc	contained
       \ matchgroup=vimScriptHeredocStart
       \ start=+<<\ze\s*$+	matchgroup=vimScriptHeredocStop
       \ end=+^\.$+
       \ contains=@vimPerlScript
VimFoldp syn region vimPerlHeredoc	contained
       \ matchgroup=vimScriptHeredocStart
       \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\s\+\z(\S\+\)\ze\s*$+
       \ matchgroup=vimScriptHeredocStop
       \ end=+^\z1\=\z2$+
       \ contains=@vimPerlScript
VimFoldp syn region vimPerlHeredoc	contained
       \ matchgroup=vimScriptHeredocStart
       \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\ze\s*$+
       \ matchgroup=vimScriptHeredocStop
       \ end=+^\z1\=\.$+
       \ contains=@vimPerlScript

" [-- python --] {{{3
if s:interfaces =~# 'P'
  syn include @vimPythonScript syntax/python2.vim
  unlet b:current_syntax
endif

syn keyword	vimPython	py[thon]	skipwhite nextgroup=vimPythonHeredoc,vimPythonStatement
syn keyword	vimPython	pydo	skipwhite nextgroup=vimPythonStatement
syn keyword	vimPython	pyfile

syn region	vimPythonStatement	contained
      \ start="\S"
      \ skip=+\n\s*\%(\\\|["#]\\ \)+
      \ end="$"
      \ contains=@vimPythonScript,@vimContinue
VimFoldP syn region vimPythonHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\s*\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1$+
      \ contains=@vimPythonScript
VimFoldP syn region vimPythonHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\.$+
      \ contains=@vimPythonScript
VimFoldP syn region vimPythonHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\s\+\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\z2$+
      \ contains=@vimPythonScript
VimFoldP syn region vimPythonHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\.$+
      \ contains=@vimPythonScript

" [-- python3 --] {{{3
if s:interfaces =~# 'P'
  syn include @vimPython3Script syntax/python.vim
  unlet b:current_syntax
endif

syn keyword	vimPython3	python3 py3	skipwhite nextgroup=vimPython3Heredoc,vimPython3Statement
syn keyword	vimPython3	py3do	skipwhite nextgroup=vimPython3Statement
syn keyword	vimPython3	py3file

syn region	vimPython3Statement	contained
      \ start="\S"
      \ skip=+\n\s*\%(\\\|["#]\\ \)+
      \ end="$"
      \ contains=@vimPython3Script,@vimContinue
VimFoldP syn region vimPython3Heredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\s*\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1$+
      \ contains=@vimPython3Script
VimFoldP syn region vimPython3Heredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\.$+
      \ contains=@vimPython3Script
VimFoldP syn region vimPython3Heredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\s\+\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\z2$+
      \ contains=@vimPython3Script
VimFoldP syn region vimPython3Heredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\.$+
      \ contains=@vimPython3Script

" [-- pythonx --] {{{3
if s:interfaces =~# 'P'
  if &pyxversion == 2
    syn cluster vimPythonXScript contains=@vimPythonScript
  else
    syn cluster vimPythonXScript contains=@vimPython3Script
  endif
endif

syn keyword	vimPythonX	pythonx pyx	skipwhite nextgroup=vimPythonXHeredoc,vimPythonXStatement
syn keyword	vimPythonX	pyxdo	skipwhite nextgroup=vimPythonXStatement
syn keyword	vimPythonX	pyxfile

syn region	vimPythonXStatement	contained
      \ start="\S"
      \ skip=+\n\s*\%(\\\|["#]\\ \)+
      \ end="$"
      \ contains=@vimPythonXScript,@vimContinue
VimFoldP syn region vimPythonXHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\s*\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1$+
      \ contains=@vimPythonXScript
VimFoldP syn region vimPythonXHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\.$+
      \ contains=@vimPythonXScript
VimFoldP syn region vimPythonXHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\s\+\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\z2$+
      \ contains=@vimPythonXScript
VimFoldP syn region vimPythonXHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\.$+
      \ contains=@vimPythonXScript

" [-- ruby --] {{{3
if s:interfaces =~# 'r'
  let s:foldmethod = &l:foldmethod
  syn include @vimRubyScript syntax/ruby.vim
  let &l:foldmethod = s:foldmethod
  unlet b:current_syntax
endif

syn keyword	vimRuby	rub[y]	skipwhite nextgroup=vimRubyHeredoc,vimRubyStatement
syn keyword	vimRuby	rubyd[o]	skipwhite nextgroup=vimRubyStatement
syn keyword	vimRuby	rubyf[ile]

syn region	vimRubyStatement	contained
      \ start="\S"
      \ skip=+\n\s*\%(\\\|["#]\\ \)+
      \ end="$"
      \ contains=@vimRubyScript,@vimContinue
VimFoldr syn region vimRubyHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\s*\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1$+
      \ contains=@vimRubyScript
VimFoldr syn region vimRubyHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\ze\s*$+	matchgroup=vimScriptHeredocStop
      \ end=+^\.$+
      \ contains=@vimRubyScript
VimFoldr syn region vimRubyHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\s\+\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\z2$+
      \ contains=@vimRubyScript
VimFoldr syn region vimRubyHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\.$+
      \ contains=@vimRubyScript

" [-- tcl --] {{{3
if s:interfaces =~# 't'
  syn include @vimTclScript syntax/tcl.vim
  unlet b:current_syntax
endif

syn keyword	vimTcl	tcl	skipwhite nextgroup=vimTclHeredoc,vimTclStatement
syn keyword	vimTcl	tcld[o]	skipwhite nextgroup=vimTclStatement
syn keyword	vimTcl	tclf[ile]
syn region	vimTclStatement	contained
      \ start="\S"
      \ skip=+\n\s*\%(\\\|["#]\\ \)+
      \ end="$"
      \ contains=@vimTclScript,@vimContinue
VimFoldt syn region vimTclHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\s*\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1$+
      \ contains=@vimTclScript
VimFoldt syn region vimTclHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+<<\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\.$+
      \ contains=@vimTclScript
VimFoldt syn region vimTclHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\s\+\z(\S\+\)\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\z2$+
      \ contains=@vimTclScript
VimFoldt syn region vimTclHeredoc	contained
      \ matchgroup=vimScriptHeredocStart
      \ start=+\%(^\z(\s*\)\S.*\)\@<=<<\s*trim\ze\s*$+
      \ matchgroup=vimScriptHeredocStop
      \ end=+^\z1\=\.$+
      \ contains=@vimTclScript

unlet s:interfaces
" Function Call Highlighting: {{{2
" (following Gautam Iyer's suggestion)
" ==========================
syn match	vimFunc	contained	"\<\l\w*\ze\s*("				skipwhite nextgroup=vimOperParen contains=vimFuncName
syn match	vimUserFunc	contained	"\.\@1<=\l\w*\ze\s*("			skipwhite nextgroup=vimOperParen
syn match	vimUserFunc	contained	"\<\%([[:upper:]_]\|\%(\h\w*\.\)\+\h\)\w*\ze\s*("		skipwhite nextgroup=vimOperParen contains=vim9MethodName,vim9Super,vim9This
syn match	vimUserFunc	contained	"\<\%(g:\)\=\%(\h\w*#\)\+\h\w*\ze\s*("		skipwhite nextgroup=vimOperParen contains=vimVarScope
syn match	vimUserFunc	contained	"\%(\<[sgbwtlav]:\|<[sS][iI][dD]>\)\%(\h\w*\.\)*\h\w*\ze\s*("	skipwhite nextgroup=vimOperParen contains=vimVarScope,vimNotation

Vim9 syn match	vim9UserFunc	"^\s*\zs\%([sgbwtv]:\|<[sS][iI][dD]>\)\=\%(\h\w*[.#]\)*\h\w*\ze("		skipwhite nextgroup=vimOperParen contains=vimVarScope,vimNotation,vim9MethodName,vim9Super,vim9This
Vim9 syn match	vim9Func	"^\s*\zs\l\w*\ze("				skipwhite nextgroup=vimOperParen contains=vimFuncName

syn cluster	vimFunc	contains=vimFunc,vimUserFunc
syn cluster	vim9Func	contains=vim9Func,vim9UserFunc

" Beginners - Patterns that involve ^ {{{2
" =========
Vim9 syn region	vim9LineComment	start=+^[ \t:]*\zs#.*$+ skip=+\n\s*\\\|\n\s*#\\ + end="$" contains=@vimCommentGroup,vimCommentString,vim9CommentTitle extend
VimL syn region	vimLineComment	start=+^[ \t:]*\zs".*$+ skip=+\n\s*\\\|\n\s*"\\ + end="$" contains=@vimCommentGroup,vimCommentString,vimCommentTitle extend

syn match	vimCommentTitle	'"\s*\%([sS]:\|\h\w*#\)\=\u\w*\(\s\+\u\w*\)*:'hs=s+1	contained contains=vimCommentTitleLeader,vimTodo,@vimCommentGroup
syn match	vim9CommentTitle	'#\s*\%([sS]:\|\h\w*#\)\=\u\w*\(\s\+\u\w*\)*:'hs=s+1	contained contains=vim9CommentTitleLeader,vimTodo,@vimCommentGroup

" allowed anywhere in the file
if !s:vim9script
  syn match	vimShebangError	"^\s*\zs#!.*" display
endif
syn match	vimShebang	"\%^#!.*" display

syn match	vimContinue		"^\s*\zs\\"
syn match	vimContinueComment	'^\s*\zs["#]\\ .*' extend
syn match	vim9ContinueComment	"^\s*\zs#\\ .*"	 extend
syn cluster	vimContinue	contains=vimContinue,vimContinueComment
syn cluster	vim9Continue	contains=vimContinue,vim9ContinueComment

syn region	vimString	start='^\s*\\"' end='"' oneline keepend contains=@vimStringGroup,vimContinue
syn region	vimString	start="^\s*\\'" end="'" oneline keepend contains=vimQuoteEscape,vimContinue

syn match	vimCommentTitleLeader	'"\s\+'ms=s+1	contained
syn match	vim9CommentTitleLeader	'#\s\+'ms=s+1	contained

" Searches And Globals: {{{2
" ====================
VimL syn match	vimSearch	'^\s*[/?].*'		contains=vimSearchDelim
syn match	vimSearchDelim	'^\s*\zs[/?]\|[/?]$'	contained
Vim9 syn match	vim9Search	'^\s*:[/?].*'		contains=vim9SearchDelim
syn match	vim9SearchDelim	'^\s*\zs:[/?]\|[/?]$'	contained contains=vimCmdSep
syn region	vimGlobal	matchgroup=Statement start='\<g\%[lobal]!\=/'  skip='\\.' end='/'	skipwhite nextgroup=vimSubst1
syn region	vimGlobal	matchgroup=Statement start='\<v\%[global]!\=/' skip='\\.' end='/'	skipwhite nextgroup=vimSubst1

" Vim9 script Regions: {{{2
" ==================

if s:vim9script
  syn cluster vimLegacyTop	contains=TOP,vim9LegacyHeader,vim9Comment,vim9LineComment
  VimFoldH syn region vim9LegacyHeader start="\%^" end="^\ze\s*vim9s\%[cript]\>" contains=@vimLegacyTop,vimComment,vimLineComment

  syn keyword vim9Vim9ScriptArg	noclear contained
  syn keyword vim9Vim9Script	vim9s[cript] nextgroup=vim9Vim9ScriptArg skipwhite
endif

" Synchronize (speed) {{{2
"============

exe "syn sync minlines=" .. get(g:, "vimsyn_minlines", 100)
exe "syn sync maxlines=" .. get(g:, "vimsyn_maxlines", 200)

syn sync linecont	"^\s\+\\"
syn sync linebreaks=2
syn sync match vimAugroupSyncA	groupthere NONE	"\<aug\%[roup]\>\s\+[eE][nN][dD]"

" ====================
" Highlighting Settings {{{2
" ====================

if !exists("skip_vim_syntax_inits")
 if !exists("g:vimsyn_noerror")
  hi def link vimBehaveError	vimError
  hi def link vimCollClassErr	vimError
  hi def link vimErrSetting	vimError
  hi def link vimFTError	vimError
  hi def link vimFunctionError	vimError
  hi def link vimFunc         	vimError
  hi def link vim9Func         	vimError
  hi def link vimHiAttribList	vimError
  hi def link vimHiCtermError	vimError
  hi def link vimHiKeyError	vimError
  hi def link vimMapModErr	vimError
  hi def link vimMarkArgError	vimError
  hi def link vimShebangError	vimError
  hi def link vimSortOptionsError	Error
  hi def link vimSubstFlagErr	vimError
  hi def link vimSynCaseError	vimError
  hi def link vimSyncError	vimError
  hi def link vimSynConcealError	vimError
  hi def link vimSynError	vimError
  hi def link vimSynFoldlevelError	vimError
  hi def link vimSynIskeywordError	vimError
  hi def link vimSynSpellError	vimError
  hi def link vimBufnrWarn	vimWarn

  hi def link vim9TypeAliasError	vimError
 endif

 hi def link vimAbb	vimCommand
 hi def link vimAddress	vimMark
 hi def link vimAugroupBang	vimBang
 hi def link vimAugroupError	vimError
 hi def link vimAugroupKey	vimCommand
 hi def link vimAutocmd	vimCommand
 hi def link vimAutocmdBang	vimBang
 hi def link vimAutocmdPatternEscape	Special
 hi def link vimAutoEvent	Type
 hi def link vimAutoEventGlob	Type
 hi def link vimAutocmdBufferPattern	Special
 hi def link vimAutocmdMod	Special
 hi def link vimAutocmdPatternSep	vimSep
 hi def link vimBang	vimOper
 hi def link vimBehaveBang	vimBang
 hi def link vimBehaveModel	vimBehave
 hi def link vimBehave	vimCommand
 hi def link vimBracket	Delimiter
 hi def link vimCall	vimCommand
 hi def link vimCatch	vimCommand
 hi def link vimCmplxRepeat	SpecialChar
 hi def link vimCommand	Statement
 hi def link vimCommandModifier	vimCommand
 hi def link vimCommandModifierBang	vimBang
 hi def link vimComment	Comment
 hi def link vimCommentError	vimError
 hi def link vimCommentString	vimString
 hi def link vimCommentTitle	PreProc
 hi def link vimCondHL	vimCommand
 hi def link vimConst	vimCommand
 hi def link vimContinue	Special
 hi def link vimContinueComment	vimComment
 hi def link vimContinueString	vimString
 hi def link vimCount	Number
 hi def link vimCtrlChar	SpecialChar
 hi def link vimDebuggreedy	vimCommand
 hi def link vimDef	vimCommand
 hi def link vimDefBang	vimBang
 hi def link vimDefComment	vim9Comment
 hi def link vimDefer	vimCommand
 hi def link vimDefParam	vimVar
 hi def link vimDelcommand	vimCommand
 hi def link vimDelcommandAttr	vimUserCmdAttr
 hi def link vimDelfunction	vimCommand
 hi def link vimDelfunctionBang	vimBang
 hi def link vimDoautocmd	vimCommand
 hi def link vimDoautocmdMod	Special
 hi def link vimEcho	vimCommand
 hi def link vimEchohlNone	vimGroup
 hi def link vimEchohl	vimCommand
 hi def link vimElse	vimCommand
 hi def link vimElseIfErr	Error
 hi def link vimEndfunction	vimCommand
 hi def link vimEnddef	vimCommand
 hi def link vimEndif	vimCommand
 hi def link vimEnvvar	PreProc
 hi def link vimError	Error
 hi def link vimEscape	Special
 hi def link vimEval	vimCommand
 hi def link vimExFilter	vimCommand
 hi def link vimExFilterBang	vimBang
 hi def link vimExMark	vimCommand
 hi def link vimFBVar	vimVar
 hi def link vimFgBgAttrib	vimHiAttrib
 hi def link vimFuncEcho	vimCommand
 hi def link vimFor	vimCommand
 hi def link vimForInContinue	vimContinue
 hi def link vimForInContinueComment	vimContinueComment
 hi def link vimFTCmd	vimCommand
 hi def link vimFTOption	vimSynType
 hi def link vimFunction	vimCommand
 hi def link vimFunctionBang	vimBang
 hi def link vimFunctionComment	vimComment
 hi def link vimFuncName	Function
 hi def link vimFunctionMod	Special
 hi def link vimFunctionParam	vimVar
 hi def link vimFunctionParamEquals	vimOper
 hi def link vimFunctionScope	vimVarScope
 hi def link vimFunctionSID	vimNotation
 hi def link vimGrep	vimCommand
 hi def link vimGrepadd	vimCommand
 hi def link vimGrepBang	vimBang
 hi def link vimGroupAdd	vimSynOption
 hi def link vimGroupName	Normal
 hi def link vimGroupRem	vimSynOption
 hi def link vimGroupSpecial	Special
 hi def link vimGroup	Type
 hi def link vimHelpgrep	vimCommand
 hi def link vimHiAttrib	PreProc
 hi def link vimHiBang	vimBang
 hi def link vimHiBlend	vimHiTerm
 hi def link vimHiClear	Type
 hi def link vimHiCtermColor	Constant
 hi def link vimHiCtermFgBg	vimHiTerm
 hi def link vimHiCtermfont	vimHiTerm
 hi def link vimHiCtermul	vimHiTerm
 hi def link vimHiCTerm	vimHiTerm
 hi def link vimHighlight	vimCommand
 hi def link vimHiGroup	vimGroupName
 hi def link vimHiGuiFgBg	vimHiTerm
 hi def link vimHiGuiFont	vimHiTerm
 hi def link vimHiGuiRgb	vimNumber
 hi def link vimHiGui	vimHiTerm
 hi def link vimHiNmbr	Number
 hi def link vimHiNone	vimGroup
 hi def link vimHiStartStop	vimHiTerm
 hi def link vimHiTerm	Type
 hi def link vimHLGroup	vimGroup
 hi def link vimImport	vimCommand
 hi def link vimImportAutoload	Special
 hi def link vimImportAs	vimImport
 hi def link vimInsert	vimString
 hi def link vim9KeymapLineComment	vimKeymapLineComment
 hi def link vimKeymapLineComment	vimComment
 hi def link vimKeymapTailComment	vimComment
 hi def link vimLambdaBrace	Delimiter
 hi def link vimLambdaOperator	vimOper
 hi def link vimLet	vimCommand
 hi def link vimLetHeredoc	vimString
 hi def link vimLetHeredocStart	Special
 hi def link vimLetHeredocStop	Special
 hi def link vimLetRegister	vimRegister
 hi def link vimLineComment	vimComment
 hi def link vimLua	vimCommand
 hi def link vimMake	vimCommand
 hi def link vimMakeadd	vimCommand
 hi def link vimMakeBang	vimBang
 hi def link vimMapBang	vimBang
 hi def link vimMapLeader	vimBracket
 hi def link vimMapLeaderKey	vimNotation
 hi def link vimMapModKey	vimFunctionSID
 hi def link vimMapMod	vimBracket
 hi def link vimMap	vimCommand
 hi def link vimMark	Number
 hi def link vimMarkNumber	vimNumber
 hi def link vimMatch	vimCommand
 hi def link vimMatchGroup	vimGroup
 hi def link vimMatchNone	vimGroup
 hi def link vimMenuBang	vimBang
 hi def link vimMenuClear	Special
 hi def link vimMenuMod	vimMapMod
 hi def link vimMenuName	PreProc
 hi def link vimMenu	vimCommand
 hi def link vimMenuNotation	vimNotation
 hi def link vimMenuPriority	Number
 hi def link vimMenuStatus	Special
 hi def link vimMenutranslateComment	vimComment
 hi def link vim9MethodName	vimFuncName
 hi def link vimMtchComment	vimComment
 hi def link vimMzScheme	vimCommand
 hi def link vimNonText	NonText
 hi def link vimNormal	vimCommand
 hi def link vimNotation	Special
 hi def link vimNotFunc	vimCommand
 hi def link vimNotPatSep	vimString
 hi def link vimNumber	Number
 hi def link vimOperError	Error
 hi def link vimOper	Operator
 hi def link vimOperContinue	vimContinue
 hi def link vimOperContinueComment	vimContinueComment
 hi def link vimOption	PreProc
 hi def link vimOptionVar	Identifier
 hi def link vimOptionVarName	Identifier
 hi def link vimParenSep	Delimiter
 hi def link vimPatSepErr	vimError
 hi def link vimPatSepR	vimPatSep
 hi def link vimPatSep	SpecialChar
 hi def link vimPatSepZone	vimString
 hi def link vimPatSepZ	vimPatSep
 hi def link vimPattern	Type
 hi def link vimPerl	vimCommand
 hi def link vimPlainMark	vimMark
 hi def link vimProfile	vimCommand
 hi def link vimProfileArg	vimSpecial
 hi def link vimProfileBang	vimBang
 hi def link vimProfdel	vimCommand
 hi def link vimProfdelArg	vimSpecial
 hi def link vimPython	vimCommand
 hi def link vimPython3	vimCommand
 hi def link vimPythonX	vimCommand
 hi def link vimQuoteEscape	vimEscape
 hi def link vimRedir	vimCommand
 hi def link vimRedirBang	vimBang
 hi def link vimRedirFileOperator	vimOper
 hi def link vimRedirRegisterOperator	vimOper
 hi def link vimRedirVariableOperator	vimOper
 hi def link vimRedirEnd	Special
 hi def link vimRedirRegister	vimRegister
 hi def link vimRegister	SpecialChar
 hi def link vimRuby	vimCommand
 hi def link vimScriptDelim	Comment
 hi def link vimScriptHeredocStart	vimLetHeredocStart
 hi def link vimScriptHeredocStop	vimLetHeredocStop
 hi def link vimSearch	vimString
 hi def link vimSearchDelim	Delimiter
 hi def link vimSep	Delimiter
 hi def link vimSet	vimCommand
 hi def link vimSetAll	vimOption
 hi def link vimSetBang	vimBang
 hi def link vimSetComment	vimComment
 hi def link vimSetMod	vimOption
 hi def link vimSetSep	vimSep
 hi def link vimSetTermcap	vimOption
 hi def link vimShebang	PreProc
 hi def link vimSleep	vimCommand
 hi def link vimSleepArg	Constant
 hi def link vimSleepBang	vimBang
 hi def link vimSort	vimCommand
 hi def link vimSortBang	vimBang
 hi def link vimSortOptions	Special
 hi def link vimSpecFile	Identifier
 hi def link vimSpecFileMod	vimSpecFile
 hi def link vimSpecial	Type
 hi def link vimStringCont	vimString
 hi def link vimString	String
 hi def link vimStringEnd	vimString
 hi def link vimStringInterpolationBrace	vimEscape
 hi def link vimSubst1	vimSubst
 hi def link vimSubstCount	Number
 hi def link vimSubstDelim	Delimiter
 hi def link vimSubstFlags	Special
 hi def link vimSubstSubstr	SpecialChar
 hi def link vimSubstTwoBS	vimString
 hi def link vimSubst	vimCommand
 hi def link vimSynCase	Type
 hi def link vimSyncCcomment	Type
 hi def link vimSynCchar	vimSynOption
 hi def link vimSynCcharValue	Character
 hi def link vimSyncClear	Type
 hi def link vimSyncFromstart	Type
 hi def link vimSyncGroup	vimGroupName
 hi def link vimSyncGroupName	vimGroupName
 hi def link vimSyncKey	Type
 hi def link vimSyncLinebreak	Type
 hi def link vimSyncLinecont	Type
 hi def link vimSyncLines	Type
 hi def link vimSyncMatch	Type
 hi def link vimSyncNone	Type
 hi def link vimSynConceal	Type
 hi def link vimSynContains	vimSynOption
 hi def link vimSyncRegion	Type
 hi def link vimSynFoldlevel	Type
 hi def link vimSynIskeyword	Type
 hi def link vimSynIskeywordSep	Delimiter
 hi def link vimSynKeyContainedin	vimSynContains
 hi def link vimSynKeyOpt	vimSynOption
 hi def link vimSynMtchGrp	vimSynOption
 hi def link vimSynMtchOpt	vimSynOption
 hi def link vimSynNextgroup	vimSynOption
 hi def link vimSynNotPatRange	vimSynRegPat
 hi def link vimSynOption	Special
 hi def link vimSynPatRange	vimString
 hi def link vimSynReg	Type
 hi def link vimSynRegOpt	vimSynOption
 hi def link vimSynRegPat	vimString
 hi def link vimSynSpell	Type
 hi def link vimSyntax	vimCommand
 hi def link vimSynType	vimSpecial
 hi def link vimTcl	vimCommand
 hi def link vimThrow	vimCommand
 hi def link vimTodo	Todo
 hi def link vimType	Type
 hi def link vimTypeAny	vimType
 hi def link vimUniq	vimCommand
 hi def link vimUniqBang	vimBang
 hi def link vimUniqOptions	Special
 hi def link vimUnlet	vimCommand
 hi def link vimUnletBang	vimBang
 hi def link vimUnmap	vimMap
 hi def link vimUserCmd	vimCommand
 hi def link vimUserCmdAttrAddr	vimSpecial
 hi def link vimUserCmdAttrComplete	vimSpecial
 hi def link vimUserCmdAttrCompleteFunc	vimVar
 hi def link vimUserCmdAttrNargs	vimSpecial
 hi def link vimUserCmdAttrRange	vimSpecial
 hi def link vimUserCmdAttrKey	vimUserCmdAttr
 hi def link vimUserCmdAttr	Special
 hi def link vimUserCmdAttrError	Error
 hi def link vimUserCmdError	Error
 hi def link vimUserCmdKey	vimCommand
 hi def link vimUserFunc	Normal
 hi def link vimVar	Normal
 hi def link vimVarScope	Identifier
 hi def link vimVimgrep	vimCommand
 hi def link vimVimgrepadd	vimCommand
 hi def link vimVimgrepBang	vimBang
 hi def link vimVimgrepFlags	Special
 hi def link vimVimVar	Identifier
 hi def link vimVimVarName	Identifier
 hi def link vimWarn	WarningMsg
 hi def link vimWildcard	Special
 hi def link vimWildcardBraceComma	vimWildcard
 hi def link vimWildcardBracket	vimWildcard
 hi def link vimWildcardBracketCaret	vimWildcard
 hi def link vimWildcardBracketCharacter	Normal
 hi def link vimWildcardBracketCharacter	Normal
 hi def link vimWildcardBracketCharacterClass	vimWildCard
 hi def link vimWildcardBracketCollatingSymbol	vimWildCard
 hi def link vimWildcardBracketEnd		vimWildcard
 hi def link vimWildcardBracketEquivalenceClass	vimWildCard
 hi def link vimWildcardBracketEscape	vimWildcard
 hi def link vimWildcardBracketHyphen	vimWildcard
 hi def link vimWildcardBracketRightBracket	vimWildcardBracketCharacter
 hi def link vimWildcardBracketStart	vimWildcard
 hi def link vimWildcardEscape	vimWildcard
 hi def link vimWildcardInterval	vimWildcard
 hi def link vimWildcardQuestion	vimWildcard
 hi def link vimWildcardStar	vimWildcard

 hi def link vim9Abstract	vimCommand
 hi def link vim9Boolean	Boolean
 hi def link vim9Class	vimCommand
 hi def link vim9Comment	Comment
 hi def link vim9CommentError	vimError
 hi def link vim9CommentTitle	PreProc
 hi def link vim9ConstructorDefParam	vimVar
 hi def link vim9Const	vimCommand
 hi def link vim9ContinueComment	vimContinueComment
 hi def link vim9Enum	vimCommand
 hi def link vim9EnumImplementedInterfaceComment	vim9Comment
 hi def link vim9EnumImplements	vim9Implements
 hi def link vim9EnumNameComment	vim9Comment
 hi def link vim9EnumNameContinue	vimContinue
 hi def link vim9EnumNameContinueComment	vim9Comment
 hi def link vim9EnumValueListCommaComment	vim9Comment
 hi def link vim9Export	vimCommand
 hi def link vim9Extends	Keyword
 hi def link vim9Final	vimCommand
 hi def link vim9For	vimCommand
 hi def link vim9ForInComment	vim9Comment
 hi def link vim9Implements	Keyword
 hi def link vim9AbstractDef	vimCommand
 hi def link vim9Interface	vimCommand
 hi def link vim9LambdaOperator	vimOper
 hi def link vim9LambdaOperatorComment	vim9Comment
 hi def link vim9LambdaParen	vimParenSep
 hi def link vim9LhsRegister	vimLetRegister
 hi def link vim9LhsVariable	vimVar
 hi def link vim9LineComment	vimComment
 hi def link vim9MethodDef	vimCommand
 hi def link vim9MethodDefComment	vimDefComment
 hi def link vim9MethodNameError	vimFunctionError
 hi def link vim9Null	Constant
 hi def link vim9Public	vimCommand
 hi def link vim9Search	vimString
 hi def link vim9SearchDelim	Delimiter
 hi def link vim9Static	vimCommand
 hi def link vim9Super	Identifier
 hi def link vim9This	Identifier
 hi def link vim9Type	vimCommand
 hi def link vim9TypeEquals	vimOper
 hi def link vim9Variable	vimVar
 hi def link vim9VariableType	vimType
 hi def link vim9VariableTypeAny	vimType
 hi def link vim9Var	vimCommand
 hi def link vim9Vim9ScriptArg	Special
 hi def link vim9Vim9Script	vimCommand

 hi def link vimCompilerSet	vimCommand
 hi def link vimSynColor vimCommand
 hi def link vimSynLink vimCommand
 hi def link vimSynMenu	vimCommand
 hi def link vimSynMenuPath	vimMenuName

 hi def link nvimAutoEvent	vimAutoEvent
 hi def link nvimHLGroup	vimHLGroup
endif

" Current Syntax Variable: {{{2
let b:current_syntax = "vim"

" ---------------------------------------------------------------------
" Cleanup: {{{1
delc Vim9
delc VimL
delc VimFolda
delc VimFoldc
delc VimFolde
delc VimFoldf
delc VimFoldh
delc VimFoldH
delc VimFoldi
delc VimFoldl
delc VimFoldm
delc VimFoldp
delc VimFoldP
delc VimFoldr
delc VimFoldt
let &cpo = s:keepcpo
unlet s:keepcpo s:vim9script
" vim:ts=18 fdm=marker ft=vim
