/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Fonts;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java2d.AnimatingSurface;

public class Highlighting
extends AnimatingSurface {
    private static String[] text = new String[]{"HIGHLIGHTING", "OpenJDK"};
    private static Color[] colors = new Color[]{Color.CYAN, Color.LIGHT_GRAY};
    private static Font smallF = new Font("Monospaced", 0, 8);
    private int[] curPos;
    private TextLayout[] layouts;
    private Font[] fonts;

    public Highlighting() {
        this.setBackground(Color.WHITE);
        this.fonts = new Font[2];
        this.layouts = new TextLayout[this.fonts.length];
        this.curPos = new int[this.fonts.length];
    }

    @Override
    public void reset(int w, int h) {
        this.fonts[0] = new Font("Monospaced", 0, w / text[0].length() + 8);
        this.fonts[1] = new Font("Serif", 1, w / text[1].length());
        for (int i = 0; i < this.layouts.length; ++i) {
            this.curPos[i] = 0;
        }
    }

    @Override
    public void step(int w, int h) {
        this.setSleepAmount(900L);
        for (int i = 0; i < 2; ++i) {
            if (this.layouts[i] == null) continue;
            int n = i;
            int n2 = this.curPos[n];
            this.curPos[n] = n2 + 1;
            if (n2 != this.layouts[i].getCharacterCount()) continue;
            this.curPos[i] = 0;
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        FontRenderContext frc = g2.getFontRenderContext();
        for (int i = 0; i < 2; ++i) {
            this.layouts[i] = new TextLayout(text[i], this.fonts[i], frc);
            float rw = this.layouts[i].getAdvance();
            float rx = ((float)w - rw) / 2.0f;
            float ry = i == 0 ? (float)(h / 3) : (float)h * 0.75f;
            Shape hilite = this.layouts[i].getLogicalHighlightShape(0, this.curPos[i]);
            AffineTransform at = AffineTransform.getTranslateInstance(rx, ry);
            hilite = at.createTransformedShape(hilite);
            float hy = (float)hilite.getBounds2D().getY();
            float hh = (float)hilite.getBounds2D().getHeight();
            g2.setColor(colors[i]);
            g2.fill(hilite);
            Shape[] shapes = this.layouts[i].getCaretShapes(this.curPos[i]);
            Shape caret = at.createTransformedShape(shapes[0]);
            g2.setColor(Color.BLACK);
            this.layouts[i].draw(g2, rx, ry);
            g2.draw(caret);
            g2.draw(new Rectangle2D.Float(rx, hy, rw, hh));
            for (int j = 0; j <= this.layouts[i].getCharacterCount(); ++j) {
                float[] cInfo = this.layouts[i].getCaretInfo(TextHitInfo.leading(j));
                String str = String.valueOf((int)cInfo[0]);
                TextLayout tl = new TextLayout(str, smallF, frc);
                tl.draw(g2, rx + cInfo[0] - tl.getAdvance() / 2.0f, hy + hh + tl.getAscent() + 1.0f);
            }
        }
    }

    public static void main(String[] argv) {
        Highlighting.createDemoFrame(new Highlighting());
    }
}

