private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "ARM"
	condition:
		true
}

rule file_2_0_0 {
	meta:
		name = "_RTC_Initialize"
		size = 54
		refs = "0008 __rtc_iaa 0010 __rtc_izz 0028 _guard_check_icall"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B ?? ?? ?? ?? C0 F2 00 03 ?? ?? ?? ?? C0 F2 00 06 1D 1D 1B 1D B3 42 08 D2 55 F8 04 4B 1C B1 20 46 ?? ?? ?? ?? A0 47 B5 42 F6 D3 BD E8 78 88 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "_RTC_Terminate"
		size = 54
		refs = "0008 __rtc_taa 0010 __rtc_tzz 0028 _guard_check_icall"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B ?? ?? ?? ?? C0 F2 00 03 ?? ?? ?? ?? C0 F2 00 06 1D 1D 1B 1D B3 42 08 D2 55 F8 04 4B 1C B1 20 46 ?? ?? ?? ?? A0 47 B5 42 F6 D3 BD E8 78 88 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "??0bad_alloc@std@@AAA@QBD@Z"
		size = 48
		refs = "0010 ??0exception@std@@QAA@QBDH@Z 002c ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 01 22 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "??0bad_alloc@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0exception@std@@QAA@ABV01@@Z 0028 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_1_4 {
	meta:
		name = "??0__non_rtti_object@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0bad_typeid@std@@QAA@ABV01@@Z 0028 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_3_0 {
	meta:
		name = "??0bad_array_new_length@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0bad_alloc@std@@QAA@ABV01@@Z 0028 ??_7bad_array_new_length@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_150_2 {
	meta:
		name = "??0bad_cast@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0exception@std@@QAA@ABV01@@Z 0028 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_44_1 {
	meta:
		name = "??0bad_exception@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0exception@std@@QAA@ABV01@@Z 0028 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_2_2 {
	meta:
		name = "??0bad_function_call@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0exception@std@@QAA@ABV01@@Z 0028 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_5_4 {
	meta:
		name = "??0bad_typeid@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0exception@std@@QAA@ABV01@@Z 0028 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_86_1 {
	meta:
		name = "??0failure@ios_base@std@@QAA@ABV012@@Z"
		size = 44
		refs = "000e ??0system_error@std@@QAA@ABV01@@Z 0028 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_8_2 {
	meta:
		name = "??0invalid_argument@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0logic_error@std@@QAA@ABV01@@Z 0028 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_10_2 {
	meta:
		name = "??0length_error@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0logic_error@std@@QAA@ABV01@@Z 0028 ??_7length_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_5_2 {
	meta:
		name = "??0logic_error@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0exception@std@@QAA@ABV01@@Z 0028 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_14_3 {
	meta:
		name = "??0out_of_range@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0logic_error@std@@QAA@ABV01@@Z 0028 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_16_2 {
	meta:
		name = "??0overflow_error@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0runtime_error@std@@QAA@ABV01@@Z 0028 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_46_1 {
	meta:
		name = "??0runtime_error@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0exception@std@@QAA@ABV01@@Z 0028 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_43_1 {
	meta:
		name = "??0system_error@std@@QAA@ABV01@@Z"
		size = 44
		refs = "000e ??0_System_error@std@@QAA@ABV01@@Z 0028 ??_7system_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_2_0 {
	meta:
		name = "??0bad_alloc@std@@QAA@XZ"
		size = 52
		refs = "0010 ??0exception@std@@QAA@QBDH@Z 002c ??_7bad_alloc@std@@6B@ 0030 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 01 22 08 49 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_116_3 {
	meta:
		name = "??0bad_cast@std@@QAA@XZ"
		size = 52
		refs = "0010 ??0exception@std@@QAA@QBDH@Z 002c ??_7bad_cast@std@@6B@ 0030 ??_C@_08EPJLHIJG@bad?5cast?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 01 22 08 49 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_2_4 {
	meta:
		name = "??0bad_exception@std@@QAA@XZ"
		size = 52
		refs = "0010 ??0exception@std@@QAA@QBDH@Z 002c ??_7bad_exception@std@@6B@ 0030 ??_C@_0O@DPKOEFFH@bad?5exception?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 01 22 08 49 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_4_0 {
	meta:
		name = "??0bad_array_new_length@std@@QAA@XZ"
		size = 48
		refs = "000e ??0bad_alloc@std@@AAA@QBD@Z 0028 ??_7bad_array_new_length@std@@6B@ 002c ??_C@_0BF@KINCDENJ@bad?5array?5new?5length?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 08 49 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_5_0 {
	meta:
		name = "??0exception@std@@QAA@ABV01@@Z"
		size = 60
		refs = "0018 memset 0024 __std_exception_copy 0038 ??_7exception@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 0A 4B 13 60 08 22 00 21 04 9B 18 1D ?? ?? ?? ?? 04 9B 19 1D 05 9B 18 1D ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_6_0 {
	meta:
		name = "??0exception@std@@QAA@QBDH@Z"
		size = 56
		refs = "0018 memset 0034 ??_7exception@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 04 9A 09 4B 13 60 08 22 00 21 04 9B 18 1D ?? ?? ?? ?? 04 9B 1A 1D 05 9B 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_7_0 {
	meta:
		name = "??1bad_alloc@std@@UAA@XZ"
		size = 22
		refs = "000a ??1exception@std@@UAA@XZ"
		altNames = "??1bad_cast@std@@UAA@XZ ??1bad_exception@std@@UAA@XZ ??1bad_function_call@std@@UAA@XZ ??1bad_typeid@std@@UAA@XZ ??1logic_error@std@@UAA@XZ ??1runtime_error@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_53_97_1 {
	meta:
		name = "??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_String_val@U?$_Simple_types@D@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_309_1 {
	meta:
		name = "??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_String_val@U?$_Simple_types@G@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_65_46_3 {
	meta:
		name = "??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_String_val@U?$_Simple_types@_W@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_119_2_3 {
	meta:
		name = "??1?$_Func_class@X$$V@std@@QAA@XZ"
		size = 22
		refs = "000a ?_Tidy@?$_Func_class@X$$V@std@@IAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_110_120_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1_Iterator_base12@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_370_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1_Iterator_base12@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_7_45_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1_Iterator_base12@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_86_48_1 {
	meta:
		name = "??1?$_Ref_count_obj@V__ExceptionPtr@@@std@@UAA@XZ"
		size = 22
		refs = "000a ??1_Ref_count_base@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_82_49_2 {
	meta:
		name = "??1?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@UAA@XZ"
		size = 22
		refs = "000a ??1_Ref_count_base@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_75_99_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_314_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_32_20_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_67_122_2 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_423_3 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_424_3 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_143_3 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_379_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_7_48_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_118_84_1 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@D@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1_Bxty@?$_String_val@U?$_Simple_types@D@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_317_1 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@G@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1_Bxty@?$_String_val@U?$_Simple_types@G@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_318_1 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@_W@std@@@std@@QAA@XZ"
		size = 22
		refs = "000a ??1_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_25_9_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAA@XZ"
		size = 22
		refs = "000a ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_22_2_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAA@XZ"
		size = 22
		refs = "000a ?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_3_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAA@XZ"
		size = 22
		refs = "000a ?release@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_1_3_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAA@XZ"
		size = 22
		refs = "000a ?release@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_25_10_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAA@XZ"
		size = 22
		refs = "000a ?release@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_15_3_2 {
	meta:
		name = "??1?$function@$$A6AXXZ@std@@QAA@XZ"
		size = 22
		refs = "000a ??1?$_Func_class@X$$V@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_46_157_3 {
	meta:
		name = "??1_Generic_error_category@std@@UAA@XZ"
		size = 22
		refs = "000a ??1error_category@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_84_60_1 {
	meta:
		name = "??1_Iostream_error_category@std@@UAA@XZ"
		size = 22
		refs = "000a ??1_Generic_error_category@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_21_115_1 {
	meta:
		name = "??1_System_error@std@@UAA@XZ"
		size = 22
		refs = "000a ??1runtime_error@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_33_95_3 {
	meta:
		name = "??1_System_error_category@std@@UAA@XZ"
		size = 22
		refs = "000a ??1error_category@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_24_8_4 {
	meta:
		name = "??1__non_rtti_object@std@@UAA@XZ"
		size = 22
		refs = "000a ??1bad_typeid@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_8_0 {
	meta:
		name = "??1bad_array_new_length@std@@UAA@XZ"
		size = 22
		refs = "000a ??1bad_alloc@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_9_8_3 {
	meta:
		name = "??1exception_ptr@std@@QAA@XZ"
		size = 22
		refs = "000a ?__ExceptionPtrDestroy@@YAXPAX@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_26_168_3 {
	meta:
		name = "??1failure@ios_base@std@@UAA@XZ"
		size = 22
		refs = "000a ??1system_error@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_9_9_3 {
	meta:
		name = "??1future_error@std@@UAA@XZ"
		size = 22
		refs = "000a ??1logic_error@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_31_25_1 {
	meta:
		name = "??1invalid_argument@std@@UAA@XZ"
		size = 22
		refs = "000a ??1logic_error@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_26_3 {
	meta:
		name = "??1length_error@std@@UAA@XZ"
		size = 22
		refs = "000a ??1logic_error@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_79_157_1 {
	meta:
		name = "??1messages_base@std@@UAA@XZ"
		size = 22
		refs = "000a ??1facet@locale@std@@MAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_79_158_1 {
	meta:
		name = "??1money_base@std@@UAA@XZ"
		size = 22
		refs = "000a ??1facet@locale@std@@MAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_50_28_2 {
	meta:
		name = "??1out_of_range@std@@UAA@XZ"
		size = 22
		refs = "000a ??1logic_error@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_31_29_1 {
	meta:
		name = "??1overflow_error@std@@UAA@XZ"
		size = 22
		refs = "000a ??1runtime_error@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_30_3 {
	meta:
		name = "??1regex_error@std@@UAA@XZ"
		size = 22
		refs = "000a ??1runtime_error@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_63_172_3 {
	meta:
		name = "??1system_error@std@@UAA@XZ"
		size = 22
		refs = "000a ??1_System_error@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "??3@YAXPAXABUnothrow_t@std@@@Z"
		size = 22
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "??3@YAXPAXI@Z"
		size = 22
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_94_156_2 {
	meta:
		name = "??3_Crt_new_delete@std@@SAXPAX@Z"
		size = 22
		refs = "000a free"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "??_V@YAXPAX@Z"
		size = 22
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "??_V@YAXPAXABUnothrow_t@std@@@Z"
		size = 22
		refs = "000a ??_V@YAXPAX@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "??_V@YAXPAXI@Z"
		size = 22
		refs = "000a ??_V@YAXPAX@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_88_5_3 {
	meta:
		name = "_Thrd_exit"
		size = 22
		refs = "000a _endthreadex"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_9_0 {
	meta:
		name = "??1exception@std@@UAA@XZ"
		size = 36
		refs = "0012 __std_exception_destroy 0020 ??_7exception@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9A 05 4B 13 60 02 9B 18 1D ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_10_0 {
	meta:
		name = "??_Gbad_alloc@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1bad_alloc@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_114_65_3 {
	meta:
		name = "??_G_Ref_count_base@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1_Ref_count_base@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_24_12_4 {
	meta:
		name = "??_G__non_rtti_object@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1__non_rtti_object@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_11_0 {
	meta:
		name = "??_Gbad_array_new_length@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1bad_array_new_length@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_66_149_1 {
	meta:
		name = "??_Gbad_cast@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1bad_cast@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_3_8_4 {
	meta:
		name = "??_Gbad_exception@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1bad_exception@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_50_33_2 {
	meta:
		name = "??_Gbad_function_call@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1bad_function_call@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_24_14_4 {
	meta:
		name = "??_Gbad_typeid@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1bad_typeid@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_12_0 {
	meta:
		name = "??_Gexception@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1exception@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_50_35_2 {
	meta:
		name = "??_Ginvalid_argument@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1invalid_argument@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_50_36_2 {
	meta:
		name = "??_Glength_error@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1length_error@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_44_13_2 {
	meta:
		name = "??_Glogic_error@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1logic_error@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_31_38_1 {
	meta:
		name = "??_Gout_of_range@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1out_of_range@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_50_39_2 {
	meta:
		name = "??_Goverflow_error@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1overflow_error@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_159_1 {
	meta:
		name = "??_Gruntime_error@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1runtime_error@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_125_1_7 {
	meta:
		name = "??_Gtype_info@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1type_info@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 0C 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_13_0 {
	meta:
		name = "?__scrt_throw_std_bad_alloc@@YAXXZ"
		size = 32
		refs = "000a ??0bad_alloc@std@@QAA@XZ 0012 _CxxThrowException 001c _TI2?AVbad_alloc@std@@"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 68 46 ?? ?? ?? ?? 03 49 68 46 ?? ?? ?? ?? 04 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_14_0 {
	meta:
		name = "?__scrt_throw_std_bad_array_new_length@@YAXXZ"
		size = 32
		refs = "000a ??0bad_array_new_length@std@@QAA@XZ 0012 _CxxThrowException 001c _TI3?AVbad_array_new_length@std@@"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 68 46 ?? ?? ?? ?? 03 49 68 46 ?? ?? ?? ?? 04 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_15_0 {
	meta:
		name = "?what@exception@std@@UBAPBDXZ"
		size = 56
		refs = "0034 ??_C@_0BC@EOODALEL@Unknown?5exception?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 1D 1B 68 00 2B 04 D0 04 9B 1B 1D 1B 68 00 93 01 E0 05 4B 00 93 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_0_4 {
	meta:
		name = "?get_unexpected_or_default@@YAP6AXXZQBU__vcrt_ptd@@@Z"
		size = 56
		refs = "0034 terminate"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 1D 1B 68 00 2B 04 D0 04 9B 1B 1D 1B 68 00 93 01 E0 05 4B 00 93 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "__dyn_tls_dtor"
		size = 216
		refs = "0086 _guard_check_icall 00a2 _free_dbg 00d0 dtor_list 00d4 _tls_index"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 07 9B 03 2B 03 D0 07 9B 00 2B 00 D0 55 E0 00 23 02 93 2D 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 27 4B 13 44 1B 68 00 93 01 E0 02 9B 00 93 00 9B 00 2B 3F D0 00 9B 1B 68 5B 1E 01 93 02 E0 01 9B 5B 1E 01 93 01 9B 00 2B 1A DB 00 9B 03 F1 08 01 01 9A 04 23 02 FB 03 F3 0B 44 1B 68 00 2B 0E D0 00 9B 03 F1 08 01 01 9A 04 23 02 FB 03 F3 0B 44 1B 68 03 93 03 98 ?? ?? ?? ?? 03 9B 98 47 DE E7 00 9B 1B 1D 1B 68 02 93 02 9B 00 2B 03 D0 02 21 00 98 ?? ?? ?? ?? 0B 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 05 4B 1A 44 02 9B 13 60 BA E7 04 B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "??$?RUTlsDtorNode@@@__crt_internal_free_policy@@QBAXQBUTlsDtorNode@@@Z"
		size = 24
		refs = "000c _free_dbg"
		altNames = "??$?RD@__crt_internal_free_policy@@QBAXQBD@Z ??$?RU__vcrt_ptd@@@__crt_internal_free_policy@@QBAXQBU__vcrt_ptd@@@Z ??$?RX@__crt_internal_free_policy@@QBAXQBX@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 21 03 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_2_0 {
	meta:
		name = "??0?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAA@QAUTlsDtorNode@@@Z"
		size = 32
		altNames = "??0?$__crt_scoped_stack_ptr@_W@@QAA@U?$__crt_scoped_stack_ptr_tag@_W@@@Z ??0?$__crt_scoped_stack_ptr_tag@_W@@QAA@QA_W@Z ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAA@QAD@Z ??0?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAA@QAD@Z ??0?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAA@QAU__vcrt_ptd@@@Z ??0?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAA@QAX@Z ??0_Timevec@std@@QAA@PAX@Z ??0id@locale@std@@QAA@I@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 05 9B 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_4_0 {
	meta:
		name = "?detach@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAAPAUTlsDtorNode@@XZ"
		size = 38
		altNames = "?detach@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAAPADXZ ?detach@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAAPAU__vcrt_ptd@@XZ ?detach@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAAPAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 68 00 93 04 9A 00 23 13 60 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_5_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAAXXZ"
		size = 36
		refs = "0010 ??$?RUTlsDtorNode@@@__crt_internal_free_policy@@QBAXQBUTlsDtorNode@@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 19 68 68 46 ?? ?? ?? ?? 04 9A 00 23 13 60 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_25_22_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAAXXZ"
		size = 36
		refs = "0010 ??$?RD@__crt_internal_free_policy@@QBAXQBD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 19 68 68 46 ?? ?? ?? ?? 04 9A 00 23 13 60 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_22_7_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAAXXZ"
		size = 36
		refs = "0010 ??$?RD@__crt_public_free_policy@@QBAXQBD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 19 68 68 46 ?? ?? ?? ?? 04 9A 00 23 13 60 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_1_9_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAAXXZ"
		size = 36
		refs = "0010 ??$?RU__vcrt_ptd@@@__crt_internal_free_policy@@QBAXQBU__vcrt_ptd@@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 19 68 68 46 ?? ?? ?? ?? 04 9A 00 23 13 60 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_25_23_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAAXXZ"
		size = 36
		refs = "0010 ??$?RX@__crt_internal_free_policy@@QBAXQBX@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 19 68 68 46 ?? ?? ?? ?? 04 9A 00 23 13 60 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_6_0 {
	meta:
		name = "__tlregdtor"
		size = 468
		refs = "00a0 _malloc_dbg 00aa ??0?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAA@QAUTlsDtorNode@@@Z 00b6 ?detach@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAAPAUTlsDtorNode@@XZ 00c2 ??1?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAA@XZ 01c4 dtor_list 01c8 _tls_index 01cc ??_C@_0DA@HHHHCDMN@f?3?2dd?2vctools?2crt?2vcstartup?2src?2@ 01d0 dtor_list_head"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 88 B0 6F 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 69 4B 13 44 1B 68 00 2B 27 D1 67 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 64 4B D1 18 61 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 5B 4B 13 44 19 60 5B 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 58 4B 1A 44 00 23 13 60 5D E0 53 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 4D 4B 13 44 1B 68 1B 68 1E 2B 4D D1 43 23 4C 4A 02 21 80 20 ?? ?? ?? ?? 02 90 02 99 06 A8 ?? ?? ?? ?? 03 90 03 9B 04 93 04 98 ?? ?? ?? ?? 05 90 05 9B 00 93 06 A8 ?? ?? ?? ?? 00 9B 00 2B 03 D1 6F F0 00 03 01 93 71 E0 00 9A 00 23 13 60 3B 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 35 4B D1 18 00 9B 1A 1D 0B 68 13 60 33 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 2D 4B 1A 44 00 9B 13 60 2C 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 26 4B 13 44 1A 68 00 23 13 60 24 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 1E 4B 13 44 1B 68 03 F1 08 01 1D 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 17 4B 13 44 1B 68 1A 68 04 23 02 FB 03 F3 CA 18 0A 9B 13 60 13 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 0D 4B 13 44 1B 68 1B 68 59 1C 0B 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 05 4B 13 44 1B 68 19 60 00 23 01 93 01 98 08 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "__scrt_stub_for_vcrt_initialize"
		size = 24
		altNames = "?are_vista_sync_apis_available@details@Concurrency@@YA_NXZ ?are_win7_sync_apis_available@details@Concurrency@@YA_NXZ ?is_vista_threadpool_supported@?A0x7ef259da@details@Concurrency@@YA_NXZ __scrt_stub_for_acrt_initialize __scrt_stub_for_acrt_thread_attach __scrt_stub_for_acrt_thread_detach __scrt_stub_for_vcrt_thread_attach __scrt_stub_for_vcrt_thread_detach __vcrt_initialize _should_initialize_environment"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 01 23 8D F8 00 30 9D F8 00 00 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_13_3_0 {
	meta:
		name = "__scrt_stub_for_vcrt_uninitialize"
		size = 30
		altNames = "??$?8DD@std@@YA_NABV?$allocator@D@0@0@Z ??$?8GG@std@@YA_NABV?$allocator@G@0@0@Z ??$?8_W_W@std@@YA_NABV?$allocator@_W@0@0@Z ?do_always_noconv@?$codecvt@DDU_Mbstatet@@@std@@MBA_NXZ __scrt_stub_for_acrt_uninitialize __scrt_stub_for_acrt_uninitialize_critical __scrt_stub_for_vcrt_uninitialize_critical"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 01 23 8D F8 00 30 9D F8 00 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "?dllmain_crt_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
		size = 130
		refs = "0022 ?dllmain_crt_process_attach@@YAHQAUHINSTANCE__@@QAX@Z 0046 ?dllmain_crt_process_detach@@YAH_N@Z 0052 __scrt_dllmain_crt_thread_attach 0062 __scrt_dllmain_crt_thread_detach"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 09 9B 02 93 02 9B 03 2B 2E D8 02 9A DF E8 02 F0 0A 02 1C 24 0A 99 08 98 ?? ?? ?? ?? 03 90 03 9B 01 93 23 E0 0A 9B 00 2B 03 D0 01 23 8D F8 00 30 02 E0 00 23 8D F8 00 30 9D F8 00 00 ?? ?? ?? ?? 04 90 04 9B 01 93 11 E0 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 01 93 09 E0 ?? ?? ?? ?? 8D F8 02 00 9D F8 02 30 01 93 01 E0 01 23 01 93 01 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_14_1_0 {
	meta:
		name = "?dllmain_crt_process_attach@@YAHQAUHINSTANCE__@@QAX@Z"
		size = 292
		refs = "0010 __scrt_initialize_crt 0022 __scrt_acquire_startup_lock 003a __scrt_fastfail 0044 __scrt_dllmain_before_initialize_c 0052 _RTC_Initialize 0058 atexit 005c ?__scrt_initialize_type_info@@YAXXZ 0066 __scrt_initialize_default_local_stdio_options 006e _initterm_e 007c __scrt_dllmain_after_initialize_c 008e _initterm 009e __scrt_release_startup_lock 00ae __scrt_get_dyn_tls_init_callback 00c2 __scrt_is_nonwritable_in_current_image 00dc _guard_check_icall 0104 ?__proc_attached@@3HA 0108 __scrt_current_native_startup_state 010c __xc_a 0110 __xc_z 0114 __xi_a 0118 __xi_z 011c ?__scrt_uninitialize_type_info@@YAXXZ 0120 _RTC_Terminate"
	strings:
		$1 = { 03 B4 2D E9 F0 48 0D F1 10 0B 88 B0 6F 46 00 20 ?? ?? ?? ?? B8 70 BB 78 00 2B 02 D1 00 23 FB 60 6A E0 ?? ?? ?? ?? F8 70 FB 78 3B 70 01 23 7B 70 35 4B 1B 68 00 2B 02 D0 07 20 ?? ?? ?? ?? 32 4A 01 23 13 60 ?? ?? ?? ?? 38 71 3B 79 00 2B 00 D1 24 E0 ?? ?? ?? ?? 32 48 ?? ?? ?? ?? ?? ?? ?? ?? 2E 48 ?? ?? ?? ?? ?? ?? ?? ?? 2B 49 29 48 ?? ?? ?? ?? 78 61 7B 69 00 2B 00 D0 0F E0 ?? ?? ?? ?? 78 71 7B 79 00 2B 00 D1 08 E0 21 49 1F 48 ?? ?? ?? ?? 1D 4A 02 23 13 60 00 23 7B 70 38 78 ?? ?? ?? ?? 7B 78 00 2B 02 D0 00 23 FB 60 24 E0 ?? ?? ?? ?? B8 61 BB 69 BB 60 BB 68 1B 68 00 2B 14 D0 B8 68 ?? ?? ?? ?? B8 71 BB 79 00 2B 0D D0 FE 6B 02 25 BC 6B BB 68 1B 68 3B 61 38 69 ?? ?? ?? ?? 3B 69 20 46 29 46 32 46 98 47 06 4B 1B 68 5A 1C 04 4B 1A 60 01 23 FB 60 F8 68 08 B0 BD E8 F0 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_3_0 {
	meta:
		name = "?dllmain_crt_process_detach@@YAH_N@Z"
		size = 128
		refs = "0026 __scrt_acquire_startup_lock 003a __scrt_fastfail 003e __scrt_dllmain_uninitialize_c 0048 __scrt_dllmain_uninitialize_critical 004e __scrt_release_startup_lock 0056 __scrt_uninitialize_crt 0078 __scrt_current_native_startup_state 007c ?__proc_attached@@3HA"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 1B 4B 1B 68 00 2B 02 DC 00 23 7B 60 27 E0 17 4B 1B 68 5A 1E 16 4B 1A 60 ?? ?? ?? ?? 78 70 7B 78 3B 70 11 4B 1B 68 02 2B 02 D0 07 20 ?? ?? ?? ?? ?? ?? ?? ?? 0D 4A 00 23 13 60 ?? ?? ?? ?? 38 78 ?? ?? ?? ?? 00 21 38 7E ?? ?? ?? ?? B8 70 BB 78 00 2B 02 D1 00 23 7B 60 01 E0 01 23 7B 60 78 68 03 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_4_0 {
	meta:
		name = "?fin$0@?0??dllmain_crt_process_detach@@YAH_N@Z@4HA"
		size = 16
		refs = "0002 __scrt_dllmain_uninitialize_critical 0008 __scrt_release_startup_lock"
	strings:
		$1 = { 10 B5 ?? ?? ?? ?? 38 78 ?? ?? ?? ?? FF E7 10 BD }
	condition:
		$1
}

rule file_79_320_1 {
	meta:
		name = "__catch$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z$0"
		size = 24
		refs = "0004 ?_Tidy@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AAAXXZ 000c _CxxThrowException 0014 $LN7"
	strings:
		$1 = { 10 B5 38 6A ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? 00 48 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_764_1 {
	meta:
		name = "__catch$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z$0"
		size = 24
		refs = "0004 ?_Tidy@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AAAXXZ 000c _CxxThrowException 0014 $LN7"
	strings:
		$1 = { 10 B5 38 6A ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? 00 48 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_766_1 {
	meta:
		name = "__catch$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z$0"
		size = 24
		refs = "0004 ?_Tidy@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AAAXXZ 000c _CxxThrowException 0014 $LN7"
	strings:
		$1 = { 10 B5 38 6A ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? 00 48 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_58_1 {
	meta:
		name = "__unwindfunclet$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z$1"
		size = 16
		refs = "0006 ??3@YAXPAX0@Z 000c ?classic_locale@std@@3Vlocale@1@A"
	strings:
		$1 = { 10 B5 02 49 B8 68 ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_5_0 {
	meta:
		name = "?dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
		size = 240
		refs = "003a ?dllmain_raw@@YAHQAUHINSTANCE__@@KQAX@Z 0052 ?dllmain_crt_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z 006a DllMain 00ec ?__proc_attached@@3HA"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 8B B0 6F 46 82 B0 FB 6B 00 2B 06 D1 35 4B 1B 68 00 2B 02 DC 00 23 BB 60 5C E0 01 23 3B 60 FB 6B 01 2B 02 D0 FB 6B 02 2B 17 D1 3A 6C F9 6B B8 6B ?? ?? ?? ?? F8 60 FB 68 3B 60 3B 68 00 2B 00 D1 42 E0 3A 6C F9 6B B8 6B ?? ?? ?? ?? 38 61 3B 69 3B 60 3B 68 00 2B 00 D1 36 E0 3A 6C F9 6B B8 6B ?? ?? ?? ?? 78 61 7B 69 3B 60 FB 6B 01 2B 11 D1 3B 68 00 2B 0E D1 3A 6C 00 21 B8 6B ?? ?? ?? ?? 3A 6C 00 21 B8 6B ?? ?? ?? ?? 3A 6C 00 21 B8 6B ?? ?? ?? ?? FB 6B 00 2B 02 D0 FB 6B 03 2B 13 D1 3A 6C F9 6B B8 6B ?? ?? ?? ?? B8 61 BB 69 3B 60 3B 68 00 2B 00 D1 07 E0 3A 6C F9 6B B8 6B ?? ?? ?? ?? F8 61 FB 69 3B 60 02 E0 00 23 3B 60 FF E7 3B 68 BB 60 B8 68 0D B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_6_0 {
	meta:
		name = "?filt$0@?0??dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z@4HA"
		size = 52
		refs = "0022 __scrt_dllmain_exception_filter 0030 ?dllmain_crt_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
	strings:
		$1 = { 10 B5 82 B0 78 60 7B 68 3B 62 7B 68 1B 68 1B 68 7B 62 3B 6A 01 93 7B 6A 00 93 05 4B 3A 6C F9 6B B8 6B ?? ?? ?? ?? B8 62 B8 6A 02 B0 10 BD FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_7_0 {
	meta:
		name = "?dllmain_raw@@YAHQAUHINSTANCE__@@KQAX@Z"
		size = 76
		refs = "0028 _guard_check_icall 0048 _pRawDllMain"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B 83 B0 0E 4B 1B 68 00 2B 02 D1 01 23 01 93 10 E0 0A 9E 09 9D 08 9C 09 4B 1B 68 00 93 00 98 ?? ?? ?? ?? 00 9B 20 46 29 46 32 46 98 47 02 90 02 9B 01 93 01 98 03 B0 BD E8 70 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_8_0 {
	meta:
		name = "_CRT_INIT"
		size = 38
		refs = "0010 ?dllmain_crt_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_94_2_1 {
	meta:
		name = "?_Fiopen@std@@YAPAU_iobuf@@PBDHH@Z"
		size = 38
		refs = "0010 ??$_Xfiopen@D@std@@YAPAU_iobuf@@PBDHH@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_94_3_1 {
	meta:
		name = "?_Fiopen@std@@YAPAU_iobuf@@PBGHH@Z"
		size = 38
		refs = "0010 ?_Fiopen@std@@YAPAU_iobuf@@PB_WHH@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_94_4_1 {
	meta:
		name = "?_Fiopen@std@@YAPAU_iobuf@@PB_WHH@Z"
		size = 38
		refs = "0010 ??$_Xfiopen@_W@std@@YAPAU_iobuf@@PB_WHH@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_83_45_1 {
	meta:
		name = "_Cnd_timedwait"
		size = 38
		refs = "0010 ?do_wait@@YAHPAU_Cnd_internal_imp_t@@PAU_Mtx_internal_imp_t@@PBUxtime@@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_14_9_0 {
	meta:
		name = "_DllMainCRTStartup"
		size = 48
		refs = "0010 __security_init_cookie 001a ?dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 9B 01 2B 01 D1 ?? ?? ?? ?? 06 9A 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_17_5_0 {
	meta:
		name = "__scrt_stub_for_is_c_termination_complete"
		size = 20
		altNames = "__scrt_initialize_winrt _get_startup_commit_mode _get_startup_new_mode _get_startup_thread_locale_mode"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 00 23 00 93 00 98 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "__chkstk"
		size = 28
	strings:
		$1 = { BD EB 84 0C 1D EE 50 4F A4 68 04 D3 A4 45 05 D3 AD EB 0C 04 70 47 5F F0 00 0C F7 E7 }
	condition:
		$1
}

rule file_19_1_0 {
	meta:
		name = "__chkstk_probe"
		size = 26
	strings:
		$1 = { 60 B4 66 46 6F F3 0B 06 A4 F5 80 54 25 68 B4 42 FA D1 60 BC AD EB 0C 04 70 47 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__isa_available_init"
		size = 44
		refs = "000a IsProcessorFeaturePresent 0028 __isa_available"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 13 20 ?? ?? ?? ?? 00 90 00 9B 00 2B 02 D0 04 4A 01 23 13 60 00 23 01 93 01 98 02 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "__dyn_tls_init"
		size = 96
		refs = "003c _guard_check_icall 0048 terminate 0058 __xd_z 005c __xd_a"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 7B 6A 02 2B 00 D0 1B E0 11 4B 1B 1D 3B 60 02 E0 3B 68 1B 1D 3B 60 3A 68 0C 4B 9A 42 0C D0 3B 68 1B 68 00 2B 07 D0 3B 68 1B 68 7B 60 78 68 ?? ?? ?? ?? 7B 68 98 47 EB E7 02 E0 ?? ?? ?? ?? FF E7 05 B0 BD E8 80 08 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_1_0 {
	meta:
		name = "__dyn_tls_init$filt$0"
		size = 24
		refs = "000e dyntls_init_exception_filter"
	strings:
		$1 = { 10 B5 B8 60 BB 68 1B 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? 38 61 38 69 10 BD }
	condition:
		$1
}

rule file_23_2_0 {
	meta:
		name = "dyntls_init_exception_filter"
		size = 44
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 06 4B 9A 42 02 D1 01 23 00 93 01 E0 00 23 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB 63 73 6D E0 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "??2@YAPAXIHPBDH@Z"
		size = 86
		refs = "0012 _malloc_dbg 002a _callnewh 003e ?__scrt_throw_std_bad_array_new_length@@YAXXZ 0044 ?__scrt_throw_std_bad_alloc@@YAXXZ"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 09 9B 08 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 00 2B 02 D0 00 9B 03 93 10 E0 06 98 ?? ?? ?? ?? 02 90 02 9B 00 2B 08 D1 06 9B B3 F1 FF 3F 02 D1 ?? ?? ?? ?? 01 E0 ?? ?? ?? ?? DF E7 03 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "??_U@YAPAXIHPBDH@Z"
		size = 40
		refs = "0012 ??2@YAPAXIHPBDH@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 07 9B 06 9A 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_19_18_4 {
	meta:
		name = "__CxxFrameHandler2"
		size = 40
		refs = "0012 __CxxFrameHandler3"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 07 9B 06 9A 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "?GetPdbDll@@YAPAUHINSTANCE__@@XZ"
		size = 138
		refs = "0006 __security_push_cookie 000e ?alreadyTried@?1??GetPdbDll@@YAPAUHINSTANCE__@@XZ@4_NA 0020 __security_pop_cookie 002c ?GetPdbDllFromInstallPath@@YAPAUHINSTANCE__@@XZ 0034 ?debugCrtFileName@@3QB_WB 003c __vcrt_GetModuleHandleW 0048 __vcrt_GetModuleFileNameW 0056 ?GetPdbDllPathFromFilePath@@YAHPB_WPA_WI@Z 0064 __vcrt_LoadLibraryExW 006c ??_C@_1BC@JINFINNJ@?$AAM?$AAS?$AAP?$AAD?$AAB?$AA1?$AA4?$AA0?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? AD F2 14 4D ?? ?? ?? ?? C0 F2 00 02 13 78 33 B1 00 20 0D F2 14 4D ?? ?? ?? ?? BD E8 00 88 01 23 13 70 ?? ?? ?? ?? 00 28 F3 D1 ?? ?? ?? ?? C0 F2 00 00 ?? ?? ?? ?? A0 B1 69 46 4F F4 82 72 ?? ?? ?? ?? 70 B1 82 A9 68 46 4F F4 82 72 ?? ?? ?? ?? 38 B1 82 A8 4F F4 10 62 00 21 ?? ?? ?? ?? 00 28 D7 D1 ?? ?? ?? ?? C0 F2 00 00 4F F4 20 62 00 21 ?? ?? ?? ?? 0D F2 14 4D ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_9_25_1 {
	meta:
		name = "?_ReportUnobservedException@details@Concurrency@@YAXXZ"
		size = 18
		refs = "000a terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 20 FB DE ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "?GetPdbDllFromInstallPath@@YAPAUHINSTANCE__@@XZ"
		size = 422
		refs = "0008 __security_push_cookie 0010 ??_C@_1EI@MLPKHBGE@?$AAa?$AAp?$AAi?$AA?9?$AAm?$AAs?$AA?9?$AAw?$AAi?$AAn?$AA?9?$AAc?$AAo?$AAr?$AAe?$AA?9?$AAr?$AAe?$AAg?$AAi?$AAs?$AAt?$AAr?$AAy?$AA?9?$AAl?$AA1?$AA?9?$AA1?$AA?9?$AA0?$AA?4@ 001e __vcrt_LoadLibraryExW 0026 ??_C@_1BK@JHLNAEJL@?$AAa?$AAd?$AAv?$AAa?$AAp?$AAi?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 003c __imp_GetLastError 0060 __imp_GetProcAddress 0068 ??_C@_0O@COHOBMLB@RegOpenKeyExW?$AA@ 0082 ??_C@_0BB@GLNAEDBD@RegQueryValueExW?$AA@ 009c ??_C@_0M@HLOHPNFA@RegCloseKey?$AA@ 00b8 _guard_check_icall 00bc ??_C@_1HE@EBEAGLFB@?$AAS?$AAO?$AAF?$AAT?$AAW?$AAA?$AAR?$AAE?$AA?2?$AAW?$AAo?$AAw?$AA6?$AA4?$AA3?$AA2?$AAN?$AAo?$AAd?$AAe?$AA?2?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?2?$AAV@ 00ce __imp_FreeLibrary 00e2 __security_pop_cookie 0100 ??_C@_1BG@EABPBLLF@?$AAP?$AAr?$AAo?$AAd?$AAu?$AAc?$AAt?$AAD?$AAi?$AAr?$AA?$AA@ 0176 ?mspdbName@@3QB_WB"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? AD F5 08 7D ?? ?? ?? ?? C0 F2 00 00 4F F4 00 62 00 21 ?? ?? ?? ?? 05 46 E5 B9 ?? ?? ?? ?? C0 F2 00 00 4F F4 00 62 00 21 ?? ?? ?? ?? 05 46 8D B9 ?? ?? ?? ?? C0 F2 00 03 1B 68 98 47 57 28 47 D1 ?? ?? ?? ?? C0 F2 00 00 00 22 00 21 ?? ?? ?? ?? 05 46 ED B3 ?? ?? ?? ?? C0 F2 00 03 ?? ?? ?? ?? C0 F2 00 01 28 46 1B 68 98 47 06 46 86 B3 ?? ?? ?? ?? C0 F2 00 03 ?? ?? ?? ?? C0 F2 00 01 28 46 1B 68 98 47 07 46 1F B3 ?? ?? ?? ?? C0 F2 00 03 ?? ?? ?? ?? C0 F2 00 01 28 46 1B 68 98 47 80 46 B0 B1 02 AB 30 46 00 93 4F F0 00 44 ?? ?? ?? ?? ?? ?? ?? ?? C0 F2 00 01 A0 1C 00 22 01 23 B0 47 68 B1 ?? ?? ?? ?? C0 F2 00 03 28 46 1B 68 98 47 00 20 0D F5 08 7D ?? ?? ?? ?? BD E8 F0 89 4F F4 02 73 03 93 03 AB 01 93 06 AB 38 46 00 93 ?? ?? ?? ?? 02 98 ?? ?? ?? ?? C0 F2 00 01 00 22 04 AB B8 47 04 46 40 46 ?? ?? ?? ?? 02 98 C0 47 ?? ?? ?? ?? C0 F2 00 03 28 46 1B 68 98 47 00 2C D7 D1 04 9B 01 2B D4 D1 03 9B 13 F0 01 0F D0 D1 5A 08 10 46 02 2A CC D3 52 1E 06 AB 03 EB 42 01 33 F8 12 30 00 2B C4 D1 31 F8 02 3C 5C 2B 02 D0 5C 23 0B 80 02 46 D3 43 12 2B BA D3 02 F1 11 03 B3 F5 82 7F B5 D8 06 AB 03 EB 42 02 ?? ?? ?? ?? C0 F2 00 01 02 F1 22 00 31 F8 02 3B 22 F8 02 3B 82 42 F9 D1 06 A8 00 21 4F F4 10 62 ?? ?? ?? ?? 0D F5 08 7D ?? ?? ?? ?? BD E8 F0 89 }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "?GetPdbDllPathFromFilePath@@YAHPB_WPA_WI@Z"
		size = 146
		refs = "0008 __security_push_cookie 002e _wsplitpath_s 003a __security_pop_cookie 0042 ?mspdbFilename@?1??GetPdbDllPathFromFilePath@@YAHPB_WPA_WI@Z@4QB_WB 004e wcscpy_s 0056 ?dllExt@?1??GetPdbDllPathFromFilePath@@YAHPB_WPA_WI@Z@4QB_WB 007c _wmakepath_s"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 C4 6D 08 AB 03 93 88 AB 01 93 15 46 0E 46 4F F4 80 74 0D F5 84 63 06 A9 03 22 04 94 02 94 00 94 ?? ?? ?? ?? 30 B1 00 20 0D F5 C4 6D ?? ?? ?? ?? BD E8 70 88 ?? ?? ?? ?? C0 F2 00 02 88 A8 09 21 ?? ?? ?? ?? 00 28 EE D1 ?? ?? ?? ?? C0 F2 00 02 08 A8 04 21 ?? ?? ?? ?? 00 28 E4 D1 08 AB 01 93 88 AB 00 93 0D F5 84 63 06 AA 29 46 30 46 ?? ?? ?? ?? 00 28 D7 D1 01 20 0D F5 C4 6D ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_28_3_0 {
	meta:
		name = "?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z"
		size = 788
		refs = "000c __imp_VirtualQuery 0048 __vcrt_GetModuleFileNameW 009e ?PDBOK@?1??_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z@4_NA 00a6 ?mspdb@@3PAUHINSTANCE__@@A 00ba ?GetPdbDll@@YAPAUHINSTANCE__@@XZ 00cc __imp_GetProcAddress 00d4 ??_C@_0BB@KCIACLNC@PDBOpenValidate5?$AA@ 00f6 _guard_check_icall 012e ??_C@_01KDCPPGHE@r?$AA@ 020a __imp_GetProcessHeap 021c __imp_HeapAlloc 02b4 __imp_HeapFree"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 97 B0 ?? ?? ?? ?? C0 F2 00 04 4F F0 00 09 C3 F8 00 90 05 46 A1 F8 00 90 24 68 6D 1E 0E 91 1C 22 10 A9 28 46 0C 93 A0 47 30 B9 00 27 38 46 17 B0 BD E8 F0 0F 5D F8 14 FB 25 9A 24 99 11 98 ?? ?? ?? ?? 00 28 F1 D0 11 99 45 F6 4D 23 0A 88 9A 42 EB D1 CB 6B 00 2B E8 DD 5A 58 5C 18 44 F2 50 53 9A 42 E2 D1 A3 8A E0 88 69 1A 23 44 00 26 4F F0 00 08 68 B1 03 F1 18 02 D3 68 99 42 04 D3 A1 EB 03 08 93 68 99 42 03 D3 76 1C 28 32 86 42 F3 D3 86 42 CA D0 ?? ?? ?? ?? C0 F2 00 05 ?? ?? ?? ?? C0 F2 00 04 76 1C 2B 78 53 B9 23 68 00 2B BC D1 ?? ?? ?? ?? 20 60 00 28 B7 D0 01 23 2B 70 00 E0 20 68 ?? ?? ?? ?? C0 F2 00 03 ?? ?? ?? ?? C0 F2 00 01 1B 68 98 47 04 46 00 2C A6 D0 08 AB 03 93 0F AB 00 93 CD F8 08 90 CD F8 04 90 ?? ?? ?? ?? 24 98 00 21 00 22 00 23 A0 47 00 28 95 D0 08 9D 00 27 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 7D 4B 98 42 40 F0 E9 80 08 9D 2C 68 E4 69 20 46 ?? ?? ?? ?? ?? ?? ?? ?? C0 F2 00 02 28 46 00 21 0B AB A0 47 00 28 00 F0 D8 80 0B 9C CD F8 08 90 CD F8 04 90 22 68 CD F8 00 90 15 6A 28 46 ?? ?? ?? ?? 20 46 B1 B2 42 46 07 AB A8 47 00 28 00 F0 BC 80 07 9D 00 23 05 93 2B 68 9C 6E 20 46 ?? ?? ?? ?? 28 46 05 A9 A0 47 00 28 00 F0 A6 80 05 9D 00 2D 00 F0 A2 80 2B 68 B9 46 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 00 28 00 F0 81 80 0D F1 18 0A 05 9C 09 AB 00 93 23 68 00 22 02 92 DD 68 CD F8 04 A0 28 46 ?? ?? ?? ?? 20 46 00 21 0A AA 04 AB A8 47 00 28 79 D0 BD F8 10 30 B3 42 06 D1 0A 9A 42 45 03 D8 09 9B 13 44 98 45 0A D3 05 9D 2B 68 9C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 00 28 56 D0 D6 E7 06 9A 00 2A 60 D0 6F F0 60 43 9A 42 5C D2 ?? ?? ?? ?? C0 F2 00 03 1B 68 98 47 06 9B 00 21 DA 00 ?? ?? ?? ?? C0 F2 00 03 1B 68 98 47 81 46 00 28 4A D0 05 9D 02 90 06 AB 2C 68 00 26 01 93 E4 68 00 96 20 46 ?? ?? ?? ?? 28 46 0D A9 00 22 00 23 A0 47 58 B3 0A 9B A8 EB 03 04 D9 F8 00 30 9C 42 24 D3 06 98 01 22 01 28 08 D9 09 F1 08 01 51 F8 08 3B 9C 42 02 D3 52 1C 82 42 F8 D3 09 EB C2 03 53 F8 04 3C 0C 9A 07 9C 23 F0 7F 43 13 60 22 68 02 96 01 96 15 6F 00 96 28 46 ?? ?? ?? ?? DD E9 0D 12 20 46 22 AB A8 47 00 B1 01 27 ?? ?? ?? ?? C0 F2 00 03 1B 68 98 47 ?? ?? ?? ?? C0 F2 00 03 4A 46 00 21 1B 68 98 47 05 9D 2B 68 1C 68 20 46 ?? ?? ?? ?? 28 46 A0 47 07 9D 2B 68 1C 6C 20 46 ?? ?? ?? ?? 28 46 A0 47 0B 9D 2B 68 9C 6B 20 46 ?? ?? ?? ?? 28 46 A0 47 08 9D 2B 68 DC 6A 20 46 ?? ?? ?? ?? 28 46 A0 47 38 46 17 B0 BD E8 F0 0F 5D F8 14 FB 41 91 32 01 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "??_U@YAPAXI@Z"
		size = 34
		refs = "000c ??2@YAPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_86_61_1 {
	meta:
		name = "??C?$shared_ptr@V__ExceptionPtr@@@std@@QBAPAV__ExceptionPtr@@XZ"
		size = 34
		refs = "000c ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QBAPAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_27_182_3 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAAADXZ"
		size = 34
		refs = "000c ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAABDXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_466_2 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAAAGXZ"
		size = 34
		refs = "000c ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAABGXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_467_2 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAAA_WXZ"
		size = 34
		refs = "000c ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAAB_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_495_1 {
	meta:
		name = "?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_496_1 {
	meta:
		name = "?_Bx@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAT_Bxty@?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_37_1 {
	meta:
		name = "?_Bx@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAT_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_33_113_2 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAAAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_88_112_2 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QBAABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_685_3 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_555_1 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QBAABV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_47_1 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_639_2 {
	meta:
		name = "?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QBAABV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_701_3 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAAAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_13_240_3 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QBAABU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_572_1 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAAAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_704_3 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QBAABU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_656_2 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_54_1 {
	meta:
		name = "?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
		size = 34
		refs = "000c ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QBAABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_69_129_3 {
	meta:
		name = "?_Myproxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAPAU_Container_proxy@2@XZ"
		size = 34
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_967_3 {
	meta:
		name = "?_Myproxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAPAU_Container_proxy@2@XZ"
		size = 34
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_7_92_2 {
	meta:
		name = "?_Myproxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAPAU_Container_proxy@2@XZ"
		size = 34
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_114_132_3 {
	meta:
		name = "?get@?$shared_ptr@V__ExceptionPtr@@@std@@QBAPAV__ExceptionPtr@@XZ"
		size = 34
		refs = "000c ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QBAPAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_28_314_1 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QBAIU_Nil@2@@Z"
		size = 34
		refs = "000c ?max_size@?$allocator_traits@V?$allocator@D@std@@@std@@SAIABV?$allocator@D@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_1333_2 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QBAIU_Nil@2@@Z"
		size = 34
		refs = "000c ?max_size@?$allocator_traits@V?$allocator@G@std@@@std@@SAIABV?$allocator@G@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_65_141_3 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QBAIU_Nil@2@@Z"
		size = 34
		refs = "000c ?max_size@?$allocator_traits@V?$allocator@_W@std@@@std@@SAIABV?$allocator@_W@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_82_367_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@D@std@@@std@@SAIABV?$allocator@D@2@@Z"
		size = 34
		refs = "000c ?max_size@?$allocator@D@std@@QBAIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_1389_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@G@std@@@std@@SAIABV?$allocator@G@2@@Z"
		size = 34
		refs = "000c ?max_size@?$allocator@G@std@@QBAIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_1203_1 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@_W@std@@@std@@SAIABV?$allocator@_W@2@@Z"
		size = 34
		refs = "000c ?max_size@?$allocator@_W@std@@QBAIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_53_340_1 {
	meta:
		name = "?pointer_to@?$pointer_traits@PAD@std@@SAPADAAD@Z"
		size = 34
		refs = "000c ??$addressof@D@std@@YAPADAAD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_1355_2 {
	meta:
		name = "?pointer_to@?$pointer_traits@PAG@std@@SAPAGAAG@Z"
		size = 34
		refs = "000c ??$addressof@G@std@@YAPAGAAG@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_79_167_3 {
	meta:
		name = "?pointer_to@?$pointer_traits@PAU_Container_proxy@std@@@std@@SAPAU_Container_proxy@2@AAU32@@Z"
		size = 34
		refs = "000c ??$addressof@U_Container_proxy@std@@@std@@YAPAU_Container_proxy@0@AAU10@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_1357_2 {
	meta:
		name = "?pointer_to@?$pointer_traits@PA_W@std@@SAPA_WAA_W@Z"
		size = 34
		refs = "000c ??$addressof@_W@std@@YAPA_WAA_W@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_32_39_3 {
	meta:
		name = "_Mtx_getconcrtcs"
		size = 34
		refs = "000c ?_get_cs@_Mtx_internal_imp_t@@QAAPAVstl_critical_section_interface@details@Concurrency@@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "?__scrt_initialize_thread_safe_statics@@YAHXZ"
		size = 128
		refs = "0028 ??$__crt_fast_encode_pointer@P6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z 0038 ??$__crt_fast_encode_pointer@P6AXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z 0046 atexit 0058 ?__scrt_uninitialize_thread_safe_statics@@YAXXZ 005c ?encoded_wake_all_condition_variable@@3P6AXPAU_RTL_CONDITION_VARIABLE@@@ZA 0060 __imp_WakeAllConditionVariable 0064 ?encoded_sleep_condition_variable_cs@@3P6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZA 0068 __imp_SleepConditionVariableCS 006c __imp_InitializeConditionVariable 0070 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 0074 ?_Tss_event@@3PAXA 0078 __imp_InitializeCriticalSectionEx 007c ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 00 22 4F F4 7A 61 1B 48 19 4B 1B 68 98 47 17 4A 00 23 13 60 14 48 13 4B 1B 68 98 47 10 4B 18 68 ?? ?? ?? ?? 00 90 00 9A 0C 4B 1A 60 0A 4B 18 68 ?? ?? ?? ?? 01 90 01 9A 06 4B 1A 60 04 48 ?? ?? ?? ?? 00 23 02 93 02 98 04 B0 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_1_0 {
	meta:
		name = "??$__crt_fast_decode_pointer@P6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z"
		size = 56
		refs = "0010 __rt_udiv 001e ?__crt_rotate_pointer_value@@YAIIH@Z 0034 __security_cookie"
		altNames = "??$__crt_fast_decode_pointer@P6AXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z ??$__crt_fast_decode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_decode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0A 4B 19 68 20 20 ?? ?? ?? ?? 04 9A 07 4B 1B 68 82 EA 03 00 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_3_0 {
	meta:
		name = "??$__crt_fast_encode_pointer@P6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z"
		size = 60
		refs = "0010 __rt_udiv 001a ?__crt_rotate_pointer_value@@YAIIH@Z 0038 __security_cookie"
		altNames = "??$__crt_fast_encode_pointer@P6AXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z ??$__crt_fast_encode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_encode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0B 4B 19 68 20 20 ?? ?? ?? ?? C1 F1 20 01 04 98 ?? ?? ?? ?? 00 90 00 9A 05 4B 1B 68 53 40 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_5_0 {
	meta:
		name = "?__crt_rotate_pointer_value@@YAIIH@Z"
		size = 30
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 9A 04 9B D3 41 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_32_6_0 {
	meta:
		name = "?__scrt_uninitialize_thread_safe_statics@@YAXXZ"
		size = 52
		refs = "0024 __imp_CloseHandle 0028 ?_Tss_event@@3PAXA 002c __imp_DeleteCriticalSection 0030 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 48 08 4B 1B 68 98 47 06 4B 1B 68 00 2B 04 D0 04 4B 18 68 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_7_0 {
	meta:
		name = "_Init_thread_abort"
		size = 34
		refs = "0008 _Init_thread_lock 0012 _Init_thread_unlock 0016 _Init_thread_notify"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 02 9A 00 23 13 60 ?? ?? ?? ?? ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_32_8_0 {
	meta:
		name = "_Init_thread_footer"
		size = 88
		refs = "0008 _Init_thread_lock 003c _Init_thread_unlock 0040 _Init_thread_notify 004c _Init_global_epoch 0050 _Init_thread_epoch 0054 _tls_index"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 0F 4B 1B 68 5A 1C 0E 4B 1A 60 0D 4B 1A 68 02 9B 1A 60 0D 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 07 4B 1A 44 05 4B 1B 68 13 60 ?? ?? ?? ?? ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_9_0 {
	meta:
		name = "_Init_thread_header"
		size = 124
		refs = "0008 _Init_thread_lock 002a _Init_thread_wait 003e _Init_thread_unlock 0070 _Init_global_epoch 0074 _Init_thread_epoch 0078 _tls_index"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 02 9B 1B 68 00 2B 04 D1 02 9A 6F F0 00 03 13 60 22 E0 02 9B 1B 68 B3 F1 FF 3F 0E D1 64 20 ?? ?? ?? ?? 02 9B 1B 68 00 2B 06 D1 02 9A 6F F0 00 03 13 60 ?? ?? ?? ?? 11 E0 EB E7 0C 4B 1A 68 04 23 02 FB 03 F2 1D EE 50 3F DB 6A 13 44 1A 68 06 4B 1A 44 04 4B 1B 68 13 60 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_10_0 {
	meta:
		name = "_Init_thread_lock"
		size = 28
		refs = "0014 __imp_EnterCriticalSection 0018 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 48 02 4B 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "?__scrt_initialize_type_info@@YAXXZ"
		size = 28
		refs = "0014 __imp_InitializeSListHead 0018 ?__type_info_root_node@@3U__type_info_node@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 48 02 4B 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_12_0 {
	meta:
		name = "_Init_thread_unlock"
		size = 28
		refs = "0014 __imp_LeaveCriticalSection 0018 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 48 02 4B 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_4_0 {
	meta:
		name = "__scrt_set_unhandled_exception_filter"
		size = 28
		refs = "0014 __imp_SetUnhandledExceptionFilter 0018 __scrt_unhandled_exception_filter"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 48 02 4B 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_11_0 {
	meta:
		name = "_Init_thread_notify"
		size = 96
		refs = "0016 ??$__crt_fast_decode_pointer@P6AXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z 0024 _guard_check_icall 004c __imp_ResetEvent 0050 ?_Tss_event@@3PAXA 0054 __imp_SetEvent 0058 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 005c ?encoded_wake_all_condition_variable@@3P6AXPAU_RTL_CONDITION_VARIABLE@@@ZA"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 83 B0 11 4B 1B 68 00 2B 0E D1 12 4B 18 68 ?? ?? ?? ?? 01 90 0E 4C 01 9B 00 93 00 98 ?? ?? ?? ?? 00 9B 20 46 98 47 09 E0 07 4B 18 68 07 4B 1B 68 98 47 05 4B 18 68 03 4B 1B 68 98 47 03 B0 BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_13_0 {
	meta:
		name = "_Init_thread_wait"
		size = 220
		refs = "0018 ??$__crt_fast_decode_pointer@P6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z 002a _guard_check_icall 006e _CrtDbgReportW 007c _Init_thread_unlock 0094 _Init_thread_lock 00c0 __imp_WaitForSingleObjectEx 00c4 ?_Tss_event@@3PAXA 00c8 ??_C@_1HK@LKKBAJNK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAv?$AAc?$AAs?$AAt?$AAa?$AAr?$AAt?$AAu?$AAp?$AA?2?$AAs?$AAr?$AAc?$AA?2@ 00cc ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00d0 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 00d4 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 00d8 ?encoded_sleep_condition_variable_cs@@3P6AHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZA"
	strings:
		$1 = { 03 B4 2D E9 70 48 0D F1 0C 0B 8B B0 2D 4B 1B 68 00 2B 20 D1 30 4B 18 68 ?? ?? ?? ?? 06 90 10 9E 2C 4D 2B 4C 06 9B 02 93 02 98 ?? ?? ?? ?? 02 9B 20 46 29 46 32 46 98 47 07 90 07 9B 00 2B 02 D0 01 23 03 93 01 E0 00 23 03 93 03 9B DB B2 8D F8 14 30 2D E0 2C E0 10 9B B3 F1 FF 3F 0E D1 00 23 01 93 1A 4B 00 93 00 23 8F 22 17 49 02 20 ?? ?? ?? ?? 08 90 08 9B 01 2B 00 D1 FE DE ?? ?? ?? ?? 00 22 10 99 0F 4B 18 68 0D 4B 1B 68 98 47 09 90 09 9B 0A 93 ?? ?? ?? ?? 0A 9B 00 2B 02 D1 01 23 04 93 01 E0 00 23 04 93 04 9B DB B2 8D F8 14 30 9D F8 14 00 0B B0 BD E8 70 08 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__scrt_is_ucrt_dll_in_use"
		size = 44
		refs = "0028 __scrt_ucrt_dll_is_in_use"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 07 4B 1B 68 00 2B 02 D0 01 23 00 93 01 E0 00 23 00 93 00 9B 01 93 01 98 02 B0 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "??1type_info@@UAA@XZ"
		size = 28
		refs = "0018 ??_7type_info@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9A 03 4B 13 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_465_3 {
	meta:
		name = "??1_Facet_base@std@@UAA@XZ"
		size = 28
		refs = "0018 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9A 03 4B 13 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_51_3 {
	meta:
		name = "??1_Ref_count_base@std@@UAA@XZ"
		size = 28
		refs = "0018 ??_7_Ref_count_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9A 03 4B 13 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_165_3 {
	meta:
		name = "??1error_category@std@@UAA@XZ"
		size = 28
		refs = "0018 ??_7error_category@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9A 03 4B 13 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__vdecl_fmodf4"
		size = 142
		refs = "0022 fmodf"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 08 8B 22 EF 52 81 18 EE 10 3B 20 EF 50 A1 00 EE 90 3A 1A EE 10 3B 00 EE 10 3A ?? ?? ?? ?? 10 EE 10 3A 0A EE 10 3B 38 EE 10 3B 00 EE 90 3A 3A EE 10 3B 00 EE 10 3A ?? ?? ?? ?? 10 EE 10 3A 2A EE 10 3B 19 EE 10 3B 00 EE 90 3A 1B EE 10 3B 00 EE 10 3A ?? ?? ?? ?? 10 EE 10 3A 0B EE 10 3B 39 EE 10 3B 00 EE 90 3A 3B EE 10 3B 00 EE 10 3A ?? ?? ?? ?? 10 EE 10 3A 2B EE 10 3B 2A EF 5A 01 BD EC 08 8B BD E8 00 88 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__GSHandlerCheck_SEH_noexcept"
		size = 84
		refs = "0012 __GSHandlerCheck_SEH 003a terminate"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 09 9B 08 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 06 9B 1B 1D 1B 68 03 F0 66 03 00 2B 09 D1 06 9B 1A 68 08 4B 9A 42 04 D1 00 9B 01 2B 01 D1 ?? ?? ?? ?? 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB FE DE 63 73 6D E0 }
	condition:
		$1
}

rule file_6_0_4 {
	meta:
		name = "__C_specific_handler_noexcept"
		size = 84
		refs = "0012 __C_specific_handler 003a terminate"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 09 9B 08 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 06 9B 1B 1D 1B 68 03 F0 66 03 00 2B 09 D1 06 9B 1A 68 08 4B 9A 42 04 D1 00 9B 01 2B 01 D1 ?? ?? ?? ?? 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB FE DE 63 73 6D E0 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "_RTC_AllocaHelper"
		size = 44
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 70 B1 69 B1 62 B1 39 B1 CC 25 03 46 21 B1 44 18 03 F8 01 5B A3 42 FB D1 13 68 C1 60 43 60 10 60 BD E8 30 88 }
	condition:
		$1
}

rule file_56_1_0 {
	meta:
		name = "_RTC_CheckStackVars"
		size = 78
		refs = "003c ?_RTC_StackFailure@@YAXPAXPBD@Z"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0E 46 33 68 00 24 80 46 00 2B 1A DD 00 25 6F F0 33 37 73 68 E9 58 EA 18 01 EB 08 03 53 F8 04 3C BB 42 05 D1 53 68 0B 44 53 F8 08 30 BB 42 03 D0 91 68 07 98 ?? ?? ?? ?? 33 68 64 1C 0C 35 9C 42 E7 DB BD E8 F8 89 }
	condition:
		$1
}

rule file_56_2_0 {
	meta:
		name = "_RTC_CheckStackVars2"
		size = 166
		refs = "0042 ?_RTC_StackFailure@@YAXPAXPBD@Z 0080 ?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 14 46 88 46 81 46 6F F0 33 36 F1 B1 0B 68 00 25 00 2B 1A DD 00 27 D8 F8 04 30 F9 58 FA 18 01 EB 09 03 53 F8 04 3C B3 42 05 D1 53 68 0B 44 53 F8 09 30 B3 42 03 D0 91 68 07 98 ?? ?? ?? ?? D8 F8 00 30 6D 1C 0C 37 9D 42 E5 DB 00 25 23 46 24 B3 5B 68 6D 1C 00 2B FB D1 FC B1 23 68 B3 42 08 D1 63 69 B3 42 05 D1 A3 69 B3 42 02 D1 E3 69 B3 42 04 D0 07 98 2A 46 21 46 ?? ?? ?? ?? E3 68 23 44 53 F8 04 3C B3 42 04 D0 07 98 2A 46 21 46 ?? ?? ?? ?? 64 68 6D 1E 00 2C DF D1 BD E8 F0 8B }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "??__E?eps@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_110_1_0 {
	meta:
		name = "??__E?eps@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_153_4_0 {
	meta:
		name = "??__E?eps@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_85_3_0 {
	meta:
		name = "??__E?eps@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_148_8_0 {
	meta:
		name = "??__E?eps@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "??__E?eps@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 39 }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "??__E?eps@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 50 3E }
	condition:
		$1
}

rule file_110_2_0 {
	meta:
		name = "??__E?eps@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 50 3E }
	condition:
		$1
}

rule file_85_4_0 {
	meta:
		name = "??__E?eps@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 50 3E }
	condition:
		$1
}

rule file_148_9_0 {
	meta:
		name = "??__E?eps@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 50 3E }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "??__E?eps@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 50 3E }
	condition:
		$1
}

rule file_57_2_0 {
	meta:
		name = "??__E?exponentBias@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 28
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?exponentBias@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 7E 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_3_0 {
	meta:
		name = "??__E?exponentBias@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@I@Z 0018 ?exponentBias@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 F2 FE 30 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_4_0 {
	meta:
		name = "??__E?exponentMask@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 4F F0 FF 40 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_8_7 {
	meta:
		name = "??__E?inf@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?inf@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 4F F0 FF 40 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_5_0 {
	meta:
		name = "??__E?exponentMask@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?exponentMask@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 F0 7F }
	condition:
		$1
}

rule file_102_9_7 {
	meta:
		name = "??__E?inf@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?inf@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 F0 7F }
	condition:
		$1
}

rule file_57_6_0 {
	meta:
		name = "??__E?ind@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?ind@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 00 C0 FF }
	condition:
		$1
}

rule file_57_7_0 {
	meta:
		name = "??__E?ind@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?ind@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 F8 FF }
	condition:
		$1
}

rule file_57_10_0 {
	meta:
		name = "??__E?neginf@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?neginf@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 00 80 FF }
	condition:
		$1
}

rule file_57_11_0 {
	meta:
		name = "??__E?neginf@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?neginf@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 F0 FF }
	condition:
		$1
}

rule file_57_12_0 {
	meta:
		name = "??__E?notExponentMask@?$VectorOp@M@@2T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?notExponentMask@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 FF 40 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_13_0 {
	meta:
		name = "??__E?notExponentMask@?$VectorOp@N@@2T__n128@@B@@YAXXZ"
		size = 36
		refs = "000c ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 001c ?notExponentMask@?$VectorOp@N@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 49 6F F0 00 00 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? FF FF 0F 80 }
	condition:
		$1
}

rule file_57_14_0 {
	meta:
		name = "??__E?p1@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 6B 16 6F 3F }
	condition:
		$1
}

rule file_57_15_0 {
	meta:
		name = "??__E?p1@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 62 0A 3A A8 55 5E 3B C0 }
	condition:
		$1
}

rule file_57_16_0 {
	meta:
		name = "??__E?p2@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 65 20 01 BF }
	condition:
		$1
}

rule file_57_17_0 {
	meta:
		name = "??__E?p2@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 8A D4 0A 36 A7 9A 4C 40 }
	condition:
		$1
}

rule file_57_18_0 {
	meta:
		name = "??__E?p3@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p3@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_111_12_0 {
	meta:
		name = "??__E?a1@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?a1@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_111_14_0 {
	meta:
		name = "??__E?a2@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?a2@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_111_20_0 {
	meta:
		name = "??__E?b2@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?b2@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_111_22_0 {
	meta:
		name = "??__E?b3@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?b3@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_184_19_7 {
	meta:
		name = "??__E?p2@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_200_29_0 {
	meta:
		name = "??__E?p2@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_235_27_7 {
	meta:
		name = "??__E?p2@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_85_25_0 {
	meta:
		name = "??__E?p2@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_263_26_7 {
	meta:
		name = "??__E?p2@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_122_18_7 {
	meta:
		name = "??__E?p2@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p2@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_110_21_0 {
	meta:
		name = "??__E?p3@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p3@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_235_29_7 {
	meta:
		name = "??__E?p3@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p3@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_85_27_0 {
	meta:
		name = "??__E?p3@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p3@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_263_28_7 {
	meta:
		name = "??__E?p3@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p3@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_57_20_0 {
	meta:
		name = "??__E?p4@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p4@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_138_31_0 {
	meta:
		name = "??__E?p4@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p4@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_22_7 {
	meta:
		name = "??__E?p5@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p5@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_184_27_7 {
	meta:
		name = "??__E?q2@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_336_35_7 {
	meta:
		name = "??__E?q2@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_154_33_7 {
	meta:
		name = "??__E?q2@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_122_24_7 {
	meta:
		name = "??__E?q2@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_30_7 {
	meta:
		name = "??__E?q3@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_184_29_7 {
	meta:
		name = "??__E?q3@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_154_35_7 {
	meta:
		name = "??__E?q3@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_148_36_0 {
	meta:
		name = "??__E?q3@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_122_26_7 {
	meta:
		name = "??__E?q3@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_32_7 {
	meta:
		name = "??__E?q4@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q4@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_110_31_0 {
	meta:
		name = "??__E?q4@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q4@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_138_39_0 {
	meta:
		name = "??__E?q4@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q4@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_263_38_7 {
	meta:
		name = "??__E?q4@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q4@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_102_34_7 {
	meta:
		name = "??__E?q5@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q5@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_138_41_0 {
	meta:
		name = "??__E?q5@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q5@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_138_43_0 {
	meta:
		name = "??__E?q6@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q6@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_235_45_7 {
	meta:
		name = "??__E?q7@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q7@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_153_30_0 {
	meta:
		name = "??__E?r5@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r5@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_267_32_7 {
	meta:
		name = "??__E?r6@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r6@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_153_34_0 {
	meta:
		name = "??__E?r7@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r7@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_267_36_7 {
	meta:
		name = "??__E?r8@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r8@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_57_19_0 {
	meta:
		name = "??__E?p3@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p3@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9F DA A6 A9 2C D8 43 C0 }
	condition:
		$1
}

rule file_57_21_0 {
	meta:
		name = "??__E?p4@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p4@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 27 39 EC 64 17 4E 24 40 }
	condition:
		$1
}

rule file_57_23_0 {
	meta:
		name = "??__E?p5@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p5@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 65 1E E6 B5 BD 4B E6 BF }
	condition:
		$1
}

rule file_57_24_0 {
	meta:
		name = "??__E?q0@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F0 50 B3 40 }
	condition:
		$1
}

rule file_57_25_0 {
	meta:
		name = "??__E?q0@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CC 87 2B 3E C0 86 64 C0 }
	condition:
		$1
}

rule file_57_26_0 {
	meta:
		name = "??__E?q1@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 0B 8D B1 C0 }
	condition:
		$1
}

rule file_57_27_0 {
	meta:
		name = "??__E?q1@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 43 B8 1E 10 4F 12 7A 40 }
	condition:
		$1
}

rule file_57_28_0 {
	meta:
		name = "??__E?q2@?$VASin@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_18_0 {
	meta:
		name = "??__E?b1@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?b1@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_20_0 {
	meta:
		name = "??__E?one@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?one@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_148_22_0 {
	meta:
		name = "??__E?p0@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p0@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_148_30_0 {
	meta:
		name = "??__E?q0@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_25_0 {
	meta:
		name = "??__E?q1@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_31_0 {
	meta:
		name = "??__E?q1@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_22_0 {
	meta:
		name = "??__E?q1@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_29_0 {
	meta:
		name = "??__E?q2@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 48 A8 56 FC CE DD 77 C0 }
	condition:
		$1
}

rule file_57_31_0 {
	meta:
		name = "??__E?q3@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 70 1C 59 96 7C DE 62 40 }
	condition:
		$1
}

rule file_57_33_0 {
	meta:
		name = "??__E?q4@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q4@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1F 86 F9 6E E8 D2 37 C0 }
	condition:
		$1
}

rule file_57_35_0 {
	meta:
		name = "??__E?q5@?$VASin@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q5@?$VASin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_23_0 {
	meta:
		name = "??__E?b3@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?b3@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_21_0 {
	meta:
		name = "??__E?one@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?one@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_148_23_0 {
	meta:
		name = "??__E?p0@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p0@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_148_31_0 {
	meta:
		name = "??__E?q0@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_36_0 {
	meta:
		name = "??__E?q3@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_27_0 {
	meta:
		name = "??__E?q3@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_32_0 {
	meta:
		name = "??__E?q4@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q4@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_36_0 {
	meta:
		name = "?A@?$VASin@M@@CA?AT__n128@@T2@@Z"
		size = 84
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 87 B0 00 23 00 93 10 4B 10 EE 10 2B 30 EE 10 1B 01 93 6B 46 11 EE 10 0B 53 F8 22 30 31 EE 10 4B 02 93 6B 46 53 F8 21 30 03 93 6B 46 53 F8 20 30 04 93 6B 46 53 F8 24 30 05 93 0D F1 08 0C 9C EC 04 0B 07 B0 BD E8 10 88 DA 0F 49 3F }
	condition:
		$1
}

rule file_57_37_0 {
	meta:
		name = "?B@?$VASin@M@@CA?AT__n128@@T2@@Z"
		size = 88
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 87 B0 12 4B 10 EE 10 2B 30 EE 10 1B 00 93 0E 4B 11 EE 10 0B 31 EE 10 4B 01 93 6B 46 53 F8 22 30 02 93 6B 46 53 F8 21 30 03 93 6B 46 53 F8 20 30 04 93 6B 46 53 F8 24 30 05 93 0D F1 08 0C 9C EC 04 0B 07 B0 BD E8 10 88 DA 0F 49 3F DA 0F C9 3F }
	condition:
		$1
}

rule file_57_40_0 {
	meta:
		name = "?acos@?$VASin@M@@SA?AT__n128@@T2@@Z"
		size = 512
		refs = "001e ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0030 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 01dc ?ind@?$VectorOp@M@@2T__n128@@B 01e4 ?eps@?$VASin@M@@0T__n128@@B 01e8 ?q0@?$VASin@M@@0T__n128@@B 01ec ?q1@?$VASin@M@@0T__n128@@B 01f0 ?p1@?$VASin@M@@0T__n128@@B 01f8 ?p2@?$VASin@M@@0T__n128@@B"
		altNames = "__vdecl_acosf4"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 10 8B 94 B0 20 EF 50 E1 9F ED 7A 0A 0D F1 40 0C 8C EC 04 EB ?? ?? ?? ?? 60 EF 50 01 01 20 0D F1 30 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A ?? ?? ?? ?? 20 EF 50 C1 B7 EE 00 0A 8D ED 00 0A ?? ?? ?? ?? 01 20 20 EF 50 81 B9 FF 4E E7 ?? ?? ?? ?? 6E FF 4C AE 60 FF 4A 08 6A EF FA C1 50 FF DA C1 68 EF 4E 0D 61 4B 4E FF 5E 2D 5E 4A 40 FF DC 0D 6A EF FA 81 50 FF F2 81 03 92 1C EE 90 1B FB FF E8 25 3C EE 90 0B 42 FF F2 0D 1D EE 90 4B 68 EF F0 0F 3D EE 90 5B 42 FF F0 2D 42 FF F2 0D 68 EF F0 0F 42 FF F0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D F9 FF E0 07 40 EF E0 0D 50 FF DE A1 D3 EC 04 0B 45 4B 40 FF F8 2D D3 EC 04 0B 42 4B 42 EF E0 0D 40 FF F8 6D D3 EC 04 0B 3D 4B 48 EF E0 0D 40 FF F8 2D D3 EC 04 0B 39 4B 42 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4A FF F0 0D 4A EF E0 2D D3 EC 04 0B 2D 4B 60 FF CE 6E 02 93 02 AB 53 F8 21 30 5A FF F2 61 04 93 02 AB 53 F8 20 30 0D F1 40 0C 9C EC 04 AB 9D ED 00 0A 05 93 02 AB 53 F8 24 30 06 93 02 AB 53 F8 25 30 03 92 07 93 00 23 02 93 02 AB 53 F8 21 30 0D F1 10 0C DC EC 04 2B 08 93 02 AB 53 F8 20 30 42 EF E6 0D 09 93 02 AB 53 F8 24 30 40 EF E2 4D 0A 93 02 AB 53 F8 25 30 0B 93 0D F1 20 0C DC EC 04 2B 62 EF E6 0D 40 EF E2 0D 0D F1 30 0C DC EC 04 2B 22 FF CA 8E 14 FF F0 81 ?? ?? ?? ?? 08 4B 6A FF 50 2E 0A EF 4A 0E D3 EC 04 0B 50 FF D8 21 12 FF DA 01 14 B0 BD EC 10 8B BD E8 30 88 FE DE ?? ?? ?? ?? DA 0F C9 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? DA 0F 49 3F ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_57_42_0 {
	meta:
		name = "?asin@?$VASin@M@@SA?AT__n128@@T2@@Z"
		size = 456
		refs = "001e ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0030 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 01a8 ?ind@?$VectorOp@M@@2T__n128@@B 01b0 ?eps@?$VASin@M@@0T__n128@@B 01b4 ?q0@?$VASin@M@@0T__n128@@B 01b8 ?q1@?$VASin@M@@0T__n128@@B 01bc ?p1@?$VASin@M@@0T__n128@@B 01c0 ?p2@?$VASin@M@@0T__n128@@B"
		altNames = "__vdecl_asinf4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 91 B0 20 EF 50 E1 9F ED 6C 0A 0D F1 30 0C 8C EC 04 EB ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 20 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A ?? ?? ?? ?? 20 EF 50 C1 B7 EE 00 0A 8D ED 00 0A ?? ?? ?? ?? 01 20 20 EF 50 81 B9 FF 4E E7 ?? ?? ?? ?? 6E FF 4C AE 60 FF 4A 08 6A EF FA C1 50 FF DA C1 68 EF 4E 0D 53 4B 4E FF 5E 2D 40 FF DC 0D 6A EF FA 81 50 FF F2 81 1C EE 90 2B FB FF E8 25 3C EE 90 1B 42 FF F2 0D 1D EE 90 0B 68 EF F0 0F 3D EE 90 4B 42 FF F0 2D 42 FF F2 0D 68 EF F0 0F 42 FF F0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D F9 FF E0 07 40 EF E0 0D 50 FF DE A1 D3 EC 04 0B 39 4B 40 FF F8 2D D3 EC 04 0B 36 4B 42 EF E0 0D 40 FF F8 6D D3 EC 04 0B 31 4B 48 EF E0 0D 40 FF F8 2D D3 EC 04 0B 2D 4B 42 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4A FF F0 0D 4A EF E0 2D D3 EC 04 0B 00 23 02 93 20 4B 60 FF CE 0E 03 93 02 AB 53 F8 22 30 5A FF F2 01 04 93 02 AB 53 F8 21 30 0D F1 20 0C DC EC 04 4B 0D F1 30 0C 9C EC 04 AB 05 93 02 AB 53 F8 20 30 9D ED 00 0A 24 FF CA 8E 06 93 02 AB 53 F8 24 30 07 93 0D F1 10 0C DC EC 04 2B 42 EF E0 0D 40 EF E2 2D F9 FF E2 07 10 FF F2 81 ?? ?? ?? ?? 07 4B 6A FF 50 2E 0A EF 4A 0E D3 EC 04 0B 50 FF D8 21 12 FF DA 01 11 B0 BD EC 10 8B BD E8 10 88 ?? ?? ?? ?? DA 0F 49 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_57_43_0 {
	meta:
		name = "?asin_check_special_case@?$VASin@M@@CA?AT__n128@@T2@T2@@Z"
		size = 60
		refs = "0016 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0038 ?ind@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 08 8B 20 EF 50 A1 B7 EE 00 0A 22 EF 52 81 ?? ?? ?? ?? 07 4B 6A FF 50 2E 0A EF 4A 0E D3 EC 04 0B 50 FF D8 21 12 FF DA 01 BD EC 08 8B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_44_0 {
	meta:
		name = "?asin_impl@?$VASin@M@@CA?AT__n128@@T2@AAT2@@Z"
		size = 280
		refs = "0016 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0034 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0104 ?eps@?$VASin@M@@0T__n128@@B 0108 ?q0@?$VASin@M@@0T__n128@@B 010c ?q1@?$VASin@M@@0T__n128@@B 0110 ?p1@?$VASin@M@@0T__n128@@B 0114 ?p2@?$VASin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 2D ED 10 8B 20 EF 50 81 B6 EE 00 0A 04 46 ?? ?? ?? ?? 20 EF 50 C1 B7 EE 00 0A ?? ?? ?? ?? B9 FF 48 87 01 20 28 FF 4C EE 20 EF 50 A1 ?? ?? ?? ?? 6E EF 5E 21 D4 EC 04 4B 6E EF 5E 81 60 FF 64 08 32 4B 50 FF F4 21 6A EF 48 0D C4 EC 04 2B 48 FF 58 2D 40 FF DC 0D 50 FF F2 81 FB FF E8 25 42 FF F2 0D 68 EF F0 0F 42 FF F0 2D 42 FF F2 0D 68 EF F0 0F 42 FF F0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D F9 FF E0 07 40 EF E0 0D 10 FF D8 E1 D3 EC 04 0B 1B 4B 40 FF F8 2D D3 EC 04 0B 17 4B 42 EF E0 0D 40 FF F8 6D D3 EC 04 0B 13 4B 48 EF E0 0D 40 FF F8 2D D3 EC 04 0B 0E 4B 42 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4E FF 70 0D 4E EF 60 2D D3 EC 04 0B 20 FF C8 0E 1E FF 72 01 BD EC 10 8B BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_49_0 {
	meta:
		name = "?create@?$VectorOp@M@@SA?AT__n128@@I@Z"
		size = 42
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 A0 EE 10 0B 87 EC 04 0B 06 E0 97 EC 04 0B 03 E0 07 F1 10 0C 9C EC 04 0B 09 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_57_50_0 {
	meta:
		name = "?filt$0@?0??create@?$VectorOp@M@@SA?AT__n128@@I@Z@4HA"
		size = 24
		altNames = "?filt$0@?0??create@?$VectorOp@M@@SA?AT__n128@@M@Z@4HA ?filt$0@?0??create@?$VectorOp@N@@SA?AT__n128@@I@Z@4HA ?filt$0@?0??create@?$VectorOp@N@@SA?AT__n128@@N@Z@4HA ?filt$0@?0??create@?$VectorOp@N@@SA?AT__n128@@_K@Z@4HA"
	strings:
		$1 = { 03 68 1A 68 03 4B 9A 42 01 D1 01 20 00 E0 00 20 70 47 FE DE 1D 00 00 C0 }
	condition:
		$1
}

rule file_57_51_0 {
	meta:
		name = "?create@?$VectorOp@M@@SA?AT__n128@@IIII@Z"
		size = 24
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B CD E9 00 01 CD E9 02 23 9D EC 04 0B BD E8 0F 88 }
	condition:
		$1
}

rule file_57_52_0 {
	meta:
		name = "?create@?$VectorOp@M@@SA?AT__n128@@M@Z"
		size = 42
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 B4 FF 40 0C 87 EC 04 0B 06 E0 97 EC 04 0B 03 E0 07 F1 10 0C 9C EC 04 0B 09 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_57_54_0 {
	meta:
		name = "?create@?$VectorOp@N@@SA?AT__n128@@I@Z"
		size = 48
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 00 23 43 EC 10 0B 20 EF 10 11 87 EC 04 0B 06 E0 97 EC 04 0B 03 E0 07 F1 10 0C 9C EC 04 0B 09 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_57_56_0 {
	meta:
		name = "?create@?$VectorOp@N@@SA?AT__n128@@N@Z"
		size = 58
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 87 ED 00 0B 7A 68 3B 68 42 EC 10 3B 20 EF 10 11 07 F1 10 0C 8C EC 04 0B 06 E0 07 F1 10 0C 9C EC 04 0B 01 E0 97 EC 04 0B 09 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_57_58_0 {
	meta:
		name = "?create@?$VectorOp@N@@SA?AT__n128@@_K@Z"
		size = 46
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 41 EC 10 0B 20 EF 10 11 87 EC 04 0B 06 E0 97 EC 04 0B 03 E0 07 F1 10 0C 9C EC 04 0B 09 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_57_60_0 {
	meta:
		name = "?div@?$VectorOp@M@@SA?AT__n128@@T2@0@Z"
		size = 34
	strings:
		$1 = { 2D E9 00 48 EB 46 FB FF 42 25 42 EF 72 0F 42 FF F0 2D 42 EF 72 0F 42 FF F0 0D 00 FF 70 0D BD E8 00 88 }
	condition:
		$1
}

rule file_57_64_0 {
	meta:
		name = "?recip@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 FB FF 40 25 40 EF 72 0F 42 FF F0 2D 40 EF 72 0F 02 FF F0 0D BD E8 00 88 }
	condition:
		$1
}

rule file_57_65_0 {
	meta:
		name = "?sqrt@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 58
	strings:
		$1 = { 2D E9 00 48 EB 46 FB FF C0 25 42 FF F2 0D 60 EF 70 0F 42 FF F0 2D 42 FF F2 0D 60 EF 70 0F 42 FF F0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 02 FF F0 0D BD E8 00 88 }
	condition:
		$1
}

rule file_57_67_0 {
	meta:
		name = "?unpack@?$VectorOp@M@@SAXT__n128@@AAI111@Z"
		size = 36
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 10 EE 10 4B 04 60 30 EE 10 0B 08 60 11 EE 10 1B 11 60 31 EE 10 2B 1A 60 BD E8 18 88 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "??_L@YAXPAXIHP6AX0@Z1@Z"
		size = 36
		refs = "0016 ??_L@YAXPAXIIP6AX0@Z1@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 08 9B 00 93 07 9B 06 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "??_N@YAXPAXIHP6AX0@Z1@Z"
		size = 36
		refs = "0016 ??_N@YAXPAXIIP6AX0@Z1@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 08 9B 00 93 07 9B 06 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_58_1_0 {
	meta:
		name = "??_L@YAXPAXIIP6AX0@Z1@Z"
		size = 98
		refs = "002e _guard_check_icall 0054 ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 90 48 0D F1 08 0B 84 B0 6F 46 00 23 7B 60 00 23 3B 70 02 E0 7B 68 5B 1C 7B 60 7A 68 BB 6A 9A 42 0D D0 3C 6A FB 6A BB 60 B8 68 ?? ?? ?? ?? BB 68 20 46 98 47 3A 6A 7B 6A 13 44 3B 62 EA E7 01 23 3B 70 3B 78 00 2B 05 D1 3B 6B 7A 68 79 6A 38 6A ?? ?? ?? ?? 04 B0 BD E8 90 08 5D F8 14 FB }
	condition:
		$1
}

rule file_58_2_0 {
	meta:
		name = "?fin$0@?0???_L@YAXPAXIIP6AX0@Z1@Z@4HA"
		size = 24
		refs = "0010 ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
		altNames = "?fin$0@?0???_N@YAXPAXIIP6AX0@Z1@Z@4HA"
	strings:
		$1 = { 10 B5 3B 78 00 2B 05 D1 3B 6B 7A 68 79 6A 38 6A ?? ?? ?? ?? FF E7 10 BD }
	condition:
		$1
}

rule file_65_1_0 {
	meta:
		name = "??_N@YAXPAXIIP6AX0@Z1@Z"
		size = 102
		refs = "0030 _guard_check_icall 0058 ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 B0 48 0D F1 0C 0B 83 B0 6F 46 00 23 7B 60 00 23 3B 70 02 E0 7B 68 5B 1C 7B 60 7A 68 BB 6A 9A 42 0F D0 01 25 3C 6A FB 6A BB 60 B8 68 ?? ?? ?? ?? BB 68 20 46 29 46 98 47 3A 6A 7B 6A 13 44 3B 62 E8 E7 01 23 3B 70 3B 78 00 2B 05 D1 3B 6B 7A 68 79 6A 38 6A ?? ?? ?? ?? 03 B0 BD E8 B0 08 5D F8 14 FB }
	condition:
		$1
}

rule file_66_14_0 {
	meta:
		name = "??__E?p0@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p0@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? C6 E2 52 BF }
	condition:
		$1
}

rule file_66_15_0 {
	meta:
		name = "??__E?p0@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p0@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1F B2 B0 C9 A5 35 99 C0 }
	condition:
		$1
}

rule file_66_16_0 {
	meta:
		name = "??__E?p1@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B2 11 7B BB }
	condition:
		$1
}

rule file_66_17_0 {
	meta:
		name = "??__E?p1@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CC 5C BA A1 75 CE 58 C0 }
	condition:
		$1
}

rule file_66_19_0 {
	meta:
		name = "??__E?p2@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7F A7 FB CE 28 DC EE BF }
	condition:
		$1
}

rule file_66_20_0 {
	meta:
		name = "??__E?q0@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1A 2A 1E 40 }
	condition:
		$1
}

rule file_66_21_0 {
	meta:
		name = "??__E?q0@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 93 96 4E 57 3C E8 B2 40 }
	condition:
		$1
}

rule file_66_23_0 {
	meta:
		name = "??__E?q1@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F3 F0 01 4D 8B 73 A1 40 }
	condition:
		$1
}

rule file_66_25_0 {
	meta:
		name = "??__E?q2@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? FA F7 EB E1 A9 2F 5C 40 }
	condition:
		$1
}

rule file_66_28_0 {
	meta:
		name = "??__E?xbig@?$VTanh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?xbig@?$VTanh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B3 2C 10 41 }
	condition:
		$1
}

rule file_66_29_0 {
	meta:
		name = "??__E?xbig@?$VTanh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?xbig@?$VTanh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 A0 C1 0F 33 40 }
	condition:
		$1
}

rule file_66_53_0 {
	meta:
		name = "?signof@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 34
		refs = "0012 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 4F F0 00 40 20 EF 50 81 ?? ?? ?? ?? 00 EF 58 01 BD EC 04 8B BD E8 00 88 }
	condition:
		$1
}

rule file_66_55_0 {
	meta:
		name = "?tanh@?$VTanh@M@@SA?AT__n128@@T2@@Z"
		size = 336
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0054 __vdecl_expf4 00fe ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0130 ?inf@?$VectorOp@M@@2T__n128@@B 0134 ?eps@?$VTanh@M@@0T__n128@@B 0138 ?xbig@?$VTanh@M@@0T__n128@@B 013c ?q0@?$VTanh@M@@0T__n128@@B 0140 ?p0@?$VTanh@M@@0T__n128@@B 0144 ?p1@?$VTanh@M@@0T__n128@@B"
		altNames = "__vdecl_tanhf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 88 B0 20 EF 50 E1 9F ED 4E 0A 0D F1 10 0C 8C EC 04 EB ?? ?? ?? ?? 20 EF 50 C1 B7 EE 00 0A ?? ?? ?? ?? 60 EF 50 01 B6 EE 00 0A CD EC 04 0B ?? ?? ?? ?? 20 EF 50 81 9F ED 41 0A ?? ?? ?? ?? B9 FF 4E E7 20 EF 50 A1 0E EF 4E 0D ?? ?? ?? ?? DD EC 04 AB 39 4B 4F F0 00 40 40 EF 6A 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 4E FF 5E 4D 42 FF F0 0D 68 EF 60 0D 40 EF E0 8D D3 EC 04 0B 2D 4B 40 FF F4 2D D3 EC 04 0B 29 4B 42 EF E0 0D 40 FF F4 6D D3 EC 04 0B 25 4B 44 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 6E FF 4A 2E 46 FF F0 0D 0D F1 10 0C 9C EC 04 AB 2C FF 4A 8E 4E FF 70 0D 4E EF 60 0D 58 FF F0 21 D3 EC 04 0B 14 4B 6E FF 60 4E D3 EC 04 0B 5A FF F2 41 60 FF CE 2E 5E FF 74 21 F9 FF E2 07 10 FF F2 81 ?? ?? ?? ?? DD EC 04 2B 0A 4B 40 EF 5A 01 0A EF 4A 0E 60 EF F2 21 D3 EC 04 0B 4E EF 60 0E 52 FF D8 01 10 FF DA 01 08 B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 54 9F 0C 3F 00 00 00 00 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__GSHandlerCheck_SEH"
		size = 104
		refs = "0046 __GSHandlerCheckCommon 0052 __C_specific_handler"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 09 9B 1C 33 1B 68 00 93 00 9B 1B 68 13 F0 00 4F 08 D0 09 9B 19 1D 00 9B 1B 68 23 F0 00 42 0B 68 13 44 00 93 00 9B 19 1D 00 9B 1A 68 10 23 02 FB 03 F3 0B 44 01 93 01 9A 09 99 07 98 ?? ?? ?? ?? 09 9B 08 9A 07 99 06 98 ?? ?? ?? ?? 02 90 02 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "??_U@YAPAXIABUnothrow_t@std@@@Z"
		size = 36
		refs = "000e ??2@YAPAXIABUnothrow_t@std@@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_79_185_1 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@1@@Z"
		size = 36
		refs = "000e ??G?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAHABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_531_3 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@1@@Z"
		size = 36
		refs = "000e ??G?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAHABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_534_3 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@1@@Z"
		size = 36
		refs = "000e ??G?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAHABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_47_144_3 {
	meta:
		name = "??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV01@ABV01@@Z"
		size = 36
		refs = "000e ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_544_3 {
	meta:
		name = "??Y?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV01@ABV01@@Z"
		size = 36
		refs = "000e ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_499_2 {
	meta:
		name = "??Y?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV01@ABV01@@Z"
		size = 36
		refs = "000e ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_82_129_2 {
	meta:
		name = "?allocate@?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@QAAPAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@2@I@Z"
		size = 36
		refs = "000e ?allocate@?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@QBAPAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@I@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_88_145_2 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAPADI@Z"
		size = 36
		refs = "000e ?allocate@?$allocator@D@std@@QAAPADI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_1071_3 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAPAGI@Z"
		size = 36
		refs = "000e ?allocate@?$allocator@G@std@@QAAPAGI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_95_454_3 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAAPAU_Container_proxy@2@I@Z"
		size = 36
		refs = "000e ?allocate@?$allocator@U_Container_proxy@std@@@std@@QAAPAU_Container_proxy@2@I@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_72_1 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAPA_WI@Z"
		size = 36
		refs = "000e ?allocate@?$allocator@_W@std@@QAAPA_WI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_65_158_3 {
	meta:
		name = "_Lstat"
		size = 36
		refs = "000e _Stat"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "?DebuggerProbe@@YAHK@Z"
		size = 68
		refs = "0026 __imp_RaiseException"
	strings:
		$1 = { 2D E9 90 48 0D F1 08 0B 88 B0 6F 46 00 23 3B 70 41 F2 01 03 BB 60 F8 60 3B 46 3B 61 17 F1 08 03 06 22 00 21 06 48 ?? ?? ?? ?? C0 F2 00 04 24 68 A0 47 38 78 00 E0 78 68 08 B0 BD E8 90 88 FE DE 88 13 6D 40 }
	condition:
		$1
}

rule file_71_2_0 {
	meta:
		name = "?filt$0@?0??DebuggerProbe@@YAHK@Z@4HA"
		size = 24
		altNames = "?filt$0@?0??DebuggerRuntime@@YAHKHPAXPB_W@Z@4HA"
	strings:
		$1 = { 03 68 1A 68 03 4B 9A 42 01 D1 01 20 00 E0 00 20 70 47 FE DE 88 13 6D 40 }
	condition:
		$1
}

rule file_71_3_0 {
	meta:
		name = "?DebuggerRuntime@@YAHKHPAXPB_W@Z"
		size = 72
		refs = "002c __imp_RaiseException"
	strings:
		$1 = { 2D E9 90 48 0D F1 08 0B 88 B0 6F 46 00 24 3C 70 41 F2 02 04 BC 60 F8 60 39 61 7A 61 3A 46 BA 61 FB 61 17 F1 08 03 06 22 00 21 06 48 ?? ?? ?? ?? C0 F2 00 04 24 68 A0 47 38 78 00 E0 78 68 08 B0 BD E8 90 88 88 13 6D 40 }
	condition:
		$1
}

rule file_71_5_0 {
	meta:
		name = "?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
		size = 220
		refs = "0008 __security_push_cookie 000e ?_RTC_ErrorLevels@@3PAHA 0024 ??_C@_0EJ@LJKNEOLN@Stack?5area?5around?5_alloca?5memory@ 002e ??_C@_08OMAHNMHJ@?6Data?3?5?$DM?$AA@ 0038 ??_C@_0BC@HHMKLAND@?$CFs?$CFs?$CFp?$CFs?$CFzd?$CFs?$CFd?$CFs?$AA@ 0042 ??_C@_0CK@DKGBICFE@?6Allocation?5number?5within?5this?5f@ 005c ??_C@_07DFDJCKFN@?6Size?3?5?$AA@ 0066 ??_C@_0N@MHFFIMFG@?6Address?3?50x?$AA@ 0070 ??_C@_0EI@CLEPFNGI@Stack?5area?5around?5_alloca?5memory@ 0078 sprintf_s 0086 ?_getMemBlockDataString@@YAXPAD00I@Z 008c ?_strlen_priv@@YAIPBD@Z 0098 ??_C@_01EEMJAFIK@?6?$AA@ 00a0 ??_C@_08KJEDNCKC@?$CFs?$CFs?$CFs?$CFs?$AA@ 00b2 ??_C@_02LLMPMKNF@?$DO?5?$AA@ 00ce ?failwithmessage@@YAXPAXHHPBD@Z 00d4 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? D9 B0 ?? ?? ?? ?? C0 F2 00 03 0E 46 07 46 1D 69 B5 F1 FF 3F 57 D0 26 B9 ?? ?? ?? ?? C0 F2 00 03 4C E0 ?? ?? ?? ?? C0 F2 00 03 05 92 ?? ?? ?? ?? C0 F2 00 02 06 93 ?? ?? ?? ?? C0 F2 00 03 06 F1 20 04 1C A8 04 93 F3 68 F4 21 01 94 24 3B 03 93 ?? ?? ?? ?? C0 F2 00 03 02 93 ?? ?? ?? ?? C0 F2 00 03 00 93 ?? ?? ?? ?? C0 F2 00 03 ?? ?? ?? ?? F3 68 0E A9 08 A8 24 3B 22 46 ?? ?? ?? ?? 1C A8 ?? ?? ?? ?? 04 46 1C A8 ?? ?? ?? ?? ?? ?? ?? ?? C0 F2 00 03 ?? ?? ?? ?? C0 F2 00 02 C4 F1 F4 01 02 93 0E AB 01 93 ?? ?? ?? ?? C0 F2 00 03 1C AC 20 44 00 93 08 AB ?? ?? ?? ?? 1C AB 04 22 29 46 38 46 ?? ?? ?? ?? 59 B0 ?? ?? ?? ?? BD E8 F0 88 }
	condition:
		$1
}

rule file_71_6_0 {
	meta:
		name = "?_RTC_Failure@@YAXPAXH@Z"
		size = 80
		refs = "000c ?_RTC_ErrorLevels@@3PAHA 0018 ?_RTC_ErrorMessages@@3QBQBDB 002e ?failwithmessage@@YAXPAXHHPBD@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 29 14 D8 ?? ?? ?? ?? C0 F2 00 03 53 F8 21 40 ?? ?? ?? ?? C0 F2 00 03 B4 F1 FF 3F 53 F8 21 30 10 D0 0A 46 21 46 ?? ?? ?? ?? BD E8 18 88 ?? ?? ?? ?? C0 F2 00 03 01 24 05 21 5B 69 0A 46 21 46 ?? ?? ?? ?? BD E8 18 88 }
	condition:
		$1
}

rule file_71_7_0 {
	meta:
		name = "?_RTC_StackFailure@@YAXPAXPBD@Z"
		size = 160
		refs = "0008 __security_push_cookie 0010 ?_RTC_ErrorLevels@@3PAHA 002c ?_strlen_priv@@YAIPBD@Z 003a ?stack_premsg@@3QBDB 0048 strcpy 0080 ??_C@_0CG@IAFNJNEE@Stack?5corrupted?5near?5unknown?5var@ 0090 ?failwithmessage@@YAXPAXHHPBD@Z 0098 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? AD F5 80 6D ?? ?? ?? ?? C0 F2 00 03 0C 46 80 46 9F 68 B7 F1 FF 3F 37 D0 91 F9 00 30 53 B3 08 46 ?? ?? ?? ?? 00 F1 2D 03 B3 F5 80 6F 22 D8 ?? ?? ?? ?? C0 F2 00 05 68 46 6E 46 29 46 ?? ?? ?? ?? 68 46 42 1E 12 F8 01 3F 00 2B FB D1 14 F8 01 3B 00 2B 02 F8 01 3B F9 D1 05 F1 1C 01 42 1E 12 F8 01 3F 00 2B FB D1 11 F8 01 3B 00 2B 02 F8 01 3B F9 D1 03 E0 ?? ?? ?? ?? C0 F2 00 06 33 46 02 22 39 46 40 46 ?? ?? ?? ?? 0D F5 80 6D ?? ?? ?? ?? BD E8 F0 89 }
	condition:
		$1
}

rule file_71_8_0 {
	meta:
		name = "?_getMemBlockDataString@@YAXPAD00I@Z"
		size = 100
		refs = "002e ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 003c sprintf_s"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 1E 46 00 25 13 1A CD E9 00 30 9A 46 02 91 07 46 88 46 4F F0 31 09 10 2E 32 46 28 BF 10 22 95 42 12 D2 1A F8 07 40 ?? ?? ?? ?? C0 F2 00 02 49 46 23 46 40 46 ?? ?? ?? ?? 07 F8 01 4B 6D 1C A9 F1 03 09 08 F1 03 08 E6 E7 DD E9 01 A2 00 21 05 EB 45 03 05 F8 0A 10 99 54 BD E8 FE 8F }
	condition:
		$1
}

rule file_71_9_0 {
	meta:
		name = "?_strlen_priv@@YAIPBD@Z"
		size = 24
	strings:
		$1 = { 2D E9 00 48 EB 46 02 46 12 F9 01 3B 00 2B FB D1 13 1A 58 1E BD E8 00 88 }
	condition:
		$1
}

rule file_71_10_0 {
	meta:
		name = "?failwithmessage@@YAXPAXHHPBD@Z"
		size = 408
		refs = "0008 __security_push_cookie 001c ?_RTC_GetErrorFuncW@@YAP6AHHPB_WH00ZZPBX@Z 0026 ?_RTC_GetErrorFunc@@YAP6AHHPBDH00ZZPBX@Z 002c __imp_MultiByteToWideChar 0076 ??_C@_1GM@OLMCBDMB@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?4?$AA?6?$AA?$AN?$AA?5?$AAU?$AAn?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAt?$AAo@ 0082 ?DebuggerProbe@@YAHK@Z 0088 ?_RTC_NoFalsePositives@@3QBHB 009a ?DebuggerRuntime@@YAHKHPAXPB_W@Z 00b0 __imp_IsDebuggerPresent 00d0 ?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z 00d6 ??_C@_1EA@NFKNIFJP@?$AAR?$AAu?$AAn?$AA?9?$AAT?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAu?$AAr?$AAe?$AA?5?$AA?$CD?$AA?$CF?$AAd?$AA?5?$AA?9?$AA?5?$AA?$CF?$AAs?$AA?$AA@ 00e8 _guard_check_icall 00f8 __imp_WideCharToMultiByte 0108 ??_C@_0BB@PFFGGCJP@Unknown?5Filename?$AA@ 0140 ??_C@_0BE@GNBOBNCK@Unknown?5Module?5Name?$AA@ 0164 ??_C@_0CA@IODNCDPG@Run?9Time?5Check?5Failure?5?$CD?$CFd?5?9?5?$CFs?$AA@ 0190 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? AD F6 48 6D 9A 46 91 46 88 46 05 91 06 46 00 27 ?? ?? ?? ?? 05 46 1D B9 30 46 ?? ?? ?? ?? 07 46 ?? ?? ?? ?? C0 F2 00 04 00 23 01 93 24 68 00 93 DB 43 52 46 00 21 4F F6 E9 50 A0 47 B0 F5 00 7F 13 D2 ?? ?? ?? ?? C0 F2 00 04 0D F6 48 23 01 90 24 68 00 93 6F F0 00 03 52 46 00 21 4F F6 E9 50 A0 47 10 B1 0D F6 48 24 03 E0 ?? ?? ?? ?? C0 F2 00 04 41 F2 02 00 ?? ?? ?? ?? 70 B1 ?? ?? ?? ?? C0 F2 00 03 32 46 48 46 53 F8 29 10 23 46 ?? ?? ?? ?? 00 28 74 D1 00 23 00 E0 01 23 0F B9 00 2D 6D D0 3B B1 ?? ?? ?? ?? C0 F2 00 03 1B 68 98 47 00 28 64 D1 88 AB 00 93 4F F4 82 72 04 AB 06 A9 30 1F 01 92 ?? ?? ?? ?? 85 B1 ?? ?? ?? ?? C0 F2 00 03 28 46 02 94 00 93 CD F8 04 90 ?? ?? ?? ?? 04 9A 06 A9 40 46 88 AB A8 47 46 E0 ?? ?? ?? ?? C0 F2 00 04 00 23 0D F5 85 62 24 68 ?? ?? ?? ?? C0 F2 00 06 03 93 02 93 40 F2 0A 38 00 92 DB 43 06 AA 00 21 4F F6 E9 50 CD F8 04 80 A0 47 08 B1 0D F5 85 66 ?? ?? ?? ?? C0 F2 00 04 00 23 0D F5 E7 62 24 68 ?? ?? ?? ?? C0 F2 00 05 03 93 02 93 00 92 DB 43 88 AA 00 21 4F F6 E9 50 CD F8 04 80 A0 47 08 B1 0D F5 E7 65 ?? ?? ?? ?? C0 F2 00 02 38 46 CD F8 08 A0 00 92 CD F8 04 90 ?? ?? ?? ?? DD E9 04 20 31 46 2B 46 B8 47 01 28 00 D1 FE DE 0D F6 48 6D ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_71_11_0 {
	meta:
		name = "_RTC_UninitUse"
		size = 154
		refs = "0008 __security_push_cookie 0010 ?_RTC_ErrorLevels@@3PAHA 0024 ?_strlen_priv@@YAIPBD@Z 0032 ?uninit_premsg@@3QBDB 0040 strcpy 0078 ??_C@_0DE@OHJBPMBP@A?5variable?5is?5being?5used?5without@ 008a ?failwithmessage@@YAXPAXHHPBD@Z 0092 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? AD F2 04 4D ?? ?? ?? ?? C0 F2 00 03 04 46 DF 68 B7 F1 FF 3F 35 D0 4C B3 ?? ?? ?? ?? 00 F1 3A 03 B3 F5 80 6F 22 D8 ?? ?? ?? ?? C0 F2 00 05 68 46 6E 46 29 46 ?? ?? ?? ?? 68 46 42 1E 12 F8 01 3F 00 2B FB D1 14 F8 01 3B 00 2B 02 F8 01 3B F9 D1 05 F1 10 01 42 1E 12 F8 01 3F 00 2B FB D1 11 F8 01 3B 00 2B 02 F8 01 3B F9 D1 03 E0 ?? ?? ?? ?? C0 F2 00 06 DD F8 1C 04 33 46 03 22 39 46 ?? ?? ?? ?? 0D F2 04 4D ?? ?? ?? ?? BD E8 F0 88 }
	condition:
		$1
}

rule file_71_12_0 {
	meta:
		name = "__local_stdio_printf_options"
		size = 18
		refs = "0006 ?_OptionsStorage@?1??__local_stdio_printf_options@@9@4_KA"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? C0 F2 00 00 BD E8 00 88 }
	condition:
		$1
}

rule file_47_158_3 {
	meta:
		name = "??__E?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_32_2 {
	meta:
		name = "??__E?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_33_2 {
	meta:
		name = "??__E?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_253_2 {
	meta:
		name = "??__E?id@?$collate@D@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$collate@D@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_588_3 {
	meta:
		name = "??__E?id@?$collate@G@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$collate@G@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_542_2 {
	meta:
		name = "??__E?id@?$collate@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$collate@_W@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_34_3 {
	meta:
		name = "??__E?id@?$ctype@D@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$ctype@D@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_35_2 {
	meta:
		name = "??__E?id@?$ctype@G@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$ctype@G@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_36_1 {
	meta:
		name = "??__E?id@?$ctype@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$ctype@_W@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_211_1 {
	meta:
		name = "??__E?id@?$messages@D@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$messages@D@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_543_2 {
	meta:
		name = "??__E?id@?$messages@G@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$messages@G@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_544_2 {
	meta:
		name = "??__E?id@?$messages@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$messages@_W@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_255_2 {
	meta:
		name = "??__E?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_545_2 {
	meta:
		name = "??__E?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_546_2 {
	meta:
		name = "??__E?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_256_2 {
	meta:
		name = "??__E?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_594_3 {
	meta:
		name = "??__E?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_595_3 {
	meta:
		name = "??__E?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_272_3 {
	meta:
		name = "??__E?id@?$moneypunct@D$00@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$moneypunct@D$00@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_273_3 {
	meta:
		name = "??__E?id@?$moneypunct@D$0A@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$moneypunct@D$0A@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_549_2 {
	meta:
		name = "??__E?id@?$moneypunct@G$00@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$moneypunct@G$00@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_550_2 {
	meta:
		name = "??__E?id@?$moneypunct@G$0A@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$moneypunct@G$0A@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_598_3 {
	meta:
		name = "??__E?id@?$moneypunct@_W$00@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$moneypunct@_W$00@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_476_1 {
	meta:
		name = "??__E?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_132_1 {
	meta:
		name = "??__E?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_477_1 {
	meta:
		name = "??__E?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_554_2 {
	meta:
		name = "??__E?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_150_2 {
	meta:
		name = "??__E?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_479_1 {
	meta:
		name = "??__E?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_603_3 {
	meta:
		name = "??__E?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_134_1 {
	meta:
		name = "??__E?id@?$numpunct@D@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$numpunct@D@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_604_3 {
	meta:
		name = "??__E?id@?$numpunct@G@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$numpunct@G@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_605_3 {
	meta:
		name = "??__E?id@?$numpunct@_W@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$numpunct@_W@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_259_2 {
	meta:
		name = "??__E?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_483_1 {
	meta:
		name = "??__E?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_560_2 {
	meta:
		name = "??__E?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_260_2 {
	meta:
		name = "??__E?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_608_3 {
	meta:
		name = "??__E?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_609_3 {
	meta:
		name = "??__E?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A@@YAXXZ"
		size = 24
		refs = "000a ??0id@locale@std@@QAA@I@Z 0014 ?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_146_0_7 {
	meta:
		name = "_CRT_RTC_INIT"
		size = 18
		refs = "0006 _CrtDbgReport"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? C0 F2 00 00 BD E8 00 88 }
	condition:
		$1
}

rule file_146_1_7 {
	meta:
		name = "_CRT_RTC_INITW"
		size = 18
		refs = "0006 _CrtDbgReportW"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? C0 F2 00 00 BD E8 00 88 }
	condition:
		$1
}

rule file_71_13_0 {
	meta:
		name = "_vsprintf_s_l"
		size = 62
		refs = "0010 __local_stdio_printf_options 0026 __stdio_common_vsprintf_s"
	strings:
		$1 = { 2D E9 FF 4B 0D F1 28 0B 1E 46 17 46 88 46 81 46 ?? ?? ?? ?? 0C 9C 05 46 D5 E9 00 01 43 46 4A 46 02 94 01 96 00 97 ?? ?? ?? ?? 00 28 04 DA 6F F0 00 00 04 B0 BD E8 F0 8B 04 B0 BD E8 F0 8B }
	condition:
		$1
}

rule file_71_14_0 {
	meta:
		name = "sprintf_s"
		size = 42
		refs = "000e ??$__vcrt_va_start_verify_argument_type@QBD@@YAXXZ 001e _vsprintf_s_l"
	strings:
		$1 = { 0F B4 2D E9 3C 48 0D F1 10 0B 0C 46 05 46 ?? ?? ?? ?? 08 9A 09 AB 00 93 00 23 21 46 28 46 ?? ?? ?? ?? BD E8 3C 08 5D F8 14 FB }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__GSHandlerCheck_EH"
		size = 60
		refs = "001a __GSHandlerCheckCommon 0026 __CxxFrameHandler3"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 09 9B 1C 33 1B 68 1B 1D 00 93 00 9A 09 99 07 98 ?? ?? ?? ?? 09 9B 08 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "__rt_udiv"
		size = 360
		refs = "001e _lc009_002361_"
	strings:
		$1 = { 80 B1 02 46 B0 FA 80 F0 B1 FA 81 F3 C0 1A 0F F2 4D 13 A3 EB C0 03 A3 EB 40 03 4F F0 00 00 ?? ?? ?? ?? 18 47 F9 DE B1 EB C2 73 28 BF 19 46 40 41 B1 EB 82 73 28 BF 19 46 40 41 B1 EB 42 73 28 BF 19 46 40 41 B1 EB 02 73 28 BF 19 46 40 41 B1 EB C2 63 28 BF 19 46 40 41 B1 EB 82 63 28 BF 19 46 40 41 B1 EB 42 63 28 BF 19 46 40 41 B1 EB 02 63 28 BF 19 46 40 41 B1 EB C2 53 28 BF 19 46 40 41 B1 EB 82 53 28 BF 19 46 40 41 B1 EB 42 53 28 BF 19 46 40 41 B1 EB 02 53 28 BF 19 46 40 41 B1 EB C2 43 28 BF 19 46 40 41 B1 EB 82 43 28 BF 19 46 40 41 B1 EB 42 43 28 BF 19 46 40 41 B1 EB 02 43 28 BF 19 46 40 41 B1 EB C2 33 28 BF 19 46 40 41 B1 EB 82 33 28 BF 19 46 40 41 B1 EB 42 33 28 BF 19 46 40 41 B1 EB 02 33 28 BF 19 46 40 41 B1 EB C2 23 28 BF 19 46 40 41 B1 EB 82 23 28 BF 19 46 40 41 B1 EB 42 23 28 BF 19 46 40 41 B1 EB 02 23 28 BF 19 46 40 41 B1 EB C2 13 28 BF 19 46 40 41 B1 EB 82 13 28 BF 19 46 40 41 B1 EB 42 13 28 BF 19 46 40 41 B1 EB 02 13 28 BF 19 46 40 41 B1 EB C2 03 28 BF 19 46 40 41 B1 EB 82 03 28 BF 19 46 40 41 B1 EB 42 03 28 BF 19 46 40 41 8B 1A 28 BF 19 46 40 41 70 47 00 00 }
	condition:
		$1
}

rule file_77_1_0 {
	meta:
		name = "__rt_sdiv"
		size = 388
		refs = "002e _lc009_002745_"
	strings:
		$1 = { 10 F0 00 43 48 BF 40 42 93 EA 21 0C 28 BF 49 42 80 B1 02 46 B0 FA 80 F0 B1 FA 81 F3 C0 1A 0F F2 4D 13 A3 EB C0 03 A3 EB 40 03 4F F0 00 00 ?? ?? ?? ?? 18 47 F9 DE B1 EB C2 73 28 BF 19 46 40 41 B1 EB 82 73 28 BF 19 46 40 41 B1 EB 42 73 28 BF 19 46 40 41 B1 EB 02 73 28 BF 19 46 40 41 B1 EB C2 63 28 BF 19 46 40 41 B1 EB 82 63 28 BF 19 46 40 41 B1 EB 42 63 28 BF 19 46 40 41 B1 EB 02 63 28 BF 19 46 40 41 B1 EB C2 53 28 BF 19 46 40 41 B1 EB 82 53 28 BF 19 46 40 41 B1 EB 42 53 28 BF 19 46 40 41 B1 EB 02 53 28 BF 19 46 40 41 B1 EB C2 43 28 BF 19 46 40 41 B1 EB 82 43 28 BF 19 46 40 41 B1 EB 42 43 28 BF 19 46 40 41 B1 EB 02 43 28 BF 19 46 40 41 B1 EB C2 33 28 BF 19 46 40 41 B1 EB 82 33 28 BF 19 46 40 41 B1 EB 42 33 28 BF 19 46 40 41 B1 EB 02 33 28 BF 19 46 40 41 B1 EB C2 23 28 BF 19 46 40 41 B1 EB 82 23 28 BF 19 46 40 41 B1 EB 42 23 28 BF 19 46 40 41 B1 EB 02 23 28 BF 19 46 40 41 B1 EB C2 13 28 BF 19 46 40 41 B1 EB 82 13 28 BF 19 46 40 41 B1 EB 42 13 28 BF 19 46 40 41 B1 EB 02 13 28 BF 19 46 40 41 B1 EB C2 03 28 BF 19 46 40 41 B1 EB 82 03 28 BF 19 46 40 41 B1 EB 42 03 28 BF 19 46 40 41 8B 1A 28 BF 19 46 40 41 5F EA 4C 0C 28 BF 40 42 48 BF 49 42 70 47 00 00 }
	condition:
		$1
}

rule file_77_2_0 {
	meta:
		name = "__rt_udiv64"
		size = 160
		refs = "008a __rt_udiv"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 50 EA 01 04 26 D0 51 EA 03 04 39 D0 06 46 8C 46 B3 FA 83 F1 13 B9 B2 FA 82 F1 20 31 BC F1 00 0F BC FA 8C F0 02 D1 B6 FA 86 F0 20 30 40 1A 2E DB 20 28 65 46 34 46 01 D3 35 46 00 24 10 F0 1F 00 85 40 D0 F1 20 01 34 FA 01 F1 84 40 0D 43 00 20 00 21 06 E0 F9 DE 64 08 00 18 44 EA C5 74 49 41 6D 08 9D 42 07 D8 01 D3 94 42 04 D8 12 1B AB 41 40 1C 51 F1 00 01 B4 42 ED D1 65 45 EB D1 08 E0 11 46 ?? ?? ?? ?? 0A 46 00 21 00 23 01 E0 00 21 00 20 BD E8 F0 88 00 00 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 54
		refs = "0018 ??2@YAPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 B8 6A ?? ?? ?? ?? 78 60 7B 68 3B 60 02 E0 01 E0 BB 68 3B 60 38 68 07 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_79_1_0 {
	meta:
		name = "__catch$??2@YAPAXIABUnothrow_t@std@@@Z$0"
		size = 20
		refs = "000c __tryend$??2@YAPAXIABUnothrow_t@std@@@Z$1 0010 $LN7"
	strings:
		$1 = { 00 23 BB 60 02 48 70 47 00 48 70 47 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__security_init_cookie"
		size = 188
		refs = "009c __security_cookie_complement 00a0 __security_cookie 00ac __imp_QueryPerformanceCounter 00b0 __imp_GetCurrentProcessId 00b4 __imp_GetCurrentThreadId 00b8 __imp_GetSystemTimeAsFileTime"
	strings:
		$1 = { 2D E9 00 48 EB 46 88 B0 00 23 04 93 00 23 05 93 23 4B 1A 68 24 4B 9A 42 05 D0 21 4B 1B 68 DA 43 1E 4B 1A 60 36 E0 04 A8 23 4B 1B 68 98 47 04 9B 00 93 00 9A 05 9B 53 40 00 93 1E 4B 1B 68 98 47 01 90 00 9A 01 9B 53 40 00 93 19 4B 1B 68 98 47 02 90 00 9A 02 9B 53 40 00 93 06 A8 13 4B 1B 68 98 47 00 9A 06 9B 53 40 00 93 00 9A 07 9B 53 40 00 93 00 9A 6B 46 53 40 00 93 00 9A 0A 4B 9A 42 01 D1 08 4B 00 93 00 9A 05 4B 1A 60 00 9B DA 43 02 4B 1A 60 08 B0 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? 4F E6 40 BB 4E E6 40 BB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__scrt_get_dyn_tls_dtor_callback"
		size = 24
		refs = "0014 __dyn_tls_dtor_callback"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 4B 00 93 00 98 02 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_74_3 {
	meta:
		name = "?_BadAllocException@__ExceptionPtr@@SAABV?$shared_ptr@V__ExceptionPtr@@@std@@XZ"
		size = 24
		refs = "0014 ?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 4B 00 93 00 98 02 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_122_3 {
	meta:
		name = "?_Init_cnt_func@Init@ios_base@std@@CAAAHXZ"
		size = 24
		refs = "0014 ?_Init_cnt@Init@ios_base@std@@0HA"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 4B 00 93 00 98 02 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_402_2 {
	meta:
		name = "__local_stdio_printf_options"
		size = 24
		refs = "0014 ?_OptionsStorage@?1??__local_stdio_printf_options@@9@4_KA"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 4B 00 93 00 98 02 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_339_1_7 {
	meta:
		name = "__local_stdio_scanf_options"
		size = 24
		refs = "0014 ?_OptionsStorage@?1??__local_stdio_scanf_options@@9@4_KA"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 4B 00 93 00 98 02 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_223_0_7 {
	meta:
		name = "__scrt_get_dyn_tls_init_callback"
		size = 24
		refs = "0014 __dyn_tls_init_callback"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 4B 00 93 00 98 02 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "??$cosh_impl@$00@?$VSinh@M@@CA?AT__n128@@T1@@Z"
		size = 168
		refs = "0026 __vdecl_expf4 0046 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0094 ?inf@?$VectorOp@M@@2T__n128@@B 0098 ?wmax@?$VSinh@M@@0T__n128@@B 009c ?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B 00a0 ?ln_v@?$VSinh@M@@0T__n128@@B 00a4 ?ybar@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 26 4B 20 EF 50 81 D3 EC 04 0B 22 4B 28 FF 60 EE D3 EC 04 0B 28 EF 60 CD 2C EF 5C 01 ?? ?? ?? ?? 1C 4B D3 EC 04 0B 40 FF D0 0D 00 EF 60 AD 28 EF 58 01 ?? ?? ?? ?? 01 20 20 EF 50 81 ?? ?? ?? ?? FB FF 48 25 12 4B 48 EF 72 0F 42 FF F0 2D 48 EF 72 0F 42 FF F0 0D 48 EF 60 2D F7 EF 50 05 62 FF E0 08 6E EF 5E 21 5A FF 70 21 D3 EC 04 0B 06 4B 6C FF 60 0E 0E EF 70 01 D3 EC 04 0B 10 FF F2 01 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_1_0 {
	meta:
		name = "??$cosh_impl@$0A@@?$VSinh@M@@CA?AT__n128@@T1@@Z"
		size = 168
		refs = "0026 __vdecl_expf4 0046 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0094 ?inf@?$VectorOp@M@@2T__n128@@B 0098 ?wmax@?$VSinh@M@@0T__n128@@B 009c ?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B 00a0 ?ln_v@?$VSinh@M@@0T__n128@@B 00a4 ?ybar@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 26 4B 20 EF 50 81 D3 EC 04 0B 22 4B 28 FF 60 EE D3 EC 04 0B 28 EF 60 CD 2C EF 5C 01 ?? ?? ?? ?? 1C 4B D3 EC 04 0B 40 FF D0 0D 00 EF 60 AD 28 EF 58 01 ?? ?? ?? ?? 01 20 20 EF 50 81 ?? ?? ?? ?? FB FF 48 25 12 4B 48 EF 72 0F 42 FF F0 2D 48 EF 72 0F 42 FF F0 0D 68 EF 60 2D F7 EF 50 05 62 FF E0 08 6E EF 5E 21 5A FF 70 21 D3 EC 04 0B 06 4B 6C FF 60 0E 0E EF 70 01 D3 EC 04 0B 10 FF F2 01 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_13_0 {
	meta:
		name = "??__E?ln_v@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?ln_v@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 73 31 3F }
	condition:
		$1
}

rule file_85_14_0 {
	meta:
		name = "??__E?ln_v@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?ln_v@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 60 2E E6 3F }
	condition:
		$1
}

rule file_85_19_0 {
	meta:
		name = "??__E?one_over_v_squared@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?one_over_v_squared@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 30 FE 7F 3E }
	condition:
		$1
}

rule file_85_20_0 {
	meta:
		name = "??__E?one_over_v_squared@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?one_over_v_squared@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 74 07 29 FE C5 FF CF 3F }
	condition:
		$1
}

rule file_85_21_0 {
	meta:
		name = "??__E?p0@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p0@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F0 69 E4 C0 }
	condition:
		$1
}

rule file_85_22_0 {
	meta:
		name = "??__E?p0@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p0@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 19 34 53 56 13 79 15 C1 }
	condition:
		$1
}

rule file_85_23_0 {
	meta:
		name = "??__E?p1@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? C2 E6 42 BE }
	condition:
		$1
}

rule file_85_24_0 {
	meta:
		name = "??__E?p1@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 90 14 94 B6 C2 95 C6 C0 }
	condition:
		$1
}

rule file_85_26_0 {
	meta:
		name = "??__E?p2@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 4A BE 85 63 41 78 64 C0 }
	condition:
		$1
}

rule file_85_28_0 {
	meta:
		name = "??__E?p3@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p3@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1B C8 6F B8 E7 44 E9 BF }
	condition:
		$1
}

rule file_85_29_0 {
	meta:
		name = "??__E?q0@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 93 4F 2B C2 }
	condition:
		$1
}

rule file_85_30_0 {
	meta:
		name = "??__E?q0@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 13 67 BE 80 CE 1A 40 C1 }
	condition:
		$1
}

rule file_85_32_0 {
	meta:
		name = "??__E?q1@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? C7 5E B6 23 57 A8 E1 40 }
	condition:
		$1
}

rule file_85_34_0 {
	meta:
		name = "??__E?q2@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F2 7F C9 81 C3 5B 71 C0 }
	condition:
		$1
}

rule file_85_37_0 {
	meta:
		name = "??__E?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 97 08 68 37 }
	condition:
		$1
}

rule file_85_38_0 {
	meta:
		name = "??__E?v_over_two_minus_1@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?v_over_two_minus_1@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D6 02 02 EB 12 01 ED 3E }
	condition:
		$1
}

rule file_85_39_0 {
	meta:
		name = "??__E?wmax@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?wmax@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7A 70 B1 42 }
	condition:
		$1
}

rule file_85_40_0 {
	meta:
		name = "??__E?wmax@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?wmax@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B1 BF EC 9E 3C 2E 86 40 }
	condition:
		$1
}

rule file_85_41_0 {
	meta:
		name = "??__E?ybar@?$VSinh@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?ybar@?$VSinh@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 18 72 B1 42 }
	condition:
		$1
}

rule file_200_5_0 {
	meta:
		name = "??__E?bigx@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?bigx@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 18 72 B1 42 }
	condition:
		$1
}

rule file_85_42_0 {
	meta:
		name = "??__E?ybar@?$VSinh@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?ybar@?$VSinh@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? EF 39 FA FE 42 2E 86 40 }
	condition:
		$1
}

rule file_200_6_0 {
	meta:
		name = "??__E?bigx@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?bigx@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? EF 39 FA FE 42 2E 86 40 }
	condition:
		$1
}

rule file_85_50_0 {
	meta:
		name = "?cosh@?$VSinh@M@@SA?AT__n128@@T2@@Z"
		size = 204
		refs = "0030 __vdecl_expf4 0050 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 00b8 ?inf@?$VectorOp@M@@2T__n128@@B 00bc ?wmax@?$VSinh@M@@0T__n128@@B 00c0 ?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B 00c4 ?ln_v@?$VSinh@M@@0T__n128@@B 00c8 ?ybar@?$VSinh@M@@0T__n128@@B"
		altNames = "__vdecl_coshf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 84 B0 2E 4B 60 EF 50 01 CD EC 04 0B B9 FF 60 87 D3 EC 04 0B 29 4B 28 FF 60 EE D3 EC 04 0B 28 EF 60 CD 2C EF 5C 01 ?? ?? ?? ?? 22 4B D3 EC 04 0B 40 FF D0 0D 00 EF 60 AD 28 EF 58 01 ?? ?? ?? ?? 01 20 20 EF 50 81 ?? ?? ?? ?? FB FF 48 25 18 4B 6E EF 5E 61 48 EF 72 0F 42 FF F0 2D 48 EF 72 0F 42 FF F0 0D 48 EF 60 2D F7 EF 50 05 62 FF E0 08 5A FF 70 61 D3 EC 04 0B 0D 4B 6C FF 60 0E D3 EC 04 4B 4E EF 70 21 54 FF F6 21 DD EC 04 6B 46 EF E6 0E 52 FF F6 01 F9 FF 66 27 02 EF E4 0E 14 FF F0 01 04 B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_67_0 {
	meta:
		name = "?sdx@?$VectorOp@M@@SA?AT__n128@@T2@0@Z"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 F7 EF 52 05 20 FF 60 08 BD E8 00 88 }
	condition:
		$1
}

rule file_85_68_0 {
	meta:
		name = "?sinh@?$VSinh@M@@SA?AT__n128@@T2@@Z"
		size = 384
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0058 __vdecl_expf4 0078 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0158 ?eps@?$VSinh@M@@0T__n128@@B 015c ?q0@?$VSinh@M@@0T__n128@@B 0160 ?p0@?$VSinh@M@@0T__n128@@B 0164 ?p1@?$VSinh@M@@0T__n128@@B 0168 ?inf@?$VectorOp@M@@2T__n128@@B 016c ?wmax@?$VSinh@M@@0T__n128@@B 0170 ?v_over_two_minus_1@?$VSinh@M@@0T__n128@@B 0174 ?ln_v@?$VSinh@M@@0T__n128@@B 0178 ?ybar@?$VSinh@M@@0T__n128@@B"
		altNames = "__vdecl_sinhf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 8C B0 20 EF 50 81 9F ED 5A 0A 0D F1 10 0C 8C EC 04 8B ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A CD EC 04 0B ?? ?? ?? ?? 51 4B 60 EF 50 01 0D F1 20 0C CC EC 04 0B D3 EC 04 0B 4C 4B B9 FF 48 87 28 FF 60 EE D3 EC 04 0B 28 EF 60 CD 2C EF 5C 01 ?? ?? ?? ?? 44 4B D3 EC 04 0B 40 FF D0 0D 00 EF 60 AD 28 EF 58 01 ?? ?? ?? ?? 01 20 20 EF 50 81 ?? ?? ?? ?? FB FF 48 25 3A 4B 6E EF 5E 41 48 EF 72 0F 0D F1 10 0C DC EC 04 EB 42 FF F0 2D 4E FF FE 8D 48 EF 72 0F 42 FF F0 0D 68 EF 60 2D F7 EF 50 05 62 FF E0 08 5A FF 70 41 D3 EC 04 0B 2C 4B 6C FF 60 0E D3 EC 04 CB 28 4B 4E EF 70 21 5C FF F4 21 DD EC 04 4B F9 FF E2 07 64 FF EE AE 50 FF F2 A1 D3 EC 04 0B 20 4B 40 FF F8 2D D3 EC 04 0B 1C 4B 42 EF E0 6D D3 EC 04 0B 19 4B 48 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F F9 FF 6E 47 42 FF F0 0D 04 EF EC 0E 46 FF F0 0D 48 FF F0 0D 4E FF F0 0D 4E EF E0 2D D3 EC 04 0B 60 FF E4 0E 5E FF F2 01 0D F1 20 0C DC EC 04 2B 64 FF E2 2E 5A FF F0 21 4E EF EE 0E 52 FF FE 01 1E FF F0 01 0C B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "_get_startup_argv_mode"
		size = 20
		altNames = "?get_app_type@__scrt_main_policy@@SA?AW4_crt_app_type@@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 01 23 00 93 00 98 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_93_3_0 {
	meta:
		name = "__stoi64"
		size = 248
		refs = "00a8 __fptoi64_exception_helper"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B B5 EE 40 0A F1 EE 10 FA 10 EE 10 0A 2A D0 C0 F3 C7 52 01 02 00 20 41 F0 00 41 4F F0 BE 03 D2 1A 23 DC 52 42 40 2A 4E DA 00 25 20 2A 03 DB 20 3A 05 46 08 46 00 21 D2 F1 20 03 10 FA 03 F4 25 43 D0 40 11 FA 03 F4 20 43 D1 40 B1 F1 00 4F 18 D8 29 D0 F1 EE 10 FA 02 DA 40 42 61 EB 41 01 35 BB BD E8 30 88 00 20 00 21 FA E7 20 2A 02 DB 20 3A 01 46 00 20 D2 F1 20 03 91 40 30 FA 03 F4 21 43 90 40 F1 EE 10 FA 02 DA 40 42 61 EB 41 01 F1 EE 10 3A 43 F0 04 03 03 EA 13 22 D2 06 E0 D0 11 4A ?? ?? ?? ?? DC E7 F1 EE 10 FA F0 DA D1 E7 F1 EE 10 3A 43 F0 01 03 03 EA 13 22 D2 06 D0 D0 0A 4A ?? ?? ?? ?? CC E7 00 20 00 21 F1 EE 10 3A 43 F0 02 03 03 EA 13 22 D2 06 C2 D0 04 4A ?? ?? ?? ?? BE E7 00 00 04 08 00 06 01 08 00 06 02 08 00 06 }
	condition:
		$1
}

rule file_93_4_0 {
	meta:
		name = "__stou64"
		size = 232
		refs = "00a2 __fptoi64_exception_helper"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B B5 EE 40 0A F1 EE 10 FA 10 EE 10 0A 27 D0 C0 F3 C7 52 01 02 00 20 41 F0 00 41 4F F0 BE 03 D2 1A 20 DC 52 42 40 2A 47 DA 00 25 20 2A 03 DB 20 3A 05 46 08 46 00 21 D2 F1 20 03 10 FA 03 F4 25 43 D0 40 11 FA 03 F4 20 43 D1 40 F1 EE 10 FA 03 DA 40 42 61 EB 41 01 17 E0 15 BB BD E8 30 88 00 20 00 21 FA E7 20 2A 02 DB 20 3A 01 46 00 20 D2 F1 20 03 91 40 30 FA 03 F4 21 43 90 40 F1 EE 10 FA 02 DA 40 42 61 EB 41 01 F1 EE 10 3A 43 F0 04 03 03 EA 13 22 D2 06 E0 D0 0E 4A ?? ?? ?? ?? DC E7 F1 EE 10 3A 43 F0 01 03 03 EA 13 22 D2 06 D4 D0 09 4A ?? ?? ?? ?? D0 E7 00 20 00 21 F1 EE 10 3A 43 F0 02 03 03 EA 13 22 D2 06 C6 D0 03 4A ?? ?? ?? ?? C2 E7 04 08 00 09 01 08 00 09 02 08 00 09 }
	condition:
		$1
}

rule file_93_5_0 {
	meta:
		name = "__fptoi64_exception_helper"
		size = 44
		refs = "0022 __fphelper_raise_exception"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 E1 EE 10 3A 8D ED 00 0B CD E9 02 01 D0 B2 C2 F3 07 21 C2 F3 07 63 C2 F3 07 42 ?? ?? ?? ?? 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_94_1_0 {
	meta:
		name = "__scrt_get_show_window_mode"
		size = 68
		refs = "000e memset 0040 __imp_GetStartupInfoW"
	strings:
		$1 = { 2D E9 00 48 EB 46 94 B0 44 22 00 21 02 A8 ?? ?? ?? ?? 02 A8 0A 4B 1B 68 98 47 0D 9B 13 F0 01 0F 03 D0 BD F8 38 30 00 93 01 E0 0A 23 00 93 00 9B 9B B2 AD F8 04 30 BD F8 04 00 14 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_3_0 {
	meta:
		name = "__scrt_is_managed_app"
		size = 172
		refs = "00a8 __imp_GetModuleHandleW"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 00 20 27 4B 1B 68 98 47 03 90 03 9B 01 93 01 9B 00 2B 03 D1 00 23 8D F8 00 30 3C E0 01 9B 1A 88 45 F6 4D 23 9A 42 03 D0 00 23 8D F8 00 30 32 E0 01 9B 3C 33 01 9A 1B 68 13 44 02 93 02 9B 1A 68 44 F2 50 53 9A 42 03 D0 00 23 8D F8 00 30 22 E0 02 9B 18 33 1A 88 40 F2 0B 13 9A 42 03 D0 00 23 8D F8 00 30 17 E0 02 9B 18 33 5C 33 1B 68 0E 2B 03 D8 00 23 8D F8 00 30 0D E0 02 9B 18 33 60 33 70 33 1B 68 00 2B 03 D1 00 23 8D F8 00 30 02 E0 01 23 8D F8 00 30 9D F8 00 00 04 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_5_0 {
	meta:
		name = "__scrt_unhandled_exception_filter"
		size = 124
		refs = "0054 terminate"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 68 00 93 00 9B 1A 68 18 4B 9A 42 1E D1 00 9B 10 33 1B 68 04 2B 19 D1 00 9B 14 33 1A 68 12 4B 9A 42 11 D0 00 9B 14 33 1A 68 0E 4B 9A 42 0B D0 00 9B 14 33 1A 68 0A 4B 9A 42 05 D0 00 9B 14 33 1A 68 06 4B 9A 42 01 D1 ?? ?? ?? ?? 00 23 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB 00 40 99 01 22 05 93 19 21 05 93 19 20 05 93 19 63 73 6D E0 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "_guard_check_icall"
		size = 24
		refs = "0014 __guard_check_icall_fptr"
	strings:
		$1 = { 03 B4 00 B5 81 B0 02 98 02 4B 1B 68 98 47 01 B0 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "_FindPESection"
		size = 126
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 3C 33 06 9A 1B 68 13 44 01 93 00 23 02 93 01 9B 03 F1 18 02 01 9B 14 33 1B 88 13 44 00 93 05 E0 02 9B 5B 1C 02 93 00 9B 28 33 00 93 01 9B 9B 1D 1A 88 02 9B 93 42 14 D2 00 9B 0C 33 07 9A 1B 68 9A 42 0D D3 00 9B 03 F1 0C 02 00 9B 08 33 12 68 1B 68 1A 44 07 9B 93 42 02 D2 00 9B 03 93 02 E0 DE E7 00 23 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_101_1_0 {
	meta:
		name = "_IsNonwritableInCurrentImage"
		size = 144
		refs = "0014 _ValidateImageBase 0036 _FindPESection 008c __ImageBase"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 8F B0 6F 46 1F 4B 7B 60 78 68 ?? ?? ?? ?? 78 61 7B 69 00 2B 04 D1 00 23 BB 61 BB 69 3B 60 29 E0 BA 6C 7B 68 D3 1A FB 61 F9 69 78 68 ?? ?? ?? ?? 38 62 3B 6A BB 60 BB 68 00 2B 04 D1 00 23 7B 62 7B 6A 3B 60 16 E0 BB 68 24 33 1B 68 13 F0 00 4F 02 D1 01 23 FB 60 01 E0 00 23 FB 60 FB 68 BB 62 BB 6A 3B 60 06 E0 05 E0 00 23 7B 63 7B 6B 3B 60 00 E0 FF E7 38 68 0F B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_2_0 {
	meta:
		name = "_IsNonwritableInCurrentImage$filt$0"
		size = 36
	strings:
		$1 = { F8 62 FB 6A 1B 68 1B 68 3B 63 3A 6B 04 4B 9A 42 02 D1 01 23 3B 61 01 E0 00 23 3B 61 38 69 70 47 05 00 00 C0 }
	condition:
		$1
}

rule file_101_3_0 {
	meta:
		name = "_ValidateImageBase"
		size = 102
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 01 93 01 9B 1A 88 45 F6 4D 23 9A 42 02 D0 00 23 00 93 1C E0 01 9B 3C 33 01 9A 1B 68 13 44 02 93 02 9B 1A 68 44 F2 50 53 9A 42 02 D0 00 23 00 93 0D E0 02 9B 18 33 03 93 03 9B 1A 88 40 F2 0B 13 9A 42 02 D0 00 23 00 93 01 E0 01 23 00 93 00 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__rt_ursh"
		size = 58
	strings:
		$1 = { 00 2A 08 BF 70 47 20 2A 0C DB 40 2A 03 DB 4F EA 11 01 08 46 70 47 02 F0 1F 02 21 FA 02 F0 4F F0 00 01 70 47 20 FA 02 F0 C2 F1 20 03 01 FA 03 F3 40 EA 03 00 21 FA 02 F1 70 47 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "??__C@YAXPAX0IHP6AX00@ZP6AX0@Z@Z"
		size = 40
		refs = "001a ??__C@YAXPAX0IIP6AX00@ZP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 09 9B 01 93 08 9B 00 93 07 9B 06 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "??__D@YAXPAX0IHP6AX00@ZP6AX0@Z@Z"
		size = 40
		refs = "001a ??__D@YAXPAX0IIP6AX00@ZP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 09 9B 01 93 08 9B 00 93 07 9B 06 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_103_1_0 {
	meta:
		name = "??__C@YAXPAX0IIP6AX00@ZP6AX0@Z@Z"
		size = 110
		refs = "0030 _guard_check_icall 0060 ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 B0 48 0D F1 0C 0B 83 B0 6F 46 00 23 7B 60 00 23 3B 70 02 E0 7B 68 5B 1C 7B 60 7A 68 FB 6A 9A 42 13 D0 7D 6A 3C 6A 3B 6B BB 60 B8 68 ?? ?? ?? ?? BB 68 20 46 29 46 98 47 3A 6A BB 6A 13 44 3B 62 7A 6A BB 6A 13 44 7B 62 E4 E7 01 23 3B 70 3B 78 00 2B 05 D1 7B 6B 7A 68 B9 6A 38 6A ?? ?? ?? ?? 03 B0 BD E8 B0 08 5D F8 14 FB }
	condition:
		$1
}

rule file_103_2_0 {
	meta:
		name = "?fin$0@?0???__C@YAXPAX0IIP6AX00@ZP6AX0@Z@Z@4HA"
		size = 24
		refs = "0010 ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 10 B5 3B 78 00 2B 05 D1 7B 6B 7A 68 B9 6A 38 6A ?? ?? ?? ?? FF E7 10 BD }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0008 ?get_app_type@__scrt_main_policy@@SA?AW4_crt_app_type@@XZ 0010 _set_app_type 0014 _get_startup_file_mode 001c _set_fmode 0020 _get_startup_commit_mode 0026 __p__commode 0034 __scrt_initialize_onexit_tables 0046 __scrt_fastfail 004a _RTC_Initialize 0050 atexit 0054 ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 0066 ?__scrt_initialize_type_info@@YAXXZ 006a __scrt_is_user_matherr_present 0078 __setusermatherr 007c _initialize_invalid_parameter_handler 0080 _initialize_denormal_control 0084 _get_startup_thread_locale_mode 008c _configthreadlocale 0090 _should_initialize_environment 00a0 ?initialize_environment@@YAXXZ 00a4 __scrt_initialize_winrt 00b4 _matherr 00b8 _RTC_Terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 8A B0 ?? ?? ?? ?? 01 90 01 98 ?? ?? ?? ?? ?? ?? ?? ?? 02 90 02 98 ?? ?? ?? ?? ?? ?? ?? ?? 03 90 ?? ?? ?? ?? 04 90 03 9A 04 9B 1A 60 01 20 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 02 D1 07 20 ?? ?? ?? ?? ?? ?? ?? ?? 1A 48 ?? ?? ?? ?? ?? ?? ?? ?? 05 90 05 9B 00 2B 02 D0 07 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 06 90 06 9B 00 2B 02 D0 0F 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 07 90 07 98 ?? ?? ?? ?? ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 01 D0 ?? ?? ?? ?? ?? ?? ?? ?? 00 23 08 93 08 98 0A B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0008 ?get_app_type@__scrt_main_policy@@SA?AW4_crt_app_type@@XZ 0010 _set_app_type 0014 _get_startup_file_mode 001c _set_fmode 0020 _get_startup_commit_mode 0026 __p__commode 0034 __scrt_initialize_onexit_tables 0046 __scrt_fastfail 004a _RTC_Initialize 0050 atexit 0054 ?configure_argv@__scrt_wide_argv_policy@@SAHXZ 0066 ?__scrt_initialize_type_info@@YAXXZ 006a __scrt_is_user_matherr_present 0078 __setusermatherr 007c _initialize_invalid_parameter_handler 0080 _initialize_denormal_control 0084 _get_startup_thread_locale_mode 008c _configthreadlocale 0090 _should_initialize_environment 00a0 ?initialize_environment@@YAXXZ 00a4 __scrt_initialize_winrt 00b4 _matherr 00b8 _RTC_Terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 8A B0 ?? ?? ?? ?? 01 90 01 98 ?? ?? ?? ?? ?? ?? ?? ?? 02 90 02 98 ?? ?? ?? ?? ?? ?? ?? ?? 03 90 ?? ?? ?? ?? 04 90 03 9A 04 9B 1A 60 01 20 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 02 D1 07 20 ?? ?? ?? ?? ?? ?? ?? ?? 1A 48 ?? ?? ?? ?? ?? ?? ?? ?? 05 90 05 9B 00 2B 02 D0 07 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 06 90 06 9B 00 2B 02 D0 0F 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 07 90 07 98 ?? ?? ?? ?? ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 01 D0 ?? ?? ?? ?? ?? ?? ?? ?? 00 23 08 93 08 98 0A B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0008 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 0010 _set_app_type 0014 _get_startup_file_mode 001c _set_fmode 0020 _get_startup_commit_mode 0026 __p__commode 0034 __scrt_initialize_onexit_tables 0046 __scrt_fastfail 004a _RTC_Initialize 0050 atexit 0054 ?configure_argv@__scrt_wide_argv_policy@@SAHXZ 0066 ?__scrt_initialize_type_info@@YAXXZ 006a __scrt_is_user_matherr_present 0078 __setusermatherr 007c _initialize_invalid_parameter_handler 0080 _initialize_denormal_control 0084 _get_startup_thread_locale_mode 008c _configthreadlocale 0090 _should_initialize_environment 00a0 ?initialize_environment@@YAXXZ 00a4 __scrt_initialize_winrt 00b4 _matherr 00b8 _RTC_Terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 8A B0 ?? ?? ?? ?? 01 90 01 98 ?? ?? ?? ?? ?? ?? ?? ?? 02 90 02 98 ?? ?? ?? ?? ?? ?? ?? ?? 03 90 ?? ?? ?? ?? 04 90 03 9A 04 9B 1A 60 01 20 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 02 D1 07 20 ?? ?? ?? ?? ?? ?? ?? ?? 1A 48 ?? ?? ?? ?? ?? ?? ?? ?? 05 90 05 9B 00 2B 02 D0 07 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 06 90 06 9B 00 2B 02 D0 0F 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 07 90 07 98 ?? ?? ?? ?? ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 01 D0 ?? ?? ?? ?? ?? ?? ?? ?? 00 23 08 93 08 98 0A B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0008 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 0010 _set_app_type 0014 _get_startup_file_mode 001c _set_fmode 0020 _get_startup_commit_mode 0026 __p__commode 0034 __scrt_initialize_onexit_tables 0046 __scrt_fastfail 004a _RTC_Initialize 0050 atexit 0054 ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 0066 ?__scrt_initialize_type_info@@YAXXZ 006a __scrt_is_user_matherr_present 0078 __setusermatherr 007c _initialize_invalid_parameter_handler 0080 _initialize_denormal_control 0084 _get_startup_thread_locale_mode 008c _configthreadlocale 0090 _should_initialize_environment 00a0 ?initialize_environment@@YAXXZ 00a4 __scrt_initialize_winrt 00b4 _matherr 00b8 _RTC_Terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 8A B0 ?? ?? ?? ?? 01 90 01 98 ?? ?? ?? ?? ?? ?? ?? ?? 02 90 02 98 ?? ?? ?? ?? ?? ?? ?? ?? 03 90 ?? ?? ?? ?? 04 90 03 9A 04 9B 1A 60 01 20 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 02 D1 07 20 ?? ?? ?? ?? ?? ?? ?? ?? 1A 48 ?? ?? ?? ?? ?? ?? ?? ?? 05 90 05 9B 00 2B 02 D0 07 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 06 90 06 9B 00 2B 02 D0 0F 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 07 90 07 98 ?? ?? ?? ?? ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 01 D0 ?? ?? ?? ?? ?? ?? ?? ?? 00 23 08 93 08 98 0A B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_194_0_7 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0008 ?get_app_type@__scrt_main_policy@@SA?AW4_crt_app_type@@XZ 0010 _set_app_type 0014 _get_startup_file_mode 001c _set_fmode 0020 _get_startup_commit_mode 0026 __p__commode 0034 __scrt_initialize_onexit_tables 0046 __scrt_fastfail 004a _RTC_Initialize 0050 atexit 0054 ?configure_argv@__scrt_wide_argv_policy@@SAHXZ 0066 ?__scrt_initialize_type_info@@YAXXZ 006a __scrt_is_user_matherr_present 0078 __setusermatherr 007c _initialize_invalid_parameter_handler 0080 _initialize_denormal_control 0084 _get_startup_thread_locale_mode 008c _configthreadlocale 0090 _should_initialize_environment 00a0 ?initialize_environment@@YAXXZ 00a4 __scrt_initialize_winrt 00b4 _matherr 00b8 _RTC_Terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 8A B0 ?? ?? ?? ?? 01 90 01 98 ?? ?? ?? ?? ?? ?? ?? ?? 02 90 02 98 ?? ?? ?? ?? ?? ?? ?? ?? 03 90 ?? ?? ?? ?? 04 90 03 9A 04 9B 1A 60 01 20 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 02 D1 07 20 ?? ?? ?? ?? ?? ?? ?? ?? 1A 48 ?? ?? ?? ?? ?? ?? ?? ?? 05 90 05 9B 00 2B 02 D0 07 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 06 90 06 9B 00 2B 02 D0 0F 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 07 90 07 98 ?? ?? ?? ?? ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 01 D0 ?? ?? ?? ?? ?? ?? ?? ?? 00 23 08 93 08 98 0A B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_269_0_7 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0008 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 0010 _set_app_type 0014 _get_startup_file_mode 001c _set_fmode 0020 _get_startup_commit_mode 0026 __p__commode 0034 __scrt_initialize_onexit_tables 0046 __scrt_fastfail 004a _RTC_Initialize 0050 atexit 0054 ?configure_argv@__scrt_wide_argv_policy@@SAHXZ 0066 ?__scrt_initialize_type_info@@YAXXZ 006a __scrt_is_user_matherr_present 0078 __setusermatherr 007c _initialize_invalid_parameter_handler 0080 _initialize_denormal_control 0084 _get_startup_thread_locale_mode 008c _configthreadlocale 0090 _should_initialize_environment 00a0 ?initialize_environment@@YAXXZ 00a4 __scrt_initialize_winrt 00b4 _matherr 00b8 _RTC_Terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 8A B0 ?? ?? ?? ?? 01 90 01 98 ?? ?? ?? ?? ?? ?? ?? ?? 02 90 02 98 ?? ?? ?? ?? ?? ?? ?? ?? 03 90 ?? ?? ?? ?? 04 90 03 9A 04 9B 1A 60 01 20 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 02 D1 07 20 ?? ?? ?? ?? ?? ?? ?? ?? 1A 48 ?? ?? ?? ?? ?? ?? ?? ?? 05 90 05 9B 00 2B 02 D0 07 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 06 90 06 9B 00 2B 02 D0 0F 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 07 90 07 98 ?? ?? ?? ?? ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 01 D0 ?? ?? ?? ?? ?? ?? ?? ?? 00 23 08 93 08 98 0A B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_359_0_7 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 188
		refs = "0008 ?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ 0010 _set_app_type 0014 _get_startup_file_mode 001c _set_fmode 0020 _get_startup_commit_mode 0026 __p__commode 0034 __scrt_initialize_onexit_tables 0046 __scrt_fastfail 004a _RTC_Initialize 0050 atexit 0054 ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 0066 ?__scrt_initialize_type_info@@YAXXZ 006a __scrt_is_user_matherr_present 0078 __setusermatherr 007c _initialize_invalid_parameter_handler 0080 _initialize_denormal_control 0084 _get_startup_thread_locale_mode 008c _configthreadlocale 0090 _should_initialize_environment 00a0 ?initialize_environment@@YAXXZ 00a4 __scrt_initialize_winrt 00b4 _matherr 00b8 _RTC_Terminate"
	strings:
		$1 = { 2D E9 00 48 EB 46 8A B0 ?? ?? ?? ?? 01 90 01 98 ?? ?? ?? ?? ?? ?? ?? ?? 02 90 02 98 ?? ?? ?? ?? ?? ?? ?? ?? 03 90 ?? ?? ?? ?? 04 90 03 9A 04 9B 1A 60 01 20 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 02 D1 07 20 ?? ?? ?? ?? ?? ?? ?? ?? 1A 48 ?? ?? ?? ?? ?? ?? ?? ?? 05 90 05 9B 00 2B 02 D0 07 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 06 90 06 9B 00 2B 02 D0 0F 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 07 90 07 98 ?? ?? ?? ?? ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 01 D0 ?? ?? ?? ?? ?? ?? ?? ?? 00 23 08 93 08 98 0A B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_1_0 {
	meta:
		name = "?post_pgo_initialization@@YAHXZ"
		size = 24
		refs = "0008 __scrt_initialize_default_local_stdio_options"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? 00 23 00 93 00 98 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_104_2_0 {
	meta:
		name = "?pre_cpp_initialization@@YAXXZ"
		size = 30
		refs = "0008 __scrt_set_unhandled_exception_filter 000c _get_startup_new_mode 0014 _set_new_mode"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? ?? ?? ?? ?? 00 90 00 98 ?? ?? ?? ?? 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_104_3_0 {
	meta:
		name = "?__scrt_common_main@@YAHXZ"
		size = 30
		refs = "0008 __security_init_cookie 000c ?__scrt_common_main_seh@@YAHXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_104_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 364
		refs = "000e __scrt_initialize_crt 001c __scrt_fastfail 0024 __scrt_acquire_startup_lock 0050 _initterm_e 006a _initterm 007c __scrt_release_startup_lock 0080 __scrt_get_dyn_tls_init_callback 0094 __scrt_is_nonwritable_in_current_image 00ae _guard_check_icall 00bc __scrt_get_dyn_tls_dtor_callback 00e0 _register_thread_local_exe_atexit_callback 00e4 ?invoke_main@@YAHXZ 00ee __scrt_is_managed_app 00fc exit 0106 _cexit 010e __scrt_uninitialize_crt 0136 _exit 0140 _c_exit 0158 __scrt_current_native_startup_state 015c __xc_a 0160 __xc_z 0164 __xi_a 0168 __xi_z"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 94 B0 6F 46 01 20 ?? ?? ?? ?? 78 70 7B 78 00 2B 02 D1 07 20 ?? ?? ?? ?? 00 23 3B 70 ?? ?? ?? ?? B8 70 BB 78 FB 70 4A 4B 1B 68 01 2B 03 D1 07 20 ?? ?? ?? ?? 1D E0 46 4B 1B 68 00 2B 17 D1 44 4A 01 23 13 60 46 49 45 48 ?? ?? ?? ?? 78 62 7B 6A 00 2B 04 D0 FF 23 BB 62 BB 6A 7B 61 74 E0 3E 49 3C 48 ?? ?? ?? ?? 3A 4A 02 23 13 60 01 E0 01 23 3B 70 F8 78 ?? ?? ?? ?? ?? ?? ?? ?? F8 62 FB 6A FB 60 FB 68 1B 68 00 2B 14 D0 F8 68 ?? ?? ?? ?? 38 71 3B 79 00 2B 0D D0 00 26 02 25 00 24 FB 68 1B 68 BB 61 B8 69 ?? ?? ?? ?? BB 69 20 46 29 46 32 46 98 47 ?? ?? ?? ?? 38 63 3B 6B 3B 61 3B 69 1B 68 00 2B 0A D0 38 69 ?? ?? ?? ?? 78 71 7B 79 00 2B 03 D0 3B 69 18 68 ?? ?? ?? ?? ?? ?? ?? ?? 78 63 7B 6B FB 61 ?? ?? ?? ?? B8 71 BB 79 00 2B 02 D1 F8 69 ?? ?? ?? ?? 3B 78 00 2B 01 D1 ?? ?? ?? ?? 00 21 01 20 ?? ?? ?? ?? FB 69 BB 63 BB 6B 7B 61 19 E0 18 E0 B8 60 BB 68 BB 64 BB 6C 3B 62 ?? ?? ?? ?? F8 71 FB 79 00 2B 02 D1 38 6A ?? ?? ?? ?? 3B 78 00 2B 01 D1 ?? ?? ?? ?? 3B 6A FB 64 FB 6C 7B 61 00 E0 FF E7 78 69 14 B0 BD E8 F0 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_5_0 {
	meta:
		name = "?filt$0@?0??__scrt_common_main_seh@@YAHXZ@4HA"
		size = 30
		refs = "0014 _seh_filter_exe"
	strings:
		$1 = { 10 B5 B8 60 BB 68 FB 63 BB 68 1B 68 1B 68 3B 64 F9 6B 38 6C ?? ?? ?? ?? 78 64 78 6C 10 BD }
	condition:
		$1
}

rule file_104_6_0 {
	meta:
		name = "?configure_argv@__scrt_narrow_argv_policy@@SAHXZ"
		size = 34
		refs = "0008 _get_startup_argv_mode 0010 _configure_narrow_argv"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 ?? ?? ?? ?? 00 90 00 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_109_6_0 {
	meta:
		name = "?configure_argv@__scrt_wide_argv_policy@@SAHXZ"
		size = 34
		refs = "0008 _get_startup_argv_mode 0010 _configure_wide_argv"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 ?? ?? ?? ?? 00 90 00 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_34_1_4 {
	meta:
		name = "_get_unexpected"
		size = 34
		refs = "0008 __vcrt_getptd 0010 ?get_unexpected_or_default@@YAP6AXXZQBU__vcrt_ptd@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 ?? ?? ?? ?? 00 90 00 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_104_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 54
		refs = "0008 _get_initial_narrow_environment 000e __p___argv 0014 __p___argc 0024 main"
	strings:
		$1 = { 2D E9 00 48 EB 46 86 B0 ?? ?? ?? ?? 00 90 ?? ?? ?? ?? 01 90 ?? ?? ?? ?? 02 90 00 9A 01 9B 19 68 02 9B 18 68 ?? ?? ?? ?? 03 90 03 9B 04 93 04 98 06 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_109_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 54
		refs = "0008 _get_initial_wide_environment 000e __p___wargv 0014 __p___argc 0024 wmain"
	strings:
		$1 = { 2D E9 00 48 EB 46 86 B0 ?? ?? ?? ?? 00 90 ?? ?? ?? ?? 01 90 ?? ?? ?? ?? 02 90 00 9A 01 9B 19 68 02 9B 18 68 ?? ?? ?? ?? 03 90 03 9B 04 93 04 98 06 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_104_10_0 {
	meta:
		name = "mainCRTStartup"
		size = 26
		refs = "0008 ?__scrt_common_main@@YAHXZ"
		altNames = "WinMainCRTStartup wWinMainCRTStartup wmainCRTStartup"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_65_1_1 {
	meta:
		name = "?uncaught_exceptions@std@@YAHXZ"
		size = 26
		refs = "0008 __uncaught_exceptions"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_106_4_0 {
	meta:
		name = "?find_pe_section@@YAPAU_IMAGE_SECTION_HEADER@@QAEI@Z"
		size = 146
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 88 B0 0A 9B 02 93 02 9B 3C 33 02 9A 1B 68 13 44 05 93 05 9B 01 93 01 9B 03 F1 18 02 01 9B 1B 1D 10 33 1B 88 13 44 03 93 01 9B 1B 1D 9B 1C 1A 88 28 23 02 FB 03 F2 03 9B 13 44 06 93 03 9B 00 93 02 E0 00 9B 28 33 00 93 00 9A 06 9B 9A 42 14 D0 00 9B 0C 33 0B 9A 1B 68 9A 42 0D D3 00 9B 03 F1 0C 02 00 9B 08 33 12 68 1B 68 1A 44 0B 9B 93 42 02 D2 00 9B 04 93 02 E0 E3 E7 00 23 04 93 04 98 08 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_106_5_0 {
	meta:
		name = "?is_potentially_valid_image_base@@YA_NQAX@Z"
		size = 130
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 9B 00 2B 03 D1 00 23 8D F8 00 30 2D E0 08 9B 01 93 01 9B 1A 88 45 F6 4D 23 9A 42 03 D0 00 23 8D F8 00 30 21 E0 01 9B 3C 33 01 9A 1B 68 13 44 03 93 03 9B 02 93 02 9B 1A 68 44 F2 50 53 9A 42 03 D0 00 23 8D F8 00 30 0F E0 02 9B 18 33 04 93 04 9B 1A 88 40 F2 0B 13 9A 42 03 D0 00 23 8D F8 00 30 02 E0 01 23 8D F8 00 30 9D F8 00 00 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_106_6_0 {
	meta:
		name = "NtCurrentTeb"
		size = 26
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 1D EE 50 3F 00 93 00 9B 01 93 01 98 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_106_7_0 {
	meta:
		name = "__scrt_acquire_startup_lock"
		size = 124
		refs = "0008 __scrt_is_ucrt_dll_in_use 001c NtCurrentTeb 0078 __scrt_native_startup_lock"
	strings:
		$1 = { 2D E9 00 48 EB 46 86 B0 ?? ?? ?? ?? 03 90 03 9B 00 2B 03 D1 00 23 8D F8 00 30 27 E0 ?? ?? ?? ?? 04 90 04 9B 1B 1D 1B 68 01 93 BF F3 5B 8F 12 48 01 99 50 E8 00 2F 00 2A 03 D1 40 E8 00 13 00 2B F7 D1 13 46 05 93 BF F3 5B 8F 05 9B 02 93 02 9B 00 2B 08 D0 01 9A 02 9B 9A 42 03 D1 01 23 8D F8 00 30 03 E0 E1 E7 00 23 8D F8 00 30 9D F8 00 00 06 B0 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_8_0 {
	meta:
		name = "__scrt_dllmain_after_initialize_c"
		size = 66
		refs = "0008 __scrt_is_ucrt_dll_in_use 0014 __isa_available_init 001a ?configure_argv@__scrt_narrow_argv_policy@@SAHXZ 002e _initialize_narrow_environment"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 ?? ?? ?? ?? 01 90 01 9B 00 2B 02 D0 ?? ?? ?? ?? 0B E0 ?? ?? ?? ?? 02 90 02 9B 00 2B 03 D0 00 23 8D F8 00 30 04 E0 ?? ?? ?? ?? 01 23 8D F8 00 30 9D F8 00 00 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_106_9_0 {
	meta:
		name = "__scrt_dllmain_before_initialize_c"
		size = 50
		refs = "000a __scrt_initialize_onexit_tables"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 00 20 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 03 D1 00 23 8D F8 04 30 02 E0 01 23 8D F8 04 30 9D F8 04 00 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_106_10_0 {
	meta:
		name = "__scrt_dllmain_crt_thread_attach"
		size = 76
		refs = "0008 __vcrt_thread_attach 0020 __acrt_thread_attach 0030 __vcrt_thread_detach"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 03 D1 00 23 8D F8 04 30 10 E0 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 05 D1 ?? ?? ?? ?? 00 23 8D F8 04 30 02 E0 01 23 8D F8 04 30 9D F8 04 00 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_106_11_0 {
	meta:
		name = "__scrt_dllmain_crt_thread_detach"
		size = 32
		refs = "0008 __acrt_thread_detach 000c __vcrt_thread_detach"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? ?? ?? ?? ?? 01 23 8D F8 00 30 9D F8 00 00 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_106_12_0 {
	meta:
		name = "__scrt_dllmain_exception_filter"
		size = 82
		refs = "000c __scrt_is_ucrt_dll_in_use 002a _guard_check_icall 003c _seh_filter_dll"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B 85 B0 ?? ?? ?? ?? 01 90 01 9B 00 2B 0F D1 0B 9B 01 2B 0C D1 0C 9E 00 25 0A 9C 0D 9B 00 93 00 98 ?? ?? ?? ?? 00 9B 20 46 29 46 32 46 98 47 0F 99 0E 98 ?? ?? ?? ?? 02 90 02 9B 03 93 03 98 05 B0 BD E8 70 08 5D F8 14 FB }
	condition:
		$1
}

rule file_106_13_0 {
	meta:
		name = "__scrt_dllmain_uninitialize_c"
		size = 56
		refs = "0008 __scrt_is_ucrt_dll_in_use 0016 _execute_onexit_table 001c _is_c_termination_complete 0028 _cexit 0034 ?module_local_atexit_table@@3U_onexit_table_t@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? 00 90 00 9B 00 2B 03 D0 07 48 ?? ?? ?? ?? 07 E0 ?? ?? ?? ?? 01 90 01 9B 00 2B 01 D1 ?? ?? ?? ?? 02 B0 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_14_0 {
	meta:
		name = "__scrt_dllmain_uninitialize_critical"
		size = 20
		refs = "0008 __acrt_uninitialize_critical 000c __vcrt_uninitialize_critical"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 ?? ?? ?? ?? ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "?_RTC_GetErrorFunc@@YAP6AHHPBDH00ZZPBX@Z"
		size = 20
		refs = "0006 ?_RTC_ErrorReportFunc@@3P6AHHPBDH00ZZA"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? C0 F2 00 03 18 68 BD E8 00 88 }
	condition:
		$1
}

rule file_151_1_0 {
	meta:
		name = "?_RTC_GetErrorFuncW@@YAP6AHHPB_WH00ZZPBX@Z"
		size = 20
		refs = "0006 ?_RTC_ErrorReportFuncW@@3P6AHHPB_WH00ZZA"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? C0 F2 00 03 18 68 BD E8 00 88 }
	condition:
		$1
}

rule file_106_15_0 {
	meta:
		name = "__scrt_initialize_crt"
		size = 104
		refs = "0016 __isa_available_init 001a __vcrt_initialize 0032 __acrt_initialize 0044 __vcrt_uninitialize 0064 ?is_initialized_as_dll@@3_NA"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 00 2B 02 D1 14 4A 01 23 13 70 ?? ?? ?? ?? ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 03 D1 00 23 8D F8 04 30 11 E0 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 06 D1 00 20 ?? ?? ?? ?? 00 23 8D F8 04 30 02 E0 01 23 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_16_0 {
	meta:
		name = "__scrt_initialize_onexit_tables"
		size = 192
		refs = "001a __scrt_fastfail 001e __scrt_is_ucrt_dll_in_use 0032 _initialize_onexit_table 006a ??$__crt_fast_encode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z 00b8 ?module_local_at_quick_exit_table@@3U_onexit_table_t@@A 00bc ?module_local_atexit_table@@3U_onexit_table_t@@A"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 8D B0 10 9B 00 2B 05 D0 10 9B 01 2B 02 D0 05 20 ?? ?? ?? ?? ?? ?? ?? ?? 02 90 02 9B 00 2B 1D D0 10 9B 00 2B 1A D1 22 48 ?? ?? ?? ?? 03 90 03 9B 00 2B 03 D0 00 23 8D F8 04 30 31 E0 1C 48 ?? ?? ?? ?? 04 90 04 9B 00 2B 03 D0 00 23 8D F8 04 30 26 E0 01 23 8D F8 04 30 22 E0 21 E0 6F F0 00 00 ?? ?? ?? ?? 05 90 05 9B 00 93 00 9B 06 93 00 9B 07 93 00 9B 08 93 0E 4C 06 A8 90 E8 0E 00 84 E8 0E 00 00 9B 0A 93 00 9B 0B 93 00 9B 0C 93 07 4C 0A A8 90 E8 0E 00 84 E8 0E 00 01 23 8D F8 04 30 9D F8 04 00 0D B0 BD E8 10 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_17_0 {
	meta:
		name = "__scrt_is_nonwritable_in_current_image"
		size = 148
		refs = "0018 ?is_potentially_valid_image_base@@YA_NQAX@Z 003a ?find_pe_section@@YAPAU_IMAGE_SECTION_HEADER@@QAEI@Z 0090 __ImageBase"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 8B B0 6F 46 BB 6B BB 61 1F 4B FB 60 F8 68 ?? ?? ?? ?? 38 70 3B 78 00 2B 04 D1 00 23 7B 70 7B 78 3B 72 29 E0 BA 69 FB 68 D3 1A FB 61 F9 69 F8 68 ?? ?? ?? ?? 38 62 3B 6A 3B 61 3B 69 00 2B 04 D1 00 23 BB 70 BB 78 3B 72 16 E0 3B 69 24 33 1B 68 13 F0 00 4F 04 D0 00 23 FB 70 FB 78 3B 72 0B E0 01 23 3B 71 3B 79 3B 72 06 E0 05 E0 00 23 7B 71 7B 79 3B 72 00 E0 FF E7 38 7A 0B B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_18_0 {
	meta:
		name = "__scrt_is_nonwritable_in_current_image$filt$0"
		size = 36
	strings:
		$1 = { 78 62 7B 6A 1B 68 1B 68 BB 62 BA 6A 04 4B 9A 42 02 D1 01 23 7B 61 01 E0 00 23 7B 61 78 69 70 47 05 00 00 C0 }
	condition:
		$1
}

rule file_106_19_0 {
	meta:
		name = "__scrt_release_startup_lock"
		size = 72
		refs = "000a __scrt_is_ucrt_dll_in_use 0044 __scrt_native_startup_lock"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? 00 90 00 9B 00 2B 00 D1 10 E0 9D F8 10 30 00 2B 00 D0 0B E0 BF F3 5B 8F 07 48 00 21 50 E8 00 2F 40 E8 00 13 00 2B F9 D1 BF F3 5B 8F 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_20_0 {
	meta:
		name = "__scrt_uninitialize_crt"
		size = 76
		refs = "0026 __acrt_uninitialize 002e __vcrt_uninitialize 0048 ?is_initialized_as_dll@@3_NA"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0F 4B 1B 78 00 2B 07 D0 9D F8 14 30 00 2B 03 D0 01 23 8D F8 00 30 0A E0 9D F8 10 00 ?? ?? ?? ?? 9D F8 10 00 ?? ?? ?? ?? 01 23 8D F8 00 30 9D F8 00 00 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_21_0 {
	meta:
		name = "_onexit"
		size = 112
		refs = "000e ??$__crt_fast_decode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z 0022 _crt_atexit 0044 _register_onexit_function 006c ?module_local_atexit_table@@3U_onexit_table_t@@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 88 B0 18 4B 18 68 ?? ?? ?? ?? 03 90 03 9B 04 93 04 9B B3 F1 FF 3F 0F D1 0A 98 ?? ?? ?? ?? 05 90 05 9B 00 2B 02 D1 0A 9B 00 93 01 E0 00 23 00 93 00 9B 02 93 0F E0 0E E0 0A 99 0A 48 ?? ?? ?? ?? 06 90 06 9B 00 2B 02 D1 0A 9B 01 93 01 E0 00 23 01 93 01 9B 02 93 02 98 08 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_22_0 {
	meta:
		name = "at_quick_exit"
		size = 84
		refs = "000e ??$__crt_fast_decode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z 0022 _crt_at_quick_exit 0038 _register_onexit_function 0050 ?module_local_at_quick_exit_table@@3U_onexit_table_t@@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 11 4B 18 68 ?? ?? ?? ?? 01 90 01 9B 02 93 02 9B B3 F1 FF 3F 07 D1 08 98 ?? ?? ?? ?? 03 90 03 9B 00 93 09 E0 08 E0 08 9B 04 93 04 99 06 48 ?? ?? ?? ?? 05 90 05 9B 00 93 00 98 06 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_23_0 {
	meta:
		name = "atexit"
		size = 52
		refs = "000c _onexit"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 01 90 01 9B 00 2B 02 D0 00 23 00 93 02 E0 6F F0 00 03 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "__GSHandlerCheck"
		size = 40
		refs = "0014 __GSHandlerCheckCommon"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 07 9B 1C 33 1A 68 07 99 05 98 ?? ?? ?? ?? 01 23 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_108_1_0 {
	meta:
		name = "__GSHandlerCheckCommon"
		size = 72
		refs = "003a __security_check_cookie"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 08 9B 1B 68 23 F0 03 03 02 93 06 9B 01 93 01 9A 02 9B 13 44 1B 68 00 93 08 9B 1B 68 13 F0 01 0F 05 D0 01 9A 02 9B 1A 44 00 9B D3 1A 00 93 00 98 ?? ?? ?? ?? 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_110_15_0 {
	meta:
		name = "??__E?p0@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p0@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F6 10 F1 BE }
	condition:
		$1
}

rule file_110_16_0 {
	meta:
		name = "??__E?p0@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p0@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? E2 1C 06 51 A6 60 2B C0 }
	condition:
		$1
}

rule file_110_17_0 {
	meta:
		name = "??__E?p1@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 91 86 50 BD }
	condition:
		$1
}

rule file_110_18_0 {
	meta:
		name = "??__E?p1@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CB BC E2 B9 7F 81 34 C0 }
	condition:
		$1
}

rule file_110_20_0 {
	meta:
		name = "??__E?p2@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 63 6A 8D 5C 3F FD 20 C0 }
	condition:
		$1
}

rule file_110_22_0 {
	meta:
		name = "??__E?p3@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p3@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? BD 87 B1 D9 7A CD EA BF }
	condition:
		$1
}

rule file_110_23_0 {
	meta:
		name = "??__E?q0@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D3 CC B4 3F }
	condition:
		$1
}

rule file_110_24_0 {
	meta:
		name = "??__E?q0@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? A9 95 C4 BC 7C 88 44 40 }
	condition:
		$1
}

rule file_110_26_0 {
	meta:
		name = "??__E?q1@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? A5 6D 0B 04 12 8A 55 40 }
	condition:
		$1
}

rule file_110_28_0 {
	meta:
		name = "??__E?q2@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D7 A3 0D 32 0A CA 4D 40 }
	condition:
		$1
}

rule file_110_30_0 {
	meta:
		name = "??__E?q3@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 10 C7 4A E1 49 0C 2E 40 }
	condition:
		$1
}

rule file_110_33_0 {
	meta:
		name = "??__E?sqrt_three@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?sqrt_three@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? D7 B3 DD 3F }
	condition:
		$1
}

rule file_110_34_0 {
	meta:
		name = "??__E?sqrt_three@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?sqrt_three@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 48 04 49 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7A B6 FB 3F AA 4C 58 E8 }
	condition:
		$1
}

rule file_110_35_0 {
	meta:
		name = "??__E?two_minus_sqrt_three@?$VATan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?two_minus_sqrt_three@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? A2 30 89 3E }
	condition:
		$1
}

rule file_110_36_0 {
	meta:
		name = "??__E?two_minus_sqrt_three@?$VATan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?two_minus_sqrt_three@?$VATan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 48 04 49 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 14 26 D1 3F 56 CD 9E 5E }
	condition:
		$1
}

rule file_110_37_0 {
	meta:
		name = "?A@?$VATan@M@@CA?AT__n128@@T2@@Z"
		size = 124
		refs = "0008 __security_push_cookie 0064 __security_pop_cookie"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? 88 B0 9F ED 1A 2A 10 EE 10 2B 04 AB 30 EE 10 1B 8D ED 04 2A 9F ED 14 2A 11 EE 10 0B 31 EE 10 4B 8D ED 05 2A 9F ED 0F 2A 8D ED 06 2A 9F ED 0C 2A 8D ED 07 2A 53 F8 22 30 00 93 04 AB 53 F8 21 30 01 93 04 AB 53 F8 20 30 02 93 04 AB 53 F8 24 30 03 93 9D EC 04 0B 08 B0 ?? ?? ?? ?? BD E8 10 88 92 0A 86 3F DB 0F C9 3F 92 0A 06 3F 00 00 00 00 }
	condition:
		$1
}

rule file_110_38_0 {
	meta:
		name = "?A@?$VATan@N@@CA?AT__n128@@T2@@Z"
		size = 144
		refs = "0006 __security_push_cookie 0066 __security_pop_cookie"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 8F B0 9F ED 1E 2B 9F ED 1B 3B 9F ED 18 4B 9F ED 15 5B 50 EC 11 2B 06 AB 03 EB C2 03 8D ED 06 2B 8D ED 08 3B 8D ED 0A 4B 8D ED 0C 5B 93 ED 00 2B 51 EC 10 2B 06 AB 03 EB C2 03 8D ED 00 2B 03 91 93 ED 00 0B DD E9 00 32 CD E9 03 03 05 92 8D ED 02 0B 0D F1 08 0C 9C EC 04 0B 0F B0 ?? ?? ?? ?? BD E8 00 88 FE DE 66 73 2D 38 52 C1 F0 3F 18 2D 44 54 FB 21 F9 3F 66 73 2D 38 52 C1 E0 3F 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_110_43_0 {
	meta:
		name = "?atan2@?$VATan@M@@SA?AT__n128@@T2@0@Z"
		size = 996
		refs = "002a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00a0 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 021c ?A@?$VATan@M@@CA?AT__n128@@T2@@Z 03a4 ?neginf@?$VectorOp@M@@2T__n128@@B 03a8 ?exponentBias@?$VectorOp@M@@2T__n128@@B 03ac ?exponentMask@?$VectorOp@M@@2T__n128@@B 03b0 ?inf@?$VectorOp@M@@2T__n128@@B 03b4 ?eps@?$VATan@M@@0T__n128@@B 03b8 ?q0@?$VATan@M@@0T__n128@@B 03bc ?p0@?$VATan@M@@0T__n128@@B 03c0 ?p1@?$VATan@M@@0T__n128@@B 03c4 ?sqrt_three@?$VATan@M@@0T__n128@@B 03c8 ?two_minus_sqrt_three@?$VATan@M@@0T__n128@@B"
		altNames = "__vdecl_atan2f4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B B5 B0 20 EF 50 A1 9F ED F3 0A 22 EF 52 E1 0D F1 30 0C 8C EC 04 EB 0D F1 10 0C 8C EC 04 AB ?? ?? ?? ?? 0D F1 20 0C 8C EC 04 0B 9F ED E9 0A ?? ?? ?? ?? 60 EF 50 01 9F ED E5 0A 0D F1 A0 0C CC EC 04 0B ?? ?? ?? ?? 9F ED E0 8A 60 EF 50 01 0D F1 60 0C CC EC 04 0B B0 EE 48 0A ?? ?? ?? ?? 60 EF 50 01 9F ED D8 0A 0D F1 90 0C CC EC 04 0B ?? ?? ?? ?? 60 EF 50 01 9F ED D2 0A 0D F1 C0 0C CC EC 04 0B ?? ?? ?? ?? 60 EF 50 01 7D 20 0D F1 B0 0C CC EC 04 0B ?? ?? ?? ?? 60 EF 50 01 6F F0 79 00 0D F1 70 0C CC EC 04 0B ?? ?? ?? ?? FB FF 4E 25 60 EF 50 01 B6 EE 00 0A 0D F1 80 0C CC EC 04 0B 4E EF 72 0F 42 FF F0 2D 4E EF 72 0F 42 FF F0 0D 4A FF 70 0D B9 FF 60 A7 ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A CD EC 04 0B ?? ?? ?? ?? 20 EF 50 E1 B0 EE 48 0A ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 50 0C CC EC 04 0B ?? ?? ?? ?? FB FF 4A 25 2A FF 4E CE 4A EF 72 0F 02 20 42 FF F0 2D 0D F1 40 0C 8C EC 04 CB 20 EF 50 81 4A EF 72 0F 42 FF F0 0D 10 FF DA C1 ?? ?? ?? ?? A0 4B 0D F1 40 0C 9C EC 04 AB DD EC 04 2B D3 EC 04 0B 9B 4B 10 FF 58 A1 2C FF 60 8E D3 EC 04 0B 40 EF CC 6D 60 EF CE 0D 40 FF DC 0D 60 EF E2 0D 60 EF E2 0D 40 EF CC 4D FB FF 66 25 28 EF 58 E1 46 EF F2 0F 01 20 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D 10 FF DC E1 ?? ?? ?? ?? 87 4B 6A EF 40 08 4E FF 5E 4D 10 FF DA 81 01 20 D3 EC 04 0B 81 4B 40 FF F4 2D 8D EC 04 8B D3 EC 04 0B 7C 4B 42 EF E0 0D 40 FF F4 6D D3 EC 04 0B 78 4B 44 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4E FF 70 0D 4E EF 60 2D D3 EC 04 0B 20 FF DE CE 1E FF 72 C1 B9 FF CC 87 ?? ?? ?? ?? DD EC 04 0B 20 EF C0 A3 20 EF F0 01 18 FF 5C A1 ?? ?? ?? ?? 40 EF 4A 2D 62 4C 0D F1 20 0C 9C EC 04 0B 0D F1 30 0C 9C EC 04 4B D4 EC 04 0B 5C 4B 20 FF 44 AE 4E EF 60 4E 0D F1 50 0C DC EC 04 0B 0D F1 60 0C 9C EC 04 EB 0D F1 10 0C 9C EC 04 2B 50 FF F2 41 6A EF 5A 21 6E EF 64 0D 60 FF 42 EE 50 FF F4 21 44 EF 40 CE D3 EC 04 4B 4B 4B F9 FF E2 07 44 EF 74 81 D3 EC 04 AB 50 FF F2 E1 E9 FF 78 00 42 EF 74 41 60 FF EA 28 E9 FF 74 00 02 EF 40 CE 60 FF EA 08 60 FF E2 08 0D F1 70 0C DC EC 04 2B 60 EF F2 63 E9 FF 78 00 60 FF EA 28 E9 FF 74 00 60 FF EA 08 60 FF E2 08 0D F1 80 0C DC EC 04 2B 4F F0 00 40 62 EF F0 43 0D F1 90 0C DC EC 04 2B 6C EF F6 01 52 FF FE 01 42 EF 42 2E 50 FF 70 41 44 EF 44 0E 00 EF F2 81 14 FF D4 81 ?? ?? ?? ?? 0D F1 10 0C DC EC 04 CB 4C EF 5A 41 40 EF 7C A1 0D F1 20 0C 9C EC 04 0B 23 4B 6A EF DE 61 0D F1 30 0C 9C EC 04 EB 6A EF D0 81 6E FF 40 0E 56 FF D8 41 4C EF 70 21 0D F1 A0 0C DC EC 04 0B 6E FF 70 08 58 FF F4 21 4C EF 70 41 6E FF 50 08 56 FF F2 41 4C EF 70 61 F9 FF 6C 07 58 FF F4 61 D4 EC 04 4B 40 EF E4 8E 0D F1 B0 0C DC EC 04 0B 6A EF F0 21 4E EF 64 0E 48 EF F0 41 0D F1 C0 0C DC EC 04 0B 52 FF F6 41 6A EF F0 21 D3 EC 04 0B 4E EF 60 0E 08 EF F0 01 12 FF F4 01 35 B0 BD EC 10 8B BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E4 CB 16 40 DB 0F 49 3F DB 0F C9 3F DB 0F 49 40 00 00 00 80 00 00 00 00 }
	condition:
		$1
}

rule file_110_44_0 {
	meta:
		name = "?atan@?$VATan@M@@SA?AT__n128@@T2@@Z"
		size = 484
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0066 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0174 ?A@?$VATan@M@@CA?AT__n128@@T2@@Z 01c0 ?inf@?$VectorOp@M@@2T__n128@@B 01c4 ?eps@?$VATan@M@@0T__n128@@B 01c8 ?q0@?$VATan@M@@0T__n128@@B 01cc ?p0@?$VATan@M@@0T__n128@@B 01d0 ?p1@?$VATan@M@@0T__n128@@B 01d4 ?sqrt_three@?$VATan@M@@0T__n128@@B 01d8 ?two_minus_sqrt_three@?$VATan@M@@0T__n128@@B"
		altNames = "__vdecl_atanf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 94 B0 20 EF 50 81 9F ED 73 0A 0D F1 40 0C 8C EC 04 8B ?? ?? ?? ?? 60 EF 50 01 B6 EE 00 0A 0D F1 30 0C CC EC 04 0B B9 FF 48 A7 ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A 0D F1 10 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 E1 9F ED 62 0A ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 20 0C CC EC 04 0B ?? ?? ?? ?? FB FF 4A 25 2A FF 4E CE 4A EF 72 0F 02 20 42 FF F0 2D 8D EC 04 CB 20 EF 50 81 4A EF 72 0F 42 FF F0 0D 10 FF DA C1 ?? ?? ?? ?? 50 4B 9D EC 04 AB 0D F1 10 0C DC EC 04 2B D3 EC 04 0B 4B 4B 10 FF 58 A1 2C FF 60 8E D3 EC 04 0B 01 20 40 EF CC 6D 60 EF CE 0D 28 EF 58 E1 40 FF DC 0D 60 EF E2 0D 60 EF E2 0D FB FF 66 25 40 EF CC 4D 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D 10 FF DC E1 ?? ?? ?? ?? 37 4B 6A EF 40 08 4E FF 5E 4D 10 FF DA 81 D3 EC 04 0B 31 4B 40 FF F4 2D D3 EC 04 0B 2E 4B 0D F1 10 0C 8C EC 04 8B 42 EF E0 0D 40 FF F4 6D D3 EC 04 0B 27 4B 44 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4E FF 70 0D 4E EF 60 2D D3 EC 04 0B 20 FF DE CE 1E FF 72 C1 01 20 B9 FF CC 87 ?? ?? ?? ?? 0D F1 10 0C DC EC 04 0B 20 EF C0 A3 20 EF F0 01 18 FF 5C A1 ?? ?? ?? ?? 40 EF 4A 2D 10 4B 0D F1 40 0C DC EC 04 6B D3 EC 04 0B 06 EF E6 0E 4E EF 60 4E 0D F1 20 0C DC EC 04 0B 50 FF F2 41 0D F1 30 0C DC EC 04 2B F9 FF E4 07 62 FF E6 2E 50 FF F4 21 12 FF F6 01 14 B0 BD EC 10 8B BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? DB 0F C9 3F 00 00 00 00 }
	condition:
		$1
}

rule file_110_45_0 {
	meta:
		name = "?atan_impl@?$VATan@M@@CA?AT__n128@@T2@@Z"
		size = 412
		refs = "0014 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0046 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0154 ?A@?$VATan@M@@CA?AT__n128@@T2@@Z 017c ?inf@?$VectorOp@M@@2T__n128@@B 0180 ?eps@?$VATan@M@@0T__n128@@B 0184 ?q0@?$VATan@M@@0T__n128@@B 0188 ?p0@?$VATan@M@@0T__n128@@B 018c ?p1@?$VATan@M@@0T__n128@@B 0190 ?sqrt_three@?$VATan@M@@0T__n128@@B 0194 ?two_minus_sqrt_three@?$VATan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 8C B0 20 EF 50 A1 B6 EE 00 0A ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A 0D F1 10 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 E1 9F ED 59 0A ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 20 0C CC EC 04 0B ?? ?? ?? ?? FB FF 4A 25 2A FF 4E CE 4A EF 72 0F 02 20 42 FF F0 2D 8D EC 04 CB 20 EF 50 81 4A EF 72 0F 42 FF F0 0D 10 FF DA C1 ?? ?? ?? ?? 47 4B 9D EC 04 AB 0D F1 10 0C DC EC 04 2B D3 EC 04 0B 42 4B 10 FF 58 A1 2C FF 60 8E D3 EC 04 0B 01 20 40 EF CC 6D 60 EF CE 0D 28 EF 58 E1 40 FF DC 0D 60 EF E2 0D 60 EF E2 0D FB FF 66 25 40 EF CC 4D 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D 10 FF DC E1 ?? ?? ?? ?? 2E 4B 6A EF 40 08 4E FF 5E 4D 10 FF DA 81 01 20 D3 EC 04 0B 28 4B 40 FF F4 2D 0D F1 10 0C 8C EC 04 8B D3 EC 04 0B 22 4B 42 EF E0 0D 40 FF F4 6D D3 EC 04 0B 1E 4B 44 EF E0 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 46 FF F0 0D 4E FF 70 0D 4E EF 60 2D D3 EC 04 0B 20 FF DE CE 1E FF 72 C1 B9 FF CC 87 ?? ?? ?? ?? 0D F1 10 0C DC EC 04 0B 20 EF C0 A3 18 FF 5C A1 20 EF F0 01 ?? ?? ?? ?? 08 4B 40 EF 4A 2D D3 EC 04 0B 0E EF 60 0E 0D F1 20 0C DC EC 04 0B 10 FF F2 01 0C B0 BD EC 10 8B BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? DB 0F C9 3F }
	condition:
		$1
}

rule file_110_54_0 {
	meta:
		name = "?create@?$VectorOp@M@@SA?AT__n128@@MMMM@Z"
		size = 32
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B CD ED 01 0A 8D ED 00 0A 8D ED 02 1A CD ED 03 1A 9D EC 04 0B BD E8 0F 88 }
	condition:
		$1
}

rule file_110_59_0 {
	meta:
		name = "?create@?$VectorOp@N@@SA?AT__n128@@NN@Z"
		size = 46
	strings:
		$1 = { 2D E9 00 48 EB 46 88 B0 8D ED 00 0B 8D ED 02 1B 00 9B 04 93 01 9B 05 93 02 9B 06 93 03 9B 07 93 0D F1 10 0C 9C EC 04 0B 08 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_110_68_0 {
	meta:
		name = "?intxp@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 44
		refs = "0024 ?exponentBias@?$VectorOp@M@@2T__n128@@B 0028 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 4B D3 EC 04 0B 05 4B 40 EF 70 01 E9 FF 70 20 D3 EC 04 0B 22 FF E0 08 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_77_0 {
	meta:
		name = "?unpack@?$VectorOp@N@@SAXT__n128@@AA_K1@Z"
		size = 26
	strings:
		$1 = { 2D E9 00 48 EB 46 52 EC 10 3B C0 E9 00 32 52 EC 11 3B C1 E9 00 32 BD E8 00 88 }
	condition:
		$1
}

rule file_111_2_0 {
	meta:
		name = "??__E?C0@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?C0@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F3 04 35 3F }
	condition:
		$1
}

rule file_111_3_0 {
	meta:
		name = "??__E?C0@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?C0@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CD 3B 7F 66 9E A0 E6 3F }
	condition:
		$1
}

rule file_111_4_0 {
	meta:
		name = "??__E?C1@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?C1@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 80 31 3F }
	condition:
		$1
}

rule file_200_1_0 {
	meta:
		name = "??__E?C1@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?C1@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 80 31 3F }
	condition:
		$1
}

rule file_111_5_0 {
	meta:
		name = "??__E?C1@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?C1@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 30 E6 3F }
	condition:
		$1
}

rule file_200_2_0 {
	meta:
		name = "??__E?C1@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?C1@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 30 E6 3F }
	condition:
		$1
}

rule file_111_6_0 {
	meta:
		name = "??__E?C2@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?C2@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 83 80 5E B9 }
	condition:
		$1
}

rule file_200_3_0 {
	meta:
		name = "??__E?C2@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?C2@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 83 80 5E B9 }
	condition:
		$1
}

rule file_111_7_0 {
	meta:
		name = "??__E?C2@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?C2@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? A8 0C 61 5C 10 D0 2B BF }
	condition:
		$1
}

rule file_200_4_0 {
	meta:
		name = "??__E?C2@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?C2@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? A8 0C 61 5C 10 D0 2B BF }
	condition:
		$1
}

rule file_111_8_0 {
	meta:
		name = "??__E?C3@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?C3@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? D8 5B DE 3E }
	condition:
		$1
}

rule file_111_9_0 {
	meta:
		name = "??__E?C3@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?C3@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 48 04 49 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7B CB DB 3F 0E E5 26 15 }
	condition:
		$1
}

rule file_111_10_0 {
	meta:
		name = "??__E?a0@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?a0@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 3D 7E 0D BF }
	condition:
		$1
}

rule file_111_11_0 {
	meta:
		name = "??__E?a0@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?a0@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9A B5 B3 12 FF 07 50 C0 }
	condition:
		$1
}

rule file_111_13_0 {
	meta:
		name = "??__E?a1@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?a1@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? ED AF 16 20 4A 62 30 40 }
	condition:
		$1
}

rule file_111_15_0 {
	meta:
		name = "??__E?a2@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?a2@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 29 BD 56 B3 15 44 E9 BF }
	condition:
		$1
}

rule file_111_16_0 {
	meta:
		name = "??__E?b0@?$VLog@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?b0@?$VLog@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 3A 3F D4 C0 }
	condition:
		$1
}

rule file_111_17_0 {
	meta:
		name = "??__E?b0@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?b0@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 77 90 0D 9C FE 0B 88 C0 }
	condition:
		$1
}

rule file_111_19_0 {
	meta:
		name = "??__E?b1@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?b1@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7E 26 15 FA 83 80 73 40 }
	condition:
		$1
}

rule file_111_21_0 {
	meta:
		name = "??__E?b2@?$VLog@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?b2@?$VLog@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 0F CE 67 4B 80 D5 41 C0 }
	condition:
		$1
}

rule file_111_57_0 {
	meta:
		name = "?log10@?$VLog@M@@SA?AT__n128@@T2@@Z"
		size = 420
		refs = "001a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 003c ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0170 ?inf@?$VectorOp@M@@2T__n128@@B 0174 ?ind@?$VectorOp@M@@2T__n128@@B 0178 ?neginf@?$VectorOp@M@@2T__n128@@B 017c ?C3@?$VLog@M@@0T__n128@@B 0180 ?C2@?$VLog@M@@0T__n128@@B 0184 ?C1@?$VLog@M@@0T__n128@@B 0188 ?a0@?$VLog@M@@0T__n128@@B 0190 ?b0@?$VLog@M@@0T__n128@@B 0194 ?C0@?$VLog@M@@0T__n128@@B 0198 ?notExponentMask@?$VectorOp@M@@2T__n128@@B 019c ?exponentBias@?$VectorOp@M@@2T__n128@@B 01a0 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
		altNames = "__vdecl_log10f4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 85 B0 20 EF 50 81 B6 EE 00 0A 8D EC 04 8B ?? ?? ?? ?? 60 4B 5E 4C 00 20 D3 EC 04 0B 20 EF 50 E1 48 EF 70 01 E9 FF 70 20 D4 EC 04 0B 22 FF E0 A8 ?? ?? ?? ?? D4 EC 04 0B 54 4B 01 20 60 EF 60 08 F7 EF 70 25 D3 EC 04 0B 4F 4B 48 EF 70 01 20 EF F2 81 D3 EC 04 0B 28 FF 60 CE ?? ?? ?? ?? 6A FF 40 08 68 EF 4E 2D 6C EF 5C A1 5A FF 70 A1 62 EF CE 0D 44 4B 6C EF 5C 41 50 FF F2 41 9F ED 40 0A 44 FF DE 0D 40 EF CE 2D 48 FF 5E 0D 40 EF CE 0D 10 FF F2 C1 FB FF 4C 25 4C EF 72 0F 42 FF F0 2D 4C EF 72 0F 42 FF F0 0D 44 FF F0 8D D3 EC 04 0B 32 4B 48 FF F8 2D 42 EF E0 6D D3 EC 04 0B 2E 4B 42 FF F0 4D FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D FB FF 6A 46 48 FF F0 0D 48 EF E0 6D D3 EC 04 0B 21 4B 44 FF F0 2D D3 EC 04 0B 1E 4B 44 FF F0 0D 40 EF E6 0D 40 EF E2 2D D3 EC 04 0B 02 FF F0 8D ?? ?? ?? ?? 20 EF 50 A1 B7 EE 00 0A ?? ?? ?? ?? DD EC 04 6B 12 4B 46 EF C0 2E 46 EF CA 4E 5A FF 58 21 D3 EC 04 0B 0D 4B 06 EF E6 0E 50 FF F2 41 D3 EC 04 0B 08 4B 6A FF 66 2E 50 FF F4 21 D3 EC 04 0B 46 EF E0 0E 56 FF F2 01 10 FF F6 01 05 B0 BD EC 10 8B BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_58_0 {
	meta:
		name = "?log@?$VLog@M@@SA?AT__n128@@T2@@Z"
		size = 408
		refs = "001a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 003c ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0168 ?inf@?$VectorOp@M@@2T__n128@@B 016c ?ind@?$VectorOp@M@@2T__n128@@B 0170 ?neginf@?$VectorOp@M@@2T__n128@@B 0174 ?C2@?$VLog@M@@0T__n128@@B 0178 ?C1@?$VLog@M@@0T__n128@@B 017c ?a0@?$VLog@M@@0T__n128@@B 0184 ?b0@?$VLog@M@@0T__n128@@B 0188 ?C0@?$VLog@M@@0T__n128@@B 018c ?notExponentMask@?$VectorOp@M@@2T__n128@@B 0190 ?exponentBias@?$VectorOp@M@@2T__n128@@B 0194 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
		altNames = "__vdecl_logf4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 85 B0 20 EF 50 81 B6 EE 00 0A 8D EC 04 8B ?? ?? ?? ?? 5D 4B 5B 4C 00 20 D3 EC 04 0B 20 EF 50 E1 48 EF 70 01 E9 FF 70 20 D4 EC 04 0B 22 FF E0 A8 ?? ?? ?? ?? D4 EC 04 0B 51 4B 01 20 60 EF 60 08 F7 EF 70 25 D3 EC 04 0B 4C 4B 48 EF 70 01 20 EF F2 81 D3 EC 04 0B 28 FF 60 CE ?? ?? ?? ?? 6A FF 40 08 68 EF 4E 2D 6C EF 5C A1 5A FF 70 A1 62 EF CE 0D 41 4B 6C EF 5C 41 50 FF F2 41 9F ED 3D 0A 44 FF DE 0D 40 EF CE 2D 48 FF 5E 0D 40 EF CE 0D 10 FF F2 C1 FB FF 4C 25 4C EF 72 0F 42 FF F0 2D 4C EF 72 0F 42 FF F0 0D 44 FF F0 8D D3 EC 04 0B 2F 4B 48 FF F8 2D 42 EF E0 6D D3 EC 04 0B 2B 4B 42 FF F0 4D FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D FB FF 6A 46 48 FF F0 0D 48 EF E0 6D D3 EC 04 0B 1E 4B 44 FF F0 2D D3 EC 04 0B 44 FF F0 0D 40 EF E6 0D 00 EF E2 8D ?? ?? ?? ?? 20 EF 50 A1 B7 EE 00 0A ?? ?? ?? ?? DD EC 04 6B 13 4B 46 EF C0 2E D3 EC 04 0B 46 EF CA 4E 5A FF 58 21 50 FF F2 41 6A FF 66 2E 0B 4B 06 EF E6 0E D3 EC 04 0B 08 4B 50 FF F4 21 D3 EC 04 0B 46 EF E0 0E 56 FF F2 01 10 FF F6 01 05 B0 BD EC 10 8B BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_59_0 {
	meta:
		name = "?log_check_special_case@?$VLog@M@@CA?AT__n128@@T2@0@Z"
		size = 120
		refs = "0016 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0068 ?inf@?$VectorOp@M@@2T__n128@@B 006c ?ind@?$VectorOp@M@@2T__n128@@B 0070 ?neginf@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 0C 8B 20 EF 50 C1 9F ED 19 0A 22 EF 52 81 ?? ?? ?? ?? 20 EF 50 A1 B7 EE 00 0A ?? ?? ?? ?? 12 4B 4C EF 40 2E 4C EF 4A 4E D3 EC 04 0B 0D 4B 5A FF 58 21 0C EF 4C 0E 50 FF F2 41 6A FF 4C 2E D3 EC 04 0B 07 4B 50 FF F4 21 D3 EC 04 0B 4C EF 60 0E 5C FF 72 01 10 FF DC 01 BD EC 0C 8B BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_111_60_0 {
	meta:
		name = "?log_impl@?$VLog@M@@CA?AT__n128@@T2@@Z"
		size = 300
		refs = "0014 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0036 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 010c ?C2@?$VLog@M@@0T__n128@@B 0110 ?C1@?$VLog@M@@0T__n128@@B 0114 ?a0@?$VLog@M@@0T__n128@@B 0118 ?b0@?$VLog@M@@0T__n128@@B 011c ?C0@?$VLog@M@@0T__n128@@B 0120 ?notExponentMask@?$VectorOp@M@@2T__n128@@B 0124 ?exponentBias@?$VectorOp@M@@2T__n128@@B 0128 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 2D ED 10 8B 20 EF 50 81 B6 EE 00 0A ?? ?? ?? ?? 43 4B 42 4C 00 20 D3 EC 04 0B 20 EF 50 E1 48 EF 70 01 E9 FF 70 20 D4 EC 04 0B 22 FF E0 A8 ?? ?? ?? ?? D4 EC 04 0B 38 4B 01 20 60 EF 60 08 F7 EF 70 25 D3 EC 04 0B 33 4B 48 EF 70 01 20 EF F2 81 D3 EC 04 0B 28 FF 60 CE ?? ?? ?? ?? 6A FF 40 08 68 EF 4E 2D 6C EF 5C A1 5A FF 70 A1 62 EF CE 0D 27 4B 6C EF 5C 41 50 FF F2 41 44 FF DE 0D 40 EF CE 2D 48 FF 5E 0D 40 EF CE 0D 10 FF F2 C1 FB FF 4C 25 4C EF 72 0F 42 FF F0 2D 4C EF 72 0F 42 FF F0 0D 44 FF F0 8D D3 EC 04 0B 18 4B 48 FF F8 2D 42 EF E0 6D D3 EC 04 0B 13 4B 42 FF F0 4D FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D FB FF 6A 46 48 FF F0 0D 48 EF E0 6D D3 EC 04 0B 07 4B 44 FF F0 2D D3 EC 04 0B 44 FF F0 0D 40 EF E6 0D 00 EF E2 0D BD EC 10 8B BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_64_0 {
	meta:
		name = "?setxp@?$VectorOp@M@@SA?AT__n128@@T2@0@Z"
		size = 48
		refs = "0028 ?notExponentMask@?$VectorOp@M@@2T__n128@@B 002c ?exponentBias@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 4B D3 EC 04 0B 06 4B 62 EF 60 08 F7 EF 70 25 D3 EC 04 0B 40 EF 70 01 20 EF F2 01 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_2_0 {
	meta:
		name = "__u64tod"
		size = 140
		refs = "0080 __i64tofp_exception_helper"
	strings:
		$1 = { 2D E9 03 48 0D F1 08 0B 00 29 08 D1 B0 FA 80 F2 10 FA 02 F1 28 D0 00 20 02 F1 20 02 08 E0 B1 FA 81 F2 D2 F1 20 03 91 40 30 FA 03 F3 19 43 90 40 40 F2 3E 43 D2 EB 03 02 5F EA 00 5C C0 0A 4B 05 18 43 C9 0A 62 F3 1E 51 1C F0 80 4F 05 D0 3C F0 80 4C 02 D0 40 1C 41 F1 00 01 41 EC 10 0B 5F EA 4C 0C 04 D1 BD E8 03 88 41 EC 10 1B FA E7 F1 EE 10 3A 43 F0 01 03 03 EA 13 22 D2 06 F2 D0 02 4A ?? ?? ?? ?? EE E7 00 00 01 08 09 01 }
	condition:
		$1
}

rule file_115_4_0 {
	meta:
		name = "__u64tos"
		size = 136
		refs = "007c __i64tofp_exception_helper"
	strings:
		$1 = { 2D E9 03 48 0D F1 08 0B 00 29 08 D1 B0 FA 80 F2 10 FA 02 F1 26 D0 00 20 02 F1 20 02 08 E0 B1 FA 81 F2 D2 F1 20 03 91 40 30 FA 03 F3 19 43 90 40 4F F0 BE 03 D2 EB 03 02 5F EA C1 5C 09 0A 62 F3 DE 51 1C F0 80 4F 04 D0 3C F0 80 4C 01 D0 01 F1 01 01 00 EE 10 1A 5F EA 4C 0C 5C EA 00 0C 04 D1 BD E8 03 88 00 EE 10 1A FA E7 F1 EE 10 3A 43 F0 01 03 03 EA 13 22 D2 06 F2 D0 02 4A ?? ?? ?? ?? EE E7 00 00 01 08 09 00 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "_matherr"
		size = 26
		altNames = "?_Get_deleter@_Ref_count_base@std@@UBAPAXABVtype_info@@@Z ?do_encoding@?$codecvt@GDU_Mbstatet@@@std@@MBAHXZ ?do_encoding@?$codecvt@_WDU_Mbstatet@@@std@@MBAHXZ ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAAHXZ ?sync@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAAHXZ ?sync@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAAHXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 00 23 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "??3@YAXPAXHPBDH@Z"
		size = 24
		refs = "000c _free_dbg"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_124_1_0 {
	meta:
		name = "??_V@YAXPAXHPBDH@Z"
		size = 28
		refs = "0010 ??3@YAXPAXHPBDH@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 05 9B 04 9A 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "??_M@YAXPAXIHP6AX0@Z@Z"
		size = 28
		refs = "0010 ??_M@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 05 9B 04 9A 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "??2@YAPAXI@Z"
		size = 80
		refs = "000c malloc 0024 _callnewh 0038 ?__scrt_throw_std_bad_array_new_length@@YAXXZ 003e ?__scrt_throw_std_bad_alloc@@YAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 00 2B 02 D0 00 9B 03 93 10 E0 06 98 ?? ?? ?? ?? 02 90 02 9B 00 2B 08 D1 06 9B B3 F1 FF 3F 02 D1 ?? ?? ?? ?? 01 E0 ?? ?? ?? ?? E2 E7 03 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_128_2_0 {
	meta:
		name = "__scrt_initialize_default_local_stdio_options"
		size = 74
		refs = "0008 __local_stdio_printf_options 0026 __local_stdio_scanf_options"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 ?? ?? ?? ?? 02 90 02 9B 00 93 00 9B 1B 68 43 F0 04 01 00 9B 5A 68 00 9B 19 60 00 9B 5A 60 ?? ?? ?? ?? 03 90 03 9B 01 93 01 9B 1B 68 43 F0 02 01 01 9B 5A 68 01 9B 19 60 01 9B 5A 60 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_137_1_0 {
	meta:
		name = "??_M@YAXPAXIIP6AX0@Z@Z"
		size = 104
		refs = "003c _guard_check_icall 005a ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 90 48 0D F1 08 0B 82 B0 6F 46 00 23 3B 70 FA 69 3B 6A 02 FB 03 F2 BB 69 13 44 BB 61 3A 6A 3B 6A 5B 1E 3B 62 00 2A 0D D9 BA 69 FB 69 D3 1A BB 61 BC 69 7B 6A 7B 60 78 68 ?? ?? ?? ?? 7B 68 20 46 98 47 EB E7 01 23 3B 70 3B 78 00 2B 05 D1 7B 6A 3A 6A F9 69 B8 69 ?? ?? ?? ?? 02 B0 BD E8 90 08 5D F8 14 FB }
	condition:
		$1
}

rule file_137_2_0 {
	meta:
		name = "?fin$0@?0???_M@YAXPAXIIP6AX0@Z@Z@4HA"
		size = 24
		refs = "0010 ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 10 B5 3B 78 00 2B 05 D1 7B 6A 3A 6A F9 69 B8 69 ?? ?? ?? ?? FF E7 10 BD }
	condition:
		$1
}

rule file_137_3_0 {
	meta:
		name = "?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 52
		refs = "001c terminate"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 68 00 93 00 9B 1A 68 06 4B 9A 42 00 D0 01 E0 ?? ?? ?? ?? 00 23 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB 63 73 6D E0 }
	condition:
		$1
}

rule file_137_4_0 {
	meta:
		name = "?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
		size = 76
		refs = "0032 _guard_check_icall"
	strings:
		$1 = { 0F B4 2D E9 90 48 0D F1 08 0B 86 B0 6F 46 00 23 3B 60 02 E0 3B 68 5B 1C 3B 60 3A 68 3B 6B 9A 42 0D D0 BA 6A FB 6A D3 1A BB 62 BC 6A 7B 6B 7B 60 78 68 ?? ?? ?? ?? 7B 68 20 46 98 47 EA E7 00 E0 FF E7 06 B0 BD E8 90 08 5D F8 14 FB }
	condition:
		$1
}

rule file_137_5_0 {
	meta:
		name = "?filt$0@?0??__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z@4HA"
		size = 20
		refs = "000a ?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
	strings:
		$1 = { 10 B5 B8 60 BB 68 FB 60 F8 68 ?? ?? ?? ?? 38 61 38 69 10 BD }
	condition:
		$1
}

rule file_138_7_0 {
	meta:
		name = "??__E?K@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?K@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? ED A8 E2 3E }
	condition:
		$1
}

rule file_138_8_0 {
	meta:
		name = "??__E?K@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?K@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? F8 0B AE 94 1D 55 DC 3F }
	condition:
		$1
}

rule file_138_9_0 {
	meta:
		name = "??__E?bigx@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?bigx@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 18 52 B1 44 }
	condition:
		$1
}

rule file_138_10_0 {
	meta:
		name = "??__E?bigx@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?bigx@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? EF 39 FA FE C2 2D C6 40 }
	condition:
		$1
}

rule file_138_19_0 {
	meta:
		name = "??__E?lsb_mask@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?lsb_mask@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_138_20_0 {
	meta:
		name = "??__E?lsb_mask@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?lsb_mask@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 01 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_138_25_0 {
	meta:
		name = "??__E?p1@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 5C B7 AA 3D }
	condition:
		$1
}

rule file_138_26_0 {
	meta:
		name = "??__E?p1@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 4D 55 55 55 55 55 B5 3F }
	condition:
		$1
}

rule file_138_28_0 {
	meta:
		name = "??__E?p2@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 0E 08 9E 99 99 99 89 3F }
	condition:
		$1
}

rule file_138_30_0 {
	meta:
		name = "??__E?p3@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p3@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? AC 8D 27 2E 24 49 62 3F }
	condition:
		$1
}

rule file_138_32_0 {
	meta:
		name = "??__E?p4@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p4@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 28 FC 4A DB FD 78 3C 3F }
	condition:
		$1
}

rule file_138_33_0 {
	meta:
		name = "??__E?q1@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 11 72 31 3F }
	condition:
		$1
}

rule file_138_34_0 {
	meta:
		name = "??__E?q1@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? EF 39 FA FE 42 2E E6 3F }
	condition:
		$1
}

rule file_200_20_0 {
	meta:
		name = "??__E?ln2@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?ln2@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? EF 39 FA FE 42 2E E6 3F }
	condition:
		$1
}

rule file_138_35_0 {
	meta:
		name = "??__E?q2@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 15 F3 75 3E }
	condition:
		$1
}

rule file_138_36_0 {
	meta:
		name = "??__E?q2@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CE C4 82 FF BD BF CE 3F }
	condition:
		$1
}

rule file_138_37_0 {
	meta:
		name = "??__E?q3@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q3@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? FE A8 5E 3D }
	condition:
		$1
}

rule file_138_38_0 {
	meta:
		name = "??__E?q3@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 6D 02 03 D7 08 6B AC 3F }
	condition:
		$1
}

rule file_138_40_0 {
	meta:
		name = "??__E?q4@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q4@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 98 1D 13 6E AB B2 83 3F }
	condition:
		$1
}

rule file_138_42_0 {
	meta:
		name = "??__E?q5@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q5@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9F CD D7 18 7E D8 55 3F }
	condition:
		$1
}

rule file_138_44_0 {
	meta:
		name = "??__E?q6@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q6@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 74 4C 38 E0 7A 2F 24 3F }
	condition:
		$1
}

rule file_138_46_0 {
	meta:
		name = "??__E?q7@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q7@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 80 CC 92 E3 DD 4E EF 3E }
	condition:
		$1
}

rule file_138_47_0 {
	meta:
		name = "??__E?smallx@?$VPow@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?smallx@?$VPow@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 50 8C AE C4 }
	condition:
		$1
}

rule file_138_48_0 {
	meta:
		name = "??__E?smallx@?$VPow@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?smallx@?$VPow@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D2 BC 7A DD AB 22 C6 C0 }
	condition:
		$1
}

rule file_138_49_0 {
	meta:
		name = "?A1@?$VPow@M@@CA?AT__n128@@T2@@Z"
		size = 224
		refs = "0008 __security_push_cookie 009c __security_pop_cookie"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? 96 B0 33 4B 4F F0 7E 52 CD E9 04 23 2F 4B 30 EE 10 1B 11 EE 10 0B 06 93 2B 4B 31 EE 10 4B 07 93 28 4B 08 93 26 4B 09 93 24 4B 0A 93 22 4B 0B 93 20 4B 0C 93 1E 4B 0D 93 1C 4B 0E 93 1A 4B 0F 93 18 4B 10 93 16 4B 11 93 14 4B 12 93 12 4B 13 93 A2 F5 00 03 10 EE 10 2B 14 93 04 AB 03 EB 82 03 53 F8 04 3C 00 93 04 AB 03 EB 81 03 53 F8 04 3C 01 93 04 AB 03 EB 80 03 53 F8 04 3C 02 93 04 AB 03 EB 84 03 53 F8 04 3C 03 93 9D EC 04 0B 16 B0 ?? ?? ?? ?? BD E8 10 88 C3 AA 05 3F C1 95 0B 3F D3 C3 11 3F F0 37 18 3F 32 F5 1E 3F D6 FE 25 3F 3E 58 2D 3F F3 04 35 3F A3 08 3D 3F 2A 67 45 3F 8C 24 4E 3F FC 44 57 3F DE CC 60 3F C6 C0 6A 3F 7D 25 75 3F }
	condition:
		$1
}

rule file_138_50_0 {
	meta:
		name = "?A2@?$VPow@M@@CA?AT__n128@@T2@@Z"
		size = 156
		refs = "0008 __security_push_cookie 0074 __security_pop_cookie"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? 8C B0 22 4B 10 EE 10 2B 30 EE 10 1B 04 93 1E 4B 11 EE 10 0B 31 EE 10 4B 05 93 1A 4B 06 93 18 4B 07 93 16 4B 08 93 14 4B 09 93 12 4B 0A 93 10 4B 0B 93 04 AB 03 EB 82 03 53 F8 04 3C 00 93 04 AB 03 EB 81 03 53 F8 04 3C 01 93 04 AB 03 EB 80 03 53 F8 04 3C 02 93 04 AB 03 EB 84 03 53 F8 04 3C 03 93 9D EC 04 0B 0C B0 ?? ?? ?? ?? BD E8 10 88 90 98 CF 32 23 56 E7 32 42 23 C1 32 A1 42 6A 33 0C 58 1F 33 24 FC A8 31 94 2A 6C 33 36 24 A9 31 }
	condition:
		$1
}

rule file_138_53_0 {
	meta:
		name = "?adx@?$VectorOp@M@@SA?AT__n128@@T2@0@Z"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 F7 EF 52 05 20 EF 60 08 BD E8 00 88 }
	condition:
		$1
}

rule file_138_76_0 {
	meta:
		name = "?idiv_by16@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 22
	strings:
		$1 = { 2D E9 00 48 EB 46 FD EF 50 00 A4 FF 70 01 BC EF 50 00 BD E8 00 88 }
	condition:
		$1
}

rule file_138_78_0 {
	meta:
		name = "?is_odd@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 32
		refs = "0010 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 01 20 20 EF 50 81 ?? ?? ?? ?? 20 EF 58 08 BD EC 04 8B BD E8 00 88 }
	condition:
		$1
}

rule file_138_84_0 {
	meta:
		name = "?pow@?$VPow@M@@SA?AT__n128@@T2@0@Z"
		size = 2488
		refs = "000c __security_push_cookie 002e ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00ca ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 091a __security_pop_cookie 0928 ?ind@?$VectorOp@M@@2T__n128@@B 092c ?neginf@?$VectorOp@M@@2T__n128@@B 0930 ?smallx@?$VPow@M@@0T__n128@@B 0934 ?bigx@?$VPow@M@@0T__n128@@B 0938 ?inf@?$VectorOp@M@@2T__n128@@B 096c ?q1@?$VPow@M@@0T__n128@@B 0970 ?q2@?$VPow@M@@0T__n128@@B 0974 ?q3@?$VPow@M@@0T__n128@@B 0978 ?K@?$VPow@M@@0T__n128@@B 097c ?p1@?$VPow@M@@0T__n128@@B 09ac ?notExponentMask@?$VectorOp@M@@2T__n128@@B 09b0 ?exponentBias@?$VectorOp@M@@2T__n128@@B 09b4 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
		altNames = "__vdecl_powf4"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 2D ED 10 8B ?? ?? ?? ?? CC B0 9F ED 1F 8A 20 EF 50 A1 0D F1 18 0C 8C EC 04 2B 0D F1 28 0C 8C EC 04 AB B0 EE 48 0A ?? ?? ?? ?? 0D F1 88 0C 8C EC 04 0B 9F ED 14 0A ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A 0D F1 B8 0C CC EC 04 0B ?? ?? ?? ?? 0D F1 98 0C 8C EC 04 0B BF EE 00 0A ?? ?? ?? ?? 60 EF 50 01 B0 EE 48 0A 0D F1 A8 0C CC EC 04 0B B9 FF 4A C7 ?? ?? ?? ?? 60 EF 50 01 9F ED 01 0A 05 E0 00 00 80 3D 00 00 00 80 00 00 00 00 0D F1 78 0C CC EC 04 0B 8D ED 00 0A ?? ?? ?? ?? 60 EF 50 01 B3 EE 00 0A 0D F1 58 0C CC EC 04 0B 8D ED 01 0A ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 38 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 81 01 20 0D F1 48 0C 8C EC 04 8B ?? ?? ?? ?? DF F8 D0 38 20 EF 50 A1 09 20 D3 EC 04 0B DF F8 C0 38 0D F1 68 0C 8C EC 04 AB 4C EF 70 01 E9 FF 70 20 D3 EC 04 0B DF F8 A4 38 22 FF E0 E8 68 EF 60 08 F7 EF 70 25 D3 EC 04 0B 4C EF 70 01 20 EF F2 C1 ?? ?? ?? ?? DF F8 40 38 DF F8 14 78 4F F0 7E 52 CD E9 32 23 DF F8 2C 38 DF F8 00 68 3D 97 34 93 DF F8 1C 38 35 93 DF F8 10 38 36 93 DF F8 08 38 37 93 DF F8 FC 37 38 93 DF F8 F4 37 39 93 DF F8 E8 37 3A 93 DF F8 E0 37 3B 93 DF F8 D4 37 3C 93 A2 F5 00 08 DF F8 08 58 DF F8 2C A8 DF F8 24 98 10 EE 10 2B 32 AB 03 EB 82 03 CD E9 3E 65 CD E9 40 A9 CD F8 08 81 53 F8 04 3C 30 EE 10 1B 11 EE 10 0B 44 93 32 AB 03 EB 81 03 31 EE 10 4B 53 F8 04 3C 45 93 32 AB 03 EB 80 03 53 F8 04 3C 04 20 46 93 32 AB 03 EB 84 03 53 F8 04 3C 47 93 0D F5 88 7C DC EC 04 0B 00 FF CC 8E 10 FF 5A 81 ?? ?? ?? ?? 4F F0 7E 53 68 EF 40 28 32 93 DF F8 78 37 CD E9 3D 76 12 EE 90 2B 33 93 DF F8 64 37 CD E9 3F 5A CD E9 41 98 34 93 DF F8 54 37 32 EE 90 1B 13 EE 90 0B 35 93 DF F8 40 37 33 EE 90 4B 36 93 DF F8 34 37 37 93 DF F8 28 37 38 93 DF F8 20 37 39 93 DF F8 14 37 3A 93 DF F8 0C 37 3B 93 DF F8 00 37 3C 93 32 AB 03 EB 82 03 53 F8 04 3C 44 93 32 AB 03 EB 81 03 53 F8 04 3C 45 93 32 AB 03 EB 80 03 53 F8 04 3C 46 93 32 AB 03 EB 84 03 53 F8 04 3C 02 20 47 93 0D F5 88 7C DC EC 04 0B 00 FF CC AE 12 FF D8 A1 ?? ?? ?? ?? 4F F0 7E 53 6A EF 40 28 32 93 DF F8 D0 36 DF F8 A8 E6 12 EE 90 2B 33 93 DF F8 BC 36 CD E9 3C E7 CD E9 3E 65 34 93 DF F8 AC 36 CD E9 40 A9 CD F8 08 81 35 93 DF F8 98 36 32 EE 90 1B 13 EE 90 0B 36 93 DF F8 88 36 33 EE 90 4B 37 93 DF F8 78 36 38 93 DF F8 70 36 39 93 DF F8 64 36 3A 93 DF F8 5C 36 3B 93 32 AB 03 EB 82 03 53 F8 04 3C 44 93 32 AB 03 EB 81 03 53 F8 04 3C 45 93 32 AB 03 EB 80 03 53 F8 04 3C 46 93 32 AB 03 EB 84 03 53 F8 04 3C 47 93 4F F0 7E 53 32 93 DF F8 40 36 0D F5 88 7C DC EC 04 0B 33 93 DF F8 2C 36 40 FF CC 8E 0D F1 68 0C DC EC 04 0B 34 93 DF F8 18 36 52 FF DA 81 35 93 DF F8 08 36 68 EF E0 28 36 93 DF F8 FC 35 37 93 DF F8 F0 35 38 93 DF F8 E8 35 39 93 DF F8 DC 35 3A 93 DF F8 D4 35 3B 93 CD E9 3E 65 12 EE 90 5B 32 AB 03 EB 85 03 CD E9 3C E7 CD E9 40 A9 CD F8 08 81 53 F8 04 3C 32 EE 90 6B 13 EE 90 7B 44 93 32 AB 03 EB 86 03 33 EE 90 EB 53 F8 04 3C 45 93 32 AB 03 EB 87 03 53 F8 04 3C 46 93 32 AB 03 EB 8E 03 53 F8 04 3C 47 93 DF F8 D4 35 0D F5 88 7C DC EC 04 0B 44 93 DF F8 C4 35 4C EF 60 6D FF FF 72 00 45 93 DF F8 B0 35 10 EE 90 2B 46 93 DF F8 A4 35 30 EE 90 1B 11 EE 90 0B 47 93 DF F8 90 35 31 EE 90 4B 48 93 DF F8 84 35 49 93 DF F8 78 35 4A 93 DF F8 70 35 4B 93 44 AB 03 EB 82 03 53 F8 04 3C 02 93 44 AB 03 EB 81 03 53 F8 04 3C 03 93 44 AB 03 EB 80 03 53 F8 04 3C 04 93 44 AB 03 EB 84 03 53 F8 04 3C 05 93 4F F0 7E 53 32 93 DF F8 18 35 33 93 DF F8 0C 35 34 93 DF F8 04 35 35 93 DF F8 F8 34 36 93 DF F8 F0 34 37 93 DF F8 E4 34 38 93 DF F8 DC 34 39 93 DF F8 D0 34 DF F8 00 45 CD E9 3F 4A 3A 93 DF F8 C0 34 CD E9 41 98 9D ED 00 0A 3B 93 DF F8 AC 34 3C 93 DF F8 A4 34 3D 93 DF F8 98 34 3E 93 32 AB 03 EB 85 03 53 F8 04 3C 44 93 32 AB 03 EB 86 03 53 F8 04 3C 45 93 32 AB 03 EB 87 03 53 F8 04 3C 46 93 32 AB 03 EB 8E 03 53 F8 04 3C 47 93 DC EC 04 0B DF F8 A0 34 6C EF 60 2D 0D F1 08 0C DC EC 04 0B 62 EF E0 4D FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D 40 EF E0 6D D3 EC 04 0B DF F8 68 34 46 FF F6 2D D3 EC 04 4B 40 FF F2 0D 40 FF F6 2D 44 FF F2 0D 42 EF E0 2D 46 FF F4 0D 42 EF E0 0D 0D F1 58 0C DC EC 04 2B 00 EF E6 AD E4 EF 5E 05 60 FF E8 08 FB FF 60 06 00 FF F2 ED 0D F1 08 0C 8C EC 04 EB ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 0D F1 18 0C DC EC 04 4B 40 FF 74 0D 9D ED 00 0A FB FF 60 07 FB FF 60 06 00 FF D8 CD 64 EF CC 0D 4E FF 70 2D 4A FF 74 0D 00 EF E2 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D FB FF 60 07 9D ED 00 0A FB FF 60 06 40 FF D8 2D 0D F1 08 0C DC EC 04 0B 2A EF 62 ED 40 FF DC 0D 02 EF E0 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D 9D ED 00 0A FB FF 60 07 FB FF 60 06 00 FF D8 CD 6A EF 4C 0D 0E EF 60 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D 0D F1 38 0C DC EC 04 2B D8 4B FB FF 60 07 01 20 FB FF 60 06 00 FF D8 ED 4C EF 4E 0D 42 FF F0 0D 6A EF 4E 2D FB FF 60 47 0D F1 78 0C DC EC 04 0B 62 FF E0 6E 0D F1 58 0C DC EC 04 0B 66 EF F6 81 62 EF E0 0D 50 FF F2 81 0D F1 68 0C DC EC 04 2B 64 EF E2 08 50 FF F4 61 0D F1 48 0C DC EC 04 0B 20 EF E6 C3 10 FF F2 C1 FD EF 76 00 66 EF F6 21 E4 FF 70 21 BC EF 72 C1 E4 EF 5C 05 20 FF E6 88 D3 EC 04 0B B8 4B 40 FF F8 2D D3 EC 04 0B B4 4B 42 EF E0 0D 40 FF F8 2D D3 EC 04 0B 42 EF E0 0D 00 FF F8 AD ?? ?? ?? ?? 4F F0 7E 53 68 EF 40 08 32 93 AA 4B 33 93 A8 4B 34 93 A6 4B 35 93 A4 4B 36 93 A2 4B 37 93 A0 4B 38 93 9E 4B 39 93 9C 4B 3A 93 9A 4B 10 EE 90 2B CD E9 3F 4A 3B 93 96 4B CD E9 41 98 30 EE 90 1B 3C 93 92 4B 11 EE 90 0B 31 EE 90 4B 3D 93 8E 4B 3E 93 32 AB 03 EB 82 03 53 F8 04 3C 02 93 32 AB 03 EB 81 03 53 F8 04 3C 03 93 32 AB 03 EB 80 03 53 F8 04 3C 04 93 32 AB 03 EB 84 03 53 F8 04 3C 81 4C 01 20 05 93 0D F1 08 0C DC EC 04 2B 7C 4B 42 FF DA 0D 42 EF E0 2D F7 EF 5C 05 62 EF E0 28 D3 EC 04 0B 76 4B 6E FF 60 4E D4 EC 04 0B 50 FF F2 41 D3 EC 04 0B 20 FF CE AE 0D F1 18 0C 9C EC 04 EB 0D F1 78 0C DC EC 04 0B BB FF 4E 87 10 FF F4 A1 FB FF 48 06 00 EF CE CE 0D F1 38 0C 8C EC 04 CB ?? ?? ?? ?? 0D F1 88 0C DC EC 04 6B 0D F1 28 0C DC EC 04 8B 60 EF 58 08 6E FF 66 2E 4C EF 70 41 48 EF E6 0E 26 FF CE EE 40 EF F2 21 0D F1 48 0C CC EC 04 4B 00 EF DE C1 42 EF F4 01 4F F0 00 40 58 FF DA 01 B0 FF E4 A5 02 EF DA 81 16 FF F0 81 ?? ?? ?? ?? 0D F1 28 0C DC EC 04 0B 0D F1 48 0C 9C EC 04 2B 4C EF 5A 61 40 EF 70 01 94 EC 04 0B 4C EF 52 21 60 EF D0 01 50 FF D8 21 46 4B 0D F1 18 0C 9C EC 04 8B 0D F1 28 0C 9C EC 04 CB D3 EC 04 EB 0D F1 A8 0C DC EC 04 0B 48 EF 40 CE 48 EF 6E 4E 50 FF 72 61 0D F1 98 0C 9C EC 04 4B 4C EF 60 2E 6C EF F4 01 B9 FF 4C 67 36 4B 40 EF F2 01 64 FF 46 8E 54 FF 76 01 44 EF F8 21 66 FF 44 AE 50 FF 70 21 0D F1 88 0C 9C EC 04 4B 44 EF FA 01 4C EF FA 41 54 FF 72 01 4C EF F8 21 68 FF 44 AE 54 FF 70 21 0D F1 B8 0C DC EC 04 CB 4C EF 6E 0E 50 FF 72 41 40 EF DE 21 40 EF FA 61 42 EF D2 01 42 EF DA 21 5C FF F4 01 4C EF 40 8E 54 FF 70 21 46 EF D2 01 5E FF F2 01 46 EF DA 21 48 EF FA 61 50 FF 70 21 48 EF DE 01 54 FF 72 01 64 FF 4C 2E 50 FF 70 61 46 EF 40 0E 0C EF 4C 0E F0 FF E0 05 40 EF F2 21 0D F1 38 0C DC EC 04 0B F0 FF E0 05 42 EF F0 41 D3 EC 04 0B 42 EF D2 21 50 FF F6 41 F9 FF E4 07 50 FF F4 21 48 EF 48 0E 52 FF D8 01 10 FF DC 01 4C B0 ?? ?? ?? ?? BD EC 10 8B BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F0 37 18 3F 32 F5 1E 3F D6 FE 25 3F 3E 58 2D 3F F3 04 35 3F A3 08 3D 3F 2A 67 45 3F 8C 24 4E 3F FC 44 57 3F DE CC 60 3F C6 C0 6A 3F 7D 25 75 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D3 C3 11 3F 90 98 CF 32 23 56 E7 32 42 23 C1 32 A1 42 6A 33 0C 58 1F 33 24 FC A8 31 94 2A 6C 33 36 24 A9 31 C3 AA 05 3F C1 95 0B 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_138_85_0 {
	meta:
		name = "?pow_impl@?$VPow@M@@CA?AT__n128@@T2@0@Z"
		size = 1916
		refs = "000c __security_push_cookie 0022 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 006e ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 06e6 __security_pop_cookie 06f4 ?smallx@?$VPow@M@@0T__n128@@B 06f8 ?inf@?$VectorOp@M@@2T__n128@@B 06fc ?bigx@?$VPow@M@@0T__n128@@B 0730 ?q1@?$VPow@M@@0T__n128@@B 0734 ?q2@?$VPow@M@@0T__n128@@B 0738 ?q3@?$VPow@M@@0T__n128@@B 073c ?K@?$VPow@M@@0T__n128@@B 0740 ?p1@?$VPow@M@@0T__n128@@B 0770 ?notExponentMask@?$VectorOp@M@@2T__n128@@B 0774 ?exponentBias@?$VectorOp@M@@2T__n128@@B 0778 ?exponentMask@?$VectorOp@M@@2T__n128@@B"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 2D ED 10 8B ?? ?? ?? ?? B8 B0 20 EF 50 81 9F ED 07 0A 0D F1 48 0C 8C EC 04 2B ?? ?? ?? ?? 60 EF 50 01 9F ED 01 0A 03 E0 00 00 80 3D 00 00 00 00 0D F1 38 0C CC EC 04 0B 8D ED 00 0A ?? ?? ?? ?? 60 EF 50 01 B3 EE 00 0A 0D F1 18 0C CC EC 04 0B 8D ED 01 0A ?? ?? ?? ?? 60 EF 50 01 00 20 0D F1 58 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 C1 01 20 0D F1 68 0C 8C EC 04 CB ?? ?? ?? ?? DF F8 F0 36 20 EF 50 A1 09 20 D3 EC 04 0B DF F8 E0 36 0D F1 28 0C 8C EC 04 AB 48 EF 70 01 E9 FF 70 20 D3 EC 04 0B DF F8 C4 36 22 FF E0 E8 6C EF 60 08 F7 EF 70 25 D3 EC 04 0B 48 EF 70 01 20 EF F2 C1 ?? ?? ?? ?? DF F8 60 36 4F F0 7E 52 CD E9 1E 23 DF F8 50 36 DF F8 28 76 DF F8 20 66 20 93 DF F8 3C 36 DF F8 58 56 DF F8 7C A6 21 93 DF F8 2C 36 DF F8 70 96 A2 F5 00 08 22 93 DF F8 18 36 10 EE 10 2B CD E9 29 76 23 93 DF F8 08 36 CD E9 2B 5A CD E9 2D 98 24 93 DF F8 F4 35 30 EE 10 1B 11 EE 10 0B 25 93 DF F8 E4 35 31 EE 10 4B 26 93 DF F8 D4 35 27 93 DF F8 CC 35 28 93 1E AB 03 EB 82 03 53 F8 04 3C 30 93 1E AB 03 EB 81 03 53 F8 04 3C 31 93 1E AB 03 EB 80 03 53 F8 04 3C 04 20 32 93 1E AB 03 EB 84 03 53 F8 04 3C 33 93 0D F1 C0 0C DC EC 04 0B 00 FF CC 8E 10 FF 5A 81 ?? ?? ?? ?? 4F F0 7E 53 68 EF 40 28 1E 93 DF F8 98 35 CD E9 29 76 12 EE 90 2B 1F 93 DF F8 88 35 CD E9 2B 5A CD E9 2D 98 20 93 DF F8 74 35 32 EE 90 1B 13 EE 90 0B 21 93 DF F8 64 35 33 EE 90 4B 22 93 DF F8 54 35 23 93 DF F8 4C 35 24 93 DF F8 40 35 25 93 DF F8 38 35 26 93 DF F8 2C 35 27 93 DF F8 24 35 28 93 1E AB 03 EB 82 03 53 F8 04 3C 30 93 1E AB 03 EB 81 03 53 F8 04 3C 31 93 1E AB 03 EB 80 03 53 F8 04 3C 32 93 1E AB 03 EB 84 03 53 F8 04 3C 02 20 33 93 0D F1 C0 0C DC EC 04 0B 00 FF CC AE 12 FF D8 A1 ?? ?? ?? ?? 4F F0 7E 53 6A EF 40 28 1E 93 DF F8 F0 34 1F 93 DF F8 E8 34 20 93 DF F8 DC 34 21 93 DF F8 D4 34 22 93 DF F8 C8 34 DF F8 B0 E4 12 EE 90 2B 23 93 DF F8 B8 34 CD E9 28 E7 CD E9 2A 65 24 93 DF F8 A4 34 CD E9 2C A9 CD F8 B8 80 25 93 DF F8 94 34 32 EE 90 1B 13 EE 90 0B 26 93 DF F8 80 34 33 EE 90 4B 27 93 1E AB 03 EB 82 03 53 F8 04 3C 30 93 1E AB 03 EB 81 03 53 F8 04 3C 31 93 1E AB 03 EB 80 03 53 F8 04 3C 32 93 1E AB 03 EB 84 03 53 F8 04 3C CD E9 2A 65 CD E9 28 E7 33 93 4F F0 7E 53 1E 93 DF F8 58 34 0D F1 C0 0C DC EC 04 0B CD E9 2C A9 1F 93 DF F8 44 34 40 FF CC 8E 0D F1 28 0C DC EC 04 0B 20 93 DF F8 2C 34 52 FF DA 81 CD F8 B8 80 21 93 DF F8 1C 34 68 EF E0 28 22 93 DF F8 0C 34 12 EE 90 5B 32 EE 90 6B 23 93 FF 4B 13 EE 90 7B 33 EE 90 EB 24 93 FB 4B 25 93 F9 4B 26 93 F7 4B 27 93 1E AB 03 EB 85 03 53 F8 04 3C 30 93 1E AB 03 EB 86 03 53 F8 04 3C 31 93 1E AB 03 EB 87 03 53 F8 04 3C 32 93 1E AB 03 EB 8E 03 53 F8 04 3C CD E9 2C A9 CD F8 B8 80 33 93 FE 4B 0D F1 C0 0C DC EC 04 0B 30 93 FA 4B 4C EF 60 6D FF FF 72 00 31 93 F6 4B 10 EE 90 2B 32 93 F3 4B 30 EE 90 1B 11 EE 90 0B 33 93 EF 4B 31 EE 90 4B 34 93 EC 4B 35 93 EA 4B 36 93 E8 4B 37 93 30 AB 03 EB 82 03 53 F8 04 3C 02 93 30 AB 03 EB 81 03 53 F8 04 3C 03 93 30 AB 03 EB 80 03 53 F8 04 3C 04 93 30 AB 03 EB 84 03 53 F8 04 3C DA 4C 05 93 4F F0 7E 53 1E 93 D2 4B 2B 94 1F 93 CF 4B 20 93 CD 4B 21 93 CB 4B 22 93 C9 4B 23 93 C7 4B 24 93 C5 4B 25 93 C3 4B 26 93 C1 4B 27 93 BF 4B 28 93 BD 4B 29 93 BB 4B 2A 93 1E AB 03 EB 85 03 53 F8 04 3C 9D ED 00 0A 30 93 1E AB 03 EB 86 03 53 F8 04 3C 31 93 1E AB 03 EB 87 03 53 F8 04 3C 32 93 1E AB 03 EB 8E 03 53 F8 04 3C 33 93 DC EC 04 0B BC 4B 6C EF 60 2D 0D F1 08 0C DC EC 04 0B 62 EF E0 4D FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 44 FF F0 0D 40 EF E0 6D D3 EC 04 0B AF 4B 46 FF F6 2D D3 EC 04 4B 40 FF F2 0D 40 FF F6 2D 44 FF F2 0D 42 EF E0 2D 46 FF F4 0D 42 EF E0 0D 0D F1 18 0C DC EC 04 2B 00 EF E6 AD E4 EF 5E 05 60 FF E8 08 FB FF 60 06 00 FF F2 ED 0D F1 08 0C 8C EC 04 EB ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 0D F1 48 0C DC EC 04 4B 40 FF 74 0D 9D ED 00 0A FB FF 60 07 FB FF 60 06 00 FF D8 CD 64 EF CC 0D 4E FF 70 2D 4A FF 74 0D 00 EF E2 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D 9D ED 00 0A FB FF 60 07 FB FF 60 06 40 FF D8 2D 0D F1 08 0C DC EC 04 0B 2A EF 62 ED 40 FF DC 0D 02 EF E0 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D FB FF 60 07 FB FF 60 06 00 FF D8 CD 6A EF 4C 0D 9D ED 00 0A 0E EF 60 AD ?? ?? ?? ?? 20 EF 50 81 9D ED 01 0A ?? ?? ?? ?? 40 FF 5A 0D 0D F1 58 0C DC EC 04 2B 6D 4B FB FF 60 07 01 20 FB FF 60 06 00 FF D8 ED 4C EF 4E 0D 42 FF F0 0D 6A EF 4E 2D FB FF 60 47 0D F1 38 0C DC EC 04 0B 62 FF E0 6E 0D F1 18 0C DC EC 04 0B 66 EF F6 81 62 EF E0 0D 50 FF F2 81 0D F1 28 0C DC EC 04 2B 64 EF E2 08 50 FF F4 61 0D F1 68 0C DC EC 04 0B 20 EF E6 C3 10 FF F2 C1 FD EF 76 00 66 EF F6 21 E4 FF 70 21 BC EF 72 C1 E4 EF 5C 05 20 FF E6 88 D3 EC 04 0B 4D 4B 40 FF F8 2D D3 EC 04 0B 4A 4B 42 EF E0 0D 40 FF F8 2D D3 EC 04 0B 42 EF E0 0D 00 FF F8 AD ?? ?? ?? ?? 4F F0 7E 53 68 EF 40 08 1E 93 40 4B CD E9 2B 4A CD E9 2D 98 1F 93 3C 4B 10 EE 90 2B 30 EE 90 1B 20 93 38 4B 11 EE 90 0B 31 EE 90 4B 21 93 34 4B 22 93 32 4B 23 93 30 4B 24 93 2E 4B 25 93 2C 4B 26 93 2A 4B 27 93 28 4B 28 93 26 4B 29 93 24 4B 2A 93 1E AB 03 EB 82 03 53 F8 04 3C 02 93 1E AB 03 EB 81 03 53 F8 04 3C 03 93 1E AB 03 EB 80 03 53 F8 04 3C 04 93 1E AB 03 EB 84 03 53 F8 04 3C 05 93 0D F1 08 0C DC EC 04 2B 14 4B 42 FF DA 0D 42 EF E0 2D F7 EF 5C 05 62 EF E0 28 D3 EC 04 0B 0D 4B 6E FF 60 4E D3 EC 04 0B 0A 4B 50 FF F2 41 D3 EC 04 0B 20 FF CE 0E 0D F1 38 0C DC EC 04 0B 10 FF F4 01 38 B0 ?? ?? ?? ?? BD EC 10 8B BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F0 37 18 3F 32 F5 1E 3F D6 FE 25 3F 3E 58 2D 3F F3 04 35 3F A3 08 3D 3F 2A 67 45 3F 8C 24 4E 3F FC 44 57 3F DE CC 60 3F C6 C0 6A 3F 7D 25 75 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D3 C3 11 3F 90 98 CF 32 23 56 E7 32 42 23 C1 32 A1 42 6A 33 0C 58 1F 33 24 FC A8 31 94 2A 6C 33 36 24 A9 31 C3 AA 05 3F C1 95 0B 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_138_87_0 {
	meta:
		name = "?reduce@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 64
		refs = "0012 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 08 8B 20 EF 50 81 9F ED 0B 0A ?? ?? ?? ?? 20 EF 50 A1 B3 EE 00 0A ?? ?? ?? ?? 40 FF 58 0D FB FF 60 07 FB FF 60 06 00 FF DA 0D BD EC 08 8B BD E8 00 88 FE DE 00 00 80 3D }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "??$tan_impl@$00@?$VTan@M@@CA?AT__n128@@T1@0@Z"
		size = 380
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00d8 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0150 ?ind@?$VectorOp@M@@2T__n128@@B 0154 ?inf@?$VectorOp@M@@2T__n128@@B 0158 ?eps@?$VTan@M@@0T__n128@@B 015c ?q0@?$VTan@M@@0T__n128@@B 0160 ?q1@?$VTan@M@@0T__n128@@B 0164 ?q2@?$VTan@M@@0T__n128@@B 0168 ?p1@?$VTan@M@@0T__n128@@B 016c ?c1@?$VTan@M@@0T__n128@@B 0170 ?c2@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 88 B0 20 EF 50 E1 9F ED 59 0A 0D F1 10 0C 8C EC 04 2B ?? ?? ?? ?? 20 EF 50 81 B7 EE 00 0A ?? ?? ?? ?? 60 EF 50 01 9F ED 50 0A CD EC 04 0B 0E FF 58 CD ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C CE FB FF 60 27 44 4B 01 20 F9 FF E2 03 10 FF F2 C1 D3 EC 04 0B 3F 4B FB FF 4C 46 44 FF F0 2D D3 EC 04 0B 3B 4B 44 FF F0 0D 6E EF 60 0D 60 EF E2 8D D3 EC 04 0B 35 4B 48 FF F8 4D 40 FF F4 0D 40 FF F8 0D 40 EF E8 6D D3 EC 04 0B 2F 4B 40 FF F4 2D D3 EC 04 0B 2B 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 27 4B 42 EF E0 2D D3 EC 04 0B 20 FF F8 AE DD EC 04 0B 2A EF 5A 81 18 FF F6 81 10 FF F2 A1 ?? ?? ?? ?? 60 EF 5C 88 F9 FF C8 07 FB FF 4A 25 1A 4B 68 EF F8 61 50 FF D8 61 4A EF 72 0F 42 FF F0 2D 4A EF 72 0F 42 FF F0 0D FB FF 66 25 46 FF F0 4D 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 4A FF 70 0D 50 FF F4 81 0D F1 10 0C DC EC 04 4B D3 EC 04 0B 08 4B 44 EF E4 2E 04 EF E0 0E D3 EC 04 0B 58 FF F4 21 10 FF F2 01 08 B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 83 F9 22 3F }
	condition:
		$1
}

rule file_148_1_0 {
	meta:
		name = "??$tan_impl@$0A@@?$VTan@M@@CA?AT__n128@@T1@0@Z"
		size = 380
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00d8 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0150 ?ind@?$VectorOp@M@@2T__n128@@B 0154 ?inf@?$VectorOp@M@@2T__n128@@B 0158 ?eps@?$VTan@M@@0T__n128@@B 015c ?q0@?$VTan@M@@0T__n128@@B 0160 ?q1@?$VTan@M@@0T__n128@@B 0164 ?q2@?$VTan@M@@0T__n128@@B 0168 ?p1@?$VTan@M@@0T__n128@@B 016c ?c1@?$VTan@M@@0T__n128@@B 0170 ?c2@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 88 B0 20 EF 50 E1 9F ED 59 0A 0D F1 10 0C 8C EC 04 2B ?? ?? ?? ?? 20 EF 50 81 B7 EE 00 0A ?? ?? ?? ?? 60 EF 50 01 9F ED 50 0A CD EC 04 0B 0E FF 58 CD ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C CE FB FF 60 27 44 4B 01 20 F9 FF E2 03 10 FF F2 C1 D3 EC 04 0B 3F 4B FB FF 4C 46 44 FF F0 2D D3 EC 04 0B 3B 4B 44 FF F0 0D 6E EF 60 0D 60 EF E2 8D D3 EC 04 0B 35 4B 48 FF F8 4D 40 FF F4 0D 40 FF F8 0D 40 EF E8 6D D3 EC 04 0B 2F 4B 40 FF F4 2D D3 EC 04 0B 2B 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 27 4B 42 EF E0 2D D3 EC 04 0B 20 FF F8 AE DD EC 04 0B 2A EF 5A 81 18 FF F6 81 10 FF F2 A1 ?? ?? ?? ?? 60 EF 5C 88 F9 FF C8 07 68 EF F8 61 50 FF D8 61 19 4B FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D FB FF 4A 25 4A FF 70 4D 4A EF 72 0F 42 FF F0 2D 4A EF 72 0F 42 FF F0 0D 46 FF F0 0D 50 FF F4 81 0D F1 10 0C DC EC 04 4B D3 EC 04 0B 08 4B 44 EF E4 2E 04 EF E0 0E D3 EC 04 0B 58 FF F4 21 10 FF F2 01 08 B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 83 F9 22 3F }
	condition:
		$1
}

rule file_148_2_0 {
	meta:
		name = "??__E?c1@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?c1@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 00 C9 3F }
	condition:
		$1
}

rule file_148_3_0 {
	meta:
		name = "??__E?c1@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?c1@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 22 F9 3F }
	condition:
		$1
}

rule file_148_4_0 {
	meta:
		name = "??__E?c2@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?c2@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 22 AA FD 39 }
	condition:
		$1
}

rule file_148_5_0 {
	meta:
		name = "??__E?c2@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?c2@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9E E5 9E 4B EF AE D2 BE }
	condition:
		$1
}

rule file_148_6_0 {
	meta:
		name = "??__E?eps1@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps1@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 80 00 }
	condition:
		$1
}

rule file_148_7_0 {
	meta:
		name = "??__E?eps1@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps1@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 6F 28 F4 18 66 1C 73 C0 }
	condition:
		$1
}

rule file_148_24_0 {
	meta:
		name = "??__E?p1@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B8 33 C4 BD }
	condition:
		$1
}

rule file_148_25_0 {
	meta:
		name = "??__E?p1@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 09 4D E5 B5 12 C1 BF }
	condition:
		$1
}

rule file_148_27_0 {
	meta:
		name = "??__E?p2@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? DF AA 3B A6 82 0E 6C 3F }
	condition:
		$1
}

rule file_148_29_0 {
	meta:
		name = "??__E?p3@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p3@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 24 C7 A2 2E B7 BA F2 BE }
	condition:
		$1
}

rule file_148_32_0 {
	meta:
		name = "??__E?q1@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? AF B7 DB BE }
	condition:
		$1
}

rule file_148_33_0 {
	meta:
		name = "??__E?q1@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D5 D9 FB 47 B0 DE DD BF }
	condition:
		$1
}

rule file_148_34_0 {
	meta:
		name = "??__E?q2@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q2@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 75 33 1F 3C }
	condition:
		$1
}

rule file_148_35_0 {
	meta:
		name = "??__E?q2@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 59 21 7E A1 9E 47 9A 3F }
	condition:
		$1
}

rule file_148_37_0 {
	meta:
		name = "??__E?q3@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q3@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 41 48 09 99 64 6F 34 BF }
	condition:
		$1
}

rule file_148_39_0 {
	meta:
		name = "??__E?q4@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q4@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? E9 78 76 F0 74 B7 A0 3E }
	condition:
		$1
}

rule file_148_40_0 {
	meta:
		name = "??__E?ymax@?$VTan@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?ymax@?$VTan@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 08 C9 45 }
	condition:
		$1
}

rule file_148_41_0 {
	meta:
		name = "??__E?ymax@?$VTan@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?ymax@?$VTan@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 54 FB 21 99 41 }
	condition:
		$1
}

rule file_148_49_0 {
	meta:
		name = "?cotan@?$VTan@M@@SA?AT__n128@@T2@@Z"
		size = 428
		refs = "0026 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00de ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 017c ?eps1@?$VTan@M@@0T__n128@@B 0180 ?ind@?$VectorOp@M@@2T__n128@@B 0184 ?inf@?$VectorOp@M@@2T__n128@@B 0188 ?eps@?$VTan@M@@0T__n128@@B 018c ?q0@?$VTan@M@@0T__n128@@B 0190 ?q1@?$VTan@M@@0T__n128@@B 0194 ?q2@?$VTan@M@@0T__n128@@B 0198 ?p1@?$VTan@M@@0T__n128@@B 019c ?c1@?$VTan@M@@0T__n128@@B 01a0 ?c2@?$VTan@M@@0T__n128@@B"
		altNames = "__vdecl_cotanf4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 89 B0 20 EF 50 A1 9F ED 65 0A F9 FF 4A 07 8D EC 04 AB 0D F1 10 0C CC EC 04 0B ?? ?? ?? ?? 20 EF 50 81 B7 EE 00 0A ?? ?? ?? ?? 20 EF 50 E1 9F ED 5A 0A 0A FF 58 CD ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C CE FB FF 60 27 4F 4B 01 20 F9 FF E2 03 10 FF F2 C1 D3 EC 04 0B 4A 4B FB FF 4C 46 44 FF F0 2D D3 EC 04 0B 45 4B 44 FF F0 0D DD EC 04 4B 64 EF E0 0D 60 EF E2 8D D3 EC 04 0B 3F 4B 48 FF F8 4D 40 FF F4 0D 40 FF F8 0D 40 EF E8 6D D3 EC 04 0B 38 4B 40 FF F4 2D D3 EC 04 0B 35 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 30 4B 42 EF E0 2D D3 EC 04 0B 20 FF F8 AE 2A EF 5A 81 18 FF F6 81 1E FF 72 A1 ?? ?? ?? ?? 60 EF 5C 88 F9 FF C8 07 68 EF F8 61 50 FF D8 61 24 4C 22 4B FB FF 66 25 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D FB FF 4A 25 4A FF 70 4D 4A EF 72 0F 42 FF F0 2D 4A EF 72 0F 0D F1 10 0C 9C EC 04 AB 42 FF F0 0D 4A EF 4A 2E 46 FF F0 0D 50 FF F4 81 D4 EC 04 0B 58 FF DA 21 0A EF 60 8E D3 EC 04 0B 4F F0 00 40 10 FF F2 81 ?? ?? ?? ?? DD EC 04 0B 09 4B 40 EF 70 21 D4 EC 04 0B 62 EF F0 21 D3 EC 04 0B 20 FF CA 0E 12 FF D8 01 09 B0 BD EC 10 8B BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 83 F9 22 3F }
	condition:
		$1
}

rule file_148_64_0 {
	meta:
		name = "?intrnd@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 72
		refs = "0012 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 0C 8B 20 EF 50 C1 9F ED 0D 0A ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C 0E FB FF 60 27 F9 FF E2 03 10 FF F2 01 BD EC 0C 8B BD E8 00 88 FE DE 00 00 00 00 }
	condition:
		$1
}

rule file_148_65_0 {
	meta:
		name = "?intrnd_posonly@?$VectorOp@M@@SA?AT__n128@@T2@@Z"
		size = 38
		refs = "0012 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 20 EF 50 81 B6 EE 00 0A ?? ?? ?? ?? 48 EF 40 0D BB FF 60 07 BD EC 04 8B BD E8 00 88 }
	condition:
		$1
}

rule file_148_73_0 {
	meta:
		name = "?tan@?$VTan@M@@SA?AT__n128@@T2@@Z"
		size = 368
		refs = "0014 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00d0 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0144 ?ind@?$VectorOp@M@@2T__n128@@B 0148 ?inf@?$VectorOp@M@@2T__n128@@B 014c ?eps@?$VTan@M@@0T__n128@@B 0150 ?q0@?$VTan@M@@0T__n128@@B 0154 ?q1@?$VTan@M@@0T__n128@@B 0158 ?q2@?$VTan@M@@0T__n128@@B 015c ?p1@?$VTan@M@@0T__n128@@B 0160 ?c1@?$VTan@M@@0T__n128@@B 0164 ?c2@?$VTan@M@@0T__n128@@B"
		altNames = "__vdecl_tanf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 10 8B 84 B0 20 EF 50 E1 9F ED 56 0A ?? ?? ?? ?? 20 EF 50 81 B7 EE 00 0A ?? ?? ?? ?? 60 EF 50 01 9F ED 4F 0A CD EC 04 0B 0E FF 58 CD ?? ?? ?? ?? 20 EF 50 A1 B6 EE 00 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C CE FB FF 60 27 43 4B 01 20 F9 FF E2 03 10 FF F2 C1 D3 EC 04 0B 3E 4B FB FF 4C 46 44 FF F0 2D D3 EC 04 0B 3A 4B 44 FF F0 0D 6E EF 60 0D 60 EF E2 8D D3 EC 04 0B 34 4B 48 FF F8 4D 40 FF F4 0D 40 FF F8 0D 40 EF E8 6D D3 EC 04 0B 2E 4B 40 FF F4 2D D3 EC 04 0B 2A 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 26 4B 42 EF E0 2D D3 EC 04 0B 20 FF F8 AE DD EC 04 0B 2A EF 5A 81 18 FF F6 81 10 FF F2 A1 ?? ?? ?? ?? 60 EF 5C 88 F9 FF C8 07 FB FF 4A 25 19 4B 68 EF F8 61 50 FF D8 61 4A EF 72 0F 42 FF F0 2D 4A EF 72 0F 42 FF F0 0D FB FF 66 25 46 FF F0 4D 46 EF F2 0F 42 FF F0 2D 46 EF F2 0F 42 FF F0 0D 4A FF 70 0D 50 FF F4 81 F9 FF 4E 47 D3 EC 04 0B 08 4B 44 EF E4 2E 04 EF E0 0E D3 EC 04 0B 58 FF F4 21 10 FF F2 01 04 B0 BD EC 10 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 83 F9 22 3F }
	condition:
		$1
}

rule file_151_2_0 {
	meta:
		name = "_RTC_GetErrDesc"
		size = 32
		refs = "000a ?_RTC_errlist@@3QBQBDB"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 28 07 D8 ?? ?? ?? ?? C0 F2 00 03 53 F8 20 00 BD E8 00 88 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_151_4_0 {
	meta:
		name = "_RTC_SetErrorFunc"
		size = 28
		refs = "0006 ?_RTC_ErrorReportFunc@@3P6AHHPBDH00ZZA"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? C0 F2 00 02 03 46 10 68 13 60 00 23 53 60 BD E8 00 88 }
	condition:
		$1
}

rule file_151_5_0 {
	meta:
		name = "_RTC_SetErrorFuncW"
		size = 28
		refs = "0006 ?_RTC_ErrorReportFunc@@3P6AHHPBDH00ZZA"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? C0 F2 00 02 03 46 50 68 53 60 00 23 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_151_6_0 {
	meta:
		name = "_RTC_SetErrorType"
		size = 40
		refs = "000c ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 46 04 2A 09 D8 ?? ?? ?? ?? C0 F2 00 03 53 F8 20 00 43 F8 22 10 BD E8 00 88 6F F0 00 00 BD E8 00 88 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "??__E?c1@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "0008 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?c1@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? 00 10 49 40 }
	condition:
		$1
}

rule file_153_1_0 {
	meta:
		name = "??__E?c1@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 0018 ?c1@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 49 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 22 09 40 }
	condition:
		$1
}

rule file_153_2_0 {
	meta:
		name = "??__E?c2@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?c2@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 7A 77 15 B7 }
	condition:
		$1
}

rule file_153_3_0 {
	meta:
		name = "??__E?c2@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?c2@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9E E5 9E 4B EF AE E2 BE }
	condition:
		$1
}

rule file_153_5_0 {
	meta:
		name = "??__E?eps@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? CD 3B 7F 66 9E A0 46 3E }
	condition:
		$1
}

rule file_153_10_0 {
	meta:
		name = "??__E?half@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?half@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B6 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_31_0 {
	meta:
		name = "??__E?q0@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q0@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B6 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_11_0 {
	meta:
		name = "??__E?half@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?half@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B6 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_32_0 {
	meta:
		name = "??__E?q0@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q0@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B6 EE 00 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_22_0 {
	meta:
		name = "??__E?r1@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r1@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? A4 AA 2A BE }
	condition:
		$1
}

rule file_153_23_0 {
	meta:
		name = "??__E?r1@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r1@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 55 55 55 55 55 55 C5 BF }
	condition:
		$1
}

rule file_153_24_0 {
	meta:
		name = "??__E?r2@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r2@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 3E 87 08 3C }
	condition:
		$1
}

rule file_153_25_0 {
	meta:
		name = "??__E?r2@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r2@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B0 10 11 11 11 11 81 3F }
	condition:
		$1
}

rule file_153_26_0 {
	meta:
		name = "??__E?r3@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r3@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 22 B2 4F B9 }
	condition:
		$1
}

rule file_153_27_0 {
	meta:
		name = "??__E?r3@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r3@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1A 3E 01 1A A0 01 2A BF }
	condition:
		$1
}

rule file_153_28_0 {
	meta:
		name = "??__E?r4@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?r4@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 5B 9C 2E 36 }
	condition:
		$1
}

rule file_153_29_0 {
	meta:
		name = "??__E?r4@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r4@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 63 F0 24 A5 E3 1D C7 3E }
	condition:
		$1
}

rule file_153_31_0 {
	meta:
		name = "??__E?r5@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r5@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? AB C0 5D 4B 45 E6 5A BE }
	condition:
		$1
}

rule file_153_33_0 {
	meta:
		name = "??__E?r6@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r6@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 30 D4 6A 68 3C 12 E6 3D }
	condition:
		$1
}

rule file_153_35_0 {
	meta:
		name = "??__E?r7@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r7@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 9C 49 08 DC 20 E4 6A BD }
	condition:
		$1
}

rule file_153_37_0 {
	meta:
		name = "??__E?r8@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?r8@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 95 DF 93 69 FF 80 E8 3C }
	condition:
		$1
}

rule file_153_38_0 {
	meta:
		name = "??__E?sign_mask@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0018 ?sign_mask@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 4F F0 00 40 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_39_0 {
	meta:
		name = "??__E?sign_mask@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000c ?create@?$VectorOp@N@@SA?AT__n128@@_K@Z 001c ?sign_mask@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 4F F0 00 61 00 20 ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_40_0 {
	meta:
		name = "??__E?ymax@?$VSin@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?ymax@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? DB 0F 49 46 }
	condition:
		$1
}

rule file_153_41_0 {
	meta:
		name = "??__E?ymax@?$VSin@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?ymax@?$VSin@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? E1 62 DD 1A 83 C5 B1 41 }
	condition:
		$1
}

rule file_153_48_0 {
	meta:
		name = "?cos@?$VSin@M@@SA?AT__n128@@T2@@Z"
		size = 328
		refs = "0016 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0058 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0114 ?ind@?$VectorOp@M@@2T__n128@@B 0118 ?inf@?$VectorOp@M@@2T__n128@@B 011c ?eps@?$VSin@M@@0T__n128@@B 0120 ?r1@?$VSin@M@@0T__n128@@B 0124 ?r2@?$VSin@M@@0T__n128@@B 0128 ?r3@?$VSin@M@@0T__n128@@B 012c ?r4@?$VSin@M@@0T__n128@@B 0130 ?c1@?$VSin@M@@0T__n128@@B 0134 ?c2@?$VSin@M@@0T__n128@@B 0138 ?half@?$VSin@M@@0T__n128@@B 0140 ?one@?$VSin@M@@0T__n128@@B"
		altNames = "__vdecl_cosf4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 89 B0 20 EF 50 81 9F ED 4C 0A ?? ?? ?? ?? F9 FF 48 07 48 4B 00 EF C0 8D 9F ED 45 0A 93 EC 04 EB 0D F1 10 0C 8C EC 04 8B CD EC 04 0B ?? ?? ?? ?? 3E 4C 48 FF 50 2D 01 20 D4 EC 04 0B B9 FF CE 87 42 EF E0 0D BB FF 60 A7 BB FF 4A C6 ?? ?? ?? ?? D4 EC 04 0B DD EC 04 6B 0D F1 10 0C DC EC 04 AB 31 4B 6C EF 60 0D 46 EF EA 4E 60 EF 5A 88 5C FF 70 41 58 FF 5E 81 D3 EC 04 0B 2A 4B 44 FF F0 2D D3 EC 04 0B 26 4B 44 FF F0 0D 66 EF E0 0D 60 EF E2 6D D3 EC 04 0B 21 4B 46 FF F6 4D 40 FF F4 2D D3 EC 04 0B 1C 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 18 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 13 4B 42 EF E0 0D 40 FF F4 0D 46 FF F0 0D 46 EF E0 2D D3 EC 04 0B 0D 4B 60 FF F6 0E 56 FF F2 01 4A EF EA 2E 40 FF F8 0D 50 FF FA 21 D3 EC 04 0B 05 4B 0A EF E0 0E D3 EC 04 0B 10 FF F2 01 09 B0 BD EC 10 8B BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 F9 A2 3E ?? ?? ?? ?? DB 0F C9 3F }
	condition:
		$1
}

rule file_153_65_0 {
	meta:
		name = "?sin@?$VSin@M@@SA?AT__n128@@T2@@Z"
		size = 312
		refs = "002e ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 004e ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 0104 ?ind@?$VectorOp@M@@2T__n128@@B 0108 ?inf@?$VectorOp@M@@2T__n128@@B 010c ?eps@?$VSin@M@@0T__n128@@B 0110 ?r1@?$VSin@M@@0T__n128@@B 0114 ?r2@?$VSin@M@@0T__n128@@B 0118 ?r3@?$VSin@M@@0T__n128@@B 011c ?r4@?$VSin@M@@0T__n128@@B 0120 ?c1@?$VSin@M@@0T__n128@@B 0124 ?c2@?$VSin@M@@0T__n128@@B 0128 ?half@?$VSin@M@@0T__n128@@B 0130 ?one@?$VSin@M@@0T__n128@@B 0134 ?sign_mask@?$VSin@M@@0T__n128@@B"
		altNames = "__vdecl_sinf4"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 85 B0 49 4B B9 FF 40 87 D3 EC 04 0B 45 4B 8D EC 04 8B 40 EF 70 21 D3 EC 04 0B 9F ED 41 0A 22 EF F0 E1 ?? ?? ?? ?? 3D 4C 48 FF 50 2D 01 20 D4 EC 04 0B B9 FF CE 87 42 EF E0 0D BB FF 60 A7 BB FF 4A C6 ?? ?? ?? ?? D4 EC 04 0B DD EC 04 AB 32 4B 6C EF 60 0D 4A EF EA 4E 60 EF 5A 88 5C FF 70 41 58 FF 5E 81 D3 EC 04 0B 2A 4B 44 FF F0 2D D3 EC 04 0B 27 4B 44 FF F0 0D 6A EF E0 0D 60 EF E2 6D D3 EC 04 0B 21 4B 46 FF F6 4D 40 FF F4 2D D3 EC 04 0B 1D 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 18 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 14 4B 42 EF E0 0D 40 FF F4 0D 46 FF F0 0D 46 EF E0 2D D3 EC 04 0B 0D 4B 60 FF F6 0E 56 FF F2 01 4A EF EA 2E 40 FF F8 0D 50 FF FA 21 D3 EC 04 0B 06 4B 0A EF E0 0E D3 EC 04 0B 10 FF F2 01 05 B0 BD EC 10 8B BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 F9 A2 3E ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_66_0 {
	meta:
		name = "?sincos@?$VSin@M@@CA?AT__n128@@T2@00@Z"
		size = 312
		refs = "0026 ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 004e ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 010c ?ind@?$VectorOp@M@@2T__n128@@B 0110 ?inf@?$VectorOp@M@@2T__n128@@B 0114 ?eps@?$VSin@M@@0T__n128@@B 0118 ?r1@?$VSin@M@@0T__n128@@B 011c ?r2@?$VSin@M@@0T__n128@@B 0120 ?r3@?$VSin@M@@0T__n128@@B 0124 ?r4@?$VSin@M@@0T__n128@@B 0128 ?c1@?$VSin@M@@0T__n128@@B 012c ?c2@?$VSin@M@@0T__n128@@B 0130 ?half@?$VSin@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 89 B0 20 EF 50 81 9F ED 48 0A 22 EF 52 A1 24 EF 54 E1 0D F1 10 0C 8C EC 04 AB ?? ?? ?? ?? 41 4C 4A FF 50 2D 01 20 D4 EC 04 0B 42 EF E0 0D BB FF 60 A7 F9 FF 48 07 BB FF 4A C6 B9 FF CE 87 CD EC 04 0B ?? ?? ?? ?? 60 EF 5A 88 D4 EC 04 0B DD EC 04 6B 0D F1 10 0C DC EC 04 AB 31 4B 6C EF 60 0D 46 EF EA 4E 58 FF 5E 81 5C FF 70 41 D3 EC 04 0B 2A 4B 44 FF F0 2D D3 EC 04 0B 27 4B 44 FF F0 0D 66 EF E0 0D 60 EF E2 6D D3 EC 04 0B 21 4B 46 FF F6 4D 40 FF F4 2D D3 EC 04 0B 1D 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 18 4B 42 EF E0 0D 40 FF F4 2D D3 EC 04 0B 14 4B 42 EF E0 0D 40 FF F4 0D 46 FF F0 0D 46 EF E0 2D D3 EC 04 0B 0D 4B 60 FF F6 0E 56 FF F2 01 4A EF EA 2E 40 FF F8 0D 50 FF FA 21 D3 EC 04 0B 06 4B 0A EF E0 0E D3 EC 04 0B 10 FF F2 01 09 B0 BD EC 10 8B BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 F9 A2 3E }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "_get_startup_file_mode"
		size = 22
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 4F F4 80 43 00 93 00 98 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "??3@YAXPAX@Z"
		size = 26
		refs = "000e _free_dbg"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 6F F0 00 01 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__rt_srsh"
		size = 58
	strings:
		$1 = { 00 2A 08 BF 70 47 20 2A 0C DB 40 2A 03 DB 4F EA 21 01 08 46 70 47 02 F0 1F 02 41 FA 02 F0 4F EA 21 01 70 47 20 FA 02 F0 C2 F1 20 03 01 FA 03 F3 40 EA 03 00 41 FA 02 F1 70 47 }
	condition:
		$1
}

rule file_170_1_0 {
	meta:
		name = "?__scrt_uninitialize_type_info@@YAXXZ"
		size = 20
		refs = "0008 __std_type_info_destroy_list 0010 ?__type_info_root_node@@3U__type_info_node@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1304_6_6 {
	meta:
		name = "??__E_Fac_tidy_reg@std@@YAXXZ"
		size = 20
		refs = "0008 atexit 0010 ??__F_Fac_tidy_reg@std@@YAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_1_2 {
	meta:
		name = "??__Einit_atexit@@YAXXZ"
		size = 20
		refs = "0008 atexit 0010 ??__Finit_atexit@@YAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_164_1 {
	meta:
		name = "??__Einit_cerr@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_cerr@std@@QAA@XZ 0010 ?init_cerr@std@@3U_Init_cerr@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_190_2 {
	meta:
		name = "??__Einit_cin@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_cin@std@@QAA@XZ 0010 ?init_cin@std@@3U_Init_cin@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_164_1 {
	meta:
		name = "??__Einit_clog@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_clog@std@@QAA@XZ 0010 ?init_clog@std@@3U_Init_clog@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_164_1 {
	meta:
		name = "??__Einit_cout@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_cout@std@@QAA@XZ 0010 ?init_cout@std@@3U_Init_cout@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_160_1 {
	meta:
		name = "??__Einit_ushcerr@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_ushcerr@std@@QAA@XZ 0010 ?init_ushcerr@std@@3U_Init_ushcerr@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_206_3 {
	meta:
		name = "??__Einit_ushcin@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_ushcin@std@@QAA@XZ 0010 ?init_ushcin@std@@3U_Init_ushcin@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_206_3 {
	meta:
		name = "??__Einit_ushclog@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_ushclog@std@@QAA@XZ 0010 ?init_ushclog@std@@3U_Init_ushclog@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_160_1 {
	meta:
		name = "??__Einit_ushcout@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_ushcout@std@@QAA@XZ 0010 ?init_ushcout@std@@3U_Init_ushcout@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_160_1 {
	meta:
		name = "??__Einit_wcerr@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_wcerr@std@@QAA@XZ 0010 ?init_wcerr@std@@3U_Init_wcerr@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_186_2 {
	meta:
		name = "??__Einit_wcin@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_wcin@std@@QAA@XZ 0010 ?init_wcin@std@@3U_Init_wcin@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_160_1 {
	meta:
		name = "??__Einit_wclog@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_wclog@std@@QAA@XZ 0010 ?init_wclog@std@@3U_Init_wclog@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_160_1 {
	meta:
		name = "??__Einit_wcout@std@@YAXXZ"
		size = 20
		refs = "0008 ??0_Init_wcout@std@@QAA@XZ 0010 ?init_wcout@std@@3U_Init_wcout@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_71_2 {
	meta:
		name = "??__F?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A@@YAXXZ"
		size = 20
		refs = "0008 ??1?$shared_ptr@V__ExceptionPtr@@@std@@QAA@XZ 0010 ?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_39_1 {
	meta:
		name = "??__F_Fac_tidy_reg@std@@YAXXZ"
		size = 20
		refs = "0008 ??1_Fac_tidy_reg_t@std@@QAA@XZ 0010 ?_Fac_tidy_reg@std@@3U_Fac_tidy_reg_t@1@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_91_1 {
	meta:
		name = "??__F_Static@?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAAV_Generic_error_category@0@XZ@YAXXZ"
		size = 20
		refs = "0008 ??1?$_Immortalizer@V_Generic_error_category@std@@@std@@QAA@XZ 0010 ?_Static@?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAAV_Generic_error_category@1@XZ@4U?$_Immortalizer@V_Generic_error_category@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_199_3 {
	meta:
		name = "??__F_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ@YAXXZ"
		size = 20
		refs = "0008 ??1?$_Immortalizer@V_Iostream_error_category@std@@@std@@QAA@XZ 0010 ?_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@1@XZ@4U?$_Immortalizer@V_Iostream_error_category@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_92_1 {
	meta:
		name = "??__F_Static@?1???$_Immortalize@V_System_error_category@std@@@std@@YAAAV_System_error_category@0@XZ@YAXXZ"
		size = 20
		refs = "0008 ??1?$_Immortalizer@V_System_error_category@std@@@std@@QAA@XZ 0010 ?_Static@?1???$_Immortalize@V_System_error_category@std@@@std@@YAAAV_System_error_category@1@XZ@4U?$_Immortalizer@V_System_error_category@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_167_1 {
	meta:
		name = "??__Fcerr@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAAXXZ 0010 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_167_1 {
	meta:
		name = "??__Fcin@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QAAXXZ 0010 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_40_1 {
	meta:
		name = "??__Fclassic_locale@std@@YAXXZ"
		size = 20
		refs = "0008 ??1locale@std@@QAA@XZ 0010 ?classic_locale@std@@3Vlocale@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_193_2 {
	meta:
		name = "??__Fclog@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAAXXZ 0010 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_193_2 {
	meta:
		name = "??__Fcout@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAAXXZ 0010 ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_194_2 {
	meta:
		name = "??__Fferr@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAA@XZ 0010 ?ferr@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_201_3 {
	meta:
		name = "??__Ffin@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAA@XZ 0010 ?fin@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_194_2 {
	meta:
		name = "??__Fflog@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAA@XZ 0010 ?flog@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_168_1 {
	meta:
		name = "??__Ffout@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAA@XZ 0010 ?fout@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_3_3 {
	meta:
		name = "??__Finit_atexit@@YAXXZ"
		size = 20
		refs = "0008 ??1_Init_atexit@@QAA@XZ 0010 ?init_atexit@@3U_Init_atexit@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_202_3 {
	meta:
		name = "??__Finitlocks@@YAXXZ"
		size = 20
		refs = "0008 ??1_Init_locks@std@@QAA@XZ 0010 ?initlocks@@3V_Init_locks@std@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_4_2 {
	meta:
		name = "??__Finitlocks@std@@YAXXZ"
		size = 20
		refs = "0008 ??1_Init_locks@std@@QAA@XZ 0010 ?initlocks@std@@3V_Init_locks@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_166_1 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAXXZ 0010 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_192_2 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAXXZ 0010 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_192_2 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAXXZ 0010 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_166_1 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAXXZ 0010 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_192_2 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QAAXXZ 0010 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_166_1 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAAXXZ 0010 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_212_3 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QAAXXZ 0010 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_192_2 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAAXXZ 0010 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_166_1 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QAAXXZ 0010 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_212_3 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAAXXZ 0010 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_166_1 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAXXZ 0010 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_192_2 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAXXZ 0010 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_212_3 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAXXZ 0010 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_212_3 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAXXZ 0010 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_166_1 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 20
		refs = "0008 ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAXXZ 0010 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_193_2 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_213_3 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_213_3 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_193_2 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_167_1 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_167_1 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_193_2 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_213_3 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_213_3 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_193_2 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_167_1 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_193_2 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_193_2 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_213_3 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_167_1 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_193_2 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_193_2 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 0010 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_213_3 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 20
		refs = "0008 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0010 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_176_2_0 {
	meta:
		name = "_RTC_InitBase"
		size = 48
		refs = "0008 ?init@?1??_RTC_InitBase@@9@4_NA 0024 _CRT_RTC_INITW 0028 _RTC_SetErrorFuncW"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B ?? ?? ?? ?? C0 F2 00 02 13 78 5B B9 01 23 13 70 00 23 00 93 01 23 00 22 00 21 00 20 ?? ?? ?? ?? ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_176_3_0 {
	meta:
		name = "_RTC_Shutdown"
		size = 26
		refs = "0012 _CRT_RTC_INITW"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 01 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "_guard_check_icall_nop"
		size = 16
		altNames = "??$destroy@PAD@?$allocator@D@std@@QAAXPAPAD@Z ??$destroy@PAG@?$allocator@G@std@@QAAXPAPAG@Z ??$destroy@PA_W@?$allocator@_W@std@@QAAXPAPA_W@Z ??$destroy@U_Container_proxy@std@@@?$allocator@U_Container_proxy@std@@@std@@QAAXPAU_Container_proxy@1@@Z ??1?$_Immortalizer@V_Generic_error_category@std@@@std@@QAA@XZ ??1?$_Immortalizer@V_Iostream_error_category@std@@@std@@QAA@XZ ??1?$_Immortalizer@V_System_error_category@std@@@std@@QAA@XZ ??1_Bxty@?$_String_val@U?$_Simple_types@D@std@@@std@@QAA@XZ ??1_Bxty@?$_String_val@U?$_Simple_types@G@std@@@std@@QAA@XZ ??1_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAA@XZ ??1_Iterator_base12@std@@QAA@XZ ??3@YAXPAX0@Z ?ReportUnhandledError@_ExceptionHolder@details@Concurrency@@AAAXXZ ?_Adopt@_Iterator_base0@std@@QAAXPBX@Z ?_Assign@_ContextCallback@details@Concurrency@@AAAXPAX@Z ?_Capture@_ContextCallback@details@Concurrency@@AAAXXZ ?_Compat@?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAXABV12@@Z ?_Compat@?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAXABV12@@Z ?_Compat@?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAXABV12@@Z ?_Deprecate@_Unchecked_iterators@?1???$copy@PADV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@PAD0V32@@Z@SAXU?$integral_constant@_N$00@2@@Z ?_Deprecate@_Unchecked_iterators@?1???$copy@PA_WV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@PA_W0V32@@Z@SAXU?$integral_constant@_N$00@2@@Z ?_Deprecate@_Unchecked_iterators@?1???$copy@PA_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@PA_W0V32@@Z@SAXU?$integral_constant@_N$00@2@@Z ?_Enable_shared@std@@YAXPDX0@Z ?_Init@?$codecvt@DDU_Mbstatet@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$messages@D@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$messages@G@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$messages@_W@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Init@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z ?_Lock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAAXXZ ?_Lock@?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAAXXZ ?_Lock@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAAXXZ ?_LogCancelTask@_TaskEventLogger@details@Concurrency@@QAAXXZ ?_LogScheduleTask@_TaskEventLogger@details@Concurrency@@QAAX_N@Z ?_LogTaskCompleted@_TaskEventLogger@details@Concurrency@@QAAXXZ ?_LogTaskExecutionCompleted@_TaskEventLogger@details@Concurrency@@QAAXXZ ?_LogWorkItemCompleted@_TaskEventLogger@details@Concurrency@@QAAXXZ ?_LogWorkItemStarted@_TaskEventLogger@details@Concurrency@@QAAXXZ ?_Orphan_all@_Container_base12@std@@QAAXXZ ?_Reset@_ContextCallback@details@Concurrency@@AAAXXZ ?_Swap_all@_Container_base0@std@@QAAXAAU12@@Z ?_Unlock@?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAAXXZ ?_Unlock@?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAAXXZ ?_Unlock@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAAXXZ ?__empty_global_delete@@YAXPAX@Z ?__empty_global_delete@@YAXPAXI@Z ?destroy@stl_condition_variable_vista@details@Concurrency@@UAAXXZ ?destroy@stl_condition_variable_win7@details@Concurrency@@UAAXXZ ?destroy@stl_critical_section_win7@details@Concurrency@@UAAXXZ ?do_close@?$messages@D@std@@MBAXH@Z ?do_close@?$messages@G@std@@MBAXH@Z ?do_close@?$messages@_W@std@@MBAXH@Z ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAAXABVlocale@2@@Z ?imbue@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAAXABVlocale@2@@Z ?imbue@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAAXABVlocale@2@@Z __telemetry_main_invoke_trigger __telemetry_main_return_trigger __vcrt_uninitialize_winapi_thunks"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_178_1_0 {
	meta:
		name = "_guard_icall_checks_enforced"
		size = 56
		refs = "0030 _guard_check_icall_nop 0034 __guard_check_icall_fptr"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 0A 4B 1B 68 01 93 BF F3 5B 8F 01 9A 06 4B 9A 42 02 D0 01 23 00 93 01 E0 00 23 00 93 00 9B 02 93 02 98 04 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "__scrt_is_user_matherr_present"
		size = 44
		refs = "0028 __scrt_default_matherr"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 07 4B 1B 68 00 2B 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B 01 93 01 98 02 B0 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_183_7_0 {
	meta:
		name = "?get_app_type@__scrt_winmain_policy@@SA?AW4_crt_app_type@@XZ"
		size = 20
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 23 00 93 00 98 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_183_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 56
		refs = "0008 __scrt_get_show_window_mode 0010 _get_wide_winmain_command_line 0020 wWinMain 0034 __ImageBase"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 ?? ?? ?? ?? AD F8 00 00 ?? ?? ?? ?? 01 90 BD F8 00 30 01 9A 00 21 05 48 ?? ?? ?? ?? 02 90 02 9B 03 93 03 98 04 B0 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_221_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 56
		refs = "0008 __scrt_get_show_window_mode 0010 _get_narrow_winmain_command_line 0020 WinMain 0034 __ImageBase"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 ?? ?? ?? ?? AD F8 00 00 ?? ?? ?? ?? 01 90 BD F8 00 30 01 9A 00 21 05 48 ?? ?? ?? ?? 02 90 02 9B 03 93 03 98 04 B0 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "DllMain"
		size = 26
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 01 23 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "__security_check_cookie"
		size = 20
		refs = "0010 __security_cookie"
	strings:
		$1 = { DF F8 0C C0 DC F8 00 C0 60 45 03 D1 70 47 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "_RTC_Check_2_to_1"
		size = 42
		refs = "001a ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 10 F4 7F 43 09 D0 B3 F5 7F 4F 03 D0 03 98 01 21 ?? ?? ?? ?? 60 B2 BD E8 18 88 60 B2 BD E8 18 88 }
	condition:
		$1
}

rule file_199_1_0 {
	meta:
		name = "_RTC_Check_4_to_1"
		size = 42
		refs = "001a ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 30 F0 FF 03 09 D0 13 F5 80 7F 03 D0 03 98 01 21 ?? ?? ?? ?? 60 B2 BD E8 18 88 60 B2 BD E8 18 88 }
	condition:
		$1
}

rule file_199_2_0 {
	meta:
		name = "_RTC_Check_4_to_2"
		size = 44
		refs = "001c ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 03 46 6F F3 0F 03 04 46 4B B1 13 F5 80 3F 03 D0 03 98 01 21 ?? ?? ?? ?? 20 B2 BD E8 18 88 20 B2 BD E8 18 88 }
	condition:
		$1
}

rule file_199_3_0 {
	meta:
		name = "_RTC_Check_8_to_1"
		size = 52
		refs = "0024 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 20 F0 FF 02 52 EA 01 03 04 46 0C D0 12 F5 80 7F 02 D1 B1 F1 FF 3F 03 D0 03 98 01 21 ?? ?? ?? ?? 60 B2 BD E8 18 88 60 B2 BD E8 18 88 }
	condition:
		$1
}

rule file_199_4_0 {
	meta:
		name = "_RTC_Check_8_to_2"
		size = 54
		refs = "0026 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 02 46 6F F3 0F 02 52 EA 01 03 04 46 0C D0 12 F5 80 3F 02 D1 B1 F1 FF 3F 03 D0 03 98 01 21 ?? ?? ?? ?? 20 B2 BD E8 18 88 20 B2 BD E8 18 88 }
	condition:
		$1
}

rule file_199_5_0 {
	meta:
		name = "_RTC_Check_8_to_4"
		size = 40
		refs = "0018 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 0B 00 09 D0 B1 F1 FF 3F 03 D0 03 98 01 21 ?? ?? ?? ?? 20 46 BD E8 18 88 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_200_7_0 {
	meta:
		name = "??__E?eps@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?eps@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 33 }
	condition:
		$1
}

rule file_200_8_0 {
	meta:
		name = "??__E?eps@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?eps@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 00 00 00 00 00 00 90 3C }
	condition:
		$1
}

rule file_200_17_0 {
	meta:
		name = "??__E?inv_ln2@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?inv_ln2@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 3B AA B8 3F }
	condition:
		$1
}

rule file_200_18_0 {
	meta:
		name = "??__E?inv_ln2@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?inv_ln2@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? FE 82 2B 65 47 15 F7 3F }
	condition:
		$1
}

rule file_200_19_0 {
	meta:
		name = "??__E?ln2@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?ln2@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 18 72 31 3F }
	condition:
		$1
}

rule file_200_25_0 {
	meta:
		name = "??__E?p0@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 28
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p0@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 B5 EE 00 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_26_0 {
	meta:
		name = "??__E?p0@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p0@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 82 25 B6 FE FF FF CF 3F }
	condition:
		$1
}

rule file_200_27_0 {
	meta:
		name = "??__E?p1@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?p1@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 08 53 88 3B }
	condition:
		$1
}

rule file_200_28_0 {
	meta:
		name = "??__E?p1@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p1@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? E0 F6 B3 6F E4 70 7C 3F }
	condition:
		$1
}

rule file_200_30_0 {
	meta:
		name = "??__E?p2@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?p2@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 1C DC 58 6F A4 52 F1 3E }
	condition:
		$1
}

rule file_200_33_0 {
	meta:
		name = "??__E?q1@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?q1@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 5B BF 4C 3D }
	condition:
		$1
}

rule file_200_34_0 {
	meta:
		name = "??__E?q1@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q1@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? B3 51 42 71 8E 71 AC 3F }
	condition:
		$1
}

rule file_200_36_0 {
	meta:
		name = "??__E?q2@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?q2@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 09 38 DE 6F 99 3F 40 3F }
	condition:
		$1
}

rule file_200_37_0 {
	meta:
		name = "??__E?smallx@?$VExp@M@@0T__n128@@B@@YAXXZ"
		size = 32
		refs = "000a ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 0018 ?smallx@?$VExp@M@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0A ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? 50 AC AE C2 }
	condition:
		$1
}

rule file_200_38_0 {
	meta:
		name = "??__E?smallx@?$VExp@N@@0T__n128@@B@@YAXXZ"
		size = 36
		refs = "000a ?create@?$VectorOp@N@@SA?AT__n128@@N@Z 0018 ?smallx@?$VExp@N@@0T__n128@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 05 0B ?? ?? ?? ?? 02 4B 83 EC 04 0B BD E8 00 88 ?? ?? ?? ?? D2 BC 7A DD 2B 23 86 C0 }
	condition:
		$1
}

rule file_200_60_0 {
	meta:
		name = "?exp@?$VExp@M@@SA?AT__n128@@T2@@Z"
		size = 396
		refs = "001c ?create@?$VectorOp@M@@SA?AT__n128@@M@Z 00f8 ?create@?$VectorOp@M@@SA?AT__n128@@I@Z 015c ?eps@?$VExp@M@@0T__n128@@B 0160 ?smallx@?$VExp@M@@0T__n128@@B 0164 ?inf@?$VectorOp@M@@2T__n128@@B 0168 ?bigx@?$VExp@M@@0T__n128@@B 016c ?q0@?$VExp@M@@0T__n128@@B 0170 ?q1@?$VExp@M@@0T__n128@@B 0174 ?p0@?$VExp@M@@0T__n128@@B 0178 ?p1@?$VExp@M@@0T__n128@@B 017c ?C1@?$VExp@M@@0T__n128@@B 0180 ?C2@?$VExp@M@@0T__n128@@B 0184 ?inv_ln2@?$VExp@M@@0T__n128@@B"
		altNames = "__vdecl_expf4"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 0E 8B 8C B0 9F ED 5E 8A 20 EF 50 A1 8D EC 04 AB B0 EE 48 0A ?? ?? ?? ?? 60 EF 50 01 B7 EE 00 0A 0D F1 10 0C CC EC 04 0B ?? ?? ?? ?? 53 4B 60 EF 50 01 0D F1 20 0C CC EC 04 0B D3 EC 04 0B B0 EE 48 0A 0A FF 70 CD ?? ?? ?? ?? B6 EE 00 EA 20 EF 50 A1 B0 EE 4E 0A B9 FF 4C 87 ?? ?? ?? ?? 48 EF 40 0D 2A FF 4C AE FB FF 60 27 43 4B 9D EC 04 CB B0 EE 4E 0A F9 FF E2 03 10 FF F2 A1 D3 EC 04 0B 3C 4B FB FF 4A 46 44 FF F0 2D D3 EC 04 0B 38 4B 44 FF F0 0D 6C EF 60 0D 60 EF E2 4D D3 EC 04 0B 32 4B 44 FF F4 6D 46 FF F0 2D D3 EC 04 0B 2E 4B 42 EF E0 0D 40 FF F4 8D D3 EC 04 0B 29 4B 46 FF F0 2D D3 EC 04 0B 42 EF E0 0D 60 EF E8 4D FB FF 64 25 44 EF F2 0F 42 FF F0 2D 44 EF F2 0F 42 FF F0 0D 08 FF F0 8D ?? ?? ?? ?? 01 20 00 EF 48 8D ?? ?? ?? ?? 6A EF 40 08 19 4B F7 EF 70 05 68 EF 60 28 D3 EC 04 0B 15 4B 6C FF 60 4E D3 EC 04 0B 11 4B 50 FF F2 41 D3 EC 04 0B 0E 4B 60 FF CC 2E 0D F1 10 0C DC EC 04 0B 50 FF F4 21 D3 EC 04 0B 0D F1 20 0C DC EC 04 4B 60 FF DC 0E 54 FF F2 01 0C EF 4C 0E 10 FF DC 01 0C B0 BD EC 0E 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "__guard_check_icall_thunk"
		size = 20
		refs = "0004 __guard_check_icall_fptr"
	strings:
		$1 = { 2D E9 0F 50 ?? ?? ?? ?? C0 F2 00 01 09 68 88 47 BD E8 0F 90 }
	condition:
		$1
}

rule file_215_1_0 {
	meta:
		name = "__security_pop_cookie"
		size = 28
		refs = "0000 __security_cookie"
	strings:
		$1 = { ?? ?? ?? ?? C0 F2 00 0C 00 9B DC F8 00 C0 AD EB 03 03 63 45 01 D1 01 B0 70 47 18 46 }
	condition:
		$1
}

rule file_215_2_0 {
	meta:
		name = "__ppgsfailure"
		size = 24
		refs = "000c __security_check_cookie"
	strings:
		$1 = { 10 B5 6C 46 EC 46 2C F0 07 0C E5 46 ?? ?? ?? ?? A5 46 BD E8 10 40 70 47 }
	condition:
		$1
}

rule file_219_1_0 {
	meta:
		name = "??__D@YAXPAX0IIP6AX00@ZP6AX0@Z@Z"
		size = 114
		refs = "0032 _guard_check_icall 0064 ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 48 0D F1 10 0B 84 B0 6F 46 00 23 7B 60 00 23 3B 70 02 E0 7B 68 5B 1C 7B 60 7A 68 7B 6B 9A 42 15 D0 01 26 FD 6A BC 6A BB 6B BB 60 B8 68 ?? ?? ?? ?? BB 68 20 46 29 46 32 46 98 47 BA 6A 3B 6B 13 44 BB 62 FA 6A 3B 6B 13 44 FB 62 E2 E7 01 23 3B 70 3B 78 00 2B 05 D1 FB 6B 7A 68 39 6B B8 6A ?? ?? ?? ?? 04 B0 BD E8 F0 08 5D F8 14 FB }
	condition:
		$1
}

rule file_219_2_0 {
	meta:
		name = "?fin$0@?0???__D@YAXPAX0IIP6AX00@ZP6AX0@Z@Z@4HA"
		size = 24
		refs = "0010 ?__ArrayUnwind@@YAXPAXIIP6AX0@Z@Z"
	strings:
		$1 = { 10 B5 3B 78 00 2B 05 D1 FB 6B 7A 68 39 6B B8 6A ?? ?? ?? ?? FF E7 10 BD }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__fphelper_raise_exception"
		size = 1120
		refs = "000a __security_push_cookie 0436 __security_pop_cookie 0448 __imp_RaiseException"
	strings:
		$1 = { 0F B4 2D E9 90 48 0D F1 08 0B ?? ?? ?? ?? 93 B0 6F 46 5D F8 80 39 6B 46 3B 60 3B 68 0F 33 3B 60 3B 68 23 F0 0F 03 3B 60 3B 68 7B 64 00 23 FB 60 00 23 3B 61 F1 EE 10 3A 3B 64 3B 6C BB 60 BB 68 5B 0D 03 F0 02 02 BB 68 C3 F3 C0 53 1A 43 3B 68 1B 68 62 F3 01 03 3A 68 13 60 3B 68 1B 68 23 F0 1C 02 3B 68 1A 60 7A 6E 3B 68 1B 68 62 F3 50 13 3A 68 13 60 3B 6E 03 F0 01 02 3B 68 1B 1D 19 68 62 F3 04 11 3B 68 1A 1D 0B 46 13 60 3B 6E C3 F3 40 02 3B 68 1B 1D 19 68 62 F3 C3 01 3B 68 1A 1D 0B 46 13 60 3B 6E C3 F3 80 02 3B 68 1B 1D 19 68 62 F3 82 01 3B 68 1A 1D 0B 46 13 60 3B 6E C3 F3 C0 02 3B 68 1B 1D 19 68 62 F3 41 01 3B 68 1A 1D 0B 46 13 60 3B 6E C3 F3 00 12 3B 68 1B 1D 19 68 62 F3 00 01 3B 68 1A 1D 0B 46 13 60 BB 68 C3 F3 00 22 3B 68 08 33 19 68 62 F3 04 11 3B 68 03 F1 08 02 0B 46 13 60 BB 68 C3 F3 40 22 3B 68 08 33 19 68 62 F3 C3 01 3B 68 03 F1 08 02 0B 46 13 60 BB 68 C3 F3 80 22 3B 68 08 33 19 68 62 F3 82 01 3B 68 03 F1 08 02 0B 46 13 60 BB 68 C3 F3 C0 22 3B 68 08 33 19 68 62 F3 41 01 3B 68 03 F1 08 02 0B 46 13 60 BB 68 C3 F3 00 32 3B 68 08 33 19 68 62 F3 00 01 3B 68 03 F1 08 02 0B 46 13 60 BB 68 03 F0 01 02 3B 68 0C 33 19 68 62 F3 04 11 3B 68 03 F1 0C 02 0B 46 13 60 BB 68 C3 F3 40 02 3B 68 0C 33 19 68 62 F3 C3 01 3B 68 03 F1 0C 02 0B 46 13 60 BB 68 C3 F3 80 02 3B 68 0C 33 19 68 62 F3 82 01 3B 68 03 F1 0C 02 0B 46 13 60 BB 68 C3 F3 C0 02 3B 68 0C 33 19 68 62 F3 41 01 3B 68 03 F1 0C 02 0B 46 13 60 BB 68 C3 F3 00 12 3B 68 0C 33 19 68 62 F3 00 01 3B 68 03 F1 0C 02 0B 46 13 60 3B 68 10 33 7B 61 3A 6F 7B 69 1A 60 7A 6F 7B 69 5A 60 3B 68 20 33 1B 68 43 F0 01 02 3B 68 20 33 1A 60 3B 68 03 F1 20 02 BB 6E 11 68 63 F3 44 01 3B 68 03 F1 20 02 0B 46 13 60 3B 68 40 33 1B 68 23 F0 01 02 3B 68 40 33 1A 60 3B 68 50 33 BB 61 BA 6F BB 69 1A 60 FA 6F BB 69 5A 60 3B 68 60 33 1B 68 43 F0 01 02 3B 68 60 33 1A 60 3B 68 03 F1 60 02 FB 6E 11 68 63 F3 44 01 3B 68 03 F1 60 02 0B 46 13 60 3B 68 0C 33 1B 68 13 F0 10 0F 0A D0 3B 68 08 33 1B 68 13 F0 10 0F 04 D0 73 4B 3B 61 01 23 FB 60 42 E0 3B 68 0C 33 1B 68 13 F0 08 0F 0A D0 3B 68 08 33 1B 68 13 F0 08 0F 04 D0 6A 4B 3B 61 01 23 FB 60 31 E0 3B 68 0C 33 1B 68 13 F0 04 0F 0A D0 3B 68 08 33 1B 68 13 F0 04 0F 04 D0 60 4B 3B 61 01 23 FB 60 20 E0 3B 68 0C 33 1B 68 13 F0 02 0F 0A D0 3B 68 08 33 1B 68 13 F0 02 0F 04 D0 57 4B 3B 61 01 23 FB 60 0F E0 3B 68 0C 33 1B 68 13 F0 01 0F 09 D0 3B 68 08 33 1B 68 13 F0 01 0F 03 D0 4D 4B 3B 61 01 23 FB 60 FB 68 00 2B 04 D1 BA 6F FB 6F BA 63 FB 63 80 E0 17 F1 48 02 17 F1 44 03 13 60 17 F1 48 03 01 22 00 21 38 69 41 4C 24 68 A0 47 BA 68 3E 4B 13 40 7B 60 3B 68 08 33 1B 68 13 F0 10 0F 03 D0 4F F4 80 73 FB 61 01 E0 00 23 FB 61 7A 68 FB 69 13 43 7B 60 3B 68 08 33 1B 68 13 F0 08 0F 03 D0 4F F4 00 73 3B 62 01 E0 00 23 3B 62 7A 68 3B 6A 13 43 7B 60 3B 68 08 33 1B 68 13 F0 04 0F 03 D0 4F F4 80 63 7B 62 01 E0 00 23 7B 62 7A 68 7B 6A 13 43 7B 60 3B 68 08 33 1B 68 13 F0 02 0F 03 D0 4F F4 00 63 BB 62 01 E0 00 23 BB 62 7A 68 BB 6A 13 43 7B 60 3B 68 08 33 1B 68 13 F0 01 0F 03 D0 4F F4 80 53 FB 62 01 E0 00 23 FB 62 7A 68 FB 6A 13 43 7B 60 3B 68 1B 68 03 F0 03 03 03 F0 01 03 DA 05 7B 68 13 43 7B 60 3B 68 1B 68 03 F0 03 03 03 F0 02 03 5A 05 7B 68 13 43 7B 60 7B 68 E1 EE 10 3A 3B 68 50 33 3B 63 3B 6B 1A 68 3B 6B 5B 68 BA 63 FB 63 B8 6B F9 6B BD 46 13 B0 ?? ?? ?? ?? BD E8 90 08 5D F8 14 FB FE DE FF E0 3F FF ?? ?? ?? ?? 8F 00 00 C0 93 00 00 C0 91 00 00 C0 8E 00 00 C0 90 00 00 C0 }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "__helper_divide_by_0"
		size = 40
		refs = "0020 __imp_RaiseException"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 81 B0 00 23 00 22 00 21 04 48 03 4C 24 68 A0 47 01 B0 BD E8 10 88 FE DE ?? ?? ?? ?? 94 00 00 C0 }
	condition:
		$1
}

rule file_0_0_1 {
	meta:
		name = "_FDscale"
		size = 712
		refs = "005e _FDnorm 02c4 _FInf"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 8A B0 0C 9B 03 93 03 9B 9B 1C 1B 88 03 F4 FF 43 DB 11 1B B2 AD F8 02 30 BD F9 02 30 FF 2B 15 D1 03 9B 9B 1C 1B 88 03 F0 7F 03 00 2B 06 D1 03 9B 1B 88 00 2B 02 D1 01 23 05 93 01 E0 02 23 05 93 05 9B 1B B2 AD F8 10 30 31 E1 14 E0 BD F9 02 30 00 2B 10 D1 03 98 ?? ?? ?? ?? AD F8 0A 00 BD F9 0A 30 AD F8 02 30 BD F9 02 30 00 2B 03 DD 00 23 AD F8 10 30 1B E1 0D 9B 00 2B 23 DD BD F9 02 30 C3 F1 FF 02 0D 9B 9A 42 1C DC 03 9B 9B 1C 1B 88 13 F4 00 4F 07 D0 89 4B 93 ED 00 0A B1 EE 40 0A 8D ED 06 0A 04 E0 85 4B 93 ED 00 0A 8D ED 06 0A 9D ED 06 0A 0C 9B 83 ED 00 0A 01 23 AD F8 10 30 F5 E0 F4 E0 BD F9 02 30 5A 42 0D 9B 9A 42 14 DA 03 9B 9B 1C 1B 88 23 F4 FF 41 BD F9 02 20 0D 9B 13 44 DB 01 0B 43 9A B2 03 9B 9B 1C 1A 80 6F F0 00 03 AD F8 10 30 DA E0 D9 E0 03 9B 9B 1C 1B 88 03 F4 00 43 9B B2 AD F8 06 30 03 9B 9B 1C 1B 88 03 F0 7F 03 43 F0 80 03 9A B2 03 9B 9B 1C 1A 80 BD F9 02 30 5A 1E 0D 9B 13 44 0D 93 0D 9B 13 F1 18 0F 02 DB 0D 9B 00 2B 0C DB 03 9B 9A 1C BD F8 06 30 13 80 03 9A 00 23 13 80 00 23 AD F8 10 30 AD E0 AC E0 0D 9B 1B B2 AD F8 00 30 00 23 AD F8 04 30 BD F9 00 30 13 F1 10 0F 1E DC BD F8 04 30 00 2B 02 D0 01 23 07 93 01 E0 00 23 07 93 03 9B 1A 88 07 9B 13 43 9B B2 AD F8 04 30 03 9B 9B 1C 03 9A 1B 88 13 80 03 9B 9A 1C 00 23 13 80 BD F9 00 30 10 33 1B B2 AD F8 00 30 BD F9 00 30 5B 42 1B B2 AD F8 00 30 BD F9 00 30 00 2B 32 D0 BD F8 04 30 00 2B 02 D0 01 23 08 93 01 E0 00 23 08 93 03 9B 1A 88 BD F9 00 30 C3 F1 10 03 9A 40 08 9B 13 43 9B B2 AD F8 04 30 03 9B 1A 88 BD F9 00 30 42 FA 03 F1 03 9B 9B 1C 1A 88 BD F9 00 30 C3 F1 10 03 02 FA 03 F3 0B 43 9A B2 03 9B 1A 80 03 9B 99 1C BD F9 00 30 9A B2 0B 88 D3 40 9A B2 03 9B 9B 1C 1A 80 03 9B 9B 1C BD F8 06 20 1B 88 43 EA 02 01 03 9B 9A 1C 8B B2 13 80 BD F8 04 30 B3 F5 00 4F 09 DC BD F8 04 30 B3 F5 00 4F 1C D1 03 9B 1B 88 13 F0 01 0F 17 D0 03 9B 1B 88 5B 1C 9B B2 AD F8 08 30 03 9A BD F8 08 30 13 80 BD F8 08 30 9B B2 00 2B 08 D1 03 9B 9B 1C 1B 88 5B 1C 9A B2 03 9B 9B 1C 1A 80 0E E0 03 9B 9B 1C 1A 88 BD F8 06 30 9A 42 07 D1 03 9B 1B 88 00 2B 03 D1 00 23 AD F8 10 30 03 E0 6F F0 00 03 AD F8 10 30 BD F9 10 00 0A B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_0_1 {
	meta:
		name = "?_XLgamma@std@@YAMM@Z"
		size = 244
		refs = "0020 ?log@@YAMM@Z 00f0 ?coeff@?1??_XLgamma@std@@YAMM@Z@4QBMB"
	strings:
		$1 = { 2D E9 00 48 EB 46 88 B0 8D ED 01 0A DD ED 01 0A B1 EE 06 0A 30 EE 80 0A 8D ED 02 0A 9D ED 02 0A ?? ?? ?? ?? 8D ED 05 0A DD ED 01 0A B6 EE 00 0A 70 EE 80 0A 9D ED 05 0A 60 EE 80 0A 9D ED 02 0A 30 EE 60 0A 8D ED 02 0A B7 EE 00 0A 8D ED 04 0A DD ED 01 0A B7 EE 00 0A 30 EE 80 0A 8D ED 03 0A 00 23 00 93 0E E0 00 9B 5B 1C 00 93 9D ED 03 0A B7 EE C0 1A B7 EE 00 0B 31 EE 00 0B B7 EE C0 0B 8D ED 03 0A 00 9B 06 2B 12 DA 00 9A 04 23 02 FB 03 F2 17 4B 13 44 D3 ED 00 0A 9D ED 03 0A C0 EE 80 0A 9D ED 04 0A 30 EE 20 0A 8D ED 04 0A DA E7 DF ED 0E 0A 9D ED 04 0A 60 EE 80 0A 9D ED 01 0A 80 EE 80 0A ?? ?? ?? ?? 8D ED 06 0A 9D ED 02 0A F1 EE 40 0A 9D ED 06 0A 30 EE 80 0A 8D ED 07 0A 9D ED 07 0A 08 B0 BD E8 00 88 FE DE 99 6C 20 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_1_1 {
	meta:
		name = "?_XLgamma@std@@YANN@Z"
		size = 240
		refs = "0030 log 00e4 ?coeff@?1??_XLgamma@std@@YANN@Z@4QBNB"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 8C B0 8D ED 04 0B 9D ED 04 1B B1 EE 06 0B 31 EE 00 0B 8D ED 02 0B 9D ED 04 1B B6 EE 00 0B 31 EE 00 8B 9D ED 02 0B ?? ?? ?? ?? 28 EE 00 1B 9D ED 02 0B 30 EE 41 0B 8D ED 02 0B 9F ED 28 0B 8D ED 08 0B 9D ED 04 1B B7 EE 00 0B 31 EE 00 0B 8D ED 06 0B 00 23 00 93 0A E0 00 9B 5B 1C 00 93 9D ED 06 1B B7 EE 00 0B 31 EE 00 0B 8D ED 06 0B 00 9B 06 2B 12 DA 00 9A 08 23 02 FB 03 F2 17 4B 13 44 93 ED 00 1B 9D ED 06 0B 81 EE 00 1B 9D ED 08 0B 30 EE 01 0B 8D ED 08 0B DE E7 9D ED 02 0B B1 EE 40 8B 9F ED 0B 1B 9D ED 08 0B 21 EE 00 1B 9D ED 04 0B 81 EE 00 0B ?? ?? ?? ?? 38 EE 00 0B 8D ED 0A 0B 9D ED 0A 0B 0C B0 BD EC 02 8B BD E8 00 88 FE DE 06 27 F6 1F 93 0D 04 40 ?? ?? ?? ?? C7 0E 0D 00 00 00 F0 3F }
	condition:
		$1
}

rule file_2_2_1 {
	meta:
		name = "?_XLgamma@std@@YAOO@Z"
		size = 248
		refs = "0020 ?log@@YAOO@Z 00ec ?coeff@?1??_XLgamma@std@@YAOO@Z@4QBOB"
	strings:
		$1 = { 2D E9 00 48 EB 46 90 B0 8D ED 02 0B 9D ED 02 1B B1 EE 06 0B 31 EE 00 0B 8D ED 04 0B 9D ED 04 0B ?? ?? ?? ?? 8D ED 0A 0B 9D ED 02 1B B6 EE 00 0B 31 EE 00 1B 9D ED 0A 0B 21 EE 00 1B 9D ED 04 0B 30 EE 41 0B 8D ED 04 0B 9F ED 29 0B 8D ED 08 0B 9D ED 02 1B B7 EE 00 0B 31 EE 00 0B 8D ED 06 0B 00 23 00 93 0A E0 00 9B 5B 1C 00 93 9D ED 06 1B B7 EE 00 0B 31 EE 00 0B 8D ED 06 0B 00 9B 06 2B 12 DA 00 9A 08 23 02 FB 03 F2 18 4B 13 44 93 ED 00 1B 9D ED 06 0B 81 EE 00 1B 9D ED 08 0B 30 EE 01 0B 8D ED 08 0B DE E7 9F ED 0E 1B 9D ED 08 0B 21 EE 00 1B 9D ED 02 0B 81 EE 00 0B ?? ?? ?? ?? 8D ED 0C 0B 9D ED 04 0B B1 EE 40 1B 9D ED 0C 0B 31 EE 00 0B 8D ED 0E 0B 9D ED 0E 0B 10 B0 BD E8 00 88 FE DE 06 27 F6 1F 93 0D 04 40 ?? ?? ?? ?? C7 0E 0D 00 00 00 F0 3F }
	condition:
		$1
}

rule file_2_3_1 {
	meta:
		name = "?log@@YAMM@Z"
		size = 34
		refs = "0010 logf"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 8D ED 00 0A 9D ED 00 0A ?? ?? ?? ?? 8D ED 01 0A 9D ED 01 0A 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_2_4_1 {
	meta:
		name = "?log@@YAOO@Z"
		size = 42
		refs = "0010 logl"
	strings:
		$1 = { 2D E9 00 48 EB 46 86 B0 8D ED 00 0B 9D ED 00 0B ?? ?? ?? ?? 8D ED 02 0B 9D ED 02 0B 8D ED 04 0B 9D ED 04 0B 06 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_2_5_1 {
	meta:
		name = "logl"
		size = 34
		refs = "0010 log"
		altNames = "fabsl sqrtl"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 8D ED 00 0B 9D ED 00 0B ?? ?? ?? ?? 8D ED 02 0B 9D ED 02 0B 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_3_0_1 {
	meta:
		name = "_Getwctype"
		size = 72
		refs = "0044 __imp_GetStringTypeW"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 85 B0 6B 46 01 22 08 A9 01 20 0B 4C 24 68 A0 47 02 90 02 9B 00 2B 02 D1 00 23 01 93 02 E0 BD F9 00 30 01 93 01 9B 1B B2 AD F8 0C 30 BD F9 0C 00 05 B0 BD E8 10 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_1_1 {
	meta:
		name = "_Getwctypes"
		size = 52
		refs = "0030 __imp_GetStringTypeW"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B 81 B0 06 9B 05 99 04 9A 8A 1A 52 10 04 99 01 20 05 4C 24 68 A0 47 05 9B 00 93 00 98 01 B0 BD E8 10 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_0_1 {
	meta:
		name = "??0stl_critical_section_concrt@details@Concurrency@@QAA@XZ"
		size = 52
		refs = "000c ??0stl_critical_section_interface@details@Concurrency@@QAA@XZ 001a ??0critical_section@Concurrency@@QAA@XZ 0030 ??_7stl_critical_section_concrt@details@Concurrency@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 07 4A 04 9B 1A 60 04 9B 18 1D ?? ?? ?? ?? 01 90 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_0_1 {
	meta:
		name = "??0stl_condition_variable_concrt@details@Concurrency@@QAA@XZ"
		size = 52
		refs = "000c ??0stl_condition_variable_interface@details@Concurrency@@QAA@XZ 001a ??0_Condition_variable@details@Concurrency@@QAA@XZ 0030 ??_7stl_condition_variable_concrt@details@Concurrency@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 07 4A 04 9B 1A 60 04 9B 18 1D ?? ?? ?? ?? 01 90 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_1_1 {
	meta:
		name = "??0stl_critical_section_interface@details@Concurrency@@QAA@XZ"
		size = 26
		altNames = "??$?0D@?$allocator@U_Container_proxy@std@@@std@@QAA@ABV?$allocator@D@1@@Z ??$?0G@?$allocator@U_Container_proxy@std@@@std@@QAA@ABV?$allocator@G@1@@Z ??$?0H@?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@QAA@ABU?$_StaticAllocator@H@@@Z ??$?0Uoutput_iterator_tag@std@@@_Any_tag@std@@QAA@$$QAUoutput_iterator_tag@1@@Z ??$?0_W@?$allocator@U_Container_proxy@std@@@std@@QAA@ABV?$allocator@_W@1@@Z ??$_Unchecked@PAD@std@@YAPADPAD@Z ??$_Unchecked@PA_W@std@@YAPA_WPA_W@Z ??$_Unfancy@$$CBD@std@@YAPBDPBD@Z ??$_Unfancy@$$CBG@std@@YAPBGPBG@Z ??$_Unfancy@$$CB_W@std@@YAPB_WPB_W@Z ??$_Unfancy@D@std@@YAPADPAD@Z ??$_Unfancy@G@std@@YAPAGPAG@Z ??$_Unfancy@U_Container_proxy@std@@@std@@YAPAU_Container_proxy@0@PAU10@@Z ??$_Unfancy@_W@std@@YAPA_WPA_W@Z ??$addressof@D@std@@YAPADAAD@Z ??$addressof@G@std@@YAPAGAAG@Z ??$addressof@PAD@std@@YAPAPADAAPAD@Z ??$addressof@PAG@std@@YAPAPAGAAPAG@Z ??$addressof@PA_W@std@@YAPAPA_WAAPA_W@Z ??$addressof@U_Container_proxy@std@@@std@@YAPAU_Container_proxy@0@AAU10@@Z ??$addressof@_W@std@@YAPA_WAA_W@Z ??$forward@AAPAD@std@@YAAAPADAAPAD@Z ??$forward@AAPAG@std@@YAAAPAGAAPAG@Z ??$forward@AAPAUEHExceptionRecord@@@std@@YAAAPAUEHExceptionRecord@@AAPAU1@@Z ??$forward@AAPA_W@std@@YAAAPA_WAAPA_W@Z ??$forward@AAU?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@@std@@YAAAU?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@0@AAU10@@Z ??$forward@AAU?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AAU10@@Z ??$forward@AAU?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YAAAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AAU10@@Z ??$forward@AAU?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AAU10@@Z ??$forward@ABU?$_StaticAllocator@H@@@std@@YAABU?$_StaticAllocator@H@@ABU1@@Z ??$forward@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AAU10@@Z ??$forward@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AAU10@@Z ??$forward@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AAU10@@Z ??$forward@U_Container_proxy@std@@@std@@YA$$QAU_Container_proxy@0@AAU10@@Z ??$forward@V?$allocator@D@std@@@std@@YA$$QAV?$allocator@D@0@AAV10@@Z ??$forward@V?$allocator@G@std@@@std@@YA$$QAV?$allocator@G@0@AAV10@@Z ??$forward@V?$allocator@_W@std@@@std@@YA$$QAV?$allocator@_W@0@AAV10@@Z ??$forward@V?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@@std@@YA$$QAV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AAV10@@Z ??$forward@V?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@@std@@YA$$QAV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@0@AAV10@@Z ??$forward@V?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@@std@@YA$$QAV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@0@AAV10@@Z ??$forward@_N@std@@YA$$QA_NAA_N@Z ??$move@AAD@std@@YA$$QADAAD@Z ??$move@AAI@std@@YA$$QAIAAI@Z ??$move@AAPAD@std@@YA$$QAPADAAPAD@Z ??$move@AAPAV_Ref_count_base@std@@@std@@YA$$QAPAV_Ref_count_base@0@AAPAV10@@Z ??$move@AAPAV__ExceptionPtr@@@std@@YA$$QAPAV__ExceptionPtr@@AAPAV1@@Z ??$move@AAU?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AAU10@@Z ??$move@AAU?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AAU10@@Z ??$move@AAU?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AAU10@@Z ??$move@AAV?$shared_ptr@V__ExceptionPtr@@@std@@@std@@YA$$QAV?$shared_ptr@V__ExceptionPtr@@@0@AAV10@@Z ??0?$allocator@D@std@@QAA@ABV01@@Z ??0?$allocator@D@std@@QAA@XZ ??0?$allocator@G@std@@QAA@ABV01@@Z ??0?$allocator@G@std@@QAA@XZ ??0?$allocator@_W@std@@QAA@ABV01@@Z ??0?$allocator@_W@std@@QAA@XZ ??0_Bxty@?$_String_val@U?$_Simple_types@D@std@@@std@@QAA@XZ ??0_Bxty@?$_String_val@U?$_Simple_types@G@std@@@std@@QAA@XZ ??0_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAA@XZ ??0locale@std@@QAA@W4_Uninitialized@1@@Z ??0stl_condition_variable_interface@details@Concurrency@@QAA@XZ ??D?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@XZ ??D?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@XZ ??D?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@XZ ??E?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@H@Z ??E?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@XZ ??E?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@H@Z ??E?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@XZ ??E?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@H@Z ??E?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@XZ ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@T?$_Align_type@H$0FE@@2@$00@std@@QAAAAU?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@2@XZ ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAAAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QBAABU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAAAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QBAABU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ ?_Get_first@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QBAABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@T?$_Align_type@H$0FE@@2@$00@std@@QBAABT?$_Align_type@H$0FE@@2@XZ ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAAAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QBAABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QBAABV?$_String_val@U?$_Simple_types@G@std@@@2@XZ ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ ?_Get_second@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QBAABV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ ?_Getspace@?$_Func_class@X$$V@std@@ABAPBXXZ ?_get_cv@_Cnd_internal_imp_t@@QAAPAVstl_condition_variable_interface@details@Concurrency@@XZ _FPlsw _LPlsw _Plsw"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_2_1 {
	meta:
		name = "??0stl_critical_section_vista@details@Concurrency@@QAA@XZ"
		size = 64
		refs = "000c ??0stl_critical_section_interface@details@Concurrency@@QAA@XZ 0038 __imp_InitializeCriticalSectionEx 003c ??_7stl_critical_section_vista@details@Concurrency@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 0A 4A 04 9B 1A 60 00 22 4F F4 7A 61 04 9B 18 1D 05 4B 1B 68 98 47 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_3_1 {
	meta:
		name = "??0stl_critical_section_win7@details@Concurrency@@QAA@XZ"
		size = 56
		refs = "000c ??0stl_critical_section_interface@details@Concurrency@@QAA@XZ 0030 __imp_InitializeSRWLock 0034 ??_7stl_critical_section_win7@details@Concurrency@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 08 4A 04 9B 1A 60 04 9B 18 1D 05 4B 1B 68 98 47 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_2_1 {
	meta:
		name = "??0stl_condition_variable_vista@details@Concurrency@@QAA@XZ"
		size = 56
		refs = "000c ??0stl_condition_variable_interface@details@Concurrency@@QAA@XZ 0030 __imp_InitializeConditionVariable 0034 ??_7stl_condition_variable_vista@details@Concurrency@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 08 4A 04 9B 1A 60 04 9B 18 1D 05 4B 1B 68 98 47 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_3_1 {
	meta:
		name = "??0stl_condition_variable_win7@details@Concurrency@@QAA@XZ"
		size = 56
		refs = "000c ??0stl_condition_variable_interface@details@Concurrency@@QAA@XZ 0030 __imp_InitializeConditionVariable 0034 ??_7stl_condition_variable_win7@details@Concurrency@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 08 4A 04 9B 1A 60 04 9B 18 1D 05 4B 1B 68 98 47 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_4_1 {
	meta:
		name = "??1GlobalCore@details@Concurrency@@QAA@XZ"
		size = 36
		refs = "0016 ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 20 33 1B 68 00 93 08 21 00 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_5_1 {
	meta:
		name = "??2@YAPAXIPAX@Z"
		size = 26
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_7_1 {
	meta:
		name = "??_EGlobalCore@details@Concurrency@@QAAPAXI@Z"
		size = 128
		refs = "002a ??_M@YAXPAXIIP6AX0@Z@Z 0048 ??_V@YAXPAXI@Z 0056 ??1GlobalCore@details@Concurrency@@QAA@XZ 0066 ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 7B 6A 13 F0 02 0F 1A D0 17 4B 3A 6A 12 1F 12 68 24 21 38 6A ?? ?? ?? ?? 7B 6A 13 F0 01 0F 0A D0 3B 6A 1B 1F 1A 68 24 23 02 FB 03 F3 19 1D 3B 6A 18 1F ?? ?? ?? ?? 3B 6A 1B 1F 3B 60 0C E0 38 6A ?? ?? ?? ?? 7B 6A 13 F0 01 0F 03 D0 24 21 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_8_1 {
	meta:
		name = "??_Gcritical_section@Concurrency@@QAAPAXI@Z"
		size = 48
		refs = "000c ??1critical_section@Concurrency@@QAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 20 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_9_1 {
	meta:
		name = "??_H@YAXPAXIIP6APAX0@Z@Z"
		size = 62
		refs = "0020 _guard_check_icall"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B 81 B0 06 9A 06 9B 5B 1E 06 93 00 2A 0D D9 04 9C 07 9B 00 93 00 98 ?? ?? ?? ?? 00 9B 20 46 98 47 04 9A 05 9B 13 44 04 93 EB E7 01 B0 BD E8 10 08 5D F8 14 FB }
	condition:
		$1
}

rule file_4_12_1 {
	meta:
		name = "?_get_cs@_Mtx_internal_imp_t@@QAAPAVstl_critical_section_interface@details@Concurrency@@XZ"
		size = 28
		altNames = "?native_handle@stl_critical_section_concrt@details@Concurrency@@QAAAAVcritical_section@3@XZ ?native_handle@stl_critical_section_vista@details@Concurrency@@QAAPAU_RTL_CRITICAL_SECTION@@XZ ?native_handle@stl_critical_section_win7@details@Concurrency@@QAAPAU_RTL_SRWLOCK@@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 1D 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_15_1 {
	meta:
		name = "?create_stl_critical_section@details@Concurrency@@YAXPAVstl_critical_section_interface@12@@Z"
		size = 216
		refs = "0030 ?are_win7_sync_apis_available@details@Concurrency@@YA_NXZ 0040 ??2@YAPAXIPAX@Z 0052 ??0stl_critical_section_win7@details@Concurrency@@QAA@XZ 0068 ?are_vista_sync_apis_available@details@Concurrency@@YA_NXZ 008a ??0stl_critical_section_vista@details@Concurrency@@QAA@XZ 00b6 ??0stl_critical_section_concrt@details@Concurrency@@QAA@XZ 00d4 ?__stl_sync_api_impl_mode@@3W4__stl_sync_api_modes_enum@@A"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 95 B0 6F 46 6F F0 01 03 C7 E9 12 33 2F 4B 1B 68 7B 60 7B 68 00 2B 3E DB 7B 68 01 2B 03 DD 7B 68 02 2B 1C D0 37 E0 ?? ?? ?? ?? 38 70 3B 78 00 2B 15 D0 39 6E 08 20 ?? ?? ?? ?? 38 62 3B 6A BB 60 BB 68 00 2B 06 D0 B8 68 ?? ?? ?? ?? 78 62 7B 6A FB 60 01 E0 00 23 FB 60 FB 68 BB 63 30 E0 ?? ?? ?? ?? 78 70 7B 78 00 2B 15 D0 39 6E 1C 20 ?? ?? ?? ?? B8 62 BB 6A 3B 61 3B 69 00 2B 06 D0 38 69 ?? ?? ?? ?? F8 62 FB 6A 7B 61 01 E0 00 23 7B 61 7B 69 FB 63 14 E0 39 6E 24 20 ?? ?? ?? ?? 38 63 3B 6B BB 61 BB 69 00 2B 06 D0 B8 69 ?? ?? ?? ?? 78 63 7B 6B FB 61 01 E0 00 23 FB 61 FB 69 3B 64 15 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_19_1 {
	meta:
		name = "?destroy@stl_critical_section_concrt@details@Concurrency@@UAAXXZ"
		size = 26
		refs = "000e ??_Gcritical_section@Concurrency@@QAAPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 00 21 02 9B 18 1D ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_114_107_3 {
	meta:
		name = "?_Incref@_Ref_count_base@std@@QAAXXZ"
		size = 26
		refs = "000e ?_Inc_atomic_counter_explicit@std@@YAKAAKW4memory_order@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 00 21 02 9B 18 1D ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_27_269_3 {
	meta:
		name = "?_Incref@facet@locale@std@@UAAXXZ"
		size = 26
		refs = "000e ?_Inc_atomic_counter_explicit@std@@YAKAAKW4memory_order@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 00 21 02 9B 18 1D ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_83_19_1 {
	meta:
		name = "?destroy@stl_condition_variable_concrt@details@Concurrency@@UAAXXZ"
		size = 26
		refs = "000e ??_G_Condition_variable@details@Concurrency@@QAAPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 00 21 02 9B 18 1D ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_20_1 {
	meta:
		name = "?destroy@stl_critical_section_vista@details@Concurrency@@UAAXXZ"
		size = 32
		refs = "001c __imp_DeleteCriticalSection"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_23_1 {
	meta:
		name = "?lock@stl_critical_section_vista@details@Concurrency@@UAAXXZ"
		size = 32
		refs = "001c __imp_EnterCriticalSection"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_24_1 {
	meta:
		name = "?lock@stl_critical_section_win7@details@Concurrency@@UAAXXZ"
		size = 32
		refs = "001c __imp_AcquireSRWLockExclusive"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_28_2 {
	meta:
		name = "?notify_all@stl_condition_variable_vista@details@Concurrency@@UAAXXZ"
		size = 32
		refs = "001c __imp_WakeAllConditionVariable"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_29_2 {
	meta:
		name = "?notify_all@stl_condition_variable_win7@details@Concurrency@@UAAXXZ"
		size = 32
		refs = "001c __imp_WakeAllConditionVariable"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_31_1 {
	meta:
		name = "?notify_one@stl_condition_variable_vista@details@Concurrency@@UAAXXZ"
		size = 32
		refs = "001c __imp_WakeConditionVariable"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_32_1 {
	meta:
		name = "?notify_one@stl_condition_variable_win7@details@Concurrency@@UAAXXZ"
		size = 32
		refs = "001c __imp_WakeConditionVariable"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_33_1 {
	meta:
		name = "?unlock@stl_critical_section_vista@details@Concurrency@@UAAXXZ"
		size = 32
		refs = "001c __imp_LeaveCriticalSection"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_34_3 {
	meta:
		name = "?unlock@stl_critical_section_win7@details@Concurrency@@UAAXXZ"
		size = 32
		refs = "001c __imp_ReleaseSRWLockExclusive"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_22_1 {
	meta:
		name = "?lock@stl_critical_section_concrt@details@Concurrency@@UAAXXZ"
		size = 24
		refs = "000c ?lock@critical_section@Concurrency@@QAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_83_27_1 {
	meta:
		name = "?notify_all@stl_condition_variable_concrt@details@Concurrency@@UAAXXZ"
		size = 24
		refs = "000c ?notify_all@_Condition_variable@details@Concurrency@@QAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_83_30_1 {
	meta:
		name = "?notify_one@stl_condition_variable_concrt@details@Concurrency@@UAAXXZ"
		size = 24
		refs = "000c ?notify_one@_Condition_variable@details@Concurrency@@QAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_32_1 {
	meta:
		name = "?unlock@stl_critical_section_concrt@details@Concurrency@@UAAXXZ"
		size = 24
		refs = "000c ?unlock@critical_section@Concurrency@@QAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 1D ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_25_1 {
	meta:
		name = "?mtx_do_lock@@YAHPAU_Mtx_internal_imp_t@@PBUxtime@@@Z"
		size = 784
		refs = "000a __security_push_cookie 0032 ?_get_cs@_Mtx_internal_imp_t@@QAAPAVstl_critical_section_interface@details@Concurrency@@XZ 0048 _guard_check_icall 0164 xtime_get 01ee _Xtime_diff_to_millis2 02fe __security_pop_cookie 030c __imp_GetCurrentThreadId"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? B5 B0 3A 9B 1B 68 23 F4 80 73 01 2B 2E D1 BB 4B 1B 68 98 47 12 90 3A 9B 28 33 1A 68 12 9B 9A 42 19 D0 3A 98 ?? ?? ?? ?? 13 90 13 9B 04 93 04 9B 1B 68 04 9C 1B 68 05 93 05 98 ?? ?? ?? ?? 05 9B 20 46 98 47 AE 4B 1B 68 98 47 14 90 3A 9B 03 F1 28 02 14 9B 13 60 3A 9B 2C 33 1B 68 5A 1C 3A 9B 2C 33 1A 60 00 23 02 93 40 E1 3F E1 4F F4 81 73 00 93 3B 9B 00 2B 1D D1 A1 4B 1B 68 98 47 15 90 3A 9B 28 33 1A 68 15 9B 9A 42 10 D0 3A 98 ?? ?? ?? ?? 16 90 16 9B 06 93 06 9B 1B 68 06 9C 1B 68 07 93 07 98 ?? ?? ?? ?? 07 9B 20 46 98 47 00 23 00 93 BE E0 3B 9B 08 93 08 9B 1B 68 22 93 08 9B 5B 68 23 93 22 9B 17 93 23 9B 00 2B 15 DB 02 DC 17 9B 00 2B 11 D3 3B 9B 09 93 09 9B 1B 68 24 93 09 9B 5B 68 25 93 25 9A 24 9B 13 43 00 2B 30 D1 3B 9B 08 33 1B 68 00 2B 2B DC 80 4B 1B 68 98 47 18 90 3A 9B 28 33 1A 68 18 9B 9A 42 1E D0 3A 98 ?? ?? ?? ?? 19 90 19 9B 0A 93 0A 9B 1B 68 1B 1D 0A 9C 1B 68 0B 93 0B 98 ?? ?? ?? ?? 0B 9B 20 46 98 47 8D F8 04 00 9D F8 04 30 00 2B 02 D0 00 23 00 93 02 E0 4F F4 81 73 00 93 01 E0 00 23 00 93 6F E0 01 21 30 A8 ?? ?? ?? ?? 3B 9A 30 9B 26 93 31 9B 27 93 0C 92 0C 9B 1B 68 28 93 0C 9B 5B 68 29 93 26 9B 1A 93 28 9B 1B 93 27 9A 29 9B 9A 42 22 DB 03 DC 1A 9A 1B 9B 9A 42 1D D3 3B 9A 30 9B 2A 93 31 9B 2B 93 0D 92 0D 9B 1B 68 2C 93 0D 9B 5B 68 2D 93 2B 9B 1C 93 2D 9B 1D 93 2A 9A 2C 9B 9A 42 3E D1 1C 9A 1D 9B 9A 42 3A D1 3B 9B 08 33 32 9A 1B 68 9A 42 34 DA 4D 4B 1B 68 98 47 1E 90 3A 9B 28 33 1A 68 1E 9B 9A 42 1E D0 30 A9 3B 98 ?? ?? ?? ?? 20 90 3A 98 ?? ?? ?? ?? 1F 90 1F 9B 0E 93 20 9D 0E 9C 0E 9B 1B 68 08 33 1B 68 0F 93 0F 98 ?? ?? ?? ?? 0F 9B 20 46 29 46 98 47 8D F8 05 00 9D F8 05 30 00 2B 03 D0 00 23 00 93 08 E0 02 E0 4F F4 81 73 00 93 01 21 30 A8 ?? ?? ?? ?? 93 E7 00 9B 00 2B 03 D0 00 9B 80 2B 00 D0 27 E0 3A 9B 2C 33 1B 68 5B 1C 10 93 3A 9B 03 F1 2C 02 10 9B 13 60 10 9B 01 2B 11 DD 3A 9B 1B 68 03 F4 80 73 B3 F5 80 7F 09 D0 3A 9B 2C 33 1B 68 5A 1E 3A 9B 2C 33 1A 60 4F F4 81 73 00 93 08 E0 1F 4B 1B 68 98 47 21 90 3A 9B 03 F1 28 02 21 9B 13 60 00 9B 03 93 03 9B 00 2B 07 D0 03 9B 80 2B 04 D0 03 9B B3 F5 81 7F 03 D0 1E E0 00 23 02 93 1D E0 3B 9B 00 2B 11 D0 3B 9B 11 93 11 9B 1B 68 2E 93 11 9B 5B 68 2F 93 2F 9A 2E 9B 13 43 00 2B 08 D1 3B 9B 08 33 1B 68 00 2B 03 D1 03 23 02 93 05 E0 02 E0 02 23 02 93 01 E0 04 23 02 93 02 98 35 B0 ?? ?? ?? ?? BD E8 30 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_26_1 {
	meta:
		name = "?try_lock@stl_critical_section_concrt@details@Concurrency@@UAA_NXZ"
		size = 44
		refs = "000e ?try_lock@critical_section@Concurrency@@QAA_NXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 18 1D ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_27_1 {
	meta:
		name = "?try_lock@stl_critical_section_vista@details@Concurrency@@UAA_NXZ"
		size = 64
		refs = "003c __imp_TryEnterCriticalSection"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 18 1D 0B 4B 1B 68 98 47 01 90 01 9B 00 2B 02 D0 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_28_1 {
	meta:
		name = "?try_lock@stl_critical_section_win7@details@Concurrency@@UAA_NXZ"
		size = 68
		refs = "0040 __imp_TryAcquireSRWLockExclusive"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 18 1D 0C 4B 1B 68 98 47 8D F8 00 00 9D F8 00 30 00 2B 02 D0 01 23 01 93 01 E0 00 23 01 93 01 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_29_1 {
	meta:
		name = "?try_lock_for@stl_critical_section_concrt@details@Concurrency@@UAA_NI@Z"
		size = 46
		refs = "0010 ?try_lock_for@critical_section@Concurrency@@QAA_NI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 9B 18 1D ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_30_1 {
	meta:
		name = "?try_lock_for@stl_critical_section_vista@details@Concurrency@@UAA_NI@Z"
		size = 42
		refs = "000c ?try_lock@stl_critical_section_vista@details@Concurrency@@UAA_NXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_25_13_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBA_NXZ"
		size = 42
		refs = "000c ?is_valid@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBA_NXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_22_3_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QBA_NXZ"
		size = 42
		refs = "000c ?is_valid@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QBA_NXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_1_5_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QBA_NXZ"
		size = 42
		refs = "000c ?is_valid@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QBA_NXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_25_14_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QBA_NXZ"
		size = 42
		refs = "000c ?is_valid@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QBA_NXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_31_1 {
	meta:
		name = "?try_lock_for@stl_critical_section_win7@details@Concurrency@@UAA_NI@Z"
		size = 42
		refs = "000c ?try_lock@stl_critical_section_win7@details@Concurrency@@UAA_NXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_35_1 {
	meta:
		name = "_Mtx_clear_owner"
		size = 42
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 03 F1 28 02 6F F0 00 03 13 60 02 9B 2C 33 1B 68 5A 1E 02 9B 2C 33 1A 60 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_36_1 {
	meta:
		name = "_Mtx_current_owns"
		size = 72
		refs = "0044 __imp_GetCurrentThreadId"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 2C 33 1B 68 00 2B 0C D0 0B 4B 1B 68 98 47 01 90 06 9B 28 33 1A 68 01 9B 9A 42 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_37_1 {
	meta:
		name = "_Mtx_destroy"
		size = 36
		refs = "0010 _Mtx_destroy_in_situ 0018 _free_dbg"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 00 2B 06 D0 02 98 ?? ?? ?? ?? 02 21 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_83_40_1 {
	meta:
		name = "_Cnd_destroy"
		size = 36
		refs = "0010 _Cnd_destroy_in_situ 0018 _free_dbg"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 00 2B 06 D0 02 98 ?? ?? ?? ?? 02 21 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_38_1 {
	meta:
		name = "_Mtx_destroy_in_situ"
		size = 80
		refs = "001a _Thrd_abort 0020 ?_get_cs@_Mtx_internal_imp_t@@QAAPAVstl_critical_section_interface@details@Concurrency@@XZ 0038 _guard_check_icall 004c ??_C@_0EM@GBEAHCKM@f?3?2dd?2vctools?2crt?2crtw32?2stdcpp?2@"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 83 B0 06 9B 2C 33 1B 68 00 2B 00 D1 02 E0 0C 48 ?? ?? ?? ?? 06 98 ?? ?? ?? ?? 02 90 02 9B 00 93 00 9B 1B 68 10 33 00 9C 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 98 47 03 B0 BD E8 10 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_40_1 {
	meta:
		name = "_Mtx_init"
		size = 84
		refs = "001c _calloc_dbg 0036 _Mtx_init_in_situ 0050 ??_C@_0CM@EOPLGJDM@f?3?2dd?2vctools?2crt?2crtw32?2stdcpp?2@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 9A 00 23 13 60 3C 23 00 93 0E 4B 02 22 30 21 01 20 ?? ?? ?? ?? 04 90 04 9B 02 93 02 9B 00 2B 02 D1 01 23 03 93 08 E0 09 99 02 98 ?? ?? ?? ?? 02 9A 08 9B 1A 60 00 23 03 93 03 98 06 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_41_1 {
	meta:
		name = "_Mtx_init_in_situ"
		size = 62
		refs = "000c ?_get_cs@_Mtx_internal_imp_t@@QAAPAVstl_critical_section_interface@details@Concurrency@@XZ 0014 ?create_stl_critical_section@details@Concurrency@@YAXPAVstl_critical_section_interface@12@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 98 ?? ?? ?? ?? 04 9B 03 F1 28 02 6F F0 00 03 13 60 04 9A 05 9B 13 60 04 9B 03 F1 2C 02 00 23 13 60 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_42_1 {
	meta:
		name = "_Mtx_lock"
		size = 36
		refs = "000e ?mtx_do_lock@@YAHPAU_Mtx_internal_imp_t@@PBUxtime@@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 00 21 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_83_44_1 {
	meta:
		name = "_Cnd_signal"
		size = 36
		refs = "000e ?do_signal@@YAHPAU_Cnd_internal_imp_t@@H@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 00 21 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_43_1 {
	meta:
		name = "_Mtx_reset_owner"
		size = 56
		refs = "0034 __imp_GetCurrentThreadId"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0A 4B 1B 68 98 47 00 90 04 9B 03 F1 28 02 00 9B 13 60 04 9B 2C 33 1B 68 5A 1C 04 9B 2C 33 1A 60 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_44_1 {
	meta:
		name = "_Mtx_timedlock"
		size = 80
		refs = "0018 _Thrd_abort 0020 ?mtx_do_lock@@YAHPAU_Mtx_internal_imp_t@@PBUxtime@@@Z 004c ??_C@_0FD@JBMGHHCE@f?3?2dd?2vctools?2crt?2crtw32?2stdcpp?2@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 1B 68 13 F0 04 0F 00 D0 02 E0 0D 48 ?? ?? ?? ?? 07 99 06 98 ?? ?? ?? ?? 02 90 02 9B 00 93 00 9B 03 2B 02 D1 02 23 01 93 01 E0 00 9B 01 93 01 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_45_1 {
	meta:
		name = "_Mtx_trylock"
		size = 84
		refs = "0008 __security_push_cookie 001e _Thrd_abort 0034 ?mtx_do_lock@@YAHPAU_Mtx_internal_imp_t@@PBUxtime@@@Z 0042 __security_pop_cookie 0050 ??_C@_0FB@BILGMMLM@f?3?2dd?2vctools?2crt?2crtw32?2stdcpp?2@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 87 B0 0A 9B 1B 68 03 F0 06 03 00 2B 00 D0 02 E0 0C 48 ?? ?? ?? ?? 00 23 04 93 04 9A 04 9B DB 17 02 92 03 93 02 A9 0A 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 07 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_46_1 {
	meta:
		name = "_Mtx_unlock"
		size = 148
		refs = "002e _Thrd_abort 005a ?_get_cs@_Mtx_internal_imp_t@@QAAPAVstl_critical_section_interface@details@Concurrency@@XZ 0072 _guard_check_icall 008c ??_C@_0EK@BCFFEPKN@f?3?2dd?2vctools?2crt?2crtw32?2stdcpp?2@ 0090 __imp_GetCurrentThreadId"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 87 B0 0A 9B 2C 33 1B 68 01 2B 0A DB 1E 4B 1B 68 98 47 03 90 0A 9B 28 33 1A 68 03 9B 9A 42 00 D1 02 E0 17 48 ?? ?? ?? ?? 0A 9B 2C 33 1B 68 5B 1E 00 93 0A 9B 03 F1 2C 02 00 9B 13 60 00 9B 00 2B 17 D1 0A 9B 03 F1 28 02 6F F0 00 03 13 60 0A 98 ?? ?? ?? ?? 04 90 04 9B 01 93 01 9B 1B 68 0C 33 01 9C 1B 68 02 93 02 98 ?? ?? ?? ?? 02 9B 20 46 98 47 00 23 05 93 05 98 07 B0 BD E8 10 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_47_1 {
	meta:
		name = "__set_stl_sync_api_mode"
		size = 28
		refs = "0018 ?__stl_sync_api_impl_mode@@3W4__stl_sync_api_modes_enum@@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9A 03 4B 1A 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_25_4 {
	meta:
		name = "_SetWinRTOutOfMemoryExceptionCallback"
		size = 28
		refs = "0018 ?g_OutOfMemoryExceptionCallback@@3P6APAXXZA"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9A 03 4B 1A 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_0_1 {
	meta:
		name = "_Stopfx"
		size = 650
		refs = "0024 isspace 00d2 isalnum 0246 isxdigit"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 8A B0 0C 9B 1B 68 00 93 00 23 02 93 02 E0 00 9B 5B 1C 00 93 00 9B 93 F9 00 30 D8 B2 ?? ?? ?? ?? 05 90 05 9B 00 2B 00 D0 F1 E7 00 9B 93 F9 00 30 2D 2B 05 D1 08 23 02 93 00 9B 5B 1C 00 93 07 E0 00 9B 93 F9 00 30 2B 2B 02 D1 00 9B 5B 1C 00 93 00 9B 93 F9 00 30 6E 2B 04 D0 00 9B 93 F9 00 30 4E 2B 4F D1 00 9B 5B 1C 00 93 00 9B 93 F9 00 30 61 2B 04 D0 00 9B 93 F9 00 30 41 2B 0C D1 00 9B 5B 1C 00 93 00 9B 93 F9 00 30 6E 2B 0A D0 00 9B 93 F9 00 30 4E 2B 05 D0 0C 9B 1B 68 00 93 00 23 02 93 28 E0 00 9B 5B 1C 00 93 00 9B 03 93 04 23 02 93 03 9B 93 F9 00 30 28 2B 1C D1 03 9B 5B 1C 03 93 03 9B 93 F9 00 30 D8 B2 ?? ?? ?? ?? 06 90 06 9B 00 2B 04 D1 03 9B 93 F9 00 30 5F 2B 00 D1 EC E7 03 9B 93 F9 00 30 29 2B 04 D1 03 9B 5B 1C 03 93 03 9B 00 93 0D 9B 00 2B 02 D0 00 9A 0D 9B 1A 60 B3 E0 00 9B 93 F9 00 30 69 2B 04 D0 00 9B 93 F9 00 30 49 2B 72 D1 00 9B 5B 1C 00 93 00 9B 93 F9 00 30 6E 2B 04 D0 00 9B 93 F9 00 30 4E 2B 0C D1 00 9B 5B 1C 00 93 00 9B 93 F9 00 30 66 2B 0A D0 00 9B 93 F9 00 30 46 2B 05 D0 0C 9B 1B 68 00 93 00 23 02 93 4B E0 00 9B 5B 1C 00 93 00 9B 01 93 02 9B 43 F0 03 03 02 93 01 9B 93 F9 00 30 69 2B 04 D0 01 9B 93 F9 00 30 49 2B 38 D1 01 9B 5B 1C 01 93 01 9B 93 F9 00 30 6E 2B 04 D0 01 9B 93 F9 00 30 4E 2B 2B D1 01 9B 5B 1C 01 93 01 9B 93 F9 00 30 69 2B 04 D0 01 9B 93 F9 00 30 49 2B 1E D1 01 9B 5B 1C 01 93 01 9B 93 F9 00 30 74 2B 04 D0 01 9B 93 F9 00 30 54 2B 11 D1 01 9B 5B 1C 01 93 01 9B 93 F9 00 30 79 2B 04 D0 01 9B 93 F9 00 30 59 2B 04 D1 01 9B 5B 1C 01 93 01 9B 00 93 0D 9B 00 2B 02 D0 00 9A 0D 9B 1A 60 36 E0 00 9B 93 F9 00 30 30 2B 2D D1 00 9B 5B 1C 93 F9 00 30 78 2B 05 D0 00 9B 5B 1C 93 F9 00 30 58 2B 21 D1 00 9B 9B 1C 04 93 04 9B 93 F9 00 30 2E 2B 02 D1 04 9B 5B 1C 04 93 04 9B 93 F9 00 30 D8 B2 ?? ?? ?? ?? 07 90 07 9B 00 2B 04 D1 02 9B 43 F0 01 03 02 93 06 E0 00 9B 9B 1C 00 93 02 9B 43 F0 02 03 02 93 03 E0 02 9B 43 F0 01 03 02 93 00 9A 0C 9B 1A 60 02 9B 08 93 08 98 0A B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_6_0_1 {
	meta:
		name = "_Cnd_do_broadcast_at_thread_exit"
		size = 276
		refs = "000e _Lock_at_thread_exit_mutex 0014 _Thrd_current 0022 memcpy 0076 _Thrd_equal 00ba _Mtx_unlock 00ce _Cnd_broadcast 0106 _Unlock_at_thread_exit_mutex 0110 thread_exit_data"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8B B0 41 4B 00 93 ?? ?? ?? ?? 08 A8 ?? ?? ?? ?? 08 AB 02 93 02 99 06 A8 08 22 ?? ?? ?? ?? 00 9B 00 2B 6C D0 00 23 01 93 02 E0 01 9B 5B 1C 01 93 00 9B 03 F5 C8 73 1B 68 00 2B 5A D0 01 9B 14 2B 57 DA 00 99 01 9A 14 23 02 FB 03 F3 0B 44 08 33 1B 68 00 2B 4C D0 06 9A 07 9B 00 9C 01 98 14 21 00 FB 01 F1 21 44 03 91 03 99 08 68 49 68 ?? ?? ?? ?? 04 90 04 9B 00 2B 3A D0 00 99 01 9A 14 23 02 FB 03 F3 0B 44 10 33 1B 68 00 2B 09 D0 00 99 01 9A 14 23 02 FB 03 F3 0B 44 10 33 1A 68 01 23 13 60 00 99 01 9A 14 23 02 FB 03 F3 0B 44 08 33 18 68 ?? ?? ?? ?? 00 99 01 9A 14 23 02 FB 03 F3 0B 44 0C 33 18 68 ?? ?? ?? ?? 00 99 01 9A 14 23 02 FB 03 F3 0B 44 03 F1 08 02 00 23 13 60 00 9B 03 F5 C8 73 1B 68 5A 1E 00 9B 03 F5 C8 73 1A 60 9B E7 00 9B 03 F5 CA 73 1B 68 00 93 8F E7 ?? ?? ?? ?? 0B B0 BD E8 10 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_1_1 {
	meta:
		name = "_Cnd_register_at_thread_exit"
		size = 260
		refs = "0010 _Lock_at_thread_exit_mutex 0038 calloc 007c _Thrd_current 0096 memcpy 00f2 _Unlock_at_thread_exit_mutex 0100 thread_exit_data"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B 87 B0 3C 4B 00 93 ?? ?? ?? ?? 00 9B 00 2B 6B D0 00 9B 03 F5 C8 73 1B 68 14 2B 16 D1 00 9B 03 F5 CA 73 1B 68 00 2B 0A D1 4F F4 CC 71 01 20 ?? ?? ?? ?? 02 90 00 9B 03 F5 CA 72 02 9B 13 60 00 9B 03 F5 CA 73 1B 68 00 93 4D E0 00 23 01 93 02 E0 01 9B 5B 1C 01 93 01 9B 14 2B 42 DA 00 99 01 9A 14 23 02 FB 03 F3 0B 44 08 33 1B 68 00 2B 37 D1 04 A8 ?? ?? ?? ?? 04 AB 03 93 03 9C 00 99 01 9A 14 23 02 FB 03 F3 C8 18 21 46 08 22 ?? ?? ?? ?? 00 99 01 9A 14 23 02 FB 03 F3 0B 44 03 F1 08 02 0B 9B 13 60 00 99 01 9A 14 23 02 FB 03 F3 0B 44 03 F1 0C 02 0A 9B 13 60 00 99 01 9A 14 23 02 FB 03 F3 0B 44 03 F1 10 02 0C 9B 13 60 00 9B 03 F5 C8 73 1B 68 5A 1C 00 9B 03 F5 C8 73 1A 60 00 E0 B6 E7 00 23 00 93 90 E7 ?? ?? ?? ?? 07 B0 BD E8 10 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_2_1 {
	meta:
		name = "_Cnd_unregister_at_thread_exit"
		size = 148
		refs = "000e _Lock_at_thread_exit_mutex 0080 _Unlock_at_thread_exit_mutex 0090 thread_exit_data"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 21 4B 00 93 ?? ?? ?? ?? 00 9B 00 2B 33 D0 00 23 01 93 02 E0 01 9B 5B 1C 01 93 00 9B 03 F5 C8 73 1B 68 00 2B 21 D0 01 9B 14 2B 1E DA 00 99 01 9A 14 23 02 FB 03 F3 0B 44 08 33 1A 68 04 9B 9A 42 12 D1 00 99 01 9A 14 23 02 FB 03 F3 0B 44 03 F1 08 02 00 23 13 60 00 9B 03 F5 C8 73 1B 68 5A 1E 00 9B 03 F5 C8 73 1A 60 D4 E7 00 9B 03 F5 CA 73 1B 68 00 93 C8 E7 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_0_1 {
	meta:
		name = "_WStold"
		size = 48
		refs = "0012 _WStoldx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 00 23 08 9A 07 99 06 98 ?? ?? ?? ?? 8D ED 00 0B 9D ED 00 0B 8D ED 02 0B 9D ED 02 0B 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_45_0_1 {
	meta:
		name = "_Stod"
		size = 48
		refs = "0012 _Stodx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 00 23 08 9A 07 99 06 98 ?? ?? ?? ?? 8D ED 00 0B 9D ED 00 0B 8D ED 02 0B 9D ED 02 0B 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_64_0_1 {
	meta:
		name = "_Stold"
		size = 48
		refs = "0012 _Stoldx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 00 23 08 9A 07 99 06 98 ?? ?? ?? ?? 8D ED 00 0B 9D ED 00 0B 8D ED 02 0B 9D ED 02 0B 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_113_0_1 {
	meta:
		name = "_WStod"
		size = 48
		refs = "0012 _WStodx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 00 23 08 9A 07 99 06 98 ?? ?? ?? ?? 8D ED 00 0B 9D ED 00 0B 8D ED 02 0B 9D ED 02 0B 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_7_1_1 {
	meta:
		name = "_WStoldx"
		size = 552
		refs = "0008 __security_push_cookie 0016 _WStopfx 004e _WStoflt 0060 _LXp_setw 0086 _LXp_setn 009e _LXp_mulx 00c6 _LXp_addx 00dc _LDtento 0100 _WStoxflt 019a _LDscale 01d4 _LPmsw 01fa __security_pop_cookie 0210 _LNan 0214 _LInf"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? ED B0 70 9B 09 93 71 99 70 A8 ?? ?? ?? ?? 0C 90 0C 9B 02 93 02 9B 03 F0 08 03 0F 93 73 9B 00 2B 02 D0 73 9A 00 23 13 60 02 9B 23 F0 08 03 02 93 02 9B 01 2B 55 D1 03 23 00 93 18 AB 71 9A 70 99 09 98 ?? ?? ?? ?? 0D 90 0D 9B 08 93 9F ED 71 0B 04 21 2C A8 ?? ?? ?? ?? 08 9B 00 2B 06 D1 9F ED 67 0B 04 21 1C A8 ?? ?? ?? ?? 29 E0 01 23 03 93 18 AB 1B 1D 1A 68 04 21 1C A8 ?? ?? ?? ?? 03 9A 08 9B 9A 42 1C DA 4C AB 00 93 04 23 2C AA 04 21 1C A8 ?? ?? ?? ?? 03 9B 5B 1C 03 93 03 9A 04 23 02 FB 03 F2 18 AB 13 44 1A 68 04 21 34 A8 ?? ?? ?? ?? 04 23 34 AA 04 21 1C A8 ?? ?? ?? ?? DE E7 18 AB 72 9A 1B 68 13 44 72 93 73 9A 72 99 1C A8 ?? ?? ?? ?? 8D ED 12 0B 9D ED 12 0B 8D ED 06 0B 6E E0 02 9B 02 2B 55 D1 03 23 00 93 18 AB 71 9A 70 99 09 98 ?? ?? ?? ?? 0E 90 0E 9B 0A 93 9F ED 43 0B 04 21 3C A8 ?? ?? ?? ?? 0A 9B 00 2B 06 D1 9F ED 3A 0B 04 21 24 A8 ?? ?? ?? ?? 29 E0 01 23 04 93 18 AB 1B 1D 1A 68 04 21 24 A8 ?? ?? ?? ?? 04 9A 0A 9B 9A 42 1C DA 5C AB 00 93 04 23 3C AA 04 21 24 A8 ?? ?? ?? ?? 04 9B 5B 1C 04 93 04 9A 04 23 02 FB 03 F2 18 AB 13 44 1A 68 04 21 44 A8 ?? ?? ?? ?? 04 23 44 AA 04 21 24 A8 ?? ?? ?? ?? DE E7 73 9A 72 99 24 A8 ?? ?? ?? ?? 8D ED 14 0B 9D ED 14 0B 8D ED 06 0B 18 AB 19 68 06 A8 ?? ?? ?? ?? 15 E0 02 9B 03 2B 05 D1 1B 4B 93 ED 00 0B 8D ED 06 0B 0C E0 02 9B 04 2B 05 D1 15 4B 93 ED 00 0B 8D ED 06 0B 03 E0 9F ED 10 0B 8D ED 06 0B 0F 9B 00 2B 0C D0 06 A8 ?? ?? ?? ?? 10 90 10 9B 0B 93 0B 9B 1B 88 83 F4 00 43 9A B2 0B 9B 1A 80 9D ED 06 0B 8D ED 16 0B 9D ED 16 0B 6D B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB FE DE 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 B0 41 00 00 00 00 65 CD CD 41 }
	condition:
		$1
}

rule file_45_1_1 {
	meta:
		name = "_Stodx"
		size = 552
		refs = "0008 __security_push_cookie 0016 _Stopfx 004e _Stoflt 0060 _Xp_setw 0086 _Xp_setn 009e _Xp_mulx 00c6 _Xp_addx 00dc _Dtento 0100 _Stoxflt 019a _Dscale 01d4 _Pmsw 01fa __security_pop_cookie 0210 _Nan 0214 _Inf"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? ED B0 70 9B 09 93 71 99 70 A8 ?? ?? ?? ?? 0C 90 0C 9B 02 93 02 9B 03 F0 08 03 0F 93 73 9B 00 2B 02 D0 73 9A 00 23 13 60 02 9B 23 F0 08 03 02 93 02 9B 01 2B 55 D1 03 23 00 93 18 AB 71 9A 70 99 09 98 ?? ?? ?? ?? 0D 90 0D 9B 08 93 9F ED 71 0B 04 21 2C A8 ?? ?? ?? ?? 08 9B 00 2B 06 D1 9F ED 67 0B 04 21 1C A8 ?? ?? ?? ?? 29 E0 01 23 03 93 18 AB 1B 1D 1A 68 04 21 1C A8 ?? ?? ?? ?? 03 9A 08 9B 9A 42 1C DA 4C AB 00 93 04 23 2C AA 04 21 1C A8 ?? ?? ?? ?? 03 9B 5B 1C 03 93 03 9A 04 23 02 FB 03 F2 18 AB 13 44 1A 68 04 21 34 A8 ?? ?? ?? ?? 04 23 34 AA 04 21 1C A8 ?? ?? ?? ?? DE E7 18 AB 72 9A 1B 68 13 44 72 93 73 9A 72 99 1C A8 ?? ?? ?? ?? 8D ED 12 0B 9D ED 12 0B 8D ED 06 0B 6E E0 02 9B 02 2B 55 D1 03 23 00 93 18 AB 71 9A 70 99 09 98 ?? ?? ?? ?? 0E 90 0E 9B 0A 93 9F ED 43 0B 04 21 3C A8 ?? ?? ?? ?? 0A 9B 00 2B 06 D1 9F ED 3A 0B 04 21 24 A8 ?? ?? ?? ?? 29 E0 01 23 04 93 18 AB 1B 1D 1A 68 04 21 24 A8 ?? ?? ?? ?? 04 9A 0A 9B 9A 42 1C DA 5C AB 00 93 04 23 3C AA 04 21 24 A8 ?? ?? ?? ?? 04 9B 5B 1C 04 93 04 9A 04 23 02 FB 03 F2 18 AB 13 44 1A 68 04 21 44 A8 ?? ?? ?? ?? 04 23 44 AA 04 21 24 A8 ?? ?? ?? ?? DE E7 73 9A 72 99 24 A8 ?? ?? ?? ?? 8D ED 14 0B 9D ED 14 0B 8D ED 06 0B 18 AB 19 68 06 A8 ?? ?? ?? ?? 15 E0 02 9B 03 2B 05 D1 1B 4B 93 ED 00 0B 8D ED 06 0B 0C E0 02 9B 04 2B 05 D1 15 4B 93 ED 00 0B 8D ED 06 0B 03 E0 9F ED 10 0B 8D ED 06 0B 0F 9B 00 2B 0C D0 06 A8 ?? ?? ?? ?? 10 90 10 9B 0B 93 0B 9B 1B 88 83 F4 00 43 9A B2 0B 9B 1A 80 9D ED 06 0B 8D ED 16 0B 9D ED 16 0B 6D B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB FE DE 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 B0 41 00 00 00 00 65 CD CD 41 }
	condition:
		$1
}

rule file_64_1_1 {
	meta:
		name = "_Stoldx"
		size = 552
		refs = "0008 __security_push_cookie 0016 _Stopfx 004e _Stoflt 0060 _LXp_setw 0086 _LXp_setn 009e _LXp_mulx 00c6 _LXp_addx 00dc _LDtento 0100 _Stoxflt 019a _LDscale 01d4 _LPmsw 01fa __security_pop_cookie 0210 _LNan 0214 _LInf"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? ED B0 70 9B 09 93 71 99 70 A8 ?? ?? ?? ?? 0C 90 0C 9B 02 93 02 9B 03 F0 08 03 0F 93 73 9B 00 2B 02 D0 73 9A 00 23 13 60 02 9B 23 F0 08 03 02 93 02 9B 01 2B 55 D1 03 23 00 93 18 AB 71 9A 70 99 09 98 ?? ?? ?? ?? 0D 90 0D 9B 08 93 9F ED 71 0B 04 21 2C A8 ?? ?? ?? ?? 08 9B 00 2B 06 D1 9F ED 67 0B 04 21 1C A8 ?? ?? ?? ?? 29 E0 01 23 03 93 18 AB 1B 1D 1A 68 04 21 1C A8 ?? ?? ?? ?? 03 9A 08 9B 9A 42 1C DA 4C AB 00 93 04 23 2C AA 04 21 1C A8 ?? ?? ?? ?? 03 9B 5B 1C 03 93 03 9A 04 23 02 FB 03 F2 18 AB 13 44 1A 68 04 21 34 A8 ?? ?? ?? ?? 04 23 34 AA 04 21 1C A8 ?? ?? ?? ?? DE E7 18 AB 72 9A 1B 68 13 44 72 93 73 9A 72 99 1C A8 ?? ?? ?? ?? 8D ED 12 0B 9D ED 12 0B 8D ED 06 0B 6E E0 02 9B 02 2B 55 D1 03 23 00 93 18 AB 71 9A 70 99 09 98 ?? ?? ?? ?? 0E 90 0E 9B 0A 93 9F ED 43 0B 04 21 3C A8 ?? ?? ?? ?? 0A 9B 00 2B 06 D1 9F ED 3A 0B 04 21 24 A8 ?? ?? ?? ?? 29 E0 01 23 04 93 18 AB 1B 1D 1A 68 04 21 24 A8 ?? ?? ?? ?? 04 9A 0A 9B 9A 42 1C DA 5C AB 00 93 04 23 3C AA 04 21 24 A8 ?? ?? ?? ?? 04 9B 5B 1C 04 93 04 9A 04 23 02 FB 03 F2 18 AB 13 44 1A 68 04 21 44 A8 ?? ?? ?? ?? 04 23 44 AA 04 21 24 A8 ?? ?? ?? ?? DE E7 73 9A 72 99 24 A8 ?? ?? ?? ?? 8D ED 14 0B 9D ED 14 0B 8D ED 06 0B 18 AB 19 68 06 A8 ?? ?? ?? ?? 15 E0 02 9B 03 2B 05 D1 1B 4B 93 ED 00 0B 8D ED 06 0B 0C E0 02 9B 04 2B 05 D1 15 4B 93 ED 00 0B 8D ED 06 0B 03 E0 9F ED 10 0B 8D ED 06 0B 0F 9B 00 2B 0C D0 06 A8 ?? ?? ?? ?? 10 90 10 9B 0B 93 0B 9B 1B 88 83 F4 00 43 9A B2 0B 9B 1A 80 9D ED 06 0B 8D ED 16 0B 9D ED 16 0B 6D B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB FE DE 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 B0 41 00 00 00 00 65 CD CD 41 }
	condition:
		$1
}

rule file_113_1_1 {
	meta:
		name = "_WStodx"
		size = 552
		refs = "0008 __security_push_cookie 0016 _WStopfx 004e _WStoflt 0060 _Xp_setw 0086 _Xp_setn 009e _Xp_mulx 00c6 _Xp_addx 00dc _Dtento 0100 _WStoxflt 019a _Dscale 01d4 _Pmsw 01fa __security_pop_cookie 0210 _Nan 0214 _Inf"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? ED B0 70 9B 09 93 71 99 70 A8 ?? ?? ?? ?? 0C 90 0C 9B 02 93 02 9B 03 F0 08 03 0F 93 73 9B 00 2B 02 D0 73 9A 00 23 13 60 02 9B 23 F0 08 03 02 93 02 9B 01 2B 55 D1 03 23 00 93 18 AB 71 9A 70 99 09 98 ?? ?? ?? ?? 0D 90 0D 9B 08 93 9F ED 71 0B 04 21 2C A8 ?? ?? ?? ?? 08 9B 00 2B 06 D1 9F ED 67 0B 04 21 1C A8 ?? ?? ?? ?? 29 E0 01 23 03 93 18 AB 1B 1D 1A 68 04 21 1C A8 ?? ?? ?? ?? 03 9A 08 9B 9A 42 1C DA 4C AB 00 93 04 23 2C AA 04 21 1C A8 ?? ?? ?? ?? 03 9B 5B 1C 03 93 03 9A 04 23 02 FB 03 F2 18 AB 13 44 1A 68 04 21 34 A8 ?? ?? ?? ?? 04 23 34 AA 04 21 1C A8 ?? ?? ?? ?? DE E7 18 AB 72 9A 1B 68 13 44 72 93 73 9A 72 99 1C A8 ?? ?? ?? ?? 8D ED 12 0B 9D ED 12 0B 8D ED 06 0B 6E E0 02 9B 02 2B 55 D1 03 23 00 93 18 AB 71 9A 70 99 09 98 ?? ?? ?? ?? 0E 90 0E 9B 0A 93 9F ED 43 0B 04 21 3C A8 ?? ?? ?? ?? 0A 9B 00 2B 06 D1 9F ED 3A 0B 04 21 24 A8 ?? ?? ?? ?? 29 E0 01 23 04 93 18 AB 1B 1D 1A 68 04 21 24 A8 ?? ?? ?? ?? 04 9A 0A 9B 9A 42 1C DA 5C AB 00 93 04 23 3C AA 04 21 24 A8 ?? ?? ?? ?? 04 9B 5B 1C 04 93 04 9A 04 23 02 FB 03 F2 18 AB 13 44 1A 68 04 21 44 A8 ?? ?? ?? ?? 04 23 44 AA 04 21 24 A8 ?? ?? ?? ?? DE E7 73 9A 72 99 24 A8 ?? ?? ?? ?? 8D ED 14 0B 9D ED 14 0B 8D ED 06 0B 18 AB 19 68 06 A8 ?? ?? ?? ?? 15 E0 02 9B 03 2B 05 D1 1B 4B 93 ED 00 0B 8D ED 06 0B 0C E0 02 9B 04 2B 05 D1 15 4B 93 ED 00 0B 8D ED 06 0B 03 E0 9F ED 10 0B 8D ED 06 0B 0F 9B 00 2B 0C D0 06 A8 ?? ?? ?? ?? 10 90 10 9B 0B 93 0B 9B 1B 88 83 F4 00 43 9A B2 0B 9B 1A 80 9D ED 06 0B 8D ED 16 0B 9D ED 16 0B 6D B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB FE DE 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 B0 41 00 00 00 00 65 CD CD 41 }
	condition:
		$1
}

rule file_8_0_1 {
	meta:
		name = "_LSinh"
		size = 576
		refs = "0012 _LDtest 0150 _LPoly 01a8 _LExp 01f6 _Feraise 0234 _LXbig 0238 p 023c _LRteps"
	strings:
		$1 = { 2D E9 00 48 EB 46 96 B0 8D ED 06 1B 8D ED 04 0B 04 A8 ?? ?? ?? ?? AD F8 02 00 BD F9 02 30 02 93 02 9B 00 2B 31 D0 02 9B 01 2B 08 D0 02 9B 02 2B 00 D0 33 E0 9D ED 04 0B 8D ED 08 0B F4 E0 9D ED 06 0B B5 EE 40 0B F1 EE 10 FA 04 D0 9D ED 04 0B 8D ED 0C 0B 14 E0 04 AB 9B 1D 1B 88 13 F4 00 4F 06 D0 9D ED 06 0B B1 EE 40 0B 8D ED 0A 0B 03 E0 9D ED 06 0B 8D ED 0A 0B 9D ED 0A 0B 8D ED 0C 0B 9D ED 0C 0B 8D ED 08 0B CE E0 9D ED 04 1B 9D ED 06 0B 21 EE 00 0B 8D ED 08 0B C5 E0 9D ED 06 0B B5 EE 40 0B F1 EE 10 FA 16 D1 9D ED 04 0B B5 EE C0 0B F1 EE 10 FA 06 D2 9D ED 06 0B B1 EE 40 0B 8D ED 0E 0B 03 E0 9D ED 06 0B 8D ED 0E 0B 9D ED 0E 0B 8D ED 08 0B A7 E0 9D ED 04 0B B5 EE C0 0B F1 EE 10 FA 09 D2 9D ED 04 0B B1 EE 40 0B 8D ED 04 0B 01 23 AD F8 00 30 02 E0 00 23 AD F8 00 30 9D ED 04 1B 4D 4B 93 ED 00 0B B4 EE C0 1B F1 EE 10 FA 08 D2 9D ED 04 1B 9D ED 06 0B 21 EE 00 0B 8D ED 04 0B 6D E0 9D ED 04 1B B7 EE 00 0B B4 EE C0 1B F1 EE 10 FA 28 D2 9D ED 04 1B 9D ED 04 0B 21 EE 00 0B 8D ED 10 0B 07 21 3B 48 9D ED 10 0B ?? ?? ?? ?? 8D ED 14 0B 9D ED 04 1B 9D ED 10 0B 21 EE 00 1B 9D ED 14 0B 21 EE 00 1B 9D ED 04 0B 30 EE 01 0B 8D ED 04 0B 9D ED 04 1B 9D ED 06 0B 21 EE 00 0B 8D ED 04 0B 3B E0 9D ED 04 1B 29 4B 93 ED 00 0B B4 EE C0 1B F1 EE 10 FA 17 D2 6F F0 00 01 B7 EE 00 0B 04 A8 ?? ?? ?? ?? B5 EE 00 1B 9D ED 04 0B 81 EE 00 1B 9D ED 04 0B 30 EE 41 1B 9D ED 06 0B 20 EE 01 0B 8D ED 04 0B 19 E0 6F F0 00 01 9D ED 06 0B 04 A8 ?? ?? ?? ?? AD F8 04 00 BD F9 04 30 03 93 03 9B 00 2B 03 D0 03 9B 01 2B 04 D0 06 E0 10 20 ?? ?? ?? ?? 02 E0 08 20 ?? ?? ?? ?? BD F9 00 30 00 2B 06 D0 9D ED 04 0B B1 EE 40 0B 8D ED 12 0B 03 E0 9D ED 04 0B 8D ED 12 0B 9D ED 12 0B 8D ED 08 0B 9D ED 08 0B 16 B0 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_0_1 {
	meta:
		name = "??0_ContextCallback@details@Concurrency@@QAA@_N@Z"
		size = 48
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 9D F8 14 30 00 2B 03 D0 04 9A 01 23 13 60 02 E0 04 9A 00 23 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_9_1_1 {
	meta:
		name = "??0task_continuation_context@Concurrency@@AAA@XZ"
		size = 44
		refs = "000e ??0_ContextCallback@details@Concurrency@@QAA@_N@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 00 21 04 98 ?? ?? ?? ?? 01 90 04 9B 1A 1D 00 23 13 70 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_9_4_1 {
	meta:
		name = "??R?$_Func_class@X$$V@std@@QBAXXZ"
		size = 80
		refs = "000e ?_Empty@?$_Func_class@X$$V@std@@IBA_NXZ 001e ?_Xbad_function_call@std@@YAXXZ 0024 ?_Getimpl@?$_Func_class@X$$V@std@@ABAPAV?$_Func_base@X$$V@2@XZ 003c _guard_check_icall"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 85 B0 08 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 01 D0 ?? ?? ?? ?? 08 98 ?? ?? ?? ?? 03 90 03 9B 01 93 01 9B 1B 68 08 33 01 9C 1B 68 02 93 02 98 ?? ?? ?? ?? 02 9B 20 46 98 47 05 B0 BD E8 10 08 5D F8 0C FB }
	condition:
		$1
}

rule file_9_5_1 {
	meta:
		name = "?CaptureCallstack@platform@details@Concurrency@@YAIPAPAXII@Z"
		size = 64
		refs = "003c __imp_RtlCaptureStackBackTrace"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B 83 B0 00 23 01 93 00 23 06 9A 08 99 07 98 40 1C 08 4C 24 68 A0 47 AD F8 00 00 BD F8 00 30 01 93 01 9B 02 93 02 98 03 B0 BD E8 10 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_6_1 {
	meta:
		name = "?GetCurrentThreadId@platform@details@Concurrency@@YAJXZ"
		size = 32
		refs = "001c __imp_GetCurrentThreadId"
		altNames = "_Thrd_id"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 04 4B 1B 68 98 47 00 90 00 9B 01 93 01 98 02 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_7_1 {
	meta:
		name = "?GetNextAsyncId@platform@details@Concurrency@@YAIXZ"
		size = 52
		refs = "0030 ?s_asyncId@platform@details@Concurrency@@3IA"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 BF F3 5B 8F 08 49 51 E8 00 2F 52 1C 41 E8 00 23 00 2B F8 D1 13 46 00 93 BF F3 5B 8F 00 9B 01 93 01 98 02 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_10_1 {
	meta:
		name = "?_CallInContext@_ContextCallback@details@Concurrency@@QBAXV?$function@$$A6AXXZ@std@@_N@Z"
		size = 44
		refs = "0018 ??R?$_Func_class@X$$V@std@@QBAXXZ 001e ??1?$function@$$A6AXXZ@std@@QAA@XZ"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 F8 69 ?? ?? ?? ?? F8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 14 FB }
	condition:
		$1
}

rule file_9_13_1 {
	meta:
		name = "?_Empty@?$_Func_class@X$$V@std@@IBA_NXZ"
		size = 56
		refs = "000c ?_Getimpl@?$_Func_class@X$$V@std@@ABAPAV?$_Func_base@X$$V@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 01 90 01 9B 00 2B 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_61_147_1 {
	meta:
		name = "?good@ios_base@std@@QBA_NXZ"
		size = 56
		refs = "000c ?rdstate@ios_base@std@@QBAHXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 01 90 01 9B 00 2B 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_101_1 {
	meta:
		name = "_Current_set"
		size = 56
		refs = "000c _wchdir"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 01 90 01 9B 00 2B 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_9_14_1 {
	meta:
		name = "?_Getimpl@?$_Func_class@X$$V@std@@ABAPAV?$_Func_base@X$$V@2@XZ"
		size = 30
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 24 33 1B 68 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_9_16_1 {
	meta:
		name = "?_IsCurrentOriginSTA@_ContextCallback@details@Concurrency@@CA_NXZ"
		size = 24
		altNames = "?_IsNonBlockingThread@_Task_impl_base@details@Concurrency@@SA_NXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 00 23 8D F8 00 30 9D F8 00 00 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_9_18_1 {
	meta:
		name = "?_Local@?$_Func_class@X$$V@std@@ABA_NXZ"
		size = 66
		refs = "000c ?_Getimpl@?$_Func_class@X$$V@std@@ABAPAV?$_Func_base@X$$V@2@XZ 0014 ?_Getspace@?$_Func_class@X$$V@std@@ABAPBXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 01 90 06 98 ?? ?? ?? ?? 02 90 01 9A 02 9B 9A 42 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 0C 30 9D F8 0C 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_9_27_1 {
	meta:
		name = "?_Set@?$_Func_class@X$$V@std@@AAAXPAV?$_Func_base@X$$V@2@@Z"
		size = 26
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 03 F1 24 02 03 9B 13 60 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_9_28_1 {
	meta:
		name = "?_Tidy@?$_Func_class@X$$V@std@@IAAXXZ"
		size = 122
		refs = "000e ?_Empty@?$_Func_class@X$$V@std@@IBA_NXZ 0020 ?_Local@?$_Func_class@X$$V@std@@ABA_NXZ 0040 ?_Getimpl@?$_Func_class@X$$V@std@@ABAPAV?$_Func_base@X$$V@2@XZ 005c _guard_check_icall 006c ?_Set@?$_Func_class@X$$V@std@@AAAXPAV?$_Func_base@X$$V@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 84 B0 08 98 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 28 D1 08 98 ?? ?? ?? ?? 8D F8 02 00 9D F8 02 30 00 2B 03 D1 01 23 8D F8 00 30 02 E0 00 23 8D F8 00 30 08 98 ?? ?? ?? ?? 03 90 03 9B 01 93 9D F8 00 50 01 9C 01 9B 1B 68 10 33 1B 68 02 93 02 98 ?? ?? ?? ?? 02 9B 20 46 29 46 98 47 00 21 08 98 ?? ?? ?? ?? 04 B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_0_1 {
	meta:
		name = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAA@U_Zero_then_variadic_args_t@1@@Z"
		size = 40
		refs = "000c ??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAA@XZ 0012 ??0?$_String_val@U?$_Simple_types@D@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 98 ?? ?? ?? ?? 01 90 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_1_1 {
	meta:
		name = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAA@U_Zero_then_variadic_args_t@1@@Z"
		size = 40
		refs = "000c ??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAA@XZ 0012 ??0?$_String_val@U?$_Simple_types@G@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 98 ?? ?? ?? ?? 01 90 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_0_1 {
	meta:
		name = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAA@U_Zero_then_variadic_args_t@1@@Z"
		size = 40
		refs = "000c ??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAA@XZ 0012 ??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 98 ?? ?? ?? ?? 01 90 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_1_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAA@U_One_then_variadic_args_t@1@$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
		size = 50
		refs = "000c ??$forward@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AAU10@@Z 0016 ??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAA@$$QAU01@@Z 001c ??0?$_String_val@U?$_Simple_types@D@std@@@std@@QAA@XZ"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 08 98 ?? ?? ?? ?? 00 90 00 99 06 98 ?? ?? ?? ?? 06 98 ?? ?? ?? ?? 02 90 06 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_5_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAA@U_One_then_variadic_args_t@1@$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z"
		size = 50
		refs = "000c ??$forward@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AAU10@@Z 0016 ??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAA@$$QAU01@@Z 001c ??0?$_String_val@U?$_Simple_types@G@std@@@std@@QAA@XZ"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 08 98 ?? ?? ?? ?? 00 90 00 99 06 98 ?? ?? ?? ?? 06 98 ?? ?? ?? ?? 02 90 06 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_7_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAA@U_One_then_variadic_args_t@1@$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z"
		size = 50
		refs = "000c ??$forward@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AAU10@@Z 0016 ??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAA@$$QAU01@@Z 001c ??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QAA@XZ"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 08 98 ?? ?? ?? ?? 00 90 00 99 06 98 ?? ?? ?? ?? 06 98 ?? ?? ?? ?? 02 90 06 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_2_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
		size = 48
		refs = "000c ??$forward@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AAU10@@Z 001a ??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAA@U_One_then_variadic_args_t@1@$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 98 ?? ?? ?? ?? 01 90 01 9A 9D F8 00 10 06 98 ?? ?? ?? ?? 03 90 06 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_6_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z"
		size = 48
		refs = "000c ??$forward@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AAU10@@Z 001a ??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAA@U_One_then_variadic_args_t@1@$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 98 ?? ?? ?? ?? 01 90 01 9A 9D F8 00 10 06 98 ?? ?? ?? ?? 03 90 06 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_8_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z"
		size = 48
		refs = "000c ??$forward@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AAU10@@Z 001a ??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAA@U_One_then_variadic_args_t@1@$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 98 ?? ?? ?? ?? 01 90 01 9A 9D F8 00 10 06 98 ?? ?? ?? ?? 03 90 06 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_3_1 {
	meta:
		name = "??$?0V?$allocator@D@std@@@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAA@$$QAV?$allocator@D@1@@Z"
		size = 42
		refs = "000c ??$forward@V?$allocator@D@std@@@std@@YA$$QAV?$allocator@D@0@AAV10@@Z 0016 ??0?$allocator@D@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_78_1_2 {
	meta:
		name = "??$?0AAU?$_Wrap_alloc@V?$allocator@D@std@@@std@@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAA@AAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
		size = 42
		refs = "000c ??$forward@AAU?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YAAAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AAU10@@Z 0016 ??$?0D@?$allocator@U_Container_proxy@std@@@std@@QAA@ABV?$allocator@D@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_4_2 {
	meta:
		name = "??$?0AAU?$_Wrap_alloc@V?$allocator@G@std@@@std@@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAA@AAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z"
		size = 42
		refs = "000c ??$forward@AAU?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YAAAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AAU10@@Z 0016 ??$?0G@?$allocator@U_Container_proxy@std@@@std@@QAA@ABV?$allocator@G@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_17_1_3 {
	meta:
		name = "??$?0AAU?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAA@AAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z"
		size = 42
		refs = "000c ??$forward@AAU?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AAU10@@Z 0016 ??$?0_W@?$allocator@U_Container_proxy@std@@@std@@QAA@ABV?$allocator@_W@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_18_2 {
	meta:
		name = "??$?0V?$allocator@G@std@@@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAA@$$QAV?$allocator@G@1@@Z"
		size = 42
		refs = "000c ??$forward@V?$allocator@G@std@@@std@@YA$$QAV?$allocator@G@0@AAV10@@Z 0016 ??0?$allocator@G@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_19_3 {
	meta:
		name = "??$?0V?$allocator@_W@std@@@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAA@$$QAV?$allocator@_W@1@@Z"
		size = 42
		refs = "000c ??$forward@V?$allocator@_W@std@@@std@@YA$$QAV?$allocator@_W@0@AAV10@@Z 0016 ??0?$allocator@_W@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_32_1 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAA@$$QAU01@@Z"
		size = 42
		refs = "000c ??$move@AAU?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AAU10@@Z 0016 ??0?$allocator@D@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_191_1 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAA@$$QAU01@@Z"
		size = 42
		refs = "000c ??$move@AAU?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AAU10@@Z 0016 ??0?$allocator@G@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_193_1 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAA@$$QAU01@@Z"
		size = 42
		refs = "000c ??$move@AAU?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AAU10@@Z 0016 ??0?$allocator@_W@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_4_1 {
	meta:
		name = "??$_Fgetc@D@std@@YA_NAADPAU_iobuf@@@Z"
		size = 68
		refs = "000c fgetc"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 98 ?? ?? ?? ?? 02 90 02 9B 00 93 00 9B B3 F1 FF 3F 04 D1 00 23 8D F8 04 30 07 E0 06 E0 00 9B 5A B2 06 9B 1A 70 01 23 8D F8 04 30 9D F8 04 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_5_1 {
	meta:
		name = "??$_Fputc@D@std@@YA_NDPAU_iobuf@@@Z"
		size = 62
		refs = "0010 fputc"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 99 9D F9 18 00 ?? ?? ?? ?? 01 90 01 9B B3 F1 FF 3F 02 D0 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_6_1 {
	meta:
		name = "??$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ"
		size = 80
		refs = "002c ??0?$_Immortalizer@V_Iostream_error_category@std@@@std@@QAA@XZ 0032 atexit 0044 ?_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@1@XZ@4U?$_Immortalizer@V_Iostream_error_category@std@@@1@A 0048 ??__F_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ@YAXXZ 004c ??_B?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ@51"
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 0D 4B 1B 68 13 F0 01 0F 0B D1 0B 4B 1B 68 43 F0 01 02 09 4B 1A 60 06 48 ?? ?? ?? ?? 05 48 ?? ?? ?? ?? 03 4B 3B 60 38 68 05 B0 BD E8 80 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_7_1 {
	meta:
		name = "??$_Immortalize@V_Generic_error_category@std@@@std@@YAAAV_Generic_error_category@0@XZ"
		size = 80
		refs = "002c ??0?$_Immortalizer@V_Generic_error_category@std@@@std@@QAA@XZ 0032 atexit 0044 ?_Static@?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAAV_Generic_error_category@1@XZ@4U?$_Immortalizer@V_Generic_error_category@std@@@1@A 0048 ??__F_Static@?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAAV_Generic_error_category@0@XZ@YAXXZ 004c ??_B?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAAV_Generic_error_category@0@XZ@51"
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 0D 4B 1B 68 13 F0 01 0F 0B D1 0B 4B 1B 68 43 F0 01 02 09 4B 1A 60 06 48 ?? ?? ?? ?? 05 48 ?? ?? ?? ?? 03 4B 3B 60 38 68 05 B0 BD E8 80 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_9_1 {
	meta:
		name = "??$_Immortalize@V_System_error_category@std@@@std@@YAAAV_System_error_category@0@XZ"
		size = 80
		refs = "002c ??0?$_Immortalizer@V_System_error_category@std@@@std@@QAA@XZ 0032 atexit 0044 ?_Static@?1???$_Immortalize@V_System_error_category@std@@@std@@YAAAV_System_error_category@1@XZ@4U?$_Immortalizer@V_System_error_category@std@@@1@A 0048 ??__F_Static@?1???$_Immortalize@V_System_error_category@std@@@std@@YAAAV_System_error_category@0@XZ@YAXXZ 004c ??_B?1???$_Immortalize@V_System_error_category@std@@@std@@YAAAV_System_error_category@0@XZ@51"
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 0D 4B 1B 68 13 F0 01 0F 0B D1 0B 4B 1B 68 43 F0 01 02 09 4B 1A 60 06 48 ?? ?? ?? ?? 05 48 ?? ?? ?? ?? 03 4B 3B 60 38 68 05 B0 BD E8 80 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_7_1 {
	meta:
		name = "__unwindfunclet$??$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ$0"
		size = 20
		refs = "0010 ??_B?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ@51"
	strings:
		$1 = { 03 4B 1B 68 23 F0 01 02 01 4B 1A 60 70 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_8_1 {
	meta:
		name = "__unwindfunclet$??$_Immortalize@V_Generic_error_category@std@@@std@@YAAAV_Generic_error_category@0@XZ$0"
		size = 20
		refs = "0010 ??_B?1???$_Immortalize@V_Generic_error_category@std@@@std@@YAAAV_Generic_error_category@0@XZ@51"
	strings:
		$1 = { 03 4B 1B 68 23 F0 01 02 01 4B 1A 60 70 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_10_1 {
	meta:
		name = "__unwindfunclet$??$_Immortalize@V_System_error_category@std@@@std@@YAAAV_System_error_category@0@XZ$0"
		size = 20
		refs = "0010 ??_B?1???$_Immortalize@V_System_error_category@std@@@std@@YAAAV_System_error_category@0@XZ@51"
	strings:
		$1 = { 03 4B 1B 68 23 F0 01 02 01 4B 1A 60 70 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_9_1 {
	meta:
		name = "??$_Ungetc@D@std@@YA_NABDPAU_iobuf@@@Z"
		size = 66
		refs = "0014 ungetc"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 99 06 9B 93 F9 00 30 D8 B2 ?? ?? ?? ?? 01 90 01 9B B3 F1 FF 3F 02 D0 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_12_1 {
	meta:
		name = "??$construct@PADAAPAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAXPAPADAAPAD@Z"
		size = 38
		refs = "000c ??$forward@AAPAD@std@@YAAAPADAAPAD@Z 0018 ??$construct@PADAAPAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAAV?$allocator@D@1@PAPADAAPAD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 98 ?? ?? ?? ?? 00 90 00 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_36_160_3 {
	meta:
		name = "??$construct@PADAAPAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAAV?$allocator@D@1@PAPADAAPAD@Z"
		size = 38
		refs = "000c ??$forward@AAPAD@std@@YAAAPADAAPAD@Z 0018 ??$construct@PADAAPAD@?$allocator@D@std@@QAAXPAPADAAPAD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 98 ?? ?? ?? ?? 00 90 00 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_36_161_3 {
	meta:
		name = "??$construct@PAGAAPAG@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAXPAPAGAAPAG@Z"
		size = 38
		refs = "000c ??$forward@AAPAG@std@@YAAAPAGAAPAG@Z 0018 ??$construct@PAGAAPAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAAV?$allocator@G@1@PAPAGAAPAG@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 98 ?? ?? ?? ?? 00 90 00 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_36_163_3 {
	meta:
		name = "??$construct@PAGAAPAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAAV?$allocator@G@1@PAPAGAAPAG@Z"
		size = 38
		refs = "000c ??$forward@AAPAG@std@@YAAAPAGAAPAG@Z 0018 ??$construct@PAGAAPAG@?$allocator@G@std@@QAAXPAPAGAAPAG@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 98 ?? ?? ?? ?? 00 90 00 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_32_3_1 {
	meta:
		name = "??$construct@PA_WAAPA_W@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAXPAPA_WAAPA_W@Z"
		size = 38
		refs = "000c ??$forward@AAPA_W@std@@YAAAPA_WAAPA_W@Z 0018 ??$construct@PA_WAAPA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAAV?$allocator@_W@1@PAPA_WAAPA_W@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 98 ?? ?? ?? ?? 00 90 00 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_36_166_3 {
	meta:
		name = "??$construct@PA_WAAPA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAAV?$allocator@_W@1@PAPA_WAAPA_W@Z"
		size = 38
		refs = "000c ??$forward@AAPA_W@std@@YAAAPA_WAAPA_W@Z 0018 ??$construct@PA_WAAPA_W@?$allocator@_W@std@@QAAXPAPA_WAAPA_W@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 98 ?? ?? ?? ?? 00 90 00 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_82_28_3 {
	meta:
		name = "??$construct@U_Container_proxy@std@@U12@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAAXPAU_Container_proxy@1@$$QAU21@@Z"
		size = 38
		refs = "000c ??$forward@U_Container_proxy@std@@@std@@YA$$QAU_Container_proxy@0@AAU10@@Z 0018 ??$construct@U_Container_proxy@std@@U12@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAAV?$allocator@U_Container_proxy@std@@@1@PAU_Container_proxy@1@$$QAU31@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 98 ?? ?? ?? ?? 00 90 00 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_7_14_2 {
	meta:
		name = "??$construct@U_Container_proxy@std@@U12@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAAV?$allocator@U_Container_proxy@std@@@1@PAU_Container_proxy@1@$$QAU31@@Z"
		size = 38
		refs = "000c ??$forward@U_Container_proxy@std@@@std@@YA$$QAU_Container_proxy@0@AAU10@@Z 0018 ??$construct@U_Container_proxy@std@@U12@@?$allocator@U_Container_proxy@std@@@std@@QAAXPAU_Container_proxy@1@$$QAU21@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 98 ?? ?? ?? ?? 00 90 00 9A 05 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_13_1 {
	meta:
		name = "??$construct@PADAAPAD@?$allocator@D@std@@QAAXPAPADAAPAD@Z"
		size = 66
		refs = "000e ??2@YAPAXIPAX@Z 0020 ??$forward@AAPAD@std@@YAAAPADAAPAD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 07 99 04 20 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 00 2B 0A D0 08 98 ?? ?? ?? ?? 02 90 02 9B 1A 68 00 9B 1A 60 00 9B 03 93 01 E0 00 23 03 93 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_91_1 {
	meta:
		name = "??$construct@PAGAAPAG@?$allocator@G@std@@QAAXPAPAGAAPAG@Z"
		size = 66
		refs = "000e ??2@YAPAXIPAX@Z 0020 ??$forward@AAPAG@std@@YAAAPAGAAPAG@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 07 99 04 20 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 00 2B 0A D0 08 98 ?? ?? ?? ?? 02 90 02 9B 1A 68 00 9B 1A 60 00 9B 03 93 01 E0 00 23 03 93 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_5_1 {
	meta:
		name = "??$construct@PA_WAAPA_W@?$allocator@_W@std@@QAAXPAPA_WAAPA_W@Z"
		size = 66
		refs = "000e ??2@YAPAXIPAX@Z 0020 ??$forward@AAPA_W@std@@YAAAPA_WAAPA_W@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 07 99 04 20 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 00 2B 0A D0 08 98 ?? ?? ?? ?? 02 90 02 9B 1A 68 00 9B 1A 60 00 9B 03 93 01 E0 00 23 03 93 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_15_1 {
	meta:
		name = "??$destroy@PAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAXPAPAD@Z"
		size = 24
		refs = "000c ??$destroy@PAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAAV?$allocator@D@1@PAPAD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_33_18_3 {
	meta:
		name = "??$_Swap_adl@PAD@std@@YAXAAPAD0@Z"
		size = 24
		refs = "000c ??$swap@PADX@std@@YAXAAPAD0@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_33_21_2 {
	meta:
		name = "??$destroy@PAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAAV?$allocator@D@1@PAPAD@Z"
		size = 24
		refs = "000c ??$destroy@PAD@?$allocator@D@std@@QAAXPAPAD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_175_3 {
	meta:
		name = "??$destroy@PAG@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAXPAPAG@Z"
		size = 24
		refs = "000c ??$destroy@PAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAAV?$allocator@G@1@PAPAG@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_131_2 {
	meta:
		name = "??$destroy@PAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAAV?$allocator@G@1@PAPAG@Z"
		size = 24
		refs = "000c ??$destroy@PAG@?$allocator@G@std@@QAAXPAPAG@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_17_13_2 {
	meta:
		name = "??$destroy@PA_W@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAXPAPA_W@Z"
		size = 24
		refs = "000c ??$destroy@PA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAAV?$allocator@_W@1@PAPA_W@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_106_1 {
	meta:
		name = "??$destroy@PA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAAV?$allocator@_W@1@PAPA_W@Z"
		size = 24
		refs = "000c ??$destroy@PA_W@?$allocator@_W@std@@QAAXPAPA_W@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_26_47_3 {
	meta:
		name = "??$destroy@U_Container_proxy@std@@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAAXPAU_Container_proxy@1@@Z"
		size = 24
		refs = "000c ??$destroy@U_Container_proxy@std@@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAAV?$allocator@U_Container_proxy@std@@@1@PAU_Container_proxy@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_29_2 {
	meta:
		name = "??$destroy@U_Container_proxy@std@@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAAV?$allocator@U_Container_proxy@std@@@1@PAU_Container_proxy@1@@Z"
		size = 24
		refs = "000c ??$destroy@U_Container_proxy@std@@@?$allocator@U_Container_proxy@std@@@std@@QAAXPAU_Container_proxy@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_82_21_2 {
	meta:
		name = "??$destroy@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@QAAXPAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@@Z"
		size = 24
		refs = "000c ??$destroy@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@?$allocator_traits@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@SAXAAU?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@PAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_93_39_2 {
	meta:
		name = "??$iter_swap@PADPAD@std@@YAXPAD0@Z"
		size = 24
		refs = "000c ??$swap@DX@std@@YAXAAD0@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_86_133_1 {
	meta:
		name = "?swap@?$shared_ptr@V__ExceptionPtr@@@std@@QAAXAAV12@@Z"
		size = 24
		refs = "000c ?_Swap@?$_Ptr_base@V__ExceptionPtr@@@std@@QAAXAAV12@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_23_1 {
	meta:
		name = "??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$codecvt@DDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_23_1 {
	meta:
		name = "??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$codecvt@GDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_37_2 {
	meta:
		name = "??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_48_1 {
	meta:
		name = "??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$collate@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$collate@D@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$collate@D@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_125_1 {
	meta:
		name = "??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$collate@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$collate@G@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$collate@G@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_127_1 {
	meta:
		name = "??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$collate@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$collate@_W@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$collate@_W@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_46_3 {
	meta:
		name = "??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$ctype@D@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$ctype@D@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_39_2 {
	meta:
		name = "??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$ctype@G@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$ctype@G@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_212_3 {
	meta:
		name = "??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$ctype@_W@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$ctype@_W@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_52_1 {
	meta:
		name = "??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$messages@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$messages@D@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$messages@D@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_133_1 {
	meta:
		name = "??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$messages@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$messages@G@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$messages@G@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_170_2 {
	meta:
		name = "??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$messages@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$messages@_W@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$messages@_W@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_74_2 {
	meta:
		name = "??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_218_3 {
	meta:
		name = "??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_220_3 {
	meta:
		name = "??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_56_1 {
	meta:
		name = "??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_176_2 {
	meta:
		name = "??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_178_2 {
	meta:
		name = "??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_58_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$moneypunct@D$00@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$moneypunct@D$00@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_60_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$moneypunct@D$0A@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$moneypunct@D$0A@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_145_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$moneypunct@G$00@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$moneypunct@G$00@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_147_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$moneypunct@G$0A@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$moneypunct@G$0A@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_184_2 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$moneypunct@_W$00@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$moneypunct@_W$00@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_186_2 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$moneypunct@_W$0A@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_42_2 {
	meta:
		name = "??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_153_1 {
	meta:
		name = "??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_155_1 {
	meta:
		name = "??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_32_1 {
	meta:
		name = "??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_238_3 {
	meta:
		name = "??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_240_3 {
	meta:
		name = "??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_56_3 {
	meta:
		name = "??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$numpunct@D@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$numpunct@D@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_161_1 {
	meta:
		name = "??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$numpunct@G@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$numpunct@G@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_163_1 {
	meta:
		name = "??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$numpunct@_W@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$numpunct@_W@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_62_1 {
	meta:
		name = "??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_165_1 {
	meta:
		name = "??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_248_3 {
	meta:
		name = "??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_84_2 {
	meta:
		name = "??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_204_2 {
	meta:
		name = "??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_252_3 {
	meta:
		name = "??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 208
		refs = "001c ??0_Lockit@std@@QAA@H@Z 002a ??Bid@locale@std@@QAAIXZ 0038 ?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z 005a ?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 006c ??0bad_cast@std@@QAA@XZ 0076 _CxxThrowException 0098 _guard_check_icall 00a4 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 00b0 ??1_Lockit@std@@QAA@XZ 00c4 ?_Psave@?$_Facetptr@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 00c8 _TI2?AVbad_cast@std@@ 00cc ?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 92 B0 6F 46 6F F0 01 03 C7 E9 0C 33 00 21 17 F1 20 00 ?? ?? ?? ?? F8 62 28 4B 1B 68 3B 60 28 48 ?? ?? ?? ?? 38 61 3B 69 7B 61 79 69 B8 6D ?? ?? ?? ?? B8 61 BB 69 7B 60 7B 68 00 2B 00 D0 2E E0 3B 68 00 2B 02 D0 3B 68 7B 60 28 E0 B9 6D 38 46 ?? ?? ?? ?? F8 61 FB 69 B3 F1 FF 3F 09 D1 17 F1 38 00 ?? ?? ?? ?? 15 49 17 F1 38 00 ?? ?? ?? ?? 15 E0 3B 68 7B 60 3A 68 10 4B 1A 60 3B 68 BB 60 BB 68 1B 68 1B 1D BC 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 98 47 B8 68 ?? ?? ?? ?? 7B 68 7B 62 17 F1 20 00 ?? ?? ?? ?? 7B 6A BB 62 B8 6A 12 B0 BD E8 90 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_27_1 {
	meta:
		name = "??0?$_Immortalizer@V_Iostream_error_category@std@@@std@@QAA@XZ"
		size = 64
		refs = "000e ??2@YAPAXIPAX@Z 0020 ??0_Iostream_error_category@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 99 08 20 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 00 2B 06 D0 00 98 ?? ?? ?? ?? 02 90 02 9B 03 93 01 E0 00 23 03 93 08 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_51_35_1 {
	meta:
		name = "??0?$_Immortalizer@V_Generic_error_category@std@@@std@@QAA@XZ"
		size = 64
		refs = "000e ??2@YAPAXIPAX@Z 0020 ??0_Generic_error_category@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 99 08 20 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 00 2B 06 D0 00 98 ?? ?? ?? ?? 02 90 02 9B 03 93 01 E0 00 23 03 93 08 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_51_36_1 {
	meta:
		name = "??0?$_Immortalizer@V_System_error_category@std@@@std@@QAA@XZ"
		size = 64
		refs = "000e ??2@YAPAXIPAX@Z 0020 ??0_System_error_category@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 99 08 20 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 00 2B 06 D0 00 98 ?? ?? ?? ?? 02 90 02 9B 03 93 01 E0 00 23 03 93 08 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_28_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@XZ"
		size = 38
		refs = "0010 ??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QAA@U_Zero_then_variadic_args_t@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 9D F8 00 10 06 98 ?? ?? ?? ?? 02 90 06 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_178_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@XZ"
		size = 38
		refs = "0010 ??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QAA@U_Zero_then_variadic_args_t@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 9D F8 00 10 06 98 ?? ?? ?? ?? 02 90 06 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_11_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@XZ"
		size = 38
		refs = "0010 ??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QAA@U_Zero_then_variadic_args_t@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 9D F8 00 10 06 98 ?? ?? ?? ?? 02 90 06 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_29_1 {
	meta:
		name = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@PBDPBU_Container_base0@1@@Z"
		size = 40
		refs = "0014 ?_Adopt@_Iterator_base0@std@@QAAXPBX@Z"
		altNames = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@PBGPBU_Container_base0@1@@Z ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@PB_WPBU_Container_base0@1@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 04 9A 05 9B 13 60 06 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_30_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@PADPBU_Container_base0@1@@Z"
		size = 36
		refs = "0010 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@PBDPBU_Container_base0@1@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_184_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@PAGPBU_Container_base0@1@@Z"
		size = 36
		refs = "0010 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@PBGPBU_Container_base0@1@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_13_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@PA_WPBU_Container_base0@1@@Z"
		size = 36
		refs = "0010 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@PB_WPBU_Container_base0@1@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_31_1 {
	meta:
		name = "??0?$_String_val@U?$_Simple_types@D@std@@@std@@QAA@XZ"
		size = 54
		refs = "000c ??0_Bxty@?$_String_val@U?$_Simple_types@D@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 01 90 04 9B 03 F1 10 02 00 23 13 60 04 9B 03 F1 14 02 00 23 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_187_1 {
	meta:
		name = "??0?$_String_val@U?$_Simple_types@G@std@@@std@@QAA@XZ"
		size = 54
		refs = "000c ??0_Bxty@?$_String_val@U?$_Simple_types@G@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 01 90 04 9B 03 F1 10 02 00 23 13 60 04 9B 03 F1 14 02 00 23 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_14_1 {
	meta:
		name = "??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QAA@XZ"
		size = 54
		refs = "000c ??0_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 01 90 04 9B 03 F1 10 02 00 23 13 60 04 9B 03 F1 14 02 00 23 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_33_1 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAA@XZ"
		size = 32
		refs = "000c ??0?$allocator@D@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_192_1 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAA@XZ"
		size = 32
		refs = "000c ??0?$allocator@G@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_32_14_1 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAA@XZ"
		size = 32
		refs = "000c ??0?$allocator@_W@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_86_39_1 {
	meta:
		name = "??0?$shared_ptr@V__ExceptionPtr@@@std@@QAA@XZ"
		size = 32
		refs = "000c ??0?$_Ptr_base@V__ExceptionPtr@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_118_115_1 {
	meta:
		name = "??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QAAAAV01@XZ"
		size = 32
		refs = "000c ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_474_2 {
	meta:
		name = "??E?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QAAAAV01@XZ"
		size = 32
		refs = "000c ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_475_2 {
	meta:
		name = "??E?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAAAAV01@XZ"
		size = 32
		refs = "000c ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_29_80_4 {
	meta:
		name = "?getECSUName@UnDecorator@@CA?AVDName@@XZ"
		size = 32
		refs = "000c ?getScopedName@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_29_107_4 {
	meta:
		name = "?getStorageConvention@UnDecorator@@CA?AVDName@@XZ"
		size = 32
		refs = "000c ?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_34_1 {
	meta:
		name = "??0?$_Yarn@D@std@@QAA@XZ"
		size = 40
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 00 23 13 60 04 9B 1A 1D 00 23 13 70 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_35_1 {
	meta:
		name = "??0?$_Yarn@_W@std@@QAA@XZ"
		size = 40
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 00 23 13 60 04 9B 1A 1D 00 23 13 80 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_38_1 {
	meta:
		name = "??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAA@PAU_iobuf@@@Z"
		size = 68
		refs = "0018 ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAA@XZ 002a ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z 0040 ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 78 60 08 4A 3B 6A 1A 60 00 22 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_56_2 {
	meta:
		name = "??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAA@PAU_iobuf@@@Z"
		size = 68
		refs = "0018 ??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAA@XZ 002a ?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z 0040 ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 78 60 08 4A 3B 6A 1A 60 00 22 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_56_2 {
	meta:
		name = "??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAA@PAU_iobuf@@@Z"
		size = 68
		refs = "0018 ??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAA@XZ 002a ?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z 0040 ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 78 60 08 4A 3B 6A 1A 60 00 22 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_40_1 {
	meta:
		name = "??0?$basic_ios@DU?$char_traits@D@std@@@std@@IAA@XZ"
		size = 44
		refs = "000c ??0ios_base@std@@IAA@XZ 0028 ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_58_2 {
	meta:
		name = "??0?$basic_ios@GU?$char_traits@G@std@@@std@@IAA@XZ"
		size = 44
		refs = "000c ??0ios_base@std@@IAA@XZ 0028 ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_58_2 {
	meta:
		name = "??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@IAA@XZ"
		size = 44
		refs = "000c ??0ios_base@std@@IAA@XZ 0028 ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_41_1 {
	meta:
		name = "??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 148
		refs = "002c ??0?$basic_ios@DU?$char_traits@D@std@@@std@@IAA@XZ 0078 ?init@?$basic_ios@DU?$char_traits@D@std@@@std@@IAAXPAV?$basic_streambuf@DU?$char_traits@D@std@@@2@_N@Z 008c ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0090 ??_8?$basic_ostream@DU?$char_traits@D@std@@@std@@7B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 00 23 3B 60 7B 6B 00 2B 0C D0 BA 6A 1B 4B 13 60 BB 6A 03 F1 08 00 ?? ?? ?? ?? B8 60 3B 68 43 F0 01 03 3B 60 BB 6A 1B 68 1B 1D BA 6A 1B 68 1A 44 11 4B 13 60 BB 6A 1B 68 1B 1D 1B 68 A3 F1 08 01 BB 6A 1B 68 1B 1D BA 6A 1B 68 13 44 1B 1F 19 60 97 F8 30 20 F9 6A BB 6A 1B 68 1B 1D B8 6A 1B 68 18 44 ?? ?? ?? ?? BB 6A 7B 60 78 68 07 B0 BD E8 80 08 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_59_2 {
	meta:
		name = "??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 148
		refs = "002c ??0?$basic_ios@GU?$char_traits@G@std@@@std@@IAA@XZ 0078 ?init@?$basic_ios@GU?$char_traits@G@std@@@std@@IAAXPAV?$basic_streambuf@GU?$char_traits@G@std@@@2@_N@Z 008c ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0090 ??_8?$basic_ostream@GU?$char_traits@G@std@@@std@@7B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 00 23 3B 60 7B 6B 00 2B 0C D0 BA 6A 1B 4B 13 60 BB 6A 03 F1 08 00 ?? ?? ?? ?? B8 60 3B 68 43 F0 01 03 3B 60 BB 6A 1B 68 1B 1D BA 6A 1B 68 1A 44 11 4B 13 60 BB 6A 1B 68 1B 1D 1B 68 A3 F1 08 01 BB 6A 1B 68 1B 1D BA 6A 1B 68 13 44 1B 1F 19 60 97 F8 30 20 F9 6A BB 6A 1B 68 1B 1D B8 6A 1B 68 18 44 ?? ?? ?? ?? BB 6A 7B 60 78 68 07 B0 BD E8 80 08 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_41_1 {
	meta:
		name = "??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 148
		refs = "002c ??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@IAA@XZ 0078 ?init@?$basic_ios@_WU?$char_traits@_W@std@@@std@@IAAXPAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_N@Z 008c ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0090 ??_8?$basic_ostream@_WU?$char_traits@_W@std@@@std@@7B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 00 23 3B 60 7B 6B 00 2B 0C D0 BA 6A 1B 4B 13 60 BB 6A 03 F1 08 00 ?? ?? ?? ?? B8 60 3B 68 43 F0 01 03 3B 60 BB 6A 1B 68 1B 1D BA 6A 1B 68 1A 44 11 4B 13 60 BB 6A 1B 68 1B 1D 1B 68 A3 F1 08 01 BB 6A 1B 68 1B 1D BA 6A 1B 68 13 44 1B 1F 19 60 97 F8 30 20 F9 6A BB 6A 1B 68 1B 1D B8 6A 1B 68 18 44 ?? ?? ?? ?? BB 6A 7B 60 78 68 07 B0 BD E8 80 08 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_42_1 {
	meta:
		name = "__unwindfunclet$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z$0"
		size = 34
		refs = "001c ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 09 80 3B 68 23 F0 01 03 3B 60 BB 6A 03 F1 08 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_84_60_2 {
	meta:
		name = "__unwindfunclet$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z$0"
		size = 34
		refs = "001c ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 09 80 3B 68 23 F0 01 03 3B 60 BB 6A 03 F1 08 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_114_42_1 {
	meta:
		name = "__unwindfunclet$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z$0"
		size = 34
		refs = "001c ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 09 80 3B 68 23 F0 01 03 3B 60 BB 6A 03 F1 08 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_10_43_1 {
	meta:
		name = "??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAA@XZ"
		size = 88
		refs = "0012 ??2_Crt_new_delete@std@@SAPAXI@Z 0024 ??0locale@std@@QAA@XZ 0040 ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXXZ 0054 ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 9A 11 4B 13 60 08 20 ?? ?? ?? ?? 02 90 02 9B 00 93 00 9B 00 2B 06 D0 00 98 ?? ?? ?? ?? 03 90 03 9B 01 93 01 E0 00 23 01 93 08 9B 03 F1 34 02 01 9B 13 60 08 98 ?? ?? ?? ?? 08 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_61_2 {
	meta:
		name = "??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAA@XZ"
		size = 88
		refs = "0012 ??2_Crt_new_delete@std@@SAPAXI@Z 0024 ??0locale@std@@QAA@XZ 0040 ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXXZ 0054 ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 9A 11 4B 13 60 08 20 ?? ?? ?? ?? 02 90 02 9B 00 93 00 9B 00 2B 06 D0 00 98 ?? ?? ?? ?? 03 90 03 9B 01 93 01 E0 00 23 01 93 08 9B 03 F1 34 02 01 9B 13 60 08 98 ?? ?? ?? ?? 08 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_61_2 {
	meta:
		name = "??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAA@XZ"
		size = 88
		refs = "0012 ??2_Crt_new_delete@std@@SAPAXI@Z 0024 ??0locale@std@@QAA@XZ 0040 ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXXZ 0054 ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 9A 11 4B 13 60 08 20 ?? ?? ?? ?? 02 90 02 9B 00 93 00 9B 00 2B 06 D0 00 98 ?? ?? ?? ?? 03 90 03 9B 01 93 01 E0 00 23 01 93 08 9B 03 F1 34 02 01 9B 13 60 08 98 ?? ?? ?? ?? 08 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_44_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@$$QAV01@@Z"
		size = 88
		refs = "0018 ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0020 ??$move@AAU?$_Wrap_alloc@V?$allocator@D@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@0@AAU10@@Z 002a ??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z 0034 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z 003a ??$forward@V?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@@std@@YA$$QAV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AAV10@@Z 0044 ?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX$$QAV12@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 F8 6A ?? ?? ?? ?? 38 60 38 68 ?? ?? ?? ?? 78 60 79 68 B8 6A ?? ?? ?? ?? 00 22 00 21 B8 6A ?? ?? ?? ?? F8 6A ?? ?? ?? ?? B8 60 B9 68 B8 6A ?? ?? ?? ?? BB 6A FB 60 F8 68 07 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_55_209_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@$$QAV01@@Z"
		size = 88
		refs = "0018 ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0020 ??$move@AAU?$_Wrap_alloc@V?$allocator@G@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@0@AAU10@@Z 002a ??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z 0034 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z 003a ??$forward@V?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@@std@@YA$$QAV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@0@AAV10@@Z 0044 ?_Assign_rv@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX$$QAV12@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 F8 6A ?? ?? ?? ?? 38 60 38 68 ?? ?? ?? ?? 78 60 79 68 B8 6A ?? ?? ?? ?? 00 22 00 21 B8 6A ?? ?? ?? ?? F8 6A ?? ?? ?? ?? B8 60 B9 68 B8 6A ?? ?? ?? ?? BB 6A FB 60 F8 68 07 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_55_219_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@$$QAV01@@Z"
		size = 88
		refs = "0018 ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0020 ??$move@AAU?$_Wrap_alloc@V?$allocator@_W@std@@@std@@@std@@YA$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@0@AAU10@@Z 002a ??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z 0034 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z 003a ??$forward@V?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@@std@@YA$$QAV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@0@AAV10@@Z 0044 ?_Assign_rv@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX$$QAV12@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 F8 6A ?? ?? ?? ?? 38 60 38 68 ?? ?? ?? ?? 78 60 79 68 B8 6A ?? ?? ?? ?? 00 22 00 21 B8 6A ?? ?? ?? ?? F8 6A ?? ?? ?? ?? B8 60 B9 68 B8 6A ?? ?? ?? ?? BB 6A FB 60 F8 68 07 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_45_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ABV01@@Z"
		size = 96
		refs = "0018 ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0024 ?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QBA?AU12@U_Nil@2@@Z 002e ??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z 003a ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z 0048 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z 005c ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 78 6B ?? ?? ?? ?? 78 60 3A 78 79 1C 78 68 ?? ?? ?? ?? B8 60 B9 68 38 6B ?? ?? ?? ?? 38 61 00 22 00 21 38 6B ?? ?? ?? ?? 07 4B 1B 68 00 22 79 6B 38 6B ?? ?? ?? ?? 3B 6B FB 60 F8 68 09 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_210_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@ABV01@@Z"
		size = 96
		refs = "0018 ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0024 ?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QBA?AU12@U_Nil@2@@Z 002e ??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z 003a ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z 0048 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z 005c ?npos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@2IB"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 78 6B ?? ?? ?? ?? 78 60 3A 78 79 1C 78 68 ?? ?? ?? ?? B8 60 B9 68 38 6B ?? ?? ?? ?? 38 61 00 22 00 21 38 6B ?? ?? ?? ?? 07 4B 1B 68 00 22 79 6B 38 6B ?? ?? ?? ?? 3B 6B FB 60 F8 68 09 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_220_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@ABV01@@Z"
		size = 96
		refs = "0018 ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0024 ?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QBA?AU12@U_Nil@2@@Z 002e ??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z 003a ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z 0048 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z 005c ?npos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@2IB"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 78 6B ?? ?? ?? ?? 78 60 3A 78 79 1C 78 68 ?? ?? ?? ?? B8 60 B9 68 38 6B ?? ?? ?? ?? 38 61 00 22 00 21 38 6B ?? ?? ?? ?? 07 4B 1B 68 00 22 79 6B 38 6B ?? ?? ?? ?? 3B 6B FB 60 F8 68 09 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_47_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z"
		size = 68
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@XZ 0024 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z 0030 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 78 60 00 22 00 21 38 6A ?? ?? ?? ?? 97 F9 28 20 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB }
	condition:
		$1
}

rule file_10_49_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z"
		size = 64
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@XZ 0024 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z 002c ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBD@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 78 60 00 22 00 21 38 6A ?? ?? ?? ?? 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_55_214_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@PBG@Z"
		size = 64
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@XZ 0024 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z 002c ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@PBG@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 78 60 00 22 00 21 38 6A ?? ?? ?? ?? 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_16_17_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@PB_W@Z"
		size = 64
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@XZ 0024 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z 002c ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_W@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 78 60 00 22 00 21 38 6A ?? ?? ?? ?? 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_51_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ"
		size = 54
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@XZ 0022 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 00 22 00 21 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_55_218_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@XZ"
		size = 54
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@XZ 0022 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 00 22 00 21 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_55_228_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ"
		size = 54
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@XZ 0022 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 00 22 00 21 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_52_1 {
	meta:
		name = "??0?$codecvt@DDU_Mbstatet@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0codecvt_base@std@@QAA@I@Z 002a ?_Init@?$codecvt@DDU_Mbstatet@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_52_1 {
	meta:
		name = "??0?$codecvt@GDU_Mbstatet@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0codecvt_base@std@@QAA@I@Z 002a ?_Init@?$codecvt@GDU_Mbstatet@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_70_2 {
	meta:
		name = "??0?$codecvt@_WDU_Mbstatet@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0codecvt_base@std@@QAA@I@Z 002a ?_Init@?$codecvt@_WDU_Mbstatet@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_132_3 {
	meta:
		name = "??0?$collate@D@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$collate@D@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$collate@D@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_334_3 {
	meta:
		name = "??0?$collate@G@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$collate@G@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$collate@G@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_235_1 {
	meta:
		name = "??0?$collate@_W@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$collate@_W@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$collate@_W@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_120_2 {
	meta:
		name = "??0?$ctype@D@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0ctype_base@std@@QAA@I@Z 002a ?_Init@?$ctype@D@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$ctype@D@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_92_3 {
	meta:
		name = "??0?$ctype@G@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0ctype_base@std@@QAA@I@Z 002a ?_Init@?$ctype@G@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$ctype@G@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_72_2 {
	meta:
		name = "??0?$ctype@_W@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0ctype_base@std@@QAA@I@Z 002a ?_Init@?$ctype@_W@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$ctype@_W@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_93_1 {
	meta:
		name = "??0?$messages@D@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0messages_base@std@@QAA@I@Z 002a ?_Init@?$messages@D@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$messages@D@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_241_1 {
	meta:
		name = "??0?$messages@G@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0messages_base@std@@QAA@I@Z 002a ?_Init@?$messages@G@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$messages@G@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_243_1 {
	meta:
		name = "??0?$messages@_W@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0messages_base@std@@QAA@I@Z 002a ?_Init@?$messages@_W@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$messages@_W@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_138_3 {
	meta:
		name = "??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_245_1 {
	meta:
		name = "??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_247_1 {
	meta:
		name = "??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_140_3 {
	meta:
		name = "??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_249_1 {
	meta:
		name = "??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_352_3 {
	meta:
		name = "??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_76_3 {
	meta:
		name = "??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_257_1 {
	meta:
		name = "??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_259_1 {
	meta:
		name = "??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_54_1 {
	meta:
		name = "??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_362_3 {
	meta:
		name = "??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_364_3 {
	meta:
		name = "??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0facet@locale@std@@IAA@I@Z 002a ?_Init@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_130_2 {
	meta:
		name = "??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0time_base@std@@QAA@I@Z 002a ?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_269_1 {
	meta:
		name = "??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0time_base@std@@QAA@I@Z 002a ?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_326_2 {
	meta:
		name = "??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAA@ABV_Locinfo@1@I@Z"
		size = 68
		refs = "001a ??0time_base@std@@QAA@I@Z 002a ?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAAXABV_Locinfo@2@@Z 0040 ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 B9 6A 38 6A ?? ?? ?? ?? 78 60 07 4A 3B 6A 1A 60 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_56_1 {
	meta:
		name = "??0?$fpos@U_Mbstatet@@@std@@QAA@U_Mbstatet@@_J@Z"
		size = 74
		refs = "0036 memcpy"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 9B 00 93 00 9A 00 23 13 60 00 9A 00 23 53 60 06 9B 08 33 01 93 0A 9A 01 9B 1A 60 0B 9A 01 9B 5A 60 06 9B 03 F1 10 00 07 A9 08 22 ?? ?? ?? ?? 06 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_57_1 {
	meta:
		name = "??0?$fpos@U_Mbstatet@@@std@@QAA@_J@Z"
		size = 74
		refs = "0036 memset"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 9B 00 93 08 9A 00 9B 1A 60 09 9A 00 9B 5A 60 06 9B 08 33 01 93 01 9A 00 23 13 60 01 9A 00 23 53 60 08 22 00 21 06 9B 03 F1 10 00 ?? ?? ?? ?? 06 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_59_1 {
	meta:
		name = "??0_Facet_base@std@@QAA@XZ"
		size = 36
		refs = "0020 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 04 4B 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_11_4 {
	meta:
		name = "??0DNameNode@@IAA@XZ"
		size = 36
		refs = "0020 ??_7DNameNode@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 04 4B 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_110_2 {
	meta:
		name = "??0ios_base@std@@IAA@XZ"
		size = 36
		refs = "0020 ??_7ios_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 04 4B 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_60_1 {
	meta:
		name = "??0_Generic_error_category@std@@QAA@XZ"
		size = 52
		refs = "000c ??0error_category@std@@QAA@XZ 0030 ??_7_Generic_error_category@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 07 4A 04 9B 1A 60 04 9B 1A 1D 03 23 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_61_1 {
	meta:
		name = "??0_Init_cerr@std@@QAA@XZ"
		size = 84
		refs = "0020 ?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QAAPAV?$basic_ostream@DU?$char_traits@D@std@@@2@PAV32@@Z 0032 ?setf@ios_base@std@@QAAHH@Z 0048 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 004c ?_Ptr_cout@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 0050 ?_Ptr_cerr@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0F 4A 10 4B 1A 60 0E 4B 19 68 0C 4B 1B 68 1B 1D 0B 4A 1B 68 D0 18 ?? ?? ?? ?? 02 21 08 4B 1B 68 1B 1D 06 4A 1B 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_61_1 {
	meta:
		name = "??0_Init_ushcerr@std@@QAA@XZ"
		size = 84
		refs = "0020 ?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QAAPAV?$basic_ostream@GU?$char_traits@G@std@@@2@PAV32@@Z 0032 ?setf@ios_base@std@@QAAHH@Z 0048 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 004c ?_Ptr_wcout@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 0050 ?_Ptr_wcerr@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0F 4A 10 4B 1A 60 0E 4B 19 68 0C 4B 1B 68 1B 1D 0B 4A 1B 68 D0 18 ?? ?? ?? ?? 02 21 08 4B 1B 68 1B 1D 06 4A 1B 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_61_1 {
	meta:
		name = "??0_Init_wcerr@std@@QAA@XZ"
		size = 84
		refs = "0020 ?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAAPAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@PAV32@@Z 0032 ?setf@ios_base@std@@QAAHH@Z 0048 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 004c ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0050 ?_Ptr_wcerr@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0F 4A 10 4B 1A 60 0E 4B 19 68 0C 4B 1B 68 1B 1D 0B 4A 1B 68 D0 18 ?? ?? ?? ?? 02 21 08 4B 1B 68 1B 1D 06 4A 1B 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_62_1 {
	meta:
		name = "??0_Iostream_error_category@std@@QAA@XZ"
		size = 52
		refs = "000c ??0_Generic_error_category@std@@QAA@XZ 0030 ??_7_Iostream_error_category@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 07 4A 04 9B 1A 60 04 9B 1A 1D 05 23 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_63_1 {
	meta:
		name = "??0_Locinfo@std@@QAA@PBD@Z"
		size = 160
		refs = "001a ??0_Lockit@std@@QAA@H@Z 0024 ??0?$_Yarn@D@std@@QAA@XZ 003c ??0?$_Yarn@_W@std@@QAA@XZ 0072 ??0runtime_error@std@@QAA@PBD@Z 007c _CxxThrowException 0084 ?_Locinfo_ctor@_Locinfo@std@@SAXPAV12@PBD@Z 0098 _TI2?AVruntime_error@std@@ 009c ??_C@_0BA@ELKIONDK@bad?5locale?5name?$AA@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 8D B0 6F 46 6F F0 01 03 C7 E9 08 33 00 21 38 6C ?? ?? ?? ?? 78 60 3B 6C 18 1D ?? ?? ?? ?? B8 60 3B 6C 03 F1 0C 00 ?? ?? ?? ?? F8 60 3B 6C 03 F1 14 00 ?? ?? ?? ?? 38 61 3B 6C 03 F1 1C 00 ?? ?? ?? ?? 78 61 3B 6C 03 F1 24 00 ?? ?? ?? ?? B8 61 3B 6C 03 F1 2C 00 ?? ?? ?? ?? F8 61 7B 6C 00 2B 09 D1 0B 49 17 F1 28 00 ?? ?? ?? ?? 08 49 17 F1 28 00 ?? ?? ?? ?? 79 6C 38 6C ?? ?? ?? ?? 3B 6C 3B 60 38 68 0D B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_71_1 {
	meta:
		name = "??0_System_error@std@@IAA@Verror_code@1@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 132
		refs = "000a __security_push_cookie 0024 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ABV01@@Z 0038 ?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z 0046 ??0runtime_error@std@@QAA@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0050 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 0066 memcpy 0072 __security_pop_cookie 0080 ??_7_System_error@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B ?? ?? ?? ?? 96 B0 6F 46 6F F0 01 03 C7 E9 08 33 17 F1 28 03 3B 60 79 6F 38 68 ?? ?? ?? ?? 78 60 7B 68 BB 60 BB 68 F9 6E 3A 6F 17 F1 40 00 ?? ?? ?? ?? F8 60 FB 68 3B 61 39 69 B8 6E ?? ?? ?? ?? B8 61 17 F1 40 00 ?? ?? ?? ?? 0A 4A BB 6E 1A 60 BB 6E 03 F1 0C 00 17 F1 6C 01 08 22 ?? ?? ?? ?? BB 6E 7B 61 78 69 16 B0 ?? ?? ?? ?? BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_73_1 {
	meta:
		name = "??0_System_error@std@@QAA@ABV01@@Z"
		size = 64
		refs = "000e ??0runtime_error@std@@QAA@ABV01@@Z 0026 memcpy 003c ??_7_System_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 0A 4A 04 9B 1A 60 05 9B 03 F1 0C 01 04 9B 03 F1 0C 00 08 22 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_3_1 {
	meta:
		name = "??0future_error@std@@QAA@ABV01@@Z"
		size = 64
		refs = "000e ??0logic_error@std@@QAA@ABV01@@Z 0026 memcpy 003c ??_7future_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 0A 4A 04 9B 1A 60 05 9B 03 F1 0C 01 04 9B 03 F1 0C 00 08 22 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_76_1 {
	meta:
		name = "??0codecvt_base@std@@QAA@I@Z"
		size = 48
		refs = "000e ??0facet@locale@std@@IAA@I@Z 002c ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_105_3 {
	meta:
		name = "??0ctype_base@std@@QAA@I@Z"
		size = 48
		refs = "000e ??0facet@locale@std@@IAA@I@Z 002c ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_9_3 {
	meta:
		name = "??0invalid_argument@std@@QAA@PBD@Z"
		size = 48
		refs = "000e ??0logic_error@std@@QAA@PBD@Z 002c ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_11_2 {
	meta:
		name = "??0length_error@std@@QAA@PBD@Z"
		size = 48
		refs = "000e ??0logic_error@std@@QAA@PBD@Z 002c ??_7length_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_13_3 {
	meta:
		name = "??0logic_error@std@@QAA@PBD@Z"
		size = 48
		refs = "000e ??0exception@std@@QAA@QBD@Z 002c ??_7logic_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_408_3 {
	meta:
		name = "??0messages_base@std@@QAA@I@Z"
		size = 48
		refs = "000e ??0facet@locale@std@@IAA@I@Z 002c ??_7messages_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_161_2 {
	meta:
		name = "??0money_base@std@@QAA@I@Z"
		size = 48
		refs = "000e ??0facet@locale@std@@IAA@I@Z 002c ??_7money_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_15_2 {
	meta:
		name = "??0out_of_range@std@@QAA@PBD@Z"
		size = 48
		refs = "000e ??0logic_error@std@@QAA@PBD@Z 002c ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_17_1 {
	meta:
		name = "??0overflow_error@std@@QAA@PBD@Z"
		size = 48
		refs = "000e ??0runtime_error@std@@QAA@PBD@Z 002c ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_21_3 {
	meta:
		name = "??0runtime_error@std@@QAA@PBD@Z"
		size = 48
		refs = "000e ??0exception@std@@QAA@QBD@Z 002c ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_307_1 {
	meta:
		name = "??0time_base@std@@QAA@I@Z"
		size = 48
		refs = "000e ??0facet@locale@std@@IAA@I@Z 002c ??_7time_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 01 90 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_78_1 {
	meta:
		name = "??0error_category@std@@QAA@XZ"
		size = 44
		refs = "0028 ??_7error_category@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 06 4B 13 60 04 9B 1A 1D 04 9B 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_79_1 {
	meta:
		name = "??0error_code@std@@QAA@HABVerror_category@1@@Z"
		size = 40
		altNames = "??0?$_Smanip@H@std@@QAA@P6AXAAVios_base@1@H@ZH@Z ??0_Fac_node@std@@QAA@PAU01@PAV_Facet_base@1@@Z ??0error_condition@std@@QAA@HABVerror_category@1@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 04 9A 05 9B 13 60 04 9B 1A 1D 06 9B 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_82_1 {
	meta:
		name = "??0exception@std@@QAA@QBD@Z"
		size = 68
		refs = "0018 memset 002c __std_exception_copy 0040 ??_7exception@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9A 0C 4B 13 60 08 22 00 21 06 9B 18 1D ?? ?? ?? ?? 07 9B 02 93 01 23 8D F8 0C 30 06 9B 19 1D 02 A8 ?? ?? ?? ?? 06 9B 00 93 00 98 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_84_1 {
	meta:
		name = "??0facet@locale@std@@IAA@I@Z"
		size = 68
		refs = "0018 ??0_Facet_base@std@@QAA@XZ 002a ?_Init_atomic_counter@std@@YAXAAKK@Z 0040 ??_7facet@locale@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 78 60 08 4A 3B 6A 1A 60 79 6A 3B 6A 18 1D ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_87_1 {
	meta:
		name = "??0failure@ios_base@std@@QAA@PBDABVerror_code@2@@Z"
		size = 56
		refs = "0018 ??0system_error@std@@QAA@Verror_code@1@PBD@Z 0034 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 07 9B 08 9A 00 92 00 9A 11 68 52 68 06 98 ?? ?? ?? ?? 02 90 05 4A 06 9B 1A 60 06 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_90_1 {
	meta:
		name = "??0locale@std@@QAA@ABV01@@Z"
		size = 82
		refs = "0038 _guard_check_icall"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 84 B0 6F 46 6F F0 01 03 C7 E9 02 33 7B 6A 19 1D 3B 6A 1A 1D 0B 68 13 60 3B 6A 1B 1D 1A 68 3B 6A 1B 1D 1C 68 13 68 1B 1D 1B 68 3B 60 38 68 ?? ?? ?? ?? 3B 68 20 46 98 47 3B 6A 7B 60 78 68 04 B0 BD E8 90 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_91_1 {
	meta:
		name = "??0locale@std@@QAA@XZ"
		size = 54
		refs = "0018 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 01 20 ?? ?? ?? ?? 38 60 3B 6A 1A 1D 3B 68 13 60 3B 6A 7B 60 78 68 05 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_93_1 {
	meta:
		name = "??0runtime_error@std@@QAA@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 56
		refs = "000c ?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAPBDXZ 0016 ??0exception@std@@QAA@QBD@Z 0034 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 98 ?? ?? ?? ?? 00 90 00 99 06 98 ?? ?? ?? ?? 02 90 05 4A 06 9B 1A 60 06 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_96_1 {
	meta:
		name = "??0system_error@std@@QAA@Verror_code@1@PBD@Z"
		size = 92
		refs = "000a __security_push_cookie 0020 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z 0030 ??0_System_error@std@@IAA@Verror_code@1@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 003a ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 004c __security_pop_cookie 0058 ??_7system_error@std@@6B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B ?? ?? ?? ?? 8C B0 6F 46 6F F0 01 03 C7 E9 04 33 F9 6C 17 F1 18 00 ?? ?? ?? ?? 78 60 17 F1 18 03 79 6C BA 6C 38 6C ?? ?? ?? ?? B8 60 17 F1 18 00 ?? ?? ?? ?? 06 4A 3B 6C 1A 60 3B 6C 3B 60 38 68 0C B0 ?? ?? ?? ?? BD E8 80 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_102_1 {
	meta:
		name = "??1?$_Yarn@D@std@@QAA@XZ"
		size = 38
		refs = "0018 ?_Tidy@?$_Yarn@D@std@@AAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_36_431_3 {
	meta:
		name = "??1?$_Yarn@_W@std@@QAA@XZ"
		size = 38
		refs = "0018 ?_Tidy@?$_Yarn@_W@std@@AAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_114_50_3 {
	meta:
		name = "??1?$shared_ptr@V__ExceptionPtr@@@std@@QAA@XZ"
		size = 38
		refs = "0018 ?_Decref@?$_Ptr_base@V__ExceptionPtr@@@std@@QAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_46_155_3 {
	meta:
		name = "??1_Container_base12@std@@QAA@XZ"
		size = 38
		refs = "0018 ?_Orphan_all@_Container_base12@std@@QAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_104_1 {
	meta:
		name = "??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAA@XZ"
		size = 80
		refs = "0028 ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AAAXXZ 0038 ?close@?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAAPAV12@XZ 003e ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAA@XZ 004c ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 0D 4A BB 69 1A 60 BB 69 4C 33 1B 68 00 2B 02 D0 B8 69 ?? ?? ?? ?? BB 69 48 33 1B 78 00 2B 02 D0 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_127_2 {
	meta:
		name = "??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ"
		size = 80
		refs = "0028 ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAAXXZ 0038 ?close@?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAAPAV12@XZ 003e ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAA@XZ 004c ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 0D 4A BB 69 1A 60 BB 69 4C 33 1B 68 00 2B 02 D0 B8 69 ?? ?? ?? ?? BB 69 48 33 1B 78 00 2B 02 D0 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_127_2 {
	meta:
		name = "??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
		size = 80
		refs = "0028 ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAAXXZ 0038 ?close@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAAPAV12@XZ 003e ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 004c ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 0D 4A BB 69 1A 60 BB 69 4C 33 1B 68 00 2B 02 D0 B8 69 ?? ?? ?? ?? BB 69 48 33 1B 78 00 2B 02 D0 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_105_1 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAA@XZ"
		size = 32
		refs = "0010 ??1ios_base@std@@UAA@XZ 001c ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_128_2 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAA@XZ"
		size = 32
		refs = "0010 ??1ios_base@std@@UAA@XZ 001c ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_128_2 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
		size = 32
		refs = "0010 ??1ios_base@std@@UAA@XZ 001c ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_109_1 {
	meta:
		name = "??1?$codecvt@DDU_Mbstatet@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1codecvt_base@std@@UAA@XZ 001c ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_132_2 {
	meta:
		name = "??1?$codecvt@GDU_Mbstatet@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1codecvt_base@std@@UAA@XZ 001c ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_152_3 {
	meta:
		name = "??1?$codecvt@_WDU_Mbstatet@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1codecvt_base@std@@UAA@XZ 001c ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_141_1 {
	meta:
		name = "??1?$messages@D@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1messages_base@std@@UAA@XZ 001c ??_7?$messages@D@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_395_2 {
	meta:
		name = "??1?$messages@G@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1messages_base@std@@UAA@XZ 001c ??_7?$messages@G@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_396_2 {
	meta:
		name = "??1?$messages@_W@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1messages_base@std@@UAA@XZ 001c ??_7?$messages@_W@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_192_3 {
	meta:
		name = "??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_332_1 {
	meta:
		name = "??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_398_2 {
	meta:
		name = "??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_179_2 {
	meta:
		name = "??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_445_3 {
	meta:
		name = "??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_446_3 {
	meta:
		name = "??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_144_1 {
	meta:
		name = "??1?$moneypunct@D$00@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1?$_Mpunct@D@std@@MAA@XZ 001c ??_7?$moneypunct@D$00@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_145_1 {
	meta:
		name = "??1?$moneypunct@D$0A@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1?$_Mpunct@D@std@@MAA@XZ 001c ??_7?$moneypunct@D$0A@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_336_1 {
	meta:
		name = "??1?$moneypunct@G$00@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1?$_Mpunct@G@std@@MAA@XZ 001c ??_7?$moneypunct@G$00@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_337_1 {
	meta:
		name = "??1?$moneypunct@G$0A@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1?$_Mpunct@G@std@@MAA@XZ 001c ??_7?$moneypunct@G$0A@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_403_2 {
	meta:
		name = "??1?$moneypunct@_W$00@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1?$_Mpunct@_W@std@@MAA@XZ 001c ??_7?$moneypunct@_W$00@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_339_1 {
	meta:
		name = "??1?$moneypunct@_W$0A@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1?$_Mpunct@_W@std@@MAA@XZ 001c ??_7?$moneypunct@_W$0A@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_116_3 {
	meta:
		name = "??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_340_1 {
	meta:
		name = "??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_406_2 {
	meta:
		name = "??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_117_3 {
	meta:
		name = "??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_342_1 {
	meta:
		name = "??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_343_1 {
	meta:
		name = "??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_143_2 {
	meta:
		name = "??1codecvt_base@std@@UAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_153_1 {
	meta:
		name = "??1ctype_base@std@@UAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_121_1 {
	meta:
		name = "??1facet@locale@std@@MAA@XZ"
		size = 32
		refs = "0010 ??1_Facet_base@std@@UAA@XZ 001c ??_7facet@locale@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_365_1 {
	meta:
		name = "??1time_base@std@@UAA@XZ"
		size = 32
		refs = "0010 ??1facet@locale@std@@MAA@XZ 001c ??_7time_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 04 4A 02 9B 1A 60 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_106_1 {
	meta:
		name = "??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UAA@XZ"
		size = 84
		refs = "0050 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B A3 F1 08 01 02 9B A3 F1 08 02 0B 68 1B 1D 1B 68 1A 44 0C 4B 13 60 02 9B 08 3B 1B 68 1B 1D 1B 68 A3 F1 08 00 02 9B A3 F1 08 01 02 9B A3 F1 08 02 0B 68 1B 1D 1B 68 13 44 1B 1F 18 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_129_2 {
	meta:
		name = "??1?$basic_ostream@GU?$char_traits@G@std@@@std@@UAA@XZ"
		size = 84
		refs = "0050 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B A3 F1 08 01 02 9B A3 F1 08 02 0B 68 1B 1D 1B 68 1A 44 0C 4B 13 60 02 9B 08 3B 1B 68 1B 1D 1B 68 A3 F1 08 00 02 9B A3 F1 08 01 02 9B A3 F1 08 02 0B 68 1B 1D 1B 68 13 44 1B 1F 18 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_105_1 {
	meta:
		name = "??1?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
		size = 84
		refs = "0050 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B A3 F1 08 01 02 9B A3 F1 08 02 0B 68 1B 1D 1B 68 1A 44 0C 4B 13 60 02 9B 08 3B 1B 68 1B 1D 1B 68 A3 F1 08 00 02 9B A3 F1 08 01 02 9B A3 F1 08 02 0B 68 1B 1D 1B 68 13 44 1B 1F 18 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_107_1 {
	meta:
		name = "??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAA@XZ"
		size = 68
		refs = "0026 ??_Glocale@std@@QAAPAXI@Z 0040 ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9A 0C 4B 13 60 06 9B 34 33 1B 68 01 93 01 9B 00 93 00 9B 00 2B 07 D0 01 21 00 98 ?? ?? ?? ?? 02 90 02 9B 03 93 01 E0 00 23 03 93 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_130_2 {
	meta:
		name = "??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAA@XZ"
		size = 68
		refs = "0026 ??_Glocale@std@@QAAPAXI@Z 0040 ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9A 0C 4B 13 60 06 9B 34 33 1B 68 01 93 01 9B 00 93 00 9B 00 2B 07 D0 01 21 00 98 ?? ?? ?? ?? 02 90 02 9B 03 93 01 E0 00 23 03 93 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_130_2 {
	meta:
		name = "??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
		size = 68
		refs = "0026 ??_Glocale@std@@QAAPAXI@Z 0040 ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9A 0C 4B 13 60 06 9B 34 33 1B 68 01 93 01 9B 00 93 00 9B 00 2B 07 D0 01 21 00 98 ?? ?? ?? ?? 02 90 02 9B 03 93 01 E0 00 23 03 93 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_108_1 {
	meta:
		name = "??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ"
		size = 48
		refs = "001c ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z 0022 ??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 00 22 01 21 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_55_322_1 {
	meta:
		name = "??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@XZ"
		size = 48
		refs = "001c ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z 0022 ??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 00 22 01 21 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_16_23_1 {
	meta:
		name = "??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ"
		size = 48
		refs = "001c ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z 0022 ??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 00 22 01 21 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_110_1 {
	meta:
		name = "??1?$ctype@D@std@@MAA@XZ"
		size = 56
		refs = "001e ?_Tidy@?$ctype@D@std@@IAAXXZ 0024 ??1ctype_base@std@@UAA@XZ 0034 ??_7?$ctype@D@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 07 4A BB 69 1A 60 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_167_2 {
	meta:
		name = "??1?$_Mpunct@D@std@@MAA@XZ"
		size = 56
		refs = "001e ?_Tidy@?$_Mpunct@D@std@@AAAXXZ 0024 ??1money_base@std@@UAA@XZ 0034 ??_7?$_Mpunct@D@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 07 4A BB 69 1A 60 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_372_2 {
	meta:
		name = "??1?$_Mpunct@G@std@@MAA@XZ"
		size = 56
		refs = "001e ?_Tidy@?$_Mpunct@G@std@@AAAXXZ 0024 ??1money_base@std@@UAA@XZ 0034 ??_7?$_Mpunct@G@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 07 4A BB 69 1A 60 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_373_2 {
	meta:
		name = "??1?$_Mpunct@_W@std@@MAA@XZ"
		size = 56
		refs = "001e ?_Tidy@?$_Mpunct@_W@std@@AAAXXZ 0024 ??1money_base@std@@UAA@XZ 0034 ??_7?$_Mpunct@_W@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 07 4A BB 69 1A 60 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_118_3 {
	meta:
		name = "??1?$numpunct@D@std@@MAA@XZ"
		size = 56
		refs = "001e ?_Tidy@?$numpunct@D@std@@AAAXXZ 0024 ??1facet@locale@std@@MAA@XZ 0034 ??_7?$numpunct@D@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 07 4A BB 69 1A 60 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_409_2 {
	meta:
		name = "??1?$numpunct@G@std@@MAA@XZ"
		size = 56
		refs = "001e ?_Tidy@?$numpunct@G@std@@AAAXXZ 0024 ??1facet@locale@std@@MAA@XZ 0034 ??_7?$numpunct@G@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 07 4A BB 69 1A 60 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_345_1 {
	meta:
		name = "??1?$numpunct@_W@std@@MAA@XZ"
		size = 56
		refs = "001e ?_Tidy@?$numpunct@_W@std@@AAAXXZ 0024 ??1facet@locale@std@@MAA@XZ 0034 ??_7?$numpunct@_W@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 07 4A BB 69 1A 60 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_196_3 {
	meta:
		name = "??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ"
		size = 56
		refs = "001e ?_Tidy@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AAAXXZ 0024 ??1time_base@std@@UAA@XZ 0034 ??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 07 4A BB 69 1A 60 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_411_2 {
	meta:
		name = "??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ"
		size = 56
		refs = "001e ?_Tidy@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AAAXXZ 0024 ??1time_base@std@@UAA@XZ 0034 ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 07 4A BB 69 1A 60 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_412_2 {
	meta:
		name = "??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ"
		size = 56
		refs = "001e ?_Tidy@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AAAXXZ 0024 ??1time_base@std@@UAA@XZ 0034 ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 07 4A BB 69 1A 60 B8 69 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_115_1 {
	meta:
		name = "??1_Locinfo@std@@QAA@XZ"
		size = 102
		refs = "0018 ?_Locinfo_dtor@_Locinfo@std@@SAXPAV12@@Z 0022 ??1?$_Yarn@D@std@@QAA@XZ 0036 ??1?$_Yarn@_W@std@@QAA@XZ 0058 ??1_Lockit@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 B8 69 ?? ?? ?? ?? BB 69 03 F1 2C 00 ?? ?? ?? ?? BB 69 03 F1 24 00 ?? ?? ?? ?? BB 69 03 F1 1C 00 ?? ?? ?? ?? BB 69 03 F1 14 00 ?? ?? ?? ?? BB 69 03 F1 0C 00 ?? ?? ?? ?? BB 69 18 1D ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_124_1 {
	meta:
		name = "??1ios_base@std@@UAA@XZ"
		size = 48
		refs = "001e ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 002c ??_7ios_base@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 BA 69 04 4B 13 60 B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_125_1 {
	meta:
		name = "??1locale@std@@QAA@XZ"
		size = 128
		refs = "0036 _guard_check_icall"
	strings:
		$1 = { 03 B4 2D E9 B0 48 0D F1 0C 0B 8B B0 6F 46 6F F0 01 03 C7 E9 08 33 3B 6C 1B 1D 1B 68 00 2B 2A D0 3B 6C 1B 1D 1A 68 3B 6C 1B 1D 1C 68 13 68 08 33 1B 68 7B 60 78 68 ?? ?? ?? ?? 7B 68 20 46 98 47 F8 60 FB 68 3B 61 3B 69 3B 60 3B 68 00 2B 10 D0 01 25 3B 68 1B 68 3C 68 1B 68 BB 60 B8 68 ?? ?? ?? ?? BB 68 20 46 29 46 98 47 78 61 7B 69 BB 61 01 E0 00 23 BB 61 0B B0 BD E8 B0 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_129_1 {
	meta:
		name = "??2_Crt_new_delete@std@@SAPAXI@Z"
		size = 56
		refs = "000e ??2_Crt_new_delete@std@@SAPAXIABUnothrow_t@1@@Z 001e ?_Xbad_alloc@std@@YAXXZ 0034 ?nothrow@std@@3Unothrow_t@1@B"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 0A 49 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 00 2B 01 D1 ?? ?? ?? ?? 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_130_1 {
	meta:
		name = "??2_Crt_new_delete@std@@SAPAXIABUnothrow_t@1@@Z"
		size = 60
		refs = "0022 _malloc_dbg 0038 ??_C@_0CI@FIAODHFJ@f?3?2dd?2vctools?2crt?2crtw32?2stdhpp?2@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 00 2B 02 D9 06 9B 00 93 01 E0 01 23 00 93 4A 23 06 4A 02 21 00 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_132_1 {
	meta:
		name = "??8error_category@std@@QBA_NABV01@@Z"
		size = 58
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1A 1D 05 9B 1B 1D 12 68 1B 68 9A 42 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_133_1 {
	meta:
		name = "??8std@@YA_NABVerror_condition@0@0@Z"
		size = 102
		refs = "000c ?category@error_condition@std@@QBAABVerror_category@2@XZ 001e ??8error_category@std@@QBA_NABV01@@Z 0030 ?value@error_condition@std@@QBAHXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 88 B0 0B 98 ?? ?? ?? ?? 02 90 0A 98 ?? ?? ?? ?? 03 90 02 99 03 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0E D0 0A 98 ?? ?? ?? ?? 04 90 0B 98 ?? ?? ?? ?? 05 90 04 9A 05 9B 9A 42 02 D1 01 23 01 93 01 E0 00 23 01 93 01 9B DB B2 8D F8 18 30 9D F8 18 00 08 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_134_1 {
	meta:
		name = "??B?$fpos@U_Mbstatet@@@std@@QBA_JXZ"
		size = 60
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 99 06 9B 03 F1 08 02 00 91 00 9B 18 68 00 9B 59 68 01 92 01 9B 1A 68 01 9B 5B 68 12 18 4B 41 02 92 03 93 02 98 03 99 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_135_1 {
	meta:
		name = "??Bid@locale@std@@QAAIXZ"
		size = 84
		refs = "0016 ??0_Lockit@std@@QAA@H@Z 0038 ??1_Lockit@std@@QAA@XZ 0050 ?_Id_cnt@id@locale@std@@0HA"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 1B 68 00 2B 14 D1 00 21 68 46 ?? ?? ?? ?? 02 90 06 9B 1B 68 00 2B 08 D1 0A 4B 1B 68 5A 1C 09 4B 1A 60 06 9A 07 4B 1B 68 13 60 68 46 ?? ?? ?? ?? 06 9B 1B 68 01 93 01 98 04 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_136_1 {
	meta:
		name = "??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAABDXZ"
		size = 28
		altNames = "??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBAABGXZ ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAAB_WXZ ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QBAPAV__ExceptionPtr@@XZ ?_Getptr@_Timevec@std@@QBAPAXXZ ?get@?$__crt_scoped_stack_ptr@_W@@QBAPA_WXZ ?get@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBAPADXZ ?get@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QBAPADXZ ?get@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QBAPAU__vcrt_ptd@@XZ ?get@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QBAPAXXZ ?value@error_code@std@@QBAHXZ ?value@error_condition@std@@QBAHXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 68 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_138_1 {
	meta:
		name = "??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAAXXZ"
		size = 36
		refs = "000e ??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UAA@XZ 0018 ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 03 F1 08 00 ?? ?? ?? ?? 02 9B 03 F1 08 00 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_84_163_2 {
	meta:
		name = "??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAXXZ"
		size = 36
		refs = "000e ??1?$basic_ostream@GU?$char_traits@G@std@@@std@@UAA@XZ 0018 ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 03 F1 08 00 ?? ?? ?? ?? 02 9B 03 F1 08 00 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_114_137_1 {
	meta:
		name = "??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAXXZ"
		size = 36
		refs = "000e ??1?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0018 ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 03 F1 08 00 ?? ?? ?? ?? 02 9B 03 F1 08 00 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_139_1 {
	meta:
		name = "??_E?$basic_ostream@DU?$char_traits@D@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_ostream@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_139_1 {
	meta:
		name = "??_E?$basic_istream@DU?$char_traits@D@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_istream@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_184_3 {
	meta:
		name = "??_E?$basic_istream@GU?$char_traits@G@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_istream@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_184_3 {
	meta:
		name = "??_E?$basic_istream@_WU?$char_traits@_W@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_istream@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_164_2 {
	meta:
		name = "??_E?$basic_ostream@GU?$char_traits@G@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_ostream@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_164_2 {
	meta:
		name = "??_E?$basic_ostream@_WU?$char_traits@_W@std@@@std@@$4PPPPPPPM@A@AAPAXI@Z"
		size = 20
		refs = "0010 ??_E?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
	strings:
		$1 = { 50 F8 04 CC A0 EB 0C 00 DF F8 04 C0 60 47 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_140_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 58 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_84_165_2 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 58 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_30_165_2 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 58 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_141_1 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 48 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_84_166_2 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 48 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_30_166_2 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 48 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_142_1 {
	meta:
		name = "??_G?$basic_ostream@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
		size = 58
		refs = "0010 ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAAXXZ 0024 ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B A3 F1 08 00 ?? ?? ?? ?? 05 9B 13 F0 01 0F 05 D0 50 21 04 9B A3 F1 08 00 ?? ?? ?? ?? 04 9B 08 3B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_84_167_2 {
	meta:
		name = "??_G?$basic_ostream@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
		size = 58
		refs = "0010 ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAAXXZ 0024 ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B A3 F1 08 00 ?? ?? ?? ?? 05 9B 13 F0 01 0F 05 D0 50 21 04 9B A3 F1 08 00 ?? ?? ?? ?? 04 9B 08 3B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_114_141_1 {
	meta:
		name = "??_G?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
		size = 58
		refs = "0010 ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAAXXZ 0024 ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B A3 F1 08 00 ?? ?? ?? ?? 05 9B 13 F0 01 0F 05 D0 50 21 04 9B A3 F1 08 00 ?? ?? ?? ?? 04 9B 08 3B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_143_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 38 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_76_188_3 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 38 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_118_168_2 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 38 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_63_202_3 {
	meta:
		name = "??_Gios_base@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1ios_base@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 38 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_144_1 {
	meta:
		name = "??_G?$codecvt@DDU_Mbstatet@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$codecvt@DDU_Mbstatet@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_87_237_2 {
	meta:
		name = "??_G?$messages@D@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$messages@D@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_435_1 {
	meta:
		name = "??_G?$messages@G@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$messages@G@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_436_1 {
	meta:
		name = "??_G?$messages@_W@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$messages@_W@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_95_253_3 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_437_1 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_561_3 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_87_239_2 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_562_3 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_563_3 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_47_148_3 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_521_2 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_522_2 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_47_149_3 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_570_3 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_448_1 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_35_28_1 {
	meta:
		name = "??_G_Fac_node@std@@QAAPAXI@Z"
		size = 64
		refs = "000c ??1_Fac_node@std@@QAA@XZ 0022 ??3_Fac_node@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_114_150_1 {
	meta:
		name = "??_Gcodecvt_base@std@@UAAPAXI@Z"
		size = 64
		refs = "000c ??1codecvt_base@std@@UAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_68_178_2 {
	meta:
		name = "??_Gctype_base@std@@UAAPAXI@Z"
		size = 64
		refs = "000c ??1ctype_base@std@@UAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_460_1 {
	meta:
		name = "??_Gfacet@locale@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1facet@locale@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_27_203_3 {
	meta:
		name = "??_Glocale@std@@QAAPAXI@Z"
		size = 64
		refs = "000c ??1locale@std@@QAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_79_206_1 {
	meta:
		name = "??_Gmessages_base@std@@UAAPAXI@Z"
		size = 64
		refs = "000c ??1messages_base@std@@UAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_538_2 {
	meta:
		name = "??_Gmoney_base@std@@UAAPAXI@Z"
		size = 64
		refs = "000c ??1money_base@std@@UAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_79_209_1 {
	meta:
		name = "??_Gtime_base@std@@UAAPAXI@Z"
		size = 64
		refs = "000c ??1time_base@std@@UAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_145_1 {
	meta:
		name = "??_G?$ctype@D@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$ctype@D@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 18 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_118_123_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$numpunct@D@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 18 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_449_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$numpunct@G@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 18 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_450_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$numpunct@_W@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 18 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_146_1 {
	meta:
		name = "??_G_Facet_base@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1_Facet_base@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 04 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_147_1 {
	meta:
		name = "??_G_Generic_error_category@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1_Generic_error_category@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_114_64_3 {
	meta:
		name = "??_G?$shared_ptr@V__ExceptionPtr@@@std@@QAAPAXI@Z"
		size = 48
		refs = "000c ??1?$shared_ptr@V__ExceptionPtr@@@std@@QAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_110_173_2 {
	meta:
		name = "??_G_Iostream_error_category@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1_Iostream_error_category@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_33_106_3 {
	meta:
		name = "??_G_System_error_category@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1_System_error_category@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_153_1 {
	meta:
		name = "??_Gerror_category@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1error_category@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 08 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_149_1 {
	meta:
		name = "??_G_System_error@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1_System_error@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 14 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_68_182_2 {
	meta:
		name = "??_Gfailure@ios_base@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1failure@ios_base@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 14 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_44_12_2 {
	meta:
		name = "??_Gfuture_error@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1future_error@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 14 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_13_193_3 {
	meta:
		name = "??_Gsystem_error@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1system_error@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 14 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_162_1 {
	meta:
		name = "??__Ecerr@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0014 atexit 001c ??__Fcerr@std@@YAXXZ 0020 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0024 ?ferr@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_162_1 {
	meta:
		name = "??__Ecin@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0014 atexit 001c ??__Fcin@std@@YAXXZ 0020 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 0024 ?fin@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_195_3 {
	meta:
		name = "??__Eclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0014 atexit 001c ??__Fclog@std@@YAXXZ 0020 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0024 ?flog@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_195_3 {
	meta:
		name = "??__Ecout@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0014 atexit 001c ??__Fcout@std@@YAXXZ 0020 ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0024 ?fout@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_208_3 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 atexit 001c ??__Fwcerr@std@@YAXXZ 0020 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_208_3 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 atexit 001c ??__Fwcerr@std@@YAXXZ 0020 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0024 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_188_2 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 atexit 001c ??__Fwcerr@std@@YAXXZ 0020 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_188_2 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 atexit 001c ??__Fwcerr@std@@YAXXZ 0020 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0024 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_162_1 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 atexit 001c ??__Fwcerr@std@@YAXXZ 0020 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_188_2 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 atexit 001c ??__Fwcin@std@@YAXXZ 0020 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0024 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_162_1 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 atexit 001c ??__Fwcin@std@@YAXXZ 0020 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 0024 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_208_3 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 atexit 001c ??__Fwcin@std@@YAXXZ 0020 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0024 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_188_2 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 atexit 001c ??__Fwcin@std@@YAXXZ 0020 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 0024 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_188_2 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 atexit 001c ??__Fwclog@std@@YAXXZ 0020 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0024 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_188_2 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 atexit 001c ??__Fwclog@std@@YAXXZ 0020 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_208_3 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 atexit 001c ??__Fwclog@std@@YAXXZ 0020 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0024 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_208_3 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 atexit 001c ??__Fwclog@std@@YAXXZ 0020 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_162_1 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 atexit 001c ??__Fwclog@std@@YAXXZ 0020 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0024 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_162_1 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 atexit 001c ??__Fwclog@std@@YAXXZ 0020 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_208_3 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 atexit 001c ??__Fwcout@std@@YAXXZ 0020 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_208_3 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 atexit 001c ??__Fwcout@std@@YAXXZ 0020 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0024 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_188_2 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 atexit 001c ??__Fwcout@std@@YAXXZ 0020 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_188_2 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 atexit 001c ??__Fwcout@std@@YAXXZ 0020 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0024 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_162_1 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 40
		refs = "000e ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 atexit 001c ??__Fwcout@std@@YAXXZ 0020 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0024 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 00 22 06 49 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_163_1 {
	meta:
		name = "??__Eferr@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fferr@std@@YAXXZ 0028 ?ferr@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_163_1 {
	meta:
		name = "??__Eflog@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fflog@std@@YAXXZ 0028 ?flog@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_163_1 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwferr@std@@YAXXZ 0028 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_163_1 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwferr@std@@YAXXZ 0028 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_189_2 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwferr@std@@YAXXZ 0028 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_209_3 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwferr@std@@YAXXZ 0028 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_209_3 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwferr@std@@YAXXZ 0028 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_163_1 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwflog@std@@YAXXZ 0028 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_163_1 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwflog@std@@YAXXZ 0028 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_189_2 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwflog@std@@YAXXZ 0028 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_209_3 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwflog@std@@YAXXZ 0028 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_165_1 {
	meta:
		name = "??__Einitlocks@@YAXXZ"
		size = 32
		refs = "0008 ??0_Init_locks@std@@QAA@XZ 000e atexit 0018 ??__Finitlocks@@YAXXZ 001c ?initlocks@@3V_Init_locks@std@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_70_1 {
	meta:
		name = "??__E?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A@@YAXXZ"
		size = 32
		refs = "0008 ?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ 000e atexit 0018 ??__F?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A@@YAXXZ 001c ?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_2_1 {
	meta:
		name = "??__Einitlocks@std@@YAXXZ"
		size = 32
		refs = "0008 ??0_Init_locks@std@@QAA@XZ 000e atexit 0018 ??__Finitlocks@std@@YAXXZ 001c ?initlocks@std@@3V_Init_locks@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_171_1 {
	meta:
		name = "?_Allocate@std@@YAPAXII_N@Z"
		size = 164
		refs = "0026 __rt_udiv 0030 ?_Xbad_alloc@std@@YAXXZ 0040 ??2@YAPAXI@Z 0060 _CrtDbgReportW 007a _invalid_parameter 0090 ??_C@_1CG@JNLFBNGN@?$AA?$CC?$AAi?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAa?$AAr?$AAg?$AAu?$AAm?$AAe?$AAn?$AAt?$AA?$CC?$AA?$AA@ 0094 ??_C@_1BO@NKFMJPA@?$AAs?$AAt?$AAd?$AA?3?$AA?3?$AA_?$AAA?$AAl?$AAl?$AAo?$AAc?$AAa?$AAt?$AAe?$AA?$AA@ 0098 ??_C@_1FC@CNLMDHOG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAh?$AAp?$AAp?$AA?2@ 009c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00a0 ??_C@_1CC@GKJLLHIM@?$AA?$CC?$AA_?$AAP?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$AA@"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 88 B0 00 23 02 93 0A 9B 00 2B 02 D1 02 9B 03 93 33 E0 0B 98 6F F0 00 01 00 28 00 D1 F9 DE ?? ?? ?? ?? 0A 9B 98 42 01 D2 ?? ?? ?? ?? 0A 9A 0B 9B 02 FB 03 F3 04 93 04 98 ?? ?? ?? ?? 05 90 05 9B 02 93 02 9B 00 2B 16 D1 13 4B 01 93 11 4B 00 93 00 23 54 22 0E 49 02 20 ?? ?? ?? ?? 06 90 06 9B 01 2B 00 D1 FE DE 00 23 00 93 54 23 08 4A 07 49 05 48 ?? ?? ?? ?? 02 9B 03 93 03 98 08 B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_172_1 {
	meta:
		name = "?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX$$QAV12@@Z"
		size = 190
		refs = "000c ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ 001c ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ 0024 ?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ 003c ?move@?$char_traits@D@std@@SAPADPADPBDI@Z 0054 ??$addressof@PAD@std@@YAPAPADAAPAD@Z 005c ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0068 ??$construct@PADAAPAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAXPAPADAAPAD@Z 00b0 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 8E B0 11 98 ?? ?? ?? ?? 00 90 00 9B 1B 68 10 2B 13 D2 11 98 ?? ?? ?? ?? 01 90 11 98 ?? ?? ?? ?? 02 90 10 98 ?? ?? ?? ?? 03 90 01 9B 1B 68 5A 1C 02 99 03 98 ?? ?? ?? ?? 1B E0 11 98 ?? ?? ?? ?? 05 90 10 98 ?? ?? ?? ?? 04 90 04 98 ?? ?? ?? ?? 06 90 10 98 ?? ?? ?? ?? 07 90 05 9A 06 99 07 98 ?? ?? ?? ?? 11 98 ?? ?? ?? ?? 08 90 08 9A 00 23 13 60 11 98 ?? ?? ?? ?? 09 90 10 98 ?? ?? ?? ?? 0A 90 09 9B 1A 68 0A 9B 1A 60 11 98 ?? ?? ?? ?? 0B 90 10 98 ?? ?? ?? ?? 0C 90 0B 9B 1A 68 0C 9B 1A 60 00 22 00 21 11 98 ?? ?? ?? ?? 0E B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_173_1 {
	meta:
		name = "?_Atomic_fetch_add_4@std@@YAKPCKKW4memory_order@1@@Z"
		size = 112
		refs = "0024 ?_Fetch_add_relaxed_4@std@@YAKPCKK@Z 0034 ?_Fetch_add_acquire_4@std@@YAKPCKK@Z 0044 ?_Fetch_add_release_4@std@@YAKPCKK@Z 0054 ?_Fetch_add_seq_cst_4@std@@YAKPCKK@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 0A 9B 01 93 01 9B 05 2B 25 D8 01 9A DF E8 02 F0 03 0B 0B 13 1B 1B 09 99 08 98 ?? ?? ?? ?? 02 90 02 9B 00 93 19 E0 09 99 08 98 ?? ?? ?? ?? 03 90 03 9B 00 93 11 E0 09 99 08 98 ?? ?? ?? ?? 04 90 04 9B 00 93 09 E0 09 99 08 98 ?? ?? ?? ?? 05 90 05 9B 00 93 01 E0 00 23 00 93 00 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_174_1 {
	meta:
		name = "?_Atomic_fetch_sub_4@std@@YAKPCKKW4memory_order@1@@Z"
		size = 40
		refs = "0012 ?_Atomic_fetch_add_4@std@@YAKPCKKW4memory_order@1@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 05 9B 59 42 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_176_1 {
	meta:
		name = "?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXIID@Z"
		size = 72
		refs = "0012 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAPADXZ 0020 ?assign@?$char_traits@D@std@@SAXAADABD@Z 003a ?assign@?$char_traits@D@std@@SAPADPADID@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9B 01 2B 0A D1 04 98 ?? ?? ?? ?? 00 90 07 A9 00 9A 05 9B D0 18 ?? ?? ?? ?? 0B E0 04 98 ?? ?? ?? ?? 01 90 9D F9 1C 20 06 99 01 98 05 9B 18 44 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_177_1 {
	meta:
		name = "?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXI@Z"
		size = 44
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABIXZ 001e ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 1A 68 05 9B 9A 42 02 D2 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_504_1 {
	meta:
		name = "?_Check_offset@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXI@Z"
		size = 44
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABIXZ 001e ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 1A 68 05 9B 9A 42 02 D2 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_38_1 {
	meta:
		name = "?_Check_offset@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXI@Z"
		size = 44
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABIXZ 001e ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 1A 68 05 9B 9A 42 02 D2 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_178_1 {
	meta:
		name = "?_Clamp_suffix_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIII@Z"
		size = 60
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABIXZ"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 02 90 02 9B 1A 68 07 9B D3 1A 00 93 08 9A 00 9B 9A 42 03 D8 08 9B 01 93 02 E0 01 E0 00 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_507_1 {
	meta:
		name = "?_Clamp_suffix_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAIII@Z"
		size = 60
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABIXZ"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 02 90 02 9B 1A 68 07 9B D3 1A 00 93 08 9A 00 9B 9A 42 03 D8 08 9B 01 93 02 E0 01 E0 00 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_39_1 {
	meta:
		name = "?_Clamp_suffix_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAIII@Z"
		size = 60
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABIXZ"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 02 90 02 9B 1A 68 07 9B D3 1A 00 93 08 9A 00 9B 9A 42 03 D8 08 9B 01 93 02 E0 01 E0 00 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_179_1 {
	meta:
		name = "?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXII@Z"
		size = 314
		refs = "0020 ?max_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ 0036 ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ 0040 __rt_udiv 00b6 ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 00c2 ?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAPADI@Z 00d6 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAPADXZ 00de ??$_Unfancy@D@std@@YAPADPAD@Z 00ea ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 00f4 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z 00fa ?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0102 ??$addressof@PAD@std@@YAPAPADAAPAD@Z 0116 ??$construct@PADAAPAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAXPAPADAAPAD@Z 012c ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 90 48 0D F1 08 0B 96 B0 6F 46 6F F0 01 03 C7 E9 14 33 FB 6E 43 F0 0F 03 3B 60 B8 6E ?? ?? ?? ?? B8 60 BA 68 3B 68 9A 42 02 D2 FB 6E 3B 60 3F E0 B8 6E ?? ?? ?? ?? F8 60 39 68 03 20 ?? ?? ?? ?? 04 46 FB 68 19 68 02 20 ?? ?? ?? ?? A0 42 00 D8 2E E0 B8 6E ?? ?? ?? ?? B8 61 B8 6E ?? ?? ?? ?? 78 61 B8 6E ?? ?? ?? ?? 38 61 3B 69 19 68 02 20 ?? ?? ?? ?? 7B 69 1A 1A BB 69 1B 68 93 42 11 D8 B8 6E ?? ?? ?? ?? 38 62 B8 6E ?? ?? ?? ?? F8 61 FB 69 19 68 02 20 ?? ?? ?? ?? 3B 6A 1B 68 03 44 3B 60 05 E0 B8 6E ?? ?? ?? ?? 78 62 7B 6A 3B 60 B8 6E ?? ?? ?? ?? B8 62 3B 68 59 1C B8 6A ?? ?? ?? ?? F8 62 FB 6A 7B 60 FF E7 3B 6F 00 2B 0C D9 B8 6E ?? ?? ?? ?? B8 63 78 68 ?? ?? ?? ?? F8 63 3A 6F B9 6B F8 6B ?? ?? ?? ?? 00 22 01 21 B8 6E ?? ?? ?? ?? B8 6E ?? ?? ?? ?? 38 64 38 6C ?? ?? ?? ?? 78 64 B8 6E ?? ?? ?? ?? B8 64 3A 1D 79 6C B8 6C ?? ?? ?? ?? B8 6E ?? ?? ?? ?? F8 64 3A 68 FB 6C 1A 60 39 6F B8 6E ?? ?? ?? ?? 16 B0 BD E8 90 08 5D F8 14 FB }
	condition:
		$1
}

rule file_10_180_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXII@Z$1"
		size = 28
		refs = "0008 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z 0010 _CxxThrowException 0018 $LN17"
	strings:
		$1 = { 10 B5 00 22 01 21 B8 6E ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? 00 48 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_515_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXII@Z$1"
		size = 28
		refs = "0008 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z 0010 _CxxThrowException 0018 $LN17"
	strings:
		$1 = { 10 B5 00 22 01 21 B8 6E ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? 00 48 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_41_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXII@Z$1"
		size = 28
		refs = "0008 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z 0010 _CxxThrowException 0018 $LN17"
	strings:
		$1 = { 10 B5 00 22 01 21 B8 6E ?? ?? ?? ?? 00 21 00 20 ?? ?? ?? ?? 00 48 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_181_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXII@Z$0"
		size = 44
		refs = "0008 ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0014 ?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAPADI@Z 0028 $LN19"
	strings:
		$1 = { 10 B5 FB 6E 3B 60 B8 6E ?? ?? ?? ?? 38 63 3B 68 59 1C 38 6B ?? ?? ?? ?? 78 63 7B 6B 7B 60 00 F0 00 B8 01 48 10 BD FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_516_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXII@Z$0"
		size = 44
		refs = "0008 ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0014 ?allocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAPAGI@Z 0028 $LN19"
	strings:
		$1 = { 10 B5 FB 6E 3B 60 B8 6E ?? ?? ?? ?? 38 63 3B 68 59 1C 38 6B ?? ?? ?? ?? 78 63 7B 6B 7B 60 00 F0 00 B8 01 48 10 BD FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_42_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXII@Z$0"
		size = 44
		refs = "0008 ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0014 ?allocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAPA_WI@Z 0028 $LN19"
	strings:
		$1 = { 10 B5 FB 6E 3B 60 B8 6E ?? ?? ?? ?? 38 63 3B 68 59 1C 38 6B ?? ?? ?? ?? 78 63 7B 6B 7B 60 00 F0 00 B8 01 48 10 BD FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_182_1 {
	meta:
		name = "?_Deallocate@std@@YAXPAXII@Z"
		size = 22
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_183_1 {
	meta:
		name = "?_Dec_atomic_counter_explicit@std@@YAKAAKW4memory_order@1@@Z"
		size = 40
		refs = "0010 ?_Atomic_fetch_sub_4@std@@YAKPCKKW4memory_order@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 9A 01 21 04 98 ?? ?? ?? ?? 00 90 00 9B 5B 1E 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_184_1 {
	meta:
		name = "?_Decref@facet@locale@std@@UAAPAV_Facet_base@3@XZ"
		size = 52
		refs = "0010 ?_Dec_atomic_counter_explicit@std@@YAKAAKW4memory_order@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 21 04 9B 18 1D ?? ?? ?? ?? 01 90 01 9B 00 2B 03 D1 04 9B 00 93 02 E0 01 E0 00 23 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_185_1 {
	meta:
		name = "?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAA_NXZ"
		size = 498
		refs = "000a __security_push_cookie 0040 ?eof@?$char_traits@D@std@@SAHXZ 005a _guard_check_icall 007e ?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z 0098 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 00a6 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 00ae ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAAADXZ 00b8 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ 00f0 ?unshift@?$codecvt@DDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PAD1AAPAD@Z 0162 fwrite 0178 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 01ae ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 01e6 __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 B0 48 0D F1 0C 0B ?? ?? ?? ?? A6 B0 6F 46 82 B0 6F F0 01 03 C7 E9 1E 33 D7 F8 B0 30 38 33 1B 68 00 2B 05 D0 D7 F8 B0 30 3D 33 1B 78 00 2B 03 D1 01 23 3B 72 D3 E0 D2 E0 08 23 FB 65 ?? ?? ?? ?? B8 61 BD 69 D7 F8 B0 30 1B 68 0C 33 D7 F8 B0 40 1B 68 7B 61 78 69 ?? ?? ?? ?? 7B 69 20 46 29 46 98 47 F8 61 FB 69 7B 62 ?? ?? ?? ?? 38 62 3B 6A BB 62 17 F1 24 01 17 F1 28 00 ?? ?? ?? ?? 38 70 3B 78 00 2B 02 D0 00 23 3B 72 A8 E0 00 22 08 21 17 F1 80 00 ?? ?? ?? ?? 38 66 17 F1 64 01 17 F1 80 00 ?? ?? ?? ?? F8 62 F8 6A ?? ?? ?? ?? 78 63 17 F1 80 00 ?? ?? ?? ?? B8 63 17 F1 68 01 17 F1 80 00 ?? ?? ?? ?? 38 63 38 6B ?? ?? ?? ?? F8 63 17 F1 48 03 00 93 7A 6B BB 6B 13 44 FA 6B D7 F8 B0 10 40 31 D7 F8 B0 00 38 30 00 68 ?? ?? ?? ?? 38 64 3B 6C 3B 61 3B 69 00 2B 06 D0 3B 69 01 2B 09 D0 3B 69 03 2B 53 D0 5B E0 D7 F8 B0 30 03 F1 3D 02 00 23 13 70 17 F1 6C 01 17 F1 80 00 ?? ?? ?? ?? 78 64 78 6C ?? ?? ?? ?? F8 64 BA 6C FB 6C D3 1A FB 60 FB 68 00 2B 21 D9 17 F1 70 01 17 F1 80 00 ?? ?? ?? ?? 38 65 38 6D ?? ?? ?? ?? 78 65 D7 F8 B0 30 4C 33 1B 68 FA 68 01 21 78 6D ?? ?? ?? ?? B8 65 FA 68 BB 6D 9A 42 08 D0 00 23 7B 70 17 F1 80 00 ?? ?? ?? ?? 7B 78 3B 72 2F E0 D7 F8 B0 30 3D 33 1B 78 00 2B 08 D1 01 23 BB 70 17 F1 80 00 ?? ?? ?? ?? BB 78 3B 72 20 E0 FB 68 00 2B 05 D1 00 22 08 21 17 F1 80 00 ?? ?? ?? ?? 11 E0 01 23 FB 70 17 F1 80 00 ?? ?? ?? ?? FB 78 3B 72 0D E0 00 23 3B 71 17 F1 80 00 ?? ?? ?? ?? 3B 79 3B 72 04 E0 61 E7 17 F1 80 00 ?? ?? ?? ?? 38 7A 28 B0 ?? ?? ?? ?? BD E8 B0 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_187_1 {
	meta:
		name = "?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z"
		size = 74
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 001e ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QAAPADXZ 003c ?assign@?$char_traits@D@std@@SAXAADABD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 02 90 02 9B 01 93 00 23 8D F8 00 30 01 98 ?? ?? ?? ?? 03 90 01 9B 03 F1 10 02 07 9B 13 60 69 46 07 9A 01 23 02 FB 03 F2 03 9B 98 18 ?? ?? ?? ?? 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_188_1 {
	meta:
		name = "?_Fetch_add_acquire_4@std@@YAKPCKK@Z"
		size = 54
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 83 B0 06 9C 07 98 54 E8 00 2F 11 18 44 E8 00 13 00 2B F8 D1 13 46 00 93 BF F3 5B 8F 00 9B 01 93 01 98 03 B0 BD E8 10 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_189_1 {
	meta:
		name = "?_Fetch_add_relaxed_4@std@@YAKPCKK@Z"
		size = 50
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 83 B0 06 9C 07 98 54 E8 00 2F 11 18 44 E8 00 13 00 2B F8 D1 13 46 00 93 00 9B 01 93 01 98 03 B0 BD E8 10 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_190_1 {
	meta:
		name = "?_Fetch_add_release_4@std@@YAKPCKK@Z"
		size = 54
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 83 B0 BF F3 5B 8F 06 9C 07 98 54 E8 00 2F 11 18 44 E8 00 13 00 2B F8 D1 13 46 00 93 00 9B 01 93 01 98 03 B0 BD E8 10 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_191_1 {
	meta:
		name = "?_Fetch_add_seq_cst_4@std@@YAKPCKK@Z"
		size = 58
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 83 B0 BF F3 5B 8F 06 9C 07 98 54 E8 00 2F 11 18 44 E8 00 13 00 2B F8 D1 13 46 00 93 BF F3 5B 8F 00 9B 01 93 01 98 03 B0 BD E8 10 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_200_1 {
	meta:
		name = "?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 162
		refs = "002a ??2_Crt_new_delete@std@@SAPAXI@Z 003c ?c_str@locale@std@@QBAPBDXZ 0048 ??0_Locinfo@std@@QAA@PBD@Z 0060 ??0?$codecvt@DDU_Mbstatet@@@std@@QAA@ABV_Locinfo@1@I@Z 008e ??1_Locinfo@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 99 B0 6F 46 6F F0 01 03 C7 E9 0A 33 00 23 3B 60 3B 6F 00 2B 38 D0 3B 6F 1B 68 00 2B 34 D1 08 20 ?? ?? ?? ?? F8 60 FB 68 7B 60 7B 68 00 2B 18 D0 78 6F ?? ?? ?? ?? 38 61 39 69 17 F1 30 00 ?? ?? ?? ?? 78 61 7B 69 BB 61 3B 68 43 F0 01 03 3B 60 00 22 B9 69 78 68 ?? ?? ?? ?? F8 61 FB 69 BB 60 01 E0 00 23 BB 60 BB 68 3B 62 3A 6A 3B 6F 1A 60 3B 68 13 F0 01 0F 07 D0 3B 68 23 F0 01 03 3B 60 17 F1 30 00 ?? ?? ?? ?? 02 23 7B 62 78 6A 19 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_202_1 {
	meta:
		name = "__unwindfunclet$?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1"
		size = 32
		refs = "001a ??1_Locinfo@std@@QAA@XZ"
		altNames = "__unwindfunclet$?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$messages@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$messages@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$messages@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 08 80 3B 68 23 F0 01 03 3B 60 17 F1 30 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_10_203_1 {
	meta:
		name = "?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 162
		refs = "002a ??2_Crt_new_delete@std@@SAPAXI@Z 003c ?c_str@locale@std@@QBAPBDXZ 0048 ??0_Locinfo@std@@QAA@PBD@Z 0060 ??0?$ctype@D@std@@QAA@ABV_Locinfo@1@I@Z 008e ??1_Locinfo@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 99 B0 6F 46 6F F0 01 03 C7 E9 0A 33 00 23 3B 60 3B 6F 00 2B 38 D0 3B 6F 1B 68 00 2B 34 D1 18 20 ?? ?? ?? ?? F8 60 FB 68 7B 60 7B 68 00 2B 18 D0 78 6F ?? ?? ?? ?? 38 61 39 69 17 F1 30 00 ?? ?? ?? ?? 78 61 7B 69 BB 61 3B 68 43 F0 01 03 3B 60 00 22 B9 69 78 68 ?? ?? ?? ?? F8 61 FB 69 BB 60 01 E0 00 23 BB 60 BB 68 3B 62 3A 6A 3B 6F 1A 60 3B 68 13 F0 01 0F 07 D0 3B 68 23 F0 01 03 3B 60 17 F1 30 00 ?? ?? ?? ?? 02 23 7B 62 78 6A 19 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_206_1 {
	meta:
		name = "?_Getctype@_Locinfo@std@@QBA?AU_Ctypevec@@XZ"
		size = 62
		refs = "000e _Getctype"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 8A B0 02 A8 ?? ?? ?? ?? 02 AB 00 93 00 9C 06 AD 94 E8 0F 00 85 E8 0F 00 0F 9D 06 AC 94 E8 0F 00 85 E8 0F 00 0F 9B 01 93 01 98 0A B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_207_1 {
	meta:
		name = "?_Getfacet@locale@std@@QBAPBVfacet@12@I@Z"
		size = 156
		refs = "005a ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 9B 1B 1D 1B 68 0C 33 09 9A 1B 68 9A 42 0D D2 08 9B 1B 1D 1B 68 03 F1 08 01 09 9A 04 23 02 FB 03 F2 0B 68 13 44 1B 68 00 93 01 E0 00 23 00 93 00 9B 01 93 01 9B 00 2B 06 D1 08 9B 1B 1D 1B 68 14 33 1B 78 00 2B 03 D1 01 9B 04 93 1B E0 1A E0 ?? ?? ?? ?? 05 90 05 9B 02 93 02 9B 0C 33 09 9A 1B 68 9A 42 0B D2 02 9B 03 F1 08 01 09 9A 04 23 02 FB 03 F2 0B 68 13 44 1B 68 03 93 01 E0 00 23 03 93 03 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_208_1 {
	meta:
		name = "?_Gnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBA_JXZ"
		size = 62
		altNames = "?_Gnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBA_JXZ ?_Gnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBA_JXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 1C 33 1B 68 1B 68 00 2B 05 D0 06 9B 2C 33 1B 68 1B 68 00 93 01 E0 00 23 00 93 00 9A 00 9B DB 17 02 92 03 93 02 98 03 99 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_209_1 {
	meta:
		name = "?_Gndec@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAPADXZ"
		size = 66
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 2C 33 1B 68 1B 68 5A 1C 04 9B 2C 33 1B 68 1A 60 04 9B 1C 33 1B 68 1B 68 5B 1E 00 93 04 9B 1C 33 1A 68 00 9B 13 60 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_210_1 {
	meta:
		name = "?_Gninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAPADXZ"
		size = 72
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 2C 33 1B 68 1B 68 5A 1E 04 9B 2C 33 1B 68 1A 60 04 9B 1C 33 1B 68 1B 68 00 93 04 9B 1C 33 1B 68 1B 68 5A 1C 04 9B 1C 33 1B 68 1A 60 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_211_1 {
	meta:
		name = "?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z"
		size = 188
		refs = "000c ?max_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ 001c ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 0022 ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ 0034 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ 0042 ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXII@Z 0082 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z 0092 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 88 B0 0A 98 ?? ?? ?? ?? 02 90 02 9A 0B 9B 9A 42 02 D2 0A 98 ?? ?? ?? ?? 0A 98 ?? ?? ?? ?? 03 90 03 9B 1A 68 0B 9B 9A 42 0A D2 0A 98 ?? ?? ?? ?? 04 90 04 9B 1A 68 0B 99 0A 98 ?? ?? ?? ?? 26 E0 9D F8 30 30 00 2B 1B D0 0B 9B 10 2B 18 D2 0A 98 ?? ?? ?? ?? 05 90 0B 9A 05 9B 1B 68 9A 42 02 D2 0B 9B 00 93 06 E0 0A 98 ?? ?? ?? ?? 06 90 06 9B 1B 68 00 93 00 9A 01 21 0A 98 ?? ?? ?? ?? 06 E0 0B 9B 00 2B 03 D1 00 21 0A 98 ?? ?? ?? ?? 0B 9B 00 2B 02 D9 01 23 01 93 01 E0 00 23 01 93 01 9B DB B2 8D F8 1C 30 9D F8 1C 00 08 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_212_1 {
	meta:
		name = "?_Inc_atomic_counter_explicit@std@@YAKAAKW4memory_order@1@@Z"
		size = 40
		refs = "0010 ?_Atomic_fetch_add_4@std@@YAKPCKKW4memory_order@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 9A 01 21 04 98 ?? ?? ?? ?? 00 90 00 9B 5B 1C 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_214_1 {
	meta:
		name = "?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
		size = 160
		refs = "0032 ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXXZ 0050 _get_stream_buffer_pointers 006c ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXPAPAD0PAH001@Z 0084 memcpy 009c ?_Stinit@?1??_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0E 9B 01 2B 02 D1 01 23 07 93 01 E0 00 23 07 93 0C 9B 03 F1 48 02 07 9B DB B2 13 70 0C 9B 03 F1 3D 02 00 23 13 70 0C 98 ?? ?? ?? ?? 0D 9B 00 2B 19 D0 00 23 06 93 00 23 05 93 00 23 04 93 04 AB 05 AA 06 A9 0D 98 ?? ?? ?? ?? 04 9B 08 93 08 9B 02 93 05 9B 01 93 06 9B 00 93 04 9B 05 9A 06 99 0C 98 ?? ?? ?? ?? 0C 9B 03 F1 4C 02 0D 9B 13 60 0C 9B 03 F1 40 00 06 49 08 22 ?? ?? ?? ?? 0C 9B 03 F1 38 02 00 23 13 60 0A B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_215_1 {
	meta:
		name = "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXPAPAD0PAH001@Z"
		size = 76
		altNames = "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXPAPAG0PAH001@Z ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXPAPA_W0PAH001@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 02 9B 03 F1 0C 02 03 9B 13 60 02 9B 03 F1 10 02 06 9B 13 60 02 9B 03 F1 1C 02 04 9B 13 60 02 9B 03 F1 20 02 07 9B 13 60 02 9B 03 F1 2C 02 05 9B 13 60 02 9B 03 F1 30 02 08 9B 13 60 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_216_1 {
	meta:
		name = "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXXZ"
		size = 108
		refs = "0054 ?setp@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXPAD0@Z 0060 ?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXPAD00@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 1A 1D 02 9B 0C 33 1A 60 02 9B 03 F1 08 02 02 9B 10 33 1A 60 02 9B 03 F1 14 02 02 9B 1C 33 1A 60 02 9B 03 F1 18 02 02 9B 20 33 1A 60 02 9B 03 F1 24 02 02 9B 2C 33 1A 60 02 9B 03 F1 28 02 02 9B 30 33 1A 60 00 22 00 21 02 98 ?? ?? ?? ?? 00 23 00 22 00 21 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_84_250_2 {
	meta:
		name = "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXXZ"
		size = 108
		refs = "0054 ?setp@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXPAG0@Z 0060 ?setg@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXPAG00@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 1A 1D 02 9B 0C 33 1A 60 02 9B 03 F1 08 02 02 9B 10 33 1A 60 02 9B 03 F1 14 02 02 9B 1C 33 1A 60 02 9B 03 F1 18 02 02 9B 20 33 1A 60 02 9B 03 F1 24 02 02 9B 2C 33 1A 60 02 9B 03 F1 28 02 02 9B 30 33 1A 60 00 22 00 21 02 98 ?? ?? ?? ?? 00 23 00 22 00 21 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_30_250_2 {
	meta:
		name = "?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXXZ"
		size = 108
		refs = "0054 ?setp@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXPA_W0@Z 0060 ?setg@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXPA_W00@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 1A 1D 02 9B 0C 33 1A 60 02 9B 03 F1 08 02 02 9B 10 33 1A 60 02 9B 03 F1 14 02 02 9B 1C 33 1A 60 02 9B 03 F1 18 02 02 9B 20 33 1A 60 02 9B 03 F1 24 02 02 9B 2C 33 1A 60 02 9B 03 F1 28 02 02 9B 30 33 1A 60 00 22 00 21 02 98 ?? ?? ?? ?? 00 23 00 22 00 21 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_218_1 {
	meta:
		name = "?_Init@?$ctype@D@std@@IAAXABV_Locinfo@2@@Z"
		size = 48
		refs = "0010 ?_Getctype@_Locinfo@std@@QBA?AU_Ctypevec@@XZ"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 86 B0 02 A9 0B 98 ?? ?? ?? ?? 00 90 00 9C 0A 9B 03 F1 08 05 94 E8 0F 00 85 E8 0F 00 06 B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_219_1 {
	meta:
		name = "?_Init@ios_base@std@@IAAXXZ"
		size = 172
		refs = "0070 ?clear@ios_base@std@@QAAXH@Z 0076 ??2_Crt_new_delete@std@@SAPAXI@Z 0088 ??0locale@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 9B 03 F1 30 02 00 23 13 60 08 9B 03 F1 08 02 00 23 13 60 08 9B 03 F1 10 02 00 23 13 60 08 9B 03 F1 14 02 40 F2 01 23 13 60 08 9B 18 33 00 93 00 9A 06 23 13 60 00 9A 00 23 53 60 08 9B 20 33 01 93 01 9A 00 23 13 60 01 9A 00 23 53 60 08 9B 03 F1 28 02 00 23 13 60 08 9B 03 F1 2C 02 00 23 13 60 00 21 08 98 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 04 90 04 9B 02 93 02 9B 00 2B 06 D0 02 98 ?? ?? ?? ?? 05 90 05 9B 03 93 01 E0 00 23 03 93 08 9B 03 F1 30 02 03 9B 13 60 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_220_1 {
	meta:
		name = "?_Init_atomic_counter@std@@YAXAAKK@Z"
		size = 22
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 9A 02 9B 1A 60 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_221_1 {
	meta:
		name = "?_Initcvt@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAAXPBV?$codecvt@DDU_Mbstatet@@@2@@Z"
		size = 66
		refs = "000c ?always_noconv@codecvt_base@std@@QBA_NXZ 0034 ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 05 D0 04 9B 03 F1 38 02 00 23 13 60 07 E0 04 9B 03 F1 38 02 05 9B 13 60 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_84_255_2 {
	meta:
		name = "?_Initcvt@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPBV?$codecvt@GDU_Mbstatet@@@2@@Z"
		size = 66
		refs = "000c ?always_noconv@codecvt_base@std@@QBA_NXZ 0034 ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 05 D0 04 9B 03 F1 38 02 00 23 13 60 07 E0 04 9B 03 F1 38 02 05 9B 13 60 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_30_255_2 {
	meta:
		name = "?_Initcvt@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPBV?$codecvt@_WDU_Mbstatet@@@2@@Z"
		size = 66
		refs = "000c ?always_noconv@codecvt_base@std@@QBA_NXZ 0034 ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 05 D0 04 9B 03 F1 38 02 00 23 13 60 07 E0 04 9B 03 F1 38 02 05 9B 13 60 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_222_1 {
	meta:
		name = "?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NPBD@Z"
		size = 92
		refs = "0012 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAPADXZ 002a ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 9B 00 2B 16 D0 06 98 ?? ?? ?? ?? 01 90 07 9A 01 9B 9A 42 0E D3 06 98 ?? ?? ?? ?? 02 90 06 98 ?? ?? ?? ?? 03 90 02 9A 03 9B 1B 68 1A 44 07 9B 9A 42 04 D8 00 23 8D F8 00 30 03 E0 02 E0 01 23 8D F8 00 30 9D F8 00 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_223_1 {
	meta:
		name = "?_Lock@?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAAXXZ"
		size = 36
		refs = "0018 _lock_file"
		altNames = "?_Lock@?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAAXXZ ?_Lock@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 4C 33 1B 68 00 2B 04 D0 02 9B 4C 33 18 68 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_96_243_1 {
	meta:
		name = "?_Unlock@?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAAXXZ"
		size = 36
		refs = "0018 _unlock_file"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 4C 33 1B 68 00 2B 04 D0 02 9B 4C 33 18 68 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_46_302_3 {
	meta:
		name = "?_Unlock@?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAAXXZ"
		size = 36
		refs = "0018 _unlock_file"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 4C 33 1B 68 00 2B 04 D0 02 9B 4C 33 18 68 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_21_243_1 {
	meta:
		name = "?_Unlock@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAAXXZ"
		size = 36
		refs = "0018 _unlock_file"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 4C 33 1B 68 00 2B 04 D0 02 9B 4C 33 18 68 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_225_1 {
	meta:
		name = "?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z"
		size = 136
		refs = "000a __security_push_cookie 0020 ?empty@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBA_NXZ 0030 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBD@Z 003c ?message@error_code@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 004a ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@@Z 0052 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 005a ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@$$QAV01@@Z 0076 __security_pop_cookie 0084 ??_C@_02LMMGGCAJ@?3?5?$AA@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B ?? ?? ?? ?? 8E B0 6F 46 6F F0 01 03 C7 E9 06 33 00 23 7B 60 78 6D ?? ?? ?? ?? 38 70 3B 78 00 2B 03 D1 15 49 78 6D ?? ?? ?? ?? 17 F1 20 01 17 F1 4C 00 ?? ?? ?? ?? B8 60 BB 68 FB 60 F9 68 78 6D ?? ?? ?? ?? 17 F1 20 00 ?? ?? ?? ?? 79 6D B8 6C ?? ?? ?? ?? 78 61 7B 68 43 F0 01 03 7B 60 78 6D ?? ?? ?? ?? BB 6C 3B 61 38 69 0E B0 ?? ?? ?? ?? BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_228_1 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAPADXZ"
		size = 42
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0014 ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QAAPADXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 00 90 00 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_84_264_2 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAPBDXZ"
		size = 42
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0014 ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QBAPBDXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 00 90 00 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_971_3 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAPAGXZ"
		size = 42
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0014 ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QAAPAGXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 00 90 00 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_972_3 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAPBGXZ"
		size = 42
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0014 ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QBAPBGXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 00 90 00 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_32_41_1 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAPA_WXZ"
		size = 42
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0014 ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAAPA_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 00 90 00 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_974_3 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAPB_WXZ"
		size = 42
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0014 ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QBAPB_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 00 90 00 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_230_1 {
	meta:
		name = "?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QAAPADXZ"
		size = 56
		refs = "0018 ??$_Unfancy@D@std@@YAPADPAD@Z"
		altNames = "?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QBAPBDXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 14 33 1B 68 10 2B 07 D3 06 9B 18 68 ?? ?? ?? ?? 01 90 01 9B 00 93 01 E0 06 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_232_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
		altNames = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 14 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_51_123_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 14 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_831_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 14 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_32_43_1 {
	meta:
		name = "?_Myres@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 14 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_41_277_3 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 14 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_937_2 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 14 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_938_2 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 14 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_939_2 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 14 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_989_3 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 14 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_233_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 10 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_834_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@D@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 10 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_835_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 10 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_836_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@G@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 10 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_837_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 10 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_838_1 {
	meta:
		name = "?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABIXZ"
		size = 36
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 10 33 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_235_1 {
	meta:
		name = "?_Pnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBA_JXZ"
		size = 62
		altNames = "?_Pnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBA_JXZ ?_Pnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBA_JXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 20 33 1B 68 1B 68 00 2B 05 D0 06 9B 30 33 1B 68 1B 68 00 93 01 E0 00 23 00 93 00 9A 00 9B DB 17 02 92 03 93 02 98 03 99 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_236_1 {
	meta:
		name = "?_Pninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAPADXZ"
		size = 72
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 30 33 1B 68 1B 68 5A 1E 04 9B 30 33 1B 68 1A 60 04 9B 20 33 1B 68 1B 68 00 93 04 9B 20 33 1B 68 1B 68 5A 1C 04 9B 20 33 1B 68 1A 60 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_237_1 {
	meta:
		name = "?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AAAXXZ"
		size = 64
		refs = "000c ?eback@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 0032 ?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXPAD00@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 04 9B 03 F1 3C 02 00 9B 93 42 0B D1 04 9B 54 33 1B 68 04 9A 50 32 12 68 04 99 50 31 09 68 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_84_274_2 {
	meta:
		name = "?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAAXXZ"
		size = 64
		refs = "000c ?eback@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 0032 ?setg@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXPAG00@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 04 9B 03 F1 3C 02 00 9B 93 42 0B D1 04 9B 54 33 1B 68 04 9A 50 32 12 68 04 99 50 31 09 68 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_30_274_2 {
	meta:
		name = "?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAAXXZ"
		size = 64
		refs = "000c ?eback@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 0032 ?setg@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXPA_W00@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 04 9B 03 F1 3C 02 00 9B 93 42 0B D1 04 9B 54 33 1B 68 04 9A 50 32 12 68 04 99 50 31 09 68 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_238_1 {
	meta:
		name = "?_Set_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AAAXXZ"
		size = 94
		refs = "000c ?eback@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 0032 ?egptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 0050 ?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXPAD00@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 00 90 06 9B 03 F1 3C 02 00 9B 93 42 11 D0 06 98 ?? ?? ?? ?? 01 90 06 9B 03 F1 50 02 01 9B 13 60 06 98 ?? ?? ?? ?? 02 90 06 9B 03 F1 54 02 02 9B 13 60 06 9B 3D 33 06 9A 3C 32 06 99 3C 31 06 98 ?? ?? ?? ?? 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_239_1 {
	meta:
		name = "?_Tidy@?$_Yarn@D@std@@AAAXXZ"
		size = 40
		refs = "0016 _free_dbg"
		altNames = "?_Tidy@?$_Yarn@_W@std@@AAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 1B 68 00 2B 04 D0 02 21 02 9B 18 68 ?? ?? ?? ?? 02 9A 00 23 13 60 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_241_1 {
	meta:
		name = "?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAX_NI@Z"
		size = 176
		refs = "0016 ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ 0026 ?_Bx@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAT_Bxty@?$_String_val@U?$_Simple_types@D@std@@@2@XZ 003c ??$addressof@PAD@std@@YAPAPADAAPAD@Z 0044 ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 004e ??$destroy@PAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAXPAPAD@Z 005a ??$_Unfancy@D@std@@YAPADPAD@Z 006e ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 008c ?deallocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAXPADI@Z 00a2 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8C B0 9D F8 3C 30 00 2B 00 D1 3D E0 0E 98 ?? ?? ?? ?? 01 90 01 9B 1B 68 10 2B 35 D3 0E 98 ?? ?? ?? ?? 02 90 02 9B 1B 68 00 93 0E 98 ?? ?? ?? ?? 03 90 03 98 ?? ?? ?? ?? 04 90 0E 98 ?? ?? ?? ?? 05 90 04 99 05 98 ?? ?? ?? ?? 10 9B 00 2B 0C D9 00 98 ?? ?? ?? ?? 06 90 0E 98 ?? ?? ?? ?? 07 90 10 9A 06 99 07 98 ?? ?? ?? ?? 0E 98 ?? ?? ?? ?? 08 90 0E 98 ?? ?? ?? ?? 09 90 08 9B 1B 68 5A 1C 00 99 09 98 ?? ?? ?? ?? 0E 98 ?? ?? ?? ?? 0A 90 0A 9A 0F 23 13 60 10 99 0E 98 ?? ?? ?? ?? 0C B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_242_1 {
	meta:
		name = "?_Tidy@?$ctype@D@std@@IAAXXZ"
		size = 86
		refs = "001e free 003c ??_V@YAXPAX@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 08 33 08 33 1B 68 00 2B 06 DD 04 9B 08 33 1B 1D 18 68 ?? ?? ?? ?? 0D E0 04 9B 08 33 08 33 1B 68 00 2B 07 DA 04 9B 08 33 1B 1D 1B 68 00 93 00 98 ?? ?? ?? ?? 04 9B 08 33 0C 33 18 68 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_245_1 {
	meta:
		name = "?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
		size = 20
		refs = "000a ?_Xlength_error@std@@YAXPBD@Z 0010 ??_C@_0BA@JFNIOLAK@string?5too?5long?$AA@"
		altNames = "?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 01 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_141_2 {
	meta:
		name = "?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ"
		size = 20
		refs = "000a ?_Xout_of_range@std@@YAXPBD@Z 0010 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 01 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_887_1 {
	meta:
		name = "?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ"
		size = 20
		refs = "000a ?_Xout_of_range@std@@YAXPBD@Z 0010 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 01 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_111_3 {
	meta:
		name = "?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ"
		size = 20
		refs = "000a ?_Xout_of_range@std@@YAXPBD@Z 0010 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 01 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_249_1 {
	meta:
		name = "?address@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QBAPADAAD@Z"
		size = 34
		refs = "000c ?pointer_to@?$pointer_traits@PAD@std@@SAPADAAD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_891_1 {
	meta:
		name = "?address@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QBAPAGAAG@Z"
		size = 34
		refs = "000c ?pointer_to@?$pointer_traits@PAG@std@@SAPAGAAG@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_118_286_2 {
	meta:
		name = "?address@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QBAPAU_Container_proxy@2@AAU32@@Z"
		size = 34
		refs = "000c ?pointer_to@?$pointer_traits@PAU_Container_proxy@std@@@std@@SAPAU_Container_proxy@2@AAU32@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_1069_3 {
	meta:
		name = "?address@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QBAPA_WAA_W@Z"
		size = 34
		refs = "000c ?pointer_to@?$pointer_traits@PA_W@std@@SAPA_WAA_W@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_251_1 {
	meta:
		name = "?allocate@?$allocator@D@std@@QAAPADI@Z"
		size = 38
		refs = "0010 ?_Allocate@std@@YAPAXII_N@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 01 22 01 21 05 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_252_1 {
	meta:
		name = "?always_noconv@codecvt_base@std@@QBA_NXZ"
		size = 62
		refs = "001a _guard_check_icall"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 83 B0 06 9B 1B 68 0C 33 06 9C 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 98 47 8D F8 00 00 9D F8 00 30 8D F8 08 30 9D F8 08 00 03 B0 BD E8 10 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_253_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@@Z"
		size = 48
		refs = "0014 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z 002c ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 08 4B 1B 68 00 22 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_900_1 {
	meta:
		name = "?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@@Z"
		size = 48
		refs = "0014 ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z 002c ?npos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@2IB"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 08 4B 1B 68 00 22 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_903_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@@Z"
		size = 48
		refs = "0014 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z 002c ?npos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@2IB"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 08 4B 1B 68 00 22 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_268_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@@Z"
		size = 48
		refs = "0014 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z 002c ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 08 4B 1B 68 00 22 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_911_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@@Z"
		size = 48
		refs = "0014 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z 002c ?npos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@2IB"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 08 4B 1B 68 00 22 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_917_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@@Z"
		size = 48
		refs = "0014 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z 002c ?npos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@2IB"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 08 4B 1B 68 00 22 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_254_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 184
		refs = "000e ?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXI@Z 0018 ?_Clamp_suffix_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIII@Z 0024 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ 003c ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 005e ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0070 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAPBDXZ 0078 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAPADXZ 0096 ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 009e ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z 00b4 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0E 99 0D 98 ?? ?? ?? ?? 0F 9A 0E 99 0D 98 ?? ?? ?? ?? 02 90 02 9B 0F 93 0C 98 ?? ?? ?? ?? 03 90 22 4B 1A 68 03 9B 1B 68 D2 1A 0F 9B 9A 42 02 D8 0C 98 ?? ?? ?? ?? 0C 98 ?? ?? ?? ?? 04 90 04 9B 1A 68 0F 9B 13 44 01 93 0F 9B 00 2B 24 D9 00 22 01 99 0C 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 19 D0 0D 98 ?? ?? ?? ?? 05 90 0C 98 ?? ?? ?? ?? 06 90 0C 98 ?? ?? ?? ?? 07 90 0F 9A 05 99 0E 9B 19 44 06 98 07 9B 1B 68 18 44 ?? ?? ?? ?? 01 99 0C 98 ?? ?? ?? ?? 0C 9B 08 93 08 98 0A B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_255_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z"
		size = 140
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ 0024 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 0046 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 006a ?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXIID@Z 0072 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z 0088 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 08 98 ?? ?? ?? ?? 02 90 1D 4B 1A 68 02 9B 1B 68 D2 1A 09 9B 9A 42 02 D8 08 98 ?? ?? ?? ?? 08 98 ?? ?? ?? ?? 03 90 03 9B 1A 68 09 9B 13 44 01 93 09 9B 00 2B 1A D9 00 22 01 99 08 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0F D0 08 98 ?? ?? ?? ?? 04 90 9D F9 28 30 09 9A 04 99 09 68 08 98 ?? ?? ?? ?? 01 99 08 98 ?? ?? ?? ?? 08 9B 05 93 05 98 06 B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_256_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBD@Z"
		size = 46
		refs = "000c ?length@?$char_traits@D@std@@SAIPBD@Z 0018 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBDI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 98 ?? ?? ?? ?? 00 90 00 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_75_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_W@Z"
		size = 46
		refs = "000c ?length@?$char_traits@_W@std@@SAIPB_W@Z 0018 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_WI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 98 ?? ?? ?? ?? 00 90 00 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_4_299_2 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBD@Z"
		size = 46
		refs = "000c ?length@?$char_traits@D@std@@SAIPBD@Z 0018 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBDI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 98 ?? ?? ?? ?? 00 90 00 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_914_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@PBG@Z"
		size = 46
		refs = "000c ?length@?$char_traits@G@std@@SAIPBG@Z 0018 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@PBGI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 98 ?? ?? ?? ?? 00 90 00 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_1049_2 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_W@Z"
		size = 46
		refs = "000c ?length@?$char_traits@_W@std@@SAIPB_W@Z 0018 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_WI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 98 ?? ?? ?? ?? 00 90 00 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_257_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBDI@Z"
		size = 200
		refs = "000e ?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NPBD@Z 0020 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAPADXZ 0032 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z 0040 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ 0058 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 007a ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 00a6 ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 00ae ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z 00c4 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0D 99 0C 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0F D0 0C 98 ?? ?? ?? ?? 03 90 0E 9B 0D 99 03 9A 8A 1A 0C 99 0C 98 ?? ?? ?? ?? 04 90 04 9B 02 93 3B E0 0C 98 ?? ?? ?? ?? 05 90 1F 4B 1A 68 05 9B 1B 68 D2 1A 0E 9B 9A 42 02 D8 0C 98 ?? ?? ?? ?? 0C 98 ?? ?? ?? ?? 06 90 06 9B 1A 68 0E 9B 13 44 01 93 0E 9B 00 2B 1E D9 00 22 01 99 0C 98 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 13 D0 0C 98 ?? ?? ?? ?? 07 90 0C 98 ?? ?? ?? ?? 08 90 0E 9A 0D 99 07 98 08 9B 1B 68 18 44 ?? ?? ?? ?? 01 99 0C 98 ?? ?? ?? ?? 0C 9B 02 93 02 98 0A B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_258_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 142
		refs = "000e ?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXI@Z 0018 ?_Clamp_suffix_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIII@Z 0032 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@I@Z 003c ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@II@Z 0048 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 005a ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAPBDXZ 0062 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAPADXZ 0072 ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 007a ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 0A 99 09 98 ?? ?? ?? ?? 0B 9A 0A 99 09 98 ?? ?? ?? ?? 01 90 01 9B 0B 93 08 9A 09 9B 9A 42 0B D1 0A 9A 0B 9B D1 18 08 98 ?? ?? ?? ?? 0A 9A 00 21 08 98 ?? ?? ?? ?? 1D E0 00 22 0B 99 08 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 12 D0 09 98 ?? ?? ?? ?? 02 90 08 98 ?? ?? ?? ?? 03 90 0B 9A 02 99 0A 9B 19 44 03 98 ?? ?? ?? ?? 0B 99 08 98 ?? ?? ?? ?? 08 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_259_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z"
		size = 92
		refs = "0016 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXXZ 0020 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 003a ?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXIID@Z 0042 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z 0058 ?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2IB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 9A 12 4B 1B 68 9A 42 02 D1 04 98 ?? ?? ?? ?? 00 22 05 99 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0A D0 9D F9 18 30 05 9A 00 21 04 98 ?? ?? ?? ?? 05 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_261_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@PBDI@Z"
		size = 126
		refs = "000e ?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NPBD@Z 0020 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAPADXZ 0032 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ABV12@II@Z 0044 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA_NI_N@Z 0062 ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 006a ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 09 99 08 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0F D0 08 98 ?? ?? ?? ?? 02 90 0A 9B 09 99 02 9A 8A 1A 08 99 08 98 ?? ?? ?? ?? 03 90 03 9B 01 93 19 E0 00 22 0A 99 08 98 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 0C D0 08 98 ?? ?? ?? ?? 04 90 0A 9A 09 99 04 98 ?? ?? ?? ?? 0A 99 08 98 ?? ?? ?? ?? 08 9B 01 93 01 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_262_1 {
	meta:
		name = "?assign@?$char_traits@D@std@@SAPADPADID@Z"
		size = 40
		refs = "0012 memset"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 9A 9D F9 18 10 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_263_1 {
	meta:
		name = "?assign@?$char_traits@D@std@@SAXAADABD@Z"
		size = 26
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 9B 93 F9 00 20 02 9B 1A 70 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_264_1 {
	meta:
		name = "?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ"
		size = 86
		refs = "0018 ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0024 ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QAAPADXZ 002c ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0036 ?address@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QBAPADAAD@Z 0042 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@PADPBU_Container_base0@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 38 6B ?? ?? ?? ?? 78 60 7B 68 3B 60 38 68 ?? ?? ?? ?? B8 60 38 6B ?? ?? ?? ?? F8 60 B9 68 F8 68 ?? ?? ?? ?? 38 61 3A 68 39 69 78 6B ?? ?? ?? ?? 7B 6B 7B 61 78 69 09 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_118_303_2 {
	meta:
		name = "?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ"
		size = 86
		refs = "0018 ?_Get_data@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@D@std@@@2@XZ 0024 ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QAAPADXZ 002c ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0036 ?address@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QBAPADAAD@Z 0042 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAA@PADPBU_Container_base12@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 38 6B ?? ?? ?? ?? 78 60 7B 68 3B 60 38 68 ?? ?? ?? ?? B8 60 38 6B ?? ?? ?? ?? F8 60 B9 68 F8 68 ?? ?? ?? ?? 38 61 3A 68 39 69 78 6B ?? ?? ?? ?? 7B 6B 7B 61 78 69 09 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_55_928_1 {
	meta:
		name = "?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ"
		size = 86
		refs = "0018 ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0024 ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QAAPAGXZ 002c ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0036 ?address@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QBAPAGAAG@Z 0042 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@PAGPBU_Container_base0@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 38 6B ?? ?? ?? ?? 78 60 7B 68 3B 60 38 68 ?? ?? ?? ?? B8 60 38 6B ?? ?? ?? ?? F8 60 B9 68 F8 68 ?? ?? ?? ?? 38 61 3A 68 39 69 78 6B ?? ?? ?? ?? 7B 6B 7B 61 78 69 09 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_34_1057_2 {
	meta:
		name = "?begin@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ"
		size = 86
		refs = "0018 ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0024 ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QAAPAGXZ 002c ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0036 ?address@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QBAPAGAAG@Z 0042 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@PAGPBU_Container_base12@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 38 6B ?? ?? ?? ?? 78 60 7B 68 3B 60 38 68 ?? ?? ?? ?? B8 60 38 6B ?? ?? ?? ?? F8 60 B9 68 F8 68 ?? ?? ?? ?? 38 61 3A 68 39 69 78 6B ?? ?? ?? ?? 7B 6B 7B 61 78 69 09 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_34_1058_2 {
	meta:
		name = "?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ"
		size = 86
		refs = "0018 ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0024 ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAAPA_WXZ 002c ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0036 ?address@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QBAPA_WAA_W@Z 0042 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@PA_WPBU_Container_base12@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 38 6B ?? ?? ?? ?? 78 60 7B 68 3B 60 38 68 ?? ?? ?? ?? B8 60 38 6B ?? ?? ?? ?? F8 60 B9 68 F8 68 ?? ?? ?? ?? 38 61 3A 68 39 69 78 6B ?? ?? ?? ?? 7B 6B 7B 61 78 69 09 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_55_929_1 {
	meta:
		name = "?begin@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ"
		size = 86
		refs = "0018 ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0024 ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAAPA_WXZ 002c ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0036 ?address@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QBAPA_WAA_W@Z 0042 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@PA_WPBU_Container_base0@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 38 6B ?? ?? ?? ?? 78 60 7B 68 3B 60 38 68 ?? ?? ?? ?? B8 60 38 6B ?? ?? ?? ?? F8 60 B9 68 F8 68 ?? ?? ?? ?? 38 61 3A 68 39 69 78 6B ?? ?? ?? ?? 7B 6B 7B 61 78 69 09 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_265_1 {
	meta:
		name = "?c_str@?$_Yarn@D@std@@QBAPBDXZ"
		size = 48
		altNames = "?_C_str@?$_Yarn@D@std@@QBAPBDXZ ?_C_str@?$_Yarn@_W@std@@QBAPB_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 68 00 2B 03 D0 04 9B 1B 68 00 93 02 E0 04 9B 1B 1D 00 93 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_266_1 {
	meta:
		name = "?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAPBDXZ"
		size = 46
		refs = "0018 ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAPBDXZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 38 60 3B 68 7B 60 78 68 05 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_55_932_1 {
	meta:
		name = "?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAPBGXZ"
		size = 46
		refs = "0018 ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAPBGXZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 38 60 3B 68 7B 60 78 68 05 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_16_82_1 {
	meta:
		name = "?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAPB_WXZ"
		size = 46
		refs = "0018 ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAPB_WXZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 38 60 3B 68 7B 60 78 68 05 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_267_1 {
	meta:
		name = "?c_str@locale@std@@QBAPBDXZ"
		size = 68
		refs = "0024 ?c_str@?$_Yarn@D@std@@QBAPBDXZ 0040 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 1B 1D 1B 68 00 2B 02 D1 0A 4B 00 93 09 E0 06 9B 1B 1D 1B 68 03 F1 18 00 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_268_1 {
	meta:
		name = "?category@error_code@std@@QBAABVerror_category@2@XZ"
		size = 30
		altNames = "?category@error_condition@std@@QBAABVerror_category@2@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 1D 1B 68 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_270_1 {
	meta:
		name = "?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QAAXH_N@Z"
		size = 56
		refs = "002a ?clear@ios_base@std@@QAAXH_N@Z"
		altNames = "?clear@?$basic_ios@GU?$char_traits@G@std@@@std@@QAAXH_N@Z ?clear@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAAXH_N@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 04 9B 38 33 1B 68 00 2B 04 D1 05 9B 43 F0 04 03 00 93 01 E0 05 9B 00 93 9D F8 18 20 00 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_271_1 {
	meta:
		name = "?clear@ios_base@std@@QAAXH@Z"
		size = 26
		refs = "000e ?clear@ios_base@std@@QAAXH_N@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 00 22 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_37_388_2 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z"
		size = 26
		refs = "000e ?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXID@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 00 22 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_1383_2 {
	meta:
		name = "?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z"
		size = 26
		refs = "000e ?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXIG@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 00 22 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_1385_2 {
	meta:
		name = "?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z"
		size = 26
		refs = "000e ?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI_W@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 00 22 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_272_1 {
	meta:
		name = "?clear@ios_base@std@@QAAXH_N@Z"
		size = 220
		refs = "0038 _CxxThrowException 0058 ?make_error_code@std@@YA?AVerror_code@1@W4io_errc@1@@Z 0064 ??0failure@ios_base@std@@QAA@PBDABVerror_code@2@@Z 00cc _TI5?AVfailure@ios_base@std@@ 00d0 ??_C@_0BF@OOHOMBOF@ios_base?3?3eofbit?5set?$AA@ 00d4 ??_C@_0BG@FMKFHCIL@ios_base?3?3failbit?5set?$AA@ 00d8 ??_C@_0BF@PHHKMMFD@ios_base?3?3badbit?5set?$AA@"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 9C B0 1F 9B 03 F0 17 02 1E 9B 0C 33 1A 60 1E 9B 03 F1 0C 02 1E 9B 10 33 12 68 1B 68 13 40 00 2B 00 D1 4A E0 9D F8 80 30 00 2B 04 D0 00 21 00 20 ?? ?? ?? ?? 41 E0 1E 9B 03 F1 0C 02 1E 9B 10 33 12 68 1B 68 13 40 13 F0 04 0F 0E D0 01 21 04 A8 ?? ?? ?? ?? 00 90 00 9A 1D 49 0A A8 ?? ?? ?? ?? 18 49 0A A8 ?? ?? ?? ?? 27 E0 1E 9B 03 F1 0C 02 1E 9B 10 33 12 68 1B 68 13 40 13 F0 02 0F 0E D0 01 21 06 A8 ?? ?? ?? ?? 01 90 01 9A 0F 49 10 A8 ?? ?? ?? ?? 0B 49 10 A8 ?? ?? ?? ?? 0D E0 01 21 08 A8 ?? ?? ?? ?? 02 90 02 9A 07 49 16 A8 ?? ?? ?? ?? 04 49 16 A8 ?? ?? ?? ?? 1C B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_273_1 {
	meta:
		name = "?close@?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAAPAV12@XZ"
		size = 100
		refs = "0020 ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAA_NXZ 003a fclose 0050 ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 01 93 06 9B 4C 33 1B 68 00 2B 02 D1 00 23 01 93 15 E0 06 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 01 D1 00 23 01 93 06 9B 4C 33 18 68 ?? ?? ?? ?? 02 90 02 9B 00 2B 01 D0 00 23 01 93 02 22 00 21 06 98 ?? ?? ?? ?? 01 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_84_312_2 {
	meta:
		name = "?close@?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAAPAV12@XZ"
		size = 100
		refs = "0020 ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAA_NXZ 003a fclose 0050 ?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 01 93 06 9B 4C 33 1B 68 00 2B 02 D1 00 23 01 93 15 E0 06 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 01 D1 00 23 01 93 06 9B 4C 33 18 68 ?? ?? ?? ?? 02 90 02 9B 00 2B 01 D0 00 23 01 93 02 22 00 21 06 98 ?? ?? ?? ?? 01 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_30_312_2 {
	meta:
		name = "?close@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAAPAV12@XZ"
		size = 100
		refs = "0020 ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAA_NXZ 003a fclose 0050 ?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 01 93 06 9B 4C 33 1B 68 00 2B 02 D1 00 23 01 93 15 E0 06 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 01 D1 00 23 01 93 06 9B 4C 33 18 68 ?? ?? ?? ?? 02 90 02 9B 00 2B 01 D0 00 23 01 93 02 22 00 21 06 98 ?? ?? ?? ?? 01 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_274_1 {
	meta:
		name = "?copy@?$char_traits@D@std@@SAPADPADPBDI@Z"
		size = 54
		refs = "001c memcpy"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 08 9B 00 2B 02 D1 06 9B 00 93 07 E0 08 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_112_337_3 {
	meta:
		name = "?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z"
		size = 54
		refs = "001c wmemcpy"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 08 9B 00 2B 02 D1 06 9B 00 93 07 E0 08 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_30_314_2 {
	meta:
		name = "?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z"
		size = 54
		refs = "001c wmemcpy"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 08 9B 00 2B 02 D1 06 9B 00 93 07 E0 08 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_27_393_3 {
	meta:
		name = "?move@?$char_traits@D@std@@SAPADPADPBDI@Z"
		size = 54
		refs = "001c memmove"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 08 9B 00 2B 02 D1 06 9B 00 93 07 E0 08 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_34_1345_2 {
	meta:
		name = "?move@?$char_traits@G@std@@SAPAGPAGPBGI@Z"
		size = 54
		refs = "001c wmemmove"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 08 9B 00 2B 02 D1 06 9B 00 93 07 E0 08 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_65_145_3 {
	meta:
		name = "?move@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z"
		size = 54
		refs = "001c wmemmove"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 08 9B 00 2B 02 D1 06 9B 00 93 07 E0 08 9A 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_275_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAAXPADI@Z"
		size = 26
		refs = "000e ?deallocate@?$allocator@D@std@@QAAXPADI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 04 9A 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_487_1 {
	meta:
		name = "?_Addfac@_Locimp@locale@std@@AAAXPAVfacet@23@I@Z"
		size = 26
		refs = "000e ?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 04 9A 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_119_0_2 {
	meta:
		name = "?_Debug_message@std@@YAXPBG0I@Z"
		size = 26
		refs = "000e ?_Debug_message@std@@YAXPB_W0I@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 04 9A 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_114_131_3 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@QAAXPAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@2@I@Z"
		size = 26
		refs = "000e ?deallocate@?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@QBAXPAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@I@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 04 9A 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_34_1072_2 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAXPAGI@Z"
		size = 26
		refs = "000e ?deallocate@?$allocator@G@std@@QAAXPAGI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 04 9A 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_37_339_3 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAAXPAU_Container_proxy@2@I@Z"
		size = 26
		refs = "000e ?deallocate@?$allocator@U_Container_proxy@std@@@std@@QAAXPAU_Container_proxy@2@I@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 04 9A 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_84_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAXPA_WI@Z"
		size = 26
		refs = "000e ?deallocate@?$allocator@_W@std@@QAAXPA_WI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 04 9A 03 99 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_276_1 {
	meta:
		name = "?deallocate@?$allocator@D@std@@QAAXPADI@Z"
		size = 26
		refs = "000e ?_Deallocate@std@@YAXPAXII@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 01 22 04 99 03 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_277_1 {
	meta:
		name = "?default_error_condition@error_category@std@@UBA?AVerror_condition@2@H@Z"
		size = 36
		refs = "0010 ??0error_condition@std@@QAA@HABVerror_category@1@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 04 9A 06 99 05 98 ?? ?? ?? ?? 05 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_279_1 {
	meta:
		name = "?do_always_noconv@codecvt_base@std@@MBA_NXZ"
		size = 30
		altNames = "??$?9DD@std@@YA_NABV?$allocator@D@0@0@Z ??$?9GG@std@@YA_NABV?$allocator@G@0@0@Z ??$?9_W_W@std@@YA_NABV?$allocator@_W@0@0@Z ?do_always_noconv@?$codecvt@GDU_Mbstatet@@@std@@MBA_NXZ ?do_always_noconv@?$codecvt@_WDU_Mbstatet@@@std@@MBA_NXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 00 23 8D F8 00 30 9D F8 00 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_280_1 {
	meta:
		name = "?do_encoding@codecvt_base@std@@MBAHXZ"
		size = 26
		altNames = "?do_max_length@codecvt_base@std@@MBAHXZ ?length@charNode@@UBAHXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 01 23 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_281_1 {
	meta:
		name = "?do_in@?$codecvt@DDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z"
		size = 104
		altNames = "?do_out@?$codecvt@DDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 08 9B 1A 60 09 9A 0B 9B 1A 60 03 23 00 93 1F E0 1E E0 09 E0 08 9B 1B 68 5A 1C 08 9B 1A 60 0B 9B 1B 68 5A 1C 0B 9B 1A 60 08 9B 1A 68 07 9B 9A 42 0C D0 0B 9B 1A 68 0A 9B 9A 42 07 D0 08 9B 19 68 0B 9B 1A 68 91 F9 00 30 13 70 E3 E7 00 23 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_282_1 {
	meta:
		name = "?do_length@?$codecvt@DDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1I@Z"
		size = 52
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 07 9A 06 9B D2 1A 08 9B 93 42 02 D2 08 9B 00 93 03 E0 07 9A 06 9B D3 1A 00 93 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_284_1 {
	meta:
		name = "?do_narrow@?$ctype@D@std@@MBADDD@Z"
		size = 32
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 9D F9 14 30 8D F8 00 30 9D F9 00 00 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_285_1 {
	meta:
		name = "?do_narrow@?$ctype@D@std@@MBAPBDPBD0DPAD@Z"
		size = 40
		refs = "0014 memcpy"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 05 9B D2 1A 05 99 08 98 ?? ?? ?? ?? 06 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_287_1 {
	meta:
		name = "?do_tolower@?$ctype@D@std@@MBADD@Z"
		size = 50
		refs = "0016 _Tolower"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 03 F1 08 01 9D F9 14 30 D8 B2 ?? ?? ?? ?? 00 90 00 9B 5B B2 8D F8 04 30 9D F9 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_68_330_2 {
	meta:
		name = "?do_toupper@?$ctype@D@std@@MBADD@Z"
		size = 50
		refs = "0016 _Toupper"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 03 F1 08 01 9D F9 14 30 D8 B2 ?? ?? ?? ?? 00 90 00 9B 5B B2 8D F8 04 30 9D F9 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_288_1 {
	meta:
		name = "?do_tolower@?$ctype@D@std@@MBAPBDPADPBD@Z"
		size = 72
		refs = "0028 _Tolower"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 02 E0 05 9B 5B 1C 05 93 05 9A 06 9B 9A 42 0E D0 04 9B 03 F1 08 01 05 9B 93 F9 00 30 D8 B2 ?? ?? ?? ?? 00 90 00 9B 5A B2 05 9B 1A 70 E9 E7 05 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_290_1 {
	meta:
		name = "?do_toupper@?$ctype@D@std@@MBAPBDPADPBD@Z"
		size = 72
		refs = "0028 _Toupper"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 02 E0 05 9B 5B 1C 05 93 05 9A 06 9B 9A 42 0E D0 04 9B 03 F1 08 01 05 9B 93 F9 00 30 D8 B2 ?? ?? ?? ?? 00 90 00 9B 5A B2 05 9B 1A 70 E9 E7 05 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_291_1 {
	meta:
		name = "?do_unshift@?$codecvt@DDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PAD1AAPAD@Z"
		size = 32
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 08 9B 1A 60 00 23 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_292_1 {
	meta:
		name = "?do_widen@?$ctype@D@std@@MBADD@Z"
		size = 32
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 9D F9 14 30 8D F8 00 30 9D F9 00 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_293_1 {
	meta:
		name = "?do_widen@?$ctype@D@std@@MBAPBDPBD0PAD@Z"
		size = 40
		refs = "0014 memcpy"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 05 9B D2 1A 05 99 07 98 ?? ?? ?? ?? 06 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_294_1 {
	meta:
		name = "?eback@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ"
		size = 32
		altNames = "?eback@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ ?eback@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 0C 33 1B 68 1B 68 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_295_1 {
	meta:
		name = "?egptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ"
		size = 42
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1C 33 1A 68 04 9B 2C 33 1B 68 12 68 1B 68 13 44 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_296_1 {
	meta:
		name = "?empty@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBA_NXZ"
		size = 58
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 01 90 01 9B 1B 68 00 2B 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_1151_1 {
	meta:
		name = "?empty@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBA_NXZ"
		size = 58
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 01 90 01 9B 1B 68 00 2B 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_86_1 {
	meta:
		name = "?empty@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBA_NXZ"
		size = 58
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 01 90 01 9B 1B 68 00 2B 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_297_1 {
	meta:
		name = "?eof@?$char_traits@D@std@@SAHXZ"
		size = 22
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 6F F0 00 03 00 93 00 98 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_10_298_1 {
	meta:
		name = "?epptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ"
		size = 42
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 20 33 1A 68 04 9B 30 33 1B 68 12 68 1B 68 13 44 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_299_1 {
	meta:
		name = "?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z"
		size = 54
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1A 68 05 9B 1B 68 9A 42 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_300_1 {
	meta:
		name = "?equivalent@error_category@std@@UBA_NABVerror_code@2@H@Z"
		size = 86
		refs = "000c ?category@error_code@std@@QBAABVerror_category@2@XZ 0016 ??8error_category@std@@QBA_NABV01@@Z 0028 ?value@error_code@std@@QBAHXZ"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 09 98 ?? ?? ?? ?? 02 90 02 99 08 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0A D0 09 98 ?? ?? ?? ?? 03 90 03 9A 0A 9B 9A 42 02 D1 01 23 01 93 01 E0 00 23 01 93 01 9B DB B2 8D F8 10 30 9D F8 10 00 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_301_1 {
	meta:
		name = "?equivalent@error_category@std@@UBA_NHABVerror_condition@2@@Z"
		size = 80
		refs = "001e _guard_check_icall 0032 ??8std@@YA_NABVerror_condition@0@0@Z"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B 87 B0 0D 9E 04 AD 0C 9B 1B 68 0C 33 0C 9C 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 29 46 32 46 98 47 02 90 0E 99 02 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 8D F8 0C 30 9D F8 0C 00 07 B0 BD E8 70 08 5D F8 14 FB }
	condition:
		$1
}

rule file_10_302_1 {
	meta:
		name = "?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@I@Z"
		size = 42
		refs = "000e ?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXI@Z 0016 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_1163_1 {
	meta:
		name = "?erase@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@I@Z"
		size = 42
		refs = "000e ?_Check_offset@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXI@Z 0016 ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_88_1 {
	meta:
		name = "?erase@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I@Z"
		size = 42
		refs = "000e ?_Check_offset@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXI@Z 0016 ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_303_1 {
	meta:
		name = "?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@II@Z"
		size = 132
		refs = "000e ?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAXI@Z 0014 ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAAAIXZ 002c ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAXI@Z 003a ?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAAPADXZ 0068 ?move@?$char_traits@D@std@@SAPADPADPBDI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 09 99 08 98 ?? ?? ?? ?? 08 98 ?? ?? ?? ?? 02 90 02 9B 1A 68 09 9B D2 1A 0A 9B 9A 42 04 D8 09 99 08 98 ?? ?? ?? ?? 20 E0 0A 9B 00 2B 1D D9 08 98 ?? ?? ?? ?? 03 90 03 9A 09 9B 13 44 00 93 08 98 ?? ?? ?? ?? 04 90 04 9B 1A 68 0A 9B D3 1A 01 93 01 9A 09 9B D2 1A 00 99 0A 9B 19 44 00 98 ?? ?? ?? ?? 01 99 08 98 ?? ?? ?? ?? 08 9B 05 93 05 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_304_1 {
	meta:
		name = "?gbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXH@Z"
		size = 56
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 2C 33 1B 68 1A 68 03 9B D2 1A 02 9B 2C 33 1B 68 1A 60 02 9B 1C 33 1B 68 1A 68 03 9B 1A 44 02 9B 1C 33 1B 68 1A 60 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_305_1 {
	meta:
		name = "?getloc@ios_base@std@@QBA?AVlocale@2@XZ"
		size = 52
		refs = "0016 ??0locale@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 00 23 00 93 06 9B 30 33 19 68 07 98 ?? ?? ?? ?? 02 90 00 9B 43 F0 01 03 00 93 07 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_306_1 {
	meta:
		name = "?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ"
		size = 32
		altNames = "?gptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ ?gptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1C 33 1B 68 1B 68 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_307_1 {
	meta:
		name = "?imbue@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAAXABVlocale@2@@Z"
		size = 36
		refs = "000c ??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z 0016 ?_Initcvt@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAAXPBV?$codecvt@DDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_84_355_2 {
	meta:
		name = "?imbue@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAAXABVlocale@2@@Z"
		size = 36
		refs = "000c ??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z 0016 ?_Initcvt@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPBV?$codecvt@GDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_30_355_2 {
	meta:
		name = "?imbue@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAAXABVlocale@2@@Z"
		size = 36
		refs = "000c ??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z 0016 ?_Initcvt@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPBV?$codecvt@_WDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_309_1 {
	meta:
		name = "?in@?$codecvt@DDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z"
		size = 84
		refs = "0032 _guard_check_icall"
		altNames = "?in@?$codecvt@GDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PBD1AAPBDPAG3AAPAG@Z ?in@?$codecvt@_WDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PBD1AAPBDPA_W3AAPA_W@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 49 0D F1 14 0B 87 B0 15 9B 03 93 14 9B 02 93 13 9B 01 93 12 9B 00 93 DD F8 44 80 10 9F 0F 9E 0E 9B 1B 68 18 33 0E 9D 1B 68 04 93 04 98 ?? ?? ?? ?? 04 9C 28 46 31 46 3A 46 43 46 A0 47 05 90 05 9B 06 93 06 98 07 B0 BD E8 F0 09 5D F8 14 FB }
	condition:
		$1
}

rule file_10_310_1 {
	meta:
		name = "?init@?$basic_ios@DU?$char_traits@D@std@@@std@@IAAXPAV?$basic_streambuf@DU?$char_traits@D@std@@@2@_N@Z"
		size = 104
		refs = "000c ?_Init@ios_base@std@@IAAXXZ 0028 ?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBADD@Z 004c ?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QAAXH_N@Z 005a ?_Addstd@ios_base@std@@SAXPAV12@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 03 F1 38 02 05 9B 13 60 04 9B 03 F1 3C 02 00 23 13 60 20 21 04 98 ?? ?? ?? ?? 8D F8 00 00 04 9B 03 F1 40 02 9D F9 00 30 13 70 04 9B 38 33 1B 68 00 2B 04 D1 00 22 04 21 04 98 ?? ?? ?? ?? 9D F8 18 30 00 2B 02 D0 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_311_1 {
	meta:
		name = "?iostream_category@std@@YAABVerror_category@1@XZ"
		size = 38
		refs = "0014 ??$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ"
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 ?? ?? ?? ?? 38 60 3B 68 7B 60 78 68 05 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_51_160_1 {
	meta:
		name = "?generic_category@std@@YAABVerror_category@1@XZ"
		size = 38
		refs = "0014 ??$_Immortalize@V_Generic_error_category@std@@@std@@YAAAV_Generic_error_category@0@XZ"
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 ?? ?? ?? ?? 38 60 3B 68 7B 60 78 68 05 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_51_180_1 {
	meta:
		name = "?system_category@std@@YAABVerror_category@1@XZ"
		size = 38
		refs = "0014 ??$_Immortalize@V_System_error_category@std@@@std@@YAAAV_System_error_category@0@XZ"
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 ?? ?? ?? ?? 38 60 3B 68 7B 60 78 68 05 B0 BD E8 80 88 }
	condition:
		$1
}

rule file_10_312_1 {
	meta:
		name = "?length@?$char_traits@D@std@@SAIPBD@Z"
		size = 54
		refs = "001c strlen"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 93 F9 00 30 00 2B 02 D1 00 23 00 93 05 E0 06 98 ?? ?? ?? ?? 01 90 01 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_313_1 {
	meta:
		name = "?make_error_code@std@@YA?AVerror_code@1@W4io_errc@1@@Z"
		size = 42
		refs = "000a ?iostream_category@std@@YAABVerror_category@1@XZ 0016 ??0error_code@std@@QAA@HABVerror_category@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? 00 90 00 9A 05 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_315_1 {
	meta:
		name = "?max_size@?$allocator@D@std@@QBAIXZ"
		size = 28
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 6F F0 00 03 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_317_1 {
	meta:
		name = "?max_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ"
		size = 68
		refs = "000c ?_Getal@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABU?$_Wrap_alloc@V?$allocator@D@std@@@2@XZ 0018 ?max_size@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QBAIU_Nil@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 98 ?? ?? ?? ?? 03 90 9D F8 00 10 03 98 ?? ?? ?? ?? 04 90 04 9B 01 93 01 9B 01 2B 02 D8 01 23 02 93 02 E0 01 9B 5B 1E 02 93 02 9B 05 93 05 98 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_1205_1 {
	meta:
		name = "?max_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAIXZ"
		size = 68
		refs = "000c ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0018 ?max_size@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QBAIU_Nil@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 98 ?? ?? ?? ?? 03 90 9D F8 00 10 03 98 ?? ?? ?? ?? 04 90 04 9B 01 93 01 9B 01 2B 02 D8 01 23 02 93 02 E0 01 9B 5B 1E 02 93 02 9B 05 93 05 98 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_94_1 {
	meta:
		name = "?max_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAIXZ"
		size = 68
		refs = "000c ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0018 ?max_size@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QBAIU_Nil@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 98 ?? ?? ?? ?? 03 90 9D F8 00 10 03 98 ?? ?? ?? ?? 04 90 04 9B 01 93 01 9B 01 2B 02 D8 01 23 02 93 02 E0 01 9B 5B 1E 02 93 02 9B 05 93 05 98 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_318_1 {
	meta:
		name = "?message@_Generic_error_category@std@@UBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
		size = 56
		refs = "0010 ?_Syserror_map@std@@YAPBDH@Z 001a ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 00 23 00 93 08 98 ?? ?? ?? ?? 01 90 01 99 07 98 ?? ?? ?? ?? 03 90 00 9B 43 F0 01 03 00 93 07 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_319_1 {
	meta:
		name = "?message@_Iostream_error_category@std@@UBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
		size = 88
		refs = "0018 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@PBD@Z 0034 ?message@_Generic_error_category@std@@UBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z 0054 ??_C@_0BG@PADBLCHM@iostream?5stream?5error?$AA@"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 00 23 00 93 08 9B 01 2B 0C D1 0F 49 07 98 ?? ?? ?? ?? 02 90 00 9B 43 F0 01 03 00 93 07 9B 01 93 0C E0 0B E0 08 9A 07 99 06 98 ?? ?? ?? ?? 03 90 00 9B 43 F0 01 03 00 93 07 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_320_1 {
	meta:
		name = "?message@error_code@std@@QBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 94
		refs = "0012 ?value@error_code@std@@QBAHXZ 001a ?category@error_code@std@@QBAABVerror_category@2@XZ 0036 _guard_check_icall"
	strings:
		$1 = { 03 B4 2D E9 70 48 0D F1 0C 0B 87 B0 00 23 02 93 0C 98 ?? ?? ?? ?? 04 90 0C 98 ?? ?? ?? ?? 03 90 03 9B 00 93 04 9E 0D 9D 00 9C 00 9B 1B 68 08 33 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 29 46 32 46 98 47 06 90 02 9B 43 F0 01 03 02 93 0D 9B 05 93 05 98 07 B0 BD E8 70 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_322_1 {
	meta:
		name = "?name@_Generic_error_category@std@@UBAPBDXZ"
		size = 32
		refs = "001c ??_C@_07DCLBNMLN@generic?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 4B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_189_1 {
	meta:
		name = "?_Getfalse@_Locinfo@std@@QBAPBDXZ"
		size = 32
		refs = "001c ??_C@_05LAPONLG@false?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 4B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_724_1 {
	meta:
		name = "?_Gettrue@_Locinfo@std@@QBAPBDXZ"
		size = 32
		refs = "001c ??_C@_04LOAJBDKD@true?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 4B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_364_2 {
	meta:
		name = "?name@_Iostream_error_category@std@@UBAPBDXZ"
		size = 32
		refs = "001c ??_C@_08LLGCOLLL@iostream?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 4B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_202_3 {
	meta:
		name = "?name@_System_error_category@std@@UBAPBDXZ"
		size = 32
		refs = "001c ??_C@_06FHFOAHML@system?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 4B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_53_3 {
	meta:
		name = "?what@bad_function_call@std@@UBAPBDXZ"
		size = 32
		refs = "001c ??_C@_0BC@DPJNKNAF@bad?5function?5call?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 4B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_324_1 {
	meta:
		name = "?not_eof@?$char_traits@D@std@@SAHABH@Z"
		size = 76
		refs = "000a ?eof@?$char_traits@D@std@@SAHXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 ?? ?? ?? ?? 02 90 08 9B 1A 68 02 9B 9A 42 03 D0 08 9B 1B 68 01 93 0C E0 ?? ?? ?? ?? 03 90 03 9B 00 2B 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B 01 93 01 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_325_1 {
	meta:
		name = "?out@?$codecvt@DDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z"
		size = 84
		refs = "0032 _guard_check_icall"
		altNames = "?out@?$codecvt@GDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PBG1AAPBGPAD3AAPAD@Z ?out@?$codecvt@_WDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PB_W1AAPB_WPAD3AAPAD@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 49 0D F1 14 0B 87 B0 15 9B 03 93 14 9B 02 93 13 9B 01 93 12 9B 00 93 DD F8 44 80 10 9F 0F 9E 0E 9B 1B 68 1C 33 0E 9D 1B 68 04 93 04 98 ?? ?? ?? ?? 04 9C 28 46 31 46 3A 46 43 46 A0 47 05 90 05 9B 06 93 06 98 07 B0 BD E8 F0 09 5D F8 14 FB }
	condition:
		$1
}

rule file_10_326_1 {
	meta:
		name = "?overflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAAHH@Z"
		size = 786
		refs = "000a __security_push_cookie 001c ?eof@?$char_traits@D@std@@SAHXZ 002e ?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z 003e ?not_eof@?$char_traits@D@std@@SAHABH@Z 0050 ?pptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 006a ?epptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 007c ?to_char_type@?$char_traits@D@std@@SADABH@Z 0086 ?_Pninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAPADXZ 00ba ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AAAXXZ 00e0 ??$_Fputc@D@std@@YA_NDPAU_iobuf@@@Z 0124 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 0134 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 013c ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAAADXZ 0146 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ 018e ?out@?$codecvt@DDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z 01f6 fwrite 0212 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 026c ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 0306 __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B ?? ?? ?? ?? B6 B0 6F 46 84 B0 6F F0 01 03 C7 E9 2E 33 ?? ?? ?? ?? 38 62 3B 6A 7B 62 17 F1 EC 01 17 F1 24 00 ?? ?? ?? ?? 38 72 3B 7A 00 2B 08 D0 17 F1 EC 00 ?? ?? ?? ?? B8 62 BB 6A 7B 60 5B E1 34 E0 D7 F8 E8 00 ?? ?? ?? ?? F8 62 FB 6A 00 2B 20 D0 D7 F8 E8 00 ?? ?? ?? ?? 38 63 D7 F8 E8 00 ?? ?? ?? ?? 78 63 3A 6B 7B 6B 9A 42 12 D2 17 F1 EC 00 ?? ?? ?? ?? 78 72 D7 F8 E8 00 ?? ?? ?? ?? B8 63 97 F9 09 20 BB 6B 1A 70 D7 F8 EC 30 7B 60 32 E1 0B E0 D7 F8 E8 30 4C 33 1B 68 00 2B 05 D1 ?? ?? ?? ?? F8 63 FB 6B 7B 60 25 E1 D7 F8 E8 00 ?? ?? ?? ?? D7 F8 E8 30 38 33 1B 68 00 2B 1D D1 17 F1 EC 00 ?? ?? ?? ?? B8 72 D7 F8 E8 30 4C 33 19 68 97 F9 0A 00 ?? ?? ?? ?? F8 72 FB 7A 00 2B 03 D0 D7 F8 EC 30 BB 61 04 E0 ?? ?? ?? ?? 38 64 3B 6C BB 61 BB 69 7B 60 FE E0 FD E0 08 23 C7 F8 A0 30 17 F1 EC 00 ?? ?? ?? ?? 38 73 97 F9 0C 30 3B 70 00 22 08 21 17 F1 C0 00 ?? ?? ?? ?? C7 F8 A4 00 17 F1 A8 01 17 F1 C0 00 ?? ?? ?? ?? 78 64 78 6C ?? ?? ?? ?? F8 64 17 F1 C0 00 ?? ?? ?? ?? 38 65 17 F1 AC 01 17 F1 C0 00 ?? ?? ?? ?? B8 64 B8 6C ?? ?? ?? ?? 78 65 17 F1 60 03 03 93 FA 6C 3B 6D 13 44 02 93 7B 6D 01 93 17 F1 7C 03 00 93 3B 46 5B 1C 3A 46 D7 F8 E8 10 40 31 D7 F8 E8 00 38 30 00 68 ?? ?? ?? ?? B8 65 BB 6D 7B 61 7B 69 00 2B C0 F2 9C 80 7B 69 01 2B 03 DD 7B 69 03 2B 73 D0 94 E0 17 F1 B0 01 17 F1 C0 00 ?? ?? ?? ?? F8 65 F8 6D ?? ?? ?? ?? 78 66 3A 6E 7B 6E D3 1A 3B 61 3B 69 00 2B 24 D9 17 F1 B4 01 17 F1 C0 00 ?? ?? ?? ?? B8 66 B8 6E ?? ?? ?? ?? F8 66 D7 F8 E8 30 4C 33 1B 68 3A 69 01 21 F8 6E ?? ?? ?? ?? 38 67 3A 69 3B 6F 9A 42 0B D0 ?? ?? ?? ?? 78 67 7B 6F BB 67 17 F1 C0 00 ?? ?? ?? ?? BB 6F 7B 60 72 E0 D7 F8 E8 30 03 F1 3D 02 01 23 13 70 FA 6F 3B 46 9A 42 0B D0 D7 F8 EC 30 C7 F8 80 30 17 F1 C0 00 ?? ?? ?? ?? D7 F8 80 30 7B 60 5C E0 3B 69 00 2B 00 D9 20 E0 17 F1 C0 00 ?? ?? ?? ?? C7 F8 84 00 D7 F8 84 30 20 2B 06 D2 00 22 08 21 17 F1 C0 00 ?? ?? ?? ?? 0F E0 ?? ?? ?? ?? C7 F8 88 00 D7 F8 88 30 C7 F8 8C 30 17 F1 C0 00 ?? ?? ?? ?? D7 F8 8C 30 7B 60 37 E0 31 E0 D7 F8 E8 30 4C 33 19 68 97 F9 00 00 ?? ?? ?? ?? 78 73 7B 7B 00 2B 03 D0 D7 F8 EC 30 FB 61 06 E0 ?? ?? ?? ?? C7 F8 90 00 D7 F8 90 30 FB 61 FB 69 C7 F8 94 30 17 F1 C0 00 ?? ?? ?? ?? D7 F8 94 30 7B 60 14 E0 ?? ?? ?? ?? C7 F8 98 00 D7 F8 98 30 C7 F8 9C 30 17 F1 C0 00 ?? ?? ?? ?? D7 F8 9C 30 7B 60 04 E0 18 E7 17 F1 C0 00 ?? ?? ?? ?? 78 68 3A B0 ?? ?? ?? ?? BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_328_1 {
	meta:
		name = "?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAAHH@Z"
		size = 32
		refs = "000a ?eof@?$char_traits@D@std@@SAHXZ"
		altNames = "?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAAHH@Z ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAAHXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_659_1 {
	meta:
		name = "?_Getdateorder@_Locinfo@std@@QBAHXZ"
		size = 32
		refs = "000a _Getdateorder"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_695_1 {
	meta:
		name = "?_Getlconv@_Locinfo@std@@QBAPBUlconv@@XZ"
		size = 32
		refs = "000a localeconv"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_329_1 {
	meta:
		name = "?pbackfail@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAAHH@Z"
		size = 334
		refs = "000c ?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 001a ?eback@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 0030 ?eof@?$char_traits@D@std@@SAHXZ 003e ?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z 005a ?to_int_type@?$char_traits@D@std@@SAHABD@Z 007a ?_Gndec@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAPADXZ 0080 ?not_eof@?$char_traits@D@std@@SAHABH@Z 00d0 ?to_char_type@?$char_traits@D@std@@SADABH@Z 00e8 ??$_Ungetc@D@std@@YA_NABDPAU_iobuf@@@Z 012c ?_Set_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 92 B0 14 98 ?? ?? ?? ?? 03 90 03 9B 00 2B 3A D0 14 98 ?? ?? ?? ?? 04 90 14 98 ?? ?? ?? ?? 05 90 04 9A 05 9B 9A 42 2E D2 ?? ?? ?? ?? 06 90 06 9B 07 93 15 A9 07 A8 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 14 D1 14 98 ?? ?? ?? ?? 08 90 08 9B 58 1E ?? ?? ?? ?? 09 90 09 9B 0A 93 15 A9 0A A8 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 0A D0 14 98 ?? ?? ?? ?? 15 A8 ?? ?? ?? ?? 0B 90 0B 9B 02 93 5A E0 59 E0 14 9B 4C 33 1B 68 00 2B 0E D0 ?? ?? ?? ?? 0C 90 0C 9B 0D 93 15 A9 0D A8 ?? ?? ?? ?? 8D F8 02 00 9D F8 02 30 00 2B 06 D0 ?? ?? ?? ?? 0E 90 0E 9B 02 93 3F E0 3E E0 14 9B 38 33 1B 68 00 2B 18 D1 15 A8 ?? ?? ?? ?? 8D F8 03 00 9D F9 03 30 8D F8 04 30 14 9B 4C 33 19 68 01 A8 ?? ?? ?? ?? 8D F8 05 00 9D F8 05 30 00 2B 03 D0 15 9B 02 93 21 E0 20 E0 14 98 ?? ?? ?? ?? 0F 90 14 9B 03 F1 3C 02 0F 9B 93 42 11 D0 15 A8 ?? ?? ?? ?? 8D F8 06 00 14 9B 03 F1 3C 02 9D F9 06 30 13 70 14 98 ?? ?? ?? ?? 15 9B 02 93 05 E0 04 E0 ?? ?? ?? ?? 10 90 10 9B 02 93 02 98 12 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_331_1 {
	meta:
		name = "?pbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXH@Z"
		size = 56
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 30 33 1B 68 1A 68 03 9B D2 1A 02 9B 30 33 1B 68 1A 60 02 9B 20 33 1B 68 1A 68 03 9B 1A 44 02 9B 20 33 1B 68 1A 60 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_333_1 {
	meta:
		name = "?pptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ"
		size = 32
		altNames = "?pptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ ?pptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 20 33 1B 68 1B 68 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_334_1 {
	meta:
		name = "?rdstate@ios_base@std@@QBAHXZ"
		size = 30
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 0C 33 1B 68 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_335_1 {
	meta:
		name = "?seekoff@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 232
		refs = "000c ?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 004a ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAA_NXZ 0080 _fseeki64 0094 fgetpos 00aa ??0?$fpos@U_Mbstatet@@@std@@QAA@_J@Z 00b6 ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AAAXXZ 00d0 ??0?$fpos@U_Mbstatet@@@std@@QAA@U_Mbstatet@@_J@Z 00e4 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8C B0 0E 98 ?? ?? ?? ?? 04 90 0E 9B 03 F1 3C 02 04 9B 93 42 0F D1 12 9B 01 2B 0C D1 0E 9B 38 33 1B 68 00 2B 07 D1 10 9A 11 99 00 23 52 1E 61 EB 03 03 10 92 11 93 0E 9B 4C 33 1B 68 00 2B 2B D0 0E 98 ?? ?? ?? ?? 8D F8 08 00 9D F8 08 30 00 2B 22 D0 10 9B 08 93 11 9B 09 93 09 9A 08 9B 13 43 00 2B 02 D1 12 9B 01 2B 0C D0 12 9B 00 93 10 9A 11 9B 0E 99 4C 31 08 68 ?? ?? ?? ?? 05 90 05 9B 00 2B 09 D1 0A A9 0E 9B 4C 33 18 68 ?? ?? ?? ?? 06 90 06 9B 00 2B 09 D0 10 4B 1A 68 0F 4B 5B 68 0F 98 ?? ?? ?? ?? 0F 9B 03 93 11 E0 0E 98 ?? ?? ?? ?? 0A 9B 00 93 0B 9B 01 93 0E 9B 40 33 07 93 07 9B 19 68 5A 68 0F 98 ?? ?? ?? ?? 0F 9B 03 93 03 98 0C B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_336_1 {
	meta:
		name = "?seekoff@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 44
		refs = "0014 ??0?$fpos@U_Mbstatet@@@std@@QAA@_J@Z 0028 ?_BADOFF@std@@3_JB"
		altNames = "?seekoff@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z ?seekoff@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z ?seekpos@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z ?seekpos@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z ?seekpos@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 07 4B 1A 68 06 4B 5B 68 05 98 ?? ?? ?? ?? 05 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_337_1 {
	meta:
		name = "?seekpos@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 264
		refs = "000c ?seekpos@?$fpos@U_Mbstatet@@@std@@QBA_JXZ 001e ??B?$fpos@U_Mbstatet@@@std@@QBA_JXZ 0044 ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAA_NXZ 005c fsetpos 0088 _fseeki64 009c fgetpos 00b2 ??0?$fpos@U_Mbstatet@@@std@@QAA@_J@Z 00c0 ?state@?$fpos@U_Mbstatet@@@std@@QBA?AU_Mbstatet@@XZ 00d0 memcpy 00d6 ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AAAXXZ 00f0 ??0?$fpos@U_Mbstatet@@@std@@QAA@U_Mbstatet@@_J@Z 0104 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 96 B0 1A A8 ?? ?? ?? ?? 0F 91 0E 90 0E 9B 0A 93 0F 9B 0B 93 1A A8 ?? ?? ?? ?? 11 91 10 90 10 98 11 99 0A 9A 0B 9B 82 1A 61 EB 03 03 0C 92 0D 93 18 9B 4C 33 1B 68 00 2B 32 D0 18 98 ?? ?? ?? ?? 8D F8 08 00 9D F8 08 30 00 2B 29 D0 0A A9 18 9B 4C 33 18 68 ?? ?? ?? ?? 04 90 04 9B 00 2B 1F D1 0C 9B 12 93 0D 9B 13 93 13 9A 12 9B 13 43 00 2B 0C D0 01 23 00 93 0C 9A 0D 9B 18 99 4C 31 08 68 ?? ?? ?? ?? 05 90 05 9B 00 2B 09 D1 0A A9 18 9B 4C 33 18 68 ?? ?? ?? ?? 06 90 06 9B 00 2B 09 D0 16 4B 1A 68 15 4B 5B 68 19 98 ?? ?? ?? ?? 19 9B 03 93 1D E0 14 A9 1A A8 ?? ?? ?? ?? 07 90 07 99 18 9B 03 F1 40 00 08 22 ?? ?? ?? ?? 18 98 ?? ?? ?? ?? 0A 9B 00 93 0B 9B 01 93 18 9B 40 33 08 93 08 9B 19 68 5A 68 19 98 ?? ?? ?? ?? 19 9B 03 93 03 98 16 B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_391_2 {
	meta:
		name = "?seekpos@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 264
		refs = "000c ?seekpos@?$fpos@U_Mbstatet@@@std@@QBA_JXZ 001e ??B?$fpos@U_Mbstatet@@@std@@QBA_JXZ 0044 ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAA_NXZ 005c fsetpos 0088 _fseeki64 009c fgetpos 00b2 ??0?$fpos@U_Mbstatet@@@std@@QAA@_J@Z 00c0 ?state@?$fpos@U_Mbstatet@@@std@@QBA?AU_Mbstatet@@XZ 00d0 memcpy 00d6 ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAAXXZ 00f0 ??0?$fpos@U_Mbstatet@@@std@@QAA@U_Mbstatet@@_J@Z 0104 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 96 B0 1A A8 ?? ?? ?? ?? 0F 91 0E 90 0E 9B 0A 93 0F 9B 0B 93 1A A8 ?? ?? ?? ?? 11 91 10 90 10 98 11 99 0A 9A 0B 9B 82 1A 61 EB 03 03 0C 92 0D 93 18 9B 4C 33 1B 68 00 2B 32 D0 18 98 ?? ?? ?? ?? 8D F8 08 00 9D F8 08 30 00 2B 29 D0 0A A9 18 9B 4C 33 18 68 ?? ?? ?? ?? 04 90 04 9B 00 2B 1F D1 0C 9B 12 93 0D 9B 13 93 13 9A 12 9B 13 43 00 2B 0C D0 01 23 00 93 0C 9A 0D 9B 18 99 4C 31 08 68 ?? ?? ?? ?? 05 90 05 9B 00 2B 09 D1 0A A9 18 9B 4C 33 18 68 ?? ?? ?? ?? 06 90 06 9B 00 2B 09 D0 16 4B 1A 68 15 4B 5B 68 19 98 ?? ?? ?? ?? 19 9B 03 93 1D E0 14 A9 1A A8 ?? ?? ?? ?? 07 90 07 99 18 9B 03 F1 40 00 08 22 ?? ?? ?? ?? 18 98 ?? ?? ?? ?? 0A 9B 00 93 0B 9B 01 93 18 9B 40 33 08 93 08 9B 19 68 5A 68 19 98 ?? ?? ?? ?? 19 9B 03 93 03 98 16 B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_391_2 {
	meta:
		name = "?seekpos@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 264
		refs = "000c ?seekpos@?$fpos@U_Mbstatet@@@std@@QBA_JXZ 001e ??B?$fpos@U_Mbstatet@@@std@@QBA_JXZ 0044 ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAA_NXZ 005c fsetpos 0088 _fseeki64 009c fgetpos 00b2 ??0?$fpos@U_Mbstatet@@@std@@QAA@_J@Z 00c0 ?state@?$fpos@U_Mbstatet@@@std@@QBA?AU_Mbstatet@@XZ 00d0 memcpy 00d6 ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAAXXZ 00f0 ??0?$fpos@U_Mbstatet@@@std@@QAA@U_Mbstatet@@_J@Z 0104 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 96 B0 1A A8 ?? ?? ?? ?? 0F 91 0E 90 0E 9B 0A 93 0F 9B 0B 93 1A A8 ?? ?? ?? ?? 11 91 10 90 10 98 11 99 0A 9A 0B 9B 82 1A 61 EB 03 03 0C 92 0D 93 18 9B 4C 33 1B 68 00 2B 32 D0 18 98 ?? ?? ?? ?? 8D F8 08 00 9D F8 08 30 00 2B 29 D0 0A A9 18 9B 4C 33 18 68 ?? ?? ?? ?? 04 90 04 9B 00 2B 1F D1 0C 9B 12 93 0D 9B 13 93 13 9A 12 9B 13 43 00 2B 0C D0 01 23 00 93 0C 9A 0D 9B 18 99 4C 31 08 68 ?? ?? ?? ?? 05 90 05 9B 00 2B 09 D1 0A A9 18 9B 4C 33 18 68 ?? ?? ?? ?? 06 90 06 9B 00 2B 09 D0 16 4B 1A 68 15 4B 5B 68 19 98 ?? ?? ?? ?? 19 9B 03 93 1D E0 14 A9 1A A8 ?? ?? ?? ?? 07 90 07 99 18 9B 03 F1 40 00 08 22 ?? ?? ?? ?? 18 98 ?? ?? ?? ?? 0A 9B 00 93 0B 9B 01 93 18 9B 40 33 08 93 08 9B 19 68 5A 68 19 98 ?? ?? ?? ?? 19 9B 03 93 03 98 16 B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_339_1 {
	meta:
		name = "?seekpos@?$fpos@U_Mbstatet@@@std@@QBA_JXZ"
		size = 42
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 08 33 00 93 00 9B 1A 68 00 9B 5B 68 02 92 03 93 02 98 03 99 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_340_1 {
	meta:
		name = "?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QBA?AU12@U_Nil@2@@Z"
		size = 44
		refs = "000e ?select_on_container_copy_construction@?$allocator_traits@V?$allocator@D@std@@@std@@SA?AV?$allocator@D@2@ABV32@@Z 0018 ??$?0V?$allocator@D@std@@@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAA@$$QAV?$allocator@D@1@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 ?? ?? ?? ?? 01 90 01 99 07 98 ?? ?? ?? ?? 07 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_1239_1 {
	meta:
		name = "?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QBA?AU12@U_Nil@2@@Z"
		size = 44
		refs = "000e ?select_on_container_copy_construction@?$allocator_traits@V?$allocator@G@std@@@std@@SA?AV?$allocator@G@2@ABV32@@Z 0018 ??$?0V?$allocator@G@std@@@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAA@$$QAV?$allocator@G@1@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 ?? ?? ?? ?? 01 90 01 99 07 98 ?? ?? ?? ?? 07 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_1240_1 {
	meta:
		name = "?select_on_container_copy_construction@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QBA?AU12@U_Nil@2@@Z"
		size = 44
		refs = "000e ?select_on_container_copy_construction@?$allocator_traits@V?$allocator@_W@std@@@std@@SA?AV?$allocator@_W@2@ABV32@@Z 0018 ??$?0V?$allocator@_W@std@@@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAA@$$QAV?$allocator@_W@1@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 ?? ?? ?? ?? 01 90 01 99 07 98 ?? ?? ?? ?? 07 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_341_1 {
	meta:
		name = "?select_on_container_copy_construction@?$allocator_traits@V?$allocator@D@std@@@std@@SA?AV?$allocator@D@2@ABV32@@Z"
		size = 34
		refs = "000e ??0?$allocator@D@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_110_2_1 {
	meta:
		name = "??0exception_ptr@std@@QAA@ABV01@@Z"
		size = 34
		refs = "000e ?__ExceptionPtrCopy@@YAXPAXPBX@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_95_217_3 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAAAAU01@$$QAU01@@Z"
		size = 34
		refs = "000e ??4_Iterator_base12@std@@QAAAAU01@ABU01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_483_3 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAAAAU01@$$QAU01@@Z"
		size = 34
		refs = "000e ??4_Iterator_base12@std@@QAAAAU01@ABU01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_36_484_3 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAAAAU01@$$QAU01@@Z"
		size = 34
		refs = "000e ??4_Iterator_base12@std@@QAAAAU01@ABU01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_95_246_3 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 34
		refs = "000e ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_418_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 34
		refs = "000e ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_495_2 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 34
		refs = "000e ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_29_125_4 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 34
		refs = "000e ?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_1391_2 {
	meta:
		name = "?select_on_container_copy_construction@?$allocator_traits@V?$allocator@G@std@@@std@@SA?AV?$allocator@G@2@ABV32@@Z"
		size = 34
		refs = "000e ??0?$allocator@G@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_1392_2 {
	meta:
		name = "?select_on_container_copy_construction@?$allocator_traits@V?$allocator@_W@std@@@std@@SA?AV?$allocator@_W@2@ABV32@@Z"
		size = 34
		refs = "000e ??0?$allocator@_W@std@@QAA@ABV01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_342_1 {
	meta:
		name = "?setbuf@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAAPAV?$basic_streambuf@DU?$char_traits@D@std@@@2@PAD_J@Z"
		size = 116
		refs = "0042 setvbuf 0060 ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 08 9B 4C 33 1B 68 00 2B 1C D0 09 9B 00 2B 0B D1 0A 9B 04 93 0B 9B 05 93 05 9A 04 9B 13 43 00 2B 02 D1 04 23 00 93 01 E0 00 23 00 93 0A 9B 00 9A 09 99 08 98 4C 30 00 68 ?? ?? ?? ?? 02 90 02 9B 00 2B 03 D0 00 23 01 93 09 E0 08 E0 01 22 08 9B 4C 33 19 68 08 98 ?? ?? ?? ?? 08 9B 01 93 01 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_343_1 {
	meta:
		name = "?setbuf@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAAPAV12@PAD_J@Z"
		size = 26
		altNames = "?setbuf@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAAPAV12@PAG_J@Z ?setbuf@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAAPAV12@PA_W_J@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_344_1 {
	meta:
		name = "?setf@ios_base@std@@QAAHH@Z"
		size = 54
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 14 33 1B 68 00 93 04 9B 03 F1 14 01 05 9B 9A B2 0B 68 1A 43 04 9B 14 33 1A 60 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_345_1 {
	meta:
		name = "?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXPAD00@Z"
		size = 50
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 02 9B 0C 33 1A 68 03 9B 13 60 02 9B 1C 33 1A 68 04 9B 13 60 05 9A 04 9B D2 1A 02 9B 2C 33 1B 68 1A 60 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_346_1 {
	meta:
		name = "?setp@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXPAD0@Z"
		size = 50
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 02 9B 10 33 1A 68 03 9B 13 60 02 9B 20 33 1A 68 03 9B 13 60 04 9A 03 9B D2 1A 02 9B 30 33 1B 68 1A 60 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_347_1 {
	meta:
		name = "?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QAAXH_N@Z"
		size = 50
		refs = "0012 ?rdstate@ios_base@std@@QBAHXZ 0024 ?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QAAXH_N@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 9B 00 2B 0B D0 04 98 ?? ?? ?? ?? 00 90 9D F8 18 20 00 99 05 9B 19 43 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_23_401_2 {
	meta:
		name = "?setstate@?$basic_ios@GU?$char_traits@G@std@@@std@@QAAXH_N@Z"
		size = 50
		refs = "0012 ?rdstate@ios_base@std@@QBAHXZ 0024 ?clear@?$basic_ios@GU?$char_traits@G@std@@@std@@QAAXH_N@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 9B 00 2B 0B D0 04 98 ?? ?? ?? ?? 00 90 9D F8 18 20 00 99 05 9B 19 43 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_424_3 {
	meta:
		name = "?setstate@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAAXH_N@Z"
		size = 50
		refs = "0012 ?rdstate@ios_base@std@@QBAHXZ 0024 ?clear@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAAXH_N@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 9B 00 2B 0B D0 04 98 ?? ?? ?? ?? 00 90 9D F8 18 20 00 99 05 9B 19 43 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_10_348_1 {
	meta:
		name = "?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAA_JXZ"
		size = 32
		altNames = "?showmanyc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAA_JXZ ?showmanyc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAA_JXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 00 23 00 93 00 23 01 93 00 98 01 99 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_349_1 {
	meta:
		name = "?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ"
		size = 36
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 1B 68 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_51_147_1 {
	meta:
		name = "?capacity@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ"
		size = 36
		refs = "000c ?_Myres@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QBAABIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 1B 68 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_1246_1 {
	meta:
		name = "?size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAIXZ"
		size = 36
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAABIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 1B 68 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_1247_1 {
	meta:
		name = "?size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAIXZ"
		size = 36
		refs = "000c ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAABIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 00 9B 1B 68 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_350_1 {
	meta:
		name = "?state@?$fpos@U_Mbstatet@@@std@@QBA?AU_Mbstatet@@XZ"
		size = 40
		refs = "0014 memcpy"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 03 F1 10 01 05 98 08 22 ?? ?? ?? ?? 05 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_351_1 {
	meta:
		name = "?sync@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAAHXZ"
		size = 138
		refs = "0016 ?eof@?$char_traits@D@std@@SAHXZ 002c _guard_check_icall 004c ?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z 0062 fflush"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 8A B0 0E 9B 4C 33 1B 68 00 2B 2F D0 ?? ?? ?? ?? 03 90 03 9D 0E 9B 1B 68 0C 33 0E 9C 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 29 46 98 47 04 90 04 9B 06 93 ?? ?? ?? ?? 05 90 05 9B 07 93 06 A9 07 A8 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0C D1 0E 9B 4C 33 18 68 ?? ?? ?? ?? 08 90 08 9B 00 2B 03 DA 6F F0 00 03 02 93 01 E0 00 23 02 93 02 9B 09 93 09 98 0A B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_353_1 {
	meta:
		name = "?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QAAPAV?$basic_ostream@DU?$char_traits@D@std@@@2@PAV32@@Z"
		size = 44
		altNames = "?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QAAPAV?$basic_ostream@GU?$char_traits@G@std@@@2@PAV32@@Z ?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAAPAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@PAV32@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 3C 33 1B 68 00 93 04 9B 03 F1 3C 02 05 9B 13 60 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_354_1 {
	meta:
		name = "?to_char_type@?$char_traits@D@std@@SADABH@Z"
		size = 34
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 68 5B B2 8D F8 00 30 9D F9 00 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_355_1 {
	meta:
		name = "?to_int_type@?$char_traits@D@std@@SAHABD@Z"
		size = 32
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 93 F9 00 30 DB B2 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_10_356_1 {
	meta:
		name = "?uflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAAHXZ"
		size = 724
		refs = "000a __security_push_cookie 0020 ?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 003a ?egptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 004c ?_Gninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAPADXZ 0054 ?to_int_type@?$char_traits@D@std@@SAHABD@Z 006e ?eof@?$char_traits@D@std@@SAHXZ 007e ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AAAXXZ 009c ??$_Fgetc@D@std@@YA_NAADPAU_iobuf@@@Z 00cc ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 00dc fgetc 00fc ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 0110 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 011c ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 0124 ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAAADXZ 012e ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ 0176 ?in@?$codecvt@DDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z 01ee ungetc 0232 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@II@Z 0274 memcpy_s 02c8 __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B ?? ?? ?? ?? B6 B0 6F 46 84 B0 6F F0 01 03 C7 E9 2E 33 D7 F8 E8 00 ?? ?? ?? ?? F8 61 FB 69 00 2B 1A D0 D7 F8 E8 00 ?? ?? ?? ?? 38 62 D7 F8 E8 00 ?? ?? ?? ?? 78 62 3A 6A 7B 6A 9A 42 0C D2 D7 F8 E8 00 ?? ?? ?? ?? B8 62 B8 6A ?? ?? ?? ?? F8 62 FB 6A 7B 60 31 E1 0B E0 D7 F8 E8 30 4C 33 1B 68 00 2B 05 D1 ?? ?? ?? ?? 38 63 3B 6B 7B 60 24 E1 D7 F8 E8 00 ?? ?? ?? ?? D7 F8 E8 30 38 33 1B 68 00 2B 1C D1 00 23 7B 70 D7 F8 E8 30 4C 33 19 68 78 1C ?? ?? ?? ?? B8 70 BB 78 00 2B 06 D0 78 1C ?? ?? ?? ?? 78 63 7B 6B 7B 61 04 E0 ?? ?? ?? ?? B8 63 BB 6B 7B 61 7B 69 7B 60 FE E0 FD E0 17 F1 C0 00 ?? ?? ?? ?? C7 F8 9C 00 D7 F8 E8 30 4C 33 18 68 ?? ?? ?? ?? F8 63 FB 6B BB 61 BB 69 B3 F1 FF 3F 0B D1 ?? ?? ?? ?? 38 64 3B 6C 7B 64 17 F1 C0 00 ?? ?? ?? ?? 7B 6C 7B 60 DE E0 BB 69 5A B2 01 21 17 F1 C0 00 ?? ?? ?? ?? 17 F1 A0 01 17 F1 C0 00 ?? ?? ?? ?? B8 64 B8 6C ?? ?? ?? ?? 38 65 17 F1 C0 00 ?? ?? ?? ?? 78 65 17 F1 A4 01 17 F1 C0 00 ?? ?? ?? ?? F8 64 F8 6C ?? ?? ?? ?? B8 65 17 F1 60 03 03 93 3B 46 5B 1C 02 93 3B 46 01 93 17 F1 10 03 00 93 3A 6D 7B 6D 13 44 BA 6D D7 F8 E8 10 40 31 D7 F8 E8 00 38 30 00 68 ?? ?? ?? ?? F8 65 FB 6D FB 60 FB 68 00 2B C0 F2 89 80 FB 68 01 2B 03 DD FB 68 03 2B 51 D0 81 E0 3A 6E 3B 46 9A 42 38 D0 17 F1 A8 01 17 F1 C0 00 ?? ?? ?? ?? 78 66 78 6E ?? ?? ?? ?? B8 66 17 F1 C0 00 ?? ?? ?? ?? F8 66 BA 6E FB 6E 1A 44 3B 69 D3 1A BB 60 BB 68 00 2B 11 DD BB 68 5B 1E BB 60 D7 F8 E8 30 4C 33 19 68 BA 68 01 23 02 FB 03 F2 3B 69 13 44 93 F9 00 00 ?? ?? ?? ?? EA E7 38 46 ?? ?? ?? ?? 38 67 3B 6F 7B 67 17 F1 C0 00 ?? ?? ?? ?? 7B 6F 7B 60 5A E0 12 E0 17 F1 AC 01 17 F1 C0 00 ?? ?? ?? ?? B8 67 B8 6F ?? ?? ?? ?? F8 67 3A 69 FB 6F D2 1A 00 21 17 F1 C0 00 ?? ?? ?? ?? 40 E0 17 F1 C0 00 ?? ?? ?? ?? C7 F8 80 00 D7 F8 80 30 01 2B 00 D2 35 E0 17 F1 B0 01 17 F1 C0 00 ?? ?? ?? ?? C7 F8 84 00 D7 F8 84 00 ?? ?? ?? ?? C7 F8 88 00 01 23 D7 F8 88 20 01 21 38 46 ?? ?? ?? ?? 38 46 ?? ?? ?? ?? C7 F8 8C 00 D7 F8 8C 30 C7 F8 90 30 17 F1 C0 00 ?? ?? ?? ?? D7 F8 90 30 7B 60 14 E0 ?? ?? ?? ?? C7 F8 94 00 D7 F8 94 30 C7 F8 98 30 17 F1 C0 00 ?? ?? ?? ?? D7 F8 98 30 7B 60 04 E0 0B E7 17 F1 C0 00 ?? ?? ?? ?? 78 68 3A B0 ?? ?? ?? ?? BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_358_1 {
	meta:
		name = "?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAAHXZ"
		size = 120
		refs = "001a _guard_check_icall 002a ?eof@?$char_traits@D@std@@SAHXZ 0038 ?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z 0056 ?_Gninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAPADXZ 005e ?to_int_type@?$char_traits@D@std@@SAHABD@Z"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 8B B0 0E 9B 1B 68 18 33 0E 9C 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 98 47 03 90 03 9B 05 93 ?? ?? ?? ?? 04 90 04 9B 06 93 05 A9 06 A8 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 05 D0 ?? ?? ?? ?? 07 90 07 9B 02 93 09 E0 0E 98 ?? ?? ?? ?? 08 90 08 98 ?? ?? ?? ?? 09 90 09 9B 02 93 02 9B 0A 93 0A 98 0B B0 BD E8 10 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_359_1 {
	meta:
		name = "?underflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAAHXZ"
		size = 186
		refs = "000e ?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 0024 ?egptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 003c ?to_int_type@?$char_traits@D@std@@SAHABD@Z 0058 _guard_check_icall 0068 ?eof@?$char_traits@D@std@@SAHXZ 0076 ?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 8E B0 12 98 ?? ?? ?? ?? 05 90 05 9B 00 2B 17 D0 12 98 ?? ?? ?? ?? 06 90 12 98 ?? ?? ?? ?? 07 90 06 9A 07 9B 9A 42 0B D2 12 98 ?? ?? ?? ?? 08 90 08 98 ?? ?? ?? ?? 09 90 09 9B 02 93 32 E0 31 E0 12 9B 1B 68 1C 33 12 9C 1B 68 03 93 03 98 ?? ?? ?? ?? 03 9B 20 46 98 47 0A 90 0A 9B 01 93 ?? ?? ?? ?? 0B 90 0B 9B 0C 93 01 A9 0C A8 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 03 D0 01 9B 02 93 10 E0 0F E0 01 9D 12 9B 1B 68 10 33 12 9C 1B 68 04 93 04 98 ?? ?? ?? ?? 04 9B 20 46 29 46 98 47 01 9B 02 93 02 98 0E B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_361_1 {
	meta:
		name = "?unshift@?$codecvt@DDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PAD1AAPAD@Z"
		size = 72
		refs = "0026 _guard_check_icall"
		altNames = "?unshift@?$codecvt@GDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PAD1AAPAD@Z ?unshift@?$codecvt@_WDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PAD1AAPAD@Z"
	strings:
		$1 = { 0F B4 2D E9 F0 49 0D F1 14 0B 85 B0 10 9B 00 93 DD F8 3C 80 0E 9F 0D 9E 0C 9B 1B 68 20 33 0C 9D 1B 68 02 93 02 98 ?? ?? ?? ?? 02 9C 28 46 31 46 3A 46 43 46 A0 47 03 90 03 9B 04 93 04 98 05 B0 BD E8 F0 09 5D F8 14 FB }
	condition:
		$1
}

rule file_10_365_1 {
	meta:
		name = "?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBADD@Z"
		size = 90
		refs = "001c ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0028 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0036 ??1locale@std@@QAA@XZ 0040 ?widen@?$ctype@D@std@@QBADD@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 8B B0 6F 46 6F F0 01 03 C7 E9 08 33 17 F1 18 01 B8 6B ?? ?? ?? ?? 78 60 7B 68 BB 60 B8 68 ?? ?? ?? ?? F8 60 FB 68 3B 61 17 F1 18 00 ?? ?? ?? ?? 97 F9 3C 10 38 69 ?? ?? ?? ?? 38 70 97 F9 00 30 3B 75 97 F9 14 00 0B B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_367_1 {
	meta:
		name = "?widen@?$ctype@D@std@@QBADD@Z"
		size = 68
		refs = "001e _guard_check_icall"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 84 B0 9D F9 24 50 08 9B 1B 68 20 33 08 9C 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 29 46 98 47 8D F8 00 00 9D F9 00 30 8D F8 08 30 9D F9 08 00 04 B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_10_368_1 {
	meta:
		name = "?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAA_JPAD_J@Z"
		size = 356
		refs = "0034 ?_Gnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBA_JXZ 0092 ?gptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 009e ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 00d0 ?gbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXH@Z 00e4 _guard_check_icall 00f4 ?eof@?$char_traits@D@std@@SAHXZ 0102 ?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z 0118 ?to_char_type@?$char_traits@D@std@@SADABH@Z"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B 9D B0 00 23 04 93 00 23 05 93 22 9B 10 93 23 9B 11 93 10 9B 08 93 11 9B 00 2B C0 F2 93 80 03 DC 08 9B 00 2B 40 F2 8E 80 20 98 ?? ?? ?? ?? 13 91 12 90 12 9B 02 93 13 9B 03 93 02 9B 14 93 03 9B 15 93 14 9B 09 93 15 9B 00 2B 3F DB 02 DC 09 9B 00 2B 3B D9 22 9B 16 93 23 9B 17 93 02 9B 18 93 03 9B 19 93 16 9B 0A 93 18 9B 0B 93 17 9A 19 9B 9A 42 08 DC 03 DB 0A 9A 0B 9B 9A 42 03 D2 22 9B 02 93 23 9B 03 93 20 98 ?? ?? ?? ?? 0C 90 02 9A 0C 99 21 98 ?? ?? ?? ?? 02 9A 21 9B 13 44 21 93 04 98 05 99 02 9A 03 9B 12 18 4B 41 04 92 05 93 22 98 23 99 02 9A 03 9B 82 1A 61 EB 03 03 22 92 23 93 02 99 20 98 ?? ?? ?? ?? 3A E0 20 9B 1B 68 1C 33 20 9C 1B 68 06 93 06 98 ?? ?? ?? ?? 06 9B 20 46 98 47 0D 90 0D 9B 07 93 ?? ?? ?? ?? 0E 90 0E 9B 0F 93 07 A9 0F A8 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 01 D0 1C E0 1A E0 07 A8 ?? ?? ?? ?? 8D F8 01 00 9D F9 01 20 21 9B 1A 70 21 9B 5B 1C 21 93 04 9A 05 99 00 23 52 1C 4B 41 04 92 05 93 22 9A 23 99 00 23 52 1E 61 EB 03 03 22 92 23 93 62 E7 04 9A 05 9B 1A 92 1B 93 1A 98 1B 99 1D B0 BD E8 10 08 5D F8 14 FB }
	condition:
		$1
}

rule file_10_369_1 {
	meta:
		name = "?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAA_JPBD_J@Z"
		size = 350
		refs = "0034 ?_Pnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBA_JXZ 0092 ?pptr@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBAPADXZ 009e ?copy@?$char_traits@D@std@@SAPADPADPBDI@Z 00d0 ?pbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAAXH@Z 00d8 ?to_int_type@?$char_traits@D@std@@SAHABD@Z 00ee _guard_check_icall 0100 ?eof@?$char_traits@D@std@@SAHXZ 010e ?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z"
	strings:
		$1 = { 0F B4 2D E9 30 48 0D F1 08 0B 9E B0 00 23 04 93 00 23 05 93 24 9B 12 93 25 9B 13 93 12 9B 07 93 13 9B 00 2B C0 F2 90 80 03 DC 07 9B 00 2B 40 F2 8B 80 22 98 ?? ?? ?? ?? 15 91 14 90 14 9B 02 93 15 9B 03 93 02 9B 16 93 03 9B 17 93 16 9B 08 93 17 9B 00 2B 3F DB 02 DC 08 9B 00 2B 3B D9 24 9B 18 93 25 9B 19 93 02 9B 1A 93 03 9B 1B 93 18 9B 09 93 1A 9B 0A 93 19 9A 1B 9B 9A 42 08 DC 03 DB 09 9A 0A 9B 9A 42 03 D2 24 9B 02 93 25 9B 03 93 22 98 ?? ?? ?? ?? 0B 90 02 9A 23 99 0B 98 ?? ?? ?? ?? 02 9A 23 9B 13 44 23 93 04 98 05 99 02 9A 03 9B 12 18 4B 41 04 92 05 93 24 98 25 99 02 9A 03 9B 82 1A 61 EB 03 03 24 92 25 93 02 99 22 98 ?? ?? ?? ?? 37 E0 23 98 ?? ?? ?? ?? 0C 90 0C 9D 22 9B 1B 68 0C 33 22 9C 1B 68 06 93 06 98 ?? ?? ?? ?? 06 9B 20 46 29 46 98 47 0D 90 0D 9B 0F 93 ?? ?? ?? ?? 0E 90 0E 9B 10 93 0F A9 10 A8 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 01 D0 13 E0 11 E0 23 9B 5B 1C 23 93 04 9A 05 99 00 23 52 1C 4B 41 04 92 05 93 24 9A 25 99 00 23 52 1E 61 EB 03 03 24 92 25 93 65 E7 04 9A 05 9B 1C 92 1D 93 1C 98 1D 99 1E B0 BD E8 30 08 5D F8 14 FB }
	condition:
		$1
}

rule file_10_370_1 {
	meta:
		name = "memcpy_s"
		size = 224
		refs = "0030 _errno 003c _invalid_parameter_noinfo 005a memset 00cc memcpy"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0F 9B 00 2B 02 D1 00 23 00 93 5E E0 0C 9B 00 2B 02 D0 01 23 01 93 01 E0 00 23 01 93 01 9B 04 93 04 9B 00 2B 0A D1 ?? ?? ?? ?? 05 90 05 9A 16 23 13 60 ?? ?? ?? ?? 16 23 00 93 46 E0 0E 9B 00 2B 03 D0 0D 9A 0F 9B 9A 42 38 D2 0D 9A 00 21 0C 98 ?? ?? ?? ?? 0E 9B 00 2B 02 D0 01 23 02 93 01 E0 00 23 02 93 02 9B 06 93 06 9B 00 2B 0A D1 ?? ?? ?? ?? 07 90 07 9A 16 23 13 60 ?? ?? ?? ?? 16 23 00 93 22 E0 0D 9A 0F 9B 9A 42 02 D3 01 23 03 93 01 E0 00 23 03 93 03 9B 08 93 08 9B 00 2B 0A D1 ?? ?? ?? ?? 09 90 09 9A 22 23 13 60 ?? ?? ?? ?? 22 23 00 93 09 E0 16 23 00 93 06 E0 0F 9A 0E 99 0C 98 ?? ?? ?? ?? 00 23 00 93 00 98 0A B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_11_0_1 {
	meta:
		name = "_Smtx_lock_exclusive"
		size = 28
		refs = "0018 __imp_AcquireSRWLockExclusive"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_1_1 {
	meta:
		name = "?_Mtx_lock@threads@stdext@@YAXPAX@Z"
		size = 28
		refs = "0018 __imp_EnterCriticalSection"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_3_1 {
	meta:
		name = "?_Mtx_unlock@threads@stdext@@YAXPAX@Z"
		size = 28
		refs = "0018 __imp_LeaveCriticalSection"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_149_3 {
	meta:
		name = "_Close_dir"
		size = 28
		refs = "0018 __imp_FindClose"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_0_3 {
	meta:
		name = "_Mtxdst"
		size = 28
		refs = "0018 __imp_DeleteCriticalSection"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_2_3 {
	meta:
		name = "_Mtxlock"
		size = 28
		refs = "0018 __imp_EnterCriticalSection"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_3_3 {
	meta:
		name = "_Mtxunlock"
		size = 28
		refs = "0018 __imp_LeaveCriticalSection"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_1_3 {
	meta:
		name = "_Smtx_lock_shared"
		size = 28
		refs = "0018 __imp_AcquireSRWLockShared"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_4_3 {
	meta:
		name = "_Smtx_unlock_exclusive"
		size = 28
		refs = "0018 __imp_ReleaseSRWLockExclusive"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_5_2 {
	meta:
		name = "_Smtx_unlock_shared"
		size = 28
		refs = "0018 __imp_ReleaseSRWLockShared"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 98 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_2_1 {
	meta:
		name = "_Smtx_try_lock_exclusive"
		size = 44
		refs = "0028 __imp_TryAcquireSRWLockExclusive"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 06 4B 1B 68 98 47 8D F8 00 00 9D F8 00 30 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_3_1 {
	meta:
		name = "_Smtx_try_lock_shared"
		size = 44
		refs = "0028 __imp_TryAcquireSRWLockShared"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 06 4B 1B 68 98 47 8D F8 00 00 9D F8 00 30 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_0_1 {
	meta:
		name = "_LDscale"
		size = 44
		refs = "000e _Dscale"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? AD F8 00 00 BD F9 00 30 AD F8 04 30 BD F9 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_85_0_1 {
	meta:
		name = "_LDunscale"
		size = 44
		refs = "000e _Dunscale"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? AD F8 00 00 BD F9 00 30 AD F8 04 30 BD F9 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_13_0_1 {
	meta:
		name = "_Stolx"
		size = 276
		refs = "0028 isspace 006e _Stoulx 00ba _errno"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8C B0 0F 9B 00 2B 01 D1 0A AB 0F 93 0E 9B 01 93 02 E0 01 9B 5B 1C 01 93 01 9B 93 F9 00 30 D8 B2 ?? ?? ?? ?? 07 90 07 9B 00 2B 00 D0 F1 E7 01 9B 93 F9 00 30 2D 2B 07 D0 01 9B 93 F9 00 30 2B 2B 02 D0 2B 23 03 93 06 E0 01 9B 93 F9 00 30 03 93 01 9B 5B 1C 01 93 03 9B 5B B2 8D F8 00 30 11 9B 10 9A 0F 99 01 98 ?? ?? ?? ?? 08 90 08 9B 02 93 01 9A 0F 9B 1B 68 9A 42 02 D1 0E 9A 0F 9B 1A 60 0E 9A 0F 9B 1B 68 9A 42 02 D1 02 9B 00 2B 10 D1 9D F9 00 30 2B 2B 04 D1 02 9A 6F F0 00 43 9A 42 07 D8 9D F9 00 30 2D 2B 1E D1 02 9B B3 F1 00 4F 1A D9 ?? ?? ?? ?? 09 90 09 9A 22 23 13 60 11 9B 00 2B 02 D0 11 9A 01 23 13 60 9D F9 00 30 2D 2B 03 D1 4F F0 00 43 04 93 02 E0 6F F0 00 43 04 93 04 9B 06 93 0C E0 0B E0 9D F9 00 30 2D 2B 03 D1 02 9B 5B 42 05 93 01 E0 02 9B 05 93 05 9B 06 93 06 98 0C B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_14_0_1 {
	meta:
		name = "_WStoxflt"
		size = 944
		refs = "0008 __security_push_cookie 0066 wmemchr 00b6 localeconv 01f6 __report_rangecheckfailure 021e __rt_sdiv 031e iswctype 0398 __security_pop_cookie 03a8 ?vals@?1??_WStoxflt@@9@9 03ac ?digits@?1??_WStoxflt@@9@9"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 9D B0 00 23 01 93 24 9A 07 23 02 FB 03 F3 24 93 24 9B 23 2B 01 DD 23 23 24 93 23 9A 00 23 13 60 23 9B 1A 1D 00 23 13 60 00 23 02 93 04 E0 21 9B 9B 1C 21 93 01 23 02 93 21 9B 1B 88 30 2B 00 D1 F5 E7 00 23 00 93 04 E0 21 9B 9B 1C 21 93 01 23 02 93 16 22 21 9B 19 88 D1 48 ?? ?? ?? ?? 0E 90 0E 9B 04 93 04 9B 00 2B 1F D0 00 9A 24 9B 9A 42 15 DC 04 9A CA 4B D3 1A 5A 10 02 23 02 FB 03 F2 C6 4B 99 18 00 9A 01 23 02 FB 03 F2 14 AB 1A 44 0B 88 5B B2 13 70 00 9B 5B 1C 00 93 04 E0 23 9B 1B 68 5A 1C 23 9B 1A 60 CE E7 ?? ?? ?? ?? 0F 90 21 9B 1A 88 0F 9B 1B 68 93 F9 00 30 9A 42 02 D1 21 9B 9B 1C 21 93 00 9B 00 2B 0F D1 04 E0 21 9B 9B 1C 21 93 01 23 02 93 21 9B 1B 88 30 2B 05 D1 23 9B 1B 68 5A 1E 23 9B 1A 60 F0 E7 04 E0 21 9B 9B 1C 21 93 01 23 02 93 16 22 21 9B 19 88 A8 48 ?? ?? ?? ?? 10 90 10 9B 04 93 04 9B 00 2B 1E D0 00 9A 24 9B 9A 42 19 DC 04 9A A1 4B D3 1A 5A 10 02 23 02 FB 03 F2 9D 4B 99 18 00 9A 01 23 02 FB 03 F2 14 AB 1A 44 0B 88 5B B2 13 70 00 9B 5B 1C 00 93 23 9B 1B 68 5A 1E 23 9B 1A 60 CF E7 24 9A 00 9B 9A 42 25 DA 24 9B 08 93 08 9A 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 30 08 2B 12 DB 08 9B 5A 1E 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 30 5B 1C 59 B2 08 9B 5A 1E 01 23 02 FB 03 F2 14 AB 13 44 19 70 24 9B 00 93 23 9B 1B 68 5A 1C 23 9B 1A 60 02 E0 00 9B 5B 1E 00 93 00 9B 00 2B 10 DD 00 9B 5A 1E 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 30 00 2B 05 D1 23 9B 1B 68 5A 1C 23 9B 1A 60 E8 E7 00 9B 00 2B 0F D1 00 9B 09 93 00 9B 5B 1C 00 93 09 9B 24 2B 00 D2 01 E0 ?? ?? ?? ?? 14 AA 09 9B 1A 44 00 23 13 70 23 9B 1B 68 9A 00 23 9B 1A 60 02 9B 00 2B 00 F0 AA 80 00 23 05 93 00 99 07 20 ?? ?? ?? ?? 07 23 5B 1A 06 93 06 99 07 20 ?? ?? ?? ?? 00 29 02 D1 00 23 0A 93 01 E0 01 23 0A 93 0A 9B 01 93 05 E0 06 9B 5B 1C 06 93 05 9B 5B 1C 05 93 05 9A 00 9B 9A 42 33 DA 06 99 07 20 ?? ?? ?? ?? 00 29 12 D1 01 9B 5B 1C 01 93 05 9A 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 10 01 9A 04 23 02 FB 03 F2 23 9B 13 44 19 60 19 E0 01 9A 04 23 02 FB 03 F2 23 9B 13 44 1A 68 10 23 02 FB 03 F1 05 9A 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 30 19 44 01 9A 04 23 02 FB 03 F2 23 9B 13 44 19 60 C1 E7 21 9B 1B 88 70 2B 03 D0 21 9B 1B 88 50 2B 4C D1 21 9B 12 93 21 9B 9B 1C 21 93 21 9B 1B 88 2B 2B 06 D0 21 9B 1B 88 2D 2B 02 D0 2B 23 0B 93 05 E0 21 9B 1B 88 0B 93 21 9B 9B 1C 21 93 0B 9B 9B B2 AD F8 1C 30 00 23 0C 93 00 23 03 93 04 E0 21 9B 9B 1C 21 93 01 23 0C 93 04 21 21 9B 18 88 ?? ?? ?? ?? 11 90 11 9B 00 2B 0D D0 03 9A 1D 4B 9A 42 08 DA 03 9A 0A 23 02 FB 03 F2 21 9B 1B 88 13 44 30 3B 03 93 E3 E7 BD F8 1C 30 2D 2B 02 D1 03 9B 5B 42 03 93 23 9B 1A 68 03 9B 1A 44 23 9B 1A 60 0C 9B 00 2B 01 D1 12 9B 21 93 02 9B 00 2B 01 D1 00 23 01 93 22 9B 00 2B 0A D0 02 9B 00 2B 02 D0 21 9B 0D 93 01 E0 20 9B 0D 93 0D 9A 22 9B 1A 60 01 9B 13 93 13 98 1D B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB 00 E1 F5 05 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_1_1 {
	meta:
		name = "wmemchr"
		size = 66
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 E0 04 9B 9B 1C 04 93 06 9B 5B 1E 06 93 06 9B 00 2B 09 D9 04 9B 1A 88 BD F8 14 30 9A 42 02 D1 04 9B 00 93 02 E0 EC E7 00 23 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_28_1 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBA?AV01@H@Z"
		size = 56
		refs = "0010 memcpy 0018 ??Z?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 04 22 ?? ?? ?? ?? 08 99 68 46 ?? ?? ?? ?? 01 90 01 99 07 98 04 22 ?? ?? ?? ?? 07 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_79_184_1 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBA?AV01@H@Z"
		size = 56
		refs = "0010 memcpy 0018 ??Z?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 04 22 ?? ?? ?? ?? 08 99 68 46 ?? ?? ?? ?? 01 90 01 99 07 98 04 22 ?? ?? ?? ?? 07 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_410_1 {
	meta:
		name = "??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBA?AV01@H@Z"
		size = 56
		refs = "0010 memcpy 0018 ??Z?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 04 22 ?? ?? ?? ?? 08 99 68 46 ?? ?? ?? ?? 01 90 01 99 07 98 04 22 ?? ?? ?? ?? 07 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_79_186_1 {
	meta:
		name = "??H?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBA?AV01@H@Z"
		size = 56
		refs = "0010 memcpy 0018 ??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 04 22 ?? ?? ?? ?? 08 99 68 46 ?? ?? ?? ?? 01 90 01 99 07 98 04 22 ?? ?? ?? ?? 07 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_414_1 {
	meta:
		name = "??H?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBA?AV01@H@Z"
		size = 56
		refs = "0010 memcpy 0018 ??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 04 22 ?? ?? ?? ?? 08 99 68 46 ?? ?? ?? ?? 01 90 01 99 07 98 04 22 ?? ?? ?? ?? 07 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_415_1 {
	meta:
		name = "??H?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBA?AV01@H@Z"
		size = 56
		refs = "0010 memcpy 0018 ??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 04 22 ?? ?? ?? ?? 08 99 68 46 ?? ?? ?? ?? 01 90 01 99 07 98 04 22 ?? ?? ?? ?? 07 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_29_1 {
	meta:
		name = "??Iv1@filesystem@experimental@std@@YA?AW4perms@0123@W440123@0@Z"
		size = 30
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 05 9B 13 40 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_30_1 {
	meta:
		name = "??Sv1@filesystem@experimental@std@@YA?AW4perms@0123@W440123@@Z"
		size = 28
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B DB 43 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_31_1 {
	meta:
		name = "??Uv1@filesystem@experimental@std@@YA?AW4perms@0123@W440123@0@Z"
		size = 30
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 05 9B 13 43 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_32_1 {
	meta:
		name = "??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 44
		altNames = "??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 99 05 9A 02 23 02 FB 03 F2 0B 68 1A 44 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_34_1 {
	meta:
		name = "??Z?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 38
		refs = "0010 ??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 9B 59 42 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_79_190_1 {
	meta:
		name = "??Z?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 38
		refs = "0010 ??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 9B 59 42 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_425_1 {
	meta:
		name = "??Z?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
		size = 38
		refs = "0010 ??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAAAAV01@H@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 9B 59 42 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_40_1 {
	meta:
		name = "?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXII@Z"
		size = 314
		refs = "0020 ?max_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAIXZ 0036 ?_Myres@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAIXZ 0040 __rt_udiv 00b6 ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 00c2 ?allocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAPA_WI@Z 00d6 ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAPA_WXZ 00de ??$_Unfancy@_W@std@@YAPA_WPA_W@Z 00ea ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z 00f4 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z 00fa ?_Bx@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAT_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0102 ??$addressof@PA_W@std@@YAPAPA_WAAPA_W@Z 0116 ??$construct@PA_WAAPA_W@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAXPAPA_WAAPA_W@Z 012c ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 90 48 0D F1 08 0B 96 B0 6F 46 6F F0 01 03 C7 E9 14 33 FB 6E 43 F0 07 03 3B 60 B8 6E ?? ?? ?? ?? B8 60 BA 68 3B 68 9A 42 02 D2 FB 6E 3B 60 3F E0 B8 6E ?? ?? ?? ?? F8 60 39 68 03 20 ?? ?? ?? ?? 04 46 FB 68 19 68 02 20 ?? ?? ?? ?? A0 42 00 D8 2E E0 B8 6E ?? ?? ?? ?? B8 61 B8 6E ?? ?? ?? ?? 78 61 B8 6E ?? ?? ?? ?? 38 61 3B 69 19 68 02 20 ?? ?? ?? ?? 7B 69 1A 1A BB 69 1B 68 93 42 11 D8 B8 6E ?? ?? ?? ?? 38 62 B8 6E ?? ?? ?? ?? F8 61 FB 69 19 68 02 20 ?? ?? ?? ?? 3B 6A 1B 68 03 44 3B 60 05 E0 B8 6E ?? ?? ?? ?? 78 62 7B 6A 3B 60 B8 6E ?? ?? ?? ?? B8 62 3B 68 59 1C B8 6A ?? ?? ?? ?? F8 62 FB 6A 7B 60 FF E7 3B 6F 00 2B 0C D9 B8 6E ?? ?? ?? ?? B8 63 78 68 ?? ?? ?? ?? F8 63 3A 6F B9 6B F8 6B ?? ?? ?? ?? 00 22 01 21 B8 6E ?? ?? ?? ?? B8 6E ?? ?? ?? ?? 38 64 38 6C ?? ?? ?? ?? 78 64 B8 6E ?? ?? ?? ?? B8 64 3A 1D 79 6C B8 6C ?? ?? ?? ?? B8 6E ?? ?? ?? ?? F8 64 3A 68 FB 6C 1A 60 39 6F B8 6E ?? ?? ?? ?? 16 B0 BD E8 90 08 5D F8 14 FB }
	condition:
		$1
}

rule file_55_514_1 {
	meta:
		name = "?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXII@Z"
		size = 314
		refs = "0020 ?max_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAIXZ 0036 ?_Myres@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAIXZ 0040 __rt_udiv 00b6 ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 00c2 ?allocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAPAGI@Z 00d6 ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAPAGXZ 00de ??$_Unfancy@G@std@@YAPAGPAG@Z 00ea ?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z 00f4 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z 00fa ?_Bx@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAT_Bxty@?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0102 ??$addressof@PAG@std@@YAPAPAGAAPAG@Z 0116 ??$construct@PAGAAPAG@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAXPAPAGAAPAG@Z 012c ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 90 48 0D F1 08 0B 96 B0 6F 46 6F F0 01 03 C7 E9 14 33 FB 6E 43 F0 07 03 3B 60 B8 6E ?? ?? ?? ?? B8 60 BA 68 3B 68 9A 42 02 D2 FB 6E 3B 60 3F E0 B8 6E ?? ?? ?? ?? F8 60 39 68 03 20 ?? ?? ?? ?? 04 46 FB 68 19 68 02 20 ?? ?? ?? ?? A0 42 00 D8 2E E0 B8 6E ?? ?? ?? ?? B8 61 B8 6E ?? ?? ?? ?? 78 61 B8 6E ?? ?? ?? ?? 38 61 3B 69 19 68 02 20 ?? ?? ?? ?? 7B 69 1A 1A BB 69 1B 68 93 42 11 D8 B8 6E ?? ?? ?? ?? 38 62 B8 6E ?? ?? ?? ?? F8 61 FB 69 19 68 02 20 ?? ?? ?? ?? 3B 6A 1B 68 03 44 3B 60 05 E0 B8 6E ?? ?? ?? ?? 78 62 7B 6A 3B 60 B8 6E ?? ?? ?? ?? B8 62 3B 68 59 1C B8 6A ?? ?? ?? ?? F8 62 FB 6A 7B 60 FF E7 3B 6F 00 2B 0C D9 B8 6E ?? ?? ?? ?? B8 63 78 68 ?? ?? ?? ?? F8 63 3A 6F B9 6B F8 6B ?? ?? ?? ?? 00 22 01 21 B8 6E ?? ?? ?? ?? B8 6E ?? ?? ?? ?? 38 64 38 6C ?? ?? ?? ?? 78 64 B8 6E ?? ?? ?? ?? B8 64 3A 1D 79 6C B8 6C ?? ?? ?? ?? B8 6E ?? ?? ?? ?? F8 64 3A 68 FB 6C 1A 60 39 6F B8 6E ?? ?? ?? ?? 16 B0 BD E8 90 08 5D F8 14 FB }
	condition:
		$1
}

rule file_16_44_1 {
	meta:
		name = "?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z"
		size = 74
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 001e ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAAPA_WXZ 003c ?assign@?$char_traits@_W@std@@SAXAA_WAB_W@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 02 90 02 9B 01 93 00 23 AD F8 00 30 01 98 ?? ?? ?? ?? 03 90 01 9B 03 F1 10 02 07 9B 13 60 69 46 07 9A 02 23 02 FB 03 F2 03 9B 98 18 ?? ?? ?? ?? 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_534_1 {
	meta:
		name = "?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z"
		size = 74
		refs = "000c ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 001e ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QAAPAGXZ 003c ?assign@?$char_traits@G@std@@SAXAAGABG@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 02 90 02 9B 01 93 00 23 AD F8 00 30 01 98 ?? ?? ?? ?? 03 90 01 9B 03 F1 10 02 07 9B 13 60 69 46 07 9A 02 23 02 FB 03 F2 03 9B 98 18 ?? ?? ?? ?? 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_45_1 {
	meta:
		name = "?_FilesysOpenFile@v1@filesystem@experimental@std@@YAPAXPB_WKK@Z"
		size = 60
		refs = "0038 __imp_CreateFileW"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B 87 B0 00 23 02 93 0C 9B 01 93 03 23 00 93 00 23 07 22 0B 99 0A 98 05 4C 24 68 A0 47 04 90 04 9B 05 93 05 98 07 B0 BD E8 10 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_46_1 {
	meta:
		name = "?_Filesys_code_page@v1@filesystem@experimental@std@@YAIXZ"
		size = 48
		refs = "002c __imp_AreFileApisANSI"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 08 4B 1B 68 98 47 01 90 01 9B 00 2B 03 D0 00 23 00 93 02 E0 01 E0 01 23 00 93 00 98 02 B0 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_55_1 {
	meta:
		name = "?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z"
		size = 188
		refs = "000c ?max_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAIXZ 001c ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ 0022 ?_Myres@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAIXZ 0034 ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAIXZ 0042 ?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXII@Z 0082 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z 0092 ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 88 B0 0A 98 ?? ?? ?? ?? 02 90 02 9A 0B 9B 9A 42 02 D2 0A 98 ?? ?? ?? ?? 0A 98 ?? ?? ?? ?? 03 90 03 9B 1A 68 0B 9B 9A 42 0A D2 0A 98 ?? ?? ?? ?? 04 90 04 9B 1A 68 0B 99 0A 98 ?? ?? ?? ?? 26 E0 9D F8 30 30 00 2B 1B D0 0B 9B 08 2B 18 D2 0A 98 ?? ?? ?? ?? 05 90 0B 9A 05 9B 1B 68 9A 42 02 D2 0B 9B 00 93 06 E0 0A 98 ?? ?? ?? ?? 06 90 06 9B 1B 68 00 93 00 9A 01 21 0A 98 ?? ?? ?? ?? 06 E0 0B 9B 00 2B 03 D1 00 21 0A 98 ?? ?? ?? ?? 0B 9B 00 2B 02 D9 01 23 01 93 01 E0 00 23 01 93 01 9B DB B2 8D F8 1C 30 9D F8 1C 00 08 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_730_1 {
	meta:
		name = "?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z"
		size = 188
		refs = "000c ?max_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAIXZ 001c ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ 0022 ?_Myres@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAIXZ 0034 ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAIXZ 0042 ?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXII@Z 0082 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z 0092 ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 88 B0 0A 98 ?? ?? ?? ?? 02 90 02 9A 0B 9B 9A 42 02 D2 0A 98 ?? ?? ?? ?? 0A 98 ?? ?? ?? ?? 03 90 03 9B 1A 68 0B 9B 9A 42 0A D2 0A 98 ?? ?? ?? ?? 04 90 04 9B 1A 68 0B 99 0A 98 ?? ?? ?? ?? 26 E0 9D F8 30 30 00 2B 1B D0 0B 9B 08 2B 18 D2 0A 98 ?? ?? ?? ?? 05 90 0B 9A 05 9B 1B 68 9A 42 02 D2 0B 9B 00 93 06 E0 0A 98 ?? ?? ?? ?? 06 90 06 9B 1B 68 00 93 00 9A 01 21 0A 98 ?? ?? ?? ?? 06 E0 0B 9B 00 2B 03 D1 00 21 0A 98 ?? ?? ?? ?? 0B 9B 00 2B 02 D9 01 23 01 93 01 E0 00 23 01 93 01 9B DB B2 8D F8 1C 30 9D F8 1C 00 08 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_56_1 {
	meta:
		name = "?_Inside@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NPB_W@Z"
		size = 98
		refs = "0012 ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAPA_WXZ 002a ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 9B 00 2B 19 D0 06 98 ?? ?? ?? ?? 01 90 07 9A 01 9B 9A 42 11 D3 06 98 ?? ?? ?? ?? 03 90 06 98 ?? ?? ?? ?? 02 90 02 9B 1A 68 02 23 02 FB 03 F2 03 9B 1A 44 07 9B 9A 42 04 D8 00 23 8D F8 00 30 03 E0 02 E0 01 23 8D F8 00 30 9D F8 00 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_773_1 {
	meta:
		name = "?_Inside@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NPBG@Z"
		size = 98
		refs = "0012 ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAPAGXZ 002a ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 9B 00 2B 19 D0 06 98 ?? ?? ?? ?? 01 90 07 9A 01 9B 9A 42 11 D3 06 98 ?? ?? ?? ?? 03 90 06 98 ?? ?? ?? ?? 02 90 02 9B 1A 68 02 23 02 FB 03 F2 03 9B 1A 44 07 9B 9A 42 04 D8 00 23 8D F8 00 30 03 E0 02 E0 01 23 8D F8 00 30 9D F8 00 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_57_1 {
	meta:
		name = "?_Map_mode@v1@filesystem@experimental@std@@YA?AW4file_type@1234@H@Z"
		size = 62
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 13 F0 10 0F 03 D0 02 23 00 93 0C E0 0B E0 04 9A 47 F6 A7 33 13 40 00 2B 03 D0 01 23 00 93 02 E0 01 E0 08 23 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_60_1 {
	meta:
		name = "?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAAPA_WXZ"
		size = 56
		refs = "0018 ??$_Unfancy@_W@std@@YAPA_WPA_W@Z"
		altNames = "?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QBAPB_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 14 33 1B 68 08 2B 07 D3 06 9B 18 68 ?? ?? ?? ?? 01 90 01 9B 00 93 01 E0 06 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_826_1 {
	meta:
		name = "?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QAAPAGXZ"
		size = 56
		refs = "0018 ??$_Unfancy@G@std@@YAPAGPAG@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 14 33 1B 68 08 2B 07 D3 06 9B 18 68 ?? ?? ?? ?? 01 90 01 9B 00 93 01 E0 06 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_827_1 {
	meta:
		name = "?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QBAPBGXZ"
		size = 56
		refs = "0018 ??$_Unfancy@G@std@@YAPAGPAG@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 14 33 1B 68 08 2B 07 D3 06 9B 18 68 ?? ?? ?? ?? 01 90 01 9B 00 93 01 E0 06 9B 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_65_1 {
	meta:
		name = "?_Strcpy@v1@filesystem@experimental@std@@YAPA_WAAY0BAE@_WPB_W@Z"
		size = 38
		refs = "0012 wcscpy_s"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 9A 4F F4 82 71 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_66_1 {
	meta:
		name = "?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z"
		size = 176
		refs = "0016 ?_Myres@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAIXZ 0026 ?_Bx@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAT_Bxty@?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 003c ??$addressof@PA_W@std@@YAPAPA_WAAPA_W@Z 0044 ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 004e ??$destroy@PA_W@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAXPAPA_W@Z 005a ??$_Unfancy@_W@std@@YAPA_WPA_W@Z 006e ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z 008c ?deallocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAAXPA_WI@Z 00a2 ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8C B0 9D F8 3C 30 00 2B 00 D1 3D E0 0E 98 ?? ?? ?? ?? 01 90 01 9B 1B 68 08 2B 35 D3 0E 98 ?? ?? ?? ?? 02 90 02 9B 1B 68 00 93 0E 98 ?? ?? ?? ?? 03 90 03 98 ?? ?? ?? ?? 04 90 0E 98 ?? ?? ?? ?? 05 90 04 99 05 98 ?? ?? ?? ?? 10 9B 00 2B 0C D9 00 98 ?? ?? ?? ?? 06 90 0E 98 ?? ?? ?? ?? 07 90 10 9A 06 99 07 98 ?? ?? ?? ?? 0E 98 ?? ?? ?? ?? 08 90 0E 98 ?? ?? ?? ?? 09 90 08 9B 1B 68 5A 1C 00 99 09 98 ?? ?? ?? ?? 0E 98 ?? ?? ?? ?? 0A 90 0A 9A 07 23 13 60 10 99 0E 98 ?? ?? ?? ?? 0C B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_874_1 {
	meta:
		name = "?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z"
		size = 176
		refs = "0016 ?_Myres@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAIXZ 0026 ?_Bx@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAT_Bxty@?$_String_val@U?$_Simple_types@G@std@@@2@XZ 003c ??$addressof@PAG@std@@YAPAPAGAAPAG@Z 0044 ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 004e ??$destroy@PAG@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAXPAPAG@Z 005a ??$_Unfancy@G@std@@YAPAGPAG@Z 006e ?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z 008c ?deallocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAAXPAGI@Z 00a2 ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8C B0 9D F8 3C 30 00 2B 00 D1 3D E0 0E 98 ?? ?? ?? ?? 01 90 01 9B 1B 68 08 2B 35 D3 0E 98 ?? ?? ?? ?? 02 90 02 9B 1B 68 00 93 0E 98 ?? ?? ?? ?? 03 90 03 98 ?? ?? ?? ?? 04 90 0E 98 ?? ?? ?? ?? 05 90 04 99 05 98 ?? ?? ?? ?? 10 9B 00 2B 0C D9 00 98 ?? ?? ?? ?? 06 90 0E 98 ?? ?? ?? ?? 07 90 10 9A 06 99 07 98 ?? ?? ?? ?? 0E 98 ?? ?? ?? ?? 08 90 0E 98 ?? ?? ?? ?? 09 90 08 9B 1B 68 5A 1C 00 99 09 98 ?? ?? ?? ?? 0E 98 ?? ?? ?? ?? 0A 90 0A 9A 07 23 13 60 10 99 0E 98 ?? ?? ?? ?? 0C B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_73_1 {
	meta:
		name = "?allocate@?$allocator@_W@std@@QAAPA_WI@Z"
		size = 38
		refs = "0010 ?_Allocate@std@@YAPAXII_N@Z"
		altNames = "?allocate@?$allocator@G@std@@QAAPAGI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 01 22 02 21 05 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_74_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 196
		refs = "000e ?_Check_offset@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXI@Z 0018 ?_Clamp_suffix_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAIII@Z 0024 ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAIXZ 003c ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ 005e ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 0070 ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAPB_WXZ 0078 ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAPA_WXZ 00a2 ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z 00aa ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z 00c0 ?npos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@2IB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0E 99 0D 98 ?? ?? ?? ?? 0F 9A 0E 99 0D 98 ?? ?? ?? ?? 02 90 02 9B 0F 93 0C 98 ?? ?? ?? ?? 03 90 25 4B 1A 68 03 9B 1B 68 D2 1A 0F 9B 9A 42 02 D8 0C 98 ?? ?? ?? ?? 0C 98 ?? ?? ?? ?? 04 90 04 9B 1A 68 0F 9B 13 44 01 93 0F 9B 00 2B 2A D9 00 22 01 99 0C 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 1F D0 0D 98 ?? ?? ?? ?? 05 90 0C 98 ?? ?? ?? ?? 07 90 0C 98 ?? ?? ?? ?? 06 90 0F 9A 0E 99 02 23 01 FB 03 F1 05 9B 19 44 06 9B 18 68 02 23 00 FB 03 F0 07 9B 18 44 ?? ?? ?? ?? 01 99 0C 98 ?? ?? ?? ?? 0C 9B 08 93 08 98 0A B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_901_1 {
	meta:
		name = "?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 196
		refs = "000e ?_Check_offset@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXI@Z 0018 ?_Clamp_suffix_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAIII@Z 0024 ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAIXZ 003c ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ 005e ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 0070 ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAPBGXZ 0078 ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAPAGXZ 00a2 ?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z 00aa ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z 00c0 ?npos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@2IB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0E 99 0D 98 ?? ?? ?? ?? 0F 9A 0E 99 0D 98 ?? ?? ?? ?? 02 90 02 9B 0F 93 0C 98 ?? ?? ?? ?? 03 90 25 4B 1A 68 03 9B 1B 68 D2 1A 0F 9B 9A 42 02 D8 0C 98 ?? ?? ?? ?? 0C 98 ?? ?? ?? ?? 04 90 04 9B 1A 68 0F 9B 13 44 01 93 0F 9B 00 2B 2A D9 00 22 01 99 0C 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 1F D0 0D 98 ?? ?? ?? ?? 05 90 0C 98 ?? ?? ?? ?? 07 90 0C 98 ?? ?? ?? ?? 06 90 0F 9A 0E 99 02 23 01 FB 03 F1 05 9B 19 44 06 9B 18 68 02 23 00 FB 03 F0 07 9B 18 44 ?? ?? ?? ?? 01 99 0C 98 ?? ?? ?? ?? 0C 9B 08 93 08 98 0A B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_76_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_WI@Z"
		size = 208
		refs = "000e ?_Inside@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NPB_W@Z 0020 ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAPA_WXZ 0034 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z 0042 ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAIXZ 005a ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ 007c ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 00ae ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z 00b6 ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z 00cc ?npos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@2IB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0D 99 0C 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 10 D0 0C 98 ?? ?? ?? ?? 03 90 0E 9B 0D 99 03 9A 8A 1A 52 10 0C 99 0C 98 ?? ?? ?? ?? 04 90 04 9B 02 93 3E E0 0C 98 ?? ?? ?? ?? 05 90 20 4B 1A 68 05 9B 1B 68 D2 1A 0E 9B 9A 42 02 D8 0C 98 ?? ?? ?? ?? 0C 98 ?? ?? ?? ?? 06 90 06 9B 1A 68 0E 9B 13 44 01 93 0E 9B 00 2B 21 D9 00 22 01 99 0C 98 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 16 D0 0C 98 ?? ?? ?? ?? 08 90 0C 98 ?? ?? ?? ?? 07 90 0E 9A 0D 99 07 9B 18 68 02 23 00 FB 03 F0 08 9B 18 44 ?? ?? ?? ?? 01 99 0C 98 ?? ?? ?? ?? 0C 9B 02 93 02 98 0A B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_77_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 148
		refs = "000e ?_Check_offset@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXI@Z 0018 ?_Clamp_suffix_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAIII@Z 0032 ?erase@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I@Z 003c ?erase@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@II@Z 0048 ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 005a ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAPB_WXZ 0062 ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAPA_WXZ 0078 ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z 0080 ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 0A 99 09 98 ?? ?? ?? ?? 0B 9A 0A 99 09 98 ?? ?? ?? ?? 01 90 01 9B 0B 93 08 9A 09 9B 9A 42 0B D1 0A 9A 0B 9B D1 18 08 98 ?? ?? ?? ?? 0A 9A 00 21 08 98 ?? ?? ?? ?? 20 E0 00 22 0B 99 08 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 15 D0 09 98 ?? ?? ?? ?? 02 90 08 98 ?? ?? ?? ?? 03 90 0B 9A 0A 99 02 23 01 FB 03 F1 02 9B 19 44 03 98 ?? ?? ?? ?? 0B 99 08 98 ?? ?? ?? ?? 08 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_912_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z"
		size = 148
		refs = "000e ?_Check_offset@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXI@Z 0018 ?_Clamp_suffix_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAIII@Z 0032 ?erase@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@I@Z 003c ?erase@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@II@Z 0048 ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 005a ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAPBGXZ 0062 ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAPAGXZ 0078 ?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z 0080 ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 0A 99 09 98 ?? ?? ?? ?? 0B 9A 0A 99 09 98 ?? ?? ?? ?? 01 90 01 9B 0B 93 08 9A 09 9B 9A 42 0B D1 0A 9A 0B 9B D1 18 08 98 ?? ?? ?? ?? 0A 9A 00 21 08 98 ?? ?? ?? ?? 20 E0 00 22 0B 99 08 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 15 D0 09 98 ?? ?? ?? ?? 02 90 08 98 ?? ?? ?? ?? 03 90 0B 9A 0A 99 02 23 01 FB 03 F1 02 9B 19 44 03 98 ?? ?? ?? ?? 0B 99 08 98 ?? ?? ?? ?? 08 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_79_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_WI@Z"
		size = 128
		refs = "000e ?_Inside@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NPB_W@Z 0020 ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAPA_WXZ 0034 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@ABV12@II@Z 0046 ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 0064 ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z 006c ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 09 99 08 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 10 D0 08 98 ?? ?? ?? ?? 02 90 0A 9B 09 99 02 9A 8A 1A 52 10 08 99 08 98 ?? ?? ?? ?? 03 90 03 9B 01 93 19 E0 00 22 0A 99 08 98 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 0C D0 08 98 ?? ?? ?? ?? 04 90 0A 9A 09 99 04 98 ?? ?? ?? ?? 0A 99 08 98 ?? ?? ?? ?? 08 9B 01 93 01 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_915_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@PBGI@Z"
		size = 128
		refs = "000e ?_Inside@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NPBG@Z 0020 ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAPAGXZ 0034 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@ABV12@II@Z 0046 ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 0064 ?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z 006c ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 09 99 08 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 10 D0 08 98 ?? ?? ?? ?? 02 90 0A 9B 09 99 02 9A 8A 1A 52 10 08 99 08 98 ?? ?? ?? ?? 03 90 03 9B 01 93 19 E0 00 22 0A 99 08 98 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 0C D0 08 98 ?? ?? ?? ?? 04 90 0A 9A 09 99 04 98 ?? ?? ?? ?? 0A 99 08 98 ?? ?? ?? ?? 08 9B 01 93 01 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_80_1 {
	meta:
		name = "?assign@?$char_traits@_W@std@@SAXAA_WAB_W@Z"
		size = 24
		altNames = "?assign@?$char_traits@G@std@@SAXAAGABG@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 9B 1A 88 02 9B 1A 80 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_81_1 {
	meta:
		name = "?back@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAA_WXZ"
		size = 56
		refs = "000e ?end@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ 001a ??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBA?AV01@H@Z 0022 ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBAAA_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 04 A9 08 98 ?? ?? ?? ?? 00 90 01 22 05 A9 00 98 ?? ?? ?? ?? 01 90 01 98 ?? ?? ?? ?? 02 90 02 9B 03 93 03 98 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_85_1 {
	meta:
		name = "?deallocate@?$allocator@_W@std@@QAAXPA_WI@Z"
		size = 26
		refs = "000e ?_Deallocate@std@@YAXPAXII@Z"
		altNames = "?deallocate@?$allocator@G@std@@QAAXPAGI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 02 22 04 99 03 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_87_1 {
	meta:
		name = "?end@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@XZ"
		size = 100
		refs = "0018 ?_Get_data@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@_W@std@@@2@XZ 0024 ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QAAPA_WXZ 002c ?_Getal@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@XZ 0036 ?address@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QBAPA_WAA_W@Z 0050 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAA@PA_WPBU_Container_base0@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 38 6B ?? ?? ?? ?? 78 60 7B 68 3B 60 38 68 ?? ?? ?? ?? B8 60 38 6B ?? ?? ?? ?? F8 60 B9 68 F8 68 ?? ?? ?? ?? 38 61 3A 68 3B 68 10 33 19 68 02 23 01 FB 03 F1 3B 69 19 44 78 6B ?? ?? ?? ?? 7B 6B 7B 61 78 69 09 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_55_1153_1 {
	meta:
		name = "?end@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@XZ"
		size = 100
		refs = "0018 ?_Get_data@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAV?$_String_val@U?$_Simple_types@G@std@@@2@XZ 0024 ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QAAPAGXZ 002c ?_Getal@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@XZ 0036 ?address@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QBAPAGAAG@Z 0050 ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAA@PAGPBU_Container_base0@1@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 38 6B ?? ?? ?? ?? 78 60 7B 68 3B 60 38 68 ?? ?? ?? ?? B8 60 38 6B ?? ?? ?? ?? F8 60 B9 68 F8 68 ?? ?? ?? ?? 38 61 3A 68 3B 68 10 33 19 68 02 23 01 FB 03 F1 3B 69 19 44 78 6B ?? ?? ?? ?? 7B 6B 7B 61 78 69 09 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_16_89_1 {
	meta:
		name = "?erase@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@II@Z"
		size = 144
		refs = "000e ?_Check_offset@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXI@Z 0014 ?_Mysize@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAAAIXZ 002c ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z 003a ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAPA_WXZ 0074 ?move@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 09 99 08 98 ?? ?? ?? ?? 08 98 ?? ?? ?? ?? 02 90 02 9B 1A 68 09 9B D2 1A 0A 9B 9A 42 04 D8 09 99 08 98 ?? ?? ?? ?? 26 E0 0A 9B 00 2B 23 D9 08 98 ?? ?? ?? ?? 03 90 09 9A 02 23 02 FB 03 F2 03 9B 13 44 00 93 08 98 ?? ?? ?? ?? 04 90 04 9B 1A 68 0A 9B D3 1A 01 93 01 9A 09 9B D2 1A 0A 99 02 23 01 FB 03 F1 00 9B 19 44 00 98 ?? ?? ?? ?? 01 99 08 98 ?? ?? ?? ?? 08 9B 05 93 05 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_1164_1 {
	meta:
		name = "?erase@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@II@Z"
		size = 144
		refs = "000e ?_Check_offset@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXI@Z 0014 ?_Mysize@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAAAIXZ 002c ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z 003a ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAPAGXZ 0074 ?move@?$char_traits@G@std@@SAPAGPAGPBGI@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 09 99 08 98 ?? ?? ?? ?? 08 98 ?? ?? ?? ?? 02 90 02 9B 1A 68 09 9B D2 1A 0A 9B 9A 42 04 D8 09 99 08 98 ?? ?? ?? ?? 26 E0 0A 9B 00 2B 23 D9 08 98 ?? ?? ?? ?? 03 90 09 9A 02 23 02 FB 03 F2 03 9B 13 44 00 93 08 98 ?? ?? ?? ?? 04 90 04 9B 1A 68 0A 9B D3 1A 01 93 01 9A 09 9B D2 1A 0A 99 02 23 01 FB 03 F1 00 9B 19 44 00 98 ?? ?? ?? ?? 01 99 08 98 ?? ?? ?? ?? 08 9B 05 93 05 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_90_1 {
	meta:
		name = "?length@?$char_traits@_W@std@@SAIPB_W@Z"
		size = 76
		altNames = "?length@?$char_traits@G@std@@SAIPBG@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 1B 88 00 2B 02 D1 00 23 01 93 11 E0 06 9B 00 93 00 9B B3 F9 00 30 00 2B 03 D0 00 9B 9B 1C 00 93 F6 E7 00 9A 06 9B D3 1A 5B 10 02 93 02 9B 01 93 01 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_92_1 {
	meta:
		name = "?max_size@?$allocator@_W@std@@QBAIXZ"
		size = 28
		altNames = "?max_size@?$allocator@G@std@@QBAIXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 6F F0 00 43 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_97_1 {
	meta:
		name = "_Chmod"
		size = 176
		refs = "0008 __security_push_cookie 003c ??Uv1@filesystem@experimental@std@@YA?AW4perms@0123@W440123@0@Z 0050 ??Iv1@filesystem@experimental@std@@YA?AW4perms@0123@W440123@0@Z 009c __security_pop_cookie 00a8 __imp_SetFileAttributesW 00ac __imp_GetFileAttributesExW"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 93 B0 0A AA 00 21 16 98 25 4B 1B 68 98 47 05 90 05 9B 00 2B 04 D1 6F F0 00 03 04 93 36 E0 35 E0 0A 9B 01 93 01 9B 23 F0 01 03 00 93 10 21 80 20 ?? ?? ?? ?? 06 90 02 21 06 98 ?? ?? ?? ?? 07 90 07 99 17 98 ?? ?? ?? ?? 08 90 08 9B 00 2B 03 D1 00 9B 43 F0 01 03 00 93 00 9A 01 9B 9A 42 02 D1 00 23 03 93 10 E0 00 99 16 98 0C 4B 1B 68 98 47 09 90 09 9B 00 2B 02 D0 00 23 02 93 02 E0 6F F0 00 03 02 93 02 9B 03 93 03 9B 04 93 04 98 13 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_99_1 {
	meta:
		name = "_Copy_file"
		size = 72
		refs = "0040 __imp_GetLastError 0044 __imp_CopyFileW"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 00 22 07 99 06 98 0C 4B 1B 68 98 47 01 90 01 9B 00 2B 02 D0 00 23 00 93 05 E0 06 4B 1B 68 98 47 02 90 02 9B 00 93 00 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_100_1 {
	meta:
		name = "_Current_get"
		size = 72
		refs = "000e ?_Strcpy@v1@filesystem@experimental@std@@YAPA_WAAY0BAE@_WPB_W@Z 0018 _wgetcwd 0044 ??_C@_11LOCGONAA@?$AA?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 0E 49 06 98 ?? ?? ?? ?? 4F F4 82 71 06 98 ?? ?? ?? ?? 01 90 01 9B 00 2B 02 D0 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_102_1 {
	meta:
		name = "_Equivalent"
		size = 308
		refs = "0008 __security_push_cookie 0018 memset 003e ?_FilesysOpenFile@v1@filesystem@experimental@std@@YAPAXPB_WKK@Z 011e __security_pop_cookie 012c __imp_CloseHandle 0130 __imp_GetFileInformationByHandle"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? A5 B0 00 23 0A 93 30 22 00 21 0B A8 ?? ?? ?? ?? 00 23 18 93 30 22 00 21 19 A8 ?? ?? ?? ?? 00 23 8D F8 00 30 00 23 8D F8 01 30 4F F0 00 72 80 21 28 98 ?? ?? ?? ?? 06 90 06 9B 01 93 01 9B B3 F1 FF 3F 15 D0 0A A9 01 98 36 4B 1B 68 98 47 07 90 07 9B 00 2B 02 D0 01 23 03 93 01 E0 00 23 03 93 03 9B DB B2 8D F8 00 30 01 98 2D 4B 1B 68 98 47 4F F0 00 72 80 21 29 98 ?? ?? ?? ?? 08 90 08 9B 01 93 01 9B B3 F1 FF 3F 15 D0 18 A9 01 98 25 4B 1B 68 98 47 09 90 09 9B 00 2B 02 D0 01 23 04 93 01 E0 00 23 04 93 04 9B DB B2 8D F8 01 30 01 98 1B 4B 1B 68 98 47 9D F8 00 30 00 2B 08 D1 9D F8 01 30 00 2B 04 D1 6F F0 00 03 02 93 1F E0 1E E0 9D F8 00 30 00 2B 03 D0 9D F8 01 30 00 2B 03 D1 00 23 02 93 13 E0 12 E0 11 9A 1F 9B 9A 42 0A D1 15 9A 23 9B 9A 42 06 D1 16 9A 24 9B 9A 42 02 D1 01 23 05 93 01 E0 00 23 05 93 05 9B 02 93 02 98 25 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_103_1 {
	meta:
		name = "_File_size"
		size = 80
		refs = "0008 __security_push_cookie 0040 __security_pop_cookie 004c __imp_GetFileAttributesExW"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 8D B0 04 AA 00 21 10 98 0D 4B 1B 68 98 47 02 90 02 9B 00 2B 07 D1 6F F0 00 03 00 93 6F F0 00 03 01 93 04 E0 03 E0 0B 9A 0C 9B 00 93 01 92 00 98 01 99 0D B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_104_1 {
	meta:
		name = "_Hard_links"
		size = 168
		refs = "0008 __security_push_cookie 0016 ?_FilesysOpenFile@v1@filesystem@experimental@std@@YAPAXPB_WKK@Z 002a memset 0094 __security_pop_cookie 00a0 __imp_CloseHandle 00a4 __imp_GetFileInformationByHandle"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 97 B0 4F F0 00 72 80 21 1A 98 ?? ?? ?? ?? 06 90 06 9B 01 93 00 23 0A 93 30 22 00 21 0B A8 ?? ?? ?? ?? 00 23 8D F8 00 30 01 9B B3 F1 FF 3F 15 D0 0A A9 01 98 18 4B 1B 68 98 47 07 90 07 9B 00 2B 02 D0 01 23 02 93 01 E0 00 23 02 93 02 9B DB B2 8D F8 00 30 01 98 0F 4B 1B 68 98 47 9D F8 00 30 00 2B 04 D0 14 9B 04 93 00 23 05 93 05 E0 6F F0 00 03 04 93 6F F0 00 03 05 93 04 9A 05 9B 08 92 09 93 08 98 09 99 17 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_105_1 {
	meta:
		name = "_Last_write_time"
		size = 108
		refs = "0008 __security_push_cookie 0052 __security_pop_cookie 0068 __imp_GetFileAttributesExW"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 8F B0 06 AA 00 21 12 98 14 4B 1B 68 98 47 02 90 02 9B 00 2B 07 D1 6F F0 00 03 00 93 6F F0 00 03 01 93 0D E0 0C E0 0C 9A 0B 9B 04 93 05 92 04 98 05 99 09 4A 07 4B 82 1A 61 EB 03 03 00 92 01 93 00 98 01 99 0F B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB FE DE DE B1 9D 01 00 80 3E D5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_106_1 {
	meta:
		name = "_Link"
		size = 72
		refs = "0040 __imp_GetLastError 0044 __imp_CreateHardLinkW"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 00 22 06 99 07 98 0C 4B 1B 68 98 47 01 90 01 9B 00 2B 02 D0 00 23 00 93 05 E0 06 4B 1B 68 98 47 02 90 02 9B 00 93 00 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_108_1 {
	meta:
		name = "_Make_dir"
		size = 88
		refs = "0050 __imp_GetLastError 0054 __imp_CreateDirectoryW"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 00 21 06 98 11 4B 1B 68 98 47 01 90 01 9B 02 93 02 9B 00 2B 03 D0 01 23 00 93 0E E0 0D E0 09 4B 1B 68 98 47 03 90 03 9B B7 2B 03 D1 00 23 00 93 03 E0 02 E0 6F F0 00 03 00 93 00 98 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_109_1 {
	meta:
		name = "_Open_dir"
		size = 300
		refs = "000a __security_push_cookie 0016 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@PB_W@Z 001c ?empty@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBA_NXZ 0030 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_W@Z 0036 ?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAPB_WXZ 0072 ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ 00b0 _Read_dir 00d0 _Close_dir 00ea ?_Strcpy@v1@filesystem@experimental@std@@YAPA_WAAY0BAE@_WPB_W@Z 00f0 ?_Map_mode@v1@filesystem@experimental@std@@YA?AW4file_type@1234@H@Z 0118 __security_pop_cookie 0124 __imp_FindFirstFileExW 0128 ??_C@_15PKPONJIK@?$AA?2?$AA?$CK?$AA?$AA@"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? AD F5 26 7D AB 99 0C A8 ?? ?? ?? ?? 0C A8 ?? ?? ?? ?? 8D F8 08 00 9D F8 08 30 00 2B 03 D1 3E 49 0C A8 ?? ?? ?? ?? 0C A8 ?? ?? ?? ?? 05 90 00 23 01 93 00 23 00 93 00 23 12 AA 00 21 05 98 35 4C 24 68 A0 47 06 90 06 9B 03 93 03 9B B3 F1 FF 3F 0E D1 AC 9A A1 23 13 60 AA 9A 00 23 13 80 00 23 07 93 0C A8 ?? ?? ?? ?? 07 9B 04 93 4A E0 46 E0 AC 9A 00 23 13 60 1D AB 1B 88 2E 2B 2C D1 1D AB 9B 1C 1B 88 00 2B 09 D0 1D AB 9B 1C 1B 88 2E 2B 22 D1 1D AB 1B 1D 1B 88 00 2B 1D D1 AD 9A 03 99 AA 98 ?? ?? ?? ?? AA 9B 1B 88 00 2B 08 D0 03 9B 08 93 0C A8 ?? ?? ?? ?? 08 9B 04 93 22 E0 0A E0 03 98 ?? ?? ?? ?? 00 23 09 93 0C A8 ?? ?? ?? ?? 09 9B 04 93 16 E0 12 E0 1D A9 AA 98 ?? ?? ?? ?? 12 98 ?? ?? ?? ?? 0A 90 0A 9A AD 9B 1A 60 03 9B 0B 93 0C A8 ?? ?? ?? ?? 0B 9B 04 93 02 E0 0C A8 ?? ?? ?? ?? 04 98 0D F5 26 7D ?? ?? ?? ?? BD E8 10 08 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_110_1 {
	meta:
		name = "_Read_dir"
		size = 156
		refs = "0008 __security_push_cookie 002c ?_Strcpy@v1@filesystem@experimental@std@@YAPA_WAAY0BAE@_WPB_W@Z 0064 ?_Map_mode@v1@filesystem@experimental@std@@YA?AW4file_type@1234@H@Z 0088 __security_pop_cookie 0094 ??_C@_11LOCGONAA@?$AA?$AA@ 0098 __imp_FindNextFileW"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? AD F5 1B 7D 06 A9 9F 98 20 4B 1B 68 98 47 01 90 01 9B 00 2B 0B D1 A0 9A 08 23 13 60 1A 49 9E 98 ?? ?? ?? ?? 02 90 02 9B 00 93 24 E0 22 E0 11 AB 1B 88 2E 2B 0F D1 11 AB 9B 1C 1B 88 00 2B 09 D0 11 AB 9B 1C 1B 88 2E 2B 05 D1 11 AB 1B 1D 1B 88 00 2B 00 D1 0E E0 06 98 ?? ?? ?? ?? 03 90 03 9A A0 9B 1A 60 11 A9 9E 98 ?? ?? ?? ?? 04 90 04 9B 00 93 00 E0 C6 E7 00 98 0D F5 1B 7D ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_111_1 {
	meta:
		name = "_Remove_dir"
		size = 58
		refs = "000c _wrmdir"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 01 90 01 9B B3 F1 FF 3F 02 D0 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_112_1 {
	meta:
		name = "_Rename"
		size = 64
		refs = "000e _wrename 003c __imp_GetLastError"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 99 06 98 ?? ?? ?? ?? 01 90 01 9B 00 2B 02 D1 00 23 00 93 05 E0 06 4B 1B 68 98 47 02 90 02 9B 00 93 00 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_113_1 {
	meta:
		name = "_Resize"
		size = 180
		refs = "0016 ?_FilesysOpenFile@v1@filesystem@experimental@std@@YAPAXPB_WKK@Z 00a0 __imp_GetLastError 00a4 __imp_CloseHandle 00a8 __imp_SetEndOfFile 00ac __imp_SetFilePointerEx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8E B0 00 23 8D F8 08 30 00 22 27 49 10 98 ?? ?? ?? ?? 06 90 06 9B 03 93 03 9B B3 F1 FF 3F 26 D0 12 9B 0C 93 13 9B 0D 93 00 23 01 93 00 23 00 93 0C 9A 0D 9B 03 98 1B 49 09 68 88 47 07 90 07 9B 00 2B 0A D0 03 98 16 4B 1B 68 98 47 08 90 08 9B 00 2B 02 D0 01 23 04 93 01 E0 00 23 04 93 04 9B DB B2 8D F8 08 30 03 98 0C 4B 1B 68 98 47 9D F8 08 30 00 2B 02 D0 00 23 05 93 05 E0 06 4B 1B 68 98 47 09 90 09 9B 05 93 05 9B 0A 93 0A 98 0E B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 16 01 12 00 }
	condition:
		$1
}

rule file_16_114_1 {
	meta:
		name = "_Set_last_write_time"
		size = 196
		refs = "000a __security_push_cookie 001a ?_FilesysOpenFile@v1@filesystem@experimental@std@@YAPAXPB_WKK@Z 00a2 __security_pop_cookie 00b0 __imp_CloseHandle 00b4 __imp_SetFileInformationByHandle 00c0 __imp_GetFileInformationByHandleEx"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? 92 B0 4F F0 00 72 4F F4 80 71 16 98 ?? ?? ?? ?? 02 90 02 9B 00 93 00 9B B3 F1 FF 3F 02 D1 00 23 01 93 35 E0 28 23 08 AA 00 21 00 98 21 4C 24 68 A0 47 03 90 03 9B 00 2B 06 D1 00 98 19 4B 1B 68 98 47 00 23 01 93 23 E0 18 98 19 99 18 4A 16 4B 12 18 4B 41 06 92 07 93 06 9B 0C 93 07 9B 0D 93 28 23 08 AA 00 21 00 98 0F 4C 24 68 A0 47 04 90 04 9B 00 2B 06 D1 00 98 0A 4B 1B 68 98 47 00 23 01 93 05 E0 00 98 06 4B 1B 68 98 47 01 23 01 93 01 98 12 B0 ?? ?? ?? ?? BD E8 10 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? DE B1 9D 01 00 80 3E D5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_115_1 {
	meta:
		name = "_Stat"
		size = 216
		refs = "0008 __security_push_cookie 0034 ??Uv1@filesystem@experimental@std@@YA?AW4perms@0123@W440123@0@Z 0046 ??Sv1@filesystem@experimental@std@@YA?AW4perms@0123@W440123@@Z 0052 ??Iv1@filesystem@experimental@std@@YA?AW4perms@0123@W440123@0@Z 006c ?_Map_mode@v1@filesystem@experimental@std@@YA?AW4file_type@1234@H@Z 00c2 __security_pop_cookie 00d0 __imp_GetLastError 00d4 __imp_GetFileAttributesExW"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 93 B0 0A AA 00 21 16 98 2F 4B 1B 68 98 47 03 90 03 9B 00 2B 2B D0 17 9B 00 2B 20 D0 0A 9B 13 F0 01 0F 16 D0 10 21 80 20 ?? ?? ?? ?? 04 90 02 21 04 98 ?? ?? ?? ?? 05 90 05 98 ?? ?? ?? ?? 06 90 06 99 40 F2 FF 10 ?? ?? ?? ?? 07 90 07 9B 02 93 02 E0 40 F2 FF 13 02 93 02 9A 17 9B 1A 60 0A 98 ?? ?? ?? ?? 08 90 08 9B 01 93 22 E0 21 E0 15 4B 1B 68 98 47 09 90 09 9B 00 93 00 9B 35 2B 11 D0 00 9B A1 2B 0E D0 00 9B 02 2B 0B D0 00 9B 0F 2B 08 D0 00 9B 7B 2B 05 D0 00 9B 57 2B 02 D0 00 9B 03 2B 04 D1 6F F0 00 03 01 93 02 E0 01 E0 08 23 01 93 01 98 13 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_116_1 {
	meta:
		name = "_Statvfs"
		size = 260
		refs = "000a __security_push_cookie 0038 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@PB_W@Z 003e ?empty@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBA_NXZ 0050 ?back@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAA_WXZ 0072 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@PB_W@Z 0078 ?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAPB_WXZ 00b2 memcpy 00b8 ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ 00f0 __security_pop_cookie 00fc __imp_GetDiskFreeSpaceExW 0100 ??_C@_13CGOKJPIL@?$AA?1?$AA?$AA@"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? A7 B0 6F F0 00 03 14 93 6F F0 00 03 15 93 6F F0 00 03 16 93 6F F0 00 03 17 93 6F F0 00 03 18 93 6F F0 00 03 19 93 2D 99 1A A8 ?? ?? ?? ?? 1A A8 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0F D1 1A A8 ?? ?? ?? ?? 03 90 03 9B 1B 88 2F 2B 0B D0 1A A8 ?? ?? ?? ?? 04 90 04 9B 1B 88 5C 2B 03 D0 24 49 1A A8 ?? ?? ?? ?? 1A A8 ?? ?? ?? ?? 05 90 0A AB 08 AA 0C A9 05 98 1D 4C 24 68 A0 47 06 90 06 9B 00 2B 0B D0 08 9B 14 93 09 9B 15 93 0A 9B 16 93 0B 9B 17 93 0C 9B 18 93 0D 9B 19 93 20 A8 14 A9 18 22 ?? ?? ?? ?? 1A A8 ?? ?? ?? ?? 2C 9A 20 AB 01 92 02 93 01 9D 02 9C 94 E8 0F 00 85 E8 0F 00 02 9B 10 33 02 93 01 9B 10 33 01 93 01 98 02 99 91 E8 0C 00 80 E8 0C 00 2C 9B 0E 93 0E 98 27 B0 ?? ?? ?? ?? BD E8 30 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_117_1 {
	meta:
		name = "_Symlink"
		size = 76
		refs = "0044 __imp_GetLastError 0048 __imp_CreateSymbolicLinkW"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 00 22 06 99 07 98 0D 4B 1B 68 98 47 8D F8 00 00 9D F8 00 30 00 2B 02 D0 00 23 01 93 05 E0 06 4B 1B 68 98 47 02 90 02 9B 01 93 01 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_118_1 {
	meta:
		name = "_Symlink_get"
		size = 32
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 00 23 13 80 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_16_119_1 {
	meta:
		name = "_Temp_get"
		size = 88
		refs = "0008 __security_push_cookie 0032 ?_Strcpy@v1@filesystem@experimental@std@@YAPA_WAAY0BAE@_WPB_W@Z 0042 __security_pop_cookie 0050 ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 0054 __imp_GetTempPathW"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? AD F5 07 7D 04 A9 4F F4 82 70 0F 4B 1B 68 98 47 01 90 01 9B 00 2B 02 D1 0A 4B 00 93 01 E0 04 AB 00 93 00 99 8A 98 ?? ?? ?? ?? 02 90 02 9B 03 93 03 98 0D F5 07 7D ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_120_1 {
	meta:
		name = "_To_byte"
		size = 76
		refs = "000c ?_Filesys_code_page@v1@filesystem@experimental@std@@YAIXZ 0048 __imp_WideCharToMultiByte"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 87 B0 ?? ?? ?? ?? 04 90 00 23 03 93 00 23 02 93 4F F4 82 73 01 93 0B 9B 00 93 6F F0 00 03 0A 9A 00 21 04 98 06 4C 24 68 A0 47 05 90 05 9B 06 93 06 98 07 B0 BD E8 10 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_121_1 {
	meta:
		name = "_To_wide"
		size = 68
		refs = "000c ?_Filesys_code_page@v1@filesystem@experimental@std@@YAIXZ 0040 __imp_MultiByteToWideChar"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 85 B0 ?? ?? ?? ?? 02 90 4F F4 82 73 01 93 09 9B 00 93 6F F0 00 03 08 9A 00 21 02 98 06 4C 24 68 A0 47 03 90 03 9B 04 93 04 98 05 B0 BD E8 10 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_122_1 {
	meta:
		name = "_Unlink"
		size = 64
		refs = "000c _wremove 003c __imp_GetLastError"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 01 90 01 9B 00 2B 02 D1 00 23 00 93 05 E0 07 4B 1B 68 98 47 02 90 02 9B 00 93 00 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_123_1 {
	meta:
		name = "wmemcpy"
		size = 44
		refs = "0016 memcpy"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 02 23 02 FB 03 F2 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_16_124_1 {
	meta:
		name = "wmemmove"
		size = 44
		refs = "0016 memmove"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9A 02 23 02 FB 03 F2 05 99 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_17_0_1 {
	meta:
		name = "_WStoflt"
		size = 900
		refs = "0008 __security_push_cookie 0064 iswctype 00a2 localeconv 00b0 btowc 01da __report_rangecheckfailure 01f8 __rt_sdiv 0372 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? A1 B0 00 23 01 93 28 9A 09 23 02 FB 03 F3 28 93 28 9B 2D 2B 01 DD 2D 23 28 93 27 9A 00 23 13 60 27 9B 1A 1D 00 23 13 60 00 23 02 93 04 E0 25 9B 9B 1C 25 93 01 23 02 93 25 9B 1B 88 30 2B 00 D1 F5 E7 00 23 00 93 04 E0 25 9B 9B 1C 25 93 01 23 02 93 04 21 25 9B 18 88 ?? ?? ?? ?? 0D 90 0D 9B 00 2B 18 D0 00 9A 28 9B 9A 42 0E DC 25 9B 1B 88 30 3B 59 B2 00 9A 01 23 02 FB 03 F2 14 AB 13 44 19 70 00 9B 5B 1C 00 93 04 E0 27 9B 1B 68 5A 1C 27 9B 1A 60 D8 E7 ?? ?? ?? ?? 0E 90 0E 9B 1B 68 93 F9 00 00 ?? ?? ?? ?? AD F8 18 00 25 9B 1A 88 BD F8 18 30 9A 42 02 D1 25 9B 9B 1C 25 93 00 9B 00 2B 0F D1 04 E0 25 9B 9B 1C 25 93 01 23 02 93 25 9B 1B 88 30 2B 05 D1 27 9B 1B 68 5A 1E 27 9B 1A 60 F0 E7 04 E0 25 9B 9B 1C 25 93 01 23 02 93 04 21 25 9B 18 88 ?? ?? ?? ?? 0F 90 0F 9B 00 2B 17 D0 00 9A 28 9B 9A 42 12 DC 25 9B 1B 88 30 3B 59 B2 00 9A 01 23 02 FB 03 F2 14 AB 13 44 19 70 00 9B 5B 1C 00 93 27 9B 1B 68 5A 1E 27 9B 1A 60 D9 E7 28 9A 00 9B 9A 42 25 DA 28 9B 07 93 07 9A 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 30 05 2B 12 DB 07 9B 5A 1E 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 30 5B 1C 59 B2 07 9B 5A 1E 01 23 02 FB 03 F2 14 AB 13 44 19 70 28 9B 00 93 27 9B 1B 68 5A 1C 27 9B 1A 60 02 E0 00 9B 5B 1E 00 93 00 9B 00 2B 10 DD 00 9B 5A 1E 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 30 00 2B 05 D1 27 9B 1B 68 5A 1C 27 9B 1A 60 E8 E7 00 9B 00 2B 0F D1 00 9B 08 93 00 9B 5B 1C 00 93 08 9B 2E 2B 00 D2 01 E0 ?? ?? ?? ?? 14 AA 08 9B 1A 44 00 23 13 70 02 9B 00 2B 00 F0 AA 80 00 23 04 93 00 99 09 20 ?? ?? ?? ?? C1 F1 09 03 05 93 05 99 09 20 ?? ?? ?? ?? 00 29 02 D1 00 23 09 93 01 E0 01 23 09 93 09 9B 01 93 05 E0 05 9B 5B 1C 05 93 04 9B 5B 1C 04 93 04 9A 00 9B 9A 42 33 DA 05 99 09 20 ?? ?? ?? ?? 00 29 12 D1 01 9B 5B 1C 01 93 04 9A 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 10 01 9A 04 23 02 FB 03 F2 27 9B 13 44 19 60 19 E0 01 9A 04 23 02 FB 03 F2 27 9B 13 44 1A 68 0A 23 02 FB 03 F1 04 9A 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 30 19 44 01 9A 04 23 02 FB 03 F2 27 9B 13 44 19 60 C1 E7 25 9B 1B 88 65 2B 03 D0 25 9B 1B 88 45 2B 4C D1 25 9B 11 93 25 9B 9B 1C 25 93 25 9B 1B 88 2B 2B 06 D0 25 9B 1B 88 2D 2B 02 D0 2B 23 0A 93 05 E0 25 9B 1B 88 0A 93 25 9B 9B 1C 25 93 0A 9B 9B B2 AD F8 1A 30 00 23 0B 93 00 23 03 93 04 E0 25 9B 9B 1C 25 93 01 23 0B 93 04 21 25 9B 18 88 ?? ?? ?? ?? 10 90 10 9B 00 2B 0D D0 03 9A 1E 4B 9A 42 08 DA 03 9A 0A 23 02 FB 03 F2 25 9B 1B 88 13 44 30 3B 03 93 E3 E7 BD F8 1A 30 2D 2B 02 D1 03 9B 5B 42 03 93 27 9B 1A 68 03 9B 1A 44 27 9B 1A 60 0B 9B 00 2B 01 D1 11 9B 25 93 02 9B 00 2B 01 D1 00 23 01 93 26 9B 00 2B 0A D0 02 9B 00 2B 02 D0 25 9B 0C 93 01 E0 24 9B 0C 93 0C 9A 26 9B 1A 60 01 9B 12 93 12 98 21 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB FE DE 00 E1 F5 05 }
	condition:
		$1
}

rule file_18_0_1 {
	meta:
		name = "_FDnorm"
		size = 302
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 9B 1C 1B 88 03 F4 00 43 9B B2 AD F8 04 30 01 23 AD F8 00 30 06 9B 9B 1C 1B 88 03 F0 7F 03 9B B2 AD F8 02 30 06 9B 9A 1C BD F8 02 30 13 80 BD F8 02 30 00 2B 03 D1 06 9B 1B 88 00 2B 5B D0 06 9B 9B 1C 1B 88 00 2B 0D D1 06 99 06 9B 9A 1C 0B 88 13 80 06 9A 00 23 13 80 BD F9 00 30 10 3B 1B B2 AD F8 00 30 05 E0 BD F9 00 30 5B 1E 1B B2 AD F8 00 30 06 9B 9B 1C 1B 88 80 2B 12 DA 06 9B 9B 1C 1B 88 5A 00 06 9B 1B 88 DB 13 13 43 9A B2 06 9B 9B 1C 1A 80 06 9B 1B 88 5B 00 9A B2 06 9B 1A 80 E1 E7 05 E0 BD F9 00 30 5B 1C 1B B2 AD F8 00 30 06 9B 9B 1C 1B 88 B3 F5 80 7F 13 DB 06 9B 1B 88 5A 10 06 9B 9B 1C 1B 88 DB 03 13 43 9A B2 06 9B 1A 80 06 9B 9B 1C 1B 88 5B 08 9A B2 06 9B 9B 1C 1A 80 DF E7 06 9B 9B 1C 1B 88 03 F0 7F 01 06 9B 9A 1C 8B B2 13 80 06 9B 9B 1C BD F8 04 20 1B 88 43 EA 02 01 06 9B 9A 1C 8B B2 13 80 BD F9 00 30 AD F8 08 30 BD F9 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_19_0_1 {
	meta:
		name = "_FDtento"
		size = 344
		refs = "0008 __security_push_cookie 0028 _FXp_getw 0048 _FXp_setw 005a _FXp_movx 0064 _FXp_ldexpx 007c _FXp_mulx 0118 _errno 0144 __security_pop_cookie 0150 _FInf 0154 tenth"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 99 B0 1D 9B 00 2B 07 D0 1C 9B 93 ED 00 0A B5 EE 40 0A F1 EE 10 FA 0A D1 04 21 1C 98 ?? ?? ?? ?? 8D ED 04 0A 9D ED 04 0A 8D ED 03 0A 81 E0 1D 9B 00 2B 06 DD B2 EE 04 0A 04 21 08 A8 ?? ?? ?? ?? 0C E0 1D 9B 5B 42 1D 93 3F 4A 04 21 08 A8 ?? ?? ?? ?? 30 22 04 21 1C 98 ?? ?? ?? ?? 1D 9B 13 F0 01 0F 07 D0 10 AB 00 93 04 23 08 AA 04 21 1C 98 ?? ?? ?? ?? 1D 9B 5B 10 1D 93 1D 9B 00 2B 00 D1 0D E0 08 AA 04 21 0C A8 ?? ?? ?? ?? 10 AB 00 93 04 23 0C AA 04 21 08 A8 ?? ?? ?? ?? DE E7 08 AB D3 ED 00 0A B7 EE 00 0A F4 EE C0 0A F1 EE 10 FA 05 D2 6F F0 2F 02 04 21 1C 98 ?? ?? ?? ?? 04 21 1C 98 ?? ?? ?? ?? 8D ED 05 0A 9D ED 05 0A 8D ED 02 0A 9D ED 02 0A B5 EE 40 0A F1 EE 10 FA 15 D0 DD ED 02 0A 17 4B 93 ED 00 0A F4 EE 40 0A F1 EE 10 FA 0B D0 13 4B 93 ED 00 0A F1 EE 40 0A 9D ED 02 0A B4 EE 60 0A F1 EE 10 FA 0E D1 ?? ?? ?? ?? 06 90 06 9A 22 23 13 60 1E 9B 00 2B 05 D0 1E 9B 1B 68 43 F0 01 02 1E 9B 1A 60 9D ED 02 0A 8D ED 03 0A 9D ED 03 0A 19 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_4_1 {
	meta:
		name = "??$_Fgetc@G@std@@YA_NAAGPAU_iobuf@@@Z"
		size = 78
		refs = "000c fgetwc"
		altNames = "??$_Fgetc@_W@std@@YA_NAA_WPAU_iobuf@@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 98 ?? ?? ?? ?? AD F8 02 00 BD F8 02 30 AD F8 00 30 BD F8 00 20 4F F6 FF 73 9A 42 04 D1 00 23 8D F8 04 30 07 E0 06 E0 BD F8 00 20 04 9B 1A 80 01 23 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_5_1 {
	meta:
		name = "??$_Fputc@G@std@@YA_NGPAU_iobuf@@@Z"
		size = 68
		refs = "0010 fputwc"
		altNames = "??$_Fputc@_W@std@@YA_N_WPAU_iobuf@@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 99 BD F8 18 00 ?? ?? ?? ?? AD F8 00 00 BD F8 00 20 4F F6 FF 73 9A 42 02 D0 01 23 01 93 01 E0 00 23 01 93 01 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_9_1 {
	meta:
		name = "??$_Ungetc@G@std@@YA_NABGPAU_iobuf@@@Z"
		size = 68
		refs = "0010 ungetwc"
		altNames = "??$_Ungetc@_W@std@@YA_NAB_WPAU_iobuf@@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 99 06 9B 18 88 ?? ?? ?? ?? AD F8 00 00 BD F8 00 20 4F F6 FF 73 9A 42 02 D0 01 23 01 93 01 E0 00 23 01 93 01 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_41_1 {
	meta:
		name = "??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 168
		refs = "002c ??0?$basic_ios@GU?$char_traits@G@std@@@std@@IAA@XZ 008a ?init@?$basic_ios@GU?$char_traits@G@std@@@std@@IAAXPAV?$basic_streambuf@GU?$char_traits@G@std@@@2@_N@Z 00a0 ??_7?$basic_istream@GU?$char_traits@G@std@@@std@@6B@ 00a4 ??_8?$basic_istream@GU?$char_traits@G@std@@@std@@7B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 00 23 3B 60 7B 6B 00 2B 0C D0 BA 6A 20 4B 13 60 BB 6A 03 F1 18 00 ?? ?? ?? ?? F8 60 3B 68 43 F0 01 03 3B 60 BB 6A 1B 68 1B 1D BA 6A 1B 68 1A 44 16 4B 13 60 BB 6A 1B 68 1B 1D 1B 68 A3 F1 18 01 BB 6A 1B 68 1B 1D BA 6A 1B 68 13 44 1B 1F 19 60 BB 6A 08 33 7B 60 7A 68 00 23 13 60 7A 68 00 23 53 60 97 F8 30 20 F9 6A BB 6A 1B 68 1B 1D B8 6A 1B 68 18 44 ?? ?? ?? ?? BB 6A BB 60 B8 68 07 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_41_1 {
	meta:
		name = "??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 168
		refs = "002c ??0?$basic_ios@DU?$char_traits@D@std@@@std@@IAA@XZ 008a ?init@?$basic_ios@DU?$char_traits@D@std@@@std@@IAAXPAV?$basic_streambuf@DU?$char_traits@D@std@@@2@_N@Z 00a0 ??_7?$basic_istream@DU?$char_traits@D@std@@@std@@6B@ 00a4 ??_8?$basic_istream@DU?$char_traits@D@std@@@std@@7B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 00 23 3B 60 7B 6B 00 2B 0C D0 BA 6A 20 4B 13 60 BB 6A 03 F1 18 00 ?? ?? ?? ?? F8 60 3B 68 43 F0 01 03 3B 60 BB 6A 1B 68 1B 1D BA 6A 1B 68 1A 44 16 4B 13 60 BB 6A 1B 68 1B 1D 1B 68 A3 F1 18 01 BB 6A 1B 68 1B 1D BA 6A 1B 68 13 44 1B 1F 19 60 BB 6A 08 33 7B 60 7A 68 00 23 13 60 7A 68 00 23 53 60 97 F8 30 20 F9 6A BB 6A 1B 68 1B 1D B8 6A 1B 68 18 44 ?? ?? ?? ?? BB 6A BB 60 B8 68 07 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_41_1 {
	meta:
		name = "??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 168
		refs = "002c ??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@IAA@XZ 008a ?init@?$basic_ios@_WU?$char_traits@_W@std@@@std@@IAAXPAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_N@Z 00a0 ??_7?$basic_istream@_WU?$char_traits@_W@std@@@std@@6B@ 00a4 ??_8?$basic_istream@_WU?$char_traits@_W@std@@@std@@7B@"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 00 23 3B 60 7B 6B 00 2B 0C D0 BA 6A 20 4B 13 60 BB 6A 03 F1 18 00 ?? ?? ?? ?? F8 60 3B 68 43 F0 01 03 3B 60 BB 6A 1B 68 1B 1D BA 6A 1B 68 1A 44 16 4B 13 60 BB 6A 1B 68 1B 1D 1B 68 A3 F1 18 01 BB 6A 1B 68 1B 1D BA 6A 1B 68 13 44 1B 1F 19 60 BB 6A 08 33 7B 60 7A 68 00 23 13 60 7A 68 00 23 53 60 97 F8 30 20 F9 6A BB 6A 1B 68 1B 1D B8 6A 1B 68 18 44 ?? ?? ?? ?? BB 6A BB 60 B8 68 07 B0 BD E8 80 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_42_1 {
	meta:
		name = "__unwindfunclet$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAA@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z$0"
		size = 34
		refs = "001c ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 09 80 3B 68 23 F0 01 03 3B 60 BB 6A 03 F1 18 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_28_42_1 {
	meta:
		name = "__unwindfunclet$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAA@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z$0"
		size = 34
		refs = "001c ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 09 80 3B 68 23 F0 01 03 3B 60 BB 6A 03 F1 18 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_53_42_1 {
	meta:
		name = "__unwindfunclet$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAA@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z$0"
		size = 34
		refs = "001c ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
	strings:
		$1 = { 10 B5 3B 68 03 F0 01 03 00 2B 00 F0 09 80 3B 68 23 F0 01 03 3B 60 BB 6A 03 F1 18 00 ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_20_61_1 {
	meta:
		name = "??0_Init_ushcin@std@@QAA@XZ"
		size = 64
		refs = "0020 ?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QAAPAV?$basic_ostream@GU?$char_traits@G@std@@@2@PAV32@@Z 0034 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 0038 ?_Ptr_wcout@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 003c ?_Ptr_wcin@std@@3PAV?$basic_istream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0A 4A 0B 4B 1A 60 09 4B 19 68 07 4B 1B 68 1B 1D 06 4A 1B 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_61_1 {
	meta:
		name = "??0_Init_cin@std@@QAA@XZ"
		size = 64
		refs = "0020 ?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QAAPAV?$basic_ostream@DU?$char_traits@D@std@@@2@PAV32@@Z 0034 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 0038 ?_Ptr_cout@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 003c ?_Ptr_cin@std@@3PAV?$basic_istream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0A 4A 0B 4B 1A 60 09 4B 19 68 07 4B 1B 68 1B 1D 06 4A 1B 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_61_1 {
	meta:
		name = "??0_Init_clog@std@@QAA@XZ"
		size = 64
		refs = "0020 ?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QAAPAV?$basic_ostream@DU?$char_traits@D@std@@@2@PAV32@@Z 0034 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0038 ?_Ptr_cout@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 003c ?_Ptr_clog@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0A 4A 0B 4B 1A 60 09 4B 19 68 07 4B 1B 68 1B 1D 06 4A 1B 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_61_1 {
	meta:
		name = "??0_Init_ushclog@std@@QAA@XZ"
		size = 64
		refs = "0020 ?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QAAPAV?$basic_ostream@GU?$char_traits@G@std@@@2@PAV32@@Z 0034 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0038 ?_Ptr_wcout@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 003c ?_Ptr_wclog@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0A 4A 0B 4B 1A 60 09 4B 19 68 07 4B 1B 68 1B 1D 06 4A 1B 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_61_1 {
	meta:
		name = "??0_Init_wcin@std@@QAA@XZ"
		size = 64
		refs = "0020 ?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAAPAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@PAV32@@Z 0034 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0038 ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 003c ?_Ptr_wcin@std@@3PAV?$basic_istream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0A 4A 0B 4B 1A 60 09 4B 19 68 07 4B 1B 68 1B 1D 06 4A 1B 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_61_1 {
	meta:
		name = "??0_Init_wclog@std@@QAA@XZ"
		size = 64
		refs = "0020 ?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAAPAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@PAV32@@Z 0034 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0038 ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 003c ?_Ptr_wclog@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 0A 4A 0B 4B 1A 60 09 4B 19 68 07 4B 1B 68 1B 1D 06 4A 1B 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_105_1 {
	meta:
		name = "??1?$basic_istream@GU?$char_traits@G@std@@@std@@UAA@XZ"
		size = 84
		refs = "0050 ??_7?$basic_istream@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B A3 F1 18 01 02 9B A3 F1 18 02 0B 68 1B 1D 1B 68 1A 44 0C 4B 13 60 02 9B 18 3B 1B 68 1B 1D 1B 68 A3 F1 18 00 02 9B A3 F1 18 01 02 9B A3 F1 18 02 0B 68 1B 1D 1B 68 13 44 1B 1F 18 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_106_1 {
	meta:
		name = "??1?$basic_istream@DU?$char_traits@D@std@@@std@@UAA@XZ"
		size = 84
		refs = "0050 ??_7?$basic_istream@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B A3 F1 18 01 02 9B A3 F1 18 02 0B 68 1B 1D 1B 68 1A 44 0C 4B 13 60 02 9B 18 3B 1B 68 1B 1D 1B 68 A3 F1 18 00 02 9B A3 F1 18 01 02 9B A3 F1 18 02 0B 68 1B 1D 1B 68 13 44 1B 1F 18 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_105_1 {
	meta:
		name = "??1?$basic_istream@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
		size = 84
		refs = "0050 ??_7?$basic_istream@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B A3 F1 18 01 02 9B A3 F1 18 02 0B 68 1B 1D 1B 68 1A 44 0C 4B 13 60 02 9B 18 3B 1B 68 1B 1D 1B 68 A3 F1 18 00 02 9B A3 F1 18 01 02 9B A3 F1 18 02 0B 68 1B 1D 1B 68 13 44 1B 1F 18 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_109_1 {
	meta:
		name = "??1?$ctype@G@std@@MAA@XZ"
		size = 68
		refs = "0022 free 0034 ??1ctype_base@std@@UAA@XZ 0040 ??_7?$ctype@G@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 0D 4A 02 9B 1A 60 02 9B 08 33 08 33 1B 68 00 2B 05 D0 02 9B 08 33 1B 1D 18 68 ?? ?? ?? ?? 02 9B 08 33 0C 33 18 68 ?? ?? ?? ?? 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_109_1 {
	meta:
		name = "??1?$ctype@_W@std@@MAA@XZ"
		size = 68
		refs = "0022 free 0034 ??1ctype_base@std@@UAA@XZ 0040 ??_7?$ctype@_W@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 0D 4A 02 9B 1A 60 02 9B 08 33 08 33 1B 68 00 2B 05 D0 02 9B 08 33 1B 1D 18 68 ?? ?? ?? ?? 02 9B 08 33 0C 33 18 68 ?? ?? ?? ?? 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_137_1 {
	meta:
		name = "??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QAAXXZ"
		size = 36
		refs = "000e ??1?$basic_istream@GU?$char_traits@G@std@@@std@@UAA@XZ 0018 ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 03 F1 18 00 ?? ?? ?? ?? 02 9B 03 F1 18 00 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_28_138_1 {
	meta:
		name = "??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QAAXXZ"
		size = 36
		refs = "000e ??1?$basic_istream@DU?$char_traits@D@std@@@std@@UAA@XZ 0018 ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 03 F1 18 00 ?? ?? ?? ?? 02 9B 03 F1 18 00 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_53_137_1 {
	meta:
		name = "??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAAXXZ"
		size = 36
		refs = "000e ??1?$basic_istream@_WU?$char_traits@_W@std@@@std@@UAA@XZ 0018 ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 03 F1 18 00 ?? ?? ?? ?? 02 9B 03 F1 18 00 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_141_1 {
	meta:
		name = "??_G?$basic_istream@GU?$char_traits@G@std@@@std@@UAAPAXI@Z"
		size = 58
		refs = "0010 ??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QAAXXZ 0024 ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B A3 F1 18 00 ?? ?? ?? ?? 05 9B 13 F0 01 0F 05 D0 60 21 04 9B A3 F1 18 00 ?? ?? ?? ?? 04 9B 18 3B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_28_142_1 {
	meta:
		name = "??_G?$basic_istream@DU?$char_traits@D@std@@@std@@UAAPAXI@Z"
		size = 58
		refs = "0010 ??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QAAXXZ 0024 ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B A3 F1 18 00 ?? ?? ?? ?? 05 9B 13 F0 01 0F 05 D0 60 21 04 9B A3 F1 18 00 ?? ?? ?? ?? 04 9B 18 3B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_53_141_1 {
	meta:
		name = "??_G?$basic_istream@_WU?$char_traits@_W@std@@@std@@UAAPAXI@Z"
		size = 58
		refs = "0010 ??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAAXXZ 0024 ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B A3 F1 18 00 ?? ?? ?? ?? 05 9B 13 F0 01 0F 05 D0 60 21 04 9B A3 F1 18 00 ?? ?? ?? ?? 04 9B 18 3B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_143_1 {
	meta:
		name = "??_G?$codecvt@GDU_Mbstatet@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$codecvt@GDU_Mbstatet@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 34 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_21_143_1 {
	meta:
		name = "??_G?$codecvt@_WDU_Mbstatet@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$codecvt@_WDU_Mbstatet@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 34 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_144_1 {
	meta:
		name = "??_G?$ctype@G@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$ctype@G@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 44 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_53_144_1 {
	meta:
		name = "??_G?$ctype@_W@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$ctype@_W@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 44 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_87_242_2 {
	meta:
		name = "??_G?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 44 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_527_2 {
	meta:
		name = "??_G?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 44 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_34_528_2 {
	meta:
		name = "??_G?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 44 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_163_1 {
	meta:
		name = "??__Ewfin@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwfin@std@@YAXXZ 0028 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 00 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_163_1 {
	meta:
		name = "??__Efin@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Ffin@std@@YAXXZ 0028 ?fin@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 00 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_163_1 {
	meta:
		name = "??__Ewfin@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwfin@std@@YAXXZ 0028 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 00 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_183_1 {
	meta:
		name = "?_Donarrow@?$ctype@G@std@@IBADGD@Z"
		size = 94
		refs = "0008 __security_push_cookie 0014 memset 0024 _Wcrtomb 0052 __security_pop_cookie"
		altNames = "?_Donarrow@?$ctype@_W@std@@IBAD_WD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 89 B0 08 22 00 21 04 A8 ?? ?? ?? ?? 0C 9B 18 33 04 AA BD F8 34 10 06 A8 ?? ?? ?? ?? 01 90 01 9B 01 2B 04 D0 9D F9 38 30 8D F8 00 30 04 E0 06 AB 93 F9 00 30 8D F8 00 30 9D F9 00 30 8D F8 08 30 9D F9 08 00 09 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_184_1 {
	meta:
		name = "?_Dowiden@?$ctype@G@std@@IBAGD@Z"
		size = 88
		refs = "0010 memset 0024 _Mbrtowc"
		altNames = "?_Dowiden@?$ctype@_W@std@@IBA_WD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 88 B0 08 22 00 21 06 A8 ?? ?? ?? ?? 0A 9B 18 33 00 93 06 AB 01 22 0B A9 0D F1 0A 00 ?? ?? ?? ?? 03 90 03 9B 00 2B 04 DA 4F F6 FF 73 AD F8 08 30 03 E0 BD F8 0A 30 AD F8 08 30 BD F8 08 30 AD F8 10 30 BD F8 10 00 08 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_185_1 {
	meta:
		name = "?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAA_NXZ"
		size = 498
		refs = "000a __security_push_cookie 0040 ?eof@?$char_traits@G@std@@SAGXZ 005a _guard_check_icall 007e ?eq_int_type@?$char_traits@G@std@@SA_NABG0@Z 0098 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 00a6 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 00ae ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAAADXZ 00b8 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ 00f0 ?unshift@?$codecvt@GDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PAD1AAPAD@Z 0162 fwrite 0178 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 01ae ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 01e6 __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 B0 48 0D F1 0C 0B ?? ?? ?? ?? A4 B0 6F 46 82 B0 6F F0 01 03 C7 E9 1C 33 D7 F8 A8 30 38 33 1B 68 00 2B 05 D0 D7 F8 A8 30 3E 33 1B 78 00 2B 03 D1 01 23 3B 72 D3 E0 D2 E0 08 23 7B 65 ?? ?? ?? ?? 38 82 3D 8A D7 F8 A8 30 1B 68 0C 33 D7 F8 A8 40 1B 68 3B 62 38 6A ?? ?? ?? ?? 3B 6A 20 46 29 46 98 47 78 82 7B 8A FB 82 ?? ?? ?? ?? B8 82 BB 8A 3B 83 17 F1 16 01 17 F1 18 00 ?? ?? ?? ?? 38 70 3B 78 00 2B 02 D0 00 23 3B 72 A8 E0 00 22 08 21 17 F1 78 00 ?? ?? ?? ?? B8 65 17 F1 5C 01 17 F1 78 00 ?? ?? ?? ?? 78 62 78 6A ?? ?? ?? ?? F8 62 17 F1 78 00 ?? ?? ?? ?? 38 63 17 F1 60 01 17 F1 78 00 ?? ?? ?? ?? B8 62 B8 6A ?? ?? ?? ?? 78 63 17 F1 40 03 00 93 FA 6A 3B 6B 13 44 7A 6B D7 F8 A8 10 40 31 D7 F8 A8 00 38 30 00 68 ?? ?? ?? ?? B8 63 BB 6B FB 61 FB 69 00 2B 06 D0 FB 69 01 2B 09 D0 FB 69 03 2B 53 D0 5B E0 D7 F8 A8 30 03 F1 3E 02 00 23 13 70 17 F1 64 01 17 F1 78 00 ?? ?? ?? ?? F8 63 F8 6B ?? ?? ?? ?? 78 64 3A 6C 7B 6C D3 1A FB 60 FB 68 00 2B 21 D9 17 F1 68 01 17 F1 78 00 ?? ?? ?? ?? B8 64 B8 6C ?? ?? ?? ?? F8 64 D7 F8 A8 30 4C 33 1B 68 FA 68 01 21 F8 6C ?? ?? ?? ?? 38 65 FA 68 3B 6D 9A 42 08 D0 00 23 7B 70 17 F1 78 00 ?? ?? ?? ?? 7B 78 3B 72 2F E0 D7 F8 A8 30 3E 33 1B 78 00 2B 08 D1 01 23 BB 70 17 F1 78 00 ?? ?? ?? ?? BB 78 3B 72 20 E0 FB 68 00 2B 05 D1 00 22 08 21 17 F1 78 00 ?? ?? ?? ?? 11 E0 01 23 FB 70 17 F1 78 00 ?? ?? ?? ?? FB 78 3B 72 0D E0 00 23 3B 71 17 F1 78 00 ?? ?? ?? ?? 3B 79 3B 72 04 E0 61 E7 17 F1 78 00 ?? ?? ?? ?? 38 7A 26 B0 ?? ?? ?? ?? BD E8 B0 08 5D F8 0C FB }
	condition:
		$1
}

rule file_21_185_1 {
	meta:
		name = "?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAA_NXZ"
		size = 498
		refs = "000a __security_push_cookie 0040 ?eof@?$char_traits@_W@std@@SAGXZ 005a _guard_check_icall 007e ?eq_int_type@?$char_traits@_W@std@@SA_NABG0@Z 0098 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 00a6 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 00ae ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAAADXZ 00b8 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ 00f0 ?unshift@?$codecvt@_WDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PAD1AAPAD@Z 0162 fwrite 0178 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 01ae ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 01e6 __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 B0 48 0D F1 0C 0B ?? ?? ?? ?? A4 B0 6F 46 82 B0 6F F0 01 03 C7 E9 1C 33 D7 F8 A8 30 38 33 1B 68 00 2B 05 D0 D7 F8 A8 30 3E 33 1B 78 00 2B 03 D1 01 23 3B 72 D3 E0 D2 E0 08 23 7B 65 ?? ?? ?? ?? 38 82 3D 8A D7 F8 A8 30 1B 68 0C 33 D7 F8 A8 40 1B 68 3B 62 38 6A ?? ?? ?? ?? 3B 6A 20 46 29 46 98 47 78 82 7B 8A FB 82 ?? ?? ?? ?? B8 82 BB 8A 3B 83 17 F1 16 01 17 F1 18 00 ?? ?? ?? ?? 38 70 3B 78 00 2B 02 D0 00 23 3B 72 A8 E0 00 22 08 21 17 F1 78 00 ?? ?? ?? ?? B8 65 17 F1 5C 01 17 F1 78 00 ?? ?? ?? ?? 78 62 78 6A ?? ?? ?? ?? F8 62 17 F1 78 00 ?? ?? ?? ?? 38 63 17 F1 60 01 17 F1 78 00 ?? ?? ?? ?? B8 62 B8 6A ?? ?? ?? ?? 78 63 17 F1 40 03 00 93 FA 6A 3B 6B 13 44 7A 6B D7 F8 A8 10 40 31 D7 F8 A8 00 38 30 00 68 ?? ?? ?? ?? B8 63 BB 6B FB 61 FB 69 00 2B 06 D0 FB 69 01 2B 09 D0 FB 69 03 2B 53 D0 5B E0 D7 F8 A8 30 03 F1 3E 02 00 23 13 70 17 F1 64 01 17 F1 78 00 ?? ?? ?? ?? F8 63 F8 6B ?? ?? ?? ?? 78 64 3A 6C 7B 6C D3 1A FB 60 FB 68 00 2B 21 D9 17 F1 68 01 17 F1 78 00 ?? ?? ?? ?? B8 64 B8 6C ?? ?? ?? ?? F8 64 D7 F8 A8 30 4C 33 1B 68 FA 68 01 21 F8 6C ?? ?? ?? ?? 38 65 FA 68 3B 6D 9A 42 08 D0 00 23 7B 70 17 F1 78 00 ?? ?? ?? ?? 7B 78 3B 72 2F E0 D7 F8 A8 30 3E 33 1B 78 00 2B 08 D1 01 23 BB 70 17 F1 78 00 ?? ?? ?? ?? BB 78 3B 72 20 E0 FB 68 00 2B 05 D1 00 22 08 21 17 F1 78 00 ?? ?? ?? ?? 11 E0 01 23 FB 70 17 F1 78 00 ?? ?? ?? ?? FB 78 3B 72 0D E0 00 23 3B 71 17 F1 78 00 ?? ?? ?? ?? 3B 79 3B 72 04 E0 61 E7 17 F1 78 00 ?? ?? ?? ?? 38 7A 26 B0 ?? ?? ?? ?? BD E8 B0 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_200_1 {
	meta:
		name = "?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 162
		refs = "002a ??2_Crt_new_delete@std@@SAPAXI@Z 003c ?c_str@locale@std@@QBAPBDXZ 0048 ??0_Locinfo@std@@QAA@PBD@Z 0060 ??0?$codecvt@GDU_Mbstatet@@@std@@QAA@ABV_Locinfo@1@I@Z 008e ??1_Locinfo@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 99 B0 6F 46 6F F0 01 03 C7 E9 0A 33 00 23 3B 60 3B 6F 00 2B 38 D0 3B 6F 1B 68 00 2B 34 D1 34 20 ?? ?? ?? ?? F8 60 FB 68 7B 60 7B 68 00 2B 18 D0 78 6F ?? ?? ?? ?? 38 61 39 69 17 F1 30 00 ?? ?? ?? ?? 78 61 7B 69 BB 61 3B 68 43 F0 01 03 3B 60 00 22 B9 69 78 68 ?? ?? ?? ?? F8 61 FB 69 BB 60 01 E0 00 23 BB 60 BB 68 3B 62 3A 6A 3B 6F 1A 60 3B 68 13 F0 01 0F 07 D0 3B 68 23 F0 01 03 3B 60 17 F1 30 00 ?? ?? ?? ?? 02 23 7B 62 78 6A 19 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_21_200_1 {
	meta:
		name = "?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 162
		refs = "002a ??2_Crt_new_delete@std@@SAPAXI@Z 003c ?c_str@locale@std@@QBAPBDXZ 0048 ??0_Locinfo@std@@QAA@PBD@Z 0060 ??0?$codecvt@_WDU_Mbstatet@@@std@@QAA@ABV_Locinfo@1@I@Z 008e ??1_Locinfo@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 99 B0 6F 46 6F F0 01 03 C7 E9 0A 33 00 23 3B 60 3B 6F 00 2B 38 D0 3B 6F 1B 68 00 2B 34 D1 34 20 ?? ?? ?? ?? F8 60 FB 68 7B 60 7B 68 00 2B 18 D0 78 6F ?? ?? ?? ?? 38 61 39 69 17 F1 30 00 ?? ?? ?? ?? 78 61 7B 69 BB 61 3B 68 43 F0 01 03 3B 60 00 22 B9 69 78 68 ?? ?? ?? ?? F8 61 FB 69 BB 60 01 E0 00 23 BB 60 BB 68 3B 62 3A 6A 3B 6F 1A 60 3B 68 13 F0 01 0F 07 D0 3B 68 23 F0 01 03 3B 60 17 F1 30 00 ?? ?? ?? ?? 02 23 7B 62 78 6A 19 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_203_1 {
	meta:
		name = "?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 162
		refs = "002a ??2_Crt_new_delete@std@@SAPAXI@Z 003c ?c_str@locale@std@@QBAPBDXZ 0048 ??0_Locinfo@std@@QAA@PBD@Z 0060 ??0?$ctype@G@std@@QAA@ABV_Locinfo@1@I@Z 008e ??1_Locinfo@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 99 B0 6F 46 6F F0 01 03 C7 E9 0A 33 00 23 3B 60 3B 6F 00 2B 38 D0 3B 6F 1B 68 00 2B 34 D1 44 20 ?? ?? ?? ?? F8 60 FB 68 7B 60 7B 68 00 2B 18 D0 78 6F ?? ?? ?? ?? 38 61 39 69 17 F1 30 00 ?? ?? ?? ?? 78 61 7B 69 BB 61 3B 68 43 F0 01 03 3B 60 00 22 B9 69 78 68 ?? ?? ?? ?? F8 61 FB 69 BB 60 01 E0 00 23 BB 60 BB 68 3B 62 3A 6A 3B 6F 1A 60 3B 68 13 F0 01 0F 07 D0 3B 68 23 F0 01 03 3B 60 17 F1 30 00 ?? ?? ?? ?? 02 23 7B 62 78 6A 19 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_21_203_1 {
	meta:
		name = "?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 162
		refs = "002a ??2_Crt_new_delete@std@@SAPAXI@Z 003c ?c_str@locale@std@@QBAPBDXZ 0048 ??0_Locinfo@std@@QAA@PBD@Z 0060 ??0?$ctype@_W@std@@QAA@ABV_Locinfo@1@I@Z 008e ??1_Locinfo@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 99 B0 6F 46 6F F0 01 03 C7 E9 0A 33 00 23 3B 60 3B 6F 00 2B 38 D0 3B 6F 1B 68 00 2B 34 D1 44 20 ?? ?? ?? ?? F8 60 FB 68 7B 60 7B 68 00 2B 18 D0 78 6F ?? ?? ?? ?? 38 61 39 69 17 F1 30 00 ?? ?? ?? ?? 78 61 7B 69 BB 61 3B 68 43 F0 01 03 3B 60 00 22 B9 69 78 68 ?? ?? ?? ?? F8 61 FB 69 BB 60 01 E0 00 23 BB 60 BB 68 3B 62 3A 6A 3B 6F 1A 60 3B 68 13 F0 01 0F 07 D0 3B 68 23 F0 01 03 3B 60 17 F1 30 00 ?? ?? ?? ?? 02 23 7B 62 78 6A 19 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_207_1 {
	meta:
		name = "?_Getcvt@_Locinfo@std@@QBA?AU_Cvtvec@@XZ"
		size = 182
		refs = "000a __security_push_cookie 0012 _Getcvt 00aa __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? 9D B0 06 A8 ?? ?? ?? ?? 06 AB 04 93 04 9B 12 AA 00 92 01 93 00 9D 01 9C 94 E8 0F 00 85 E8 0F 00 01 9B 10 33 01 93 00 9B 10 33 00 93 00 9D 01 9C 94 E8 0F 00 85 E8 0F 00 01 9B 10 33 01 93 00 9B 10 33 00 93 00 9C 01 98 90 E8 0E 00 84 E8 0E 00 23 9A 12 AB 02 92 03 93 02 9D 03 9C 94 E8 0F 00 85 E8 0F 00 03 9B 10 33 03 93 02 9B 10 33 02 93 02 9D 03 9C 94 E8 0F 00 85 E8 0F 00 03 9B 10 33 03 93 02 9B 10 33 02 93 02 9C 03 98 90 E8 0E 00 84 E8 0E 00 23 9B 05 93 05 98 1D B0 ?? ?? ?? ?? BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_210_1 {
	meta:
		name = "?_Gndec@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAPAGXZ"
		size = 66
		altNames = "?_Gndec@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAPA_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 2C 33 1B 68 1B 68 5A 1C 04 9B 2C 33 1B 68 1A 60 04 9B 1C 33 1B 68 1B 68 9B 1E 00 93 04 9B 1C 33 1A 68 00 9B 13 60 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_211_1 {
	meta:
		name = "?_Gninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAPAGXZ"
		size = 72
		altNames = "?_Gninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAPA_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 2C 33 1B 68 1B 68 5A 1E 04 9B 2C 33 1B 68 1A 60 04 9B 1C 33 1B 68 1B 68 00 93 04 9B 1C 33 1B 68 1B 68 9A 1C 04 9B 1C 33 1B 68 1A 60 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_215_1 {
	meta:
		name = "?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
		size = 164
		refs = "0032 ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXXZ 0052 _get_stream_buffer_pointers 006e ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXPAPAG0PAH001@Z 0086 memcpy 00a0 ?_Stinit@?1??_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0E 9B 01 2B 02 D1 01 23 07 93 01 E0 00 23 07 93 0C 9B 03 F1 48 02 07 9B DB B2 13 70 0C 9B 03 F1 3E 02 00 23 13 70 0C 98 ?? ?? ?? ?? 0D 9B 00 2B 1A D0 19 E0 00 23 06 93 00 23 05 93 00 23 04 93 04 AB 05 AA 06 A9 0D 98 ?? ?? ?? ?? 04 9B 08 93 08 9B 02 93 05 9B 01 93 06 9B 00 93 04 9B 05 9A 06 99 0C 98 ?? ?? ?? ?? 0C 9B 03 F1 4C 02 0D 9B 13 60 0C 9B 03 F1 40 00 07 49 08 22 ?? ?? ?? ?? 0C 9B 03 F1 38 02 00 23 13 60 0A B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_215_1 {
	meta:
		name = "?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
		size = 164
		refs = "0032 ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXXZ 0052 _get_stream_buffer_pointers 006e ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXPAPA_W0PAH001@Z 0086 memcpy 00a0 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0E 9B 01 2B 02 D1 01 23 07 93 01 E0 00 23 07 93 0C 9B 03 F1 48 02 07 9B DB B2 13 70 0C 9B 03 F1 3E 02 00 23 13 70 0C 98 ?? ?? ?? ?? 0D 9B 00 2B 1A D0 19 E0 00 23 06 93 00 23 05 93 00 23 04 93 04 AB 05 AA 06 A9 0D 98 ?? ?? ?? ?? 04 9B 08 93 08 9B 02 93 05 9B 01 93 06 9B 00 93 04 9B 05 9A 06 99 0C 98 ?? ?? ?? ?? 0C 9B 03 F1 4C 02 0D 9B 13 60 0C 9B 03 F1 40 00 07 49 08 22 ?? ?? ?? ?? 0C 9B 03 F1 38 02 00 23 13 60 0A B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_218_1 {
	meta:
		name = "?_Init@?$codecvt@GDU_Mbstatet@@@std@@IAAXABV_Locinfo@2@@Z"
		size = 114
		refs = "000a __security_push_cookie 0014 ?_Getcvt@_Locinfo@std@@QBA?AU_Cvtvec@@XZ 0066 __security_pop_cookie"
		altNames = "?_Init@?$codecvt@_WDU_Mbstatet@@@std@@IAAXABV_Locinfo@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? 8F B0 04 A9 15 98 ?? ?? ?? ?? 02 90 02 99 14 9B 03 F1 08 02 0B 46 00 92 01 93 00 9D 01 9C 94 E8 0F 00 85 E8 0F 00 01 9B 10 33 01 93 00 9B 10 33 00 93 00 9D 01 9C 94 E8 0F 00 85 E8 0F 00 01 9B 10 33 01 93 00 9B 10 33 00 93 00 9C 01 98 90 E8 0E 00 84 E8 0E 00 0F B0 ?? ?? ?? ?? BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_219_1 {
	meta:
		name = "?_Init@?$ctype@G@std@@IAAXABV_Locinfo@2@@Z"
		size = 140
		refs = "000a __security_push_cookie 0014 ?_Getctype@_Locinfo@std@@QBA?AU_Ctypevec@@XZ 002e ?_Getcvt@_Locinfo@std@@QBA?AU_Cvtvec@@XZ 0080 __security_pop_cookie"
		altNames = "?_Init@?$ctype@_W@std@@IAAXABV_Locinfo@2@@Z"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? 93 B0 04 A9 19 98 ?? ?? ?? ?? 02 90 02 9C 18 9B 03 F1 08 05 94 E8 0F 00 85 E8 0F 00 08 A9 19 98 ?? ?? ?? ?? 03 90 03 99 18 9B 03 F1 18 02 0B 46 00 92 01 93 00 9D 01 9C 94 E8 0F 00 85 E8 0F 00 01 9B 10 33 01 93 00 9B 10 33 00 93 00 9D 01 9C 94 E8 0F 00 85 E8 0F 00 01 9B 10 33 01 93 00 9B 10 33 00 93 00 9C 01 98 90 E8 0E 00 84 E8 0E 00 13 B0 ?? ?? ?? ?? BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_237_1 {
	meta:
		name = "?_Pninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAPAGXZ"
		size = 72
		altNames = "?_Pninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAPA_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 30 33 1B 68 1B 68 5A 1E 04 9B 30 33 1B 68 1A 60 04 9B 20 33 1B 68 1B 68 00 93 04 9B 20 33 1B 68 1B 68 9A 1C 04 9B 20 33 1B 68 1A 60 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_239_1 {
	meta:
		name = "?_Set_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAAXXZ"
		size = 94
		refs = "000c ?eback@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 0032 ?egptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 0050 ?setg@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXPAG00@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 00 90 06 9B 03 F1 3C 02 00 9B 93 42 11 D0 06 98 ?? ?? ?? ?? 01 90 06 9B 03 F1 50 02 01 9B 13 60 06 98 ?? ?? ?? ?? 02 90 06 9B 03 F1 54 02 02 9B 13 60 06 9B 3E 33 06 9A 3C 32 06 99 3C 31 06 98 ?? ?? ?? ?? 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_21_239_1 {
	meta:
		name = "?_Set_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAAXXZ"
		size = 94
		refs = "000c ?eback@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 0032 ?egptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 0050 ?setg@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXPA_W00@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 ?? ?? ?? ?? 00 90 06 9B 03 F1 3C 02 00 9B 93 42 11 D0 06 98 ?? ?? ?? ?? 01 90 06 9B 03 F1 50 02 01 9B 13 60 06 98 ?? ?? ?? ?? 02 90 06 9B 03 F1 54 02 02 9B 13 60 06 9B 3E 33 06 9A 3C 32 06 99 3C 31 06 98 ?? ?? ?? ?? 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_283_1 {
	meta:
		name = "?do_in@?$codecvt@GDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1AAPBDPAG3AAPAG@Z"
		size = 228
		refs = "005a _Mbrtowc 00a0 strlen"
		altNames = "?do_in@?$codecvt@_WDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1AAPBDPA_W3AAPA_W@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0E 9A 10 9B 1A 60 11 9A 13 9B 1A 60 10 9B 1A 68 0F 9B 9A 42 02 D1 00 23 06 93 01 E0 01 23 06 93 06 9B 04 93 10 9B 1A 68 0F 9B 9A 42 4D D0 13 9B 1A 68 12 9B 9A 42 48 D0 0C 9B 08 33 00 93 0D 9B 0F 99 10 9A 12 68 8A 1A 10 99 09 68 13 98 00 68 ?? ?? ?? ?? 07 90 07 9B 02 93 02 9B 03 93 03 9B 13 F1 02 0F 07 D0 03 9B B3 F1 FF 3F 09 D0 03 9B 00 2B 09 D0 15 E0 0F 9A 10 9B 1A 60 04 9B 05 93 25 E0 02 23 05 93 22 E0 13 9B 1B 68 1B 88 00 2B 07 D1 10 9B 18 68 ?? ?? ?? ?? 08 90 08 9B 5B 1C 02 93 02 9B 13 F1 03 0F 01 D1 00 23 02 93 10 9B 1A 68 02 9B 1A 44 10 9B 1A 60 13 9B 1B 68 9A 1C 13 9B 1A 60 00 23 04 93 AC E7 04 9B 05 93 05 98 0A B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_284_1 {
	meta:
		name = "?do_is@?$ctype@G@std@@MBAPBGPBG0PAF@Z"
		size = 42
		refs = "0014 _Getwctypes"
		altNames = "?do_is@?$ctype@_W@std@@MBAPB_WPB_W0PAF@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 04 9B 08 33 07 9A 06 99 05 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_285_1 {
	meta:
		name = "?do_is@?$ctype@G@std@@MBA_NFG@Z"
		size = 74
		refs = "0014 _Getwctype"
		altNames = "?do_is@?$ctype@_W@std@@MBA_NF_W@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 06 9B 03 F1 08 01 BD F8 20 00 ?? ?? ?? ?? AD F8 00 00 BD F9 00 20 BD F9 1C 30 13 40 00 2B 02 D0 01 23 01 93 01 E0 00 23 01 93 01 9B DB B2 8D F8 08 30 9D F8 08 00 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_286_1 {
	meta:
		name = "?do_length@?$codecvt@GDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1I@Z"
		size = 178
		refs = "0010 memcpy 003e _Mbrtowc 007a strlen"
		altNames = "?do_length@?$codecvt@_WDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBD1I@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8C B0 0F 99 0A A8 08 22 ?? ?? ?? ?? 00 23 04 93 10 9B 03 93 04 9A 12 9B 9A 42 3E D2 03 9A 11 9B 9A 42 3A D0 0E 9B 08 33 00 93 0A AB 11 99 03 9A 8A 1A 03 99 02 A8 ?? ?? ?? ?? 08 90 08 9B 05 93 05 9B 06 93 06 9B 13 F1 02 0F 07 D0 06 9B B3 F1 FF 3F 06 D0 06 9B 00 2B 06 D0 10 E0 04 9B 07 93 1D E0 04 9B 07 93 1A E0 BD F8 08 30 00 2B 06 D1 03 98 ?? ?? ?? ?? 09 90 09 9B 5B 1C 05 93 05 9B 13 F1 03 0F 01 D1 00 23 05 93 03 9A 05 9B 13 44 03 93 04 9B 5B 1C 04 93 BC E7 04 9B 07 93 07 98 0C B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_287_1 {
	meta:
		name = "?do_max_length@?$codecvt@GDU_Mbstatet@@@std@@MBAHXZ"
		size = 26
		altNames = "?do_max_length@?$codecvt@_WDU_Mbstatet@@@std@@MBAHXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 23 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_289_1 {
	meta:
		name = "?do_narrow@?$ctype@G@std@@MBADGD@Z"
		size = 50
		refs = "0014 ?_Donarrow@?$ctype@G@std@@IBADGD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 9D F9 18 20 BD F8 14 10 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F9 00 30 8D F8 04 30 9D F9 04 00 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_21_289_1 {
	meta:
		name = "?do_narrow@?$ctype@_W@std@@MBAD_WD@Z"
		size = 50
		refs = "0014 ?_Donarrow@?$ctype@_W@std@@IBAD_WD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 9D F9 18 20 BD F8 14 10 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F9 00 30 8D F8 04 30 9D F9 04 00 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_290_1 {
	meta:
		name = "?do_narrow@?$ctype@G@std@@MBAPBGPBG0DPAD@Z"
		size = 76
		refs = "002a ?_Donarrow@?$ctype@G@std@@IBADGD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 E0 05 9B 9B 1C 05 93 08 9B 5B 1C 08 93 05 9A 06 9B 9A 42 0D D0 9D F9 1C 20 05 9B 19 88 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F9 00 20 08 9B 1A 70 E7 E7 05 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_21_290_1 {
	meta:
		name = "?do_narrow@?$ctype@_W@std@@MBAPB_WPB_W0DPAD@Z"
		size = 76
		refs = "002a ?_Donarrow@?$ctype@_W@std@@IBAD_WD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 E0 05 9B 9B 1C 05 93 08 9B 5B 1C 08 93 05 9A 06 9B 9A 42 0D D0 9D F9 1C 20 05 9B 19 88 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F9 00 20 08 9B 1A 70 E7 E7 05 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_291_1 {
	meta:
		name = "?do_out@?$codecvt@GDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PBG1AAPBGPAD3AAPAD@Z"
		size = 274
		refs = "0008 __security_push_cookie 004a _Wcrtomb 0080 memcpy 0106 __security_pop_cookie"
		altNames = "?do_out@?$codecvt@_WDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PB_W1AAPB_WPAD3AAPAD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 8B B0 10 9A 12 9B 1A 60 13 9A 15 9B 1A 60 12 9B 1A 68 11 9B 9A 42 62 D0 15 9B 1A 68 14 9B 9A 42 5D D0 14 9A 15 9B 1B 68 D3 1A 05 2B 1F DB 0E 9B 08 33 0F 9A 12 99 09 68 09 88 15 98 00 68 ?? ?? ?? ?? 03 90 03 9B 00 93 00 9B 00 2B 03 DA 02 23 01 93 50 E0 0A E0 12 9B 1B 68 9A 1C 12 9B 1A 60 15 9B 1A 68 00 9B 1A 44 15 9B 1A 60 36 E0 0F 99 06 A8 08 22 ?? ?? ?? ?? 0E 9B 08 33 0F 9A 12 99 09 68 09 88 08 A8 ?? ?? ?? ?? 04 90 04 9B 00 93 00 9B 00 2B 03 DA 02 23 01 93 2C E0 1E E0 14 9A 15 9B 1B 68 D2 1A 00 9B 9A 42 06 DA 0F 98 06 A9 08 22 ?? ?? ?? ?? 12 E0 10 E0 00 9A 08 A9 15 9B 18 68 ?? ?? ?? ?? 12 9B 1B 68 9A 1C 12 9B 1A 60 15 9B 1A 68 00 9B 1A 44 15 9B 1A 60 97 E7 12 9B 1A 68 11 9B 9A 42 02 D1 00 23 02 93 01 E0 01 23 02 93 02 9B 01 93 01 98 0B B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_292_1 {
	meta:
		name = "?do_scan_is@?$ctype@G@std@@MBAPBGFPBG0@Z"
		size = 70
		refs = "0024 ?is@?$ctype@G@std@@QBA_NFG@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 02 E0 06 9B 9B 1C 06 93 06 9A 07 9B 9A 42 0D D0 06 9B 1A 88 BD F9 14 10 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 00 D1 EA E7 06 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_21_292_1 {
	meta:
		name = "?do_scan_is@?$ctype@_W@std@@MBAPB_WFPB_W0@Z"
		size = 70
		refs = "0024 ?is@?$ctype@_W@std@@QBA_NF_W@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 02 E0 06 9B 9B 1C 06 93 06 9A 07 9B 9A 42 0D D0 06 9B 1A 88 BD F9 14 10 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 00 D1 EA E7 06 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_293_1 {
	meta:
		name = "?do_scan_not@?$ctype@G@std@@MBAPBGFPBG0@Z"
		size = 70
		refs = "0024 ?is@?$ctype@G@std@@QBA_NFG@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 02 E0 06 9B 9B 1C 06 93 06 9A 07 9B 9A 42 0D D0 06 9B 1A 88 BD F9 14 10 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 00 D0 EA E7 06 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_21_293_1 {
	meta:
		name = "?do_scan_not@?$ctype@_W@std@@MBAPB_WFPB_W0@Z"
		size = 70
		refs = "0024 ?is@?$ctype@_W@std@@QBA_NF_W@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 02 E0 06 9B 9B 1C 06 93 06 9A 07 9B 9A 42 0D D0 06 9B 1A 88 BD F9 14 10 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 00 D0 EA E7 06 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_294_1 {
	meta:
		name = "?do_tolower@?$ctype@G@std@@MBAGG@Z"
		size = 50
		refs = "0014 _Towlower"
		altNames = "?do_tolower@?$ctype@_W@std@@MBA_W_W@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 03 F1 08 01 BD F8 14 00 ?? ?? ?? ?? AD F8 00 00 BD F8 00 30 AD F8 04 30 BD F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_23_337_2 {
	meta:
		name = "?do_toupper@?$ctype@G@std@@MBAGG@Z"
		size = 50
		refs = "0014 _Towupper"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 03 F1 08 01 BD F8 14 00 ?? ?? ?? ?? AD F8 00 00 BD F8 00 30 AD F8 04 30 BD F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_71_338_2 {
	meta:
		name = "?do_toupper@?$ctype@_W@std@@MBA_W_W@Z"
		size = 50
		refs = "0014 _Towupper"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 03 F1 08 01 BD F8 14 00 ?? ?? ?? ?? AD F8 00 00 BD F8 00 30 AD F8 04 30 BD F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_295_1 {
	meta:
		name = "?do_tolower@?$ctype@G@std@@MBAPBGPAGPBG@Z"
		size = 70
		refs = "0024 _Towlower"
		altNames = "?do_tolower@?$ctype@_W@std@@MBAPB_WPA_WPB_W@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 02 E0 05 9B 9B 1C 05 93 05 9A 06 9B 9A 42 0D D0 04 9B 03 F1 08 01 05 9B 18 88 ?? ?? ?? ?? AD F8 00 00 BD F8 00 20 05 9B 1A 80 EA E7 05 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_297_1 {
	meta:
		name = "?do_toupper@?$ctype@G@std@@MBAPBGPAGPBG@Z"
		size = 70
		refs = "0024 _Towupper"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 02 E0 05 9B 9B 1C 05 93 05 9A 06 9B 9A 42 0D D0 04 9B 03 F1 08 01 05 9B 18 88 ?? ?? ?? ?? AD F8 00 00 BD F8 00 20 05 9B 1A 80 EA E7 05 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_118_337_2 {
	meta:
		name = "?do_toupper@?$ctype@_W@std@@MBAPB_WPA_WPB_W@Z"
		size = 70
		refs = "0024 _Towupper"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 02 E0 05 9B 9B 1C 05 93 05 9A 06 9B 9A 42 0D D0 04 9B 03 F1 08 01 05 9B 18 88 ?? ?? ?? ?? AD F8 00 00 BD F8 00 20 05 9B 1A 80 EA E7 05 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_298_1 {
	meta:
		name = "?do_unshift@?$codecvt@GDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PAD1AAPAD@Z"
		size = 152
		refs = "0008 __security_push_cookie 001e memcpy 002c _Wcrtomb 008c __security_pop_cookie"
		altNames = "?do_unshift@?$codecvt@_WDU_Mbstatet@@@std@@MBAHAAU_Mbstatet@@PAD1AAPAD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 89 B0 0E 9A 10 9B 1A 60 00 23 01 93 0D 99 04 A8 08 22 ?? ?? ?? ?? 0C 9B 08 33 0D 9A 00 21 06 A8 ?? ?? ?? ?? 02 90 02 9B 00 93 00 9B 00 2B 02 DC 02 23 01 93 20 E0 00 9B 5B 1E 00 93 0F 9A 10 9B 1B 68 D2 1A 00 9B 9A 42 07 DA 0D 98 04 A9 08 22 ?? ?? ?? ?? 01 23 01 93 0E E0 00 9B 00 2B 0B DD 00 9A 06 A9 10 9B 18 68 ?? ?? ?? ?? 10 9B 1A 68 00 9B 1A 44 10 9B 1A 60 01 9B 03 93 03 98 09 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_299_1 {
	meta:
		name = "?do_widen@?$ctype@G@std@@MBAGD@Z"
		size = 46
		refs = "0010 ?_Dowiden@?$ctype@G@std@@IBAGD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 9D F9 14 10 04 98 ?? ?? ?? ?? AD F8 00 00 BD F8 00 30 AD F8 04 30 BD F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_21_300_1 {
	meta:
		name = "?do_widen@?$ctype@_W@std@@MBA_WD@Z"
		size = 46
		refs = "0010 ?_Dowiden@?$ctype@_W@std@@IBA_WD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 9D F9 14 10 04 98 ?? ?? ?? ?? AD F8 00 00 BD F8 00 30 AD F8 04 30 BD F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_300_1 {
	meta:
		name = "?do_widen@?$ctype@G@std@@MBAPBDPBD0PAG@Z"
		size = 74
		refs = "0028 ?_Dowiden@?$ctype@G@std@@IBAGD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 E0 05 9B 5B 1C 05 93 07 9B 9B 1C 07 93 05 9A 06 9B 9A 42 0C D0 05 9B 93 F9 00 10 04 98 ?? ?? ?? ?? AD F8 00 00 BD F8 00 20 07 9B 1A 80 E8 E7 05 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_21_299_1 {
	meta:
		name = "?do_widen@?$ctype@_W@std@@MBAPBDPBD0PA_W@Z"
		size = 74
		refs = "0028 ?_Dowiden@?$ctype@_W@std@@IBA_WD@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 E0 05 9B 5B 1C 05 93 07 9B 9B 1C 07 93 05 9A 06 9B 9A 42 0C D0 05 9B 93 F9 00 10 04 98 ?? ?? ?? ?? AD F8 00 00 BD F8 00 20 07 9B 1A 80 E8 E7 05 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_302_1 {
	meta:
		name = "?egptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ"
		size = 48
		altNames = "?egptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1C 33 19 68 04 9B 2C 33 1B 68 1A 68 02 23 02 FB 03 F2 0B 68 13 44 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_304_1 {
	meta:
		name = "?eof@?$char_traits@G@std@@SAGXZ"
		size = 26
		altNames = "?eof@?$char_traits@_W@std@@SAGXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 4F F6 FF 73 AD F8 00 30 BD F8 00 00 02 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_20_305_1 {
	meta:
		name = "?epptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ"
		size = 48
		altNames = "?epptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 20 33 19 68 04 9B 30 33 1B 68 1A 68 02 23 02 FB 03 F2 0B 68 13 44 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_306_1 {
	meta:
		name = "?eq_int_type@?$char_traits@G@std@@SA_NABG0@Z"
		size = 54
		altNames = "?eq_int_type@?$char_traits@_W@std@@SA_NABG0@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1A 88 05 9B 1B 88 9A 42 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_311_1 {
	meta:
		name = "?gbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXH@Z"
		size = 62
		altNames = "?gbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXH@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 2C 33 1B 68 1A 68 03 9B D2 1A 02 9B 2C 33 1B 68 1A 60 02 9B 1C 33 19 68 03 9A 02 23 02 FB 03 F2 0B 68 1A 44 02 9B 1C 33 1B 68 1A 60 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_317_1 {
	meta:
		name = "?init@?$basic_ios@GU?$char_traits@G@std@@@std@@IAAXPAV?$basic_streambuf@GU?$char_traits@G@std@@@2@_N@Z"
		size = 104
		refs = "000c ?_Init@ios_base@std@@IAAXXZ 0028 ?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBAGD@Z 004c ?setstate@?$basic_ios@GU?$char_traits@G@std@@@std@@QAAXH_N@Z 005a ?_Addstd@ios_base@std@@SAXPAV12@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 03 F1 38 02 05 9B 13 60 04 9B 03 F1 3C 02 00 23 13 60 20 21 04 98 ?? ?? ?? ?? AD F8 00 00 04 9B 03 F1 40 02 BD F8 00 30 13 80 04 9B 38 33 1B 68 00 2B 04 D1 00 22 04 21 04 98 ?? ?? ?? ?? 9D F8 18 30 00 2B 02 D0 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_21_317_1 {
	meta:
		name = "?init@?$basic_ios@_WU?$char_traits@_W@std@@@std@@IAAXPAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_N@Z"
		size = 104
		refs = "000c ?_Init@ios_base@std@@IAAXXZ 0028 ?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBA_WD@Z 004c ?setstate@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAAXH_N@Z 005a ?_Addstd@ios_base@std@@SAXPAV12@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 04 9B 03 F1 38 02 05 9B 13 60 04 9B 03 F1 3C 02 00 23 13 60 20 21 04 98 ?? ?? ?? ?? AD F8 00 00 04 9B 03 F1 40 02 BD F8 00 30 13 80 04 9B 38 33 1B 68 00 2B 04 D1 00 22 04 21 04 98 ?? ?? ?? ?? 9D F8 18 30 00 2B 02 D0 04 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_319_1 {
	meta:
		name = "?is@?$ctype@G@std@@QBA_NFG@Z"
		size = 74
		refs = "0022 _guard_check_icall"
		altNames = "?is@?$ctype@_W@std@@QBA_NF_W@Z"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B 83 B0 BD F8 28 60 BD F9 24 50 08 9B 1B 68 10 33 08 9C 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 29 46 32 46 98 47 8D F8 00 00 9D F8 00 30 8D F8 08 30 9D F8 08 00 03 B0 BD E8 70 08 5D F8 14 FB }
	condition:
		$1
}

rule file_20_332_1 {
	meta:
		name = "?not_eof@?$char_traits@G@std@@SAGABG@Z"
		size = 90
		refs = "000a ?eof@?$char_traits@G@std@@SAGXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 ?? ?? ?? ?? AD F8 00 00 06 9B 1A 88 BD F8 00 30 9A 42 03 D0 06 9B 1B 88 02 93 0E E0 ?? ?? ?? ?? AD F8 02 00 BD F8 02 30 00 2B 02 D1 01 23 01 93 01 E0 00 23 01 93 01 9B 02 93 02 9B 9B B2 AD F8 0C 30 BD F8 0C 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_21_332_1 {
	meta:
		name = "?not_eof@?$char_traits@_W@std@@SAGABG@Z"
		size = 90
		refs = "000a ?eof@?$char_traits@_W@std@@SAGXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 ?? ?? ?? ?? AD F8 00 00 06 9B 1A 88 BD F8 00 30 9A 42 03 D0 06 9B 1B 88 02 93 0E E0 ?? ?? ?? ?? AD F8 02 00 BD F8 02 30 00 2B 02 D1 01 23 01 93 01 E0 00 23 01 93 01 9B 02 93 02 9B 9B B2 AD F8 0C 30 BD F8 0C 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_334_1 {
	meta:
		name = "?overflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAAGG@Z"
		size = 750
		refs = "000a __security_push_cookie 001c ?eof@?$char_traits@G@std@@SAGXZ 002e ?eq_int_type@?$char_traits@G@std@@SA_NABG0@Z 003e ?not_eof@?$char_traits@G@std@@SAGABG@Z 0050 ?pptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 006a ?epptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 007c ?to_char_type@?$char_traits@G@std@@SAGABG@Z 0086 ?_Pninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAPAGXZ 00b8 ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAAXXZ 00dc ??$_Fputc@G@std@@YA_NGPAU_iobuf@@@Z 011e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 012e ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 0136 ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAAADXZ 0140 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ 0188 ?out@?$codecvt@GDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PBG1AAPBGPAD3AAPAD@Z 01f0 fwrite 020c ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 0262 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 02e2 __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B ?? ?? ?? ?? B0 B0 6F 46 84 B0 6F F0 01 03 C7 E9 28 33 ?? ?? ?? ?? B8 82 BB 8A FB 82 17 F1 D4 01 17 F1 16 00 ?? ?? ?? ?? 38 72 3B 7A 00 2B 08 D0 17 F1 D4 00 ?? ?? ?? ?? 38 83 3B 8B BB 80 49 E1 33 E0 D7 F8 D0 00 ?? ?? ?? ?? F8 63 FB 6B 00 2B 1F D0 D7 F8 D0 00 ?? ?? ?? ?? 38 64 D7 F8 D0 00 ?? ?? ?? ?? 78 64 3A 6C 7B 6C 9A 42 11 D2 17 F1 D4 00 ?? ?? ?? ?? 78 83 D7 F8 D0 00 ?? ?? ?? ?? B8 64 7A 8B BB 6C 1A 80 B7 F8 D4 30 BB 80 21 E1 0B E0 D7 F8 D0 30 4C 33 1B 68 00 2B 05 D1 ?? ?? ?? ?? B8 83 BB 8B BB 80 14 E1 D7 F8 D0 00 ?? ?? ?? ?? D7 F8 D0 30 38 33 1B 68 00 2B 1C D1 17 F1 D4 00 ?? ?? ?? ?? F8 83 D7 F8 D0 30 4C 33 19 68 F8 8B ?? ?? ?? ?? 78 72 7B 7A 00 2B 03 D0 B7 F8 D4 30 BB 81 04 E0 ?? ?? ?? ?? 38 84 3B 8C BB 81 BB 89 BB 80 EE E0 ED E0 08 23 C7 F8 84 30 17 F1 D4 00 ?? ?? ?? ?? 78 84 7B 8C 3B 80 00 22 08 21 17 F1 A8 00 ?? ?? ?? ?? C7 F8 88 00 17 F1 8C 01 17 F1 A8 00 ?? ?? ?? ?? F8 64 F8 6C ?? ?? ?? ?? 78 65 17 F1 A8 00 ?? ?? ?? ?? B8 65 17 F1 90 01 17 F1 A8 00 ?? ?? ?? ?? 38 65 38 6D ?? ?? ?? ?? F8 65 17 F1 68 03 03 93 7A 6D BB 6D 13 44 02 93 FB 6D 01 93 17 F1 7C 03 00 93 3B 46 9B 1C 3A 46 D7 F8 D0 10 40 31 D7 F8 D0 00 38 30 00 68 ?? ?? ?? ?? 38 66 3B 6E BB 63 BB 6B 00 2B C0 F2 91 80 BB 6B 01 2B 03 DD BB 6B 03 2B 6D D0 89 E0 17 F1 94 01 17 F1 A8 00 ?? ?? ?? ?? 78 66 78 6E ?? ?? ?? ?? F8 66 BA 6E FB 6E D3 1A 3B 61 3B 69 00 2B 24 D9 17 F1 98 01 17 F1 A8 00 ?? ?? ?? ?? 38 67 38 6F ?? ?? ?? ?? 78 67 D7 F8 D0 30 4C 33 1B 68 3A 69 01 21 78 6F ?? ?? ?? ?? B8 67 3A 69 BB 6F 9A 42 0B D0 ?? ?? ?? ?? B8 84 BB 8C FB 84 17 F1 A8 00 ?? ?? ?? ?? FB 8C BB 80 63 E0 D7 F8 D0 30 03 F1 3E 02 01 23 13 70 FA 6F 3B 46 9A 42 09 D0 B7 F8 D4 30 3B 85 17 F1 A8 00 ?? ?? ?? ?? 3B 8D BB 80 4F E0 3B 69 00 2B 00 D9 1C E0 17 F1 A8 00 ?? ?? ?? ?? C7 F8 80 00 D7 F8 80 30 20 2B 06 D2 00 22 08 21 17 F1 A8 00 ?? ?? ?? ?? 0B E0 ?? ?? ?? ?? 78 85 7B 8D BB 85 17 F1 A8 00 ?? ?? ?? ?? BB 8D BB 80 2E E0 28 E0 D7 F8 D0 30 4C 33 19 68 38 88 ?? ?? ?? ?? B8 72 BB 7A 00 2B 03 D0 B7 F8 D4 30 FB 81 04 E0 ?? ?? ?? ?? F8 85 FB 8D FB 81 FB 89 3B 86 17 F1 A8 00 ?? ?? ?? ?? 3B 8E BB 80 10 E0 ?? ?? ?? ?? 78 86 7B 8E BB 86 17 F1 A8 00 ?? ?? ?? ?? BB 8E BB 80 04 E0 27 E7 17 F1 A8 00 ?? ?? ?? ?? B8 88 34 B0 ?? ?? ?? ?? BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_21_334_1 {
	meta:
		name = "?overflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAAGG@Z"
		size = 750
		refs = "000a __security_push_cookie 001c ?eof@?$char_traits@_W@std@@SAGXZ 002e ?eq_int_type@?$char_traits@_W@std@@SA_NABG0@Z 003e ?not_eof@?$char_traits@_W@std@@SAGABG@Z 0050 ?pptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 006a ?epptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 007c ?to_char_type@?$char_traits@_W@std@@SA_WABG@Z 0086 ?_Pninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAPA_WXZ 00b8 ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAAXXZ 00dc ??$_Fputc@_W@std@@YA_N_WPAU_iobuf@@@Z 011e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@ID@Z 012e ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 0136 ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAAADXZ 0140 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ 0188 ?out@?$codecvt@_WDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PB_W1AAPB_WPAD3AAPAD@Z 01f0 fwrite 020c ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 0262 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 02e2 __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B ?? ?? ?? ?? B0 B0 6F 46 84 B0 6F F0 01 03 C7 E9 28 33 ?? ?? ?? ?? B8 82 BB 8A FB 82 17 F1 D4 01 17 F1 16 00 ?? ?? ?? ?? 38 72 3B 7A 00 2B 08 D0 17 F1 D4 00 ?? ?? ?? ?? 38 83 3B 8B BB 80 49 E1 33 E0 D7 F8 D0 00 ?? ?? ?? ?? F8 63 FB 6B 00 2B 1F D0 D7 F8 D0 00 ?? ?? ?? ?? 38 64 D7 F8 D0 00 ?? ?? ?? ?? 78 64 3A 6C 7B 6C 9A 42 11 D2 17 F1 D4 00 ?? ?? ?? ?? 78 83 D7 F8 D0 00 ?? ?? ?? ?? B8 64 7A 8B BB 6C 1A 80 B7 F8 D4 30 BB 80 21 E1 0B E0 D7 F8 D0 30 4C 33 1B 68 00 2B 05 D1 ?? ?? ?? ?? B8 83 BB 8B BB 80 14 E1 D7 F8 D0 00 ?? ?? ?? ?? D7 F8 D0 30 38 33 1B 68 00 2B 1C D1 17 F1 D4 00 ?? ?? ?? ?? F8 83 D7 F8 D0 30 4C 33 19 68 F8 8B ?? ?? ?? ?? 78 72 7B 7A 00 2B 03 D0 B7 F8 D4 30 BB 81 04 E0 ?? ?? ?? ?? 38 84 3B 8C BB 81 BB 89 BB 80 EE E0 ED E0 08 23 C7 F8 84 30 17 F1 D4 00 ?? ?? ?? ?? 78 84 7B 8C 3B 80 00 22 08 21 17 F1 A8 00 ?? ?? ?? ?? C7 F8 88 00 17 F1 8C 01 17 F1 A8 00 ?? ?? ?? ?? F8 64 F8 6C ?? ?? ?? ?? 78 65 17 F1 A8 00 ?? ?? ?? ?? B8 65 17 F1 90 01 17 F1 A8 00 ?? ?? ?? ?? 38 65 38 6D ?? ?? ?? ?? F8 65 17 F1 68 03 03 93 7A 6D BB 6D 13 44 02 93 FB 6D 01 93 17 F1 7C 03 00 93 3B 46 9B 1C 3A 46 D7 F8 D0 10 40 31 D7 F8 D0 00 38 30 00 68 ?? ?? ?? ?? 38 66 3B 6E BB 63 BB 6B 00 2B C0 F2 91 80 BB 6B 01 2B 03 DD BB 6B 03 2B 6D D0 89 E0 17 F1 94 01 17 F1 A8 00 ?? ?? ?? ?? 78 66 78 6E ?? ?? ?? ?? F8 66 BA 6E FB 6E D3 1A 3B 61 3B 69 00 2B 24 D9 17 F1 98 01 17 F1 A8 00 ?? ?? ?? ?? 38 67 38 6F ?? ?? ?? ?? 78 67 D7 F8 D0 30 4C 33 1B 68 3A 69 01 21 78 6F ?? ?? ?? ?? B8 67 3A 69 BB 6F 9A 42 0B D0 ?? ?? ?? ?? B8 84 BB 8C FB 84 17 F1 A8 00 ?? ?? ?? ?? FB 8C BB 80 63 E0 D7 F8 D0 30 03 F1 3E 02 01 23 13 70 FA 6F 3B 46 9A 42 09 D0 B7 F8 D4 30 3B 85 17 F1 A8 00 ?? ?? ?? ?? 3B 8D BB 80 4F E0 3B 69 00 2B 00 D9 1C E0 17 F1 A8 00 ?? ?? ?? ?? C7 F8 80 00 D7 F8 80 30 20 2B 06 D2 00 22 08 21 17 F1 A8 00 ?? ?? ?? ?? 0B E0 ?? ?? ?? ?? 78 85 7B 8D BB 85 17 F1 A8 00 ?? ?? ?? ?? BB 8D BB 80 2E E0 28 E0 D7 F8 D0 30 4C 33 19 68 38 88 ?? ?? ?? ?? B8 72 BB 7A 00 2B 03 D0 B7 F8 D4 30 FB 81 04 E0 ?? ?? ?? ?? F8 85 FB 8D FB 81 FB 89 3B 86 17 F1 A8 00 ?? ?? ?? ?? 3B 8E BB 80 10 E0 ?? ?? ?? ?? 78 86 7B 8E BB 86 17 F1 A8 00 ?? ?? ?? ?? BB 8E BB 80 04 E0 27 E7 17 F1 A8 00 ?? ?? ?? ?? B8 88 34 B0 ?? ?? ?? ?? BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_336_1 {
	meta:
		name = "?overflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAAGG@Z"
		size = 40
		refs = "000a ?eof@?$char_traits@G@std@@SAGXZ"
		altNames = "?pbackfail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAAGG@Z ?underflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAAGXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? AD F8 00 00 BD F8 00 30 AD F8 04 30 BD F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_114_336_1 {
	meta:
		name = "?overflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAAGG@Z"
		size = 40
		refs = "000a ?eof@?$char_traits@_W@std@@SAGXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? AD F8 00 00 BD F8 00 30 AD F8 04 30 BD F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_37_406_3 {
	meta:
		name = "?pbackfail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAAGG@Z"
		size = 40
		refs = "000a ?eof@?$char_traits@_W@std@@SAGXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? AD F8 00 00 BD F8 00 30 AD F8 04 30 BD F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_63_441_3 {
	meta:
		name = "?underflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAAGXZ"
		size = 40
		refs = "000a ?eof@?$char_traits@_W@std@@SAGXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 ?? ?? ?? ?? AD F8 00 00 BD F8 00 30 AD F8 04 30 BD F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_337_1 {
	meta:
		name = "?pbackfail@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAAGG@Z"
		size = 390
		refs = "000c ?gptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 001a ?eback@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 0030 ?eof@?$char_traits@G@std@@SAGXZ 0046 ?eq_int_type@?$char_traits@G@std@@SA_NABG0@Z 0066 ?to_int_type@?$char_traits@G@std@@SAGABG@Z 008e ?_Gndec@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAPAGXZ 0094 ?not_eof@?$char_traits@G@std@@SAGABG@Z 00f6 ?to_char_type@?$char_traits@G@std@@SAGABG@Z 0110 ??$_Ungetc@G@std@@YA_NABGPAU_iobuf@@@Z 0158 ?_Set_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 8E B0 10 98 ?? ?? ?? ?? 08 90 08 9B 00 2B 47 D0 10 98 ?? ?? ?? ?? 09 90 10 98 ?? ?? ?? ?? 0A 90 09 9A 0A 9B 9A 42 3B D2 ?? ?? ?? ?? AD F8 08 00 BD F8 08 30 AD F8 0A 30 11 A9 0D F1 0A 00 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 1A D1 10 98 ?? ?? ?? ?? 0B 90 6F F0 01 02 0B 9B 98 18 ?? ?? ?? ?? AD F8 0C 00 BD F8 0C 30 AD F8 0E 30 11 A9 0D F1 0E 00 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 0D D0 10 98 ?? ?? ?? ?? 11 A8 ?? ?? ?? ?? AD F8 10 00 BD F8 10 30 AD F8 04 30 68 E0 67 E0 10 9B 4C 33 1B 68 00 2B 11 D0 ?? ?? ?? ?? AD F8 12 00 BD F8 12 30 AD F8 14 30 11 A9 05 A8 ?? ?? ?? ?? 8D F8 02 00 9D F8 02 30 00 2B 09 D0 ?? ?? ?? ?? AD F8 16 00 BD F8 16 30 AD F8 04 30 47 E0 46 E0 10 9B 38 33 1B 68 00 2B 1B D1 11 A8 ?? ?? ?? ?? AD F8 18 00 BD F8 18 30 AD F8 1A 30 10 9B 4C 33 19 68 0D F1 1A 00 ?? ?? ?? ?? 8D F8 03 00 9D F8 03 30 00 2B 05 D0 BD F8 44 30 AD F8 04 30 26 E0 25 E0 10 98 ?? ?? ?? ?? 0C 90 10 9B 03 F1 3C 02 0C 9B 93 42 13 D0 11 A8 ?? ?? ?? ?? AD F8 1C 00 10 9B 03 F1 3C 02 BD F8 1C 30 13 80 10 98 ?? ?? ?? ?? BD F8 44 30 AD F8 04 30 08 E0 07 E0 ?? ?? ?? ?? AD F8 1E 00 BD F8 1E 30 AD F8 04 30 BD F8 04 00 0E B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_21_337_1 {
	meta:
		name = "?pbackfail@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAAGG@Z"
		size = 390
		refs = "000c ?gptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 001a ?eback@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 0030 ?eof@?$char_traits@_W@std@@SAGXZ 0046 ?eq_int_type@?$char_traits@_W@std@@SA_NABG0@Z 0066 ?to_int_type@?$char_traits@_W@std@@SAGAB_W@Z 008e ?_Gndec@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAPA_WXZ 0094 ?not_eof@?$char_traits@_W@std@@SAGABG@Z 00f6 ?to_char_type@?$char_traits@_W@std@@SA_WABG@Z 0110 ??$_Ungetc@_W@std@@YA_NAB_WPAU_iobuf@@@Z 0158 ?_Set_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAAXXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 8E B0 10 98 ?? ?? ?? ?? 08 90 08 9B 00 2B 47 D0 10 98 ?? ?? ?? ?? 09 90 10 98 ?? ?? ?? ?? 0A 90 09 9A 0A 9B 9A 42 3B D2 ?? ?? ?? ?? AD F8 08 00 BD F8 08 30 AD F8 0A 30 11 A9 0D F1 0A 00 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 1A D1 10 98 ?? ?? ?? ?? 0B 90 6F F0 01 02 0B 9B 98 18 ?? ?? ?? ?? AD F8 0C 00 BD F8 0C 30 AD F8 0E 30 11 A9 0D F1 0E 00 ?? ?? ?? ?? 8D F8 01 00 9D F8 01 30 00 2B 0D D0 10 98 ?? ?? ?? ?? 11 A8 ?? ?? ?? ?? AD F8 10 00 BD F8 10 30 AD F8 04 30 68 E0 67 E0 10 9B 4C 33 1B 68 00 2B 11 D0 ?? ?? ?? ?? AD F8 12 00 BD F8 12 30 AD F8 14 30 11 A9 05 A8 ?? ?? ?? ?? 8D F8 02 00 9D F8 02 30 00 2B 09 D0 ?? ?? ?? ?? AD F8 16 00 BD F8 16 30 AD F8 04 30 47 E0 46 E0 10 9B 38 33 1B 68 00 2B 1B D1 11 A8 ?? ?? ?? ?? AD F8 18 00 BD F8 18 30 AD F8 1A 30 10 9B 4C 33 19 68 0D F1 1A 00 ?? ?? ?? ?? 8D F8 03 00 9D F8 03 30 00 2B 05 D0 BD F8 44 30 AD F8 04 30 26 E0 25 E0 10 98 ?? ?? ?? ?? 0C 90 10 9B 03 F1 3C 02 0C 9B 93 42 13 D0 11 A8 ?? ?? ?? ?? AD F8 1C 00 10 9B 03 F1 3C 02 BD F8 1C 30 13 80 10 98 ?? ?? ?? ?? BD F8 44 30 AD F8 04 30 08 E0 07 E0 ?? ?? ?? ?? AD F8 1E 00 BD F8 1E 30 AD F8 04 30 BD F8 04 00 0E B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_339_1 {
	meta:
		name = "?pbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXH@Z"
		size = 62
		altNames = "?pbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXH@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 30 33 1B 68 1A 68 03 9B D2 1A 02 9B 30 33 1B 68 1A 60 02 9B 20 33 19 68 03 9A 02 23 02 FB 03 F2 0B 68 1A 44 02 9B 20 33 1B 68 1A 60 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_343_1 {
	meta:
		name = "?seekoff@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 232
		refs = "000c ?gptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 004a ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAA_NXZ 0080 _fseeki64 0094 fgetpos 00aa ??0?$fpos@U_Mbstatet@@@std@@QAA@_J@Z 00b6 ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAAXXZ 00d0 ??0?$fpos@U_Mbstatet@@@std@@QAA@U_Mbstatet@@_J@Z 00e4 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8C B0 0E 98 ?? ?? ?? ?? 04 90 0E 9B 03 F1 3C 02 04 9B 93 42 0F D1 12 9B 01 2B 0C D1 0E 9B 38 33 1B 68 00 2B 07 D1 10 9A 11 99 00 23 92 1E 61 EB 03 03 10 92 11 93 0E 9B 4C 33 1B 68 00 2B 2B D0 0E 98 ?? ?? ?? ?? 8D F8 08 00 9D F8 08 30 00 2B 22 D0 10 9B 08 93 11 9B 09 93 09 9A 08 9B 13 43 00 2B 02 D1 12 9B 01 2B 0C D0 12 9B 00 93 10 9A 11 9B 0E 99 4C 31 08 68 ?? ?? ?? ?? 05 90 05 9B 00 2B 09 D1 0A A9 0E 9B 4C 33 18 68 ?? ?? ?? ?? 06 90 06 9B 00 2B 09 D0 10 4B 1A 68 0F 4B 5B 68 0F 98 ?? ?? ?? ?? 0F 9B 03 93 11 E0 0E 98 ?? ?? ?? ?? 0A 9B 00 93 0B 9B 01 93 0E 9B 40 33 07 93 07 9B 19 68 5A 68 0F 98 ?? ?? ?? ?? 0F 9B 03 93 03 98 0C B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_343_1 {
	meta:
		name = "?seekoff@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 232
		refs = "000c ?gptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 004a ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAA_NXZ 0080 _fseeki64 0094 fgetpos 00aa ??0?$fpos@U_Mbstatet@@@std@@QAA@_J@Z 00b6 ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAAXXZ 00d0 ??0?$fpos@U_Mbstatet@@@std@@QAA@U_Mbstatet@@_J@Z 00e4 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8C B0 0E 98 ?? ?? ?? ?? 04 90 0E 9B 03 F1 3C 02 04 9B 93 42 0F D1 12 9B 01 2B 0C D1 0E 9B 38 33 1B 68 00 2B 07 D1 10 9A 11 99 00 23 92 1E 61 EB 03 03 10 92 11 93 0E 9B 4C 33 1B 68 00 2B 2B D0 0E 98 ?? ?? ?? ?? 8D F8 08 00 9D F8 08 30 00 2B 22 D0 10 9B 08 93 11 9B 09 93 09 9A 08 9B 13 43 00 2B 02 D1 12 9B 01 2B 0C D0 12 9B 00 93 10 9A 11 9B 0E 99 4C 31 08 68 ?? ?? ?? ?? 05 90 05 9B 00 2B 09 D1 0A A9 0E 9B 4C 33 18 68 ?? ?? ?? ?? 06 90 06 9B 00 2B 09 D0 10 4B 1A 68 0F 4B 5B 68 0F 98 ?? ?? ?? ?? 0F 9B 03 93 11 E0 0E 98 ?? ?? ?? ?? 0A 9B 00 93 0B 9B 01 93 0E 9B 40 33 07 93 07 9B 19 68 5A 68 0F 98 ?? ?? ?? ?? 0F 9B 03 93 03 98 0C B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_350_1 {
	meta:
		name = "?setbuf@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAAPAV?$basic_streambuf@GU?$char_traits@G@std@@@2@PAG_J@Z"
		size = 122
		refs = "0048 setvbuf 0066 ?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 08 9B 4C 33 1B 68 00 2B 1F D0 09 9B 00 2B 0B D1 0A 9B 04 93 0B 9B 05 93 05 9A 04 9B 13 43 00 2B 02 D1 04 23 00 93 01 E0 00 23 00 93 0A 9A 02 23 02 FB 03 F3 00 9A 09 99 08 98 4C 30 00 68 ?? ?? ?? ?? 02 90 02 9B 00 2B 03 D0 00 23 01 93 09 E0 08 E0 01 22 08 9B 4C 33 19 68 08 98 ?? ?? ?? ?? 08 9B 01 93 01 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_21_350_1 {
	meta:
		name = "?setbuf@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAAPAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@PA_W_J@Z"
		size = 122
		refs = "0048 setvbuf 0066 ?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAAXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 08 9B 4C 33 1B 68 00 2B 1F D0 09 9B 00 2B 0B D1 0A 9B 04 93 0B 9B 05 93 05 9A 04 9B 13 43 00 2B 02 D1 04 23 00 93 01 E0 00 23 00 93 0A 9A 02 23 02 FB 03 F3 00 9A 09 99 08 98 4C 30 00 68 ?? ?? ?? ?? 02 90 02 9B 00 2B 03 D0 00 23 01 93 09 E0 08 E0 01 22 08 9B 4C 33 19 68 08 98 ?? ?? ?? ?? 08 9B 01 93 01 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_352_1 {
	meta:
		name = "?setg@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXPAG00@Z"
		size = 52
		altNames = "?setg@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXPA_W00@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 02 9B 0C 33 1A 68 03 9B 13 60 02 9B 1C 33 1A 68 04 9B 13 60 05 9A 04 9B D3 1A 5A 10 02 9B 2C 33 1B 68 1A 60 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_353_1 {
	meta:
		name = "?setp@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXPAG0@Z"
		size = 52
		altNames = "?setp@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXPA_W0@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 02 9B 10 33 1A 68 03 9B 13 60 02 9B 20 33 1A 68 03 9B 13 60 04 9A 03 9B D3 1A 5A 10 02 9B 30 33 1B 68 1A 60 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_20_358_1 {
	meta:
		name = "?sync@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAAHXZ"
		size = 156
		refs = "0016 ?eof@?$char_traits@G@std@@SAGXZ 0030 _guard_check_icall 005e ?eq_int_type@?$char_traits@G@std@@SA_NABG0@Z 0074 fflush"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 88 B0 0C 9B 4C 33 1B 68 00 2B 38 D0 ?? ?? ?? ?? AD F8 02 00 BD F8 02 50 0C 9B 1B 68 0C 33 0C 9C 1B 68 03 93 03 98 ?? ?? ?? ?? 03 9B 20 46 29 46 98 47 AD F8 04 00 BD F8 04 30 AD F8 08 30 ?? ?? ?? ?? AD F8 06 00 BD F8 06 30 AD F8 0A 30 02 A9 0D F1 0A 00 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0C D1 0C 9B 4C 33 18 68 ?? ?? ?? ?? 05 90 05 9B 00 2B 03 DA 6F F0 00 03 04 93 01 E0 00 23 04 93 04 9B 06 93 06 98 08 B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_21_358_1 {
	meta:
		name = "?sync@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAAHXZ"
		size = 156
		refs = "0016 ?eof@?$char_traits@_W@std@@SAGXZ 0030 _guard_check_icall 005e ?eq_int_type@?$char_traits@_W@std@@SA_NABG0@Z 0074 fflush"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 88 B0 0C 9B 4C 33 1B 68 00 2B 38 D0 ?? ?? ?? ?? AD F8 02 00 BD F8 02 50 0C 9B 1B 68 0C 33 0C 9C 1B 68 03 93 03 98 ?? ?? ?? ?? 03 9B 20 46 29 46 98 47 AD F8 04 00 BD F8 04 30 AD F8 08 30 ?? ?? ?? ?? AD F8 06 00 BD F8 06 30 AD F8 0A 30 02 A9 0D F1 0A 00 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0C D1 0C 9B 4C 33 18 68 ?? ?? ?? ?? 05 90 05 9B 00 2B 03 DA 6F F0 00 03 04 93 01 E0 00 23 04 93 04 9B 06 93 06 98 08 B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_361_1 {
	meta:
		name = "?to_char_type@?$char_traits@G@std@@SAGABG@Z"
		size = 32
		altNames = "?to_char_type@?$char_traits@_W@std@@SA_WABG@Z ?to_int_type@?$char_traits@G@std@@SAGABG@Z ?to_int_type@?$char_traits@_W@std@@SAGAB_W@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 88 AD F8 00 30 BD F8 00 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_20_363_1 {
	meta:
		name = "?uflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAAGXZ"
		size = 704
		refs = "000a __security_push_cookie 0020 ?gptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 003a ?egptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 004c ?_Gninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAPAGXZ 0054 ?to_int_type@?$char_traits@G@std@@SAGABG@Z 006e ?eof@?$char_traits@G@std@@SAGXZ 007e ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAAXXZ 009e ??$_Fgetc@G@std@@YA_NAAGPAU_iobuf@@@Z 00d0 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 00e0 fgetc 0100 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 0114 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 0120 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 0128 ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAAADXZ 0132 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ 017a ?in@?$codecvt@GDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PBD1AAPBDPAG3AAPAG@Z 01f2 ungetc 0236 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@II@Z 0270 memcpy_s 02b4 __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B ?? ?? ?? ?? B0 B0 6F 46 84 B0 6F F0 01 03 C7 E9 28 33 D7 F8 D0 00 ?? ?? ?? ?? 78 63 7B 6B 00 2B 1A D0 D7 F8 D0 00 ?? ?? ?? ?? B8 63 D7 F8 D0 00 ?? ?? ?? ?? F8 63 BA 6B FB 6B 9A 42 0C D2 D7 F8 D0 00 ?? ?? ?? ?? 38 64 38 6C ?? ?? ?? ?? 38 82 3B 8A BB 80 27 E1 0B E0 D7 F8 D0 30 4C 33 1B 68 00 2B 05 D1 ?? ?? ?? ?? 78 82 7B 8A BB 80 1A E1 D7 F8 D0 00 ?? ?? ?? ?? D7 F8 D0 30 38 33 1B 68 00 2B 1E D1 00 23 3B 81 D7 F8 D0 30 4C 33 19 68 17 F1 08 00 ?? ?? ?? ?? B8 70 BB 78 00 2B 07 D0 17 F1 08 00 ?? ?? ?? ?? B8 82 BB 8A 7B 81 04 E0 ?? ?? ?? ?? F8 82 FB 8A 7B 81 7B 89 BB 80 F2 E0 F1 E0 17 F1 A8 00 ?? ?? ?? ?? C7 F8 84 00 D7 F8 D0 30 4C 33 18 68 ?? ?? ?? ?? 78 64 7B 6C 3B 63 3B 6B B3 F1 FF 3F 0B D1 ?? ?? ?? ?? 38 83 3B 8B 7B 83 17 F1 A8 00 ?? ?? ?? ?? 7B 8B BB 80 D2 E0 3B 6B 5A B2 01 21 17 F1 A8 00 ?? ?? ?? ?? 17 F1 88 01 17 F1 A8 00 ?? ?? ?? ?? B8 64 B8 6C ?? ?? ?? ?? 38 65 17 F1 A8 00 ?? ?? ?? ?? 78 65 17 F1 8C 01 17 F1 A8 00 ?? ?? ?? ?? F8 64 F8 6C ?? ?? ?? ?? B8 65 17 F1 60 03 03 93 3B 46 9B 1C 02 93 3B 46 01 93 17 F1 2C 03 00 93 3A 6D 7B 6D 13 44 BA 6D D7 F8 D0 10 40 31 D7 F8 D0 00 38 30 00 68 ?? ?? ?? ?? F8 65 FB 6D BB 62 BB 6A 00 2B C0 F2 81 80 BB 6A 01 2B 03 DD BB 6A 03 2B 51 D0 79 E0 3A 6E 3B 46 9A 42 38 D0 17 F1 90 01 17 F1 A8 00 ?? ?? ?? ?? 78 66 78 6E ?? ?? ?? ?? B8 66 17 F1 A8 00 ?? ?? ?? ?? F8 66 BA 6E FB 6E 1A 44 FB 6A D3 1A FB 60 FB 68 00 2B 11 DD FB 68 5B 1E FB 60 D7 F8 D0 30 4C 33 19 68 FA 68 01 23 02 FB 03 F2 FB 6A 13 44 93 F9 00 00 ?? ?? ?? ?? EA E7 38 46 ?? ?? ?? ?? B8 83 BB 8B FB 83 17 F1 A8 00 ?? ?? ?? ?? FB 8B BB 80 4E E0 12 E0 17 F1 94 01 17 F1 A8 00 ?? ?? ?? ?? 38 67 38 6F ?? ?? ?? ?? 78 67 FA 6A 7B 6F D2 1A 00 21 17 F1 A8 00 ?? ?? ?? ?? 34 E0 17 F1 A8 00 ?? ?? ?? ?? B8 67 BB 6F 02 2B 00 D2 2B E0 17 F1 98 01 17 F1 A8 00 ?? ?? ?? ?? F8 67 F8 6F ?? ?? ?? ?? C7 F8 80 00 02 23 D7 F8 80 20 02 21 38 46 ?? ?? ?? ?? 38 46 ?? ?? ?? ?? 38 84 3B 8C 7B 84 17 F1 A8 00 ?? ?? ?? ?? 7B 8C BB 80 10 E0 ?? ?? ?? ?? B8 84 BB 8C FB 84 17 F1 A8 00 ?? ?? ?? ?? FB 8C BB 80 04 E0 17 E7 17 F1 A8 00 ?? ?? ?? ?? B8 88 34 B0 ?? ?? ?? ?? BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_21_363_1 {
	meta:
		name = "?uflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAAGXZ"
		size = 704
		refs = "000a __security_push_cookie 0020 ?gptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 003a ?egptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 004c ?_Gninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAPA_WXZ 0054 ?to_int_type@?$char_traits@_W@std@@SAGAB_W@Z 006e ?eof@?$char_traits@_W@std@@SAGXZ 007e ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAAXXZ 009e ??$_Fgetc@_W@std@@YA_NAA_WPAU_iobuf@@@Z 00d0 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 00e0 fgetc 0100 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA@XZ 0114 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@ID@Z 0120 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 0128 ??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBAAADXZ 0132 ?size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBAIXZ 017a ?in@?$codecvt@_WDU_Mbstatet@@@std@@QBAHAAU_Mbstatet@@PBD1AAPBDPA_W3AAPA_W@Z 01f2 ungetc 0236 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAAAAV12@II@Z 0270 memcpy_s 02b4 __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B ?? ?? ?? ?? B0 B0 6F 46 84 B0 6F F0 01 03 C7 E9 28 33 D7 F8 D0 00 ?? ?? ?? ?? 78 63 7B 6B 00 2B 1A D0 D7 F8 D0 00 ?? ?? ?? ?? B8 63 D7 F8 D0 00 ?? ?? ?? ?? F8 63 BA 6B FB 6B 9A 42 0C D2 D7 F8 D0 00 ?? ?? ?? ?? 38 64 38 6C ?? ?? ?? ?? 38 82 3B 8A BB 80 27 E1 0B E0 D7 F8 D0 30 4C 33 1B 68 00 2B 05 D1 ?? ?? ?? ?? 78 82 7B 8A BB 80 1A E1 D7 F8 D0 00 ?? ?? ?? ?? D7 F8 D0 30 38 33 1B 68 00 2B 1E D1 00 23 3B 81 D7 F8 D0 30 4C 33 19 68 17 F1 08 00 ?? ?? ?? ?? B8 70 BB 78 00 2B 07 D0 17 F1 08 00 ?? ?? ?? ?? B8 82 BB 8A 7B 81 04 E0 ?? ?? ?? ?? F8 82 FB 8A 7B 81 7B 89 BB 80 F2 E0 F1 E0 17 F1 A8 00 ?? ?? ?? ?? C7 F8 84 00 D7 F8 D0 30 4C 33 18 68 ?? ?? ?? ?? 78 64 7B 6C 3B 63 3B 6B B3 F1 FF 3F 0B D1 ?? ?? ?? ?? 38 83 3B 8B 7B 83 17 F1 A8 00 ?? ?? ?? ?? 7B 8B BB 80 D2 E0 3B 6B 5A B2 01 21 17 F1 A8 00 ?? ?? ?? ?? 17 F1 88 01 17 F1 A8 00 ?? ?? ?? ?? B8 64 B8 6C ?? ?? ?? ?? 38 65 17 F1 A8 00 ?? ?? ?? ?? 78 65 17 F1 8C 01 17 F1 A8 00 ?? ?? ?? ?? F8 64 F8 6C ?? ?? ?? ?? B8 65 17 F1 60 03 03 93 3B 46 9B 1C 02 93 3B 46 01 93 17 F1 2C 03 00 93 3A 6D 7B 6D 13 44 BA 6D D7 F8 D0 10 40 31 D7 F8 D0 00 38 30 00 68 ?? ?? ?? ?? F8 65 FB 6D BB 62 BB 6A 00 2B C0 F2 81 80 BB 6A 01 2B 03 DD BB 6A 03 2B 51 D0 79 E0 3A 6E 3B 46 9A 42 38 D0 17 F1 90 01 17 F1 A8 00 ?? ?? ?? ?? 78 66 78 6E ?? ?? ?? ?? B8 66 17 F1 A8 00 ?? ?? ?? ?? F8 66 BA 6E FB 6E 1A 44 FB 6A D3 1A FB 60 FB 68 00 2B 11 DD FB 68 5B 1E FB 60 D7 F8 D0 30 4C 33 19 68 FA 68 01 23 02 FB 03 F2 FB 6A 13 44 93 F9 00 00 ?? ?? ?? ?? EA E7 38 46 ?? ?? ?? ?? B8 83 BB 8B FB 83 17 F1 A8 00 ?? ?? ?? ?? FB 8B BB 80 4E E0 12 E0 17 F1 94 01 17 F1 A8 00 ?? ?? ?? ?? 38 67 38 6F ?? ?? ?? ?? 78 67 FA 6A 7B 6F D2 1A 00 21 17 F1 A8 00 ?? ?? ?? ?? 34 E0 17 F1 A8 00 ?? ?? ?? ?? B8 67 BB 6F 02 2B 00 D2 2B E0 17 F1 98 01 17 F1 A8 00 ?? ?? ?? ?? F8 67 F8 6F ?? ?? ?? ?? C7 F8 80 00 02 23 D7 F8 80 20 02 21 38 46 ?? ?? ?? ?? 38 46 ?? ?? ?? ?? 38 84 3B 8C 7B 84 17 F1 A8 00 ?? ?? ?? ?? 7B 8C BB 80 10 E0 ?? ?? ?? ?? B8 84 BB 8C FB 84 17 F1 A8 00 ?? ?? ?? ?? FB 8C BB 80 04 E0 17 E7 17 F1 A8 00 ?? ?? ?? ?? B8 88 34 B0 ?? ?? ?? ?? BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_365_1 {
	meta:
		name = "?uflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAAGXZ"
		size = 152
		refs = "001a _guard_check_icall 0030 ?eof@?$char_traits@G@std@@SAGXZ 0046 ?eq_int_type@?$char_traits@G@std@@SA_NABG0@Z 006a ?_Gninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAPAGXZ 0072 ?to_int_type@?$char_traits@G@std@@SAGABG@Z"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 87 B0 0A 9B 1B 68 18 33 0A 9C 1B 68 04 93 04 98 ?? ?? ?? ?? 04 9B 20 46 98 47 AD F8 04 00 BD F8 04 30 AD F8 08 30 ?? ?? ?? ?? AD F8 06 00 BD F8 06 30 AD F8 0A 30 02 A9 0D F1 0A 00 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 08 D0 ?? ?? ?? ?? AD F8 0C 00 BD F8 0C 30 AD F8 02 30 0C E0 0A 98 ?? ?? ?? ?? 05 90 05 98 ?? ?? ?? ?? AD F8 0E 00 BD F8 0E 30 AD F8 02 30 BD F8 02 30 AD F8 18 30 BD F8 18 00 07 B0 BD E8 10 08 5D F8 0C FB }
	condition:
		$1
}

rule file_21_365_1 {
	meta:
		name = "?uflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAAGXZ"
		size = 152
		refs = "001a _guard_check_icall 0030 ?eof@?$char_traits@_W@std@@SAGXZ 0046 ?eq_int_type@?$char_traits@_W@std@@SA_NABG0@Z 006a ?_Gninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAPA_WXZ 0072 ?to_int_type@?$char_traits@_W@std@@SAGAB_W@Z"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 87 B0 0A 9B 1B 68 18 33 0A 9C 1B 68 04 93 04 98 ?? ?? ?? ?? 04 9B 20 46 98 47 AD F8 04 00 BD F8 04 30 AD F8 08 30 ?? ?? ?? ?? AD F8 06 00 BD F8 06 30 AD F8 0A 30 02 A9 0D F1 0A 00 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 08 D0 ?? ?? ?? ?? AD F8 0C 00 BD F8 0C 30 AD F8 02 30 0C E0 0A 98 ?? ?? ?? ?? 05 90 05 98 ?? ?? ?? ?? AD F8 0E 00 BD F8 0E 30 AD F8 02 30 BD F8 02 30 AD F8 18 30 BD F8 18 00 07 B0 BD E8 10 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_366_1 {
	meta:
		name = "?underflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAAGXZ"
		size = 220
		refs = "000e ?gptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 0024 ?egptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 003c ?to_int_type@?$char_traits@G@std@@SAGABG@Z 005e _guard_check_icall 0074 ?eof@?$char_traits@G@std@@SAGXZ 008c ?eq_int_type@?$char_traits@G@std@@SA_NABG0@Z"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 8A B0 0E 98 ?? ?? ?? ?? 06 90 06 9B 00 2B 1A D0 0E 98 ?? ?? ?? ?? 07 90 0E 98 ?? ?? ?? ?? 08 90 07 9A 08 9B 9A 42 0E D2 0E 98 ?? ?? ?? ?? 09 90 09 98 ?? ?? ?? ?? AD F8 04 00 BD F8 04 30 AD F8 0C 30 3F E0 3E E0 0E 9B 1B 68 1C 33 0E 9C 1B 68 04 93 04 98 ?? ?? ?? ?? 04 9B 20 46 98 47 AD F8 06 00 BD F8 06 30 AD F8 02 30 ?? ?? ?? ?? AD F8 08 00 BD F8 08 30 AD F8 0A 30 0D F1 02 01 0D F1 0A 00 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 05 D0 BD F8 02 30 AD F8 0C 30 13 E0 12 E0 BD F8 02 50 0E 9B 1B 68 10 33 0E 9C 1B 68 05 93 05 98 ?? ?? ?? ?? 05 9B 20 46 29 46 98 47 BD F8 02 30 AD F8 0C 30 BD F8 0C 00 0A B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_21_366_1 {
	meta:
		name = "?underflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAAGXZ"
		size = 220
		refs = "000e ?gptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 0024 ?egptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 003c ?to_int_type@?$char_traits@_W@std@@SAGAB_W@Z 005e _guard_check_icall 0074 ?eof@?$char_traits@_W@std@@SAGXZ 008c ?eq_int_type@?$char_traits@_W@std@@SA_NABG0@Z"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 8A B0 0E 98 ?? ?? ?? ?? 06 90 06 9B 00 2B 1A D0 0E 98 ?? ?? ?? ?? 07 90 0E 98 ?? ?? ?? ?? 08 90 07 9A 08 9B 9A 42 0E D2 0E 98 ?? ?? ?? ?? 09 90 09 98 ?? ?? ?? ?? AD F8 04 00 BD F8 04 30 AD F8 0C 30 3F E0 3E E0 0E 9B 1B 68 1C 33 0E 9C 1B 68 04 93 04 98 ?? ?? ?? ?? 04 9B 20 46 98 47 AD F8 06 00 BD F8 06 30 AD F8 02 30 ?? ?? ?? ?? AD F8 08 00 BD F8 08 30 AD F8 0A 30 0D F1 02 01 0D F1 0A 00 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 05 D0 BD F8 02 30 AD F8 0C 30 13 E0 12 E0 BD F8 02 50 0E 9B 1B 68 10 33 0E 9C 1B 68 05 93 05 98 ?? ?? ?? ?? 05 9B 20 46 29 46 98 47 BD F8 02 30 AD F8 0C 30 BD F8 0C 00 0A B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_372_1 {
	meta:
		name = "?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBAGD@Z"
		size = 86
		refs = "001c ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0028 ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0036 ??1locale@std@@QAA@XZ 0040 ?widen@?$ctype@G@std@@QBAGD@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 8B B0 6F 46 6F F0 01 03 C7 E9 08 33 17 F1 18 01 B8 6B ?? ?? ?? ?? 78 60 7B 68 BB 60 B8 68 ?? ?? ?? ?? F8 60 FB 68 3B 61 17 F1 18 00 ?? ?? ?? ?? 97 F9 3C 10 38 69 ?? ?? ?? ?? 38 80 3B 88 BB 82 B8 8A 0B B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_21_372_1 {
	meta:
		name = "?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBA_WD@Z"
		size = 86
		refs = "001c ?getloc@ios_base@std@@QBA?AVlocale@2@XZ 0028 ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0036 ??1locale@std@@QAA@XZ 0040 ?widen@?$ctype@_W@std@@QBA_WD@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 8B B0 6F 46 6F F0 01 03 C7 E9 08 33 17 F1 18 01 B8 6B ?? ?? ?? ?? 78 60 7B 68 BB 60 B8 68 ?? ?? ?? ?? F8 60 FB 68 3B 61 17 F1 18 00 ?? ?? ?? ?? 97 F9 3C 10 38 69 ?? ?? ?? ?? 38 80 3B 88 BB 82 B8 8A 0B B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_374_1 {
	meta:
		name = "?widen@?$ctype@G@std@@QBAGD@Z"
		size = 68
		refs = "001e _guard_check_icall"
		altNames = "?widen@?$ctype@_W@std@@QBA_WD@Z"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 84 B0 9D F9 24 50 08 9B 1B 68 30 33 08 9C 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 29 46 98 47 AD F8 00 00 BD F8 00 30 AD F8 08 30 BD F8 08 00 04 B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_20_375_1 {
	meta:
		name = "?xsgetn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAA_JPAG_J@Z"
		size = 370
		refs = "0034 ?_Gnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBA_JXZ 0092 ?gptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 009e ?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z 00d2 ?gbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXH@Z 00e6 _guard_check_icall 00fc ?eof@?$char_traits@G@std@@SAGXZ 0110 ?eq_int_type@?$char_traits@G@std@@SA_NABG0@Z 0126 ?to_char_type@?$char_traits@G@std@@SAGABG@Z"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B 9D B0 00 23 06 93 00 23 07 93 22 9B 10 93 23 9B 11 93 10 9B 0B 93 11 9B 00 2B C0 F2 9A 80 03 DC 0B 9B 00 2B 40 F2 95 80 20 98 ?? ?? ?? ?? 13 91 12 90 12 9B 02 93 13 9B 03 93 02 9B 14 93 03 9B 15 93 14 9B 0C 93 15 9B 00 2B 40 DB 02 DC 0C 9B 00 2B 3C D9 22 9B 16 93 23 9B 17 93 02 9B 18 93 03 9B 19 93 16 9B 0D 93 18 9B 0E 93 17 9A 19 9B 9A 42 08 DC 03 DB 0D 9A 0E 9B 9A 42 03 D2 22 9B 02 93 23 9B 03 93 20 98 ?? ?? ?? ?? 0F 90 02 9A 0F 99 21 98 ?? ?? ?? ?? 02 9B 5A 00 21 9B 13 44 21 93 06 98 07 99 02 9A 03 9B 12 18 4B 41 06 92 07 93 22 98 23 99 02 9A 03 9B 82 1A 61 EB 03 03 22 92 23 93 02 99 20 98 ?? ?? ?? ?? 40 E0 20 9B 1B 68 1C 33 20 9C 1B 68 0A 93 0A 98 ?? ?? ?? ?? 0A 9B 20 46 98 47 AD F8 20 00 BD F8 20 30 AD F8 10 30 ?? ?? ?? ?? AD F8 22 00 BD F8 22 30 AD F8 24 30 04 A9 09 A8 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 01 D0 1C E0 1A E0 04 A8 ?? ?? ?? ?? AD F8 26 00 BD F8 26 20 21 9B 1A 80 21 9B 9B 1C 21 93 06 9A 07 99 00 23 52 1C 4B 41 06 92 07 93 22 9A 23 99 00 23 52 1E 61 EB 03 03 22 92 23 93 5B E7 06 9A 07 9B 1A 92 1B 93 1A 98 1B 99 1D B0 BD E8 10 08 5D F8 14 FB }
	condition:
		$1
}

rule file_21_375_1 {
	meta:
		name = "?xsgetn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAA_JPA_W_J@Z"
		size = 370
		refs = "0034 ?_Gnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBA_JXZ 0092 ?gptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 009e ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z 00d2 ?gbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXH@Z 00e6 _guard_check_icall 00fc ?eof@?$char_traits@_W@std@@SAGXZ 0110 ?eq_int_type@?$char_traits@_W@std@@SA_NABG0@Z 0126 ?to_char_type@?$char_traits@_W@std@@SA_WABG@Z"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B 9D B0 00 23 06 93 00 23 07 93 22 9B 10 93 23 9B 11 93 10 9B 0B 93 11 9B 00 2B C0 F2 9A 80 03 DC 0B 9B 00 2B 40 F2 95 80 20 98 ?? ?? ?? ?? 13 91 12 90 12 9B 02 93 13 9B 03 93 02 9B 14 93 03 9B 15 93 14 9B 0C 93 15 9B 00 2B 40 DB 02 DC 0C 9B 00 2B 3C D9 22 9B 16 93 23 9B 17 93 02 9B 18 93 03 9B 19 93 16 9B 0D 93 18 9B 0E 93 17 9A 19 9B 9A 42 08 DC 03 DB 0D 9A 0E 9B 9A 42 03 D2 22 9B 02 93 23 9B 03 93 20 98 ?? ?? ?? ?? 0F 90 02 9A 0F 99 21 98 ?? ?? ?? ?? 02 9B 5A 00 21 9B 13 44 21 93 06 98 07 99 02 9A 03 9B 12 18 4B 41 06 92 07 93 22 98 23 99 02 9A 03 9B 82 1A 61 EB 03 03 22 92 23 93 02 99 20 98 ?? ?? ?? ?? 40 E0 20 9B 1B 68 1C 33 20 9C 1B 68 0A 93 0A 98 ?? ?? ?? ?? 0A 9B 20 46 98 47 AD F8 20 00 BD F8 20 30 AD F8 10 30 ?? ?? ?? ?? AD F8 22 00 BD F8 22 30 AD F8 24 30 04 A9 09 A8 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 01 D0 1C E0 1A E0 04 A8 ?? ?? ?? ?? AD F8 26 00 BD F8 26 20 21 9B 1A 80 21 9B 9B 1C 21 93 06 9A 07 99 00 23 52 1C 4B 41 06 92 07 93 22 9A 23 99 00 23 52 1E 61 EB 03 03 22 92 23 93 5B E7 06 9A 07 9B 1A 92 1B 93 1A 98 1B 99 1D B0 BD E8 10 08 5D F8 14 FB }
	condition:
		$1
}

rule file_20_376_1 {
	meta:
		name = "?xsputn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAA_JPBG_J@Z"
		size = 370
		refs = "0034 ?_Pnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBA_JXZ 0092 ?pptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBAPAGXZ 009e ?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z 00d2 ?pbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAAXH@Z 00da ?to_int_type@?$char_traits@G@std@@SAGABG@Z 00f4 _guard_check_icall 010c ?eof@?$char_traits@G@std@@SAGXZ 0122 ?eq_int_type@?$char_traits@G@std@@SA_NABG0@Z"
	strings:
		$1 = { 0F B4 2D E9 30 48 0D F1 08 0B 9C B0 00 23 04 93 00 23 05 93 22 9B 10 93 23 9B 11 93 10 9B 0A 93 11 9B 00 2B C0 F2 9A 80 03 DC 0A 9B 00 2B 40 F2 95 80 20 98 ?? ?? ?? ?? 13 91 12 90 12 9B 02 93 13 9B 03 93 02 9B 14 93 03 9B 15 93 14 9B 0B 93 15 9B 00 2B 40 DB 02 DC 0B 9B 00 2B 3C D9 22 9B 16 93 23 9B 17 93 02 9B 18 93 03 9B 19 93 16 9B 0C 93 18 9B 0D 93 17 9A 19 9B 9A 42 08 DC 03 DB 0C 9A 0D 9B 9A 42 03 D2 22 9B 02 93 23 9B 03 93 20 98 ?? ?? ?? ?? 0E 90 02 9A 21 99 0E 98 ?? ?? ?? ?? 02 9B 5A 00 21 9B 13 44 21 93 04 98 05 99 02 9A 03 9B 12 18 4B 41 04 92 05 93 22 98 23 99 02 9A 03 9B 82 1A 61 EB 03 03 22 92 23 93 02 99 20 98 ?? ?? ?? ?? 40 E0 21 98 ?? ?? ?? ?? AD F8 18 00 BD F8 18 50 20 9B 1B 68 0C 33 20 9C 1B 68 09 93 09 98 ?? ?? ?? ?? 09 9B 20 46 29 46 98 47 AD F8 1A 00 BD F8 1A 30 AD F8 1E 30 ?? ?? ?? ?? AD F8 1C 00 BD F8 1C 30 AD F8 20 30 0D F1 1E 01 08 A8 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 01 D0 13 E0 11 E0 21 9B 9B 1C 21 93 04 9A 05 99 00 23 52 1C 4B 41 04 92 05 93 22 9A 23 99 00 23 52 1E 61 EB 03 03 22 92 23 93 5B E7 04 9A 05 9B 1A 92 1B 93 1A 98 1B 99 1C B0 BD E8 30 08 5D F8 14 FB }
	condition:
		$1
}

rule file_21_376_1 {
	meta:
		name = "?xsputn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAA_JPB_W_J@Z"
		size = 370
		refs = "0034 ?_Pnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBA_JXZ 0092 ?pptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBAPA_WXZ 009e ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z 00d2 ?pbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAAXH@Z 00da ?to_int_type@?$char_traits@_W@std@@SAGAB_W@Z 00f4 _guard_check_icall 010c ?eof@?$char_traits@_W@std@@SAGXZ 0122 ?eq_int_type@?$char_traits@_W@std@@SA_NABG0@Z"
	strings:
		$1 = { 0F B4 2D E9 30 48 0D F1 08 0B 9C B0 00 23 04 93 00 23 05 93 22 9B 10 93 23 9B 11 93 10 9B 0A 93 11 9B 00 2B C0 F2 9A 80 03 DC 0A 9B 00 2B 40 F2 95 80 20 98 ?? ?? ?? ?? 13 91 12 90 12 9B 02 93 13 9B 03 93 02 9B 14 93 03 9B 15 93 14 9B 0B 93 15 9B 00 2B 40 DB 02 DC 0B 9B 00 2B 3C D9 22 9B 16 93 23 9B 17 93 02 9B 18 93 03 9B 19 93 16 9B 0C 93 18 9B 0D 93 17 9A 19 9B 9A 42 08 DC 03 DB 0C 9A 0D 9B 9A 42 03 D2 22 9B 02 93 23 9B 03 93 20 98 ?? ?? ?? ?? 0E 90 02 9A 21 99 0E 98 ?? ?? ?? ?? 02 9B 5A 00 21 9B 13 44 21 93 04 98 05 99 02 9A 03 9B 12 18 4B 41 04 92 05 93 22 98 23 99 02 9A 03 9B 82 1A 61 EB 03 03 22 92 23 93 02 99 20 98 ?? ?? ?? ?? 40 E0 21 98 ?? ?? ?? ?? AD F8 18 00 BD F8 18 50 20 9B 1B 68 0C 33 20 9C 1B 68 09 93 09 98 ?? ?? ?? ?? 09 9B 20 46 29 46 98 47 AD F8 1A 00 BD F8 1A 30 AD F8 1E 30 ?? ?? ?? ?? AD F8 1C 00 BD F8 1C 30 AD F8 20 30 0D F1 1E 01 08 A8 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 01 D0 13 E0 11 E0 21 9B 9B 1C 21 93 04 9A 05 99 00 23 52 1C 4B 41 04 92 05 93 22 9A 23 99 00 23 52 1E 61 EB 03 03 22 92 23 93 5B E7 04 9A 05 9B 1A 92 1B 93 1A 98 1B 99 1C B0 BD E8 30 08 5D F8 14 FB }
	condition:
		$1
}

rule file_21_61_1 {
	meta:
		name = "??0_Init_wcout@std@@QAA@XZ"
		size = 148
		refs = "002c ?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAAPAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@PAV32@@Z 0080 ?_Ptr_wclog@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0084 ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0088 ?_Ptr_wcerr@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 008c ?_Ptr_wcin@std@@3PAV?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0090 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 21 4A 1D 4B 1A 60 1E 4B 1B 68 00 2B 0B D0 1A 4B 19 68 1B 4B 1B 68 1B 68 18 1D 19 4B 1A 68 03 68 D0 18 ?? ?? ?? ?? 15 4B 1B 68 00 2B 0B D0 12 4B 19 68 12 4B 1B 68 1B 68 18 1D 10 4B 1A 68 03 68 D0 18 ?? ?? ?? ?? 0B 4B 1B 68 00 2B 0B D0 0A 4B 19 68 08 4B 1B 68 1B 68 18 1D 06 4B 1A 68 03 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_61_1 {
	meta:
		name = "??0_Init_cout@std@@QAA@XZ"
		size = 148
		refs = "002c ?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QAAPAV?$basic_ostream@DU?$char_traits@D@std@@@2@PAV32@@Z 0080 ?_Ptr_clog@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 0084 ?_Ptr_cout@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 0088 ?_Ptr_cerr@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 008c ?_Ptr_cin@std@@3PAV?$basic_istream@DU?$char_traits@D@std@@@1@A 0090 ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 21 4A 1D 4B 1A 60 1E 4B 1B 68 00 2B 0B D0 1A 4B 19 68 1B 4B 1B 68 1B 68 18 1D 19 4B 1A 68 03 68 D0 18 ?? ?? ?? ?? 15 4B 1B 68 00 2B 0B D0 12 4B 19 68 12 4B 1B 68 1B 68 18 1D 10 4B 1A 68 03 68 D0 18 ?? ?? ?? ?? 0B 4B 1B 68 00 2B 0B D0 0A 4B 19 68 08 4B 1B 68 1B 68 18 1D 06 4B 1A 68 03 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_61_1 {
	meta:
		name = "??0_Init_ushcout@std@@QAA@XZ"
		size = 148
		refs = "002c ?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QAAPAV?$basic_ostream@GU?$char_traits@G@std@@@2@PAV32@@Z 0080 ?_Ptr_wclog@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 0084 ?_Ptr_wcout@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 0088 ?_Ptr_wcerr@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 008c ?_Ptr_wcin@std@@3PAV?$basic_istream@GU?$char_traits@G@std@@@1@A 0090 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 21 4A 1D 4B 1A 60 1E 4B 1B 68 00 2B 0B D0 1A 4B 19 68 1B 4B 1B 68 1B 68 18 1D 19 4B 1A 68 03 68 D0 18 ?? ?? ?? ?? 15 4B 1B 68 00 2B 0B D0 12 4B 19 68 12 4B 1B 68 1B 68 18 1D 10 4B 1A 68 03 68 D0 18 ?? ?? ?? ?? 0B 4B 1B 68 00 2B 0B D0 0A 4B 19 68 08 4B 1B 68 1B 68 18 1D 06 4B 1A 68 03 68 D0 18 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_163_1 {
	meta:
		name = "??__Ewfout@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwfout@std@@YAXXZ 0028 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 01 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_163_1 {
	meta:
		name = "??__Efout@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Ffout@std@@YAXXZ 0028 ?fout@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 01 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_163_1 {
	meta:
		name = "??__Ewfout@std@@YAXXZ"
		size = 44
		refs = "000a __acrt_iob_func 0014 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAA@PAU_iobuf@@@Z 001a atexit 0024 ??__Fwfout@std@@YAXXZ 0028 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 01 20 ?? ?? ?? ?? 00 90 00 99 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_2_1 {
	meta:
		name = "??1?$__crt_scoped_stack_ptr@_W@@QAA@XZ"
		size = 24
		refs = "000c _freea_crt"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 68 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_355_1 {
	meta:
		name = "??1_Timevec@std@@QAA@XZ"
		size = 24
		refs = "000c free"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 9B 18 68 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_22_4_1 {
	meta:
		name = "_MallocaComputeSize"
		size = 50
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 08 33 00 93 00 9A 06 9B 9A 42 02 D9 00 9B 01 93 01 E0 00 23 01 93 01 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_22_5_1 {
	meta:
		name = "_MarkAllocaS"
		size = 44
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 00 2B 05 D0 05 9A 04 9B 1A 60 04 9B 08 33 04 93 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_22_6_1 {
	meta:
		name = "__crtCompareStringA"
		size = 976
		refs = "000a __security_push_cookie 001a __strncnt 00cc _CrtDbgReportW 01be _MallocaComputeSize 01e0 _malloc_dbg 01ec _MarkAllocaS 0200 ??0?$__crt_scoped_stack_ptr_tag@_W@@QAA@QA_W@Z 0210 ??0?$__crt_scoped_stack_ptr@_W@@QAA@U?$__crt_scoped_stack_ptr_tag@_W@@@Z 0216 ?get@?$__crt_scoped_stack_ptr@_W@@QBAPA_WXZ 0228 ??1?$__crt_scoped_stack_ptr@_W@@QAA@XZ 03a8 __security_pop_cookie 03b4 __imp_CompareStringEx 03b8 __imp_MultiByteToWideChar 03bc ??_C@_0DE@IDNOHCAD@f?3?2dd?2vctools?2crt?2crtw32?2misc?2st@ 03c0 ??_C@_1GI@NFLBIBDJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAs?$AAt@ 03c4 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 03c8 ??_C@_1HK@ELDMAMK@?$AAc?$AAc?$AAh?$AAC?$AAo?$AAu?$AAn?$AAt?$AA1?$AA?$DN?$AA?$DN?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAc?$AAc?$AAh?$AAC?$AAo?$AAu?$AAn?$AAt?$AA2?$AA?$DN?$AA?$DN?$AA1?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 03cc __imp_GetCPInfo"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? B8 B0 3F 9B 00 2B 07 DD 3F 99 3E 98 ?? ?? ?? ?? 0E 90 0E 9B 3F 93 06 E0 3F 9B B3 F1 FF 3F 02 DA 00 23 06 93 B7 E1 41 9B 00 2B 07 DD 41 99 40 98 ?? ?? ?? ?? 0F 90 0F 9B 41 93 06 E0 41 9B B3 F1 FF 3F 02 DA 00 23 06 93 A5 E1 3F 9B 00 2B 03 D0 41 9B 00 2B 40 F0 94 80 3F 9A 41 9B 9A 42 02 D1 02 23 06 93 97 E1 41 9B 01 2B 02 DD 01 23 06 93 91 E1 3F 9B 01 2B 02 DD 03 23 06 93 8B E1 32 A9 42 98 CE 4B 1B 68 98 47 10 90 10 9B 00 2B 02 D1 00 23 06 93 7F E1 3F 9B 00 2B 02 D1 41 9B 01 2B 14 D0 3F 9B 01 2B 02 D1 41 9B 00 2B 0E D0 C2 4B 01 93 C0 4B 00 93 00 23 66 22 BD 49 02 20 ?? ?? ?? ?? 11 90 11 9B 01 2B 00 D1 FE DE 3F 9B 00 2B 29 DD 32 9B 02 2B 02 D2 03 23 06 93 5B E1 0D F1 CE 03 07 93 02 E0 07 9B 9B 1C 07 93 07 9B 1B 78 00 2B 15 D0 07 9B 5B 1C 1B 78 00 2B 10 D0 3E 9B 1A 78 07 9B 1B 78 9A 42 09 DB 3E 9B 1A 78 07 9B 5B 1C 1B 78 9A 42 02 DC 02 23 06 93 3B E1 E2 E7 03 23 06 93 37 E1 41 9B 00 2B 29 DD 32 9B 02 2B 02 D2 01 23 06 93 2E E1 0D F1 CE 03 07 93 02 E0 07 9B 9B 1C 07 93 07 9B 1B 78 00 2B 15 D0 07 9B 5B 1C 1B 78 00 2B 10 D0 40 9B 1A 78 07 9B 1B 78 9A 42 09 DB 40 9B 1A 78 07 9B 5B 1C 1B 78 9A 42 02 DC 02 23 06 93 0E E1 E2 E7 01 23 06 93 0A E1 00 23 01 93 00 23 00 93 3F 9B 3E 9A 09 21 42 98 86 4C 24 68 A0 47 12 90 12 9B 0B 93 0B 9B 00 2B 02 D1 00 23 06 93 F6 E0 0B 9A 02 23 02 FB 03 F0 ?? ?? ?? ?? 13 90 13 9B 00 2B 16 D0 0B 9A 02 23 02 FB 03 F0 ?? ?? ?? ?? 14 90 98 23 78 4A 02 21 14 98 ?? ?? ?? ?? 15 90 4D F6 DD 51 15 98 ?? ?? ?? ?? 16 90 16 9B 0C 93 01 E0 00 23 0C 93 0C 99 30 A8 ?? ?? ?? ?? 17 90 17 9B 18 93 18 9B 19 68 08 A8 ?? ?? ?? ?? 08 A8 ?? ?? ?? ?? 19 90 19 9B 00 2B 07 D1 00 23 1A 93 08 A8 ?? ?? ?? ?? 1A 9B 06 93 B8 E0 08 A8 ?? ?? ?? ?? 1B 90 0B 9B 01 93 1B 9B 00 93 3F 9B 3E 9A 01 21 42 98 5B 4C 24 68 A0 47 1C 90 1C 9B 00 2B 07 D1 00 23 1D 93 08 A8 ?? ?? ?? ?? 1D 9B 06 93 9D E0 00 23 01 93 00 23 00 93 41 9B 40 9A 09 21 42 98 4F 4C 24 68 A0 47 1E 90 1E 9B 0A 93 0A 9B 00 2B 07 D1 00 23 1F 93 08 A8 ?? ?? ?? ?? 1F 9B 06 93 84 E0 0A 9A 02 23 02 FB 03 F0 ?? ?? ?? ?? 20 90 20 9B 00 2B 16 D0 0A 9A 02 23 02 FB 03 F0 ?? ?? ?? ?? 21 90 B0 23 3F 4A 02 21 21 98 ?? ?? ?? ?? 22 90 4D F6 DD 51 22 98 ?? ?? ?? ?? 23 90 23 9B 0D 93 01 E0 00 23 0D 93 0D 99 31 A8 ?? ?? ?? ?? 24 90 24 9B 25 93 25 9B 19 68 09 A8 ?? ?? ?? ?? 09 A8 ?? ?? ?? ?? 26 90 26 9B 00 2B 0A D1 00 23 27 93 09 A8 ?? ?? ?? ?? 08 A8 ?? ?? ?? ?? 27 9B 06 93 43 E0 09 A8 ?? ?? ?? ?? 28 90 0A 9B 01 93 28 9B 00 93 41 9B 40 9A 01 21 42 98 20 4C 24 68 A0 47 29 90 29 9B 2A 93 2A 9B 00 2B 0A D1 00 23 2B 93 09 A8 ?? ?? ?? ?? 08 A8 ?? ?? ?? ?? 2B 9B 06 93 23 E0 09 A8 ?? ?? ?? ?? 2C 90 08 A8 ?? ?? ?? ?? 2D 90 00 23 04 93 00 23 03 93 00 23 02 93 0A 9B 01 93 2C 9B 00 93 0B 9B 2D 9A 3D 99 3C 98 0A 4C 24 68 A0 47 2E 90 2E 9B 2F 93 09 A8 ?? ?? ?? ?? 08 A8 ?? ?? ?? ?? 2F 9B 06 93 06 98 38 B0 ?? ?? ?? ?? BD E8 10 08 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_7_1 {
	meta:
		name = "_freea_crt"
		size = 112
		refs = "002a _free_dbg 004c _CrtDbgReportW 0064 ??_C@_1GE@KPKABLEG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAv?$AAc?$AAr?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAi?$AAn?$AAc?$AA?2@ 0068 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 006c ??_C@_1FE@KNPCCODH@?$AA?$CI?$AA?$CC?$AAC?$AAo?$AAr?$AAr?$AAu?$AAp?$AAt?$AAe?$AAd?$AA?5?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAt?$AAo?$AA?5?$AA_?$AAf@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 00 2B 24 D0 06 9B 08 3B 06 93 06 9B 1B 68 02 93 02 9A 4D F6 DD 53 9A 42 04 D1 02 21 06 98 ?? ?? ?? ?? 14 E0 02 9A 4C F6 CC 43 9A 42 0F D0 0C 4B 01 93 0A 4B 00 93 00 23 40 F2 2F 12 06 49 02 20 ?? ?? ?? ?? 03 90 03 9B 01 2B 00 D1 FE DE 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_0_1 {
	meta:
		name = "_Toupper"
		size = 428
		refs = "0010 ___lc_locale_name_func 001e ___lc_codepage_func 0066 islower 00a0 __pctype_func 0116 __report_rangecheckfailure 016a __crtLCMapStringA"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 94 B0 17 9B 00 2B 0C D1 ?? ?? ?? ?? 0E 90 0E 9B 08 33 1B 68 08 93 ?? ?? ?? ?? 0F 90 0F 9B 0D 93 06 E0 17 9B 0C 33 1B 68 08 93 17 9B 1B 68 0D 93 08 9B 00 2B 0B D1 16 9B 61 2B 05 DB 16 9B 7A 2B 02 DC 16 9B 20 3B 16 93 16 9B 06 93 A4 E0 16 9B B3 F5 80 7F 1D D2 17 9B 00 2B 0A D1 16 98 ?? ?? ?? ?? 10 90 10 9B 00 2B 02 D1 16 9B 06 93 93 E0 0F E0 17 9B 19 1D 16 9A 02 23 02 FB 03 F2 0B 68 13 44 B3 F9 00 30 13 F0 02 0F 02 D1 16 9B 06 93 82 E0 17 9B 00 2B 10 D1 ?? ?? ?? ?? 11 90 16 9B 1B 12 DB B2 DA B2 02 23 02 FB 03 F2 11 9B 13 44 1B 88 03 F4 00 43 0A 93 15 E0 17 9B 19 1D 16 9B 1B 12 DA B2 02 23 02 FB 03 F2 0B 68 13 44 B3 F9 00 30 13 F4 00 4F 02 D0 01 23 09 93 01 E0 00 23 09 93 09 9B 0A 93 0A 9B 00 2B 1A D0 16 9B 1B 12 DB B2 04 AA DB B2 13 70 16 9B DA B2 04 AB 5B 1C 1A 70 02 23 0B 93 0B 9B 03 2B 00 D2 01 E0 ?? ?? ?? ?? 04 AA 0B 9B 1A 44 00 23 13 70 02 23 07 93 12 E0 16 9B DA B2 04 AB 1A 70 01 23 0C 93 0C 9B 03 2B 00 D2 01 E0 ?? ?? ?? ?? 04 AA 0C 9B 1A 44 00 23 13 70 01 23 07 93 01 23 03 93 0D 9B 02 93 03 23 01 93 05 AB 00 93 07 9B 04 AA 4F F4 00 71 08 98 ?? ?? ?? ?? 12 90 12 9B 07 93 07 9B 00 2B 02 D1 16 9B 06 93 0F E0 07 9B 01 2B 04 D1 05 AB 1B 78 06 93 08 E0 07 E0 05 AB 5B 1C 1A 78 05 AB 1B 78 1B 02 13 43 06 93 06 98 14 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_24_3_1 {
	meta:
		name = "?_Addstd@ios_base@std@@SAXPAV12@@Z"
		size = 192
		refs = "000e ??0_Lockit@std@@QAA@H@Z 00aa ??1_Lockit@std@@QAA@XZ 00b8 ?stdopens@std@@3PADA 00bc ?stdstr@std@@3PAPAVios_base@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 02 21 01 A8 ?? ?? ?? ?? 02 90 06 9B 03 F1 08 02 00 23 13 60 06 9B 08 33 1B 68 5B 1C 00 93 06 9B 03 F1 08 02 00 9B 13 60 00 9B 08 2B 18 D2 06 9B 08 33 1A 68 04 23 02 FB 03 F2 1D 4B 13 44 1B 68 00 2B 0B D0 06 9B 08 33 1A 68 04 23 02 FB 03 F2 18 4B 13 44 1A 68 06 9B 9A 42 00 D1 00 E0 D9 E7 06 9B 08 33 1A 68 04 23 02 FB 03 F2 11 4B 1A 44 06 9B 13 60 06 9B 08 33 1A 68 01 23 02 FB 03 F2 0B 4B 13 44 93 F9 00 30 5B 1C 59 B2 06 9B 08 33 1A 68 01 23 02 FB 03 F2 05 4B 13 44 19 70 01 A8 ?? ?? ?? ?? 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_4_1 {
	meta:
		name = "?_Callfns@ios_base@std@@AAAXW4event@12@@Z"
		size = 80
		refs = "0036 _guard_check_icall"
	strings:
		$1 = { 03 B4 2D E9 70 48 0D F1 0C 0B 83 B0 08 9B 2C 33 1B 68 00 93 02 E0 00 9B 1B 68 00 93 00 9B 00 2B 11 D0 00 9B 1B 1D 1E 68 08 9D 09 9C 00 9B 08 33 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 29 46 32 46 98 47 E7 E7 03 B0 BD E8 70 08 5D F8 0C FB }
	condition:
		$1
}

rule file_24_5_1 {
	meta:
		name = "?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
		size = 140
		refs = "0052 ?_Tidy@ios_base@std@@AAAXXZ 006c ??_Glocale@std@@QAAPAXI@Z 0088 ?stdopens@std@@3PADA"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 9B 08 33 1B 68 00 2B 1D D9 08 9B 08 33 1A 68 01 23 02 FB 03 F2 19 4B 13 44 93 F9 00 30 5B 1E 5B B2 8D F8 00 30 08 9B 08 33 1A 68 01 23 02 FB 03 F2 12 4B 1A 44 9D F9 00 30 13 70 9D F9 00 30 00 2B 00 DD 15 E0 08 98 ?? ?? ?? ?? 08 9B 30 33 1B 68 02 93 02 9B 01 93 01 9B 00 2B 07 D0 01 21 01 98 ?? ?? ?? ?? 03 90 03 9B 04 93 01 E0 00 23 04 93 06 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_6_1 {
	meta:
		name = "?_Tidy@ios_base@std@@AAAXXZ"
		size = 124
		refs = "000e ?_Callfns@ios_base@std@@AAAXW4event@12@@Z 0032 ??3_Crt_new_delete@std@@SAXPAX@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 00 21 08 98 ?? ?? ?? ?? 08 9B 28 33 1B 68 00 93 01 E0 02 9B 00 93 00 9B 00 2B 08 D0 00 9B 1B 68 02 93 00 9B 03 93 03 98 ?? ?? ?? ?? F1 E7 08 9B 03 F1 28 02 00 23 13 60 08 9B 2C 33 1B 68 01 93 01 E0 04 9B 01 93 01 9B 00 2B 08 D0 01 9B 1B 68 04 93 01 9B 05 93 05 98 ?? ?? ?? ?? F1 E7 08 9B 03 F1 2C 02 00 23 13 60 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_25_0_1 {
	meta:
		name = "_Stoll"
		size = 48
		refs = "0012 _Stollx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 00 23 08 9A 07 99 06 98 ?? ?? ?? ?? 01 91 00 90 00 9A 01 9B 02 92 03 93 02 98 03 99 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_73_0_1 {
	meta:
		name = "_Stoull"
		size = 48
		refs = "0012 _Stoullx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 00 23 08 9A 07 99 06 98 ?? ?? ?? ?? 01 91 00 90 00 9A 01 9B 02 92 03 93 02 98 03 99 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_25_1_1 {
	meta:
		name = "_Stollx"
		size = 368
		refs = "0028 isspace 006e _Stoullx 00f6 _errno"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 98 B0 1B 9B 00 2B 01 D1 07 AB 1B 93 1A 9B 01 93 02 E0 01 9B 5B 1C 01 93 01 9B 93 F9 00 30 D8 B2 ?? ?? ?? ?? 03 90 03 9B 00 2B 00 D0 F1 E7 01 9B 93 F9 00 30 2D 2B 07 D0 01 9B 93 F9 00 30 2B 2B 02 D0 2B 23 02 93 06 E0 01 9B 93 F9 00 30 02 93 01 9B 5B 1C 01 93 02 9B 5B B2 8D F8 00 30 1D 9B 1C 9A 1B 99 01 98 ?? ?? ?? ?? 11 91 10 90 10 9B 08 93 11 9B 09 93 01 9A 1B 9B 1B 68 9A 42 02 D1 1A 9A 1B 9B 1A 60 1A 9A 1B 9B 1B 68 9A 42 08 D1 08 9B 12 93 09 9B 13 93 13 9A 12 9B 13 43 00 2B 25 D1 9D F9 00 30 2B 2B 0F D1 08 9B 14 93 09 9B 15 93 14 9B 04 93 15 9A 6F F0 00 43 9A 42 16 D8 03 D3 04 9B B3 F1 FF 3F 11 D8 9D F9 00 30 2D 2B 2F D1 08 9B 16 93 09 9B 17 93 16 9B 05 93 17 9B B3 F1 00 4F 25 D3 02 D8 05 9B 00 2B 21 D9 ?? ?? ?? ?? 06 90 06 9A 22 23 13 60 1D 9B 00 2B 02 D0 1D 9A 01 23 13 60 9D F9 00 30 2D 2B 05 D1 00 23 0A 93 4F F0 00 43 0B 93 05 E0 6F F0 00 03 0A 93 6F F0 00 43 0B 93 0A 9A 0B 9B 0E 92 0F 93 14 E0 13 E0 9D F9 00 30 2D 2B 07 D1 08 9A 09 99 00 23 52 42 8B 41 0C 92 0D 93 03 E0 08 9B 0C 93 09 9B 0D 93 0C 9A 0D 9B 0E 92 0F 93 0E 98 0F 99 18 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_26_0_1 {
	meta:
		name = "?_New_handler_interface@std@@YAHI@Z"
		size = 48
		refs = "0012 _guard_check_icall 002c ?_New_handler@std@@3P6AXXZA"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 08 4B 1B 68 00 93 00 98 ?? ?? ?? ?? 00 9B 98 47 01 23 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_1_1 {
	meta:
		name = "?get_new_handler@std@@YAP6AXXZXZ"
		size = 56
		refs = "0018 ??0_Lockit@std@@QAA@H@Z 0024 ??1_Lockit@std@@QAA@XZ 0034 ?_New_handler@std@@3P6AXXZA"
	strings:
		$1 = { 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 01 21 38 46 ?? ?? ?? ?? 05 4B 1B 68 7B 60 38 46 ?? ?? ?? ?? 7B 68 BB 60 B8 68 07 B0 BD E8 80 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_2_1 {
	meta:
		name = "?set_new_handler@std@@YAP6AXXZP6AXXZ@Z"
		size = 104
		refs = "001c ??0_Lockit@std@@QAA@H@Z 003e _set_new_handler 004a ??1_Lockit@std@@QAA@XZ 0060 ?_New_handler_interface@std@@YAHI@Z 0064 ?_New_handler@std@@3P6AXXZA"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 01 21 17 F1 08 00 ?? ?? ?? ?? 10 4B 1B 68 7B 60 3A 6B 0E 4B 1A 60 3B 6B 00 2B 02 D0 0B 4B 3B 60 01 E0 00 23 3B 60 38 68 ?? ?? ?? ?? 7B 68 FB 60 17 F1 08 00 ?? ?? ?? ?? FB 68 3B 61 38 69 09 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_0_1 {
	meta:
		name = "_LXp_addh"
		size = 1300
		refs = "0022 _LDunscale 0044 _LDtest 0072 _LPmsw 0098 _Feraise 015c _LNan 0348 _LDint 0352 _LDscale"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 9C B0 8D ED 04 0B 9D ED 04 0B 8D ED 0E 0B 1F 9B 00 2B 00 D1 6D E2 0E A9 03 A8 ?? ?? ?? ?? AD F8 28 00 BD F9 28 30 AD F8 04 30 BD F9 04 30 00 2B 40 DD BD F9 04 30 02 2B 0C D0 1E 98 ?? ?? ?? ?? AD F8 2A 00 BD F9 2A 30 AD F8 04 30 BD F9 04 30 00 2B 05 DC 1E 9B 9D ED 04 0B 83 ED 00 0B 28 E0 BD F9 04 30 02 2B 11 D0 04 A8 ?? ?? ?? ?? 10 90 1E 98 ?? ?? ?? ?? 11 90 10 9B 1B 88 03 F4 00 42 11 9B 1B 88 03 F4 00 43 9A 42 00 D1 11 E0 01 20 ?? ?? ?? ?? 1E 9A 2F 4B 93 ED 00 0B 82 ED 00 0B 1F 9B 01 2B 05 DD 1E 9B 08 33 9F ED 28 0B 83 ED 00 0B 1E E2 BD F9 04 30 00 2B 80 F2 1A 82 4F F4 00 63 08 93 00 23 00 93 00 9A 1F 9B 9A 42 80 F2 10 82 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B 8D ED 1A 0B 1A 23 09 93 1A A9 0D F1 06 00 ?? ?? ?? ?? AD F8 2C 00 BD F9 2C 30 AD F8 04 30 BD F9 04 30 00 2B 01 DD F3 E1 F1 E1 BD F9 04 30 00 2B 22 D1 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 9D ED 04 0B 83 ED 00 0B 00 9B 5A 1C 1F 9B 9A 42 0A DA 00 9B 5A 1C 08 23 02 FB 03 F2 1E 9B 13 44 9F ED 02 0B 83 ED 00 0B D3 E1 FE DE 00 00 00 00 00 00 00 00 ?? ?? ?? ?? CA E1 BD F9 06 20 BD F9 0C 30 D3 1A 0C 93 09 9B 5A 42 0C 9B 93 42 56 DC 9D ED 04 0B B5 EE 40 0B F1 EE 10 FA 4F D0 00 9B 02 93 02 9B 5B 1C 02 93 02 9A 1F 9B 9A 42 0D DA 02 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 D0 EA E7 1F 9B 5A 1E 02 9B 93 42 03 DA 02 9B 5B 1C 02 93 06 E0 02 9A 1F 9B 9A 42 02 D1 02 9B 5B 1E 02 93 02 E0 02 9B 5B 1E 02 93 00 9A 02 9B 9A 42 11 DA 02 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 99 18 02 9A 08 23 02 FB 03 F2 1E 9B 13 44 91 ED 00 0B 83 ED 00 0B E6 E7 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 9D ED 04 0B 83 ED 00 0B 9F ED BB 0B 8D ED 04 0B 68 E1 09 9A 0C 9B 9A 42 0D DC 9D ED 04 0B B5 EE 40 0B F1 EE 10 FA 06 D0 BD F9 06 30 08 93 00 9B 5B 1C 00 93 56 E1 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 1B 9D ED 04 0B 31 EE 00 0B 8D ED 14 0B 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 9D ED 14 0B 83 ED 00 0B 9D ED 14 0B B5 EE 40 0B F1 EE 10 FA 41 D1 00 9B 06 93 06 9B 5B 1C 06 93 06 9A 1F 9B 9A 42 1F DA 06 9A 08 23 02 FB 03 F2 1E 9B 99 18 06 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 91 ED 00 0B 83 ED 00 0B 06 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 D0 D8 E7 1F 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 9F ED 88 0B 83 ED 00 0B 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 D1 F6 E0 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B 8D ED 04 0B 04 A9 03 A8 ?? ?? ?? ?? 08 9A 09 9B D2 1A BD F9 0C 30 9A 42 80 F2 80 80 BD F9 0C 10 08 9A 09 9B D3 1A CB 1A 19 B2 04 A8 ?? ?? ?? ?? BD F9 0C 10 04 A8 ?? ?? ?? ?? 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 1B 9D ED 04 0B 31 EE 40 0B 8D ED 16 0B 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 9D ED 16 0B 83 ED 00 0B 9D ED 16 0B B5 EE 40 0B F1 EE 10 FA 33 D1 00 9B 07 93 07 9B 5B 1C 07 93 07 9A 1F 9B 9A 42 1F DA 07 9A 08 23 02 FB 03 F2 1E 9B 99 18 07 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 91 ED 00 0B 83 ED 00 0B 07 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 D0 D8 E7 1F 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 9F ED 45 0B 83 ED 00 0B 00 9B 5B 1E 00 93 00 9B 00 2B 03 D1 4F F4 00 63 08 93 12 E0 00 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B 8D ED 0E 0B 0E A9 0D F1 06 00 ?? ?? ?? ?? BD F9 06 30 08 93 5F E0 00 9B 5A 1C 1F 9B 9A 42 01 D1 5A E0 58 E0 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B 8D ED 04 0B 00 9A 08 23 02 FB 03 F2 1E 9B 99 18 0D F1 06 00 ?? ?? ?? ?? 1A 21 00 9A 08 23 02 FB 03 F2 1E 9B 98 18 ?? ?? ?? ?? BD F9 06 10 00 9A 08 23 02 FB 03 F2 1E 9B 98 18 ?? ?? ?? ?? 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 9D ED 04 1B 93 ED 00 0B 31 EE 40 0B 8D ED 04 0B BD F9 06 30 08 93 9D ED 04 0B B5 EE 40 0B F1 EE 10 FA 04 D0 9D ED 04 0B 8D ED 18 0B 09 E0 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B 8D ED 18 0B 9D ED 18 0B 8D ED 0E 0B 0E A9 03 A8 ?? ?? ?? ?? 00 9B 5B 1C 00 93 EA E5 1E 9B 12 93 12 98 1C B0 5D F8 04 BB 5D F8 0C FB FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_119_0_1 {
	meta:
		name = "_Xp_addh"
		size = 1300
		refs = "0022 _Dunscale 0044 _Dtest 0072 _Pmsw 0098 _Feraise 015c _Nan 0348 _Dint 0352 _Dscale"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 9C B0 8D ED 04 0B 9D ED 04 0B 8D ED 0E 0B 1F 9B 00 2B 00 D1 6D E2 0E A9 03 A8 ?? ?? ?? ?? AD F8 28 00 BD F9 28 30 AD F8 04 30 BD F9 04 30 00 2B 40 DD BD F9 04 30 02 2B 0C D0 1E 98 ?? ?? ?? ?? AD F8 2A 00 BD F9 2A 30 AD F8 04 30 BD F9 04 30 00 2B 05 DC 1E 9B 9D ED 04 0B 83 ED 00 0B 28 E0 BD F9 04 30 02 2B 11 D0 04 A8 ?? ?? ?? ?? 10 90 1E 98 ?? ?? ?? ?? 11 90 10 9B 1B 88 03 F4 00 42 11 9B 1B 88 03 F4 00 43 9A 42 00 D1 11 E0 01 20 ?? ?? ?? ?? 1E 9A 2F 4B 93 ED 00 0B 82 ED 00 0B 1F 9B 01 2B 05 DD 1E 9B 08 33 9F ED 28 0B 83 ED 00 0B 1E E2 BD F9 04 30 00 2B 80 F2 1A 82 4F F4 00 63 08 93 00 23 00 93 00 9A 1F 9B 9A 42 80 F2 10 82 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B 8D ED 1A 0B 1A 23 09 93 1A A9 0D F1 06 00 ?? ?? ?? ?? AD F8 2C 00 BD F9 2C 30 AD F8 04 30 BD F9 04 30 00 2B 01 DD F3 E1 F1 E1 BD F9 04 30 00 2B 22 D1 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 9D ED 04 0B 83 ED 00 0B 00 9B 5A 1C 1F 9B 9A 42 0A DA 00 9B 5A 1C 08 23 02 FB 03 F2 1E 9B 13 44 9F ED 02 0B 83 ED 00 0B D3 E1 FE DE 00 00 00 00 00 00 00 00 ?? ?? ?? ?? CA E1 BD F9 06 20 BD F9 0C 30 D3 1A 0C 93 09 9B 5A 42 0C 9B 93 42 56 DC 9D ED 04 0B B5 EE 40 0B F1 EE 10 FA 4F D0 00 9B 02 93 02 9B 5B 1C 02 93 02 9A 1F 9B 9A 42 0D DA 02 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 D0 EA E7 1F 9B 5A 1E 02 9B 93 42 03 DA 02 9B 5B 1C 02 93 06 E0 02 9A 1F 9B 9A 42 02 D1 02 9B 5B 1E 02 93 02 E0 02 9B 5B 1E 02 93 00 9A 02 9B 9A 42 11 DA 02 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 99 18 02 9A 08 23 02 FB 03 F2 1E 9B 13 44 91 ED 00 0B 83 ED 00 0B E6 E7 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 9D ED 04 0B 83 ED 00 0B 9F ED BB 0B 8D ED 04 0B 68 E1 09 9A 0C 9B 9A 42 0D DC 9D ED 04 0B B5 EE 40 0B F1 EE 10 FA 06 D0 BD F9 06 30 08 93 00 9B 5B 1C 00 93 56 E1 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 1B 9D ED 04 0B 31 EE 00 0B 8D ED 14 0B 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 9D ED 14 0B 83 ED 00 0B 9D ED 14 0B B5 EE 40 0B F1 EE 10 FA 41 D1 00 9B 06 93 06 9B 5B 1C 06 93 06 9A 1F 9B 9A 42 1F DA 06 9A 08 23 02 FB 03 F2 1E 9B 99 18 06 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 91 ED 00 0B 83 ED 00 0B 06 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 D0 D8 E7 1F 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 9F ED 88 0B 83 ED 00 0B 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 D1 F6 E0 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B 8D ED 04 0B 04 A9 03 A8 ?? ?? ?? ?? 08 9A 09 9B D2 1A BD F9 0C 30 9A 42 80 F2 80 80 BD F9 0C 10 08 9A 09 9B D3 1A CB 1A 19 B2 04 A8 ?? ?? ?? ?? BD F9 0C 10 04 A8 ?? ?? ?? ?? 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 1B 9D ED 04 0B 31 EE 40 0B 8D ED 16 0B 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 9D ED 16 0B 83 ED 00 0B 9D ED 16 0B B5 EE 40 0B F1 EE 10 FA 33 D1 00 9B 07 93 07 9B 5B 1C 07 93 07 9A 1F 9B 9A 42 1F DA 07 9A 08 23 02 FB 03 F2 1E 9B 99 18 07 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 91 ED 00 0B 83 ED 00 0B 07 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 D0 D8 E7 1F 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 9F ED 45 0B 83 ED 00 0B 00 9B 5B 1E 00 93 00 9B 00 2B 03 D1 4F F4 00 63 08 93 12 E0 00 9B 5A 1E 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B 8D ED 0E 0B 0E A9 0D F1 06 00 ?? ?? ?? ?? BD F9 06 30 08 93 5F E0 00 9B 5A 1C 1F 9B 9A 42 01 D1 5A E0 58 E0 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B 8D ED 04 0B 00 9A 08 23 02 FB 03 F2 1E 9B 99 18 0D F1 06 00 ?? ?? ?? ?? 1A 21 00 9A 08 23 02 FB 03 F2 1E 9B 98 18 ?? ?? ?? ?? BD F9 06 10 00 9A 08 23 02 FB 03 F2 1E 9B 98 18 ?? ?? ?? ?? 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 9D ED 04 1B 93 ED 00 0B 31 EE 40 0B 8D ED 04 0B BD F9 06 30 08 93 9D ED 04 0B B5 EE 40 0B F1 EE 10 FA 04 D0 9D ED 04 0B 8D ED 18 0B 09 E0 00 9A 08 23 02 FB 03 F2 1E 9B 13 44 93 ED 00 0B 8D ED 18 0B 9D ED 18 0B 8D ED 0E 0B 0E A9 03 A8 ?? ?? ?? ?? 00 9B 5B 1C 00 93 EA E5 1E 9B 12 93 12 98 1C B0 5D F8 04 BB 5D F8 0C FB FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_27_1_1 {
	meta:
		name = "_LXp_addx"
		size = 98
		refs = "004c _LXp_addh"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 00 23 00 93 02 E0 00 9B 5B 1C 00 93 00 9A 07 9B 9A 42 19 DA 00 9A 08 23 02 FB 03 F2 06 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 0C D0 00 9A 08 23 02 FB 03 F2 06 9B 13 44 93 ED 00 0B 05 99 04 98 ?? ?? ?? ?? DE E7 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_119_1_1 {
	meta:
		name = "_Xp_addx"
		size = 98
		refs = "004c _Xp_addh"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 00 23 00 93 02 E0 00 9B 5B 1C 00 93 00 9A 07 9B 9A 42 19 DA 00 9A 08 23 02 FB 03 F2 06 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 0C D0 00 9A 08 23 02 FB 03 F2 06 9B 13 44 93 ED 00 0B 05 99 04 98 ?? ?? ?? ?? DE E7 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_27_2_1 {
	meta:
		name = "_LXp_getw"
		size = 296
		altNames = "_Xp_getw"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 09 9B 00 2B 05 D1 9F ED 43 0B 8D ED 00 0B 7B E0 7A E0 09 9B 01 2B 10 D0 08 9B 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 08 D0 08 9B 08 33 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 06 D1 08 9B 93 ED 00 0B 8D ED 00 0B 60 E0 5F E0 09 9B 02 2B 08 D0 08 9B 10 33 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 0C D1 08 9A 08 9B 08 33 92 ED 00 1B 93 ED 00 0B 31 EE 00 0B 8D ED 00 0B 47 E0 46 E0 08 9A 08 9B 08 33 92 ED 00 1B 93 ED 00 0B 31 EE 00 0B 8D ED 04 0B 08 9B 10 33 93 ED 00 0B 8D ED 02 0B 09 9B 04 2B 09 DB 08 9B 18 33 9D ED 02 1B 93 ED 00 0B 31 EE 00 0B 8D ED 02 0B 08 9B 9D ED 04 1B 93 ED 00 0B 31 EE 40 1B 08 9B 08 33 93 ED 00 0B B4 EE 40 1B F1 EE 10 FA 09 D1 9D ED 04 1B 9D ED 02 0B 31 EE 00 0B 8D ED 00 0B 0F E0 0E E0 08 9A 08 9B 08 33 93 ED 00 1B 9D ED 02 0B 31 EE 00 1B 92 ED 00 0B 30 EE 01 0B 8D ED 00 0B 9D ED 00 0B 06 B0 5D F8 04 BB 5D F8 0C FB 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_27_3_1 {
	meta:
		name = "_LXp_invx"
		size = 312
		refs = "0014 _LDtest 0086 _LXp_movx 0092 _LXp_mulh 00c0 _LXp_setw 00ee _LXp_mulx 00fa _LXp_addh 0116 _LXp_addx 012c _LInf"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0D 9B 00 2B 00 D1 84 E0 0C 98 ?? ?? ?? ?? AD F8 0A 00 BD F9 0A 30 AD F8 08 30 BD F9 08 30 00 2B 14 DB BD F9 08 30 01 2B 05 D1 0C 9B 9F ED 3E 0B 83 ED 00 0B 09 E0 BD F9 08 30 00 2B 05 D1 0C 9A 38 4B 93 ED 00 0B 82 ED 00 0B 62 E0 0E 9B 03 93 0D 9A 08 23 02 FB 03 F2 0E 9B 13 44 04 93 0D 9A 08 23 02 FB 03 F2 04 9B 13 44 06 93 0C 9B 93 ED 00 0B 8D ED 08 0B 0C 9A 0D 99 04 98 ?? ?? ?? ?? BF EE 00 0B 0D 99 04 98 ?? ?? ?? ?? 0D 9B 01 2B 09 DD 0C 9B 08 33 9D ED 08 1B 93 ED 00 0B 31 EE 00 0B 8D ED 08 0B B7 EE 00 1B 9D ED 08 0B 81 EE 00 0B 0D 99 0C 98 ?? ?? ?? ?? 01 23 05 93 02 E0 05 9B 5B 00 05 93 05 9A 0D 9B 9A 42 21 DA 0C 9A 0D 99 03 98 ?? ?? ?? ?? 06 9B 00 93 0D 9B 04 9A 0D 99 03 98 ?? ?? ?? ?? B7 EE 00 0B 0D 99 03 98 ?? ?? ?? ?? 06 9B 00 93 0D 9B 0C 9A 0D 99 03 98 ?? ?? ?? ?? 0D 9B 03 9A 0D 99 0C 98 ?? ?? ?? ?? D6 E7 0C 9B 07 93 07 98 0A B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_119_3_1 {
	meta:
		name = "_Xp_invx"
		size = 312
		refs = "0014 _Dtest 0086 _Xp_movx 0092 _Xp_mulh 00c0 _Xp_setw 00ee _Xp_mulx 00fa _Xp_addh 0116 _Xp_addx 012c _Inf"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8A B0 0D 9B 00 2B 00 D1 84 E0 0C 98 ?? ?? ?? ?? AD F8 0A 00 BD F9 0A 30 AD F8 08 30 BD F9 08 30 00 2B 14 DB BD F9 08 30 01 2B 05 D1 0C 9B 9F ED 3E 0B 83 ED 00 0B 09 E0 BD F9 08 30 00 2B 05 D1 0C 9A 38 4B 93 ED 00 0B 82 ED 00 0B 62 E0 0E 9B 03 93 0D 9A 08 23 02 FB 03 F2 0E 9B 13 44 04 93 0D 9A 08 23 02 FB 03 F2 04 9B 13 44 06 93 0C 9B 93 ED 00 0B 8D ED 08 0B 0C 9A 0D 99 04 98 ?? ?? ?? ?? BF EE 00 0B 0D 99 04 98 ?? ?? ?? ?? 0D 9B 01 2B 09 DD 0C 9B 08 33 9D ED 08 1B 93 ED 00 0B 31 EE 00 0B 8D ED 08 0B B7 EE 00 1B 9D ED 08 0B 81 EE 00 0B 0D 99 0C 98 ?? ?? ?? ?? 01 23 05 93 02 E0 05 9B 5B 00 05 93 05 9A 0D 9B 9A 42 21 DA 0C 9A 0D 99 03 98 ?? ?? ?? ?? 06 9B 00 93 0D 9B 04 9A 0D 99 03 98 ?? ?? ?? ?? B7 EE 00 0B 0D 99 03 98 ?? ?? ?? ?? 06 9B 00 93 0D 9B 0C 9A 0D 99 03 98 ?? ?? ?? ?? 0D 9B 03 9A 0D 99 0C 98 ?? ?? ?? ?? D6 E7 0C 9B 07 93 07 98 0A B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_27_4_1 {
	meta:
		name = "_LXp_ldexpx"
		size = 122
		refs = "0030 ldexpl"
		altNames = "_Xp_ldexpx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 00 23 00 93 02 E0 00 9B 5B 1C 00 93 00 9A 07 9B 9A 42 25 DA 08 98 00 9A 08 23 02 FB 03 F2 06 9B 13 44 93 ED 00 0B ?? ?? ?? ?? 8D ED 02 0B 00 9A 08 23 02 FB 03 F2 06 9B 13 44 9D ED 02 0B 83 ED 00 0B 00 9A 08 23 02 FB 03 F2 06 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 D1 00 E0 D2 E7 06 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_27_5_1 {
	meta:
		name = "_LXp_movx"
		size = 42
		refs = "0016 memcpy"
		altNames = "_Xp_movx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 9A 08 23 02 FB 03 F2 06 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_27_6_1 {
	meta:
		name = "_LXp_mulh"
		size = 532
		refs = "0008 __security_push_cookie 002e _LDtest 0050 _Feraise 016c _LDunscale 0174 _LDint 017e _LDscale 018a _LXp_addh 01fe __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 93 B0 8D ED 08 0B 17 9B 00 2B 38 DD 16 9B 93 ED 00 1B 9D ED 08 0B 21 EE 00 0B 0A AB 83 ED 00 0B 0A A8 ?? ?? ?? ?? AD F8 10 00 BD F9 10 30 AD F8 04 30 BD F9 04 30 00 2B 1C DB BD F9 04 30 02 2B 02 D1 01 20 ?? ?? ?? ?? 0A AA 16 9B 92 ED 00 0B 83 ED 00 0B BD F9 04 30 00 2B 08 DD 17 9B 01 2B 05 DD 16 9B 08 33 9F ED 66 0B 83 ED 00 0B 16 9B 05 93 BC E0 16 9B 9F ED 62 0B 83 ED 00 0B 01 23 00 93 00 23 02 93 05 E0 02 9B 5B 1C 02 93 00 9B 5B 1E 00 93 02 9A 17 9B 9A 42 80 F2 A6 80 02 E0 00 9B 5B 1C 00 93 00 9B 04 2B 45 DA 02 9A 00 9B 1A 44 17 9B 9A 42 31 DA 02 9A 00 9B 1A 44 08 23 02 FB 03 F2 16 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 22 D0 02 9A 00 9B 1A 44 08 23 02 FB 03 F2 16 9B 13 44 93 ED 00 1B 9D ED 08 0B 21 EE 00 0B 00 9A 08 23 02 FB 03 F2 0A AB 13 44 83 ED 00 0B 02 9A 00 9B 1A 44 08 23 02 FB 03 F2 16 9B 13 44 9F ED 3B 0B 83 ED 00 0B 0C E0 00 9A 08 23 02 FB 03 F2 0A AB 13 44 9F ED 35 0B 83 ED 00 0B 08 23 00 93 00 E0 B3 E7 0A AB 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 01 D1 4F E0 4D E0 00 23 03 93 0A AB 93 ED 00 0B 8D ED 06 0B 06 A9 0D F1 12 00 ?? ?? ?? ?? 1A 21 06 A8 ?? ?? ?? ?? BD F9 12 10 06 A8 ?? ?? ?? ?? 9D ED 06 0B 17 99 16 98 ?? ?? ?? ?? 0A AB 93 ED 00 1B 9D ED 06 0B 31 EE 40 0B 17 99 16 98 ?? ?? ?? ?? 03 9B 5B 1C 03 93 03 9A 00 9B 9A 42 20 DA 03 9A 08 23 02 FB 03 F2 0A AB 99 18 03 9B 5A 1E 08 23 02 FB 03 F2 0A AB 13 44 91 ED 00 0B 83 ED 00 0B 03 9B 5A 1E 08 23 02 FB 03 F2 0A AB 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 D1 00 E0 D7 E7 4E E7 16 9B 05 93 05 98 13 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_119_6_1 {
	meta:
		name = "_Xp_mulh"
		size = 532
		refs = "0008 __security_push_cookie 002e _Dtest 0050 _Feraise 016c _Dunscale 0174 _Dint 017e _Dscale 018a _Xp_addh 01fe __security_pop_cookie"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 93 B0 8D ED 08 0B 17 9B 00 2B 38 DD 16 9B 93 ED 00 1B 9D ED 08 0B 21 EE 00 0B 0A AB 83 ED 00 0B 0A A8 ?? ?? ?? ?? AD F8 10 00 BD F9 10 30 AD F8 04 30 BD F9 04 30 00 2B 1C DB BD F9 04 30 02 2B 02 D1 01 20 ?? ?? ?? ?? 0A AA 16 9B 92 ED 00 0B 83 ED 00 0B BD F9 04 30 00 2B 08 DD 17 9B 01 2B 05 DD 16 9B 08 33 9F ED 66 0B 83 ED 00 0B 16 9B 05 93 BC E0 16 9B 9F ED 62 0B 83 ED 00 0B 01 23 00 93 00 23 02 93 05 E0 02 9B 5B 1C 02 93 00 9B 5B 1E 00 93 02 9A 17 9B 9A 42 80 F2 A6 80 02 E0 00 9B 5B 1C 00 93 00 9B 04 2B 45 DA 02 9A 00 9B 1A 44 17 9B 9A 42 31 DA 02 9A 00 9B 1A 44 08 23 02 FB 03 F2 16 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 22 D0 02 9A 00 9B 1A 44 08 23 02 FB 03 F2 16 9B 13 44 93 ED 00 1B 9D ED 08 0B 21 EE 00 0B 00 9A 08 23 02 FB 03 F2 0A AB 13 44 83 ED 00 0B 02 9A 00 9B 1A 44 08 23 02 FB 03 F2 16 9B 13 44 9F ED 3B 0B 83 ED 00 0B 0C E0 00 9A 08 23 02 FB 03 F2 0A AB 13 44 9F ED 35 0B 83 ED 00 0B 08 23 00 93 00 E0 B3 E7 0A AB 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 01 D1 4F E0 4D E0 00 23 03 93 0A AB 93 ED 00 0B 8D ED 06 0B 06 A9 0D F1 12 00 ?? ?? ?? ?? 1A 21 06 A8 ?? ?? ?? ?? BD F9 12 10 06 A8 ?? ?? ?? ?? 9D ED 06 0B 17 99 16 98 ?? ?? ?? ?? 0A AB 93 ED 00 1B 9D ED 06 0B 31 EE 40 0B 17 99 16 98 ?? ?? ?? ?? 03 9B 5B 1C 03 93 03 9A 00 9B 9A 42 20 DA 03 9A 08 23 02 FB 03 F2 0A AB 99 18 03 9B 5A 1E 08 23 02 FB 03 F2 0A AB 13 44 91 ED 00 0B 83 ED 00 0B 03 9B 5A 1E 08 23 02 FB 03 F2 0A AB 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 D1 00 E0 D7 E7 4E E7 16 9B 05 93 05 98 13 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_27_7_1 {
	meta:
		name = "_LXp_mulx"
		size = 226
		refs = "0044 _LXp_mulh 0062 _LXp_movx 00cc _LXp_addx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 07 9B 00 2B 02 D0 09 9B 00 2B 00 D1 5C E0 08 9B 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 08 D0 08 9B 08 33 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 07 D1 08 9B 93 ED 00 0B 07 99 06 98 ?? ?? ?? ?? 43 E0 0A 9B 02 93 07 9A 08 23 02 FB 03 F2 0A 9B 13 44 01 93 06 9A 07 99 02 98 ?? ?? ?? ?? 08 9B 93 ED 00 0B 07 99 06 98 ?? ?? ?? ?? 01 23 00 93 02 E0 00 9B 5B 1C 00 93 00 9A 09 9B 9A 42 24 DA 00 9A 08 23 02 FB 03 F2 08 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 17 D0 02 9A 07 99 01 98 ?? ?? ?? ?? 00 9A 08 23 02 FB 03 F2 08 9B 13 44 93 ED 00 0B 07 99 01 98 ?? ?? ?? ?? 07 9B 01 9A 07 99 06 98 ?? ?? ?? ?? D3 E7 06 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_119_7_1 {
	meta:
		name = "_Xp_mulx"
		size = 226
		refs = "0044 _Xp_mulh 0062 _Xp_movx 00cc _Xp_addx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 84 B0 07 9B 00 2B 02 D0 09 9B 00 2B 00 D1 5C E0 08 9B 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 08 D0 08 9B 08 33 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 07 D1 08 9B 93 ED 00 0B 07 99 06 98 ?? ?? ?? ?? 43 E0 0A 9B 02 93 07 9A 08 23 02 FB 03 F2 0A 9B 13 44 01 93 06 9A 07 99 02 98 ?? ?? ?? ?? 08 9B 93 ED 00 0B 07 99 06 98 ?? ?? ?? ?? 01 23 00 93 02 E0 00 9B 5B 1C 00 93 00 9A 09 9B 9A 42 24 DA 00 9A 08 23 02 FB 03 F2 08 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 17 D0 02 9A 07 99 01 98 ?? ?? ?? ?? 00 9A 08 23 02 FB 03 F2 08 9B 13 44 93 ED 00 0B 07 99 01 98 ?? ?? ?? ?? 07 9B 01 9A 07 99 06 98 ?? ?? ?? ?? D3 E7 06 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_27_8_1 {
	meta:
		name = "_LXp_setn"
		size = 44
		refs = "0018 _LXp_setw"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9B 00 EE 10 3A B8 EE C0 0B 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_119_8_1 {
	meta:
		name = "_Xp_setn"
		size = 44
		refs = "0018 _Xp_setw"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9B 00 EE 10 3A B8 EE C0 0B 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_27_9_1 {
	meta:
		name = "_LXp_setw"
		size = 336
		refs = "0028 _LDunscale 0070 _LDint 007a _LDscale"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 88 B0 8D ED 06 0B 9D ED 06 0B 8D ED 04 0B 0B 9B 00 2B 00 DC 8B E0 0B 9B 01 2B 0D D0 04 A9 68 46 ?? ?? ?? ?? AD F8 04 00 BD F9 04 30 AD F8 02 30 BD F9 02 30 00 2B 05 D1 0A 9B 9D ED 04 0B 83 ED 00 0B 74 E0 BD F9 02 30 00 2B 0B DD 0A 9B 9D ED 04 0B 83 ED 00 0B 0A 9B 08 33 9F ED 39 0B 83 ED 00 0B 64 E0 1A 21 04 A8 ?? ?? ?? ?? BD F9 00 10 04 A8 ?? ?? ?? ?? 0A 9B 9D ED 04 0B 83 ED 00 0B 9D ED 06 1B 9D ED 04 0B 31 EE 40 0B 0A 9B 08 33 83 ED 00 0B 0B 9B 02 2B 40 DD 0A 9B 08 33 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 37 D0 0A 9B 08 33 93 ED 00 0B 8D ED 06 0B 0A 9B 03 F1 08 01 68 46 ?? ?? ?? ?? 1A 21 0A 9B 03 F1 08 00 ?? ?? ?? ?? BD F9 00 10 0A 9B 03 F1 08 00 ?? ?? ?? ?? 0A 9B 08 33 9D ED 06 1B 93 ED 00 0B 31 EE 40 0B 0A 9B 10 33 83 ED 00 0B 0B 9B 03 2B 0E DD 0A 9B 10 33 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 05 D0 0A 9B 18 33 9F ED 0B 0B 83 ED 00 0B 08 E0 0B 9B 02 2B 05 DD 0A 9B 10 33 9F ED 06 0B 83 ED 00 0B 0A 9B 02 93 02 98 08 B0 5D F8 04 BB 5D F8 0C FB FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_119_9_1 {
	meta:
		name = "_Xp_setw"
		size = 336
		refs = "0028 _Dunscale 0070 _Dint 007a _Dscale"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 88 B0 8D ED 06 0B 9D ED 06 0B 8D ED 04 0B 0B 9B 00 2B 00 DC 8B E0 0B 9B 01 2B 0D D0 04 A9 68 46 ?? ?? ?? ?? AD F8 04 00 BD F9 04 30 AD F8 02 30 BD F9 02 30 00 2B 05 D1 0A 9B 9D ED 04 0B 83 ED 00 0B 74 E0 BD F9 02 30 00 2B 0B DD 0A 9B 9D ED 04 0B 83 ED 00 0B 0A 9B 08 33 9F ED 39 0B 83 ED 00 0B 64 E0 1A 21 04 A8 ?? ?? ?? ?? BD F9 00 10 04 A8 ?? ?? ?? ?? 0A 9B 9D ED 04 0B 83 ED 00 0B 9D ED 06 1B 9D ED 04 0B 31 EE 40 0B 0A 9B 08 33 83 ED 00 0B 0B 9B 02 2B 40 DD 0A 9B 08 33 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 37 D0 0A 9B 08 33 93 ED 00 0B 8D ED 06 0B 0A 9B 03 F1 08 01 68 46 ?? ?? ?? ?? 1A 21 0A 9B 03 F1 08 00 ?? ?? ?? ?? BD F9 00 10 0A 9B 03 F1 08 00 ?? ?? ?? ?? 0A 9B 08 33 9D ED 06 1B 93 ED 00 0B 31 EE 40 0B 0A 9B 10 33 83 ED 00 0B 0B 9B 03 2B 0E DD 0A 9B 10 33 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 05 D0 0A 9B 18 33 9F ED 0B 0B 83 ED 00 0B 08 E0 0B 9B 02 2B 05 DD 0A 9B 10 33 9F ED 06 0B 83 ED 00 0B 0A 9B 02 93 02 98 08 B0 5D F8 04 BB 5D F8 0C FB FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_27_10_1 {
	meta:
		name = "_LXp_sqrtx"
		size = 328
		refs = "0014 _LDtest 0046 _Feraise 00a0 sqrtl 00b8 _LXp_setw 00d6 _LXp_movx 00e2 _LXp_mulh 00f2 _LXp_mulx 010e _LXp_addh 0144 _LNan"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8C B0 0F 9B 00 2B 00 D1 90 E0 0E 98 ?? ?? ?? ?? AD F8 08 00 BD F9 08 30 00 2B 07 DA 0E 9B 93 ED 00 0B B5 EE C0 0B F1 EE 10 FA 11 D2 0E 9B 93 ED 00 0B B5 EE C0 0B F1 EE 10 FA 08 D2 01 20 ?? ?? ?? ?? 0E 9A 3D 4B 93 ED 00 0B 82 ED 00 0B 6D E0 10 9B 03 93 0F 9A 08 23 02 FB 03 F2 10 9B 13 44 04 93 0F 9A 08 23 02 FB 03 F2 04 9B 13 44 05 93 0E 9B 93 ED 00 0B 8D ED 08 0B 0F 9B 01 2B 09 DD 0E 9B 08 33 9D ED 08 1B 93 ED 00 0B 31 EE 00 0B 8D ED 08 0B 9D ED 08 0B ?? ?? ?? ?? 8D ED 0A 0B B7 EE 00 1B 9D ED 0A 0B 81 EE 00 0B 0F 99 04 98 ?? ?? ?? ?? 02 23 06 93 02 E0 06 9B 5B 00 06 93 06 9A 0F 9B 9A 42 29 DA 04 9A 0F 99 03 98 ?? ?? ?? ?? BE EE 00 0B 0F 99 03 98 ?? ?? ?? ?? 05 9B 00 93 0F 9B 0E 9A 0F 99 03 98 ?? ?? ?? ?? 05 9B 00 93 0F 9B 04 9A 0F 99 03 98 ?? ?? ?? ?? B7 EE 08 0B 0F 99 03 98 ?? ?? ?? ?? 05 9B 00 93 0F 9B 03 9A 0F 99 04 98 ?? ?? ?? ?? CE E7 05 9B 00 93 0F 9B 04 9A 0F 99 0E 98 ?? ?? ?? ?? 0E 9B 07 93 07 98 0C B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_11_1 {
	meta:
		name = "_LXp_subx"
		size = 102
		refs = "0050 _LXp_addh"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 00 23 00 93 02 E0 00 9B 5B 1C 00 93 00 9A 07 9B 9A 42 1B DA 00 9A 08 23 02 FB 03 F2 06 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 0E D0 00 9A 08 23 02 FB 03 F2 06 9B 13 44 93 ED 00 0B B1 EE 40 0B 05 99 04 98 ?? ?? ?? ?? DC E7 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_119_11_1 {
	meta:
		name = "_Xp_subx"
		size = 102
		refs = "0050 _Xp_addh"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 00 23 00 93 02 E0 00 9B 5B 1C 00 93 00 9A 07 9B 9A 42 1B DA 00 9A 08 23 02 FB 03 F2 06 9B 13 44 93 ED 00 0B B5 EE 40 0B F1 EE 10 FA 0E D0 00 9A 08 23 02 FB 03 F2 06 9B 13 44 93 ED 00 0B B1 EE 40 0B 05 99 04 98 ?? ?? ?? ?? DC E7 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_27_12_1 {
	meta:
		name = "ldexpl"
		size = 50
		refs = "0014 ldexp"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 8D ED 00 0B 08 98 9D ED 00 0B ?? ?? ?? ?? 8D ED 02 0B 9D ED 02 0B 8D ED 04 0B 9D ED 04 0B 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_1270_1 {
	meta:
		name = "frexpl"
		size = 50
		refs = "0014 frexp"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 8D ED 00 0B 08 98 9D ED 00 0B ?? ?? ?? ?? 8D ED 02 0B 9D ED 02 0B 8D ED 04 0B 9D ED 04 0B 06 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_29_1_1 {
	meta:
		name = "_Mtxinit"
		size = 36
		refs = "0020 __imp_InitializeCriticalSectionEx"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 00 22 4F F4 7A 61 02 98 03 4B 1B 68 98 47 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_3_1 {
	meta:
		name = "??0bad_function_call@std@@QAA@XZ"
		size = 44
		refs = "000c ??0exception@std@@QAA@XZ 0028 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 4A 04 9B 1A 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_7_1 {
	meta:
		name = "??0exception@std@@QAA@XZ"
		size = 48
		refs = "0018 memset 002c ??_7exception@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 07 4B 13 60 08 22 00 21 04 9B 18 1D ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_18_1 {
	meta:
		name = "??0regex_error@std@@QAA@ABV01@@Z"
		size = 60
		refs = "000e ??0runtime_error@std@@QAA@ABV01@@Z 0038 ??_7regex_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 09 4A 04 9B 1A 60 05 9B 03 F1 0C 01 04 9B 03 F1 0C 02 0B 68 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_19_1 {
	meta:
		name = "??0regex_error@std@@QAA@W4error_type@regex_constants@1@@Z"
		size = 64
		refs = "000c ?_Stringify@regex_error@std@@CAPBDW4error_type@regex_constants@2@@Z 0016 ??0runtime_error@std@@QAA@PBD@Z 003c ??_7regex_error@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 98 ?? ?? ?? ?? 00 90 00 99 06 98 ?? ?? ?? ?? 02 90 07 4A 06 9B 1A 60 06 9B 03 F1 0C 02 07 9B 13 60 06 9B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_40_1 {
	meta:
		name = "??_Gregex_error@std@@UAAPAXI@Z"
		size = 48
		refs = "000c ??1regex_error@std@@UAA@XZ 001c ??3@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 03 D0 10 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_31_42_1 {
	meta:
		name = "?_Stringify@regex_error@std@@CAPBDW4error_type@regex_constants@2@@Z"
		size = 212
		refs = "0094 ??_C@_0M@KGKAAGCA@regex_error?$AA@ 0098 ??_C@_0BK@DFJCACNI@regex_error?$CIerror_syntax?$CJ?$AA@ 009c ??_C@_0BJ@CHBLKGNM@regex_error?$CIerror_parse?$CJ?$AA@ 00a0 ??_C@_0JC@HCDLJLGO@regex_error?$CIerror_stack?$CJ?3?5There?5@ 00a4 ??_C@_0HL@NEKOFBJA@regex_error?$CIerror_complexity?$CJ?3?5T@ 00a8 ??_C@_0FK@LCHHHEOA@regex_error?$CIerror_badrepeat?$CJ?3?5On@ 00ac ??_C@_0GP@PICOBCHA@regex_error?$CIerror_space?$CJ?3?5There?5@ 00b0 ??_C@_0HA@ICNJLCMC@regex_error?$CIerror_range?$CJ?3?5The?5ex@ 00b4 ??_C@_0FM@BLDIHIBB@regex_error?$CIerror_badbrace?$CJ?3?5The@ 00b8 ??_C@_0EH@DICJJKLO@regex_error?$CIerror_brace?$CJ?3?5The?5ex@ 00bc ??_C@_0EH@CAGOJGLE@regex_error?$CIerror_paren?$CJ?3?5The?5ex@ 00c0 ??_C@_0EH@LGEANNAL@regex_error?$CIerror_brack?$CJ?3?5The?5ex@ 00c4 ??_C@_0FA@HFMLPGNN@regex_error?$CIerror_backref?$CJ?3?5The?5@ 00c8 ??_C@_0GI@HEGGMMDL@regex_error?$CIerror_escape?$CJ?3?5The?5e@ 00cc ??_C@_0FE@LJMHKIOC@regex_error?$CIerror_ctype?$CJ?3?5The?5ex@ 00d0 ??_C@_0FI@CMNGHIFF@regex_error?$CIerror_collate?$CJ?3?5The?5@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 01 93 01 9B 0E 2B 37 D8 01 9A DF E8 02 F0 08 0B 0E 11 14 17 1A 1D 20 23 26 29 2C 2F 32 32 29 4B 00 93 2B E0 26 4B 00 93 28 E0 24 4B 00 93 25 E0 21 4B 00 93 22 E0 1F 4B 00 93 1F E0 1C 4B 00 93 1C E0 1A 4B 00 93 19 E0 17 4B 00 93 16 E0 15 4B 00 93 13 E0 12 4B 00 93 10 E0 10 4B 00 93 0D E0 0D 4B 00 93 0A E0 0B 4B 00 93 07 E0 08 4B 00 93 04 E0 06 4B 00 93 01 E0 03 4B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_43_1 {
	meta:
		name = "?_Xbad_alloc@std@@YAXXZ"
		size = 28
		refs = "000a ??0bad_alloc@std@@QAA@XZ 0012 _CxxThrowException 0018 _TI2?AVbad_alloc@std@@"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 68 46 ?? ?? ?? ?? 02 49 68 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_44_1 {
	meta:
		name = "?_Xbad_function_call@std@@YAXXZ"
		size = 28
		refs = "000a ??0bad_function_call@std@@QAA@XZ 0012 _CxxThrowException 0018 _TI2?AVbad_function_call@std@@"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 68 46 ?? ?? ?? ?? 02 49 68 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_45_1 {
	meta:
		name = "?_Xinvalid_argument@std@@YAXPBD@Z"
		size = 32
		refs = "000e ??0invalid_argument@std@@QAA@PBD@Z 0016 _CxxThrowException 001c _TI3?AVinvalid_argument@std@@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 ?? ?? ?? ?? 02 49 68 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_46_1 {
	meta:
		name = "?_Xlength_error@std@@YAXPBD@Z"
		size = 32
		refs = "000e ??0length_error@std@@QAA@PBD@Z 0016 _CxxThrowException 001c _TI3?AVlength_error@std@@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 ?? ?? ?? ?? 02 49 68 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_47_1 {
	meta:
		name = "?_Xout_of_range@std@@YAXPBD@Z"
		size = 32
		refs = "000e ??0out_of_range@std@@QAA@PBD@Z 0016 _CxxThrowException 001c _TI3?AVout_of_range@std@@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 ?? ?? ?? ?? 02 49 68 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_48_1 {
	meta:
		name = "?_Xoverflow_error@std@@YAXPBD@Z"
		size = 32
		refs = "000e ??0overflow_error@std@@QAA@PBD@Z 0016 _CxxThrowException 001c _TI3?AVoverflow_error@std@@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 ?? ?? ?? ?? 02 49 68 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_49_1 {
	meta:
		name = "?_Xregex_error@std@@YAXW4error_type@regex_constants@1@@Z"
		size = 32
		refs = "000e ??0regex_error@std@@QAA@W4error_type@regex_constants@1@@Z 0016 _CxxThrowException 001c _TI3?AVregex_error@std@@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 ?? ?? ?? ?? 02 49 68 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_50_1 {
	meta:
		name = "?_Xruntime_error@std@@YAXPBD@Z"
		size = 32
		refs = "000e ??0runtime_error@std@@QAA@PBD@Z 0016 _CxxThrowException 001c _TI2?AVruntime_error@std@@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 99 68 46 ?? ?? ?? ?? 02 49 68 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_9_1 {
	meta:
		name = "??$end@$$CBU_Sys_errtab_t@std@@$0EO@@std@@YAPBU_Sys_errtab_t@0@AAY0EO@$$CBU10@@Z"
		size = 30
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 03 F5 1C 73 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_32_10_1 {
	meta:
		name = "??$end@$$CBU_Win_errtab_t@std@@$0EK@@std@@YAPBU_Win_errtab_t@0@AAY0EK@$$CBU10@@Z"
		size = 30
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 03 F5 14 73 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_32_16_1 {
	meta:
		name = "??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@I_W@Z"
		size = 66
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAA@XZ 0024 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAX_NI@Z 002e ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 78 60 00 22 00 21 38 6A ?? ?? ?? ?? 3A 8D 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB }
	condition:
		$1
}

rule file_55_212_1 {
	meta:
		name = "??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA@IG@Z"
		size = 66
		refs = "0018 ??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAA@XZ 0024 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAX_NI@Z 002e ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z"
	strings:
		$1 = { 0F B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 6F F0 01 03 C7 E9 02 33 38 6A ?? ?? ?? ?? 78 60 00 22 00 21 38 6A ?? ?? ?? ?? 3A 8D 79 6A 38 6A ?? ?? ?? ?? 3B 6A 3B 60 38 68 05 B0 BD E8 80 08 5D F8 14 FB }
	condition:
		$1
}

rule file_32_25_1 {
	meta:
		name = "??A?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAA_WI@Z"
		size = 44
		refs = "000c ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAPA_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 05 9A 02 23 02 FB 03 F2 00 9B 13 44 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_387_1 {
	meta:
		name = "??A?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAGI@Z"
		size = 44
		refs = "000c ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAPAGXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 05 9A 02 23 02 FB 03 F2 00 9B 13 44 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_388_1 {
	meta:
		name = "??A?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAABGI@Z"
		size = 44
		refs = "000c ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QBAPBGXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 05 9A 02 23 02 FB 03 F2 00 9B 13 44 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_55_390_1 {
	meta:
		name = "??A?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAAB_WI@Z"
		size = 44
		refs = "000c ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QBAPB_WXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 00 90 05 9A 02 23 02 FB 03 F2 00 9B 13 44 01 93 01 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_32_28_1 {
	meta:
		name = "?_Chassign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXII_W@Z"
		size = 84
		refs = "0012 ?_Myptr@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAAPA_WXZ 0026 ?assign@?$char_traits@_W@std@@SAXAA_WAB_W@Z 0046 ?assign@?$char_traits@_W@std@@SAPA_WPA_WI_W@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9B 01 2B 0D D1 04 98 ?? ?? ?? ?? 00 90 07 A9 05 9A 02 23 02 FB 03 F2 00 9B 98 18 ?? ?? ?? ?? 0E E0 04 98 ?? ?? ?? ?? 01 90 BD F8 1C 20 06 99 05 98 02 23 00 FB 03 F0 01 9B 18 44 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_55_501_1 {
	meta:
		name = "?_Chassign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXIIG@Z"
		size = 84
		refs = "0012 ?_Myptr@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAAPAGXZ 0026 ?assign@?$char_traits@G@std@@SAXAAGABG@Z 0046 ?assign@?$char_traits@G@std@@SAPAGPAGIG@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 06 9B 01 2B 0D D1 04 98 ?? ?? ?? ?? 00 90 07 A9 05 9A 02 23 02 FB 03 F2 00 9B 98 18 ?? ?? ?? ?? 0E E0 04 98 ?? ?? ?? ?? 01 90 BD F8 1C 20 06 99 05 98 02 23 00 FB 03 F0 01 9B 18 44 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_32_45_1 {
	meta:
		name = "?_Syserror_map@std@@YAPBDH@Z"
		size = 84
		refs = "0018 ??$end@$$CBU_Sys_errtab_t@std@@$0EO@@std@@YAPBU_Sys_errtab_t@0@AAY0EO@$$CBU10@@Z 004c ??_C@_0O@BFJCFAAK@unknown?5error?$AA@ 0050 ?_Sys_errtab@std@@3QBU_Sys_errtab_t@1@B"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 11 4B 00 93 02 E0 00 9B 08 33 00 93 0E 48 ?? ?? ?? ?? 02 90 00 9A 02 9B 9A 42 0A D0 00 9B 1A 68 06 9B 9A 42 04 D1 00 9B 1B 1D 1B 68 01 93 02 E0 E9 E7 03 4B 01 93 01 98 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_47_1 {
	meta:
		name = "?_Winerror_map@std@@YAHH@Z"
		size = 80
		refs = "0018 ??$end@$$CBU_Win_errtab_t@std@@$0EK@@std@@YAPBU_Win_errtab_t@0@AAY0EK@$$CBU10@@Z 004c ?_Win_errtab@std@@3QBU_Win_errtab_t@1@B"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 10 4B 00 93 02 E0 00 9B 08 33 00 93 0D 48 ?? ?? ?? ?? 02 90 00 9A 02 9B 9A 42 0A D0 00 9B 1A 68 06 9B 9A 42 04 D1 00 9B 1B 1D 1B 68 01 93 02 E0 E9 E7 00 23 01 93 01 98 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_48_1 {
	meta:
		name = "?_Winerror_message@std@@YAKKPADK@Z"
		size = 224
		refs = "000a __security_push_cookie 0024 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@I_W@Z 0030 ??A?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAA_WI@Z 0062 ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA@XZ 00cc __security_pop_cookie 00d8 __imp_WideCharToMultiByte 00dc __imp_FormatMessageW"
	strings:
		$1 = { 0F B4 2D E9 90 48 0D F1 08 0B ?? ?? ?? ?? 93 B0 6F 46 84 B0 6F F0 01 03 C7 E9 0A 33 00 22 B9 6E 17 F1 30 00 ?? ?? ?? ?? 78 62 00 21 17 F1 30 00 ?? ?? ?? ?? B8 60 00 23 02 93 BB 6E 01 93 BB 68 00 93 00 23 3A 6E 00 21 4F F4 90 50 23 4C 24 68 A0 47 F8 60 FB 68 00 2B 08 D1 00 23 3B 61 17 F1 30 00 ?? ?? ?? ?? 3B 69 3B 60 2D E0 00 21 17 F1 30 00 ?? ?? ?? ?? 78 61 00 23 03 93 00 23 02 93 BB 6E 01 93 7B 6E 00 93 6F F0 00 03 7A 69 00 21 00 20 11 4C 24 68 A0 47 B8 61 BB 69 7B 60 7B 68 00 2B 08 D1 00 23 FB 61 17 F1 30 00 ?? ?? ?? ?? FB 69 3B 60 08 E0 7B 68 5B 1E 3B 62 17 F1 30 00 ?? ?? ?? ?? 3B 6A 3B 60 38 68 17 B0 ?? ?? ?? ?? BD E8 90 08 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_53_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAAAV12@I_W@Z"
		size = 92
		refs = "0016 ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBAXXZ 0020 ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAA_NI_N@Z 003a ?_Chassign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXII_W@Z 0042 ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAAXI@Z 0058 ?npos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@2IB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 9A 12 4B 1B 68 9A 42 02 D1 04 98 ?? ?? ?? ?? 00 22 05 99 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0A D0 BD F8 18 30 05 9A 00 21 04 98 ?? ?? ?? ?? 05 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_913_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAAAV12@IG@Z"
		size = 92
		refs = "0016 ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBAXXZ 0020 ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAA_NI_N@Z 003a ?_Chassign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXIIG@Z 0042 ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAAXI@Z 0058 ?npos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@2IB"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 9A 12 4B 1B 68 9A 42 02 D1 04 98 ?? ?? ?? ?? 00 22 05 99 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 0A D0 BD F8 18 30 05 9A 00 21 04 98 ?? ?? ?? ?? 05 99 04 98 ?? ?? ?? ?? 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_54_1 {
	meta:
		name = "?assign@?$char_traits@_W@std@@SAPA_WPA_WI_W@Z"
		size = 40
		refs = "0012 wmemset"
		altNames = "?assign@?$char_traits@G@std@@SAPAGPAGIG@Z"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 9A BD F8 18 10 04 98 ?? ?? ?? ?? 00 90 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_32_64_1 {
	meta:
		name = "wmemset"
		size = 60
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 04 9B 00 93 05 E0 00 9B 9B 1C 00 93 06 9B 5B 1E 06 93 06 9B 00 2B 04 D9 BD F8 14 20 00 9B 1A 80 F1 E7 04 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_33_0_1 {
	meta:
		name = "_Dint"
		size = 552
		refs = "0220 ?sub@?3??_Dint@@9@9 0224 ?mask@?3??_Dint@@9@9"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 08 9B 01 93 01 9B 9B 1D 1A 88 47 F6 F0 73 13 40 1B 11 1B B2 AD F8 00 30 BD F9 00 20 40 F2 FF 73 9A 42 1F D1 01 9B 9B 1D 1B 88 03 F0 0F 03 00 2B 10 D1 01 9B 1B 1D 1B 88 00 2B 0B D1 01 9B 9B 1C 1B 88 00 2B 06 D1 01 9B 1B 88 00 2B 02 D1 01 23 04 93 01 E0 02 23 04 93 04 9B 1B B2 AD F8 08 30 D2 E0 18 E0 01 9B 9B 1D 1B 88 23 F4 00 43 00 2B 11 D1 01 9B 1B 1D 1B 88 00 2B 0C D1 01 9B 9B 1C 1B 88 00 2B 07 D1 01 9B 1B 88 00 2B 03 D1 00 23 AD F8 08 30 B8 E0 BD F9 00 20 40 F2 33 43 9A 1A BD F9 24 30 D3 1A 1B B2 AD F8 00 30 BD F9 00 30 00 2B 04 DC 00 23 AD F8 08 30 A5 E0 A4 E0 BD F9 00 30 35 2B 19 DB 01 9B 9B 1D 1B 88 03 F4 00 41 01 9B 9A 1D 8B B2 13 80 01 9B 1A 1D 00 23 13 80 01 9B 9A 1C 00 23 13 80 01 9A 00 23 13 80 6F F0 00 03 AD F8 08 30 87 E0 86 E0 BD F9 00 30 03 F0 0F 02 02 23 02 FB 03 F2 44 4B 13 44 1B 88 AD F8 02 30 BD F9 00 30 1B 11 1B B2 AD F8 00 30 01 99 BD F9 00 20 04 23 02 FB 03 F2 3A 4B 13 44 1A 68 02 23 02 FB 03 F3 0B 44 1A 88 BD F8 02 30 13 40 9B B2 AD F8 02 30 01 99 BD F9 00 20 04 23 02 FB 03 F2 30 4B 13 44 1A 68 02 23 02 FB 03 F3 0B 44 BD F8 02 20 1B 88 83 EA 02 01 BD F9 00 20 04 23 02 FB 03 F2 28 4B 13 44 1A 68 02 23 02 FB 03 F2 01 9B 1A 44 8B B2 13 80 BD F9 00 30 03 93 03 9B 01 2B 20 D0 03 9B 02 2B 10 D0 03 9B 03 2B 00 D0 24 E0 01 9B 1B 1D 1A 88 BD F8 02 30 13 43 9B B2 AD F8 02 30 01 9B 1A 1D 00 23 13 80 01 9B 9B 1C 1A 88 BD F8 02 30 13 43 9B B2 AD F8 02 30 01 9B 9A 1C 00 23 13 80 01 9B 1A 88 BD F8 02 30 13 43 9B B2 AD F8 02 30 01 9A 00 23 13 80 BD F8 02 30 00 2B 03 D0 6F F0 00 03 05 93 01 E0 00 23 05 93 05 9B 1B B2 AD F8 08 30 BD F9 08 00 06 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_0_1 {
	meta:
		name = "_Lock_shared_ptr_spin_lock"
		size = 52
		refs = "0030 _Shared_ptr_flag"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 09 48 01 21 50 E8 00 2F 40 E8 00 13 00 2B F9 D1 13 46 00 93 BF F3 5B 8F 00 9B 00 2B 01 D0 10 BF EE E7 02 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_1_1 {
	meta:
		name = "_Unlock_shared_ptr_spin_lock"
		size = 24
		refs = "0014 _Shared_ptr_flag"
	strings:
		$1 = { 2D E9 00 48 EB 46 BF F3 5B 8F 02 4A 00 23 13 60 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_0_1 {
	meta:
		name = "??0?$_Yarn@D@std@@QAA@PBD@Z"
		size = 48
		refs = "001c ??4?$_Yarn@D@std@@QAAAAV01@PBD@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9A 00 23 13 60 04 9B 1A 1D 00 23 13 70 05 99 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_35_3_1 {
	meta:
		name = "??0_Locimp@locale@std@@AAA@ABV012@@Z"
		size = 152
		refs = "001a ??0facet@locale@std@@IAA@I@Z 0066 ?c_str@?$_Yarn@D@std@@QBAPBDXZ 0074 ??0?$_Yarn@D@std@@QAA@PBD@Z 007e ?_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z 0094 ??_7_Locimp@locale@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 01 21 B8 6A ?? ?? ?? ?? B8 60 1C 4A BB 6A 1A 60 BB 6A 03 F1 08 02 00 23 13 60 FB 6A 03 F1 0C 01 BB 6A 03 F1 0C 02 0B 68 13 60 FB 6A 03 F1 10 01 BB 6A 03 F1 10 02 0B 68 13 60 FB 6A 03 F1 14 01 BB 6A 03 F1 14 02 0B 78 13 70 FB 6A 03 F1 18 00 ?? ?? ?? ?? 38 60 39 68 BB 6A 03 F1 18 00 ?? ?? ?? ?? F8 60 F9 6A B8 6A ?? ?? ?? ?? BB 6A 7B 60 78 68 07 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_6_1 {
	meta:
		name = "??0_Locimp@locale@std@@AAA@_N@Z"
		size = 120
		refs = "001a ??0facet@locale@std@@IAA@I@Z 0058 ??0?$_Yarn@D@std@@QAA@PBD@Z 0070 ??_C@_01NBENCBCI@?$CK?$AA@ 0074 ??_7_Locimp@locale@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 01 21 B8 6A ?? ?? ?? ?? 78 60 14 4A BB 6A 1A 60 BB 6A 03 F1 08 02 00 23 13 60 BB 6A 03 F1 0C 02 00 23 13 60 BB 6A 03 F1 10 02 00 23 13 60 BB 6A 03 F1 14 02 97 F8 2C 30 13 70 07 49 BB 6A 03 F1 18 00 ?? ?? ?? ?? B8 60 BB 6A 3B 60 38 68 07 B0 BD E8 80 08 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_11_1 {
	meta:
		name = "??0locale@std@@AAA@PAV_Locimp@01@@Z"
		size = 34
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1A 1D 05 9B 13 60 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_35_14_1 {
	meta:
		name = "??1_Fac_node@std@@QAA@XZ"
		size = 118
		refs = "002c _guard_check_icall"
	strings:
		$1 = { 03 B4 2D E9 B0 48 0D F1 0C 0B 8B B0 6F 46 6F F0 01 03 C7 E9 08 33 3B 6C 1B 1D 1A 68 3B 6C 1B 1D 1C 68 13 68 08 33 1B 68 7B 60 78 68 ?? ?? ?? ?? 7B 68 20 46 98 47 F8 60 FB 68 3B 61 3B 69 3B 60 3B 68 00 2B 10 D0 01 25 3B 68 1B 68 3C 68 1B 68 BB 60 B8 68 ?? ?? ?? ?? BB 68 20 46 29 46 98 47 78 61 7B 69 BB 61 01 E0 00 23 BB 61 0B B0 BD E8 B0 08 5D F8 0C FB }
	condition:
		$1
}

rule file_35_15_1 {
	meta:
		name = "??1_Fac_tidy_reg_t@std@@QAA@XZ"
		size = 84
		refs = "0032 ??_G_Fac_node@std@@QAAPAXI@Z 0050 ?_Fac_head@std@@3PAU_Fac_node@1@A"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 11 4B 1B 68 00 2B 18 D0 0F 4B 1B 68 00 93 00 9B 1A 68 0C 4B 1A 60 00 9B 02 93 02 9B 01 93 01 9B 00 2B 07 D0 01 21 01 98 ?? ?? ?? ?? 03 90 03 9B 04 93 01 E0 00 23 04 93 E2 E7 06 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_17_1 {
	meta:
		name = "??1_Locimp@locale@std@@MAA@XZ"
		size = 64
		refs = "001e ?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z 0028 ??1?$_Yarn@D@std@@QAA@XZ 002e ??1facet@locale@std@@MAA@XZ 003c ??_7_Locimp@locale@std@@6B@"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 83 B0 6F 46 6F F0 01 03 C7 E9 00 33 09 4A BB 69 1A 60 B8 69 ?? ?? ?? ?? BB 69 03 F1 18 00 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 03 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_23_1 {
	meta:
		name = "??2_Fac_node@std@@SAPAXI@Z"
		size = 76
		refs = "0022 _malloc_dbg 0032 ?_Xbad_alloc@std@@YAXXZ 0048 ??_C@_0CM@OKINAFCK@f?3?2dd?2vctools?2crt?2crtw32?2stdcpp?2@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 00 2B 02 D9 06 9B 00 93 01 E0 01 23 00 93 22 23 0A 4A 02 21 00 98 ?? ?? ?? ?? 02 90 02 9B 01 93 01 9B 00 2B 01 D1 ?? ?? ?? ?? 01 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_26_1 {
	meta:
		name = "??3_Fac_node@std@@SAXPAX@Z"
		size = 24
		refs = "000c _free_dbg"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 21 02 98 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_35_27_1 {
	meta:
		name = "??4?$_Yarn@D@std@@QAAAAV01@PBD@Z"
		size = 132
		refs = "0016 ?_Tidy@?$_Yarn@D@std@@AAAXXZ 004e _malloc_dbg 006a memcpy 0080 ??_C@_0CJ@JJAOBJEO@f?3?2dd?2vctools?2crt?2crtw32?2stdhpp?2@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 9B 1A 68 07 9B 9A 42 2C D0 06 98 ?? ?? ?? ?? 07 9B 00 2B 26 D0 07 9B 00 93 00 9B 93 F9 00 30 00 2B 03 D0 00 9B 5B 1C 00 93 F6 E7 00 9B 5B 1C 00 93 00 9A 07 9B D3 1A 01 93 40 F6 AB 63 0D 4A 02 21 01 98 ?? ?? ?? ?? 02 90 06 9A 02 9B 13 60 06 9B 1B 68 00 2B 05 D0 01 9A 07 99 06 9B 18 68 ?? ?? ?? ?? 06 9B 03 93 03 98 04 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_30_1 {
	meta:
		name = "??_G_Locimp@locale@std@@MAAPAXI@Z"
		size = 64
		refs = "000c ??1_Locimp@locale@std@@MAA@XZ 0022 ??3_Crt_new_delete@std@@SAXPAX@Z 002c ?__global_delete@@YAXPAXI@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 ?? ?? ?? ?? 05 9B 13 F0 01 0F 0B D0 05 9B 13 F0 04 0F 03 D1 04 98 ?? ?? ?? ?? 03 E0 20 21 04 98 ?? ?? ?? ?? 04 9B 00 93 00 98 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_35_38_1 {
	meta:
		name = "??__Eclassic_locale@std@@YAXXZ"
		size = 32
		refs = "000a ??0locale@std@@QAA@W4_Uninitialized@1@@Z 0010 atexit 0018 ??__Fclassic_locale@std@@YAXXZ 001c ?classic_locale@std@@3Vlocale@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 04 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_46_1 {
	meta:
		name = "?_Empty@?$_Yarn@D@std@@QBA_NXZ"
		size = 50
		altNames = "?_Empty@?$_Yarn@_W@std@@QBA_NXZ"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 68 00 2B 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B DB B2 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_35_47_1 {
	meta:
		name = "?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z"
		size = 88
		refs = "0018 ??2_Fac_node@std@@SAPAXI@Z 0030 ??0_Fac_node@std@@QAA@PAU01@PAV_Facet_base@1@@Z 0054 ?_Fac_head@std@@3PAU_Fac_node@1@A"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 08 20 ?? ?? ?? ?? B8 60 BB 68 3B 60 3B 68 00 2B 09 D0 3A 6B 0A 4B 19 68 38 68 ?? ?? ?? ?? F8 60 FB 68 7B 60 01 E0 00 23 7B 60 7B 68 3B 61 3A 69 03 4B 1A 60 09 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_53_1 {
	meta:
		name = "?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ"
		size = 28
		refs = "0018 global_locale"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 03 4B 1B 68 00 93 00 98 02 B0 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_56_1 {
	meta:
		name = "?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
		size = 244
		refs = "0020 ??0_Lockit@std@@QAA@H@Z 0026 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0038 ?_New_Locimp@_Locimp@locale@std@@CAPAV123@_N@Z 0044 ?_Setgloballocale@locale@std@@CAXPAX@Z 005a ??4?$_Yarn@D@std@@QAAAAV01@PBD@Z 0076 _guard_check_icall 0084 ??2@YAPAXIPAX@Z 009a ??0locale@std@@AAA@PAV_Locimp@01@@Z 00d2 ??1_Lockit@std@@QAA@XZ 00e8 ?_Clocptr@_Locimp@locale@std@@0PAV123@A 00ec ?classic_locale@std@@3Vlocale@1@A 00f0 ??_C@_01GFHCPBMG@C?$AA@"
	strings:
		$1 = { 03 B4 2D E9 90 48 0D F1 08 0B 90 B0 6F 46 6F F0 01 03 C7 E9 0E 33 00 23 3B 60 00 21 17 F1 24 00 ?? ?? ?? ?? F8 62 ?? ?? ?? ?? 78 61 7B 69 3B 60 3B 68 00 2B 3B D1 00 20 ?? ?? ?? ?? B8 61 BB 69 3B 60 38 68 ?? ?? ?? ?? 3B 68 03 F1 10 02 3F 23 13 60 27 49 3B 68 03 F1 18 00 ?? ?? ?? ?? 3A 68 21 4B 1A 60 20 4B 1B 68 1B 68 1A 1D 1E 4B 1C 68 13 68 7B 60 78 68 ?? ?? ?? ?? 7B 68 20 46 98 47 1A 49 08 20 ?? ?? ?? ?? F8 61 FB 69 BB 60 BB 68 00 2B 08 D0 14 4B 19 68 B8 68 ?? ?? ?? ?? 38 62 3B 6A FB 60 01 E0 00 23 FB 60 FB 68 3B 63 97 F8 50 30 00 2B 0B D0 3B 68 1B 68 1B 1D 3C 68 1B 68 3B 61 38 69 ?? ?? ?? ?? 3B 69 20 46 98 47 17 F1 24 00 ?? ?? ?? ?? 3B 68 BB 62 B8 6A 10 B0 BD E8 90 08 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_60_1 {
	meta:
		name = "?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z"
		size = 220
		refs = "001c ??0_Lockit@std@@QAA@H@Z 007e _guard_check_icall 00c6 free 00ce ??1_Lockit@std@@QAA@XZ"
	strings:
		$1 = { 03 B4 2D E9 B0 48 0D F1 0C 0B 8D B0 6F 46 6F F0 01 03 C7 E9 0A 33 00 21 17 F1 20 00 ?? ?? ?? ?? 78 62 BB 6C 0C 33 1B 68 3B 60 3B 68 00 2B 47 D9 3B 68 5B 1E 3B 60 3A 68 04 23 02 FB 03 F2 BB 6C 08 33 1B 68 13 44 1B 68 00 2B 38 D0 BB 6C 03 F1 08 01 3A 68 04 23 02 FB 03 F2 0B 68 13 44 18 68 BB 6C 03 F1 08 01 3A 68 04 23 02 FB 03 F2 0B 68 13 44 1C 68 03 68 08 33 1B 68 BB 60 B8 68 ?? ?? ?? ?? BB 68 20 46 98 47 38 61 3B 69 7B 61 7B 69 7B 60 7B 68 00 2B 10 D0 01 25 7B 68 1B 68 7C 68 1B 68 FB 60 F8 68 ?? ?? ?? ?? FB 68 20 46 29 46 98 47 B8 61 BB 69 FB 61 01 E0 00 23 FB 61 B4 E7 BB 6C 08 33 18 68 ?? ?? ?? ?? 17 F1 20 00 ?? ?? ?? ?? 0D B0 BD E8 B0 08 5D F8 0C FB }
	condition:
		$1
}

rule file_35_62_1 {
	meta:
		name = "?_Locinfo_ctor@_Locinfo@std@@SAXPAV12@PBD@Z"
		size = 120
		refs = "000e setlocale 0030 ??4?$_Yarn@D@std@@QAAAAV01@PBD@Z 0070 ??_C@_01NBENCBCI@?$CK?$AA@ 0074 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 00 21 00 20 ?? ?? ?? ?? 03 90 03 9B 00 93 00 9B 00 2B 02 D1 15 4B 01 93 01 E0 00 9B 01 93 01 99 08 9B 03 F1 24 00 ?? ?? ?? ?? 09 9B 00 2B 06 D0 09 99 00 20 ?? ?? ?? ?? 04 90 04 9B 09 93 09 9B 00 2B 02 D1 08 4B 02 93 01 E0 09 9B 02 93 02 99 08 9B 03 F1 2C 00 ?? ?? ?? ?? 06 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_63_1 {
	meta:
		name = "?_Locinfo_dtor@_Locinfo@std@@SAXPAV12@@Z"
		size = 62
		refs = "0010 ?_Empty@?$_Yarn@D@std@@QBA_NXZ 0026 ?_C_str@?$_Yarn@D@std@@QBAPBDXZ 0030 setlocale"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 03 F1 24 00 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 09 D1 04 9B 03 F1 24 00 ?? ?? ?? ?? 01 90 01 99 00 20 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_35_64_1 {
	meta:
		name = "?_New_Locimp@_Locimp@locale@std@@CAPAV123@ABV123@@Z"
		size = 80
		refs = "0018 ??2_Crt_new_delete@std@@SAPAXI@Z 002c ??0_Locimp@locale@std@@AAA@ABV012@@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 20 20 ?? ?? ?? ?? B8 60 BB 68 3B 60 3B 68 00 2B 07 D0 39 6B 38 68 ?? ?? ?? ?? F8 60 FB 68 7B 60 01 E0 00 23 7B 60 7B 68 3B 61 3B 69 7B 61 78 69 09 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_35_66_1 {
	meta:
		name = "?_New_Locimp@_Locimp@locale@std@@CAPAV123@_N@Z"
		size = 82
		refs = "0018 ??2_Crt_new_delete@std@@SAPAXI@Z 002e ??0_Locimp@locale@std@@AAA@_N@Z"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 89 B0 6F 46 6F F0 01 03 C7 E9 06 33 20 20 ?? ?? ?? ?? B8 60 BB 68 3B 60 3B 68 00 2B 08 D0 97 F8 30 10 38 68 ?? ?? ?? ?? F8 60 FB 68 7B 60 01 E0 00 23 7B 60 7B 68 3B 61 3B 69 7B 61 78 69 09 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_35_68_1 {
	meta:
		name = "?_Setgloballocale@locale@std@@CAXPAX@Z"
		size = 56
		refs = "0018 ?_Atexit@@YAXP6AXXZ@Z 002c global_locale 0030 tidy_global 0034 ?registered@?1??_Setgloballocale@locale@std@@CAXPAX@Z@4_NA"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 0A 4B 1B 78 00 2B 05 D1 08 4A 01 23 13 70 06 48 ?? ?? ?? ?? 02 9A 03 4B 1A 60 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_73_1 {
	meta:
		name = "?classic@locale@std@@SAABV12@XZ"
		size = 32
		refs = "000a ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 001c ?classic_locale@std@@3Vlocale@1@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 00 20 ?? ?? ?? ?? 03 4B 00 93 00 98 02 B0 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_74_1 {
	meta:
		name = "?empty@locale@std@@SA?AV12@XZ"
		size = 62
		refs = "0010 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0016 ?_New_Locimp@_Locimp@locale@std@@CAPAV123@_N@Z 0020 ??0locale@std@@AAA@PAV_Locimp@01@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 00 23 00 93 00 20 ?? ?? ?? ?? 01 20 ?? ?? ?? ?? 01 90 01 99 06 98 ?? ?? ?? ?? 03 90 00 9B 43 F0 01 03 00 93 06 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_35_75_1 {
	meta:
		name = "_Deletegloballocale"
		size = 112
		refs = "0026 _guard_check_icall"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 88 B0 0C 9B 1B 68 00 93 00 9B 00 2B 26 D0 00 9B 1B 68 08 33 00 9C 1B 68 02 93 02 98 ?? ?? ?? ?? 02 9B 20 46 98 47 04 90 04 9B 05 93 05 9B 01 93 01 9B 00 2B 10 D0 01 25 01 9B 1B 68 01 9C 1B 68 03 93 03 98 ?? ?? ?? ?? 03 9B 20 46 29 46 98 47 06 90 06 9B 07 93 01 E0 00 23 07 93 08 B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_35_76_1 {
	meta:
		name = "tidy_global"
		size = 44
		refs = "000c ??0_Lockit@std@@QAA@H@Z 0012 _Deletegloballocale 001e ??1_Lockit@std@@QAA@XZ 0028 global_locale"
	strings:
		$1 = { 2D E9 00 48 EB 46 82 B0 00 21 68 46 ?? ?? ?? ?? 05 48 ?? ?? ?? ?? 04 4A 00 23 13 60 68 46 ?? ?? ?? ?? 02 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_0_1 {
	meta:
		name = "_FSinh"
		size = 600
		refs = "0012 _FDtest 01c2 _FExp 0210 _Feraise 024c _FXbig 0250 p 0254 _FRteps"
	strings:
		$1 = { 2D E9 00 48 EB 46 8C B0 CD ED 03 0A 8D ED 02 0A 02 A8 ?? ?? ?? ?? AD F8 02 00 BD F9 02 30 05 93 05 9B 00 2B 31 D0 05 9B 01 2B 08 D0 05 9B 02 2B 00 D0 33 E0 9D ED 02 0A 8D ED 04 0A 01 E1 9D ED 03 0A B5 EE 40 0A F1 EE 10 FA 04 D0 9D ED 02 0A 8D ED 08 0A 14 E0 02 AB 9B 1C 1B 88 13 F4 00 4F 06 D0 9D ED 03 0A B1 EE 40 0A 8D ED 07 0A 03 E0 9D ED 03 0A 8D ED 07 0A 9D ED 07 0A 8D ED 08 0A 9D ED 08 0A 8D ED 04 0A DB E0 DD ED 02 0A 9D ED 03 0A 20 EE 80 0A 8D ED 04 0A D2 E0 9D ED 03 0A B5 EE 40 0A F1 EE 10 FA 16 D1 9D ED 02 0A B5 EE C0 0A F1 EE 10 FA 06 D2 9D ED 03 0A B1 EE 40 0A 8D ED 09 0A 03 E0 9D ED 03 0A 8D ED 09 0A 9D ED 09 0A 8D ED 04 0A B4 E0 9D ED 02 0A B5 EE C0 0A F1 EE 10 FA 09 D2 9D ED 02 0A B1 EE 40 0A 8D ED 02 0A 01 23 AD F8 00 30 02 E0 00 23 AD F8 00 30 DD ED 02 0A 53 4B 93 ED 00 0A F4 EE C0 0A F1 EE 10 FA 08 D2 DD ED 02 0A 9D ED 03 0A 20 EE 80 0A 8D ED 02 0A 7A E0 DD ED 02 0A B7 EE 00 0A F4 EE C0 0A F1 EE 10 FA 35 D2 DD ED 02 0A 9D ED 02 0A 20 EE 80 0A 8D ED 06 0A 41 4B D3 ED 00 0A 9D ED 06 0A 60 EE 80 0A 3E 4B 1B 1D 93 ED 00 0A 70 EE 80 0A 9D ED 06 0A 60 EE 80 0A 39 4B 08 33 93 ED 00 0A 70 EE 80 0A 9D ED 06 0A 60 EE 80 0A 9D ED 02 0A 60 EE 80 0A 9D ED 02 0A 30 EE 20 0A 8D ED 02 0A DD ED 02 0A 9D ED 03 0A 20 EE 80 0A 8D ED 02 0A 3B E0 DD ED 02 0A 28 4B 93 ED 00 0A F4 EE C0 0A F1 EE 10 FA 17 D2 6F F0 00 01 B7 EE 00 0A 02 A8 ?? ?? ?? ?? F5 EE 00 0A 9D ED 02 0A C0 EE 80 0A 9D ED 02 0A 70 EE 60 0A 9D ED 03 0A 20 EE 20 0A 8D ED 02 0A 19 E0 6F F0 00 01 9D ED 03 0A 02 A8 ?? ?? ?? ?? AD F8 04 00 BD F9 04 30 0A 93 0A 9B 00 2B 03 D0 0A 9B 01 2B 04 D0 06 E0 10 20 ?? ?? ?? ?? 02 E0 08 20 ?? ?? ?? ?? BD F9 00 30 00 2B 06 D0 9D ED 02 0A B1 EE 40 0A 8D ED 0B 0A 03 E0 9D ED 02 0A 8D ED 0B 0A 9D ED 0B 0A 8D ED 04 0A 9D ED 04 0A 0C B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_0_1 {
	meta:
		name = "??1_Init_atexit@@QAA@XZ"
		size = 116
		refs = "0054 _guard_check_icall 0068 __imp_DecodePointer 006c ?atcount_cdecl@@3IA 0070 ?atfuns_cdecl@@3PAP6AXXZA"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 87 B0 6F 46 6F F0 01 03 C7 E9 04 33 15 4B 1B 68 0A 2B 1F D2 13 4B 1A 68 04 23 02 FB 03 F2 11 4B 13 44 1B 68 BB 60 0E 4B 1B 68 5A 1C 0D 4B 1A 60 B8 68 0A 4B 1B 68 98 47 F8 60 FB 68 3B 60 3B 68 00 2B 06 D0 3B 68 7B 60 78 68 ?? ?? ?? ?? 7B 68 98 47 DB E7 07 B0 BD E8 80 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_5_1 {
	meta:
		name = "?_Atexit@@YAXP6AXXZ@Z"
		size = 84
		refs = "0012 abort 0048 ?atfuns_cdecl@@3PAP6AXXZA 004c ?atcount_cdecl@@3IA 0050 __imp_EncodePointer"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 10 4B 1B 68 00 2B 02 D1 ?? ?? ?? ?? 12 E0 04 98 0D 4B 1B 68 98 47 00 90 0A 4B 1B 68 5A 1E 08 4B 1A 60 07 4B 1A 68 04 23 02 FB 03 F2 04 4B 1A 44 00 9B 13 60 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_0_1 {
	meta:
		name = "_Sinh"
		size = 576
		refs = "0012 _Dtest 0150 _Poly 01a8 _Exp 01f6 _Feraise 0234 _Xbig 0238 p 023c _Rteps"
	strings:
		$1 = { 2D E9 00 48 EB 46 96 B0 8D ED 06 1B 8D ED 04 0B 04 A8 ?? ?? ?? ?? AD F8 02 00 BD F9 02 30 02 93 02 9B 00 2B 31 D0 02 9B 01 2B 08 D0 02 9B 02 2B 00 D0 33 E0 9D ED 04 0B 8D ED 08 0B F4 E0 9D ED 06 0B B5 EE 40 0B F1 EE 10 FA 04 D0 9D ED 04 0B 8D ED 0C 0B 14 E0 04 AB 9B 1D 1B 88 13 F4 00 4F 06 D0 9D ED 06 0B B1 EE 40 0B 8D ED 0A 0B 03 E0 9D ED 06 0B 8D ED 0A 0B 9D ED 0A 0B 8D ED 0C 0B 9D ED 0C 0B 8D ED 08 0B CE E0 9D ED 04 1B 9D ED 06 0B 21 EE 00 0B 8D ED 08 0B C5 E0 9D ED 06 0B B5 EE 40 0B F1 EE 10 FA 16 D1 9D ED 04 0B B5 EE C0 0B F1 EE 10 FA 06 D2 9D ED 06 0B B1 EE 40 0B 8D ED 0E 0B 03 E0 9D ED 06 0B 8D ED 0E 0B 9D ED 0E 0B 8D ED 08 0B A7 E0 9D ED 04 0B B5 EE C0 0B F1 EE 10 FA 09 D2 9D ED 04 0B B1 EE 40 0B 8D ED 04 0B 01 23 AD F8 00 30 02 E0 00 23 AD F8 00 30 9D ED 04 1B 4D 4B 93 ED 00 0B B4 EE C0 1B F1 EE 10 FA 08 D2 9D ED 04 1B 9D ED 06 0B 21 EE 00 0B 8D ED 04 0B 6D E0 9D ED 04 1B B7 EE 00 0B B4 EE C0 1B F1 EE 10 FA 28 D2 9D ED 04 1B 9D ED 04 0B 21 EE 00 0B 8D ED 10 0B 05 21 3B 48 9D ED 10 0B ?? ?? ?? ?? 8D ED 14 0B 9D ED 04 1B 9D ED 10 0B 21 EE 00 1B 9D ED 14 0B 21 EE 00 1B 9D ED 04 0B 30 EE 01 0B 8D ED 04 0B 9D ED 04 1B 9D ED 06 0B 21 EE 00 0B 8D ED 04 0B 3B E0 9D ED 04 1B 29 4B 93 ED 00 0B B4 EE C0 1B F1 EE 10 FA 17 D2 6F F0 00 01 B7 EE 00 0B 04 A8 ?? ?? ?? ?? B5 EE 00 1B 9D ED 04 0B 81 EE 00 1B 9D ED 04 0B 30 EE 41 1B 9D ED 06 0B 20 EE 01 0B 8D ED 04 0B 19 E0 6F F0 00 01 9D ED 06 0B 04 A8 ?? ?? ?? ?? AD F8 04 00 BD F9 04 30 03 93 03 9B 00 2B 03 D0 03 9B 01 2B 04 D0 06 E0 10 20 ?? ?? ?? ?? 02 E0 08 20 ?? ?? ?? ?? BD F9 00 30 00 2B 06 D0 9D ED 04 0B B1 EE 40 0B 8D ED 12 0B 03 E0 9D ED 04 0B 8D ED 12 0B 9D ED 12 0B 8D ED 08 0B 9D ED 08 0B 16 B0 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_0_1 {
	meta:
		name = "?_Mtx_delete@threads@stdext@@YAXPAX@Z"
		size = 44
		refs = "001a ??3@YAXPAXI@Z 0028 __imp_DeleteCriticalSection"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 98 06 4B 1B 68 98 47 04 9B 00 93 18 21 00 98 ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_2_1 {
	meta:
		name = "?_Mtx_new@threads@stdext@@YAXAAPAX@Z"
		size = 60
		refs = "000c ??2@YAPAXI@Z 0038 __imp_InitializeCriticalSectionEx"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 18 20 ?? ?? ?? ?? 00 90 00 9B 01 93 01 9A 04 9B 1A 60 00 22 4F F4 7A 61 04 9B 18 68 04 4B 1B 68 98 47 02 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_0_1 {
	meta:
		name = "_Getctype"
		size = 164
		refs = "000c ___lc_codepage_func 0024 _calloc_dbg 0034 __pctype_func 0046 memcpy 005e ___lc_locale_name_func 007a _wcsdup_dbg 00a0 ??_C@_0CL@MMDMFNC@f?3?2dd?2vctools?2crt?2crtw32?2stdcpp?2@"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 92 B0 ?? ?? ?? ?? 02 90 02 9B 0A 93 8C 23 00 93 21 4B 02 22 02 21 4F F4 80 70 ?? ?? ?? ?? 03 90 03 9B 0B 93 0B 9B 00 2B 0D D0 ?? ?? ?? ?? 04 90 0B 9B 05 93 04 99 05 98 4F F4 00 72 ?? ?? ?? ?? 01 23 0C 93 06 E0 ?? ?? ?? ?? 06 90 06 9B 0B 93 00 23 0C 93 ?? ?? ?? ?? 07 90 07 9B 1B 1D 1B 68 0D 93 0D 9B 00 2B 08 D0 99 23 0A 4A 02 21 0D 98 ?? ?? ?? ?? 08 90 08 9B 0D 93 16 9D 0A AC 94 E8 0F 00 85 E8 0F 00 16 9B 0E 93 0E 98 12 B0 BD E8 30 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_1_1 {
	meta:
		name = "_Tolower"
		size = 428
		refs = "0010 ___lc_locale_name_func 001e ___lc_codepage_func 0066 isupper 00a0 __pctype_func 0116 __report_rangecheckfailure 016a __crtLCMapStringA"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 94 B0 17 9B 00 2B 0C D1 ?? ?? ?? ?? 0E 90 0E 9B 08 33 1B 68 08 93 ?? ?? ?? ?? 0F 90 0F 9B 0D 93 06 E0 17 9B 0C 33 1B 68 08 93 17 9B 1B 68 0D 93 08 9B 00 2B 0B D1 16 9B 41 2B 05 DB 16 9B 5A 2B 02 DC 16 9B 20 33 16 93 16 9B 06 93 A4 E0 16 9B B3 F5 80 7F 1D D2 17 9B 00 2B 0A D1 16 98 ?? ?? ?? ?? 10 90 10 9B 00 2B 02 D1 16 9B 06 93 93 E0 0F E0 17 9B 19 1D 16 9A 02 23 02 FB 03 F2 0B 68 13 44 B3 F9 00 30 13 F0 01 0F 02 D1 16 9B 06 93 82 E0 17 9B 00 2B 10 D1 ?? ?? ?? ?? 11 90 16 9B 1B 12 DB B2 DA B2 02 23 02 FB 03 F2 11 9B 13 44 1B 88 03 F4 00 43 0A 93 15 E0 17 9B 19 1D 16 9B 1B 12 DA B2 02 23 02 FB 03 F2 0B 68 13 44 B3 F9 00 30 13 F4 00 4F 02 D0 01 23 09 93 01 E0 00 23 09 93 09 9B 0A 93 0A 9B 00 2B 1A D0 16 9B 1B 12 DB B2 04 AA DB B2 13 70 16 9B DA B2 04 AB 5B 1C 1A 70 02 23 0B 93 0B 9B 03 2B 00 D2 01 E0 ?? ?? ?? ?? 04 AA 0B 9B 1A 44 00 23 13 70 02 23 07 93 12 E0 16 9B DA B2 04 AB 1A 70 01 23 0C 93 0C 9B 03 2B 00 D2 01 E0 ?? ?? ?? ?? 04 AA 0C 9B 1A 44 00 23 13 70 01 23 07 93 01 23 03 93 0D 9B 02 93 03 23 01 93 05 AB 00 93 07 9B 04 AA 4F F4 80 71 08 98 ?? ?? ?? ?? 12 90 12 9B 07 93 07 9B 00 2B 02 D1 16 9B 06 93 0F E0 07 9B 01 2B 04 D1 05 AB 1B 78 06 93 08 E0 07 E0 05 AB 5B 1C 1A 78 05 AB 1B 78 1B 02 13 43 06 93 06 98 14 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_43_0_1 {
	meta:
		name = "?_Random_device@std@@YAIXZ"
		size = 44
		refs = "000a rand_s 0018 ?_Xout_of_range@std@@YAXPBD@Z 0028 ??_C@_0BM@EEBBMCOD@invalid?5random_device?5value?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 84 B0 01 A8 ?? ?? ?? ?? 00 90 00 9B 00 2B 02 D0 04 48 ?? ?? ?? ?? 01 9B 02 93 02 98 04 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_0_1 {
	meta:
		name = "_Thrd_abort"
		size = 56
		refs = "000c __acrt_iob_func 0016 fputs 0026 fputc 002a abort"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 02 20 ?? ?? ?? ?? 00 90 00 99 04 98 ?? ?? ?? ?? 02 20 ?? ?? ?? ?? 01 90 01 99 0A 20 ?? ?? ?? ?? ?? ?? ?? ?? 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_44_1_1 {
	meta:
		name = "_Thrd_create"
		size = 132
		refs = "0010 _Cnd_init 0018 _Mtx_init 0032 _Mtx_lock 003c _Thrd_start 0056 _Cnd_wait 005e _Mtx_unlock 0064 _Cnd_destroy 006a _Mtx_destroy 0080 run"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8C B0 00 23 02 93 01 A8 ?? ?? ?? ?? 01 21 68 46 ?? ?? ?? ?? 0F 9B 06 93 10 9B 07 93 01 AB 08 93 6B 46 09 93 02 AB 0A 93 00 98 ?? ?? ?? ?? 06 AA 11 49 0E 98 ?? ?? ?? ?? 04 90 04 9B 03 93 03 9B 00 2B 07 D1 02 9B 00 2B 04 D1 00 99 01 98 ?? ?? ?? ?? F7 E7 00 98 ?? ?? ?? ?? 01 98 ?? ?? ?? ?? 00 98 ?? ?? ?? ?? 03 9B 05 93 05 98 0C B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_2_1 {
	meta:
		name = "_Thrd_current"
		size = 144
		refs = "0066 memcpy 007c __imp_GetCurrentThreadId 0080 __imp_CloseHandle 0084 __imp_DuplicateHandle 0088 __imp_GetCurrentProcess 008c __imp_GetCurrentThread"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 8F B0 1E 4B 1B 68 98 47 04 90 1D 4B 1B 68 98 47 05 90 1A 4B 1B 68 98 47 06 90 00 23 02 93 01 23 01 93 02 23 00 93 0A AB 04 9A 05 99 06 98 12 4C 24 68 A0 47 07 90 07 9B 00 2B 04 D0 0A 98 0D 4B 1B 68 98 47 01 E0 00 23 0A 93 09 4B 1B 68 98 47 08 90 08 9B 0B 93 12 98 0A A9 08 22 ?? ?? ?? ?? 12 9B 0C 93 0C 98 0F B0 BD E8 10 08 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_3_1 {
	meta:
		name = "_Thrd_detach"
		size = 56
		refs = "0034 __imp_CloseHandle"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 06 98 09 4B 1B 68 98 47 01 90 01 9B 00 2B 02 D1 04 23 00 93 01 E0 00 23 00 93 00 9B 02 93 02 98 04 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_4_1 {
	meta:
		name = "_Thrd_equal"
		size = 44
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 82 B0 05 9A 07 9B 9A 42 02 D1 01 23 00 93 01 E0 00 23 00 93 00 9B 01 93 01 98 02 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_44_6_1 {
	meta:
		name = "_Thrd_hardware_concurrency"
		size = 32
		refs = "001c __imp_GetNativeSystemInfo"
	strings:
		$1 = { 2D E9 00 48 EB 46 8C B0 02 A8 04 4B 1B 68 98 47 07 9B 00 93 00 98 0C B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_8_1 {
	meta:
		name = "_Thrd_join"
		size = 124
		refs = "0070 __imp_CloseHandle 0074 __imp_GetExitCodeThread 0078 __imp_WaitForSingleObjectEx"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 00 22 6F F0 00 01 08 98 19 4B 1B 68 98 47 02 90 02 9B B3 F1 FF 3F 08 D0 04 A9 08 98 13 4B 1B 68 98 47 03 90 03 9B 00 2B 02 D1 04 23 01 93 14 E0 0A 9B 00 2B 02 D0 04 9A 0A 9B 1A 60 08 98 09 4B 1B 68 98 47 05 90 05 9B 00 2B 02 D1 04 23 00 93 01 E0 00 23 00 93 00 9B 01 93 01 98 06 B0 5D F8 04 BB 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_9_1 {
	meta:
		name = "_Thrd_sleep"
		size = 176
		refs = "0008 __security_push_cookie 0012 xtime_get 001a _Xtime_diff_to_millis2 00a0 __security_pop_cookie 00ac __imp_Sleep"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 ?? ?? ?? ?? 95 B0 01 21 10 A8 ?? ?? ?? ?? 10 A9 18 98 ?? ?? ?? ?? 02 90 02 98 22 4B 1B 68 98 47 01 21 10 A8 ?? ?? ?? ?? 18 9A 10 9B 08 93 11 9B 09 93 00 92 00 9B 1B 68 0A 93 00 9B 5B 68 0B 93 08 9B 03 93 0A 9B 04 93 09 9A 0B 9B 9A 42 DE DB 03 DC 03 9A 04 9B 9A 42 D9 D3 18 9A 10 9B 0C 93 11 9B 0D 93 01 92 01 9B 1B 68 0E 93 01 9B 5B 68 0F 93 0D 9B 05 93 0F 9B 06 93 0C 9A 0E 9B 9A 42 09 D1 05 9A 06 9B 9A 42 05 D1 18 9B 08 33 12 9A 1B 68 9A 42 BB DB 15 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_10_1 {
	meta:
		name = "_Thrd_start"
		size = 72
		refs = "001c _beginthreadex"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 86 B0 08 9B 1B 1D 01 93 00 23 00 93 0A 9B 09 9A 00 21 00 20 ?? ?? ?? ?? 02 90 08 9A 02 9B 13 60 02 9B 00 2B 02 D1 04 23 03 93 01 E0 00 23 03 93 03 9B 04 93 04 98 06 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_44_11_1 {
	meta:
		name = "_Thrd_yield"
		size = 24
		refs = "0014 __imp_Sleep"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 02 4B 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_12_1 {
	meta:
		name = "run"
		size = 126
		refs = "0038 _Mtx_lock 0046 _Cnd_signal 004e _Mtx_unlock 005a _guard_check_icall 006a _Cnd_do_broadcast_at_thread_exit"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 8C B0 10 9B 06 AA 00 92 01 93 00 9D 01 9C 94 E8 0F 00 85 E8 0F 00 01 9B 10 33 01 93 00 9B 10 33 00 93 00 9A 01 9B 1B 68 13 60 09 9B 18 68 ?? ?? ?? ?? 0A 9A 01 23 13 60 08 9B 18 68 ?? ?? ?? ?? 09 9B 18 68 ?? ?? ?? ?? 07 9C 06 9B 02 93 02 98 ?? ?? ?? ?? 02 9B 20 46 98 47 03 90 03 9B 04 93 ?? ?? ?? ?? 04 9B 05 93 05 98 0C B0 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_46_0_1 {
	meta:
		name = "?_Release_chore@details@Concurrency@@YAXPAU_Threadpool_chore@12@@Z"
		size = 64
		refs = "0012 ?is_vista_threadpool_supported@?A0x7ef259da@details@Concurrency@@YA_NXZ 003c __imp_CloseThreadpoolWork"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 04 9B 1B 68 00 2B 0F D0 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 00 2B 04 D0 04 9B 18 68 05 4B 1B 68 98 47 04 9A 00 23 13 60 02 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_1_1 {
	meta:
		name = "?_Reschedule_chore@details@Concurrency@@YAHPBU_Threadpool_chore@12@@Z"
		size = 132
		refs = "000a ?is_vista_threadpool_supported@?A0x7ef259da@details@Concurrency@@YA_NXZ 002a _CrtDbgReportW 0078 __imp_SubmitThreadpoolWork 007c ??_C@_1GM@LHFPEBEE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAc?$AAp?$AAp?$AA?2@ 0080 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 ?? ?? ?? ?? 8D F8 08 00 9D F8 08 30 00 2B 0E D1 00 23 01 93 18 4B 00 93 00 23 3F 22 15 49 02 20 ?? ?? ?? ?? 03 90 03 9B 01 2B 00 D1 FE DE 08 9B 1B 68 00 2B 0E D1 00 23 01 93 0E 4B 00 93 00 23 40 22 0B 49 02 20 ?? ?? ?? ?? 04 90 04 9B 01 2B 00 D1 FE DE 08 9B 18 68 05 4B 1B 68 98 47 00 23 05 93 05 98 06 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_2_1 {
	meta:
		name = "?_Schedule_chore@details@Concurrency@@YAHPAU_Threadpool_chore@12@@Z"
		size = 252
		refs = "0022 _CrtDbgReportW 0058 ?is_vista_threadpool_supported@?A0x7ef259da@details@Concurrency@@YA_NXZ 0086 ?_Reschedule_chore@details@Concurrency@@YAHPBU_Threadpool_chore@12@@Z 00b0 __crtQueueUserWorkItem 00e4 __imp_GetLastError 00e8 ?task_scheduler_callback_xp@?A0x7ef259da@details@Concurrency@@YAKPAX@Z 00ec __imp_CreateThreadpoolWork 00f0 ?task_scheduler_callback@?A0x7ef259da@details@Concurrency@@YAXPAU_TP_CALLBACK_INSTANCE@@PAXPAU_TP_WORK@@@Z 00f4 ??_C@_1GM@LHFPEBEE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAc?$AAp?$AAp?$AA?2@ 00f8 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 8C B0 0E 9B 1B 68 00 2B 0E D0 00 23 01 93 38 4B 00 93 00 23 47 22 35 49 02 20 ?? ?? ?? ?? 04 90 04 9B 01 2B 00 D1 FE DE 0E 9B 1B 1D 1B 68 00 2B 0E D1 00 23 01 93 2E 4B 00 93 00 23 48 22 2B 49 02 20 ?? ?? ?? ?? 05 90 05 9B 01 2B 00 D1 FE DE ?? ?? ?? ?? 8D F8 08 00 9D F8 08 30 00 2B 1D D0 00 22 0E 99 20 48 1F 4B 1B 68 98 47 06 90 0E 9A 06 9B 13 60 0E 9B 1B 68 00 2B 07 D0 0E 98 ?? ?? ?? ?? 07 90 07 9B 03 93 21 E0 06 E0 13 4B 1B 68 98 47 08 90 08 9B 03 93 19 E0 18 E0 0E 9A 0E 9B 13 60 00 22 0E 99 0E 48 ?? ?? ?? ?? 09 90 09 9B 00 2B 0A D1 0E 9A 00 23 13 60 08 4B 1B 68 98 47 0A 90 0A 9B 03 93 02 E0 01 E0 00 23 03 93 03 98 0C B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_4_1 {
	meta:
		name = "?task_scheduler_callback@?A0x7ef259da@details@Concurrency@@YAXPAU_TP_CALLBACK_INSTANCE@@PAXPAU_TP_WORK@@@Z"
		size = 52
		refs = "0020 _guard_check_icall"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B 83 B0 07 9B 00 93 00 9B 08 33 1C 68 00 9B 1B 1D 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 98 47 03 B0 BD E8 10 08 5D F8 14 FB }
	condition:
		$1
}

rule file_46_5_1 {
	meta:
		name = "?task_scheduler_callback_xp@?A0x7ef259da@details@Concurrency@@YAKPAX@Z"
		size = 58
		refs = "0020 _guard_check_icall"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 83 B0 06 9B 00 93 00 9B 08 33 1C 68 00 9B 1B 1D 1B 68 01 93 01 98 ?? ?? ?? ?? 01 9B 20 46 98 47 00 23 02 93 02 98 03 B0 BD E8 10 08 5D F8 0C FB }
	condition:
		$1
}

rule file_47_0_1 {
	meta:
		name = "_Strxfrm"
		size = 214
		refs = "0026 ___lc_locale_name_func 0034 ___lc_collate_cp_func 0068 memcpy 008c __crtLCMapStringA"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 8E B0 11 9A 10 9B D3 1A 08 93 13 9A 12 9B D3 1A 04 93 6F F0 00 03 09 93 14 9B 00 2B 0C D1 ?? ?? ?? ?? 0A 90 0A 9B 1B 1D 1B 68 06 93 ?? ?? ?? ?? 0B 90 0B 9B 05 93 06 E0 14 9B 1B 1D 1B 68 06 93 14 9B 1B 68 05 93 06 9B 00 2B 0E D1 05 9B 00 2B 0B D1 04 9A 08 9B 9A 42 04 D8 04 9A 12 99 10 98 ?? ?? ?? ?? 04 9B 09 93 29 E0 01 23 03 93 05 9B 02 93 00 23 01 93 00 23 00 93 04 9B 12 9A 4F F4 80 61 06 98 ?? ?? ?? ?? 0C 90 0C 9B 07 93 07 9B 00 2B 14 D0 07 9B 09 93 07 9A 08 9B 9A 42 0E DC 01 23 03 93 05 9B 02 93 08 9B 01 93 10 9B 00 93 04 9B 12 9A 4F F4 80 61 06 98 ?? ?? ?? ?? 09 9B 0D 93 0D 98 0E B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_48_0_1 {
	meta:
		name = "_Getcoll"
		size = 88
		refs = "000a ___lc_collate_cp_func 0014 ___lc_locale_name_func 0030 _wcsdup_dbg 0040 memcpy 0054 ??_C@_0CL@JDOPBDBF@f?3?2dd?2vctools?2crt?2crtw32?2stdcpp?2@"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 88 B0 ?? ?? ?? ?? 00 90 00 9B 04 93 ?? ?? ?? ?? 01 90 01 9B 1B 1D 1B 68 05 93 05 9B 00 2B 08 D0 79 23 0A 4A 02 21 05 98 ?? ?? ?? ?? 02 90 02 9B 05 93 0A 98 04 A9 08 22 ?? ?? ?? ?? 0A 9B 06 93 06 98 08 B0 5D F8 04 BB 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_1_1 {
	meta:
		name = "_Strcoll"
		size = 246
		refs = "0024 ___lc_locale_name_func 0032 ___lc_collate_cp_func 006a memcmp 00bc __crtCompareStringA 00cc _errno"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 94 B0 00 23 04 93 17 9A 16 9B D3 1A 06 93 19 9A 18 9B D3 1A 05 93 1A 9B 00 2B 0C D1 ?? ?? ?? ?? 0D 90 0D 9B 1B 1D 1B 68 07 93 ?? ?? ?? ?? 0E 90 0E 9B 0C 93 06 E0 1A 9B 1B 1D 1B 68 07 93 1A 9B 1B 68 0C 93 07 9B 00 2B 29 D1 06 9A 05 9B 9A 42 02 DA 06 9B 08 93 01 E0 05 9B 08 93 08 9A 18 99 16 98 ?? ?? ?? ?? 0F 90 0F 9B 0A 93 0A 9B 00 2B 10 D1 06 9A 05 9B 9A 42 0C D0 06 9A 05 9B 9A 42 03 DA 6F F0 00 03 09 93 01 E0 01 23 09 93 09 9B 0B 93 01 E0 0A 9B 0B 93 0B 9B 04 93 1F E0 0C 9B 02 93 05 9B 01 93 18 9B 00 93 06 9B 16 9A 4F F4 80 51 07 98 ?? ?? ?? ?? 10 90 10 9B 04 93 04 9B 00 2B 09 D1 ?? ?? ?? ?? 11 90 11 9A 16 23 13 60 6F F0 00 43 04 93 02 E0 04 9B 9B 1E 04 93 04 9B 12 93 12 98 14 B0 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_49_0_1 {
	meta:
		name = "_Dunscale"
		size = 228
		refs = "007e _Dnorm"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 84 B0 07 9B 01 93 01 9B 9B 1D 1A 88 47 F6 F0 73 13 40 1B 11 1B B2 AD F8 00 30 BD F9 00 20 40 F2 FF 73 9A 42 22 D1 06 9A 00 23 13 80 01 9B 9B 1D 1B 88 03 F0 0F 03 00 2B 10 D1 01 9B 1B 1D 1B 88 00 2B 0B D1 01 9B 9B 1C 1B 88 00 2B 06 D1 01 9B 1B 88 00 2B 02 D1 01 23 03 93 01 E0 02 23 03 93 03 9B 1B B2 AD F8 08 30 31 E0 30 E0 BD F9 00 30 00 2B 0C DC 01 98 ?? ?? ?? ?? AD F8 02 00 BD F9 02 30 AD F8 00 30 BD F9 00 30 00 2B 19 DC 01 9B 9B 1D 1A 88 6F F3 0E 12 43 F6 E0 73 42 EA 03 01 01 9B 9A 1D 8B B2 13 80 BD F9 00 30 A3 F2 FE 33 1A B2 06 9B 1A 80 6F F0 00 03 AD F8 08 30 06 E0 05 E0 06 9A 00 23 13 80 00 23 AD F8 08 30 BD F9 08 00 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_50_0_1 {
	meta:
		name = "_Stoflt"
		size = 912
		refs = "0008 __security_push_cookie 006c isdigit 00ba localeconv 01d6 __report_rangecheckfailure 01f4 __rt_sdiv 037e __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 ?? ?? ?? ?? A1 B0 00 23 07 93 00 23 01 93 28 9A 09 23 02 FB 03 F3 28 93 28 9B 2D 2B 01 DD 2D 23 28 93 27 9A 00 23 13 60 27 9B 1A 1D 00 23 13 60 00 23 03 93 04 E0 25 9B 5B 1C 25 93 01 23 03 93 25 9B 93 F9 00 30 30 2B 00 D1 F4 E7 00 23 00 93 04 E0 25 9B 5B 1C 25 93 01 23 03 93 25 9B 93 F9 00 30 D8 B2 ?? ?? ?? ?? 0D 90 0D 9B 00 2B 20 D0 00 9A 28 9B 9A 42 0F DA 25 9B 93 F9 00 30 30 3B 59 B2 00 9A 01 23 02 FB 03 F2 14 AB 13 44 19 70 00 9B 5B 1C 00 93 0B E0 27 9B 1B 68 5A 1C 27 9B 1A 60 25 9B 93 F9 00 30 30 2B 01 D0 01 23 07 93 CF E7 ?? ?? ?? ?? 0E 90 25 9B 93 F9 00 20 0E 9B 1B 68 93 F9 00 30 9A 42 02 D1 25 9B 5B 1C 25 93 00 9B 00 2B 10 D1 04 E0 25 9B 5B 1C 25 93 01 23 03 93 25 9B 93 F9 00 30 30 2B 05 D1 27 9B 1B 68 5A 1E 27 9B 1A 60 EF E7 04 E0 25 9B 5B 1C 25 93 01 23 03 93 25 9B 93 F9 00 30 D8 B2 ?? ?? ?? ?? 0F 90 0F 9B 00 2B 20 D0 00 9A 28 9B 9A 42 14 DA 25 9B 93 F9 00 30 30 3B 59 B2 00 9A 01 23 02 FB 03 F2 14 AB 13 44 19 70 00 9B 5B 1C 00 93 27 9B 1B 68 5A 1E 27 9B 1A 60 06 E0 25 9B 93 F9 00 30 30 2B 01 D0 01 23 07 93 CF E7 07 9B 00 2B 12 D0 28 9B 5A 1E 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 30 59 1C 28 9B 5A 1E 01 23 02 FB 03 F2 14 AB 1A 44 4B B2 13 70 02 E0 00 9B 5B 1E 00 93 00 9B 00 2B 10 DD 00 9B 5A 1E 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 30 00 2B 05 D1 27 9B 1B 68 5A 1C 27 9B 1A 60 E8 E7 00 9B 00 2B 0F D1 00 9B 08 93 00 9B 5B 1C 00 93 08 9B 2E 2B 00 D2 01 E0 ?? ?? ?? ?? 14 AA 08 9B 1A 44 00 23 13 70 03 9B 00 2B 00 F0 B2 80 00 23 05 93 00 99 09 20 ?? ?? ?? ?? C1 F1 09 03 06 93 06 99 09 20 ?? ?? ?? ?? 00 29 02 D1 00 23 09 93 01 E0 01 23 09 93 09 9B 01 93 05 E0 06 9B 5B 1C 06 93 05 9B 5B 1C 05 93 05 9A 00 9B 9A 42 33 DA 06 99 09 20 ?? ?? ?? ?? 00 29 12 D1 01 9B 5B 1C 01 93 05 9A 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 10 01 9A 04 23 02 FB 03 F2 27 9B 13 44 19 60 19 E0 01 9A 04 23 02 FB 03 F2 27 9B 13 44 1A 68 0A 23 02 FB 03 F1 05 9A 01 23 02 FB 03 F2 14 AB 13 44 93 F9 00 30 19 44 01 9A 04 23 02 FB 03 F2 27 9B 13 44 19 60 C1 E7 25 9B 93 F9 00 30 65 2B 04 D0 25 9B 93 F9 00 30 45 2B 52 D1 25 9B 11 93 25 9B 5B 1C 25 93 25 9B 93 F9 00 30 2B 2B 07 D0 25 9B 93 F9 00 30 2D 2B 02 D0 2B 23 0A 93 06 E0 25 9B 93 F9 00 30 0A 93 25 9B 5B 1C 25 93 0A 9B 5B B2 8D F8 08 30 00 23 0B 93 00 23 04 93 04 E0 25 9B 5B 1C 25 93 01 23 0B 93 25 9B 93 F9 00 30 D8 B2 ?? ?? ?? ?? 10 90 10 9B 00 2B 0F D0 04 9A 1F 4B 9A 42 0A DA 04 9A 0A 23 02 FB 03 F2 25 9B 93 F9 00 30 DB B2 13 44 30 3B 04 93 E0 E7 9D F9 08 30 2D 2B 02 D1 04 9B 5B 42 04 93 27 9B 1A 68 04 9B 1A 44 27 9B 1A 60 0B 9B 00 2B 01 D1 11 9B 25 93 03 9B 00 2B 01 D1 00 23 01 93 26 9B 00 2B 0A D0 03 9B 00 2B 02 D0 25 9B 0C 93 01 E0 24 9B 0C 93 0C 9A 26 9B 1A 60 01 9B 12 93 12 98 21 B0 ?? ?? ?? ?? 5D F8 04 BB 5D F8 14 FB FE DE 00 E1 F5 05 }
	condition:
		$1
}

rule file_51_5_1 {
	meta:
		name = "??$?8V?$allocator@D@std@@V01@@std@@YA_NABU?$_Wrap_alloc@V?$allocator@D@std@@@0@0@Z"
		size = 44
		refs = "000e ??$?8DD@std@@YA_NABV?$allocator@D@0@0@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 82 B0 05 99 04 98 ?? ?? ?? ?? 8D F8 00 00 9D F8 00 30 8D F8 04 30 9D F8 04 00 02 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_95_9_3 {
	meta:
		name = "??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@