# rclone

> 여러 클라우드 서비스와 파일 및 디렉터리를 복사, 동기화 또는 이동.
> 더 많은 정보: <https://rclone.org/commands/rclone/>.

- rclone 설정을 위한 인터랙티브 메뉴 실행:

`rclone config`

- rclone 원격의 디렉터리 내용 나열:

`rclone lsf {{원격_이름}}:{{경로/대상/폴더}}`

- 로컬 머신에서 원격 대상으로 파일이나 디렉터리 복사:

`rclone copy {{경로/대상/소스_파일_또는_폴더}} {{원격_이름}}:{{경로/대상/폴더}}`

- 지난 24시간 내에 변경된 파일들을 사용자 확인을 거쳐 로컬 머신에서 원격으로 복사:

`rclone copy --interactive --max-age 24h {{원격_이름}}:{{경로/대상/폴더}} {{경로/대상/로컬_폴더}}`

- 특정 파일이나 디렉터리 미러링 (참고: 복사와 달리, 동기화는 로컬에 존재하지 않는 파일을 원격에서 제거):

`rclone sync {{경로/대상/파일_또는_폴더}} {{원격_이름}}:{{경로/대상/폴더}}`

- 원격 파일이나 디렉터리 삭제 (참고: `--dry-run`은 테스트를 의미하며, 실제로 삭제하려면 명령에서 제거):

`rclone --dry-run delete {{원격_이름}}:{{경로/대상/파일_또는_폴더}}`

- rclone 원격 마운트 (실험적):

`rclone mount {{원격_이름}}:{{경로/대상/폴더}} {{경로/대상/마운트_포인트}}`

- `<Ctrl c>` 실패 시 rclone 원격 마운트 해제 (실험적):

`fusermount -u {{경로/대상/마운트_포인트}}`
