# cp

> 複製檔案或整個目錄。
> 更多資訊：<https://www.gnu.org/software/coreutils/manual/html_node/cp-invocation.html>.

- 將檔案複製到另一個位置：

`cp {{檔案一/完整/路徑}} {{檔案二/完整/路徑}}`

- 將檔案複製到另一個目錄下，並保留原本的檔名：

`cp {{檔案/完整/路徑}} {{目錄/完整/路徑}}`

- 以遞迴方式將目錄一的內容複製到目錄二（如果目錄二存在，則目錄一複製為目錄二的子目錄）：

`cp {{[-r|--recursive]}} {{目錄一/完整/路徑}} {{目錄二/完整/路徑}}`

- 以詳細模式遞迴複製目錄（顯示複製的檔案）：

`cp {{[-vr|--verbose --recursive]}} {{目錄一/完整/路徑}} {{目錄二/完整/路徑}}`

- 一次複製多個檔案至目錄下

`cp {{[-t|--target-directory]}} {{目錄/完整/路徑}} {{檔案一/完整/路徑 檔案二/完整/路徑 ...}}`

- 以互動模式將 txt 檔複製到另一個目錄下（在覆寫之前提示使用者）：

`cp {{[-i|--interactive]}} {{*.txt}} {{目錄/完整/路徑}}`

- 複製前遵循符號連結：

`cp {{[-L|--dereference]}} {{符號連結}} {{目錄/完整/路徑}}`

- 使用來源檔案的完整路徑，在複製時同時建立缺少的目錄：

`cp --parents {{來源檔案/完整/路徑}} {{目標檔案/完整/路徑}}`
