# chpass

> 사용자 데이터베이스 정보, 로그인 쉘 및 비밀번호를 추가하거나 변경합니다.
> 같이 보기: `passwd`.
> 더 많은 정보: <https://man.freebsd.org/cgi/man.cgi?chpass>.

- 현재 사용자의 사용자 데이터베이스 정보를 대화식으로 추가하거나 변경:

`su -c chpass`

- 현재 사용자의 로그인 쉘 설정:

`chpass -s {{경로/대상/쉘}}`

- 특정 사용자의 로그인 쉘 설정:

`chpass -s {{경로/대상/쉘}} {{사용자명}}`

- 계정 만료 시간 변경 (에포크로부터 초 단위, UTC):

`su -c 'chpass -e {{시간}} {{사용자명}}'`

- 사용자 비밀번호 변경:

`su -c 'chpass -p {{암호화된_비밀번호}} {{사용자명}}'`

- 조회할 NIS 서버의 호스트명 또는 주소 지정:

`su -c 'chpass -h {{호스트명}} {{사용자명}}'`

- 특정 NIS 도메인 지정 (기본값은 시스템 도메인 이름):

`su -c 'chpass -d {{도메인}} {{사용자명}}'`
